/********************************************************
	Title 	 : MiscPaySubAct[F14FSUN003]
	Date  	 : 17/SEP/14
	Developer: Sagar M.
 ********************************************************/
package ibase.webitm.ejb.fin.adv;

import ibase.webitm.utility.*;
import ibase.webitm.ejb.*;
import ibase.system.config.*;
import ibase.webitm.utility.ITMException;
import ibase.webitm.ejb.ITMDBAccessEJB;
import java.rmi.RemoteException;
import java.sql.*;
import java.text.SimpleDateFormat;
import java.util.*;

import javax.ejb.Stateless; 

@Stateless 

public class MiscPaySubAct extends ActionHandlerEJB implements MiscPaySubActLocal, MiscPaySubActRemote 
{
	/**
	 * The public method is used for update the Workflow status
	 * @param tranId 
	 * @param xtraParams contais additional information such as loginEmpCode,loginCode,chgTerm etc
	 * @param forcedFlag (true or false)
	 */
	String userId = "", termId = "";
	GenericUtility genericUtility = GenericUtility.getInstance();

	@Override
	public String actionHandler(String tranId, String xtraParams, String forcedFlag) throws RemoteException, ITMException
	{
		System.out.println("---ActionHandler---@@@@@@@@xtraParams["+xtraParams+"]@@@@@@forcedFlag["+forcedFlag+"]");
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String retString = "";
		String sql = "";
		String confStatus="",wfStatus="";
		String currAppdate ="";
		String tranIdTest="",todayStr="";
		try
		{
			ConnDriver connDriver = null;
			connDriver = new ConnDriver();
			conn = connDriver.getConnectDB("DriverITM");
			conn.setAutoCommit(false);
			connDriver = null;

			ITMDBAccessEJB itmDBAccessLocal = new ITMDBAccessEJB();
			userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginCode");  
			termId =  genericUtility.getValueFromXTRA_PARAMS(xtraParams, "termId");
			if (userId == null || userId.trim().length() == 0)
			{
				userId = "SYSTEM";
			}
			if (termId == null || termId.trim().length() == 0)
			{
				termId = "SYSTEM";
			}
			
			System.out.println(">>>>>>>>>>tranId:"+tranId);
			sql = "SELECT CONFIRMED,CASE WHEN WF_STATUS IS NULL THEN 'O' ELSE WF_STATUS END AS WF_STATUS FROM MISC_PAYMENT WHERE TRAN_ID= ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, tranId);
			rs = pstmt.executeQuery();
			if ( rs.next() )
			{
				confStatus = rs.getString("CONFIRMED").trim();
				wfStatus = rs.getString("WF_STATUS").trim();
			}
			pstmt.close();
			pstmt = null;					
			rs.close();
			rs = null;
			
			if( "Y".equalsIgnoreCase(confStatus) )
			{
				retString = itmDBAccessLocal.getErrorString("","VTDIST26","");
				return retString;
			}
			if( "S".equalsIgnoreCase(wfStatus) )
			{
				retString = itmDBAccessLocal.getErrorString("","ALRDYSUBMT","");
				return retString;
			}
			if( "N".equalsIgnoreCase(confStatus) && "O".equalsIgnoreCase(wfStatus))
			{
				//SQL for update the work flow status/..........
				sql = "UPDATE MISC_PAYMENT SET WF_STATUS='S' WHERE tran_id = ?";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,tranId);
				int rowcnt = pstmt.executeUpdate();
				pstmt.close();
				pstmt = null;
				if(rowcnt > 0)
				{
					retString = itmDBAccessLocal.getErrorString("","SUBMITSUCC","");
					System.out.println(">>>>>>>>>>>>>>>Before conn.commit()");
					conn.commit();
					//return retString;
				}
			}
		}
		catch(Exception e)
		{
			try
			{
				conn.rollback();
			}
			catch (Exception e1)
			{
			}
			e.printStackTrace();
			System.out.println("Exception ::"+e.getMessage());
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;					
				}		
				if( conn != null && ! conn.isClosed() )
				{
					conn.close();
					conn = null;
				}
			}
			catch(Exception ef)
			{
				System.out.println(ef.getMessage());
				ef.printStackTrace();
				throw new ITMException(ef);
			}
		}
		System.out.println("Returning Result ::"+retString);
		return retString;
	}
	
	private String checkNull( String input )
	{
		if ( input == null )
		{
			input = "";
		}
		return input;
	}
	
}