package ibase.webitm.ejb.fin;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.StringTokenizer;

import org.apache.poi.hssf.record.formula.functions.Int;
import org.apache.poi.hssf.record.formula.functions.Trim;

import ibase.system.config.ConnDriver;
import ibase.webitm.ejb.ActionHandlerEJB;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;

public class PurchaseVoucherGltracePreview extends ActionHandlerEJB implements PurchaseVoucherGltracePreviewLocal,PurchaseVoucherGltracePreviewRemote
{

	
	public String preview(String tranID,String xtraParams, String forcedFlag) throws RemoteException,ITMException
	{ 
		System.out.println("Preview Method is called for Purchase Voucher");
		String retString = "";
	    boolean adj_amt_flag = true,amt_upd_flag = true,retenamt_flag = true,hold_tax_flag = true;
		Connection conn = null;
		String sql = "";
		PreparedStatement pstmt = null,pstmt1 = null,pstmt2 = null;
		ResultSet rs = null,rs1 = null,rs2 = null;
		FinCommon finCommon = null;
		GenericUtility genericUtility = null;
		ITMDBAccessEJB itmDBAccessEJB = null;
		ValidatorEJB validatorEJB = null;
		double netAmt = 0.0,rndTo = 0.0,lc_netwr = 0.0;
		String rndOff = "";
		String errString = "",lineNoDet = "",tranType = "" ;

		//String[] arrayOne;
		String loginEmpCode = "",acctCodeDet ="",	lineno = "",cctrCodeDet = "",deptCodeDet = "",empCodeDet = "",analCodeDet = "",analysis1 = "",analysis2 = "",analysis3 = "",basiccurr = "";
	
		double	taxtranamt = 0.0,	taxamtDet  = 0.0,advAmt = 0.0 ,amount = 0.0,vouchAmt = 0.0;	

		String acct_ap = "",acct_aphdr = "",vouchtype = "",purc_order= "",vouch_adv_amt= "",cctrcode = "",tran_id = "", proj_code = "";
		String cctr_ap = "",cctr_aphdr = "",refno_det = "",retention_days = "",retdays = "",suppcode = "";
		String refser_det = "",finentity = "",sitecode = "",sundrycode = "", empcode = "",currcode = "",remarks = "";
		double  amtupd = 0.0,retenamt = 0.0,advadj_det = 0.0,net_amt = 0.0,tax_amt = 0.0,retention_amt = 0.0,rndamt = 0.0,holdTax = 0.0,diffamtexch=0.0,exch_h = 0.0;
		double retentiondays = 0.0,retentionamt = 0.0,exch_d = 0.0,adjamt = 0.0;
		double adv_add = 0.0,hold_tax = 0.0, exchratevch= 0.0 , billamt = 0.0 ,taxamt = 0.0;
		String acctcodeadv ="",cctrcodeadv = "",currcodeadv = "", ref_id = "",refser = "",refNo = "",analcode = "";
		String acctreten ="",cctrreten = "",acct_code__cf = "",cctr_code__cf = "",tranMode = "",detcurrcode = "",projCodeDet = "",projCodeDet1 = "";
		HashMap hdrmap = new HashMap();
		HashMap map1 = new HashMap();
		Date effDate = null;
		Date tranDate = null;
		Date refDate = null;
	
		System.out.println("tran id = "+tranID);
		boolean connStatus=false;
		try{
			if ( conn == null )//changed by Gulzar - 25/11/11
			{
				ConnDriver connDriver = null;
				connDriver = new ConnDriver();
				conn = connDriver.getConnectDB("DriverITM");
				conn.setAutoCommit(false);
				connDriver = null;
				connStatus = true;
			}
			
			finCommon = new FinCommon();
			genericUtility = new GenericUtility();
			itmDBAccessEJB = new ITMDBAccessEJB();
			validatorEJB = new ValidatorEJB();
			loginEmpCode = validatorEJB.getValueFromXTRA_PARAMS(xtraParams, "loginEmpCode");
			System.out.println("Printing loginEmpCode---1-----"+loginEmpCode+"--");
			
	//Header coding ********************************************************************************************
			
			sql = "select  tran_id,tran_type,tran_date,(case when retention_amt is null then 0 else retention_amt end) as retention_amt,(case when retention_days is null then 0 else retention_days end) as retention_days," 
	              +"eff_date,fin_entity,site_code,supp_code,acct_code,cctr_code,emp_code,curr_code,exch_rate,"
					+"remarks,proj_code,anal_code,rnd_amt,vouch_type,tran_mode,acct_code__cf,cctr_code__cf,net_amt,purc_order,bill_amt,tax_amt,adv_amt,rnd_off,rnd_to from voucher where tran_id = ?";
				
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,tranID);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					
					tran_id = rs.getString("tran_id");
					tranType = checkNull(rs.getString("tran_type"));
					tranDate = new Timestamp(rs.getDate("tran_Date").getTime());
					effDate = new Timestamp(rs.getDate("eff_date").getTime());
					finentity = rs.getString("fin_entity");
					sitecode = rs.getString("site_code");
					sundrycode = rs.getString("supp_code");
				    empcode = rs.getString("emp_code");
					currcode = rs.getString("curr_code");
					remarks = rs.getString("remarks");
					analcode = rs.getString("anal_code");
					ref_id = rs.getString("tran_id");
					suppcode  = rs.getString("supp_code");
					acct_aphdr = rs.getString("acct_code");
					cctr_aphdr = rs.getString("cctr_code")==null?"":rs.getString("cctr_code");
					proj_code = rs.getString("proj_code");
					exch_h = rs.getDouble("exch_rate");
					rndamt = rs.getDouble("rnd_amt");
					vouchtype = rs.getString("vouch_type");
					acct_code__cf = rs.getString("acct_code__cf");
					cctr_code__cf = rs.getString("cctr_code__cf");
					billamt = rs.getDouble("bill_amt");
					taxamt = rs.getDouble("tax_amt");
					tranMode = rs.getString("tran_mode");
					advAmt = rs.getDouble("adv_amt");
					
					netAmt = rs.getDouble("net_amt");
					rndOff = rs.getString("rnd_off");
					rndTo = rs.getDouble("rnd_to");
					
					System.out.println("VOUCHER TYPE>>>>>>>>>>>>>>>>>"+vouchtype);
					if("A".equalsIgnoreCase(vouchtype))
					{
						System.out.println("VOUCHER TYPE>>>>>>>>>>>>>>>>>"+vouchtype);
						amtupd = rs.getDouble("net_amt");
						net_amt = rs.getDouble("net_amt");
						purc_order = rs.getString("purc_order");
						
						System.out.println("AMTUPD..........................."+amtupd);
						sql = "select case when vouch_adv_amt is null then 0 else vouch_adv_amt end as vouch_adv_amt from porder where purc_order = ?";
						pstmt2 = conn.prepareStatement(sql);
						pstmt2.setString(1,purc_order);
						rs2 = pstmt2.executeQuery();
						if(rs2.next())
						{
						vouch_adv_amt = rs2.getString("vouch_adv_amt");
						}
						rs2.close();
						rs2=null;
						pstmt2.close();
						pstmt2=null;
						
						//not written code for updating porder
						
						retenamt = 0.0;//retension amount is set 0 if voucher type is advance
					}
					else{
						System.out.println("VOUCHER TYPE>>>>>>>>>>>>>>>>>"+vouchtype);
						sql = "select (case when sum(tax_amt) is null then 0 else sum(tax_amt) end)  as hold_tax from taxtran where tran_code = 'VOUCH' and tran_id = ?  and pay_tax = 'Y'";
						
						pstmt1 = conn.prepareStatement(sql);
						pstmt1.setString(1,tranID);
						rs1 = pstmt1.executeQuery();
						if(rs1.next())
						{
							holdTax = rs1.getDouble("hold_tax");
						}
						rs1.close();
						rs1=null;
						pstmt1.close();
						pstmt1=null;
						
						amtupd = billamt + taxamt - holdTax;
						retentionamt = rs.getDouble("retention_amt");
						retentiondays = rs.getDouble("retention_days");
						
						amtupd = amtupd - retentionamt;
					}// end of vch_type = A condition
				}	
				rs.close();
				rs=null;
				pstmt.close();
				pstmt=null;
				
					
					
					//retriving data from vouchadv 
					sql="select adj_amt,exch_rate__vouch,curr_code,acct_code,cctr_code,ref_ser,ref_no from vouchadv where tran_id = ? ";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1,tranID);
					rs = pstmt.executeQuery();
					while(rs.next())
					{
						adjamt = rs.getDouble("adj_amt");
						exchratevch = rs.getDouble("exch_rate__vouch");
						currcodeadv = rs.getString("curr_code");
						acctcodeadv = rs.getString("acct_code");
						cctrcodeadv = rs.getString("cctr_code");
						refser = rs.getString("ref_ser");
						refNo = rs.getString("ref_no");
					}
					rs.close();
					rs=null;
					pstmt.close();
					pstmt=null;
					
					if(acct_aphdr == acctcodeadv && cctr_aphdr == cctrcodeadv && exch_h == exchratevch){
						
					}
					else{
						//hdrmap = new HashMap();
						adv_add = adv_add + adjamt; 
						hdrmap.put("tran_date",tranDate);
						hdrmap.put("eff_date", effDate);
						hdrmap.put("fin_entity",finentity);
						hdrmap.put("site_code",sitecode);
						hdrmap.put("sundry_type",'S');
						hdrmap.put("sundry_code",sundrycode);
						hdrmap.put("acct_code",acctcodeadv);
						hdrmap.put("cctr_code",cctrcodeadv);
						hdrmap.put("emp_code",empcode);
						hdrmap.put("anal_code","");
						hdrmap.put("curr_code", currcodeadv);
						hdrmap.put("exch_rate",exchratevch);
						
					
						if(adjamt > 0.0)
						{
						hdrmap.put("dr_amt", adjamt);
						hdrmap.put("cr_amt",0.0);
						System.out.println("adjamt>>>>>>>"+adjamt);
					
					    }

					else{
						hdrmap.put("dr_amt", 0.0);
						hdrmap.put("cr_amt",0- adjamt);
						System.out.println("adjamt>>>>>>>"+adjamt);
					    }
					
						hdrmap.put("ref_type","F");
						hdrmap.put("ref_ser","VOUCH");
						hdrmap.put("ref_id",ref_id);
						hdrmap.put("remarks",remarks);
						hdrmap.put("proj_code",proj_code);
						String party_doc_ref = finCommon.gfGetPartyDocRef("VOUCH",ref_id,conn);
						hdrmap.put("party_doc_ref",party_doc_ref);
						
						System.out.println("calling Gltrace Update for Header adj_amt*******************");
						errString = finCommon.glTraceUpdate(hdrmap,conn,true); 
						System.out.println("ERROR STRING>>>>>>>>>>>>>>>>>>>>>>["+errString+"]");
						if(errString != null && errString.trim().length() > 0)
						{
							return errString;
						}
						
				      }
			
					//hdrmap = new HashMap();
				         	amtupd = amtupd + adjamt;
							System.out.println("AMT_UPD>>>>>>>> >>>>"+amtupd);
							hdrmap.put("tran_date",tranDate);
							hdrmap.put("eff_date", effDate);
							hdrmap.put("fin_entity",finentity);
							hdrmap.put("site_code",sitecode);
							hdrmap.put("sundry_type",'S');
							hdrmap.put("sundry_code",sundrycode);
							hdrmap.put("acct_code",acct_aphdr);//from header
							hdrmap.put("cctr_code",cctr_aphdr);//from header
							hdrmap.put("emp_code",empcode);
							hdrmap.put("anal_code",analcode);
							hdrmap.put("curr_code",currcode );
							hdrmap.put("exch_rate",exch_h);
							
							if(amtupd > 0)
							{
								hdrmap.put("dr_amt",0.0);
								hdrmap.put("cr_amt",amtupd + rndamt);
								System.out.println("amtupd>>>>>>>"+amtupd);
							
							    }

							else{
								hdrmap.put("dr_amt", 0.0 -(amtupd + rndamt) );
								hdrmap.put("cr_amt",0.0);
								System.out.println("amtupd>>>>>>>"+amtupd);
							    }
							hdrmap.put("ref_type","F");
							hdrmap.put("ref_ser","VOUCH");
							hdrmap.put("ref_id",ref_id);
							hdrmap.put("remarks",remarks);
							hdrmap.put("proj_code",proj_code);
			
							String party_doc_ref = finCommon.gfGetPartyDocRef("VOUCH",ref_id,conn);
							hdrmap.put("party_doc_ref",party_doc_ref);
							
							System.out.println("calling Gltrace Update for Header amtupd*******************");
							
							errString = finCommon.glTraceUpdate(hdrmap,conn,true); 
							System.out.println("ERROR STRING>>>>>>>>>>>>>>>>>>>>>>["+errString+"]");
							if(errString != null && errString.trim().length() > 0)
							{
								return errString;
							}
			          //Retention amt
							sql = "select acct_code__reten as acctreten, cctr_code__reten as cctrreten from supplier where supp_code = ?" ;
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1,suppcode);
							rs = pstmt.executeQuery();
							while(rs.next())
							{
								acctreten = rs.getString("acctreten");
								cctrreten = rs.getString("cctrreten");
							}
							rs.close();
							rs=null;
							pstmt.close();
							pstmt=null;
							
							if ( retentionamt != 0.0)
							{
								hdrmap.put("sundry_type",'S');
								hdrmap.put("sundry_code",suppcode);
								hdrmap.put("acct_code",acctreten);
								hdrmap.put("cctr_code",cctrreten);
								
								if(retentionamt > 0.0)
								{
									hdrmap.put("dr_amt",0.0);
									hdrmap.put("cr_amt",retentionamt);
									System.out.println("retentionamt>>>>>>>"+retentionamt);
								
							    }

								else{
									hdrmap.put("dr_amt",0 - retentionamt);
									hdrmap.put("cr_amt",0.0);
									System.out.println("retentionamt>>>>>>>"+retentionamt);
								    }
								
								System.out.println("calling Gltrace Update for Header retentionamt*******************");
								errString = finCommon.glTraceUpdate(hdrmap,conn,true); 
								System.out.println("ERROR STRING>>>>>>>>>>>>>>>>>>>>>>["+errString+"]");
								if(errString != null && errString.trim().length() > 0)
								{
									return errString;
								}
							}
			//Hold Tax
			        if(holdTax != 0.0)
			        {
			        	hdrmap.put("tran_date",tranDate);
						hdrmap.put("eff_date", effDate);
						hdrmap.put("fin_entity",finentity);
						hdrmap.put("site_code",sitecode);
						hdrmap.put("sundry_type",'S');
						hdrmap.put("sundry_code",sundrycode);
						hdrmap.put("acct_code",acct_aphdr);//from header
						hdrmap.put("cctr_code",cctr_aphdr);//from header
						hdrmap.put("emp_code",empcode);
						hdrmap.put("anal_code",analcode);
						hdrmap.put("curr_code",currcode );
						hdrmap.put("exch_rate",exch_h);
						
						if(holdTax  > 0.0)
						{
							hdrmap.put("dr_amt", 0.0);
							hdrmap.put("cr_amt",holdTax);
							System.out.println("holdTax>>>>>>>"+holdTax);
						}
						else{
							
							hdrmap.put("dr_amt",0.0 -  holdTax);
							hdrmap.put("cr_amt",0.0);
							System.out.println("holdTax>>>>>>>"+holdTax);
						}
						
						hdrmap.put("ref_type","F");
						hdrmap.put("ref_ser","VOUCH");
						hdrmap.put("ref_id",ref_id);
						hdrmap.put("remarks",remarks);
						hdrmap.put("proj_code",proj_code);
		
						party_doc_ref = finCommon.gfGetPartyDocRef("VOUCH",ref_id,conn);
						hdrmap.put("party_doc_ref",party_doc_ref);
						System.out.println("calling Gltrace Update for hold tax*******************");
						errString = finCommon.glTraceUpdate(hdrmap,conn,true); 
						System.out.println("ERROR STRING>>>>>>>>>>>>>>>>>>>>>>["+errString+"]");
							if(errString != null && errString.trim().length() > 0)
							{
								return errString;
							}
			        }
			     // update gltrace for currency fluctuation
			        
			        if( diffamtexch != 0.0)
					{
			        	System.out.println("diffamtexch>>>>>>>"+diffamtexch);
						
			        	hdrmap.put("tran_date",tranDate);
						hdrmap.put("eff_date", effDate);
						hdrmap.put("fin_entity",finentity);
						hdrmap.put("site_code",sitecode);
						
						hdrmap.put("sundry_type",'O');
						hdrmap.put("sundry_code","");
						hdrmap.put("acct_code",acct_code__cf);//from header
						hdrmap.put("cctr_code",cctr_code__cf);//from header
						
						if(cctrcode == null || cctrcode.trim().length() == 0)
						{
							cctrcode = "";
						}
						hdrmap.put("emp_code","");
						hdrmap.put("anal_code","");
						hdrmap.put("curr_code",currcode);
						hdrmap.put("exch_rate",1);
						
						if(diffamtexch  > 0.0)
						{
							hdrmap.put("dr_amt", 0.0);
							hdrmap.put("cr_amt",diffamtexch);
							System.out.println("diffamtexch>>>>>>>"+diffamtexch);
						}
						else{
							
							hdrmap.put("dr_amt",0.0 - diffamtexch);
							hdrmap.put("cr_amt",0.0);
							System.out.println("diffamtexch>>>>>>>"+diffamtexch);
						}
						
						hdrmap.put("ref_type","F");
						hdrmap.put("ref_ser","VOUCH");
						hdrmap.put("ref_id",ref_id);
						hdrmap.put("remarks",remarks);
						hdrmap.put("proj_code",proj_code);
		
						party_doc_ref = finCommon.gfGetPartyDocRef("VOUCH",ref_id,conn);
						hdrmap.put("party_doc_ref",party_doc_ref);
						System.out.println("calling Gltrace Update for diff_amt_exch*******************");
					   errString = finCommon.glTraceUpdate(hdrmap,conn,true); 
						System.out.println("ERROR STRING>>>>>>>>>>>>>>>>>>>>>>["+errString+"]");
							if(errString != null && errString.trim().length() > 0)
							{
								return errString;
							}
					}
			
			//Detail Coding*******
			        sql = "select line_no from vouchdet where tran_id = ?";
			        pstmt1 = conn.prepareStatement(sql);
					pstmt1.setString(1,tranID);
					rs1 = pstmt1.executeQuery();
					while(rs1.next())
					{
			        lineNoDet = rs1.getString("line_no");
			        System.out.println("POSTING DETAIL!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"+rs1.getRow());
			        sql = "SELECT finent.curr_code  as basecurr  FROM finent  WHERE finent.fin_entity  = ? " ;
			    	pstmt = conn.prepareStatement(sql);
					pstmt.setString(1,finentity);
					rs = pstmt.executeQuery();
					while(rs.next())
					{
						detcurrcode = rs.getString("basecurr");
					}
					rs.close();
					rs=null;
					pstmt.close();
					pstmt=null;
			        
					 sql = "SELECT proj_code,line_no,tax_amt,acct_code,amount,cctr_code,dept_code,emp_code,anal_code,analysis1,analysis2,analysis3,basic_curr FROM vouchdet  WHERE tran_id = ? and line_no = ? " ;
				    	pstmt = conn.prepareStatement(sql);
						pstmt.setString(1,tranID);
						pstmt.setString(2,lineNoDet);
						rs = pstmt.executeQuery();
						while(rs.next())
						{
							projCodeDet1 = rs.getString("proj_code");
							lineno = rs.getString("line_no");
							taxamtDet = rs.getDouble("tax_amt");
							acctCodeDet = rs.getString("acct_code");
							amount = rs.getDouble("amount");
							cctrCodeDet = rs.getString("cctr_code");
							deptCodeDet = rs.getString("dept_code");
							empCodeDet = rs.getString("emp_code");
							analCodeDet = rs.getString("anal_code");
							analysis1 = rs.getString("analysis1");
							analysis2 = rs.getString("analysis2");
							analysis3 = rs.getString("analysis3");
							basiccurr = rs.getString("basic_curr");
							//vouchAmt = rs.getDouble("vouch_amt");
						}
						rs.close();
						rs=null;
						pstmt.close();
						pstmt=null;
				        
					// for each detail do the posting
				
				if(tranMode == "M")
				{
					projCodeDet = projCodeDet1;
				}
				else{
					projCodeDet = proj_code;
				}
				
				lineno = "    " + lineno;
				lineno = lineno.substring(lineno.length() - 3,lineno.length());
				hdrmap.put("tran_date",tranDate);
				hdrmap.put("eff_date", effDate);
				hdrmap.put("fin_entity",finentity);
				hdrmap.put("site_code",sitecode);
				hdrmap.put("exch_rate",exch_h);
				if(vouchtype == "A" && advAmt != 0.0 &&  acctCodeDet.trim().length() == acct_aphdr.trim().length())
				{
					hdrmap.put("sundry_type",'S');
					hdrmap.put("sundry_code",suppcode);
					sql = "select (case when sum(tax_amt) is null then 0 else sum(tax_amt) end)  as taxtranamt from taxtran where tran_code = 'VOUCH' and tran_id = ? and line_no = ? and pay_tax = 'Y'";
					
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1,tranID);
					pstmt.setString(2,lineno);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						taxtranamt = rs.getDouble("taxtranamt");
					}
					rs.close();
					rs=null;
					pstmt.close();
					pstmt=null;
					if(amount > 0)
					{
						hdrmap.put("dr_amt",(amount - taxtranamt));
						hdrmap.put("cr_amt",0.0);
						System.out.println("amount>>>>>>>"+amount);
					
					    }

					else{
						hdrmap.put("dr_amt", 0.0  );
						hdrmap.put("cr_amt",0.0 - (amount - taxtranamt) );
						System.out.println("amount>>>>>>>"+amount);
					    }
					
				}
				else{
					hdrmap.put("sundry_type",'O');
					hdrmap.put("sundry_code","");
					if(amount > 0)
					{
						hdrmap.put("dr_amt",amount);
						hdrmap.put("cr_amt",0.0);
						System.out.println("amount>>>>>>>"+amount);
					
				    }

					else{
						hdrmap.put("dr_amt", 0.0);
						hdrmap.put("cr_amt",0.0 - amount);
						System.out.println("amount>>>>>>>"+amount);
					    }
					
				}
				
				hdrmap.put("acct_code",acctCodeDet);
				hdrmap.put("cctr_code",cctrCodeDet);
				hdrmap.put("dept_code",deptCodeDet);
				hdrmap.put("emp_code",empCodeDet);
				hdrmap.put("anal_code",analCodeDet);
				hdrmap.put("analysis1",analysis1);
				hdrmap.put("analysis2",analysis2);
				hdrmap.put("analysis3",analysis3);
				/// if posting is in basic currency then put the exchange rate 1	
				
				if(basiccurr == "Y")
				{
					hdrmap.put("curr_code",basiccurr);
					hdrmap.put("exch_rate",1);
				}
				else 
				{
					hdrmap.put("curr_code",currcode );
					hdrmap.put("exch_rate",exch_h);
				}
				hdrmap.put("ref_type","F");
				hdrmap.put("ref_ser","VOUCH");
				hdrmap.put("ref_id",ref_id);
				hdrmap.put("remarks",remarks);
				hdrmap.put("proj_code",proj_code);

				 party_doc_ref = finCommon.gfGetPartyDocRef("VOUCH",ref_id,conn);
				hdrmap.put("party_doc_ref",party_doc_ref);
				
				System.out.println("calling Gltrace Update for detail 1*******************");
				
				errString = finCommon.glTraceUpdate(hdrmap,conn,true); 
				System.out.println("ERROR STRING>>>>>>>>>>>>>>>>>>>>>>["+errString+"]");
				if(errString != null && errString.trim().length() > 0)
				{
					return errString;
				}
				
			      if(taxtranamt != 0.0)
			      {
			    	    hdrmap.put("tran_date",tranDate);
						hdrmap.put("eff_date", effDate);
						hdrmap.put("fin_entity",finentity);
						hdrmap.put("site_code",sitecode);
						hdrmap.put("sundry_type",'S');
						hdrmap.put("sundry_code",suppcode);
			    	    if(taxtranamt > 0.0)
			    	    {
			    	    	hdrmap.put("dr_amt",0.0);
							hdrmap.put("cr_amt",taxtranamt);
							System.out.println("taxtranamt>>>>>>>"+taxtranamt);
						
					    }

						else{
							hdrmap.put("dr_amt", 0.0 - taxtranamt);
							hdrmap.put("cr_amt",0.0);
							System.out.println("taxtranamt>>>>>>>"+taxtranamt);
						    }
			    	    hdrmap.put("acct_code",acctCodeDet);
						hdrmap.put("cctr_code",cctrCodeDet);
						hdrmap.put("dept_code",deptCodeDet);
						hdrmap.put("emp_code",empCodeDet);
						hdrmap.put("anal_code",analCodeDet);
						hdrmap.put("analysis1",analysis1);
						hdrmap.put("analysis2",analysis2);
						hdrmap.put("analysis3",analysis3);
						hdrmap.put("curr_code",currcode );
						hdrmap.put("exch_rate",exch_h);
						hdrmap.put("ref_type","F");
						hdrmap.put("ref_ser","VOUCH");
						hdrmap.put("ref_id",ref_id);
						hdrmap.put("remarks",remarks);
						hdrmap.put("proj_code",proj_code);

						/* party_doc_ref = finCommon.gfGetPartyDocRef("VOUCH",ref_id,conn);
						hdrmap.put("party_doc_ref",party_doc_ref);
						*/
						System.out.println("calling Gltrace Update for taxtranamt*******************");
						
						errString = finCommon.glTraceUpdate(hdrmap,conn,true); 
						System.out.println("ERROR STRING>>>>>>>>>>>>>>>>>>>>>>["+errString+"]");
						if(errString != null && errString.trim().length() > 0)
						{
							return errString;
						}
						
			      }
			      
					}
					
					rs1.close();
					rs1=null;
					pstmt1.close();
					pstmt1=null;
					
					//********Posting for Receipt window
					
                    String ls_acct_tax = "",ls_cctr_tax = "";
                    String itemCode = "",itemSer ="",anly1 = "",acctCodePh = "",cctrCodePh = "",deptCode = "",projCode = "",analCode = "",anly2 = "",anly3 = "",acctVar = "",purcOrd = "";
                    double 	discAmt = 0.0,lc_tax_amt = 0.0,lc_reco_amt = 0.0 ,lc_rndAmt = 0.0;
                    int count = 0,count1 = 0,count2 = 0,count3 = 0,count4 = 0;
					String lineNoRcp = "",prcp_id = "",cctrCodeDis = "",acctCodeDis = "",itemCode2 = "",itemSer2 = "",taxLs = "";
							double rcpQty=0.0,vchQty = 0.0,rate = 0.0,rcpAmt = 0.0,varAmt = 0.0;
					sql = "select line_no from vouchrcp where tran_id = ?";
					  pstmt1 = conn.prepareStatement(sql);
						pstmt1.setString(1,tranID);
						rs1 = pstmt1.executeQuery();
						while(rs1.next())
						{
						     lineNoRcp = rs1.getString("line_no");
						        System.out.println("Posting Receipt window !!!!!!!!!!!!!!!"+rs1.getRow());
						        sql = "select * from vouchrcp where tran_id = ? and line_no = ?";
						        pstmt = conn.prepareStatement(sql);
								pstmt.setString(1,tranID);
								pstmt.setString(2,lineNoRcp);
								rs = pstmt.executeQuery();
								while(rs.next())
								{
									
								rcpAmt = rs.getDouble("vouch_amt");	
								itemCode = rs.getString("item_code");
								itemSer = rs.getString("item_ser");
								discAmt = rs.getDouble("disc_amt");
								acctCodePh = rs.getString("acct_code");
								cctrCodePh = rs.getString("cctr_code");
								deptCode = checkNull(rs.getString("dept_code"));
								projCode = rs.getString("proj_code");
								analCode = rs.getString("anal_code");
								anly1 = rs.getString("analysis1");
								anly2 = rs.getString("analysis2");
								anly3 = rs.getString("analysis3");
						
								System.out.println("Transaction Type >>>>"+tranType);
								System.out.println("acctCodePh  >>>>"+acctCodePh+ "       cctrCodePh "+cctrCodePh);
								String[] arrayOne = new String[1000];
								if(acctCodePh == null ||  acctCodePh.trim().length() == 0)
								{
									System.out.println("706********INSIDING DETERMINATION TYPE");
									acctCodePh = finCommon.getAcctDetrTtype(itemCode, itemSer, "IN", tranType, conn);
							
									arrayOne  = getTokens(acctCodePh,",");
								
								}
								System.out.println("cctrCodePh******"+arrayOne[1]+"    acctCodePh*********"+arrayOne[0]);
								prcp_id  = rs.getString("prcp_id");
							
		  			            
								sql = "select quantity,vouch_qty,rate from porcpdet where tran_id = ? and line_no = ?" ;
								    pstmt2 = conn.prepareStatement(sql);
									pstmt2.setString(1,prcp_id);
									pstmt2.setString(2,lineNoRcp);
									rs2 = pstmt2.executeQuery();
									while(rs2.next())
									{
										rcpQty = rs2.getDouble("quantity");
										vchQty = rs2.getDouble("vouch_qty");
										rate = rs2.getDouble("rate");
									}
									rs2.close();
									rs2=null;
									pstmt2.close();
									pstmt2=null;
									
									String[] cctrCodeDis1;
									acctCodeDis= finCommon.getAcctDetrTtype(itemCode, itemSer, "DIS", tranType, conn);
									cctrCodeDis1 = getTokens(acctCodeDis,",");
									
					
									varAmt = rcpAmt - (rcpQty - vchQty)*rate;
									System.out.println("tHE vAMT *****"+varAmt);
									
									if(varAmt != 0.0)
									{
										rcpAmt = (rcpQty - vchQty)*rate;
									}
									System.out.println("RCP AMount >>>>>>>>>>"+rcpAmt);
									
									sql = "select count(*) from vouchdet where acct_code = ? and cctr_code = ?";
									pstmt2 = conn.prepareStatement(sql);
									pstmt2.setString(1,arrayOne[0]);
									pstmt2.setString(2,arrayOne[1]);
									rs2 = pstmt2.executeQuery();
									while(rs2.next())
									{
										count = rs2.getInt(1);
								
									}
							     	rs2.close();
								    rs2=null;
								    pstmt2.close();
								    pstmt2=null;
									if(count == 0 )
									{
										// hdrmap.put("amount",rs.getString("acct_code"));
										    hdrmap.put("tran_date",tranDate);
											hdrmap.put("eff_date", effDate);
											hdrmap.put("fin_entity",finentity);
											hdrmap.put("site_code",sitecode);
											hdrmap.put("acct_code",arrayOne[0]);
										    hdrmap.put("cctr_code",arrayOne[1]);
											hdrmap.put("dr_amt", rcpAmt);
											hdrmap.put("cr_amt",0.0);
											hdrmap.put("dept_code",deptCode);
											//hdrmap.put("emp_code",rs.getString(""));
											hdrmap.put("anal_code",analCode);
											hdrmap.put("proj_code",projCode);
											hdrmap.put("analysis1",anly1);
											hdrmap.put("analysis2",anly2);
											hdrmap.put("analysis3",anly3);
											System.out.println("calling Gltrace Update for VoucherRcp*********1**********");
											
											errString = finCommon.glTraceUpdate(hdrmap,conn,true); 
											System.out.println("ERROR STRING>>>>>>>>>>>>>>>>>>>>>>["+errString+"]");
											if(errString != null && errString.trim().length() > 0)
											{
												return errString;
											}
									}
									
									else if (count > 0)//posting again instead of setting into detail*****updating amount
									{
										    hdrmap.put("tran_date",tranDate);
											hdrmap.put("eff_date", effDate);
											hdrmap.put("fin_entity",finentity);
											hdrmap.put("site_code",sitecode);
											hdrmap.put("acct_code",arrayOne[0]);
										    hdrmap.put("cctr_code",arrayOne[1]);
										    System.out.println("Updating amount ******"+ rcpAmt + amount);
											hdrmap.put("dr_amt", rcpAmt + amount );//**updating amount
											hdrmap.put("cr_amt",0.0);
											hdrmap.put("dept_code",deptCode);
											//hdrmap.put("emp_code",rs.getString(""));
											hdrmap.put("anal_code",analCode);
											hdrmap.put("proj_code",projCode);
											hdrmap.put("analysis1",anly1);
											hdrmap.put("analysis2",anly2);
											hdrmap.put("analysis3",anly3);
											System.out.println("calling Gltrace Update for VoucherRcp*********2**********");
											
											errString = finCommon.glTraceUpdate(hdrmap,conn,true); 
											System.out.println("ERROR STRING>>>>>>>>>>>>>>>>>>>>>>["+errString+"]");
											if(errString != null && errString.trim().length() > 0)
											{
												return errString;
											}
									}
									
								    if(varAmt != 0.0)//Variance amount
								    {
								    	acctVar= checkNull(finCommon.getAcctDetrTtype(itemCode, itemSer, "PPV", tranType, conn));
								    	String tempStrAry[];
								    	tempStrAry = getTokens(acctVar,",");
								   System.out.println("Length of array :- "+tempStrAry.length);
//								    	System.out.println("acctVar>>>>>"+acctVar+"    cctrVar "+cctrVar);
								    sql = "select count(*) from vouchdet where acct_code = ? and cctr_code = ?";
									pstmt2 = conn.prepareStatement(sql);
									pstmt2.setString(1,tempStrAry[0]);
									pstmt2.setString(2,tempStrAry[1]);
									rs2 = pstmt2.executeQuery();
									while(rs2.next())
									{
										count1 = rs2.getInt(1);
								
									}
							     	rs2.close();
								    rs2=null;
								    pstmt2.close();
								    pstmt2=null;
								    
								    if(count1 == 0)
								    {
								    	   hdrmap.put("tran_date",tranDate);
											hdrmap.put("eff_date", effDate);
											hdrmap.put("fin_entity",finentity);
											hdrmap.put("site_code",sitecode);
											hdrmap.put("acct_code",tempStrAry[0]);
										    hdrmap.put("cctr_code",tempStrAry[1]);
											hdrmap.put("dr_amt",varAmt );
											hdrmap.put("cr_amt",0.0);
											hdrmap.put("dept_code",deptCode);
											//hdrmap.put("emp_code",rs.getString(""));
											hdrmap.put("anal_code",analCode);
											hdrmap.put("proj_code",projCode);
											hdrmap.put("analysis1",anly1);
											hdrmap.put("analysis2",anly2);
											hdrmap.put("analysis3",anly3);
											System.out.println("calling Gltrace Update for VoucherRcp********3**********");
											
											errString = finCommon.glTraceUpdate(hdrmap,conn,true); 
											System.out.println("ERROR STRING>>>>>>>>>>>>>>>>>>>>>>["+errString+"]");
											if(errString != null && errString.trim().length() > 0)
											{
												return errString;
											}
								    }
									else if (count1 > 0)//posting again instead of setting into detail*****updating amount
									{
										    hdrmap.put("tran_date",tranDate);
											hdrmap.put("eff_date", effDate);
											hdrmap.put("fin_entity",finentity);
											hdrmap.put("site_code",sitecode);
											hdrmap.put("acct_code",tempStrAry[0]);
										    hdrmap.put("cctr_code",tempStrAry[1]);
										    System.out.println("Updating amount ******"+ varAmt + amount);
											hdrmap.put("dr_amt", varAmt + amount );//**updating amount
											hdrmap.put("cr_amt",0.0);
											hdrmap.put("dept_code",deptCode);
											//hdrmap.put("emp_code",rs.getString(""));
											hdrmap.put("anal_code",analCode);
											hdrmap.put("proj_code",projCode);
											hdrmap.put("analysis1",anly1);
											hdrmap.put("analysis2",anly2);
											hdrmap.put("analysis3",anly3);
											System.out.println("calling Gltrace Update for VoucherRcp*********4**********");
											
											errString = finCommon.glTraceUpdate(hdrmap,conn,true); 
											System.out.println("ERROR STRING>>>>>>>>>>>>>>>>>>>>>>["+errString+"]");
											if(errString != null && errString.trim().length() > 0)
											{
												return errString;
											}
									}
								    
								    
								    }//end of variance
								    
								    //**********For Discount amount***
								    
								    if(discAmt != 0.0)
								    {
								    	discAmt = 0.0 - discAmt;
								    	if(acctCodeDis == null ||  acctCodeDis.trim().length() == 0)
										{
								    		acctCodeDis = acctCodePh;
								    		cctrCodeDis = checkNull(cctrCodeDis);
										}
								    	sql = "select count(*) from vouchdet where acct_code = ? and cctr_code = ?";
										pstmt2 = conn.prepareStatement(sql);
										pstmt2.setString(1,cctrCodeDis1[0]);
										pstmt2.setString(2,cctrCodeDis1[1]);
										rs2 = pstmt2.executeQuery();
										while(rs2.next())
										{
											count2 = rs2.getInt(1);
									
										}
								     	rs2.close();
									    rs2=null;
									    pstmt2.close();
									    pstmt2=null;
								    	if(count2 == 0)
								    	{
								    		hdrmap.put("tran_date",tranDate);
											hdrmap.put("eff_date", effDate);
											hdrmap.put("fin_entity",finentity);
											hdrmap.put("site_code",sitecode);
											hdrmap.put("acct_code",cctrCodeDis1[0]);
										    hdrmap.put("cctr_code",cctrCodeDis1[1]);
											hdrmap.put("dr_amt", discAmt);
											hdrmap.put("cr_amt",0.0);
											hdrmap.put("dept_code",deptCode);
											//hdrmap.put("emp_code",rs.getString(""));
											hdrmap.put("anal_code",analCode);
											hdrmap.put("proj_code",projCode);
											hdrmap.put("analysis1",anly1);
											hdrmap.put("analysis2",anly2);
											hdrmap.put("analysis3",anly3);
											System.out.println("calling Gltrace Update for VoucherRcp********3**********");
											
											errString = finCommon.glTraceUpdate(hdrmap,conn,true); 
											System.out.println("ERROR STRING>>>>>>>>>>>>>>>>>>>>>>["+errString+"]");
											if(errString != null && errString.trim().length() > 0)
											{
												return errString;
											}
								    	}
								    	else if (count2 > 0)//posting again instead of setting into detail*****updating amount
										{
											    hdrmap.put("tran_date",tranDate);
												hdrmap.put("eff_date", effDate);
												hdrmap.put("fin_entity",finentity);
												hdrmap.put("site_code",sitecode);
												hdrmap.put("acct_code",cctrCodeDis1[0]);
											    hdrmap.put("cctr_code",cctrCodeDis1[1]);
											    System.out.println("Updating amount *discAmt*****"+ discAmt + amount);
												hdrmap.put("dr_amt", discAmt + amount );//**updating amount
												hdrmap.put("cr_amt",0.0);
												hdrmap.put("dept_code",deptCode);
												//hdrmap.put("emp_code",rs.getString(""));
												hdrmap.put("anal_code",analCode);
												hdrmap.put("proj_code",projCode);
												hdrmap.put("analysis1",anly1);
												hdrmap.put("analysis2",anly2);
												hdrmap.put("analysis3",anly3);
												System.out.println("calling Gltrace Update for VoucherRcp*********4**********");
												
												errString = finCommon.glTraceUpdate(hdrmap,conn,true); 
												System.out.println("ERROR STRING>>>>>>>>>>>>>>>>>>>>>>["+errString+"]");
												if(errString != null && errString.trim().length() > 0)
												{
													return errString;
												}
										}
								    }//end of discount amount
								 // taxtran taken outside
								    //do{
								    	sql = "select purc_order as ls_purc_ord from voucher where tran_id = ? ";
								    	pstmt2 = conn.prepareStatement(sql);
								    	pstmt2.setString(1,tranID);
										rs2 = pstmt2.executeQuery();
										while(rs2.next())
										{
								    	purcOrd = rs2.getString("ls_purc_ord");
										}
								     	rs2.close();
									    rs2=null;
									    pstmt2.close();
									    pstmt2=null;
									    
								    	
									    sql = "select item.item_code as ls_itemcode, item.item_ser as ls_itemser "
				                        +"from porddet, item where porddet.item_code = item.item_code and  porddet.purc_order = ? "
				                     	+"	and porddet.line_no = ( select min(line_no) from porddet where purc_order = ? ) ";
									    pstmt2 = conn.prepareStatement(sql);
										pstmt2.setString(1,purcOrd);
										pstmt2.setString(2,purcOrd);
									//	pstmt2.setString(2,cctrCodeDis);
										rs2 = pstmt2.executeQuery();
										while(rs2.next())
										{
								        itemCode2 = rs2.getString("ls_itemcode");
								        itemSer2 = rs2.getString("ls_itemser");
									    
										}
								     	rs2.close();
									    rs2=null;
									    pstmt2.close();
									    pstmt2=null;
									    
									   sql = "select case when max(line_no) is null then 0 else max(line_no) end as li_tax from vouchdet where tran_id =  ? ";
									    pstmt2 = conn.prepareStatement(sql);
										pstmt2.setString(1,tranID);
									//	pstmt2.setString(2,cctrCodeDis);
										rs2 = pstmt2.executeQuery();
										while(rs2.next())
										{
										taxLs = rs2.getString("li_tax");
										}
										rs2.close();
									    rs2=null;
									    pstmt2.close();
									    pstmt2=null;
									    
									    if(acctCodePh == null ||  acctCodePh.trim().length() == 0)
										{
									    	acctCodePh = finCommon.getAcctDetrTtype(itemCode, itemSer, "IN", tranType, conn);
									    	cctrCodePh = getTokens(acctCodePh,",").toString();
										}
								    	
								   // }while(true);
								    
								    sql = " select sum(a.tax_amt) as tax_amt, a.acct_code as acct_code, a.cctr_code as cctr_code, case when sum(a.reco_amount) is null then 0 else sum(a.reco_amount) end  as reco_amount  "
								    		+"from taxtran a, tax b where a.tax_code = b.tax_code and a.tran_code = 'VOUCH'" +
								    		" and  a.tran_id =  ? and b.effect <> 'N'group by a.acct_code, a.cctr_code ";
								    pstmt2 = conn.prepareStatement(sql);
									pstmt2.setString(1,tranID);
								//	pstmt2.setString(2,cctrCodeDis);
									rs2 = pstmt2.executeQuery();
									while(rs2.next())
									{
										lc_tax_amt = rs2.getDouble("tax_amt");
										ls_acct_tax = rs2.getString("acct_code");
										ls_cctr_tax = checkNull(rs2.getString("cctr_code"));
										lc_reco_amt = rs2.getDouble("reco_amount");
									}
									rs2.close();
								    rs2=null;
								    pstmt2.close();
								    pstmt2=null;
								    
								    if(lc_tax_amt > 0.0)
								    {
								    	if(ls_acct_tax == null ||  ls_acct_tax.trim().length() == 0)
										{
								    		ls_acct_tax = acctCodePh;
										}
								    	if(ls_cctr_tax == null ||  ls_cctr_tax.trim().length() == 0)
										{
								    		ls_cctr_tax = acctCodePh;
										}
								    	
								    	sql = "select count(*) from vouchdet where acct_code = ? and cctr_code = ?";
										pstmt2 = conn.prepareStatement(sql);
										pstmt2.setString(1,ls_acct_tax);
										pstmt2.setString(2,ls_cctr_tax);
										rs2 = pstmt2.executeQuery();
										while(rs2.next())
										{
											count3 = rs2.getInt(1);
									
										}
								     	rs2.close();
									    rs2=null;
									    pstmt2.close();
									    pstmt2=null;
									 // 22-03-03 Arif .. tax record should be separately inserted with auto_generated
										// flag set as 'Y'. Records with flag 'Y' will not be considered in save_det
										// while batchloading.
								    	if(count3 == 0)
								    	{
								    		hdrmap.put("tran_date",tranDate);
											hdrmap.put("eff_date", effDate);
											hdrmap.put("fin_entity",finentity);
											hdrmap.put("site_code",sitecode);
											hdrmap.put("acct_code",ls_acct_tax);
										    hdrmap.put("cctr_code",ls_cctr_tax);
											hdrmap.put("dr_amt", lc_tax_amt);
											hdrmap.put("cr_amt",0.0);
											hdrmap.put("dept_code",deptCode);
											//hdrmap.put("emp_code",rs.getString(""));
											hdrmap.put("anal_code",analCode);
											hdrmap.put("proj_code",projCode);
											hdrmap.put("analysis1",anly1);
											hdrmap.put("analysis2",anly2);
											hdrmap.put("analysis3",anly3);
											System.out.println("calling Gltrace Update for VoucherRcp********taxing*********");
											
											errString = finCommon.glTraceUpdate(hdrmap,conn,true); 
											System.out.println("ERROR STRING>>>>>>>>>>>>>>>>>>>>>>["+errString+"]");
											if(errString != null && errString.trim().length() > 0)
											{
												return errString;
											}
								    	}
								    	else if (count3 > 0)//posting again instead of setting into detail*****updating amount
										{
											    hdrmap.put("tran_date",tranDate);
												hdrmap.put("eff_date", effDate);
												hdrmap.put("fin_entity",finentity);
												hdrmap.put("site_code",sitecode);
												hdrmap.put("acct_code",ls_acct_tax);
											    hdrmap.put("cctr_code",ls_cctr_tax);
											    System.out.println("Updating amount *discAmt*****"+ discAmt + amount);
												hdrmap.put("dr_amt",( lc_tax_amt + amount) - lc_reco_amt );//**updating amount
												hdrmap.put("cr_amt",0.0);
												hdrmap.put("dept_code",deptCode);
												//hdrmap.put("emp_code",rs.getString(""));
												hdrmap.put("anal_code",analCode);
												hdrmap.put("proj_code",projCode);
												hdrmap.put("analysis1",anly1);
												hdrmap.put("analysis2",anly2);
												hdrmap.put("analysis3",anly3);
												System.out.println("calling Gltrace Update for VoucherRcp********taxing*********");
												
												errString = finCommon.glTraceUpdate(hdrmap,conn,true); 
												System.out.println("ERROR STRING>>>>>>>>>>>>>>>>>>>>>>["+errString+"]");
												if(errString != null && errString.trim().length() > 0)
												{
													return errString;
												}
										}
								    }
								    
								    //Rounding off net Amt
								   String ls_cctrcode_rnd = "",ls_acctcode_rnd = "";
								    if(rndOff != "N")
								    {
								    	lc_netwr  = netAmt;
								    	netAmt = getRndamt(netAmt, rndOff, rndTo);
								    	lc_rndAmt = netAmt - lc_netwr;
								    	System.out.println("Rnd Amount >>> "+lc_rndAmt);
								    	if(lc_rndAmt != 0.0)
								    	{
								    		
								    		ls_cctrcode_rnd = finCommon.getFinparams("999999", "RND_ACCT", conn);
								    		
								    		if(ls_cctrcode_rnd != "NULLFOUND")
								    		{
								    			ls_acctcode_rnd = getTokens(ls_cctrcode_rnd,";").toString();
								    		}
								    		
								    		System.out.println("ls_cctrcode_rnd*****"+ls_cctrcode_rnd+"     ls_acctcode_rnd "+ls_acctcode_rnd);
								    		
								    		
								    		if( ls_acctcode_rnd.trim().length() == 0)
											{
								    			ls_acctcode_rnd = null;
											}
									    	if( ls_cctrcode_rnd.trim().length() ==  0)
											{
									    		ls_cctrcode_rnd = null;
											}
									  
									    	
											
									    		hdrmap.put("tran_date",tranDate);
												hdrmap.put("eff_date", effDate);
												hdrmap.put("fin_entity",finentity);
												hdrmap.put("site_code",sitecode);
												hdrmap.put("acct_code",ls_acctcode_rnd);
											    hdrmap.put("cctr_code",ls_cctrcode_rnd);
												hdrmap.put("dr_amt", lc_tax_amt);
												hdrmap.put("cr_amt",0.0);
												hdrmap.put("dept_code",deptCode);
												//hdrmap.put("emp_code",rs.getString(""));
												hdrmap.put("anal_code",analCode);
												hdrmap.put("proj_code",projCode);
												hdrmap.put("analysis1",anly1);
												hdrmap.put("analysis2",anly2);
												hdrmap.put("analysis3",anly3);
												System.out.println("calling Gltrace Update for VoucherRcp********roundoff*********");
												
												errString = finCommon.glTraceUpdate(hdrmap,conn,true); 
												System.out.println("ERROR STRING>>>>>>>>>>>>>>>>>>>>>>["+errString+"]");
												if(errString != null && errString.trim().length() > 0)
												{
													return errString;
												}
									    	
								    	}
								    	
								    }
								    
								
								    
								}
								rs.close();
								rs=null;
								pstmt.close();
								pstmt=null;
						}
					
						rs1.close();
						rs1=null;
						pstmt1.close();
						pstmt1=null;
					
			      
			
						
						
						
			 /*     //DI7SUN0018-To reverse the inventory entry for items whose qc ord is not made*********************PROVISIONAL
		   String porcpOld = "",porcp = "",post_prov = "", transer = "",tran_id__ref = "",itemCd = "",lineNoRcp = "",lineno1 = "",porcp1 = "";
			      int cnt = 0,qcordcnt = 0;
			      Double amt = 0.0;
		    	  String acctcodedr = "",cctrcodedr = "" ,acctcodeprov = "",cctrcodeprov = "";
			      ArrayList porcplst = new ArrayList();
			      
			      sql = "select count(*) as cnt from vouchrcp where tran_id = ? ";
			      pstmt = conn.prepareStatement(sql);
					pstmt.setString(1,tranID);
					rs = pstmt.executeQuery();
					while(rs.next())
					{
						cnt = rs.getInt("cnt");
					}
					rs.close();
					rs=null;
					pstmt.close();
					pstmt=null;
			      
				for(int i = 0;i <= cnt;i++ )
				{
					sql = "select * from vouchrcp where tran_id= ?";
				      pstmt = conn.prepareStatement(sql);
						pstmt.setString(1,finentity);
						rs = pstmt.executeQuery();
						while(rs.next())
						{
							porcp = rs.getString("prcp_id");
							lineNoRcp = rs.getString("line_no__rcp");
						}
						rs.close();
						rs=null;
						pstmt.close();
						pstmt=null;
				      
					 if(porcpOld != porcp )
				      {
				    	  porcpOld =  porcp;
				    	  post_prov = "";
				    	  transer = "";
				    	  tran_id__ref = "";
				      
				      
				      sql  = "select post_prov , tran_ser, tran_id__ref,item_code  from	porcp where tran_id = ?";
				      pstmt = conn.prepareStatement(sql);
						pstmt.setString(1,finentity);
						rs = pstmt.executeQuery();
						while(rs.next())
						{
							post_prov = rs.getString("post_prov");
							transer = rs.getString("tran_ser");
							tran_id__ref = rs.getString("tran_id__ref");
							itemCd  = rs.getString("item_code");
						}
						rs.close();
						rs=null;
						pstmt.close();
						pstmt=null;
						
						if(post_prov == null || post_prov.trim().length() == 0 )
						{
							post_prov = "N"	;
						}
						if(post_prov == "N" ){//DOUBT
							  porcpOld =  porcp;
								continue;
						}
						porcpOld =  porcp;
						lineNoRcp = "    " + lineNoRcp;
						lineNoRcp = lineNoRcp.substring(lineNoRcp.length() - 3,lineNoRcp.length());
						lineno1 = "";
						porcp1 = "";
						if(transer == "P-RET") // IF Purch return then consider reference tranid & lineno for checking if qc ord exist's
						{
							sql  = "select line_no__ord as lineno1 from porcpdet where	tran_id = ? and	line_no = ?";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1,porcp);
							pstmt.setString(2,lineNoRcp);
							rs = pstmt.executeQuery();
							while(rs.next())
							{
								lineno1 = rs.getString("lineno1");
							}
							rs.close();
							rs=null;
							pstmt.close();
							pstmt=null;
							porcp1 = tran_id__ref;
						}
						else{
							porcp1 = porcp;
							lineno1 = lineNoRcp;
						}
						lineno1 = "    " + lineno1;
						lineno1 = lineno1.substring(lineno1.length() - 3,lineno1.length());
						
						sql ="select count(1) as qcord_cnt from	qc_order where porcp_no = ? and	porcp_line_no = ? and	item_code = ?";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1,porcp1);
						pstmt.setString(2,lineno1);
						pstmt.setString(3,itemCd);
						rs = pstmt.executeQuery();
						while(rs.next())
						{
							qcordcnt = rs.getInt("qcord_cnt");
						}
						rs.close();
						rs=null;
						pstmt.close();
						pstmt=null;
						
						if(qcordcnt > 0)
						{
							continue;
						}
						else{
							sql ="select acct_code__dr as acctcode, cctr_code__dr as cctrcode, acct_code__prov_dr as prov_acct, cctr_code__prov_dr as prov_cctr from porcpdet"
		                        +"where tran_id = ? and line_no = ? ";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1,porcp1);
							pstmt.setString(2,lineno1);
							
							rs = pstmt.executeQuery();
							while(rs.next())
							{
								acctcodedr = rs.getString("acctcode");
								cctrcodedr = rs.getString("cctrcode");
								acctcodeprov = rs.getString("prov_acct");
								cctrcodeprov = rs.getString("prov_cctr");
							}
							rs.close();
							rs=null;
							pstmt.close();
							pstmt=null;
						
							amount = vouchAmt;
							cnt = porcplst.size();
							int foundRow = 0;
							if(cnt > 0)
							{
								map1.put("type", "A");
								map1.put("acct_code", checkNull(acctcodedr));
								map1.put("cctr_code", acctcodedr);
								porcplst.add(map1);
								porcplst.add(1);
								porcplst.add(cnt);
								foundRow = porcplst.size();
								/*
								ll_foundrow = lst_porcp.Find("type = 'A' and acct_code = '" + gf_nulltostr(ls_acctcode) + &
												"' and cctr_code = '" + gf_nulltostr(ls_cctrcode) + "'", 1, ll_cnt);
								
								
								
							}
							
							if(foundRow == 0)
							{
								porcplst.add(1,"A");
								porcplst.add(2,acctcodedr);//acctcode
								porcplst.add(3,cctrcodedr);//cctrcode
								porcplst.add(4,amount);//amount
							}
							
							
						}
						
						
			      if(errString == null && errString.trim().length() == 0)
					{
			    	    hdrmap.put("tran_date",tranDate);
						hdrmap.put("eff_date", effDate);
						hdrmap.put("fin_entity",finentity);
						hdrmap.put("site_code",sitecode);
						hdrmap.put("sundry_type",'O');
						hdrmap.put("sundry_code","");
						hdrmap.put("emp_code","");
						hdrmap.put("anal_code","");
						hdrmap.put("curr_code",basiccurr);
						hdrmap.put("exch_rate",1);
						hdrmap.put("ref_type","D");
						hdrmap.put("ref_ser","VOUCH");
						hdrmap.put("ref_id",ref_id);
						hdrmap.put("remarks","Voucher : "+ref_id+"Dt."+tranDate);
						
						for(int j = 0;j<porcplst.size() ;j++)
						{
							hdrmap.put("acct_code",porcplst.get(2));
							hdrmap.put("cctr_code",porcplst.get(3));
							amt = Double.parseDouble(porcplst.get(4).toString());
							System.out.println("AMOUNT>>>>>>"+amt);
							if(amt != 0.0)
							{
								if(porcplst.get(1).equals("A"))
								{
									hdrmap.put("dr_amt",amt);
									hdrmap.put("cr_amt",0.0);
								}
							}
						}
					}
		}
				}*/
		}
		catch( Exception e)
		{
			if(conn!=null)
			{
				try {
					conn.rollback();
				} catch (SQLException ex) {

					System.out.println("Exception : "+e);
					e.printStackTrace();
					throw new ITMException(e);

				}
			}
			System.out.println("Exception : "+e);
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			
				try
				{
					
					if(errString != null && errString.trim().length() > 0)
					{
						if( conn != null && !conn.isClosed() && connStatus ) 
						{
							if(errString.indexOf("VTCICONF3") > -1)
							{
								conn.commit();
							}
							else
							{
								conn.rollback();
							}
							conn.close();
							conn = null;
						}
					}
					if(rs != null)
					{
						rs.close();
						rs = null;
					}
					if(pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
					//conn.close();
				}
				catch(Exception e)
				{
					System.out.println("Exception : "+e);e.printStackTrace();
					throw new ITMException(e);
				}
			
		}
     
	    return retString;
	}
	

	
	private String checkNull(String inp)
	{
		if(inp == null)
			inp = " ";
		return inp.trim();
	}
	
	

	private String[] getTokens( String str, String seperator )
	{
		String val = null;
		ArrayList sArr = new ArrayList();

		StringTokenizer st = new StringTokenizer( str, seperator );
	    while (st.hasMoreTokens()) 
	    {
		  val = st.nextToken();
	      sArr.add( val );
	    }
		st = null;
		int lenArr = sArr.size();
		String str1[] = new String[ lenArr ];
		for( int cnt = 0; cnt < lenArr ; cnt++ )
		{
			str1[ cnt ] = ( String ) sArr.get( cnt );
		}
		return str1;
	}
	
	public double getRndamt(double netamt, String round, double roundTo) 
	{
		double lcMultiply = 1;
		try
		{

			round = round.toUpperCase();
			if(netamt < 0)
			{
				lcMultiply = -1;
				netamt = Math.abs(netamt);
			}
			else if (netamt == 0)
			{
				return netamt;
			}
			else if (round.trim().equals("N"))
			{
				return netamt;
			}
			else if(roundTo == 0)
			{
				return netamt;
			}
			if(round.trim().equals("X"))
			{
				netamt = (netamt - (netamt % roundTo) + roundTo);
			}
			if(round.trim().equals("P"))
			{
				netamt = (netamt - (netamt % roundTo));
			}
			if(round.trim().equals("R"))
			{
				if((netamt % roundTo) < (roundTo / 2))
				{
					netamt = (netamt - (netamt % roundTo));
				}
				else
				{
					netamt = (netamt - (netamt % roundTo) + roundTo);
				}
			}
			return netamt;
		}
		catch(Exception e)
		{
			System.out.println("Exception :Conversion Qty ::" + e.getMessage() + ":");

		}
		if (roundTo == 1)
		{
			netamt = getRequiredDecimal(netamt, 0);
		}
		else if (roundTo == .1)
		{
			netamt = getRequiredDecimal(netamt, 1);
		}
		else if (roundTo == .01)
		{
			netamt = getRequiredDecimal(netamt, 2);
		}
		else if (roundTo == .001)
		{
			netamt = getRequiredDecimal(netamt, 3);
		}
		else if (roundTo == .0001)
		{
			netamt = getRequiredDecimal(netamt, 4);
		}
		return netamt;
	}
	public double getRequiredDecimal(double actVal, int prec)
	{
		NumberFormat numberFormat = NumberFormat.getIntegerInstance ();
		Double DoubleValue = new Double (actVal);
		numberFormat.setMaximumFractionDigits(3);
		String strValue = numberFormat.format(DoubleValue);
		strValue = strValue.replaceAll(",","");
		double reqVal = Double.parseDouble(strValue);
		return reqVal;
	}
	
}
	
/*
 * SELECT VOUCHRCP.TRAN_ID,VOUCHRCP.LINE_NO,VOUCHRCP.PRCP_ID,VOUCHRCP.LINE_NO__RCP,VOUCHRCP.ITEM_CODE,VOUCHRCP.UNIT,VOUCHRCP.RCP_QTY,VOUCHRCP.VOUCH_QTY,VOUCHRCP.RCP_RATE,VOUCHRCP.VOUCH_RATE,VOUCHRCP.PURC_ORDER,VOUCHRCP.LINE_NO__PORD,VOUCHRCP.VOUCH_AMT,VOUCHRCP.TAX_CLASS,VOUCHRCP.TAX_CHAP,VOUCHRCP.TAX_ENV,VOUCHRCP.DISCOUNT,VOUCHRCP.DISC_AMT,VOUCHRCP.TAX_AMT,VOUCHRCP.NET_AMT,VOUCHRCP.RCP_AMT,VOUCHRCP.POST_DIFF,VOUCHRCP.CHG_DATE,VOUCHRCP.CHG_USER,VOUCHRCP.CHG_TERM,VOUCHRCP.ITEM_SER,ITEM.DESCR,VOUCHRCP.ACCT_CODE__DIFF,VOUCHRCP.CCTR_CODE__DIFF,VOUCHRCP.VOUCH_QTY__STDUOM,VOUCHRCP.VOUCH_RATE__STDUOM,VOUCHRCP.ACCT_CODE,VOUCHRCP.CCTR_CODE,ACCOUNTS.DESCR,VOUCHRCP.TAX_ADV_AMT,VOUCHRCP.RATE__CLG,VOUCHRCP.STD_RATE,VOUCHRCP.DEPT_CODE,VOUCHRCP.ANAL_CODE,ANALYSIS.DESCR,COSTCTR.DESCR,VOUCHRCP.PROJ_CODE,VOUCHRCP.ANALYSIS1,VOUCHRCP.ANALYSIS2,VOUCHRCP.ANALYSIS3,FN_GET_BUDGET_AMT('VOUCH',"VOUCHER"."SITE_CODE","VOUCHRCP"."ACCT_CODE","VOUCHRCP"."CCTR_CODE",VOUCHRCP.ANAL_CODE ,"VOUCHRCP"."DEPT_CODE",'A') BUDGET_AMT_ANAL,FN_GET_CONS_AMT('VOUCH',"VOUCHER"."SITE_CODE","VOUCHRCP"."ACCT_CODE","VOUCHRCP"."CCTR_CODE",VOUCHRCP.ANAL_CODE,"VOUCHRCP"."DEPT_CODE",'A') CONSUMED_AMT_ANAL,(CASE WHEN (FN_GET_CONS_AMT('VOUCH',VOUCHER.SITE_CODE,VOUCHRCP.ACCT_CODE,VOUCHRCP.CCTR_CODE,VOUCHRCP.ANAL_CODE,VOUCHRCP.DEPT_CODE,'A')) > 0 THEN (FN_GET_BUDGET_AMT('VOUCH',VOUCHER.SITE_CODE,VOUCHRCP.ACCT_CODE,VOUCHRCP.CCTR_CODE,VOUCHRCP.ANAL_CODE ,VOUCHRCP.DEPT_CODE,'A') - FN_GET_CONS_AMT('VOUCH',VOUCHER.SITE_CODE,VOUCHRCP.ACCT_CODE,VOUCHRCP.CCTR_CODE,VOUCHRCP.ANAL_CODE,VOUCHRCP.DEPT_CODE,'A')) ELSE 0 END)  BUDGET_AMT FROM VOUCHRCP  VOUCHRCP,ITEM  ITEM,ACCOUNTS  ACCOUNTS,ANALYSIS  ANALYSIS,COSTCTR  COSTCTR,VOUCHER  VOUCHER WHERE ( VOUCHRCP.ITEM_CODE      = ITEM.ITEM_CODE   ) AND ( VOUCHER.TRAN_ID      = VOUCHRCP.TRAN_ID   ) AND ( VOUCHRCP.ACCT_CODE=ACCOUNTS.ACCT_CODE(+)) AND ( VOUCHRCP.ANAL_CODE=ANALYSIS.ANAL_CODE(+)) AND ( VOUCHRCP.CCTR_CODE=COSTCTR.CCTR_CODE(+)) AND VOUCHRCP.TRAN_ID    =      ?*/
