//

package ibase.e12ria.e12widgets.client;

import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.EventTarget;
import com.google.gwt.dom.client.InputElement;
import com.google.gwt.dom.client.LabelElement;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.FocusWidget;
import com.google.gwt.user.client.ui.HasValue;

public class E12ColorfulRadio extends FocusWidget implements HasValue<Boolean> {

	InputElement inputElem;
	LabelElement labelElem;

	private Boolean oldValue;
	private boolean valueChangeHandlerInitialized;

	/**
	 * <h1>This HTML created :</h1>
	 * <hr/>
	 * <code>
	   &lt;input name="radio-color-group" type="radio" class="hidden-radio" id="radio-theme-<COLOR>" &gt;<br>
	   &lt;label class="radio-color-style radio-theme-<COLOR>" for="radio-theme-<COLOR>"&gt;&lt;/label&gt;
       </code>
	 * <hr/>
	 * <h1>Use this CSS :</h1>
	 * <hr/>
	 * 
	 * <pre>
	 * .hidden-radio{
	 *   display: none;  
	 * }
	 * 
	 * .radio-color-style{
	 *    height: 25px;
	 *    width: 25px;
	 *    display: inline-block;
	 *    border-radius: 50%;
	 *    margin-left: 10px;
	 *    margin-top: 10px;
	 *    cursor: pointer;
	 * }
	 * 
	 * .radio-color-style:after{
	 *     content: '';
	 *  }
	 * 
	 * input[type="radio"]:checked + .radio-color-style:after{
	 *    margin-top: -6px; 
	 *    margin-left: -6px; 
	 *    height: 35px;
	 *    width: 35px;
	 *    display: inline-block;
	 *    border-radius: 50%;
	 *    border: thin solid;
	 * }
	 * 
	 * .radio-theme-<COLOR>{
	 *      border: 1px solid <COLOR>;
	 *      background: <COLOR>;
	 *      color: <COLOR>;
	 * }
	 * </pre>
	 * <hr/>
	 */
	public E12ColorfulRadio(String colorName) {
		this(DOM.createDiv());
		getElement().setAttribute("style", "outline:none;");
		appendRadio(colorName);
		appendLabel(colorName);

		sinkEvents(Event.ONCLICK);
		sinkEvents(Event.ONMOUSEUP);
		sinkEvents(Event.ONBLUR);
		sinkEvents(Event.ONKEYDOWN);
	}

	protected E12ColorfulRadio(Element elem) {
		super(elem);
	}

	private void appendRadio(String colorName) {
		inputElem = InputElement.as(DOM.createInputRadio("radio-color-group"));
		inputElem.setAttribute("class", "hidden-radio");
		inputElem.setPropertyString("id", "radio-theme-" + colorName);
		getElement().appendChild(inputElem);
	}

	private void appendLabel(String colorName) {
		try {
			labelElem = Document.get().createLabelElement();// DOM.createLabel();
			labelElem.setAttribute("class", "radio-color-style radio-theme-"
					+ colorName);
			labelElem.setHtmlFor("radio-theme-" + colorName);
			getElement().appendChild(labelElem);
		} catch (Exception e) {
			// Window.alert(
			// "Exception :: E12ColorfulRadio : appendLabel() ["+e.getMessage()+"]"
			// );
		}
	}

	/**
	 * Overridden to send ValueChangeEvents only when appropriate.
	 */
	@Override
	public void onBrowserEvent(Event event) {
		switch (DOM.eventGetType(event)) {
		case Event.ONMOUSEUP:
		case Event.ONBLUR:
		case Event.ONKEYDOWN:
			// Note the old value for onValueChange purposes (in ONCLICK case)
			oldValue = getValue();
			break;

		case Event.ONCLICK:
			EventTarget target = event.getEventTarget();
			if (Element.is(target)
					&& labelElem.isOrHasChild(Element.as(target))) {

				// They clicked the label. Note our pre-click value, and
				// short circuit event routing so that other click handlers
				// don't hear about it
				oldValue = getValue();
				return;
			}

			// It's not the label. Let our handlers hear about the
			// click...
			super.onBrowserEvent(event);
			// ...and now maybe tell them about the change
			ValueChangeEvent.fireIfNotEqual(E12ColorfulRadio.this, oldValue,
					getValue());
			return;
		}

		super.onBrowserEvent(event);
	}

	public Boolean getValue() {
		if (isAttached()) {
			return inputElem.isChecked();
		} else {
			return inputElem.isDefaultChecked();
		}
	}

	@Override
	public HandlerRegistration addValueChangeHandler(
			ValueChangeHandler<Boolean> handler) {
		// Is this the first value change handler? If so, time to add handlers
		if (!valueChangeHandlerInitialized) {
			ensureDomEventHandlers();
			valueChangeHandlerInitialized = true;
		}
		return addHandler(handler, ValueChangeEvent.getType());
	}

	@Override
	public void setValue(Boolean value) {
		setValue(value, false);
	}

	@Override
	public void setValue(Boolean value, boolean fireEvents) {
		if (value == null) {
			value = Boolean.FALSE;
		}

		Boolean oldValue = getValue();
		inputElem.setChecked(value);
		inputElem.setDefaultChecked(value);
		if (value.equals(oldValue)) {
			return;
		}
		if (fireEvents) {
			ValueChangeEvent.fire(this, value);
		}
	}

	protected void ensureDomEventHandlers() {
		addClickHandler(new ClickHandler() {
			public void onClick(ClickEvent event) {
				// Checkboxes always toggle their value, no need to compare
				// with old value. Radio buttons are not so lucky, see
				// overrides in RadioButton
				ValueChangeEvent.fire(E12ColorfulRadio.this, getValue());
			}
		});
	}
}
