package ibase.dashboard.scm.servlet;
import ibase.dashboard.scm.ejb.AttritionRemote;
import ibase.system.config.AppConnectParm;
import ibase.webitm.utility.ITMException;
import java.io.IOException;
import java.io.OutputStream;
import javax.naming.InitialContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.simple.JSONObject;

public class AttritionServlet extends HttpServlet
{
	
	private static final long serialVersionUID = 1L;

	public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException
	{
		doPost(request, response);
	}

	@SuppressWarnings("unchecked")
    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException
	{
		AttritionRemote  attritionRemote = null;
		InitialContext context = null;
		AppConnectParm appConnectParm = new AppConnectParm();
		String dataSourceName = "";
		String month = "";
		try
		{
			response.setContentType("application/xml");
			dataSourceName       = request.getParameter("dataSourceName"); 
			month                = (request.getParameter("month"));		
			System.out.println(" month======" + month);
			context             = new InitialContext(appConnectParm.getProperty());
			attritionRemote     = (AttritionRemote) context.lookup("ibase/Attrition/remote");
			//Here invoke EJB define method 
			JSONObject jsonObjData      = (JSONObject)attritionRemote.getAttritionDetails(dataSourceName, month);
			OutputStream outputStream   = response.getOutputStream();			
		    outputStream.write(jsonObjData.toString().getBytes());
			outputStream.flush();
			outputStream.close();
			System.out.println(" Final data set for AttritionServlet build to Graph and Grid===" + jsonObjData);	
			
		} catch (Exception e)
		{
			System.out.println("Exception in: AttritionServlet :doPost(HttpServletRequest request, HttpServletResponse response) :" + e.getMessage());
			try
			{
			  throw new ITMException(e);
			} catch (ITMException e1)
			{
				e1.printStackTrace();
			}
		}
	}

}