/*
 * Author:Wasim Ansari
 * Date:02-FEB-15
 * Request ID:D14IKAT004 (PO Wizard)
 */

package ibase.webitm.bean.wms;

import java.io.File;

import ibase.system.config.AppConnectParm;
import ibase.utility.CommonConstants;
import ibase.webitm.ejb.wms.DDPorderWizEJBRemote;
import ibase.webitm.utility.ITMException;

import javax.naming.InitialContext;
import javax.servlet.http.HttpSession;

public class PorderDetailBean 
{
	private ibase.utility.UserInfoBean userInfo = null;
	private HttpSession sessionCtx = null;
	private String objName = "";
	private String user_lang ="en"; 
	private String user_country = "US";
	
	public String getList(String field,String extra) throws ITMException
	{
		String itemTypeList = "";
		
		DDPorderWizEJBRemote ddPorderWizRemote = null;
		
		try
		{
			InitialContext ctx = new InitialContext( new AppConnectParm().getProperty() );
			ddPorderWizRemote = (ibase.webitm.ejb.wms.DDPorderWizEJBRemote) ctx.lookup("ibase/DDPorderWizEJB/remote");
			itemTypeList = ddPorderWizRemote.getList(field,extra);

			String xslFileName = getXSLFileName( "porderWiz_ItemDetails_wiz_" + this.user_lang + "_" + this.user_country + ".xsl" );
			
			itemTypeList = (ibase.webitm.utility.GenericUtility.getInstance()).transformToString( xslFileName, itemTypeList, CommonConstants.APPLICATION_CONTEXT + File.separator + "temp", "Output", ".html" );

		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		finally
		{
			if ( ddPorderWizRemote != null )
			{
				ddPorderWizRemote = null;
			}
		}
		return itemTypeList;
	}
	private String getXSLFileName( String xslFileName )throws ITMException
	{   
		String retFileName = null;
		try
		{
			String defaultPath = null;
			if( CommonConstants.APPLICATION_CONTEXT != null )
			{
				defaultPath = CommonConstants.APPLICATION_CONTEXT + CommonConstants.ITM_CONTEXT + File.separator;
			}
			else
			{
				defaultPath = ".." + File.separator + "webapps" + File.separator + "ibase" + File.separator + CommonConstants.ITM_CONTEXT + File.separator;
			}
			File xslPath = new File( defaultPath + File.separator  + "xsl" + File.separator + CommonConstants.THEME + File.separator + "WIZARD");
			if ( !xslPath.exists() )
			{
				xslPath.mkdir();
			}
			System.out.println( " xslPath [" + xslPath +"] xslFileName ["+xslFileName +"]");
			File xslFile = new File(xslPath , xslFileName);
			if( xslFile.exists() )
			{
				retFileName = xslFile.getAbsolutePath();
			}
			else
			{
				throw new ITMException( new Exception( retFileName + " Wizard XSL file Not Found") );	
			}
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		return retFileName;
	}
	
	public String nextForm( String formNo, String xmlData ) throws ITMException 
	{
		String retHtmlData = null;
		
		try
		{
			System.out.println("*******In Method : [nextForm]************");
			
			System.out.println("xmlString : ["+ xmlData +"]");
			
			//InitialContext ctx = new InitialContext( new AppConnectParm().getProperty() );
			//DDPorderWizEJBRemote ddPorderWizRemote = null;
			//ddPorderWizRemote = (ibase.webitm.ejb.wms.DDPorderWizEJBRemote) ctx.lookup("ibase/DDPorderWizEJB/remote");
			//details = ddPorderWizRemote.getPorderDetails(xmlData);
			
			String xslFileName = getXSLFileName( "porderWiz1_wiz_" + this.user_lang + "_" + this.user_country + "_" + "A" + ".xsl" );
			
			retHtmlData = (ibase.webitm.utility.GenericUtility.getInstance()).transformToString( xslFileName, xmlData, CommonConstants.APPLICATION_CONTEXT + File.separator + "temp", "Output", ".html" );
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		finally
		{
		}
		return retHtmlData;
	}
}
