/**
* PURPOSE : Pre Save Logic implementation for Replenishment component.
* AUTHOR : Chaitali Parab 15/11/11
*/

package ibase.webitm.ejb.wms;

import ibase.webitm.ejb.*;
import ibase.webitm.utility.ITMException;
import ibase.utility.E12GenericUtility;

import java.rmi.RemoteException;
import java.sql.*;

import org.w3c.dom.*;

import javax.ejb.*;

@javax.ejb.Stateless
public class ReplIssPrs extends ValidatorEJB implements PoRcpPrsLocal, PoRcpPrsRemote
{
	E12GenericUtility genericUtility = new E12GenericUtility();
	public String preSave() throws RemoteException,ITMException
	{
		return "";
	}

	public String preSave(String xmlString, String editFlag, String xtraParams, Connection conn)throws RemoteException,ITMException
	{

		System.out.println("ReplIssPrs EJB called");
		Document dom = null;
		try
		{
			System.out.println("xmlString in ReplIssPrs : preSaveRec \n"+xmlString);			
			if (xmlString != null && xmlString.trim().length() > 0)
			{
				dom = genericUtility.parseString(xmlString);
				executepreSave( dom, editFlag, xtraParams, conn );
			}			
		}
		catch(Exception e)
		{
			System.out.println("Exception :ReplIssPrs :" + e.getMessage() + ":");
			e.printStackTrace();
			throw new ITMException(e);
		}
		return "";
	}

	private String executepreSave( Document dom, String editFlag, String xtraParams, Connection conn ) throws RemoteException, ITMException
	{
		System.out.println("executepreSave method called");
		String sql = "";			
		String tranId = "";
		String transMode = "", replOrder = "";
		
		int deleteCount = 0;
		
		ResultSet rs = null;
		PreparedStatement pstmt = null;

		try
		{			
			conn.setAutoCommit(false); 
			E12GenericUtility genericUtility = new E12GenericUtility();
			
			tranId = checkNull(genericUtility.getColumnValueFromNode("tran_id", dom.getElementsByTagName("Detail2").item(0)));
			if(tranId.trim().length() == 0)
			{
				System.out.println("tranId by getcvfn");
				tranId = checkNull(genericUtility.getColumnValue( "tranId", dom, "2" ));
				replOrder = checkNull(genericUtility.getColumnValue( "repl_order", dom, "2" ));
			}
			replOrder = checkNull(genericUtility.getColumnValue( "repl_order", dom, "2" ));
			System.out.println("-->replOrder ["+replOrder + "]");
			
			//if( tranId.trim().length() > 0 )
			//{
				//sql = "DELETE FROM repl_iss_det WHERE TRAN_ID= ?";	
				sql = "DELETE FROM repl_iss_det WHERE TRAN_ID in (select tran_id from repl_iss_hdr where repl_order = ?)";	
				
				pstmt =  conn.prepareStatement(sql);
				//pstmt.setString(1, tranId);
				pstmt.setString(1, replOrder);
				deleteCount = pstmt.executeUpdate();						
				if( deleteCount > 0 )
				{
					System.out.println( "Row with Tran_ID " + tranId + " repl_order + " + replOrder + " deleted from repl_ISS_DET table" );
				}						
				pstmt.close();
				pstmt = null;
				
				//sql = "DELETE FROM repl_iss_hdr WHERE TRAN_ID = ?";
				sql = "DELETE FROM repl_iss_hdr WHERE repl_order = ?";
				pstmt =  conn.prepareStatement(sql);
				//pstmt.setString(1, tranId);
				pstmt.setString(1, replOrder);
				deleteCount = pstmt.executeUpdate();						
				if( deleteCount > 0 )
				{
					System.out.println( "Row with Tran_ID " + tranId  + " repl_order + " + replOrder + "  deleted from REPL_ISS_HDR table" );
				}						
				pstmt.close();
				pstmt = null;

			//}
		}
		catch (SQLException sqe)
		{
			System.out.println("The SQLException occurs in ReplIssPrs :"+sqe);
			sqe.printStackTrace();
			throw new ITMException(sqe);
		}
		catch(Exception e)
		{
			System.out.println("The Exception occurs in ReplIssPrs :"+e);
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				System.err.println("Exception :ReplIssPrs :\n"+e.getMessage());
				e.printStackTrace();
				throw new ITMException(e);
			}
		}
		return "";
	}
	private String checkNull( String input )	
	{
		if ( input == null )
		{
			input = "";
		}
		return input;
	}		
}
