/*!
 * jQuery UI Core 1.10.3
 * http://jqueryui.com
 *
 * Copyright 2013 jQuery Foundation and other contributors
 * Released under the MIT license.
 * http://jquery.org/license
 *
 * http://api.jqueryui.com/category/ui-core/
 */

jQuery.ui || (function($) {

var isFF2 = $.browser.mozilla && (parseFloat($.browser.version) < 1.9);

//Helper functions and ui object
$.ui = {
        version: "@VERSION",

        // $.ui.plugin is deprecated.  Use the proxy pattern instead.
        plugin: {
                add: function(module, option, set) {
                        var proto = $.ui[module].prototype;
                        for(var i in set) {
                                proto.plugins[i] = proto.plugins[i] || [];
                                proto.plugins[i].push([option, set[i]]);
                        }
                },
                call: function(instance, name, args) {
                        var set = instance.plugins[name];
                        if(!set || !instance.element[0].parentNode) { return; }

                        for (var i = 0; i < set.length; i++) {
                                if (instance.options[set[i][0]]) {
                                        set[i][1].apply(instance.element, args);
                                }
                        }
                }
        },

        contains: function(a, b) {
                return document.compareDocumentPosition
                        ? a.compareDocumentPosition(b) & 16
                        : a !== b && a.contains(b);
        },

        hasScroll: function(el, a) {

                //If overflow is hidden, the element might have extra content, but the user wants to hide it
                if ($(el).css('overflow') == 'hidden') { return false; }

                var scroll = (a && a == 'left') ? 'scrollLeft' : 'scrollTop',
                        has = false;

                if (el[scroll] > 0) { return true; }

                // TODO: determine which cases actually cause this to happen
                // if the element doesn't have the scroll set, see if it's possible to
                // set the scroll
                el[scroll] = 1;
                has = (el[scroll] > 0);
                el[scroll] = 0;
                return has;
        },

        isOverAxis: function(x, reference, size) {
                //Determines when x coordinate is over "b" element axis
                return (x > reference) && (x < (reference + size));
        },

        isOver: function(y, x, top, left, height, width) {
                //Determines when x, y coordinates is over "b" element
                return $.ui.isOverAxis(y, top, height) && $.ui.isOverAxis(x, left, width);
        },

        keyCode: {
                BACKSPACE: 8,
                CAPS_LOCK: 20,
                COMMA: 188,
                CONTROL: 17,
                DELETE: 46,
                DOWN: 40,
                END: 35,
                ENTER: 13,
                ESCAPE: 27,
                HOME: 36,
                INSERT: 45,
                LEFT: 37,
                NUMPAD_ADD: 107,
                NUMPAD_DECIMAL: 110,
                NUMPAD_DIVIDE: 111,
                NUMPAD_ENTER: 108,
                NUMPAD_MULTIPLY: 106,
                NUMPAD_SUBTRACT: 109,
                PAGE_DOWN: 34,
                PAGE_UP: 33,
                PERIOD: 190,
                RIGHT: 39,
                SHIFT: 16,
                SPACE: 32,
                TAB: 9,
                UP: 38
        }
};

//jQuery plugins
$.fn.extend({
        _focus: $.fn.focus,
        focus: function(delay, fn) {
                return typeof delay === 'number'
                        ? this.each(function() {
                                var elem = this;
                                setTimeout(function() {
                                        $(elem).focus();
                                        (fn && fn.call(elem));
                                }, delay);
                        })
                        : this._focus.apply(this, arguments);
        },
        
        enableSelection: function() {
                return this
                        .attr('unselectable', 'off')
                        .css('MozUserSelect', '')
                        .unbind('selectstart.ui');
        },

        disableSelection: function() {
                return this
                        .attr('unselectable', 'on')
                        .css('MozUserSelect', 'none')
                        .bind('selectstart.ui', function() { return false; });
        },

        scrollParent: function() {
                var scrollParent;
                if(($.browser.msie && (/(static|relative)/).test(this.css('position'))) || (/absolute/).test(this.css('position'))) {
                        scrollParent = this.parents().filter(function() {
                                return (/(relative|absolute|fixed)/).test($.curCSS(this,'position',1)) && (/(auto|scroll)/).test($.curCSS(this,'overflow',1)+$.curCSS(this,'overflow-y',1)+$.curCSS(this,'overflow-x',1));
                        }).eq(0);
                } else {
                        scrollParent = this.parents().filter(function() {
                                return (/(auto|scroll)/).test($.curCSS(this,'overflow',1)+$.curCSS(this,'overflow-y',1)+$.curCSS(this,'overflow-x',1));
                        }).eq(0);
                }

                return (/fixed/).test(this.css('position')) || !scrollParent.length ? $(document) : scrollParent;
        },

        zIndex: function(zIndex) {
                if (zIndex !== undefined) {
                        return this.css('zIndex', zIndex);
                }
                
                if (this.length) {
                        var elem = $(this[0]), position, value;
                        while (elem.length && elem[0] !== document) {
                                // Ignore z-index if position is set to a value where z-index is ignored by the browser
                                // This makes behavior of this function consistent across browsers
                                // WebKit always returns auto if the element is positioned
                                position = elem.css('position');
                                if (position == 'absolute' || position == 'relative' || position == 'fixed')
                                {
                                        // IE returns 0 when zIndex is not specified
                                        // other browsers return a string
                                        // we ignore the case of nested elements with an explicit value of 0
                                        // <div style="z-index: -10;"><div style="z-index: 0;"></div></div>
                                        value = parseInt(elem.css('zIndex'));
                                        if (!isNaN(value) && value != 0) {
                                                return value;
                                        }
                                }
                                elem = elem.parent();
                        }
                }

                return 0;
        }
});


//Additional selectors
$.extend($.expr[':'], {
        data: function(elem, i, match) {
                return !!$.data(elem, match[3]);
        },

        focusable: function(element) {
                var nodeName = element.nodeName.toLowerCase(),
                        tabIndex = $.attr(element, 'tabindex');
                return (/input|select|textarea|button|object/.test(nodeName)
                        ? !element.disabled
                        : 'a' == nodeName || 'area' == nodeName
                                ? element.href || !isNaN(tabIndex)
                                : !isNaN(tabIndex))
                        // the element and all of its ancestors must be visible
                        // the browser may report that the area is hidden
                        && !$(element)['area' == nodeName ? 'parents' : 'closest'](':hidden').length;
        },

        tabbable: function(element) {
                var tabIndex = $.attr(element, 'tabindex');
                return (isNaN(tabIndex) || tabIndex >= 0) && $(element).is(':focusable');
        }
});

})(jQuery);

