package ibase.webitm.ejb.gst;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;

import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.ejb.fin.FinCommon;
import ibase.webitm.util.gst.GSTCommonUtil;
import ibase.webitm.utility.ITMException;

import javax.ejb.Stateless;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/**
 * Session Bean implementation class GstrIC
 */
@Stateless
public class GstrPurchaseIC extends ValidatorEJB implements GstrPurchaseICRemote, GstrPurchaseICLocal 
{
	E12GenericUtility genericUtility = new E12GenericUtility();
	GSTCommonUtil gstUtility = new GSTCommonUtil();
	String GSTINFORMAT_REGEX = "[0-9]{2}[a-zA-Z]{5}[0-9]{4}[a-zA-Z]{1}[1-9A-Za-z]{1}[Z]{1}[0-9a-zA-Z]{1}";
	String GSTN_CODEPOINT_CHARS = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";
	
	public String wfValData(String xmlString, String xmlString1,String xmlString2, String objContext, String editFlag,String xtraParams) throws RemoteException, ITMException 
	{
		Document dom = null; 
   		Document dom1 = null; 
   		Document dom2 = null;
   		String retString = "";	
   		try
   		{
   			System.out.println("*************** Inside wfValData *******************");  
    	    System.out.println("xmlString::::::::::::"+xmlString);
    	    System.out.println("xmlString1::::::::::::"+xmlString1);
    	    System.out.println("xmlString2::::::::::::"+xmlString2);
    	    
	   		if(xmlString != null && xmlString.trim().length()>0)
	   		{
	   			dom = genericUtility.parseString(xmlString);		
	   		}
	   		if(xmlString1 != null && xmlString1.trim().length()>0)
	   		{
	   			dom1 = genericUtility.parseString(xmlString1);
	   		}
	   		if(xmlString2 != null && xmlString2.trim().length()>0)
	   		{
	   			dom2 = genericUtility.parseString(xmlString2);
	   		}
	   		retString = wfValData(dom,dom1,dom2,objContext,editFlag,xtraParams);
	   		System.out.println("errorString::::::::::"+retString);
		}
        catch(Exception e)
        {
        	System.out.println(":::" + getClass().getSimpleName() + "::"+ e.getMessage());
			e.getMessage(); 
        }
        return retString;	    
	}
	
	public String wfValData(Document dom, Document dom1, Document dom2,String objContext, String editFlag, String xtraParams)throws RemoteException, ITMException 
	{
		E12GenericUtility genericUtility = new E12GenericUtility();
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null ;
		String sql="";
		String userId = "";
		int currentFormNo = 0;
		NodeList parentNodeList = null;
		Node parentNode = null;
		NodeList childNodeList = null;
		Node childNode = null;
		int childNodeLength = 0;
	    int ctr = 0, cnt = 0,cnt2=0,finalGstRate=0;
		String childNodeName = "";
		String errorType = "",errString="",cust_name="";
		String errCode = "";
		ArrayList<String> errList = new ArrayList<String>();
		ArrayList<String> errFields = new ArrayList<String>();
		String tran_type="",gst_type="",gst_rate="",finalCode="",rec_type="";
		String state_code="",tax_reg_no = "",itc_type="",state_code_cdn="",gstnStateCode="";
		StringBuffer errStringXml = new StringBuffer("<?xml version = \"1.0\"?> \r\n <Root> <Errors>");
		String doc_type="",doc_date="",amount="",doc_no="",ecom_reg_no="",loginSite="",gs_code="",gs_descr="";
		String quantity="",unit="",taxable_amt="",igst_perc="",igst_amt="",cgst_amt="",sgst_amt="",cess_amt="";
		String ref_id__inv="",ref_date__inv="",lr_no="",lr_date="",supply_type="",cgst_perc="",sgst_perc="",reverse_chrg="";
		String name="",addr1="",addr2="",addr3="",city="",state="",pin="",loginSiteCode="",ecomRegNo="",orderNo="";
		double cgst_amtVal=0.0,sgst_amtVal=0.0,cgst_percVal=0.0,sgst_percVal=0.0;
		double igst_percVal=0.0,igst_amtVal=0.0,gstRate=0.0,finalAmt=0.0;
		String refIdInv="",gstCode="",itc_igst = "",itc_cgst="",itc_sgst="",itc_cess="";
		
		Timestamp refInvDateDate = null,invDate = null;
		try
		{	
			conn = getConnection();
			userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginCode"); 
			loginSite = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginSiteCode");
		    
			if(objContext != null && objContext.trim().length()>0)
		    {
				currentFormNo = Integer.parseInt(objContext); //System.out.println("currentFormNo:::"+currentFormNo);
			   	    
				switch(currentFormNo)
		    	{
		    		case 1:
		    		{	
		    			parentNodeList = dom.getElementsByTagName("Detail1");
		    			parentNode = parentNodeList.item(0);
		    			childNodeList = parentNode.getChildNodes();
		    			childNodeLength = childNodeList.getLength();
		    			
		    			for(ctr = 0; ctr < childNodeLength; ctr++)
		    			{
		    				childNode =  childNodeList.item(ctr);
		    				childNodeName = childNode.getNodeName();
		    				if("gst_type".equalsIgnoreCase(childNodeName))
		    				{
		    			    	gst_type = gstUtility.checkNull(genericUtility.getColumnValue("gst_type", dom)).trim();//System.out.println("childNodeName:::"+childNodeName+"childNode["+childNode+"]"+"gst_type["+gst_type+"]");
		    					if(gst_type == null || gst_type.trim().length() == 0)
		    					{
		    						errCode = "NULLDOCTYP";
		    						errList.add(errCode);
		    						errFields.add(childNodeName.toLowerCase());
		    					}
		    					else
		    					{
		    						gst_type = gstUtility.checkNull(genericUtility.getColumnValue("gst_type", dom)).trim();
		    						sql = "select count(*) as cnt from gencodes where fld_name='GST_TYPE' and mod_name='W_GSTR_PURC' and fld_value=?";
		    						pstmt = conn.prepareStatement(sql);
		    						pstmt.setString(1,gst_type);
		    						rs = pstmt.executeQuery();
		    						if(rs.next())
		    						{
		    							cnt = rs.getInt("cnt");
		    						}
		    						if(pstmt != null)
									{
									    pstmt.close(); 
									    pstmt = null;
									}
									if(rs != null)
									{
										rs.close();
									    rs = null;
									} 
		    						if(cnt==0)
		    						{
		    							errCode = "INVDOCUMEN";
		    							errList.add(errCode);
		    							errFields.add(childNodeName.toLowerCase());	
		    						}
		    					}	
		    				}//end of if block for gst_type
		    			    
		    			    else if("doc_type".equalsIgnoreCase(childNodeName))
		    			    {
		    			    	doc_type = gstUtility.checkNull(genericUtility.getColumnValue("doc_type", dom)).trim();
		    			    	gst_type = gstUtility.checkNull(genericUtility.getColumnValue("gst_type", dom)).trim();//System.out.println("INPUT VALUE"+"Document Type is ["+doc_type+"]"+"gst_type["+gst_type+"]");
		    			    }//end of if block for doc_type
		    			    
		    			    else if("tax_reg_no".equalsIgnoreCase(childNodeName))
		    			    {
		    			    	gst_type = gstUtility.checkNull(genericUtility.getColumnValue("gst_type", dom)).trim();
		    			    	tax_reg_no = gstUtility.checkNull(genericUtility.getColumnValue("tax_reg_no", dom)).trim();//System.out.println("INPUT VALUE"+"tax_reg_no["+tax_reg_no+"]"+"gst_type["+gst_type+"]");	
		    			    }//end of if block for tax_reg_no
		    			    
		    			    else if("name".equalsIgnoreCase(childNodeName))
		    			    {
		    			    	tax_reg_no = gstUtility.checkNull(genericUtility.getColumnValue("tax_reg_no", dom)).trim();
		    			    	gst_type = gstUtility.checkNull(genericUtility.getColumnValue("gst_type", dom)).trim();
		    			    	name = gstUtility.checkNull(genericUtility.getColumnValue("name", dom)).trim(); //System.out.println("INPUT VALUE"+"tax_reg_no["+tax_reg_no+"]"+"gst_type["+gst_type+"]"+"name["+name+"]");
		    			    }//end of if block for name
		    			    
		    			    else if("addr1".equalsIgnoreCase(childNodeName))
		    			    {
		    			    	tax_reg_no = gstUtility.checkNull(genericUtility.getColumnValue("tax_reg_no", dom)).trim();
		    			    	gst_type = gstUtility.checkNull(genericUtility.getColumnValue("gst_type", dom)).trim();
		    			    	addr1 = gstUtility.checkNull(genericUtility.getColumnValue("addr1", dom)).trim();//System.out.println("INPUT VALUE"+"tax_reg_no["+tax_reg_no+"]"+"gst_type["+gst_type+"]"+"addr1["+addr1+"]");
		    			    }//end of if block for addr1
		    			    
		    			    else if("addr2".equalsIgnoreCase(childNodeName))
		    			    {
		    			    	tax_reg_no = gstUtility.checkNull(genericUtility.getColumnValue("tax_reg_no", dom)).trim();
		    			    	gst_type = gstUtility.checkNull(genericUtility.getColumnValue("gst_type", dom)).trim();
		    			    	addr2 = gstUtility.checkNull(genericUtility.getColumnValue("addr2", dom)).trim();//System.out.println("INPUT VALUE"+"tax_reg_no["+tax_reg_no+"]"+"gst_type["+gst_type+"]"+"addr2["+addr2+"]");
		    			    }//end of if block for addr2
		    			    
		    			    else if("addr3".equalsIgnoreCase(childNodeName))
		    			    {
		    			    	tax_reg_no = gstUtility.checkNull(genericUtility.getColumnValue("tax_reg_no", dom)).trim();
		    			    	gst_type = gstUtility.checkNull(genericUtility.getColumnValue("gst_type", dom)).trim();
		    			    	addr3 = gstUtility.checkNull(genericUtility.getColumnValue("addr3", dom)).trim();//System.out.println("INPUT VALUE"+"tax_reg_no["+tax_reg_no+"]"+"gst_type["+gst_type+"]"+"addr3["+addr3+"]");
		    			    }//end of if block for addr3
		    			    
		    			    else if("city".equalsIgnoreCase(childNodeName))
		    			    {
		    			    	tax_reg_no = gstUtility.checkNull(genericUtility.getColumnValue("tax_reg_no", dom)).trim();
		    			    	gst_type = gstUtility.checkNull(genericUtility.getColumnValue("gst_type", dom)).trim();
		    			    	city = gstUtility.checkNull(genericUtility.getColumnValue("city", dom)).trim();//System.out.println("INPUT VALUE"+"tax_reg_no["+tax_reg_no+"]"+"gst_type["+gst_type+"]"+"city["+city+"]");
		    			    }//end of if block for city
		    			    
		    			    else if("gst_state_code".equalsIgnoreCase(childNodeName))
		    			    {
		    			    	tax_reg_no = gstUtility.checkNull(genericUtility.getColumnValue("tax_reg_no", dom)).trim();
		    			    	gst_type = gstUtility.checkNull(genericUtility.getColumnValue("gst_type", dom)).trim();
		    			    	state = gstUtility.checkNull(genericUtility.getColumnValue("gst_state_code", dom)).trim();//System.out.println("INPUT VALUE"+"tax_reg_no["+tax_reg_no+"]"+"gst_type["+gst_type+"]"+"state["+state+"]");
		    			    }//end of if block for state
		    			    
		    			    else if("pin".equalsIgnoreCase(childNodeName))
		    			    {
		    			    	tax_reg_no = gstUtility.checkNull(genericUtility.getColumnValue("tax_reg_no", dom)).trim();
		    			    	gst_type = gstUtility.checkNull(genericUtility.getColumnValue("gst_type", dom)).trim();
		    			    	pin = gstUtility.checkNull(genericUtility.getColumnValue("pin", dom)).trim();//System.out.println("INPUT VALUE"+"tax_reg_no["+tax_reg_no+"]"+"gst_type["+gst_type+"]"+"pin["+pin+"]");
		    			    }//end of if block for pin
		    				
		    				else if("cust_name".equalsIgnoreCase(childNodeName))
		    			    {
		    			    	gst_type = gstUtility.checkNull(genericUtility.getColumnValue("gst_type", dom)).trim();
		    			    	cust_name = gstUtility.checkNull(genericUtility.getColumnValue("cust_name", dom)).trim();//System.out.println("INPUT VALUE"+"tax_reg_no["+tax_reg_no+"]"+"gst_type["+gst_type+"]"+"name["+name+"]");
		    			    }//end of if block for name
		    				
		    			    else if("gst_code_state".equalsIgnoreCase(childNodeName))
		    			    {
		    			    	gst_type = gstUtility.checkNull(genericUtility.getColumnValue("gst_type", dom)).trim();
		    			    	state_code = gstUtility.checkNull(genericUtility.getColumnValue("gst_code_state", dom)).trim();
		    			    	doc_type = gstUtility.checkNull(genericUtility.getColumnValue("doc_type", dom)).trim();//System.out.println("INPUT VALUE"+"gst_type["+gst_type+"]"+"gst_code_state["+state_code+"]");
		    			    }//end of if block for gst_code_state
		    			    
		    			    else if("doc_no".equalsIgnoreCase(childNodeName))
		    			    {
		    			    	gst_type = gstUtility.checkNull(genericUtility.getColumnValue("gst_type", dom)).trim();
		    			    	doc_no = gstUtility.checkNull(genericUtility.getColumnValue("doc_no", dom)).trim();//System.out.println("INPUT VALUE"+"gst_type["+gst_type+"]"+"doc_no["+doc_no+"]");
		    			    }//end of if block for doc_no
		    			    
		    			    else if("doc_date".equalsIgnoreCase(childNodeName))
		    			    {
		    			    	gst_type = gstUtility.checkNull(genericUtility.getColumnValue("gst_type", dom)).trim();
		    			    	doc_date = gstUtility.checkNull(genericUtility.getColumnValue("doc_date", dom)).trim();//System.out.println("INPUT VALUE"+"gst_type["+gst_type+"]"+"doc_date["+doc_date+"]");
		    			    }//end of if block for doc_date
		    			    
		    			    else if("amount".equalsIgnoreCase(childNodeName))
		    			    {
		    			    	gst_type = gstUtility.checkNull(genericUtility.getColumnValue("gst_type", dom)).trim();
		    			    	amount = gstUtility.checkNull(genericUtility.getColumnValue("amount", dom)).trim();//System.out.println("INPUT VALUE"+"gst_type["+gst_type+"]"+"amount["+amount+"]");	
		    			    }//end of if block for amount
		    			   
		    			    else if("reverse_chrg".equalsIgnoreCase(childNodeName))
		    			    {
		    			    	gst_type = gstUtility.checkNull(genericUtility.getColumnValue("gst_type", dom)).trim();
		    			    	reverse_chrg = gstUtility.checkNull(genericUtility.getColumnValue("reverse_chrg", dom)).trim();//System.out.println("INPUT VALUE"+"gst_type["+gst_type+"]"+"reverse_chrg["+reverse_chrg+"]");	    	
		    			    }//end of if block for reverse_chrg
		    			    
		    			    else if("ecom_reg_no".equalsIgnoreCase(childNodeName))
		    			    {
		    			    	gst_type = gstUtility.checkNull(genericUtility.getColumnValue("gst_type", dom)).trim();
		    			    	doc_type = gstUtility.checkNull(genericUtility.getColumnValue("doc_type", dom)).trim();
		    			    	ecomRegNo = gstUtility.checkNull(genericUtility.getColumnValue("ecom_reg_no", dom)).trim();//System.out.println("INPUT VALUE"+"gst_type["+gst_type+"]"+"doc_type["+doc_type+"]"+"ecomRegNo["+ecomRegNo+"]");
		    			    }//end of if block for ecom_reg_no
		    			    
		    			    else if("ref_id__inv".equalsIgnoreCase(childNodeName))
		    			    {
		    			    	gst_type = gstUtility.checkNull(genericUtility.getColumnValue("gst_type", dom)).trim();
		    			    	ref_id__inv = gstUtility.checkNull(genericUtility.getColumnValue("ref_id__inv", dom)).trim();//System.out.println("INPUT VALUE"+"gst_type["+gst_type+"]"+"ref_id__inv["+ref_id__inv+"]");
		    			    }//end of if block for ref_id__inv
		    			    
		    			    else if("ref_date__inv".equalsIgnoreCase(childNodeName))
		    			    {
		    			    	gst_type = gstUtility.checkNull(genericUtility.getColumnValue("gst_type", dom)).trim();
		    			    	ref_date__inv = gstUtility.checkNull(genericUtility.getColumnValue("ref_date__inv", dom)).trim();//System.out.println("INPUT VALUE"+"gst_type["+gst_type+"]"+"ref_date__inv["+ref_date__inv+"]");  			   
		    			    }//end of if block for ref_date__inv 
		    			    
		    			    else if("order_no".equalsIgnoreCase(childNodeName))
		    			    {
		    			    	gst_type = gstUtility.checkNull(genericUtility.getColumnValue("gst_type", dom)).trim();
		    			        orderNo = gstUtility.checkNull(genericUtility.getColumnValue("order_no", dom)).trim();//System.out.println("INPUT VALUE"+"gst_type["+gst_type+"]"+"orderNo["+orderNo+"]");
		    			    }//end of if block for order_no
		    			    
		    			    else if("lr_no".equalsIgnoreCase(childNodeName))
		    			    {
		    			    	gst_type = gstUtility.checkNull(genericUtility.getColumnValue("gst_type", dom)).trim();
		    			    	lr_no = gstUtility.checkNull(genericUtility.getColumnValue("lr_no", dom)).trim();//System.out.println("INPUT VALUE"+"gst_type["+gst_type+"]"+"lr_no["+lr_no+"]");
		    			    }//end of if block for lr_no
		    			    
		    			    else if("lr_date".equalsIgnoreCase(childNodeName))
		    			    {
		    			    	gst_type = gstUtility.checkNull(genericUtility.getColumnValue("gst_type", dom)).trim();
		    			    	lr_date = gstUtility.checkNull(genericUtility.getColumnValue("lr_date", dom)).trim();//System.out.println("INPUT VALUE"+"gst_type["+gst_type+"]"+"lr_date["+lr_date+"]");   
		    			    }//end of if block for lr_date
		    			}//end of for loop  
		    			
		    			
		    			// **************************** Validation for DOC_TYPE [start] ***************************************
		    			if(doc_type == null || doc_type.trim().length() == 0)
						{
		    				if("I".equalsIgnoreCase(gst_type))
		    				{
								errCode = "NULDOCTYPE";
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());
		    				}
						}
		    			// *************************** Validation for DOC_TYPE [end] ****************************************
		    			
		    			// *************************** Validation for tax_reg_no [start] ************************************
		    			if("I".equalsIgnoreCase(gst_type))
		    			{
		    				if(tax_reg_no == null || tax_reg_no.trim().length() == 0)
		    				{
		    					errCode = "VTNLGSTIN";
		    					errList.add(errCode);
		    					errFields.add("tax_reg_no");
		    				}
		    			}		    			
		    			if("I".equalsIgnoreCase(gst_type) || "R".equalsIgnoreCase(gst_type) || "G".equalsIgnoreCase(gst_type) 
				    	|| "D".equalsIgnoreCase(gst_type) || "C".equalsIgnoreCase(gst_type))
		    			{
		    				if(tax_reg_no != null && tax_reg_no.trim().length() > 0)
		    				{
		    					boolean gstinNum = validGSTIN(tax_reg_no,conn);
		    					System.out.println("Value of Validate GSTIN Number ====["+gstinNum+"]");
		    					if(!(gstinNum == true))
		    					{
			    					errCode = "VMGTINCODE";
			    					errList.add(errCode);
			    					errFields.add("tax_reg_no");
		    					}
		    				}
		    			}
              			// *************************** Validation for tax_reg_no [end] ***************************************
		    			
		    			// *************************** Validation for name [start] *******************************************
		    			if(tax_reg_no != null && tax_reg_no.trim().length() > 0)
		    			{
		    				if(name == null || name.trim().length() == 0)
			    			{
		    					errCode = "VMCNAMENLL";
		    					errList.add(errCode);
		    					errFields.add("name");
			    			 }
		    			 }
		    			// *************************** Validation for name [end] *********************************************
		    				    			
		    			// *************************** Validation for cust_name [start] *******************************************
		    			if("U".equalsIgnoreCase(gst_type))
			    		{
			    			if(cust_name == null || cust_name.trim().length() == 0)
			    			{
			    				errCode = "VMATTDET01";
		    					errList.add(errCode);
		    					errFields.add("cust_name");
			    			}
			    		}
		    			// *************************** Validation for cust_name [end] *********************************************
		    				
		    			// **************************** Validation for Place of  Supply [start] ******************************
		    			if("I".equalsIgnoreCase(gst_type) && ("R".equalsIgnoreCase(doc_type)) || "R".equalsIgnoreCase(gst_type) || "U".equalsIgnoreCase(gst_type) 
		    			|| "S".equalsIgnoreCase(gst_type) || "A".equalsIgnoreCase(gst_type) || "T".equalsIgnoreCase(gst_type))
		    			{	
		    				if(state_code == null || state_code.trim().length() == 0)
		    				{
		    					errCode = "NULLPLSUPP";
		    					errList.add(errCode);
		    					errFields.add("gst_code_state");
		    				}	
		    			}
		    			//commented validation for doc type DE and SEZ on 14AUG2017[START]
		    		/*	else if("I".equalsIgnoreCase(gst_type))
		    			{
		    				if("DE".equalsIgnoreCase(doc_type) || "Z".equalsIgnoreCase(doc_type))
		    				{
		    					state_code = gstUtility.checkNull(genericUtility.getColumnValue("gst_code_state", dom1)).trim();
		    					loginSiteCode = gstUtility.checkNull(getStateFromLoginSite(loginSite,conn));
		    					if((state_code != null) && (state_code.equalsIgnoreCase(loginSiteCode)))
		    					{
		    						errCode = "INVDPLSUPP";
			    					errList.add(errCode);
			    					errFields.add("state_code");
		    					}
		    				}
		    			}*/
		    			//commented validation for doc type DE and SEZ on 14AUG2017[END]
		    			// *************************** Validation for Place of  Supply [end] *********************************
		    			
		    			// *************************** Validation for Document Number [start] ********************************
		    			if("I".equalsIgnoreCase(gst_type) || "R".equalsIgnoreCase(gst_type) || "U".equalsIgnoreCase(gst_type) 
		    			|| "S".equalsIgnoreCase(gst_type) || "D".equalsIgnoreCase(gst_type) || "C".equalsIgnoreCase(gst_type))
		    			{
		    				if(doc_no == null || doc_no.trim().length() == 0)
			    			{
			    				errCode = "NULLDOCNUM";
			    				errList.add(errCode);
			    				errFields.add("doc_no");
			    			}
		   				}
		    			// ************************** Validation for Document Number [end] ***********************************
		    			
		    			// ************************** Validation for Document Date [start] ***********************************
		    			if("I".equalsIgnoreCase(gst_type) || "R".equalsIgnoreCase(gst_type) || "U".equalsIgnoreCase(gst_type) 
				    	|| "S".equalsIgnoreCase(gst_type) || "D".equalsIgnoreCase(gst_type) || "C".equalsIgnoreCase(gst_type)
				    	|| "L".equalsIgnoreCase(gst_type) || "A".equalsIgnoreCase(gst_type) || "T".equalsIgnoreCase(gst_type))
		    			{
		    			   	if(doc_date == null || doc_date.trim().length() == 0)
		    				{
		    					errCode = "INVDOCDATE";
		    					errList.add(errCode);
		    					errFields.add("doc_date");
		    				}
		    				else if(doc_date != null && doc_date.trim().length() > 0)
		    				{
			    				 finalCode = gstUtility.checkNull(genericUtility.getColumnValue("prd_code", dom));
			    				 rec_type = gstUtility.checkNull(genericUtility.getColumnValue("rec_type", dom));
			    				 System.out.println("finalCode::["+finalCode+"]"+"loginSiteCode ::["+loginSite+"]");
			    				 sql = "select count(*) as cnt from gst_data_hdr where prd_code=? and rec_type=? and site_code=? and submit_status=?";
			    				 pstmt = conn.prepareStatement(sql);
								 pstmt.setString(1,finalCode);
								 pstmt.setString(2,rec_type);
								 pstmt.setString(3,loginSite);
								 pstmt.setString(4,"S");
								 rs = pstmt.executeQuery();
								 if(rs.next())
								 {
									 cnt = rs.getInt("cnt");
								 }
								 if(pstmt != null)
								 {
									pstmt.close(); 
									pstmt = null;
								 }
								 if(rs != null)
								 {
									rs.close();
									rs = null;
								 }
								 if(cnt > 0)
								 {
									 errCode = "INVTRANACT";
									 errList.add(errCode);
									 errFields.add("doc_date");
								 }
		    				}
		    			}
		    			// ************************** Validation for Document Date [end] *************************************
		    			
		    			// ************************** Validation for Amount [start] ******************************************
		    			if("I".equalsIgnoreCase(gst_type) || "R".equalsIgnoreCase(gst_type) || "U".equalsIgnoreCase(gst_type) 
				    	|| "S".equalsIgnoreCase(gst_type) || "G".equalsIgnoreCase(gst_type) || "D".equalsIgnoreCase(gst_type) || "C".equalsIgnoreCase(gst_type)
				    	|| "A".equalsIgnoreCase(gst_type) || "T".equalsIgnoreCase(gst_type))
				    	{
				    	   	if(amount == null || amount.trim().length() == 0)
				    		{
		    					errCode = "VTAMTNULL";
				    			errList.add(errCode);
				    			errFields.add("amount");
				    		}
				    	}
		    			// ************************* Validation for Amount [end] *********************************************  
		    			    			
		    			// ************************* Validation for ref_id__inv [start] **************************************
		    			if("D".equalsIgnoreCase(gst_type) || "C".equalsIgnoreCase(gst_type))
		    			{
		    				if(ref_id__inv == null || ref_id__inv.trim().length() == 0)
			    			{
			    				errCode = "NULLINVCNM";
			    				errList.add(errCode);
			    				errFields.add("ref_id__inv");
			    			}
			    			else if(ref_id__inv != null && ref_id__inv.trim().length() > 0)
			    			{
			    				sql = "select count(*) as cnt from gst_data_hdr where doc_no=?";
			    				pstmt = conn.prepareStatement(sql);
								pstmt.setString(1,ref_id__inv);
								rs = pstmt.executeQuery();
								if(rs.next())
								{
									cnt = rs.getInt("cnt");
									System.out.println("count is::::["+cnt+"]");
								}
								if(cnt == 0)
								{
									errCode = "INVINVCNM";
				    				errList.add(errCode);
				    				errFields.add("ref_id__inv");
								}
								if(pstmt != null)
								{
									pstmt.close(); 
									pstmt = null;
								}
								if(rs != null)
								{
									rs.close();
									rs = null;
								}			
			    			}
		    			}
		    			// ************************* Validation for ref_id__inv [end] **********************************************
		    			
		    			// ************************* Validation for ref_date_inv [start] *******************************************
		    			if("D".equalsIgnoreCase(gst_type) || "C".equalsIgnoreCase(gst_type))
		    			{
			    			if(ref_date__inv == null || ref_date__inv.trim().length() == 0)
			    			{	
			    				errCode = "NULLINVCDT";
			    				errList.add(errCode);
			    				errFields.add("ref_date__inv");
			    			}
		    			}
		    			// ************************* Validation for ref_date__inv [end] *********************************************
		    			    		    
		    			// ******************* Validation for Shipping Bill Number: [start] *****************************************
			    		   	if("G".equalsIgnoreCase(gst_type))
	    					{
	    						System.out.println("lr_no is ["+lr_no+"]");
	    						if(lr_no == null || lr_no.trim().length() == 0)
	    						{
	    							errCode = "NULLLRNUMB";
	    							errList.add(errCode);
	    							errFields.add("lr_no");
	    						}
	    					}
			    			// ******************* Validation for Shipping Bill Number: [end] ***************************************
			    			
			    			// ******************* Validation for Shipping Bill Date [start] ****************************************
			    			if("G".equalsIgnoreCase(gst_type))
	    					{
	    						System.out.println("lr_date is ["+lr_date+"]");
	    						if(lr_date == null || lr_date.trim().length() == 0)
	    						{
	    							errCode = "NULLLRDATE";
	    							errList.add(errCode);
	    							errFields.add("lr_date");
	    						}
	    					}
			    			// ******************* Validation for Shipping Bill Date [end] *******************************************
		    		}//end of case1	    
		    		break;
		    		
		    		case 2:
		    		{
		    			parentNodeList = dom.getElementsByTagName("Detail2");
						parentNode = parentNodeList.item(0);
						childNodeList = parentNode.getChildNodes();
						childNodeLength = childNodeList.getLength();
								    				    			
		    			for(int ctr1=0;ctr1<childNodeLength;ctr1++)
		    			{
		    				childNode =  childNodeList.item(ctr1);
		    				childNodeName = childNode.getNodeName();
		    				System.out.println("childNodeNameForDetail2:::"+childNodeName+"childNode["+childNode+"]");
		    				if("gs_code".equalsIgnoreCase(childNodeName))
		    				{
		    					gst_type = gstUtility.checkNull(genericUtility.getColumnValue("gst_type", dom1)).trim();
		    					gs_code = gstUtility.checkNull(genericUtility.getColumnValue("gs_code", dom)).trim();//System.out.println("INPUT VALUE"+"gst_type["+gst_type+"]"+"gs_code["+gs_code+"]");
		    				}//end of if block for GS Code
		    				
		    				else if("quantity".equalsIgnoreCase(childNodeName))
		    				{
		    					gst_type = gstUtility.checkNull(genericUtility.getColumnValue("gst_type", dom1)).trim();
		    					quantity = gstUtility.checkNull(genericUtility.getColumnValue("quantity", dom)).trim();//System.out.println("INPUT VALUE"+"gst_type["+gst_type+"]"+"quantity["+quantity+"]");
		    				}//end of if block for quantity
		    				
		    				else if("unit".equalsIgnoreCase(childNodeName))
		    				{
		    					gst_type = gstUtility.checkNull(genericUtility.getColumnValue("gst_type", dom1)).trim();
		    					unit = gstUtility.checkNull(genericUtility.getColumnValue("unit", dom)).trim();//System.out.println("INPUT VALUE"+"gst_type["+gst_type+"]"+"unit["+unit+"]");	
		    				}//end of if block for unit
		    				
		    				else if("taxable_amt".equalsIgnoreCase(childNodeName))
		    				{
		    					gst_type = gstUtility.checkNull(genericUtility.getColumnValue("gst_type", dom1)).trim();
		    					taxable_amt = gstUtility.checkNull(genericUtility.getColumnValue("taxable_amt", dom)).trim();//System.out.println("INPUT VALUE"+"gst_type["+gst_type+"]"+"taxable_amt["+taxable_amt+"]");	
		    					amount = gstUtility.checkNull(genericUtility.getColumnValue("amount", dom1)).trim(); 
		    				}//end of if block for taxable_amt
		    				
		    				else if("gst_rate".equalsIgnoreCase(childNodeName))
		    				{
		    					gst_type = gstUtility.checkNull(genericUtility.getColumnValue("gst_type", dom1)).trim();
		    					doc_type = gstUtility.checkNull(genericUtility.getColumnValue("doc_type", dom1)).trim();
		    					gst_rate = gstUtility.checkNull(genericUtility.getColumnValue("gst_rate", dom)).trim();
		    					gstRate = converStringToDouble(gstUtility.checkNull(genericUtility.getColumnValue("gst_rate", dom)).trim());
		    					taxable_amt = gstUtility.checkNull(genericUtility.getColumnValue("taxable_amt", dom)).trim();//System.out.println("INPUT VALUE"+"gst_type["+gst_type+"]"+"doc_type["+doc_type+"]"+"gst_rate["+gst_rate+"]"+"gstRate["+gstRate+"]"+"taxable_amt["+taxable_amt+"]");	
		    				}//end of if block for gst_rate
		    				
		    				else if("igst_perc".equalsIgnoreCase(childNodeName))
		    				{
		    					gst_type = gstUtility.checkNull(genericUtility.getColumnValue("gst_type", dom1)).trim();
		    					state_code = gstUtility.checkNull(genericUtility.getColumnValue("gst_code_state", dom1)).trim();
		    					loginSiteCode = gstUtility.checkNull(getStateFromLoginSite(loginSite,conn));
		    					igst_perc = gstUtility.checkNull(genericUtility.getColumnValue("igst_perc", dom)).trim();
		    					igst_percVal = converStringToDouble(gstUtility.checkNull(genericUtility.getColumnValue("igst_perc", dom)).trim());
		    					//Added by sarita on 30.08.2017
		    					gstnStateCode = gstUtility.checkNull(genericUtility.getColumnValue("tax_reg_no", dom1)).substring(0,2);//Value of StateCode set by using Supplier GSTIN number first 2digit.
		    					//state_code_cdn = getGstCodeForCDNR(dom,conn);//System.out.println("INPUT VALUE"+"gst_type["+gst_type+"]"+"state_code["+state_code+"]"+"loginSiteCode["+loginSiteCode+"]"+"igst_perc["+igst_perc+"]"+"igst_percVal["+igst_percVal+"]");	
		    				}//end of if block for igst_perc
		    				
		    				else if("igst_amt".equalsIgnoreCase(childNodeName))
		    				{
		    					gst_type = gstUtility.checkNull(genericUtility.getColumnValue("gst_type", dom1)).trim();
		    					state_code = gstUtility.checkNull(genericUtility.getColumnValue("gst_code_state", dom1)).trim();
		    					loginSiteCode = gstUtility.checkNull(getStateFromLoginSite(loginSite,conn));
		    					igst_amt = gstUtility.checkNull(genericUtility.getColumnValue("igst_amt", dom)).trim();
		    					igst_amtVal = converStringToDouble(gstUtility.checkNull(genericUtility.getColumnValue("igst_amt", dom)).trim());
		    					//Added by sarita on 30.08.2017
		    					gstnStateCode = gstUtility.checkNull(genericUtility.getColumnValue("tax_reg_no", dom1)).substring(0,2);//Value of StateCode set by using Supplier GSTIN number first 2digit.
		    					//state_code_cdn = getGstCodeForCDNR(dom,conn);
		    					System.out.println("INPUT VALUE in Validation"+"gst_type["+gst_type+"]"+"state_code["+state_code+"]"+"loginSiteCode["+loginSiteCode+"]"+"igst_amt["+igst_amt+"]"+"igst_amtVal["+igst_amtVal+"]"+"gstnStateCode["+gstnStateCode+"]");
		    				}//end of if block for igst_amt
		    				
		    				else if("cgst_perc".equalsIgnoreCase(childNodeName))
		    				{
		    					gst_type = gstUtility.checkNull(genericUtility.getColumnValue("gst_type", dom1)).trim();
		    					state_code = gstUtility.checkNull(genericUtility.getColumnValue("gst_code_state", dom1)).trim();
		    					cgst_perc = gstUtility.checkNull(genericUtility.getColumnValue("cgst_perc", dom)).trim();
		    					loginSiteCode = gstUtility.checkNull(getStateFromLoginSite(loginSite,conn));
		    					cgst_percVal = converStringToDouble(gstUtility.checkNull(genericUtility.getColumnValue("cgst_perc", dom)).trim());
		    					//Added by sarita on 30.08.2017
		    					gstnStateCode = gstUtility.checkNull(genericUtility.getColumnValue("tax_reg_no", dom1)).substring(0,2);//Value of StateCode set by using Supplier GSTIN number first 2digit.
		    					//state_code_cdn = getGstCodeForCDNR(dom,conn);//System.out.println("INPUT VALUE"+"gst_type["+gst_type+"]"+"state_code["+state_code+"]"+"cgst_perc["+cgst_perc+"]"+"loginSiteCode["+loginSiteCode+"]"+"cgst_percVal["+cgst_percVal+"]");
		    				}//end of if block for cgst_perc
		    				
		    				else if("cgst_amt".equalsIgnoreCase(childNodeName))
		    				{
		    					gst_type = gstUtility.checkNull(genericUtility.getColumnValue("gst_type", dom1)).trim();
		    					state_code = gstUtility.checkNull(genericUtility.getColumnValue("gst_code_state", dom1)).trim();
		    					cgst_amt = gstUtility.checkNull(genericUtility.getColumnValue("cgst_amt", dom)).trim();
		    					loginSiteCode = gstUtility.checkNull(getStateFromLoginSite(loginSite,conn));
		    					cgst_amtVal = converStringToDouble(gstUtility.checkNull(genericUtility.getColumnValue("cgst_amt", dom)).trim());
		    					//Added by sarita on 30.08.2017
		    					gstnStateCode = gstUtility.checkNull(genericUtility.getColumnValue("tax_reg_no", dom1)).substring(0,2);//Value of StateCode set by using Supplier GSTIN number first 2digit.
		    					//state_code_cdn = getGstCodeForCDNR(dom,conn);
		    					System.out.println("INPUT VALUE in Validation"+"gst_type["+gst_type+"]"+"state_code["+state_code+"]"+"cgst_amt["+cgst_amt+"]"+"loginSiteCode["+loginSiteCode+"]"+"cgst_amtVal["+cgst_amtVal+"]"+"gstnStateCode["+gstnStateCode+"]");
		    				}//end of if block for cgst_amt
		    				
		    				else if("sgst_perc".equalsIgnoreCase(childNodeName))
		    				{
		    					gst_type = gstUtility.checkNull(genericUtility.getColumnValue("gst_type", dom1)).trim();
		    					state_code = gstUtility.checkNull(genericUtility.getColumnValue("gst_code_state", dom1)).trim();
		    					sgst_perc = gstUtility.checkNull(genericUtility.getColumnValue("sgst_perc", dom)).trim();
		    					loginSiteCode = gstUtility.checkNull(getStateFromLoginSite(loginSite,conn));
		    					sgst_percVal = converStringToDouble(gstUtility.checkNull(genericUtility.getColumnValue("sgst_perc", dom)).trim());
		    					//Added by sarita on 30.08.2017
		    					gstnStateCode = gstUtility.checkNull(genericUtility.getColumnValue("tax_reg_no", dom1)).substring(0,2);//Value of StateCode set by using Supplier GSTIN number first 2digit.
		    					//state_code_cdn = getGstCodeForCDNR(dom,conn);//System.out.println("INPUT VALUE"+"gst_type["+gst_type+"]"+"state_code["+state_code+"]"+"sgst_perc["+sgst_perc+"]"+"loginSiteCode["+loginSiteCode+"]"+"sgst_percVal["+sgst_percVal+"]");
		    				}//end of if block for sgst_perc
		    				
		    				else if("sgst_amt".equalsIgnoreCase(childNodeName))
		    				{
		    					gst_type = gstUtility.checkNull(genericUtility.getColumnValue("gst_type", dom1)).trim();
		    					state_code = gstUtility.checkNull(genericUtility.getColumnValue("gst_code_state", dom1)).trim();
		    					sgst_amt = gstUtility.checkNull(genericUtility.getColumnValue("sgst_amt", dom)).trim();
		    					loginSiteCode = gstUtility.checkNull(getStateFromLoginSite(loginSite,conn));
		    					sgst_amtVal =  converStringToDouble(gstUtility.checkNull(genericUtility.getColumnValue("sgst_amt", dom)).trim());
		    				    //Added by sarita on 30.08.2017
		    					gstnStateCode = gstUtility.checkNull(genericUtility.getColumnValue("tax_reg_no", dom1)).substring(0,2);//Value of StateCode set by using Supplier GSTIN number first 2digit.
		    					//state_code_cdn = getGstCodeForCDNR(dom,conn);
		    					System.out.println("INPUT VALUE in Validation"+"gst_type["+gst_type+"]"+"state_code["+state_code+"]"+"sgst_amt["+sgst_amt+"]"+"loginSiteCode["+loginSiteCode+"]"+"sgst_amtVal["+sgst_amtVal+"]"+"gstnStateCode["+gstnStateCode+"]");
		    				}//end of if block for sgst_amt
		    				
		    				else if("itc_igst".equalsIgnoreCase(childNodeName))
		    				{
		    					gst_type = gstUtility.checkNull(genericUtility.getColumnValue("gst_type", dom1)).trim();
		    					itc_type = gstUtility.checkNull(genericUtility.getColumnValue("itc_type", dom)).trim();
		    					itc_igst = gstUtility.checkNull(genericUtility.getColumnValue("itc_igst", dom)).trim();//System.out.println("gst_type["+gst_type+"]"+"itc_type["+itc_type+"]");
		    				}//end of if block for itc_igst
		    				
		    				else if("itc_cgst".equalsIgnoreCase(childNodeName))
		    				{
		    					gst_type = gstUtility.checkNull(genericUtility.getColumnValue("gst_type", dom1)).trim();
		    					itc_type = gstUtility.checkNull(genericUtility.getColumnValue("itc_type", dom)).trim();
		    					itc_cgst = gstUtility.checkNull(genericUtility.getColumnValue("itc_cgst", dom)).trim();//System.out.println("gst_type["+gst_type+"]"+"itc_type["+itc_type+"]");
		    				}//end of if block for itc_igst
		    				
		    				else if("itc_sgst".equalsIgnoreCase(childNodeName))
		    				{
		    					gst_type = gstUtility.checkNull(genericUtility.getColumnValue("gst_type", dom1)).trim();
		    					itc_type = gstUtility.checkNull(genericUtility.getColumnValue("itc_type", dom)).trim();
		    					itc_sgst = gstUtility.checkNull(genericUtility.getColumnValue("itc_sgst", dom)).trim();//System.out.println("gst_type["+gst_type+"]"+"itc_type["+itc_type+"]");
		    				}//end of if block for itc_igst
		    				
		    				else if("itc_cess".equalsIgnoreCase(childNodeName))
		    				{
		    					gst_type = gstUtility.checkNull(genericUtility.getColumnValue("gst_type", dom1)).trim();
		    					itc_type = gstUtility.checkNull(genericUtility.getColumnValue("itc_type", dom)).trim();
		    					itc_cess = gstUtility.checkNull(genericUtility.getColumnValue("itc_cess", dom)).trim();//System.out.println("gst_type["+gst_type+"]"+"itc_type["+itc_type+"]");
		    				}//end of if block for itc_igst
		    				
		    			}//end of for loop
		    			
		    		    // ******************************* Validation for gs_code [START]*************************************
		    			if("I".equalsIgnoreCase(gst_type) || "R".equalsIgnoreCase(gst_type)
		    			|| "U".equalsIgnoreCase(gst_type))
		    			{
		    				if(gs_code == null || gs_code.trim().length() == 0)
			    			{
		    					errCode = "NULLGSCODE";
		    					errList.add(errCode);
		    					errFields.add("gs_code");
			    			}
		    			}
		    		    // ********************************** Validation for gs_code [END]*****************************************
		    			
		    		    // ********************************** Validation for quantity [START]**************************************
		    		    if("I".equalsIgnoreCase(gst_type) || "R".equalsIgnoreCase(gst_type)
				        || "U".equalsIgnoreCase(gst_type))
		    		    {
			    			if(quantity == null || quantity.trim().length() == 0)
		    				{
			    				errCode = "VTQUNT2";
	    						errList.add(errCode);
	    						errFields.add("quantity");
		    				}
		    		    }	
		    		    // *********************************** Validation for quantity [END]****************************************	
		    		
		    		    // *********************************** Validation for unit [START]******************************************
		    		    if("I".equalsIgnoreCase(gst_type) || "R".equalsIgnoreCase(gst_type)
		    		    || "U".equalsIgnoreCase(gst_type))
		    		    {
		    		    	if(unit == null || unit.trim().length() == 0)
		    		    	{
		    		    		errCode = "VTINVUNT01";
		    		    		errList.add(errCode);
		    		    		errFields.add("unit");
		    		    	}
		    		    }
		    		    // ********************************** Validation for unit [END]**********************************************
			    	
		    		    // ********************************** Validation for taxable_amt [START]*************************************
		    		    //Added A and T by sarita on 25th JULY 2017
		    		    if("I".equalsIgnoreCase(gst_type) || "R".equalsIgnoreCase(gst_type) || "U".equalsIgnoreCase(gst_type) 
		    		    || "S".equalsIgnoreCase(gst_type) || "G".equalsIgnoreCase(gst_type) || "A".equalsIgnoreCase(gst_type)
		    		    || "T".equalsIgnoreCase(gst_type))
		    		    {
		    		    	if(taxable_amt == null || taxable_amt.trim().length() == 0)
		    		    	{
		    		    		errCode = "NULLTAXAMT";
		    		    		errList.add(errCode);
		    		    		errFields.add("taxable_amt");
		    		    	}
		    		    	//commented by sarita on 14AUG2017
		    		    /*	System.out.println("Entered Amount is ======"+amount);
		    		    	finalAmt = gstUtility.gettaxableAmtForAllDetail(dom2);
		    		    	if(finalAmt > Double.valueOf(amount))
		    		    	{
		    		    		errCode = "INVDTAXAMT";
		    		    		errList.add(errCode);
		    		    		errFields.add("taxable_amt");
		    		    	}*/
		    		    }
		    		    // *********************************** Validation for taxable_amt [END]***************************************
			    	
		    		    // *********************************** Validation for gst_rate [START]****************************************
		    		   // Removed validation for gst_type A and T for gst_rate on 14AUG2017
		    		    if(("I".equalsIgnoreCase(gst_type) && ("R".equalsIgnoreCase(doc_type)) || ("DE".equalsIgnoreCase(doc_type))) || "R".equalsIgnoreCase(gst_type) || "U".equalsIgnoreCase(gst_type) 
		    		      || "S".equalsIgnoreCase(gst_type) || "G".equalsIgnoreCase(gst_type))
		    		    {
		    		    	if(gst_rate == null || gst_rate.trim().length() == 0)
		    		    	{
		    		    		errCode = "NULLIGSTPC";
		    		    		errList.add(errCode);
		    		    		errFields.add("gst_rate");
		    		    	}
		    		       	else if(gstRate ==0)
		    		    	{
		    		    		errCode = "INVZEROVAL";
		    		    		errList.add(errCode);
		    		    		errFields.add("gst_rate");
		    		    	}
		    		    }
		    		    //Added by sarita on 14AUG2017
		    		    else if("I".equalsIgnoreCase(gst_type) && ("Z".equalsIgnoreCase(doc_type)))
		    		    {
		    		        int cnt1 = gstUtility.getNumOfNonDelDetail(dom2,currentFormNo);	
		    		        System.out.println("cnt1 is===="+cnt1);
		    		    	boolean gstCheck = gstUtility.getRateValueForAllDetail(dom2);	
		    		    	if(gstCheck)
		    		    	{
		    		    		errCode = "INVRATESEZ";
		    		    		errList.add(errCode);
		    		    		errFields.add("gst_rate");
		    		    	}
		    		    }
		    		    else if("D".equalsIgnoreCase(gst_type) || "C".equalsIgnoreCase(gst_type))
		    		    {		    		    	
		    		    	refIdInv = gstUtility.checkNull(genericUtility.getColumnValue("ref_id__inv", dom1));
				    	    ref_date__inv = gstUtility.checkNull(genericUtility.getColumnValue("ref_date__inv", dom1)).trim();
				    		refInvDateDate = Timestamp.valueOf(genericUtility.getValidDateString(ref_date__inv, genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat()) + " 00:00:00.0");
			    			String dt = "01/07/2017";
			    			invDate = Timestamp.valueOf(genericUtility.getValidDateString(dt, genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat()) + " 00:00:00.0");
			    			//System.out.println("Return Value"+"ref_id__inv is ["+refIdInv+"]"+"ref_date__inv["+ref_date__inv+"]"+"refInvDateDate["+refInvDateDate+"]"+"Date1/7/17["+dt+"]"+"invDate["+invDate+"]");
			    			if(refInvDateDate.equals(invDate) || refInvDateDate.after(invDate))
			    			{
			    				if(gst_rate == null || gst_rate.trim().length() == 0)
			    		    	{
			    		    		errCode = "NULLIGSTPC";
			    		    		errList.add(errCode);
			    		    		errFields.add("gst_rate");
			    		    	}
			    		    	//Added by sarita on 14/07/2017 [start]
			    		    	else if(gstRate ==0)
			    		    	{
			    		    		errCode = "INVZEROVAL";
			    		    		errList.add(errCode);
			    		    		errFields.add("gst_rate");
			    		    	}
				    		}
		    		    }
		    		    // *********************************** Validation for gst_rate [END]******************************************
			    	    		
		    		    // *********************************** Validation for igst_amt [END]*********************************************
		    			//removed validation for gst_type A and T for igst_amt
		    		    //changed by sarita on 30.08.2017
		    		    if("I".equalsIgnoreCase(gst_type) && ("Z".equalsIgnoreCase(doc_type)) || ("DE".equalsIgnoreCase(doc_type)) || "R".equalsIgnoreCase(gst_type) 
		    		    || "U".equalsIgnoreCase(gst_type) || "S".equalsIgnoreCase(gst_type) || "G".equalsIgnoreCase(gst_type))	
		    		    {
		    		    	if((state_code != null) && !(state_code.equalsIgnoreCase(loginSiteCode)))
		    		    	{
		    		    		if(igst_amt == null || igst_amt.trim().length() == 0)
		    		    		{
		    		    			errCode = "NULLIGSTAM";
		    		    			errList.add(errCode);
		    		    			errFields.add("igst_amt");
		    		    		}
		    		    		else if(igst_amtVal == 0)
		    		    		{
		    		    			errCode = "INVZEROVAL";
		    		    			errList.add(errCode);
		    		    			errFields.add("igst_amt");
		    		    		}
		    		    		cgst_amtVal = converStringToDouble(gstUtility.checkNull(genericUtility.getColumnValue("cgst_amt", dom)).trim());
		    		    		sgst_amtVal = converStringToDouble(gstUtility.checkNull(genericUtility.getColumnValue("sgst_amt", dom)).trim());//System.out.println("Return Value"+"cgst_amtVal["+cgst_amtVal+"]"+"sgst_amtVal["+sgst_amtVal+"]"+"cgst_percVal["+cgst_percVal+"]"+"sgst_percVal["+sgst_percVal+"]");
		    		    		if((cgst_amtVal > 0) || (sgst_amtVal > 0))
		    		    		{
		    		    			errCode = "INVINTRAST";
		    		    			errList.add(errCode);
		    		    			errFields.add("igst_amt");
		    		    		}
		    		    	}
		    		    }
		    		    //Added by sarita on 30.08.2017[start]
		    		    else if("I".equalsIgnoreCase(gst_type) && ("R".equalsIgnoreCase(doc_type)))
		    		    {
		    		    	if((state_code != null) && !(state_code.equalsIgnoreCase(gstnStateCode)))
		    		    	{
		    		    		if(igst_amt == null || igst_amt.trim().length() == 0)
		    		    		{
		    		    			errCode = "NULLIGSTAM";
		    		    			errList.add(errCode);
		    		    			errFields.add("igst_amt");
		    		    		}
		    		    		else if(igst_amtVal == 0)
		    		    		{
		    		    			errCode = "INVZEROVAL";
		    		    			errList.add(errCode);
		    		    			errFields.add("igst_amt");
		    		    		}
		    		    		cgst_amtVal = converStringToDouble(gstUtility.checkNull(genericUtility.getColumnValue("cgst_amt", dom)).trim());
		    		    		sgst_amtVal = converStringToDouble(gstUtility.checkNull(genericUtility.getColumnValue("sgst_amt", dom)).trim());//System.out.println("Return Value"+"cgst_amtVal["+cgst_amtVal+"]"+"sgst_amtVal["+sgst_amtVal+"]"+"cgst_percVal["+cgst_percVal+"]"+"sgst_percVal["+sgst_percVal+"]");
		    		    		if((cgst_amtVal > 0) || (sgst_amtVal > 0))
		    		    		{
		    		    			errCode = "INVINTRAST";
		    		    			errList.add(errCode);
		    		    			errFields.add("igst_amt");
		    		    		}
		    		    	}
		    		    }
		    		    //Added by sarita on 30.08.2017[end]
		    		    else if("D".equalsIgnoreCase(gst_type) || "C".equalsIgnoreCase(gst_type))
		    		    {		    		    	
		    		    	refIdInv = gstUtility.checkNull(genericUtility.getColumnValue("ref_id__inv", dom1));
				    	    ref_date__inv = gstUtility.checkNull(genericUtility.getColumnValue("ref_date__inv", dom1)).trim();
				    		refInvDateDate = Timestamp.valueOf(genericUtility.getValidDateString(ref_date__inv, genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat()) + " 00:00:00.0");
			    			String dt = "01/07/2017";
			    			invDate = Timestamp.valueOf(genericUtility.getValidDateString(dt, genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat()) + " 00:00:00.0");
			    			//System.out.println("Return Value"+"ref_id__inv is ["+refIdInv+"]"+"ref_date__inv["+ref_date__inv+"]"+"refInvDateDate["+refInvDateDate+"]"+"Date1/7/17["+dt+"]"+"invDate["+invDate+"]");
			    			if(refInvDateDate.equals(invDate) || refInvDateDate.after(invDate))
				    		{
			    				sql = "select gst_code from gst_data_hdr where doc_no=?";
				    			pstmt = conn.prepareStatement(sql);
								pstmt.setString(1,refIdInv);
								rs = pstmt.executeQuery();	
								if(rs.next())
								{
									gstCode = rs.getString("gst_code");
									System.out.println("gstCode::::::::::["+gstCode+"]");
								}
								if(pstmt != null)
								{
								    pstmt.close(); 
								    pstmt = null;
								}
								if(rs != null)
								{
									rs.close();
								    rs = null;
								}
								//Added by sarita on 30.08.2017
								if((gstCode != null) && !(gstCode.equalsIgnoreCase(gstnStateCode)))
								{
				    				if(igst_amt == null || igst_amt.trim().length() == 0)
			    		    		{
			    		    			errCode = "NULLIGSTAM";
			    		    			errList.add(errCode);
			    		    			errFields.add("igst_amt");
			    		    		}
			    		    		else if(igst_amtVal == 0)
			    		    		{
			    		    			errCode = "INVZEROVAL";
			    		    			errList.add(errCode);
			    		    			errFields.add("igst_amt");
			    		    		}
				    				//added by sarita on 25JUL2017
				    				cgst_amtVal = converStringToDouble(gstUtility.checkNull(genericUtility.getColumnValue("cgst_amt", dom)).trim());
			    		    		sgst_amtVal = converStringToDouble(gstUtility.checkNull(genericUtility.getColumnValue("sgst_amt", dom)).trim());
			    		    		System.out.println("Return Value"+"cgst_amtVal["+cgst_amtVal+"]"+"sgst_amtVal["+sgst_amtVal+"]"+"cgst_percVal["+cgst_percVal+"]"+"sgst_percVal["+sgst_percVal+"]");
			    		    		if((cgst_amtVal > 0) || (sgst_amtVal > 0))
			    		    		{
			    		    			errCode = "INVINTRAST";
			    		    			errList.add(errCode);
			    		    			errFields.add("igst_amt");
			    		    		}
								}
				    		}
		    		    }
		    		    // ************************************ Validation for igst_amt [END]*******************************************
		    		
		    		    // ************************************ Validation for cgst_amt [START]******************************************
		    		  //removed validation for gst_type A and T for igst_amt
		    		    //Added by sarita on 30.08.2017
		    		    if(("R".equalsIgnoreCase(gst_type) || "U".equalsIgnoreCase(gst_type) 
		    		     || "S".equalsIgnoreCase(gst_type) || "G".equalsIgnoreCase(gst_type)))
		    		    {
		    		    	if((state_code != null) && (state_code.equalsIgnoreCase(loginSiteCode)))
		    		    	{
		    		    		if(cgst_amt == null || cgst_amt.trim().length() == 0)
		    		    		{
		    		    			errCode = "NULLCGSTAM";
		    		    			errList.add(errCode);
		    		    			errFields.add("cgst_amt");
		    		    		}
		    		    		else if(cgst_amtVal == 0)
		    		    		{
		    		    			errCode = "INVZEROVAL";
		    		    			errList.add(errCode);
		    		    			errFields.add("cgst_amt");
		    		    		}
		    		    		//changes by sarita on 25JUN2017
		    		    		igst_amtVal = converStringToDouble(gstUtility.checkNull(genericUtility.getColumnValue("igst_amt", dom)).trim());
		    		    		if(igst_amtVal >0)
		    		    		{
		    		    			errCode = "INVINTERST";
		    		    			errList.add(errCode);
		    		    			errFields.add("cgst_amt");
		    		    		}
		    		    	}
		    		    }
		    		    //Added by sarita on 30.08.2017[start]
		    		    else if("I".equalsIgnoreCase(gst_type) && ("R".equalsIgnoreCase(doc_type)))
		    		    {
		    		    	if((state_code != null) && !(state_code.equalsIgnoreCase(gstnStateCode)))
		    		    	{
		    		    		if(igst_amt == null || igst_amt.trim().length() == 0)
		    		    		{
		    		    			errCode = "NULLIGSTAM";
		    		    			errList.add(errCode);
		    		    			errFields.add("igst_amt");
		    		    		}
		    		    		else if(igst_amtVal == 0)
		    		    		{
		    		    			errCode = "INVZEROVAL";
		    		    			errList.add(errCode);
		    		    			errFields.add("igst_amt");
		    		    		}
		    		    		cgst_amtVal = converStringToDouble(gstUtility.checkNull(genericUtility.getColumnValue("cgst_amt", dom)).trim());
		    		    		sgst_amtVal = converStringToDouble(gstUtility.checkNull(genericUtility.getColumnValue("sgst_amt", dom)).trim());
		    		    		//System.out.println("Return Value"+"cgst_amtVal["+cgst_amtVal+"]"+"sgst_amtVal["+sgst_amtVal+"]"+"cgst_percVal["+cgst_percVal+"]"+"sgst_percVal["+sgst_percVal+"]");
		    		    		if((cgst_amtVal > 0) || (sgst_amtVal > 0))
		    		    		{
		    		    			errCode = "INVINTRAST";
		    		    			errList.add(errCode);
		    		    			errFields.add("igst_amt");
		    		    		}
		    		    	}
		    		    }
		    		  //Added by sarita on 30.08.2017[end]
		    		    else if("D".equalsIgnoreCase(gst_type) || "C".equalsIgnoreCase(gst_type))
		    		    {		    		    	
		    		    	refIdInv = gstUtility.checkNull(genericUtility.getColumnValue("ref_id__inv", dom1));
				    	    ref_date__inv = gstUtility.checkNull(genericUtility.getColumnValue("ref_date__inv", dom1)).trim();
				    		refInvDateDate = Timestamp.valueOf(genericUtility.getValidDateString(ref_date__inv, genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat()) + " 00:00:00.0");
			    			String dt = "01/07/2017";
			    			invDate = Timestamp.valueOf(genericUtility.getValidDateString(dt, genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat()) + " 00:00:00.0");//System.out.println("Return Value"+"ref_id__inv is ["+refIdInv+"]"+"ref_date__inv["+ref_date__inv+"]"+"refInvDateDate["+refInvDateDate+"]"+"Date1/7/17["+dt+"]"+"invDate["+invDate+"]");
			    			if(refInvDateDate.equals(invDate) || refInvDateDate.after(invDate))
				    		{
			    				sql = "select gst_code from gst_data_hdr where doc_no=?";
				    			pstmt = conn.prepareStatement(sql);
								pstmt.setString(1,refIdInv);
								rs = pstmt.executeQuery();	
								if(rs.next())
								{
									gstCode = rs.getString("gst_code");
									System.out.println("gstCode::::::::::["+gstCode+"]");
								}
								if(pstmt != null)
								{
								    pstmt.close(); 
								    pstmt = null;
								}
								if(rs != null)
								{
									rs.close();
								    rs = null;
								}
								//changes by sarita on 30.08.2017
								if((gstCode != null) && (gstCode.equalsIgnoreCase(gstnStateCode)))
								{
									if(cgst_amt == null || cgst_amt.trim().length() == 0)
			    		    		{
			    		    			errCode = "NULLCGSTAM";
			    		    			errList.add(errCode);
			    		    			errFields.add("cgst_amt");
			    		    		}
			    		    		else if(cgst_amtVal == 0)
			    		    		{
			    		    			errCode = "INVZEROVAL";
			    		    			errList.add(errCode);
			    		    			errFields.add("cgst_amt");
			    		    		}
									igst_amtVal = converStringToDouble(gstUtility.checkNull(genericUtility.getColumnValue("igst_amt", dom)).trim());
			    		    		if(igst_amtVal >0)
			    		    		{
			    		    			errCode = "INVINTERST";
			    		    			errList.add(errCode);
			    		    			errFields.add("cgst_amt");
			    		    		}
								}
				    		}
		    		    }		    		    
		    		    // ********************************** Validation for cgst_amt [END]********************************************
		    		
		    		    // ************************** Validation for sgst_amt [START]**************************************************
		    		    if(("R".equalsIgnoreCase(gst_type) || "U".equalsIgnoreCase(gst_type)
		    		    || "S".equalsIgnoreCase(gst_type) || "G".equalsIgnoreCase(gst_type)))
		    		    {
		    		    	//changes by sarita on 30.08.2017
		    		    	if((state_code != null) && (state_code.equalsIgnoreCase(gstnStateCode)))
		    		    	{
		    		    		if(sgst_amt == null || sgst_amt.trim().length() == 0)
		    		    		{
		    		    			errCode = "NULLSGSTAM";
		    		    			errList.add(errCode);
		    		    			errFields.add("sgst_amt");
		    		    		}
		    		    		else if(sgst_amtVal == 0)
		    		    		{
		    		    			errCode = "INVZEROVAL";
		    		    			errList.add(errCode);
		    		    			errFields.add("sgst_amt");
		    		    		}
		    		    		igst_amtVal = converStringToDouble(gstUtility.checkNull(genericUtility.getColumnValue("igst_amt", dom)).trim()); 
		    		    		if(igst_amtVal > 0)
		    		    		{
		    		    			errCode = "INVINTERST";
		    		    			errList.add(errCode);
		    		    			errFields.add("sgst_amt");
		    		    		}
		    		    	}
		    		    }
		    		    //Added by sarita on 30.08.2017[start]
		    		    else if("I".equalsIgnoreCase(gst_type) && ("R".equalsIgnoreCase(doc_type)))
		    		    {
		    		    	if((state_code != null) && !(state_code.equalsIgnoreCase(gstnStateCode)))
		    		    	{
		    		    		if(igst_amt == null || igst_amt.trim().length() == 0)
		    		    		{
		    		    			errCode = "NULLIGSTAM";
		    		    			errList.add(errCode);
		    		    			errFields.add("igst_amt");
		    		    		}
		    		    		else if(igst_amtVal == 0)
		    		    		{
		    		    			errCode = "INVZEROVAL";
		    		    			errList.add(errCode);
		    		    			errFields.add("igst_amt");
		    		    		}
		    		    		cgst_amtVal = converStringToDouble(gstUtility.checkNull(genericUtility.getColumnValue("cgst_amt", dom)).trim());
		    		    		sgst_amtVal = converStringToDouble(gstUtility.checkNull(genericUtility.getColumnValue("sgst_amt", dom)).trim());//System.out.println("Return Value"+"cgst_amtVal["+cgst_amtVal+"]"+"sgst_amtVal["+sgst_amtVal+"]"+"cgst_percVal["+cgst_percVal+"]"+"sgst_percVal["+sgst_percVal+"]");
		    		    		if((cgst_amtVal > 0) || (sgst_amtVal > 0))
		    		    		{
		    		    			errCode = "INVINTRAST";
		    		    			errList.add(errCode);
		    		    			errFields.add("igst_amt");
		    		    		}
		    		    	}
		    		    }
		    		    //Added by sarita on 30.08.2017[end]
		    		    else if("D".equalsIgnoreCase(gst_type) || "C".equalsIgnoreCase(gst_type))
		    		    {		    		    	
		    		    	refIdInv = gstUtility.checkNull(genericUtility.getColumnValue("ref_id__inv", dom1));
				    	    ref_date__inv = gstUtility.checkNull(genericUtility.getColumnValue("ref_date__inv", dom1)).trim();
				    		refInvDateDate = Timestamp.valueOf(genericUtility.getValidDateString(ref_date__inv, genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat()) + " 00:00:00.0");
			    			String dt = "01/07/2017";
			    			invDate = Timestamp.valueOf(genericUtility.getValidDateString(dt, genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat()) + " 00:00:00.0");//System.out.println("Return Value"+"ref_id__inv is ["+refIdInv+"]"+"ref_date__inv["+ref_date__inv+"]"+"refInvDateDate["+refInvDateDate+"]"+"Date1/7/17["+dt+"]"+"invDate["+invDate+"]");
			    			if(refInvDateDate.equals(invDate) || refInvDateDate.after(invDate))
				    		{
			    				sql = "select gst_code from gst_data_hdr where doc_no=?";
				    			pstmt = conn.prepareStatement(sql);
								pstmt.setString(1,refIdInv);
								rs = pstmt.executeQuery();	
								if(rs.next())
								{
									gstCode = rs.getString("gst_code");
									System.out.println("gstCode::::::::::["+gstCode+"]");
								}
								if(pstmt != null)
								{
								    pstmt.close(); 
								    pstmt = null;
								}
								if(rs != null)
								{
									rs.close();
								    rs = null;
								}
								//changes by sarita on 30.08.2017
								if((gstCode != null) && (gstCode.equalsIgnoreCase(gstnStateCode)))
								{
									if(sgst_amt == null || sgst_amt.trim().length() == 0)
			    		    		{
			    		    			errCode = "NULLSGSTAM";
			    		    			errList.add(errCode);
			    		    			errFields.add("sgst_amt");
			    		    		}
			    		    		else if(sgst_amtVal == 0)
			    		    		{
			    		    			errCode = "INVZEROVAL";
			    		    			errList.add(errCode);
			    		    			errFields.add("sgst_amt");
			    		    		}
									igst_amtVal = converStringToDouble(gstUtility.checkNull(genericUtility.getColumnValue("igst_amt", dom)).trim()); 
			    		    		if(igst_amtVal > 0)
			    		    		{
			    		    			errCode = "INVINTERST";
			    		    			errList.add(errCode);
			    		    			errFields.add("sgst_amt");
			    		    		}
								}
				    		}
		    		    }
		    		    // ************************** Validation for sgst_amt [END]*****************************************************
		    		    
		    		    // ************************** Validation for ITC_IGST [START] *******************************
		    		    if("I".equalsIgnoreCase(gst_type) || "R".equalsIgnoreCase(gst_type) || "U".equalsIgnoreCase(gst_type)
				        || "S".equalsIgnoreCase(gst_type) || "G".equalsIgnoreCase(gst_type) || "D".equalsIgnoreCase(gst_type)		
				    	|| "A".equalsIgnoreCase(gst_type) || "T".equalsIgnoreCase(gst_type) || "C".equalsIgnoreCase(gst_type))
				    	{
		    		    	if(!(itc_type.equalsIgnoreCase("NO")))
		    		    	{
		    		    		if(itc_igst == null || itc_igst.trim().length() == 0)
		    		    		{
		    		    			errCode = "INVITCIGST";
		    		    			errList.add(errCode);
		    		    			errFields.add("itc_igst");
		    		    		}
		    		    	}
				    	}
		    		    // ************************** Validation for ITC_IGST [END] *********************************
		    		    
		    		   // ************************** Validation for ITC_CGST [START] *******************************
		    		    if("I".equalsIgnoreCase(gst_type) || "R".equalsIgnoreCase(gst_type) || "U".equalsIgnoreCase(gst_type)
				        || "S".equalsIgnoreCase(gst_type) || "G".equalsIgnoreCase(gst_type) || "D".equalsIgnoreCase(gst_type)		
				    	|| "A".equalsIgnoreCase(gst_type) || "T".equalsIgnoreCase(gst_type) || "C".equalsIgnoreCase(gst_type))
				    	{
		    		    	if(!(itc_type.equalsIgnoreCase("NO")))
		    		    	{
		    		    		if(itc_cgst == null || itc_cgst.trim().length() == 0)
		    		    		{
		    		    			errCode = "INVITCCGST";
		    		    			errList.add(errCode);
		    		    			errFields.add("itc_cgst");
		    		    		}
		    		    	}
				    	}
		    		    // ************************** Validation for CTC_CGST [END] *********************************
		    		    
		    		   // ************************** Validation for ITC_SGST [START] *******************************
		    		    if("I".equalsIgnoreCase(gst_type) || "R".equalsIgnoreCase(gst_type) || "U".equalsIgnoreCase(gst_type)
				        || "S".equalsIgnoreCase(gst_type) || "G".equalsIgnoreCase(gst_type) || "D".equalsIgnoreCase(gst_type)		
				    	|| "A".equalsIgnoreCase(gst_type) || "T".equalsIgnoreCase(gst_type) || "C".equalsIgnoreCase(gst_type))
				    	{
		    		    	if(!(itc_type.equalsIgnoreCase("NO")))
		    		    	{
		    		    		if(itc_sgst == null || itc_sgst.trim().length() == 0)
		    		    		{
		    		    			errCode = "INVITCSGST";
		    		    			errList.add(errCode);
		    		    			errFields.add("itc_sgst");
		    		    		}
		    		    	}
				    	}
		    		    // ************************** Validation for CTC_SGST [END] *********************************
		    		    
		    		 // ************************** Validation for ITC_CESS [START] *******************************
		    		    if("I".equalsIgnoreCase(gst_type) || "R".equalsIgnoreCase(gst_type) || "U".equalsIgnoreCase(gst_type)
				        || "S".equalsIgnoreCase(gst_type) || "G".equalsIgnoreCase(gst_type) || "D".equalsIgnoreCase(gst_type)		
				    	|| "A".equalsIgnoreCase(gst_type) || "T".equalsIgnoreCase(gst_type) || "C".equalsIgnoreCase(gst_type))
				    	{
		    		    	if(!(itc_type.equalsIgnoreCase("NO")))
		    		    	{
		    		    		if(itc_cess == null || itc_cess.trim().length() == 0)
		    		    		{
		    		    			errCode = "INVITCCESS";
		    		    			errList.add(errCode);
		    		    			errFields.add("itc_cess");
		    		    		}
		    		    	}
				    	}
		    		    // ************************** Validation for CTC_CESS [END] *********************************		    		    
		    		}//end of case2
		    		break;
		    	}//end of switch statement
		        	
		        int errListSize = errList.size();
		        System.out.println("errListSize::::::::::"+errListSize);
		        int count = 0;
		        String errFldName = null;
		        if (errList != null && errListSize > 0)
		        {
		        	for (count = 0; count < errListSize; count++)
		        	{
		        		errCode = errList.get(count);
		        		errFldName = errFields.get(count);
		        		System.out.println(" testing :errCode .:" + errCode+"errString>>>>>>>>>"+errString);
		        		errString = getErrorString(errFldName, errCode, userId);
		        		errorType = errorType(conn, errCode);
		        		if (errString.length() > 0)
		        		{
		        			String bifurErrString = errString.substring(errString.indexOf("<Errors>") + 8, errString.indexOf("<trace>"));
		        			bifurErrString = bifurErrString + errString.substring(errString.indexOf("</trace>") + 8, errString.indexOf("</Errors>"));
		        			errStringXml.append(bifurErrString);
		        			errString = "";
		        		}
		        		if (errorType.equalsIgnoreCase("E"))
		        		{
		        			break;
		        		}
		        	}
		        	errList.clear();
		        	errList = null;
		        	errFields.clear();
		        	errFields = null;
		        	errStringXml.append("</Errors> </Root> \r\n");
		        }//end of if for errList 
		        else
		        {
		        	errStringXml = new StringBuffer("");
		        }
		    }//end of if for objContext
		}//end of try block
		catch(Exception e)
		{
			System.out.println("Exception ::"+e);
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
					{
						rs.close();
						rs = null;
					}
					if (pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
						conn.close();
				}
					conn = null;
			} 
			catch (Exception d)
			{
				d.printStackTrace();
				throw new ITMException(d);
			}
		}
		errString = errStringXml.toString();
		System.out.println("testing : final errString : " + errString);
		return errString;
	}//end of wfValData method....
	
	public String itemChanged(String xmlString, String xmlString1,String xmlString2, String objContext, String currentColumn,String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		Document dom=null;
		Document domhr=null;
		Document domAll=null;
		String retString="";
		try
		{
			System.out.println("**************  Inside itemChanged method ****************");
			if(xmlString != null && xmlString.trim().length()>0)
	   		{
				dom = genericUtility.parseString(xmlString);		
	   		}
			if(xmlString1 != null && xmlString1.trim().length()>0)
	   		{
				domhr = genericUtility.parseString(xmlString1);		
	   		}
			if(xmlString2 != null && xmlString2.trim().length()>0)
	   		{
				domAll = genericUtility.parseString(xmlString2);		
	   		}
			retString = itemChanged(dom,domhr,domAll,objContext,currentColumn,editFlag,xtraParams);	//System.out.println("retString::::::::::"+retString);
		}
		catch(Exception e)
		{
			System.out.println(":::" + getClass().getSimpleName() + "::"+ e.getMessage());
			e.getMessage(); 	
		}
		return retString;
	}
	
	public String itemChanged(Document dom, Document dom1, Document dom2,String objContext, String currentColumn, String editFlag,String xtraParams) throws RemoteException, ITMException
	{
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null ;
		int currentFormNo=0,ctr = 0;	
		StringBuffer valueXmlString = new StringBuffer();
		NodeList parentNodeList,parentNodeList1 = null;
		Node parentNode = null;
		Node childNode = null;
		NodeList childNodeList = null;
		int childNodeLength = 0;
		String childNodeName = "";
		String columnValue="";
		int childNodeListLength = 0,cnt=0;
		String tran_id__ref="",rec_type="",tran_type="",state_code="",reco_status="",site_code="",cust_code="",cust_name="";
		String sql="";
		String doc_no="",itc_type="",gst_codeVal="",gstTypeEdit="",doc_type="";
		String docDateStr="",itc_igst = "",itc_cgst="",itc_sgst="",itc_cess="";
		double amount=0.0,taxable_amt=0.0, amt = 0.0,gst_rate=0.0;
		String recDescr ="",tranDescr="",stateDescr="",recoDescr="",siteDescr="",gst_type="",gstDescr="",gstnStateCode="";
		Timestamp doc_date=null;
		String loginSite = "",state1="",stCode="",refIdInv="",ref_date__inv="",cgst_amt="",sgst_amt="",igst_amt;
	    Timestamp refInvDateDate=null,invDate=null;
		SimpleDateFormat sdf;
		NodeList parentList = null;
		String objName="",prov_assmnt="",gstCode="",docType="",tranType="",docDate="",itcType="",itcTypeDescr="";
		String code="",mnth="",year="",finalCode="",tax_reg_no="",loginSiteCode="",ecomRegNo="";
		String name="",addr1="",addr2="",addr3="",city="",state="",pin="",stateCode="",stateCodeReg="";
		String nameEdit="",addr1Edit="",addr2Edit="",addr3Edit="",cityEdit="",stateEdit="",pinEdit="";
		String taxRegNoEdit="",docTypeEdit="",docNoEdit="",docDateEdit="",amountEdit="",gstCodeEdit="",stateDescEdit="",ecomRegEdit="",revChrEdit="",refIfInvEdit = "",refDateInvEdit="",lrNoEdit="",lrDateEdit="",orderNoEdit="",reasonCdEdit="",custNameEdit="";
		double rate , igst_amount , cgst_amount, sgst_amount=0.0;
		try
		{
			conn = getConnection();
			sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			loginSite = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginSiteCode");
			
			if(objContext != null && objContext.trim().length()>0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			System.out.println("[GstrPurchase] [itemChanged] :currentFormNo ....." +currentFormNo);
			valueXmlString = new StringBuffer("<?xml version=\"1.0\"?><Root><header><editFlag>");
			valueXmlString.append(editFlag).append("</editFlag></header>");
			
			switch(currentFormNo)
			{
				case 1 :
				{
					parentNodeList = dom.getElementsByTagName("Detail1");
					parentList = dom.getElementsByTagName( "Detail" + currentFormNo );
	    			objName = getObjNameFromDom( dom, "objName", "1" );
					parentNode = parentNodeList.item(0);
					childNodeList = parentNode.getChildNodes();
					childNode = childNodeList.item(ctr);
					childNodeName = childNode.getNodeName();
					valueXmlString.append("<Detail1>");
					childNodeListLength = childNodeList.getLength();
					System.out.println("currentColumn-------->>[" + currentColumn + "]"+"objName["+objName+"]");
					
					if("itm_default".equalsIgnoreCase(currentColumn.trim()))
					{
						loginSite = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginSiteCode");
						valueXmlString.append("<site_code>").append("<![CDATA["+loginSite+"]]>").append("</site_code>");
						valueXmlString.append("<tran_date>").append("<![CDATA[" + sdf.format(new Date())+ "]]>").append("</tran_date>");
						
						if("gstr_purc".equalsIgnoreCase(objName.trim()))
						{
							sql = "select fld_value,descr from gencodes where fld_name='REC_TYPE' and mod_name='W_GSTR_PURC'";
							pstmt = conn.prepareStatement(sql);
							rs = pstmt.executeQuery();
							while(rs.next())
							{
								rec_type = rs.getString("fld_value");
								recDescr = rs.getString("descr");
								if(rec_type.equalsIgnoreCase("2") && recDescr.equalsIgnoreCase("GSTR2"))
								{
									valueXmlString.append("<rec_type>").append("<![CDATA["+rec_type+"]]>").append("</rec_type>");
									valueXmlString.append("<rec_type_descr>").append("<![CDATA["+recDescr+"]]>").append("</rec_type_descr>");
								}
							}
							if(pstmt != null)
							{
							    pstmt.close(); 
							    pstmt = null;
							}
							if(rs != null)
							{
								rs.close();
							    rs = null;
							}
						}//end of if block for obj_name='gstr_purc'
						
						gst_codeVal = gstUtility.checkNull(getStateFromLoginSite(loginSite,conn));
						gst_type = gstUtility.checkNull(genericUtility.getColumnValue("gst_type", dom));
						
						if("L".equalsIgnoreCase(gst_type))
						{
							valueXmlString.append("<submit_status protect = \"0\" visible = \"0\">").append("<![CDATA[P]]>").append("</submit_status>");
						}
						
						valueXmlString.append("<doc_type protect = \"0\" visible = \"1\">").append("<![CDATA[R    ]]>").append("</doc_type>");
						valueXmlString.append("<tax_reg_no protect = \"0\" visible = \"1\">").append("<![CDATA[]]>").append("</tax_reg_no>");
						valueXmlString.append("<cust_name protect = \"0\" visible = \"0\">").append("<![CDATA[]]>").append("</cust_name>");
						valueXmlString.append("<gst_code_state protect = \"0\" visible = \"1\">").append("<![CDATA["+gst_codeVal+"]]>").append("</gst_code_state>");
						valueXmlString.append("<state_descr protect = \"0\" visible = \"0\">").append("<![CDATA[]]>").append("</state_descr>");
						valueXmlString.append("<doc_no protect = \"0\" visible = \"1\">").append("<![CDATA[]]>").append("</doc_no>");
						valueXmlString.append("<doc_date protect = \"0\" visible = \"1\">").append("<![CDATA[]]>").append("</doc_date>");					
						valueXmlString.append("<amount protect = \"0\" visible = \"1\">").append("<![CDATA[]]>").append("</amount>");
						valueXmlString.append("<reverse_chrg protect = \"0\" visible = \"0\">").append("<![CDATA[N]]>").append("</reverse_chrg>");
						valueXmlString.append("<ecom_reg_no protect = \"0\" visible = \"0\">").append("<![CDATA[]]>").append("</ecom_reg_no>");
						valueXmlString.append("<gst_code protect = \"0\" visible = \"1\">").append("<![CDATA[]]>").append("</gst_code>");	
						valueXmlString.append("<ref_id__inv protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</ref_id__inv>");
						valueXmlString.append("<ref_date__inv protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</ref_date__inv>");
						valueXmlString.append("<lr_no protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</lr_no>");	  
						valueXmlString.append("<lr_date protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</lr_date>");
						valueXmlString.append("<name protect = \"0\" visible = \"0\">").append("<![CDATA[]]>").append("</name>");
						valueXmlString.append("<addr1 protect = \"0\" visible = \"0\">").append("<![CDATA[]]>").append("</addr1>");
						valueXmlString.append("<addr2 protect = \"0\" visible = \"0\">").append("<![CDATA[]]>").append("</addr2>");
						valueXmlString.append("<addr3 protect = \"0\" visible = \"0\">").append("<![CDATA[]]>").append("</addr3>");
						valueXmlString.append("<city protect = \"0\" visible = \"0\">").append("<![CDATA[]]>").append("</city>");
						valueXmlString.append("<gst_state_code protect = \"0\" visible = \"0\">").append("<![CDATA[]]>").append("</gst_state_code>");
						valueXmlString.append("<pin protect = \"0\" visible = \"0\">").append("<![CDATA[]]>").append("</pin>");
						valueXmlString.append("<order_no protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</order_no>");
						valueXmlString.append("<reas_code protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</reas_code>");	
					}//end of method item-default
					
					else if("itm_defaultedit".equalsIgnoreCase(currentColumn.trim()))
					{
						gst_type = gstUtility.checkNull(genericUtility.getColumnValue("gst_type", dom));//System.out.println("Return Value"+"gst_type ::::::::::"+gst_type);			
						sql = "select descr from gencodes where fld_name='GST_TYPE' and mod_name='W_GSTR_PURC' and fld_value=?";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1,gst_type);
						rs = pstmt.executeQuery();	
						if(rs.next())
						{
							gstDescr = rs.getString("descr");
							System.out.println("gstDescr["+gstDescr+"]");	
						}
						if(pstmt != null)
						{
							pstmt.close(); 
							pstmt = null;
						}
						if(rs != null)
						{
							rs.close();
							rs = null;
						}
						valueXmlString.append("<gst_type_descr>").append("<![CDATA["+gstDescr+"]]>").append("</gst_type_descr>");
						
						gstTypeEdit = gstUtility.checkNull(genericUtility.getColumnValue("gst_type", dom));
						taxRegNoEdit = gstUtility.checkNull(genericUtility.getColumnValue("tax_reg_no", dom));
						docTypeEdit=   gstUtility.checkNull(genericUtility.getColumnValue("doc_type", dom));
						docNoEdit =    gstUtility.checkNull(genericUtility.getColumnValue("doc_no", dom));
						docDateEdit =  gstUtility.checkNull(genericUtility.getColumnValue("doc_date", dom));
						amountEdit = gstUtility.checkNull(genericUtility.getColumnValue("amount", dom));
						gstCodeEdit = gstUtility.checkNull(genericUtility.getColumnValue("gst_code_state", dom));
						stateDescEdit = gstUtility.checkNull(genericUtility.getColumnValue("state_descr", dom));
						ecomRegEdit = gstUtility.checkNull(genericUtility.getColumnValue("ecom_reg_no", dom));
						revChrEdit = gstUtility.checkNull(genericUtility.getColumnValue("reverse_chrg", dom));
						refIfInvEdit = gstUtility.checkNull(genericUtility.getColumnValue("ref_id__inv", dom));
						refDateInvEdit = gstUtility.checkNull(genericUtility.getColumnValue("ref_date__inv", dom));
						lrNoEdit = gstUtility.checkNull(genericUtility.getColumnValue("lr_no", dom));
						lrDateEdit = gstUtility.checkNull(genericUtility.getColumnValue("lr_date", dom));
						nameEdit = gstUtility.checkNull(genericUtility.getColumnValue("name", dom));
						addr1Edit = gstUtility.checkNull(genericUtility.getColumnValue("addr1", dom));
						addr2Edit = gstUtility.checkNull(genericUtility.getColumnValue("addr2", dom));
						addr3Edit = gstUtility.checkNull(genericUtility.getColumnValue("addr3", dom));
						cityEdit = gstUtility.checkNull(genericUtility.getColumnValue("city", dom));
						stateEdit = gstUtility.checkNull(genericUtility.getColumnValue("gst_state_code", dom));
						pinEdit = gstUtility.checkNull(genericUtility.getColumnValue("pin", dom));
						orderNoEdit = gstUtility.checkNull(genericUtility.getColumnValue("order_no", dom));
						reasonCdEdit = gstUtility.checkNull(genericUtility.getColumnValue("reas_code", dom));
						custNameEdit = gstUtility.checkNull(genericUtility.getColumnValue("cust_name", dom));
						System.out.println("Value of dom2:::::"+dom2.getElementsByTagName("Detail2").getLength());
						
						if(dom2.getElementsByTagName("Detail2") != null && dom2.getElementsByTagName("Detail2").getLength() > 0)
						{
							System.out.println("in detail 1");
							valueXmlString.append("<gst_type protect = \"1\"  visible = \"1\">").append("<![CDATA["+gstTypeEdit+"]]>").append("</gst_type>");
							valueXmlString.append("<doc_type protect = \"1\"  visible = \"1\">").append("<![CDATA["+docTypeEdit+"]]>").append("</doc_type>");
							valueXmlString.append("<tax_reg_no protect = \"1\"  visible = \"1\">").append("<![CDATA["+taxRegNoEdit+"]]>").append("</tax_reg_no>");
							valueXmlString.append("<gst_code_state protect = \"1\" visible = \"1\">").append("<![CDATA["+gstCodeEdit+"]]>").append("</gst_code_state>");
						}
						
						if("I".equalsIgnoreCase(gst_type))
						{
							if(taxRegNoEdit == null || taxRegNoEdit.trim().length()== 0)
							{
								//valueXmlString.append("<doc_type protect = \"0\" visible = \"1\">").append("<![CDATA["+docTypeEdit+"]]>").append("</doc_type>");
								//valueXmlString.append("<tax_reg_no protect = \"0\" visible = \"1\">").append("<![CDATA["+taxRegNoEdit+"]]>").append("</tax_reg_no>");
								valueXmlString.append("<cust_name protect = \"0\" visible = \"0\">").append("<![CDATA[]]>").append("</cust_name>");
								//valueXmlString.append("<gst_code_state protect = \"0\" visible = \"1\">").append("<![CDATA["+gstCodeEdit+"]]>").append("</gst_code_state>");
								valueXmlString.append("<state_descr protect = \"0\" visible = \"0\">").append("<![CDATA["+stateDescEdit+"]]>").append("</state_descr>");
								valueXmlString.append("<doc_no protect = \"0\" visible = \"1\">").append("<![CDATA["+docNoEdit+"]]>").append("</doc_no>");
								valueXmlString.append("<doc_date protect = \"0\" visible = \"1\">").append("<![CDATA["+docDateEdit+"]]>").append("</doc_date>");					
								valueXmlString.append("<amount protect = \"0\" visible = \"1\">").append("<![CDATA["+amountEdit+"]]>").append("</amount>");
								valueXmlString.append("<reverse_chrg protect = \"0\" visible = \"0\">").append("<![CDATA["+revChrEdit+"]]>").append("</reverse_chrg>");
								valueXmlString.append("<ecom_reg_no protect = \"0\" visible = \"0\">").append("<![CDATA["+ecomRegEdit+"]]>").append("</ecom_reg_no>");
								valueXmlString.append("<gst_code protect = \"0\" visible = \"1\">").append("<![CDATA["+gstCodeEdit+"]]>").append("</gst_code>");	
								valueXmlString.append("<ref_id__inv protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</ref_id__inv>");
								valueXmlString.append("<ref_date__inv protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</ref_date__inv>");
								valueXmlString.append("<lr_no protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</lr_no>");	  
								valueXmlString.append("<lr_date protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</lr_date>");
								valueXmlString.append("<name protect = \"0\" visible = \"0\">").append("<![CDATA["+nameEdit+"]]>").append("</name>");
								valueXmlString.append("<addr1 protect = \"0\" visible = \"0\">").append("<![CDATA["+addr1Edit+"]]>").append("</addr1>");
								valueXmlString.append("<addr2 protect = \"0\" visible = \"0\">").append("<![CDATA["+addr2Edit+"]]>").append("</addr2>");
								valueXmlString.append("<addr3 protect = \"0\" visible = \"0\">").append("<![CDATA["+addr3Edit+"]]>").append("</addr3>");
								valueXmlString.append("<city protect = \"0\" visible = \"0\">").append("<![CDATA["+cityEdit+"]]>").append("</city>");
								valueXmlString.append("<gst_state_code protect = \"0\" visible = \"0\">").append("<![CDATA["+stateEdit+"]]>").append("</gst_state_code>");
								valueXmlString.append("<pin protect = \"0\" visible = \"0\">").append("<![CDATA["+pinEdit+"]]>").append("</pin>");
								valueXmlString.append("<order_no protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</order_no>");
								valueXmlString.append("<reas_code protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</reas_code>");	
							}
							else
							{
								//valueXmlString.append("<doc_type protect = \"0\" visible = \"1\">").append("<![CDATA["+docTypeEdit+"]]>").append("</doc_type>");
								//valueXmlString.append("<tax_reg_no protect = \"0\" visible = \"1\">").append("<![CDATA["+taxRegNoEdit+"]]>").append("</tax_reg_no>");
								valueXmlString.append("<cust_name protect = \"0\" visible = \"0\">").append("<![CDATA[]]>").append("</cust_name>");
								//valueXmlString.append("<gst_code_state protect = \"0\" visible = \"1\">").append("<![CDATA["+gstCodeEdit+"]]>").append("</gst_code_state>");
								valueXmlString.append("<state_descr protect = \"0\" visible = \"0\">").append("<![CDATA["+stateDescEdit+"]]>").append("</state_descr>");
								valueXmlString.append("<doc_no protect = \"0\" visible = \"1\">").append("<![CDATA["+docNoEdit+"]]>").append("</doc_no>");
								valueXmlString.append("<doc_date protect = \"0\" visible = \"1\">").append("<![CDATA["+docDateEdit+"]]>").append("</doc_date>");					
								valueXmlString.append("<amount protect = \"0\" visible = \"1\">").append("<![CDATA["+amountEdit+"]]>").append("</amount>");
								valueXmlString.append("<reverse_chrg protect = \"0\" visible = \"0\">").append("<![CDATA["+revChrEdit+"]]>").append("</reverse_chrg>");
								valueXmlString.append("<ecom_reg_no protect = \"0\" visible = \"0\">").append("<![CDATA["+ecomRegEdit+"]]>").append("</ecom_reg_no>");
								valueXmlString.append("<gst_code protect = \"0\" visible = \"1\">").append("<![CDATA["+gstCodeEdit+"]]>").append("</gst_code>");	
								valueXmlString.append("<ref_id__inv protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</ref_id__inv>");
								valueXmlString.append("<ref_date__inv protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</ref_date__inv>");
								valueXmlString.append("<lr_no protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</lr_no>");	  
								valueXmlString.append("<lr_date protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</lr_date>");
								valueXmlString.append("<name protect = \"0\" visible = \"1\">").append("<![CDATA["+nameEdit+"]]>").append("</name>");
								valueXmlString.append("<addr1 protect = \"0\" visible = \"1\">").append("<![CDATA["+addr1Edit+"]]>").append("</addr1>");
								valueXmlString.append("<addr2 protect = \"0\" visible = \"1\">").append("<![CDATA["+addr2Edit+"]]>").append("</addr2>");
								valueXmlString.append("<addr3 protect = \"0\" visible = \"1\">").append("<![CDATA["+addr3Edit+"]]>").append("</addr3>");
								valueXmlString.append("<city protect = \"0\" visible = \"1\">").append("<![CDATA["+cityEdit+"]]>").append("</city>");
								valueXmlString.append("<gst_state_code protect = \"0\" visible = \"1\">").append("<![CDATA["+stateEdit+"]]>").append("</gst_state_code>");
								valueXmlString.append("<pin protect = \"0\" visible = \"1\">").append("<![CDATA["+pinEdit+"]]>").append("</pin>");
								valueXmlString.append("<order_no protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</order_no>");
								valueXmlString.append("<reas_code protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</reas_code>");	
							}
						}
						
						else if("R".equalsIgnoreCase(gst_type))
						{
							if(taxRegNoEdit == null || taxRegNoEdit.trim().length()== 0)
							{
								valueXmlString.append("<doc_type protect = \"0\" visible = \"0\">").append("<![CDATA["+docTypeEdit+"]]>").append("</doc_type>");
								//valueXmlString.append("<tax_reg_no protect = \"0\" visible = \"1\">").append("<![CDATA["+taxRegNoEdit+"]]>").append("</tax_reg_no>");
								valueXmlString.append("<cust_name protect = \"0\" visible = \"0\">").append("<![CDATA[]]>").append("</cust_name>");
								//valueXmlString.append("<gst_code_state protect = \"0\" visible = \"1\">").append("<![CDATA["+gstCodeEdit+"]]>").append("</gst_code_state>");
								valueXmlString.append("<state_descr protect = \"0\" visible = \"0\">").append("<![CDATA["+stateDescEdit+"]]>").append("</state_descr>");
								valueXmlString.append("<doc_no protect = \"0\" visible = \"1\">").append("<![CDATA["+docNoEdit+"]]>").append("</doc_no>");
								valueXmlString.append("<doc_date protect = \"0\" visible = \"1\">").append("<![CDATA["+docDateEdit+"]]>").append("</doc_date>");					
								valueXmlString.append("<amount protect = \"0\" visible = \"1\">").append("<![CDATA["+amountEdit+"]]>").append("</amount>");
								valueXmlString.append("<reverse_chrg protect = \"1\" visible = \"1\">").append("<![CDATA["+revChrEdit+"]]>").append("</reverse_chrg>");
								valueXmlString.append("<ecom_reg_no protect = \"0\" visible = \"0\">").append("<![CDATA["+ecomRegEdit+"]]>").append("</ecom_reg_no>");
								valueXmlString.append("<gst_code protect = \"0\" visible = \"1\">").append("<![CDATA["+gstCodeEdit+"]]>").append("</gst_code>");	
								valueXmlString.append("<ref_id__inv protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</ref_id__inv>");
								valueXmlString.append("<ref_date__inv protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</ref_date__inv>");
								valueXmlString.append("<lr_no protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</lr_no>");	  
								valueXmlString.append("<lr_date protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</lr_date>");
								valueXmlString.append("<name protect = \"0\" visible = \"0\">").append("<![CDATA["+nameEdit+"]]>").append("</name>");
								valueXmlString.append("<addr1 protect = \"0\" visible = \"0\">").append("<![CDATA["+addr1Edit+"]]>").append("</addr1>");
								valueXmlString.append("<addr2 protect = \"0\" visible = \"0\">").append("<![CDATA["+addr2Edit+"]]>").append("</addr2>");
								valueXmlString.append("<addr3 protect = \"0\" visible = \"0\">").append("<![CDATA["+addr3Edit+"]]>").append("</addr3>");
								valueXmlString.append("<city protect = \"0\" visible = \"0\">").append("<![CDATA["+cityEdit+"]]>").append("</city>");
								valueXmlString.append("<gst_state_code protect = \"0\" visible = \"0\">").append("<![CDATA["+stateEdit+"]]>").append("</gst_state_code>");
								valueXmlString.append("<pin protect = \"0\" visible = \"0\">").append("<![CDATA["+pinEdit+"]]>").append("</pin>");
								valueXmlString.append("<order_no protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</order_no>");
								valueXmlString.append("<reas_code protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</reas_code>");	
							}
							else
							{
								valueXmlString.append("<doc_type protect = \"0\" visible = \"0\">").append("<![CDATA["+docTypeEdit+"]]>").append("</doc_type>");
								//valueXmlString.append("<tax_reg_no protect = \"0\" visible = \"1\">").append("<![CDATA["+taxRegNoEdit+"]]>").append("</tax_reg_no>");
								valueXmlString.append("<cust_name protect = \"0\" visible = \"0\">").append("<![CDATA[]]>").append("</cust_name>");
								//valueXmlString.append("<gst_code_state protect = \"0\" visible = \"1\">").append("<![CDATA["+gstCodeEdit+"]]>").append("</gst_code_state>");
								valueXmlString.append("<state_descr protect = \"0\" visible = \"0\">").append("<![CDATA["+stateDescEdit+"]]>").append("</state_descr>");
								valueXmlString.append("<doc_no protect = \"0\" visible = \"1\">").append("<![CDATA["+docNoEdit+"]]>").append("</doc_no>");
								valueXmlString.append("<doc_date protect = \"0\" visible = \"1\">").append("<![CDATA["+docDateEdit+"]]>").append("</doc_date>");					
								valueXmlString.append("<amount protect = \"0\" visible = \"1\">").append("<![CDATA["+amountEdit+"]]>").append("</amount>");
								valueXmlString.append("<reverse_chrg protect = \"1\" visible = \"1\">").append("<![CDATA["+revChrEdit+"]]>").append("</reverse_chrg>");
								valueXmlString.append("<ecom_reg_no protect = \"0\" visible = \"0\">").append("<![CDATA["+ecomRegEdit+"]]>").append("</ecom_reg_no>");
								valueXmlString.append("<gst_code protect = \"0\" visible = \"1\">").append("<![CDATA["+gstCodeEdit+"]]>").append("</gst_code>");	
								valueXmlString.append("<ref_id__inv protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</ref_id__inv>");
								valueXmlString.append("<ref_date__inv protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</ref_date__inv>");
								valueXmlString.append("<lr_no protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</lr_no>");	  
								valueXmlString.append("<lr_date protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</lr_date>");
								valueXmlString.append("<name protect = \"0\" visible = \"1\">").append("<![CDATA["+nameEdit+"]]>").append("</name>");
								valueXmlString.append("<addr1 protect = \"0\" visible = \"1\">").append("<![CDATA["+addr1Edit+"]]>").append("</addr1>");
								valueXmlString.append("<addr2 protect = \"0\" visible = \"1\">").append("<![CDATA["+addr2Edit+"]]>").append("</addr2>");
								valueXmlString.append("<addr3 protect = \"0\" visible = \"1\">").append("<![CDATA["+addr3Edit+"]]>").append("</addr3>");
								valueXmlString.append("<city protect = \"0\" visible = \"1\">").append("<![CDATA["+cityEdit+"]]>").append("</city>");
								valueXmlString.append("<gst_state_code protect = \"0\" visible = \"1\">").append("<![CDATA["+stateEdit+"]]>").append("</gst_state_code>");
								valueXmlString.append("<pin protect = \"0\" visible = \"1\">").append("<![CDATA["+pinEdit+"]]>").append("</pin>");
								valueXmlString.append("<order_no protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</order_no>");
								valueXmlString.append("<reas_code protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</reas_code>");	
							}
						}
						
						else if("U".equalsIgnoreCase(gst_type))
						{
							valueXmlString.append("<doc_type protect = \"0\" visible = \"0\">").append("<![CDATA["+docTypeEdit+"]]>").append("</doc_type>");
							valueXmlString.append("<cust_name protect = \"0\" visible = \"1\">").append("<![CDATA["+custNameEdit+"]]>").append("</cust_name>");
							//valueXmlString.append("<tax_reg_no protect = \"0\" visible = \"0\">").append("<![CDATA[]]>").append("</tax_reg_no>");
							//valueXmlString.append("<gst_code_state protect = \"0\" visible = \"1\">").append("<![CDATA["+gstCodeEdit+"]]>").append("</gst_code_state>");
							valueXmlString.append("<state_descr protect = \"0\" visible = \"0\">").append("<![CDATA["+stateDescEdit+"]]>").append("</state_descr>");
							valueXmlString.append("<doc_no protect = \"0\" visible = \"1\">").append("<![CDATA["+docNoEdit+"]]>").append("</doc_no>");
							valueXmlString.append("<doc_date protect = \"0\" visible = \"1\">").append("<![CDATA["+docDateEdit+"]]>").append("</doc_date>");					
							valueXmlString.append("<amount protect = \"0\" visible = \"1\">").append("<![CDATA["+amountEdit+"]]>").append("</amount>");
							valueXmlString.append("<reverse_chrg protect = \"0\" visible = \"0\">").append("<![CDATA["+revChrEdit+"]]>").append("</reverse_chrg>");
							valueXmlString.append("<ecom_reg_no protect = \"0\" visible = \"0\">").append("<![CDATA["+ecomRegEdit+"]]>").append("</ecom_reg_no>");
							valueXmlString.append("<gst_code protect = \"0\" visible = \"1\">").append("<![CDATA["+gstCodeEdit+"]]>").append("</gst_code>");	
							valueXmlString.append("<ref_id__inv protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</ref_id__inv>");
							valueXmlString.append("<ref_date__inv protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</ref_date__inv>");
							valueXmlString.append("<lr_no protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</lr_no>");	  
							valueXmlString.append("<lr_date protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</lr_date>");
							valueXmlString.append("<name protect = \"0\" visible = \"0\">").append("<![CDATA[]]>").append("</name>");
							valueXmlString.append("<addr1 protect = \"0\" visible = \"0\">").append("<![CDATA[]]>").append("</addr1>");
							valueXmlString.append("<addr2 protect = \"0\" visible = \"0\">").append("<![CDATA[]]>").append("</addr2>");
							valueXmlString.append("<addr3 protect = \"0\" visible = \"0\">").append("<![CDATA[]]>").append("</addr3>");
							valueXmlString.append("<city protect = \"0\" visible = \"0\">").append("<![CDATA[]]>").append("</city>");
							valueXmlString.append("<gst_state_code protect = \"0\" visible = \"0\">").append("<![CDATA[]]>").append("</gst_state_code>");
							valueXmlString.append("<pin protect = \"0\" visible = \"0\">").append("<![CDATA[]]>").append("</pin>");
							valueXmlString.append("<order_no protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</order_no>");
							valueXmlString.append("<reas_code protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</reas_code>");			
						}
						
						else if("S".equalsIgnoreCase(gst_type))
						{
							valueXmlString.append("<doc_type protect = \"0\" visible = \"0\">").append("<![CDATA[]]>").append("</doc_type>");
							valueXmlString.append("<tax_reg_no protect = \"0\" visible = \"0\">").append("<![CDATA[]]>").append("</tax_reg_no>");
							valueXmlString.append("<cust_name protect = \"0\" visible = \"0\">").append("<![CDATA[]]>").append("</cust_name>");
							//valueXmlString.append("<gst_code_state protect = \"0\" visible = \"1\">").append("<![CDATA[]]>").append("</gst_code_state>");
							valueXmlString.append("<state_descr protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</state_descr>");
							valueXmlString.append("<doc_no protect = \"0\" visible = \"1\">").append("<![CDATA["+docNoEdit+"]]>").append("</doc_no>");
							valueXmlString.append("<doc_date protect = \"0\" visible = \"1\">").append("<![CDATA["+docDateEdit+"]]>").append("</doc_date>");					
							valueXmlString.append("<amount protect = \"0\" visible = \"1\">").append("<![CDATA["+amountEdit+"]]>").append("</amount>");
							valueXmlString.append("<reverse_chrg protect = \"0\" visible = \"0\">").append("<![CDATA[N]]>").append("</reverse_chrg>");
							valueXmlString.append("<ecom_reg_no protect = \"0\" visible = \"0\">").append("<![CDATA[]]>").append("</ecom_reg_no>");
							valueXmlString.append("<gst_code protect = \"0\" visible = \"0\">").append("<![CDATA[]]>").append("</gst_code>");	
							valueXmlString.append("<ref_id__inv protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</ref_id__inv>");
							valueXmlString.append("<ref_date__inv protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</ref_date__inv>");
							valueXmlString.append("<lr_no protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</lr_no>");	  
							valueXmlString.append("<lr_date protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</lr_date>");
							valueXmlString.append("<name protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</name>");
							valueXmlString.append("<addr1 protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</addr1>");
							valueXmlString.append("<addr2 protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</addr2>");
							valueXmlString.append("<addr3 protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</addr3>");
							valueXmlString.append("<city protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</city>");
							valueXmlString.append("<gst_state_code protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</gst_state_code>");
							valueXmlString.append("<pin protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</pin>");
							valueXmlString.append("<order_no protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</order_no>");
							valueXmlString.append("<reas_code protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</reas_code>");	
						}
						
						else if("G".equalsIgnoreCase(gst_type))
						{
							if(taxRegNoEdit == null || taxRegNoEdit.trim().length()== 0)
							{
								valueXmlString.append("<doc_type protect = \"0\" visible = \"0\">").append("<![CDATA[]]>").append("</doc_type>");
								//valueXmlString.append("<tax_reg_no protect = \"0\" visible = \"1\">").append("<![CDATA["+taxRegNoEdit+"]]>").append("</tax_reg_no>");
								valueXmlString.append("<cust_name protect = \"0\" visible = \"0\">").append("<![CDATA[]]>").append("</cust_name>");
								valueXmlString.append("<gst_code_state protect = \"0\" visible = \"0\">").append("<![CDATA[]]>").append("</gst_code_state>");
								valueXmlString.append("<state_descr protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</state_descr>");
								valueXmlString.append("<doc_no protect = \"0\" visible = \"0\">").append("<![CDATA[]]>").append("</doc_no>");
								valueXmlString.append("<doc_date protect = \"0\" visible = \"0\">").append("<![CDATA[]]>").append("</doc_date>");					
								valueXmlString.append("<amount protect = \"0\" visible = \"1\">").append("<![CDATA["+amountEdit+"]]>").append("</amount>");
								valueXmlString.append("<reverse_chrg protect = \"0\" visible = \"0\">").append("<![CDATA[N]]>").append("</reverse_chrg>");
								valueXmlString.append("<ecom_reg_no protect = \"0\" visible = \"0\">").append("<![CDATA[]]>").append("</ecom_reg_no>");
								valueXmlString.append("<gst_code protect = \"0\" visible = \"0\">").append("<![CDATA[]]>").append("</gst_code>");	
								valueXmlString.append("<ref_id__inv protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</ref_id__inv>");
								valueXmlString.append("<ref_date__inv protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</ref_date__inv>");
								valueXmlString.append("<name protect = \"1\" visible = \"0\">").append("<![CDATA["+nameEdit+"]]>").append("</name>");
								valueXmlString.append("<addr1 protect = \"1\" visible = \"0\">").append("<![CDATA["+addr1Edit+"]]>").append("</addr1>");
								valueXmlString.append("<addr2 protect = \"1\" visible = \"0\">").append("<![CDATA["+addr2Edit+"]]>").append("</addr2>");
								valueXmlString.append("<addr3 protect = \"1\" visible = \"0\">").append("<![CDATA["+addr3Edit+"]]>").append("</addr3>");
								valueXmlString.append("<city protect = \"1\" visible = \"0\">").append("<![CDATA["+cityEdit+"]]>").append("</city>");
								valueXmlString.append("<gst_state_code protect = \"1\" visible = \"0\">").append("<![CDATA["+stateEdit+"]]>").append("</gst_state_code>");
								valueXmlString.append("<pin protect = \"1\" visible = \"0\">").append("<![CDATA["+pinEdit+"]]>").append("</pin>");								
								valueXmlString.append("<lr_no protect = \"0\" visible = \"1\">").append("<![CDATA["+lrNoEdit+"]]>").append("</lr_no>");	  
								valueXmlString.append("<lr_date protect = \"0\" visible = \"1\">").append("<![CDATA["+lrDateEdit+"]]>").append("</lr_date>");
								valueXmlString.append("<order_no protect = \"0\" visible = \"1\">").append("<![CDATA["+orderNoEdit+"]]>").append("</order_no>");
								valueXmlString.append("<reas_code protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</reas_code>");	
							}
							else
							{
								valueXmlString.append("<doc_type protect = \"0\" visible = \"0\">").append("<![CDATA[]]>").append("</doc_type>");
								//valueXmlString.append("<tax_reg_no protect = \"0\" visible = \"1\">").append("<![CDATA["+taxRegNoEdit+"]]>").append("</tax_reg_no>");
								valueXmlString.append("<cust_name protect = \"0\" visible = \"0\">").append("<![CDATA[]]>").append("</cust_name>");
								valueXmlString.append("<gst_code_state protect = \"0\" visible = \"0\">").append("<![CDATA[]]>").append("</gst_code_state>");
								valueXmlString.append("<state_descr protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</state_descr>");
								valueXmlString.append("<doc_no protect = \"0\" visible = \"0\">").append("<![CDATA[]]>").append("</doc_no>");
								valueXmlString.append("<doc_date protect = \"0\" visible = \"0\">").append("<![CDATA[]]>").append("</doc_date>");					
								valueXmlString.append("<amount protect = \"0\" visible = \"1\">").append("<![CDATA["+amountEdit+"]]>").append("</amount>");
								valueXmlString.append("<reverse_chrg protect = \"0\" visible = \"0\">").append("<![CDATA[N]]>").append("</reverse_chrg>");
								valueXmlString.append("<ecom_reg_no protect = \"0\" visible = \"0\">").append("<![CDATA[]]>").append("</ecom_reg_no>");
								valueXmlString.append("<gst_code protect = \"0\" visible = \"0\">").append("<![CDATA[]]>").append("</gst_code>");	
								valueXmlString.append("<ref_id__inv protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</ref_id__inv>");
								valueXmlString.append("<ref_date__inv protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</ref_date__inv>");
								valueXmlString.append("<name protect = \"0\" visible = \"1\">").append("<![CDATA["+nameEdit+"]]>").append("</name>");
								valueXmlString.append("<addr1 protect = \"0\" visible = \"1\">").append("<![CDATA["+addr1Edit+"]]>").append("</addr1>");
								valueXmlString.append("<addr2 protect = \"0\" visible = \"1\">").append("<![CDATA["+addr2Edit+"]]>").append("</addr2>");
								valueXmlString.append("<addr3 protect = \"0\" visible = \"1\">").append("<![CDATA["+addr3Edit+"]]>").append("</addr3>");
								valueXmlString.append("<city protect = \"0\" visible = \"1\">").append("<![CDATA["+cityEdit+"]]>").append("</city>");
								valueXmlString.append("<gst_state_code protect = \"0\" visible = \"1\">").append("<![CDATA["+stateEdit+"]]>").append("</gst_state_code>");
								valueXmlString.append("<pin protect = \"0\" visible = \"1\">").append("<![CDATA["+pinEdit+"]]>").append("</pin>");								
								valueXmlString.append("<lr_no protect = \"0\" visible = \"1\">").append("<![CDATA["+lrNoEdit+"]]>").append("</lr_no>");	  
								valueXmlString.append("<lr_date protect = \"0\" visible = \"1\">").append("<![CDATA["+lrDateEdit+"]]>").append("</lr_date>");
								valueXmlString.append("<order_no protect = \"0\" visible = \"1\">").append("<![CDATA["+orderNoEdit+"]]>").append("</order_no>");
								valueXmlString.append("<reas_code protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</reas_code>");	
							}
						}	
						else if("D".equalsIgnoreCase(gst_type))
						{
							if(taxRegNoEdit == null || taxRegNoEdit.trim().length()== 0)
							{
								valueXmlString.append("<doc_type protect = \"0\" visible = \"0\">").append("<![CDATA["+docTypeEdit+"]]>").append("</doc_type>");
								//valueXmlString.append("<tax_reg_no protect = \"0\" visible = \"1\">").append("<![CDATA["+taxRegNoEdit+"]]>").append("</tax_reg_no>");
								valueXmlString.append("<cust_name protect = \"0\" visible = \"0\">").append("<![CDATA[]]>").append("</cust_name>");
								valueXmlString.append("<doc_no protect = \"0\" visible = \"1\">").append("<![CDATA["+docNoEdit+"]]>").append("</doc_no>");
								valueXmlString.append("<doc_date protect = \"0\" visible = \"1\">").append("<![CDATA["+docDateEdit+"]]>").append("</doc_date>");					
								valueXmlString.append("<amount protect = \"0\" visible = \"1\">").append("<![CDATA["+amountEdit+"]]>").append("</amount>");
								valueXmlString.append("<reas_code protect = \"0\" visible = \"1\">").append("<![CDATA["+reasonCdEdit+"]]>").append("</reas_code>");
								valueXmlString.append("<ref_id__inv protect = \"0\" visible = \"1\">").append("<![CDATA["+refIfInvEdit+"]]>").append("</ref_id__inv>");
								valueXmlString.append("<ref_date__inv protect = \"0\" visible = \"1\">").append("<![CDATA["+refDateInvEdit+"]]>").append("</ref_date__inv>");
								valueXmlString.append("<reverse_chrg protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</reverse_chrg>");
								valueXmlString.append("<ecom_reg_no protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</ecom_reg_no>");
								valueXmlString.append("<gst_code protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</gst_code>");	
								valueXmlString.append("<name protect = \"0\" visible = \"0\">").append("<![CDATA["+nameEdit+"]]>").append("</name>");
								valueXmlString.append("<addr1 protect = \"0\" visible = \"0\">").append("<![CDATA["+addr1Edit+"]]>").append("</addr1>");
								valueXmlString.append("<addr2 protect = \"0\" visible = \"0\">").append("<![CDATA["+addr2Edit+"]]>").append("</addr2>");
								valueXmlString.append("<addr3 protect = \"0\" visible = \"0\">").append("<![CDATA["+addr3Edit+"]]>").append("</addr3>");
								valueXmlString.append("<city protect = \"0\" visible = \"0\">").append("<![CDATA["+cityEdit+"]]>").append("</city>");
								valueXmlString.append("<gst_state_code protect = \"0\" visible = \"0\">").append("<![CDATA["+stateEdit+"]]>").append("</gst_state_code>");
								valueXmlString.append("<pin protect = \"0\" visible = \"0\">").append("<![CDATA["+pinEdit+"]]>").append("</pin>");
								valueXmlString.append("<gst_code_state protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</gst_code_state>");
								valueXmlString.append("<state_descr protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</state_descr>");
								valueXmlString.append("<order_no protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</order_no>");
								valueXmlString.append("<lr_no protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</lr_no>");	  
								valueXmlString.append("<lr_date protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</lr_date>");
							}
							else
							{
								valueXmlString.append("<doc_type protect = \"0\" visible = \"0\">").append("<![CDATA["+docTypeEdit+"]]>").append("</doc_type>");
								//valueXmlString.append("<tax_reg_no protect = \"0\" visible = \"1\">").append("<![CDATA["+taxRegNoEdit+"]]>").append("</tax_reg_no>");
								valueXmlString.append("<cust_name protect = \"0\" visible = \"0\">").append("<![CDATA[]]>").append("</cust_name>");
								valueXmlString.append("<doc_no protect = \"0\" visible = \"1\">").append("<![CDATA["+docNoEdit+"]]>").append("</doc_no>");
								valueXmlString.append("<doc_date protect = \"0\" visible = \"1\">").append("<![CDATA["+docDateEdit+"]]>").append("</doc_date>");					
								valueXmlString.append("<amount protect = \"0\" visible = \"1\">").append("<![CDATA["+amountEdit+"]]>").append("</amount>");
								valueXmlString.append("<reas_code protect = \"0\" visible = \"1\">").append("<![CDATA["+reasonCdEdit+"]]>").append("</reas_code>");
								valueXmlString.append("<ref_id__inv protect = \"0\" visible = \"1\">").append("<![CDATA["+refIfInvEdit+"]]>").append("</ref_id__inv>");
								valueXmlString.append("<ref_date__inv protect = \"0\" visible = \"1\">").append("<![CDATA["+refDateInvEdit+"]]>").append("</ref_date__inv>");
								valueXmlString.append("<reverse_chrg protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</reverse_chrg>");
								valueXmlString.append("<ecom_reg_no protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</ecom_reg_no>");
								valueXmlString.append("<gst_code protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</gst_code>");	
								valueXmlString.append("<name protect = \"0\" visible = \"1\">").append("<![CDATA["+nameEdit+"]]>").append("</name>");
								valueXmlString.append("<addr1 protect = \"0\" visible = \"1\">").append("<![CDATA["+addr1Edit+"]]>").append("</addr1>");
								valueXmlString.append("<addr2 protect = \"0\" visible = \"1\">").append("<![CDATA["+addr2Edit+"]]>").append("</addr2>");
								valueXmlString.append("<addr3 protect = \"0\" visible = \"1\">").append("<![CDATA["+addr3Edit+"]]>").append("</addr3>");
								valueXmlString.append("<city protect = \"0\" visible = \"1\">").append("<![CDATA["+cityEdit+"]]>").append("</city>");
								valueXmlString.append("<gst_state_code protect = \"0\" visible = \"1\">").append("<![CDATA["+stateEdit+"]]>").append("</gst_state_code>");
								valueXmlString.append("<pin protect = \"0\" visible = \"1\">").append("<![CDATA["+pinEdit+"]]>").append("</pin>");
								valueXmlString.append("<gst_code_state protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</gst_code_state>");
								valueXmlString.append("<state_descr protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</state_descr>");
								valueXmlString.append("<order_no protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</order_no>");
								valueXmlString.append("<lr_no protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</lr_no>");	  
								valueXmlString.append("<lr_date protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</lr_date>");
							}
						}
						else if("C".equalsIgnoreCase(gst_type))
						{
							if(taxRegNoEdit == null || taxRegNoEdit.trim().length()== 0)
							{
								valueXmlString.append("<doc_type protect = \"0\" visible = \"0\">").append("<![CDATA["+docTypeEdit+"]]>").append("</doc_type>");
								//valueXmlString.append("<tax_reg_no protect = \"0\" visible = \"1\">").append("<![CDATA["+taxRegNoEdit+"]]>").append("</tax_reg_no>");
								valueXmlString.append("<cust_name protect = \"0\" visible = \"0\">").append("<![CDATA[]]>").append("</cust_name>");
								valueXmlString.append("<doc_no protect = \"0\" visible = \"1\">").append("<![CDATA["+docNoEdit+"]]>").append("</doc_no>");
								valueXmlString.append("<doc_date protect = \"0\" visible = \"1\">").append("<![CDATA["+docDateEdit+"]]>").append("</doc_date>");					
								valueXmlString.append("<amount protect = \"0\" visible = \"1\">").append("<![CDATA["+amountEdit+"]]>").append("</amount>");
								valueXmlString.append("<reas_code protect = \"0\" visible = \"1\">").append("<![CDATA["+reasonCdEdit+"]]>").append("</reas_code>");
								valueXmlString.append("<ref_id__inv protect = \"0\" visible = \"1\">").append("<![CDATA["+refIfInvEdit+"]]>").append("</ref_id__inv>");
								valueXmlString.append("<ref_date__inv protect = \"0\" visible = \"1\">").append("<![CDATA["+refDateInvEdit+"]]>").append("</ref_date__inv>");
								valueXmlString.append("<reverse_chrg protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</reverse_chrg>");
								valueXmlString.append("<ecom_reg_no protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</ecom_reg_no>");
								valueXmlString.append("<gst_code protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</gst_code>");	
								valueXmlString.append("<name protect = \"0\" visible = \"0\">").append("<![CDATA["+nameEdit+"]]>").append("</name>");
								valueXmlString.append("<addr1 protect = \"0\" visible = \"0\">").append("<![CDATA["+addr1Edit+"]]>").append("</addr1>");
								valueXmlString.append("<addr2 protect = \"0\" visible = \"0\">").append("<![CDATA["+addr2Edit+"]]>").append("</addr2>");
								valueXmlString.append("<addr3 protect = \"0\" visible = \"0\">").append("<![CDATA["+addr3Edit+"]]>").append("</addr3>");
								valueXmlString.append("<city protect = \"0\" visible = \"0\">").append("<![CDATA["+cityEdit+"]]>").append("</city>");
								valueXmlString.append("<gst_state_code protect = \"0\" visible = \"0\">").append("<![CDATA["+stateEdit+"]]>").append("</gst_state_code>");
								valueXmlString.append("<pin protect = \"0\" visible = \"0\">").append("<![CDATA["+pinEdit+"]]>").append("</pin>");
								valueXmlString.append("<gst_code_state protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</gst_code_state>");
								valueXmlString.append("<state_descr protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</state_descr>");
								valueXmlString.append("<order_no protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</order_no>");
								valueXmlString.append("<lr_no protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</lr_no>");	  
								valueXmlString.append("<lr_date protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</lr_date>");
							}
							else
							{
								valueXmlString.append("<doc_type protect = \"0\" visible = \"0\">").append("<![CDATA["+docTypeEdit+"]]>").append("</doc_type>");
								//valueXmlString.append("<tax_reg_no protect = \"0\" visible = \"1\">").append("<![CDATA["+taxRegNoEdit+"]]>").append("</tax_reg_no>");
								valueXmlString.append("<cust_name protect = \"0\" visible = \"0\">").append("<![CDATA[]]>").append("</cust_name>");
								valueXmlString.append("<doc_no protect = \"0\" visible = \"1\">").append("<![CDATA["+docNoEdit+"]]>").append("</doc_no>");
								valueXmlString.append("<doc_date protect = \"0\" visible = \"1\">").append("<![CDATA["+docDateEdit+"]]>").append("</doc_date>");					
								valueXmlString.append("<amount protect = \"0\" visible = \"1\">").append("<![CDATA["+amountEdit+"]]>").append("</amount>");
								valueXmlString.append("<reas_code protect = \"0\" visible = \"1\">").append("<![CDATA["+reasonCdEdit+"]]>").append("</reas_code>");
								valueXmlString.append("<ref_id__inv protect = \"0\" visible = \"1\">").append("<![CDATA["+refIfInvEdit+"]]>").append("</ref_id__inv>");
								valueXmlString.append("<ref_date__inv protect = \"0\" visible = \"1\">").append("<![CDATA["+refDateInvEdit+"]]>").append("</ref_date__inv>");
								valueXmlString.append("<reverse_chrg protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</reverse_chrg>");
								valueXmlString.append("<ecom_reg_no protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</ecom_reg_no>");
								valueXmlString.append("<gst_code protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</gst_code>");	
								valueXmlString.append("<name protect = \"0\" visible = \"1\">").append("<![CDATA["+nameEdit+"]]>").append("</name>");
								valueXmlString.append("<addr1 protect = \"0\" visible = \"1\">").append("<![CDATA["+addr1Edit+"]]>").append("</addr1>");
								valueXmlString.append("<addr2 protect = \"0\" visible = \"1\">").append("<![CDATA["+addr2Edit+"]]>").append("</addr2>");
								valueXmlString.append("<addr3 protect = \"0\" visible = \"1\">").append("<![CDATA["+addr3Edit+"]]>").append("</addr3>");
								valueXmlString.append("<city protect = \"0\" visible = \"1\">").append("<![CDATA["+cityEdit+"]]>").append("</city>");
								valueXmlString.append("<gst_state_code protect = \"0\" visible = \"1\">").append("<![CDATA["+stateEdit+"]]>").append("</gst_state_code>");
								valueXmlString.append("<pin protect = \"0\" visible = \"1\">").append("<![CDATA["+pinEdit+"]]>").append("</pin>");
								valueXmlString.append("<gst_code_state protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</gst_code_state>");
								valueXmlString.append("<state_descr protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</state_descr>");
								valueXmlString.append("<order_no protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</order_no>");
								valueXmlString.append("<lr_no protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</lr_no>");	  
								valueXmlString.append("<lr_date protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</lr_date>");
							}
						}
						else if("A".equalsIgnoreCase(gst_type))
						{
							//valueXmlString.append("<gst_code_state protect = \"0\" visible = \"1\">").append("<![CDATA["+gstCodeEdit+"]]>").append("</gst_code_state>");
							valueXmlString.append("<state_descr protect = \"1\" visible = \"0\">").append("<![CDATA["+stateDescEdit+"]]>").append("</state_descr>");
							valueXmlString.append("<amount protect = \"0\" visible = \"1\">").append("<![CDATA["+amountEdit+"]]>").append("</amount>");
							valueXmlString.append("<cust_name protect = \"0\" visible = \"0\">").append("<![CDATA[]]>").append("</cust_name>");
							valueXmlString.append("<reas_code protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</reas_code>");
							valueXmlString.append("<ref_id__inv protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</ref_id__inv>");
							valueXmlString.append("<ref_date__inv protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</ref_date__inv>");
							valueXmlString.append("<reverse_chrg protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</reverse_chrg>");
							valueXmlString.append("<ecom_reg_no protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</ecom_reg_no>");
							valueXmlString.append("<gst_code protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</gst_code>");	
							valueXmlString.append("<name protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</name>");
							valueXmlString.append("<addr1 protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</addr1>");
							valueXmlString.append("<addr2 protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</addr2>");
							valueXmlString.append("<addr3 protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</addr3>");
							valueXmlString.append("<city protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</city>");
							valueXmlString.append("<gst_state_code protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</gst_state_code>");
							valueXmlString.append("<pin protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</pin>");
							valueXmlString.append("<reas_code protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</reas_code>");
							valueXmlString.append("<order_no protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</order_no>");
							valueXmlString.append("<lr_no protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</lr_no>");	  
							valueXmlString.append("<lr_date protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</lr_date>");
							valueXmlString.append("<tax_reg_no protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</tax_reg_no>");
							valueXmlString.append("<doc_no protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</doc_no>");
							valueXmlString.append("<doc_date protect = \"0\" visible = \"1\">").append("<![CDATA["+docDateEdit+"]]>").append("</doc_date>");					
							valueXmlString.append("<doc_type protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</doc_type>");
						}
						else if("T".equalsIgnoreCase(gst_type))
						{
							//valueXmlString.append("<gst_code_state protect = \"0\" visible = \"1\">").append("<![CDATA["+gstCodeEdit+"]]>").append("</gst_code_state>");
							valueXmlString.append("<state_descr protect = \"0\" visible = \"0\">").append("<![CDATA["+stateDescEdit+"]]>").append("</state_descr>");
							valueXmlString.append("<amount protect = \"0\" visible = \"1\">").append("<![CDATA["+amountEdit+"]]>").append("</amount>");
							valueXmlString.append("<cust_name protect = \"0\" visible = \"0\">").append("<![CDATA[]]>").append("</cust_name>");
							valueXmlString.append("<reas_code protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</reas_code>");
							valueXmlString.append("<ref_id__inv protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</ref_id__inv>");
							valueXmlString.append("<ref_date__inv protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</ref_date__inv>");
							valueXmlString.append("<reverse_chrg protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</reverse_chrg>");
							valueXmlString.append("<ecom_reg_no protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</ecom_reg_no>");
							valueXmlString.append("<gst_code protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</gst_code>");	
							valueXmlString.append("<name protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</name>");
							valueXmlString.append("<addr1 protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</addr1>");
							valueXmlString.append("<addr2 protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</addr2>");
							valueXmlString.append("<addr3 protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</addr3>");
							valueXmlString.append("<city protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</city>");
							valueXmlString.append("<gst_state_code protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</gst_state_code>");
							valueXmlString.append("<pin protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</pin>");
							valueXmlString.append("<reas_code protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</reas_code>");
							valueXmlString.append("<order_no protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</order_no>");
							valueXmlString.append("<lr_no protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</lr_no>");	  
							valueXmlString.append("<lr_date protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</lr_date>");
							valueXmlString.append("<tax_reg_no protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</tax_reg_no>");
							valueXmlString.append("<doc_no protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</doc_no>");
							valueXmlString.append("<doc_date protect = \"0\" visible = \"1\">").append("<![CDATA["+docDateEdit+"]]>").append("</doc_date>");
							valueXmlString.append("<doc_type protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</doc_type>");
						}	
						else if("L".equalsIgnoreCase(gst_type))
						{
							valueXmlString.append("<doc_type protect = \"0\" visible = \"0\">").append("<![CDATA[]]>").append("</doc_type>");
							valueXmlString.append("<tax_reg_no protect = \"0\" visible = \"0\">").append("<![CDATA[]]>").append("</tax_reg_no>");
							valueXmlString.append("<cust_name protect = \"0\" visible = \"0\">").append("<![CDATA[]]>").append("</cust_name>");
							valueXmlString.append("<gst_code_state protect = \"0\" visible = \"0\">").append("<![CDATA[]]>").append("</gst_code_state>");
							valueXmlString.append("<state_descr protect = \"0\" visible = \"0\">").append("<![CDATA[]]>").append("</state_descr>");
							valueXmlString.append("<doc_no protect = \"0\" visible = \"0\">").append("<![CDATA[]]>").append("</doc_no>");
							valueXmlString.append("<doc_date protect = \"0\" visible = \"1\">").append("<![CDATA["+docDateEdit+"]]>").append("</doc_date>");
							valueXmlString.append("<amount protect = \"0\" visible = \"0\">").append("<![CDATA[]]>").append("</amount>");
							valueXmlString.append("<reverse_chrg protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</reverse_chrg>");
							valueXmlString.append("<ecom_reg_no protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</ecom_reg_no>");
							valueXmlString.append("<gst_code protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</gst_code>");	
							valueXmlString.append("<ref_id__inv protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</ref_id__inv>");
							valueXmlString.append("<ref_date__inv protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</ref_date__inv>");
							valueXmlString.append("<name protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</name>");
							valueXmlString.append("<addr1 protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</addr1>");
							valueXmlString.append("<addr2 protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</addr2>");
							valueXmlString.append("<addr3 protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</addr3>");
							valueXmlString.append("<city protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</city>");
							valueXmlString.append("<gst_state_code protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</gst_state_code>");
							valueXmlString.append("<pin protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</pin>");
							valueXmlString.append("<reas_code protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</reas_code>");	
							valueXmlString.append("<order_no protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</order_no>");
							valueXmlString.append("<lr_no protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</lr_no>");	  
							valueXmlString.append("<lr_date protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</lr_date>");
						}
						else if("V".equalsIgnoreCase(gst_type))
						{
							valueXmlString.append("<doc_type protect = \"0\" visible = \"0\">").append("<![CDATA[]]>").append("</doc_type>");
							valueXmlString.append("<tax_reg_no protect = \"0\" visible = \"0\">").append("<![CDATA[]]>").append("</tax_reg_no>");
							valueXmlString.append("<cust_name protect = \"0\" visible = \"0\">").append("<![CDATA[]]>").append("</cust_name>");
							valueXmlString.append("<gst_code_state protect = \"0\" visible = \"0\">").append("<![CDATA[]]>").append("</gst_code_state>");
							valueXmlString.append("<state_descr protect = \"0\" visible = \"0\">").append("<![CDATA[]]>").append("</state_descr>");
							valueXmlString.append("<doc_no protect = \"0\" visible = \"0\">").append("<![CDATA[]]>").append("</doc_no>");
							valueXmlString.append("<doc_date protect = \"0\" visible = \"1\">").append("<![CDATA["+docDateEdit+"]]>").append("</doc_date>");
							valueXmlString.append("<amount protect = \"0\" visible = \"0\">").append("<![CDATA[]]>").append("</amount>");
							valueXmlString.append("<reverse_chrg protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</reverse_chrg>");
							valueXmlString.append("<ecom_reg_no protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</ecom_reg_no>");
							valueXmlString.append("<gst_code protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</gst_code>");	
							valueXmlString.append("<ref_id__inv protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</ref_id__inv>");
							valueXmlString.append("<ref_date__inv protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</ref_date__inv>");
							valueXmlString.append("<name protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</name>");
							valueXmlString.append("<addr1 protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</addr1>");
							valueXmlString.append("<addr2 protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</addr2>");
							valueXmlString.append("<addr3 protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</addr3>");
							valueXmlString.append("<city protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</city>");
							valueXmlString.append("<gst_state_code protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</gst_state_code>");
							valueXmlString.append("<pin protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</pin>");
							valueXmlString.append("<reas_code protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</reas_code>");	
							valueXmlString.append("<order_no protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</order_no>");
							valueXmlString.append("<lr_no protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</lr_no>");	  
							valueXmlString.append("<lr_date protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</lr_date>");
						}
					}
					else if("gst_type".equalsIgnoreCase(currentColumn.trim()))
					{
						gst_type = gstUtility.checkNull(genericUtility.getColumnValue("gst_type", dom));
						gst_codeVal = gstUtility.checkNull(getStateFromLoginSite(loginSite,conn));//System.out.println("Input Value::"+"gst_type:::["+gst_type+"]");
						sql = "select descr from gencodes where fld_name='GST_TYPE' and mod_name='W_GSTR_PURC' and fld_value=?";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1,gst_type);
						rs = pstmt.executeQuery();	
						if(rs.next())
						{
							gstDescr = rs.getString("descr");
							System.out.println("descr>>"+gstDescr);	
						}
						if(pstmt != null)
						{
							pstmt.close(); 
							pstmt = null;
						}
						if(rs != null)
						{
							rs.close();
							rs = null;
						}
						valueXmlString.append("<gst_type_descr>").append("<![CDATA["+gstDescr+"]]>").append("</gst_type_descr>");
						
						if("I".equalsIgnoreCase(gst_type))
						{
							valueXmlString.append("<doc_type protect = \"0\" visible = \"1\">").append("<![CDATA[R    ]]>").append("</doc_type>");
							valueXmlString.append("<tax_reg_no protect = \"0\" visible = \"1\">").append("<![CDATA[]]>").append("</tax_reg_no>");
							valueXmlString.append("<cust_name protect = \"0\" visible = \"0\">").append("<![CDATA[]]>").append("</cust_name>");
							valueXmlString.append("<gst_code_state protect = \"0\" visible = \"1\">").append("<![CDATA["+gst_codeVal+"]]>").append("</gst_code_state>");
							valueXmlString.append("<state_descr protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</state_descr>");
							valueXmlString.append("<doc_no protect = \"0\" visible = \"1\">").append("<![CDATA[]]>").append("</doc_no>");
							valueXmlString.append("<doc_date protect = \"0\" visible = \"1\">").append("<![CDATA[]]>").append("</doc_date>");					
							valueXmlString.append("<amount protect = \"0\" visible = \"1\">").append("<![CDATA[]]>").append("</amount>");
							valueXmlString.append("<reverse_chrg protect = \"0\" visible = \"0\">").append("<![CDATA[N]]>").append("</reverse_chrg>");
							valueXmlString.append("<ecom_reg_no protect = \"0\" visible = \"0\">").append("<![CDATA[]]>").append("</ecom_reg_no>");
							valueXmlString.append("<gst_code protect = \"0\" visible = \"1\">").append("<![CDATA[]]>").append("</gst_code>");	
							valueXmlString.append("<ref_id__inv protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</ref_id__inv>");
							valueXmlString.append("<ref_date__inv protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</ref_date__inv>");
							valueXmlString.append("<lr_no protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</lr_no>");	  
							valueXmlString.append("<lr_date protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</lr_date>");
							valueXmlString.append("<name protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</name>");
							valueXmlString.append("<addr1 protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</addr1>");
							valueXmlString.append("<addr2 protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</addr2>");
							valueXmlString.append("<addr3 protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</addr3>");
							valueXmlString.append("<city protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</city>");
							valueXmlString.append("<gst_state_code protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</gst_state_code>");
							valueXmlString.append("<pin protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</pin>");
							valueXmlString.append("<order_no protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</order_no>");
							valueXmlString.append("<reas_code protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</reas_code>");	
						}
						
						if("R".equalsIgnoreCase(gst_type))
						{
							valueXmlString.append("<doc_type protect = \"0\" visible = \"0\">").append("<![CDATA[]]>").append("</doc_type>");
							valueXmlString.append("<tax_reg_no protect = \"0\" visible = \"1\">").append("<![CDATA[]]>").append("</tax_reg_no>");
							valueXmlString.append("<cust_name protect = \"0\" visible = \"0\">").append("<![CDATA[]]>").append("</cust_name>");
							valueXmlString.append("<gst_code_state protect = \"0\" visible = \"1\">").append("<![CDATA["+gst_codeVal+"]]>").append("</gst_code_state>");
							valueXmlString.append("<state_descr protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</state_descr>");
							valueXmlString.append("<doc_no protect = \"0\" visible = \"1\">").append("<![CDATA[]]>").append("</doc_no>");
							valueXmlString.append("<doc_date protect = \"0\" visible = \"1\">").append("<![CDATA[]]>").append("</doc_date>");					
							valueXmlString.append("<amount protect = \"0\" visible = \"1\">").append("<![CDATA[]]>").append("</amount>");
							valueXmlString.append("<reverse_chrg protect = \"1\" visible = \"1\">").append("<![CDATA[Y]]>").append("</reverse_chrg>");
							valueXmlString.append("<ecom_reg_no protect = \"0\" visible = \"0\">").append("<![CDATA[]]>").append("</ecom_reg_no>");
							valueXmlString.append("<gst_code protect = \"0\" visible = \"1\">").append("<![CDATA[]]>").append("</gst_code>");	
							valueXmlString.append("<ref_id__inv protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</ref_id__inv>");
							valueXmlString.append("<ref_date__inv protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</ref_date__inv>");
							valueXmlString.append("<lr_no protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</lr_no>");	  
							valueXmlString.append("<lr_date protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</lr_date>");
							valueXmlString.append("<name protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</name>");
							valueXmlString.append("<addr1 protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</addr1>");
							valueXmlString.append("<addr2 protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</addr2>");
							valueXmlString.append("<addr3 protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</addr3>");
							valueXmlString.append("<city protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</city>");
							valueXmlString.append("<gst_state_code protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</gst_state_code>");
							valueXmlString.append("<pin protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</pin>");
							valueXmlString.append("<order_no protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</order_no>");
							valueXmlString.append("<reas_code protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</reas_code>");	
						}
						
						if("U".equalsIgnoreCase(gst_type))
						{
							valueXmlString.append("<doc_type protect = \"0\" visible = \"0\">").append("<![CDATA[]]>").append("</doc_type>");
							valueXmlString.append("<tax_reg_no protect = \"0\" visible = \"0\">").append("<![CDATA[]]>").append("</tax_reg_no>");
							valueXmlString.append("<cust_name protect = \"0\" visible = \"1\">").append("<![CDATA[]]>").append("</cust_name>");
							valueXmlString.append("<gst_code_state protect = \"0\" visible = \"1\">").append("<![CDATA["+gst_codeVal+"]]>").append("</gst_code_state>");
							valueXmlString.append("<state_descr protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</state_descr>");
							valueXmlString.append("<doc_no protect = \"0\" visible = \"1\">").append("<![CDATA[]]>").append("</doc_no>");
							valueXmlString.append("<doc_date protect = \"0\" visible = \"1\">").append("<![CDATA[]]>").append("</doc_date>");					
							valueXmlString.append("<amount protect = \"0\" visible = \"1\">").append("<![CDATA[]]>").append("</amount>");
							valueXmlString.append("<reverse_chrg protect = \"0\" visible = \"0\">").append("<![CDATA[N]]>").append("</reverse_chrg>");
							valueXmlString.append("<ecom_reg_no protect = \"0\" visible = \"0\">").append("<![CDATA[]]>").append("</ecom_reg_no>");
							valueXmlString.append("<gst_code protect = \"0\" visible = \"1\">").append("<![CDATA[]]>").append("</gst_code>");	
							valueXmlString.append("<ref_id__inv protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</ref_id__inv>");
							valueXmlString.append("<ref_date__inv protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</ref_date__inv>");
							valueXmlString.append("<lr_no protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</lr_no>");	  
							valueXmlString.append("<lr_date protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</lr_date>");
							valueXmlString.append("<name protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</name>");
							valueXmlString.append("<addr1 protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</addr1>");
							valueXmlString.append("<addr2 protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</addr2>");
							valueXmlString.append("<addr3 protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</addr3>");
							valueXmlString.append("<city protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</city>");
							valueXmlString.append("<gst_state_code protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</gst_state_code>");
							valueXmlString.append("<pin protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</pin>");
							valueXmlString.append("<order_no protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</order_no>");
							valueXmlString.append("<reas_code protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</reas_code>");	
						}
						
						if("S".equalsIgnoreCase(gst_type))
						{
							valueXmlString.append("<doc_type protect = \"0\" visible = \"0\">").append("<![CDATA[]]>").append("</doc_type>");
							valueXmlString.append("<tax_reg_no protect = \"0\" visible = \"0\">").append("<![CDATA[]]>").append("</tax_reg_no>");
							valueXmlString.append("<cust_name protect = \"0\" visible = \"0\">").append("<![CDATA[]]>").append("</cust_name>");
							valueXmlString.append("<gst_code_state protect = \"0\" visible = \"1\">").append("<![CDATA["+gst_codeVal+"]]>").append("</gst_code_state>");
							valueXmlString.append("<state_descr protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</state_descr>");
							valueXmlString.append("<doc_no protect = \"0\" visible = \"1\">").append("<![CDATA[]]>").append("</doc_no>");
							valueXmlString.append("<doc_date protect = \"0\" visible = \"1\">").append("<![CDATA[]]>").append("</doc_date>");					
							valueXmlString.append("<amount protect = \"0\" visible = \"1\">").append("<![CDATA[]]>").append("</amount>");
							valueXmlString.append("<reverse_chrg protect = \"0\" visible = \"0\">").append("<![CDATA[N]]>").append("</reverse_chrg>");
							valueXmlString.append("<ecom_reg_no protect = \"0\" visible = \"0\">").append("<![CDATA[]]>").append("</ecom_reg_no>");
							valueXmlString.append("<gst_code protect = \"0\" visible = \"0\">").append("<![CDATA[]]>").append("</gst_code>");	
							valueXmlString.append("<ref_id__inv protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</ref_id__inv>");
							valueXmlString.append("<ref_date__inv protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</ref_date__inv>");
							valueXmlString.append("<lr_no protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</lr_no>");	  
							valueXmlString.append("<lr_date protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</lr_date>");
							valueXmlString.append("<name protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</name>");
							valueXmlString.append("<addr1 protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</addr1>");
							valueXmlString.append("<addr2 protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</addr2>");
							valueXmlString.append("<addr3 protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</addr3>");
							valueXmlString.append("<city protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</city>");
							valueXmlString.append("<gst_state_code protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</gst_state_code>");
							valueXmlString.append("<pin protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</pin>");
							valueXmlString.append("<order_no protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</order_no>");
							valueXmlString.append("<reas_code protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</reas_code>");	
						}
						
						if("G".equalsIgnoreCase(gst_type))
						{
							valueXmlString.append("<doc_type protect = \"0\" visible = \"0\">").append("<![CDATA[]]>").append("</doc_type>");
							valueXmlString.append("<tax_reg_no protect = \"0\" visible = \"1\">").append("<![CDATA[]]>").append("</tax_reg_no>");
							valueXmlString.append("<cust_name protect = \"0\" visible = \"0\">").append("<![CDATA[]]>").append("</cust_name>");
							valueXmlString.append("<gst_code_state protect = \"0\" visible = \"0\">").append("<![CDATA[]]>").append("</gst_code_state>");
							valueXmlString.append("<state_descr protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</state_descr>");
							valueXmlString.append("<doc_no protect = \"0\" visible = \"0\">").append("<![CDATA[]]>").append("</doc_no>");
							valueXmlString.append("<doc_date protect = \"0\" visible = \"0\">").append("<![CDATA[]]>").append("</doc_date>");					
							valueXmlString.append("<amount protect = \"0\" visible = \"1\">").append("<![CDATA[]]>").append("</amount>");
							valueXmlString.append("<reverse_chrg protect = \"0\" visible = \"0\">").append("<![CDATA[N]]>").append("</reverse_chrg>");
							valueXmlString.append("<ecom_reg_no protect = \"0\" visible = \"0\">").append("<![CDATA[]]>").append("</ecom_reg_no>");
							valueXmlString.append("<gst_code protect = \"0\" visible = \"0\">").append("<![CDATA[]]>").append("</gst_code>");	
							valueXmlString.append("<ref_id__inv protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</ref_id__inv>");
							valueXmlString.append("<ref_date__inv protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</ref_date__inv>");
							valueXmlString.append("<name protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</name>");
							valueXmlString.append("<addr1 protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</addr1>");
							valueXmlString.append("<addr2 protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</addr2>");
							valueXmlString.append("<addr3 protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</addr3>");
							valueXmlString.append("<city protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</city>");
							valueXmlString.append("<gst_state_code protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</gst_state_code>");
							valueXmlString.append("<pin protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</pin>");
							valueXmlString.append("<lr_no protect = \"0\" visible = \"1\">").append("<![CDATA[]]>").append("</lr_no>");	  
							valueXmlString.append("<lr_date protect = \"0\" visible = \"1\">").append("<![CDATA[]]>").append("</lr_date>");
							valueXmlString.append("<order_no protect = \"0\" visible = \"1\">").append("<![CDATA[]]>").append("</order_no>");
							valueXmlString.append("<reas_code protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</reas_code>");	
						}
						else if("D".equalsIgnoreCase(gst_type))
						{
							valueXmlString.append("<doc_type protect = \"0\" visible = \"0\">").append("<![CDATA[]]>").append("</doc_type>");
							valueXmlString.append("<tax_reg_no protect = \"0\" visible = \"1\">").append("<![CDATA[]]>").append("</tax_reg_no>");
							valueXmlString.append("<cust_name protect = \"0\" visible = \"0\">").append("<![CDATA[]]>").append("</cust_name>");
							valueXmlString.append("<doc_no protect = \"0\" visible = \"1\">").append("<![CDATA[]]>").append("</doc_no>");
							valueXmlString.append("<doc_date protect = \"0\" visible = \"1\">").append("<![CDATA[]]>").append("</doc_date>");					
							valueXmlString.append("<amount protect = \"0\" visible = \"1\">").append("<![CDATA[]]>").append("</amount>");
							valueXmlString.append("<reas_code protect = \"0\" visible = \"1\">").append("<![CDATA[]]>").append("</reas_code>");
							valueXmlString.append("<ref_id__inv protect = \"0\" visible = \"1\">").append("<![CDATA[]]>").append("</ref_id__inv>");
							valueXmlString.append("<ref_date__inv protect = \"0\" visible = \"1\">").append("<![CDATA[]]>").append("</ref_date__inv>");
							valueXmlString.append("<reverse_chrg protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</reverse_chrg>");
							valueXmlString.append("<ecom_reg_no protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</ecom_reg_no>");
							valueXmlString.append("<gst_code protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</gst_code>");	
							valueXmlString.append("<name protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</name>");
							valueXmlString.append("<addr1 protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</addr1>");
							valueXmlString.append("<addr2 protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</addr2>");
							valueXmlString.append("<addr3 protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</addr3>");
							valueXmlString.append("<city protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</city>");
							valueXmlString.append("<gst_state_code protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</gst_state_code>");
							valueXmlString.append("<pin protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</pin>");
							valueXmlString.append("<gst_code_state protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</gst_code_state>");
							valueXmlString.append("<state_descr protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</state_descr>");
							valueXmlString.append("<order_no protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</order_no>");
							valueXmlString.append("<lr_no protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</lr_no>");	  
							valueXmlString.append("<lr_date protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</lr_date>");
						}
						else if("C".equalsIgnoreCase(gst_type))
						{
							valueXmlString.append("<doc_type protect = \"0\" visible = \"0\">").append("<![CDATA[]]>").append("</doc_type>");
							valueXmlString.append("<tax_reg_no protect = \"0\" visible = \"1\">").append("<![CDATA[]]>").append("</tax_reg_no>");
							valueXmlString.append("<cust_name protect = \"0\" visible = \"0\">").append("<![CDATA[]]>").append("</cust_name>");
							valueXmlString.append("<doc_no protect = \"0\" visible = \"1\">").append("<![CDATA[]]>").append("</doc_no>");
							valueXmlString.append("<doc_date protect = \"0\" visible = \"1\">").append("<![CDATA[]]>").append("</doc_date>");					
							valueXmlString.append("<amount protect = \"0\" visible = \"1\">").append("<![CDATA[]]>").append("</amount>");
							valueXmlString.append("<reas_code protect = \"0\" visible = \"1\">").append("<![CDATA[]]>").append("</reas_code>");
							valueXmlString.append("<ref_id__inv protect = \"0\" visible = \"1\">").append("<![CDATA[]]>").append("</ref_id__inv>");
							valueXmlString.append("<ref_date__inv protect = \"0\" visible = \"1\">").append("<![CDATA[]]>").append("</ref_date__inv>");
							valueXmlString.append("<reverse_chrg protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</reverse_chrg>");
							valueXmlString.append("<ecom_reg_no protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</ecom_reg_no>");
							valueXmlString.append("<gst_code protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</gst_code>");	
							valueXmlString.append("<name protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</name>");
							valueXmlString.append("<addr1 protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</addr1>");
							valueXmlString.append("<addr2 protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</addr2>");
							valueXmlString.append("<addr3 protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</addr3>");
							valueXmlString.append("<city protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</city>");
							valueXmlString.append("<gst_state_code protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</gst_state_code>");
							valueXmlString.append("<pin protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</pin>");
							valueXmlString.append("<gst_code_state protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</gst_code_state>");
							valueXmlString.append("<state_descr protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</state_descr>");
							valueXmlString.append("<order_no protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</order_no>");
							valueXmlString.append("<lr_no protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</lr_no>");	  
							valueXmlString.append("<lr_date protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</lr_date>");
						}
						else if("A".equalsIgnoreCase(gst_type))
						{
							valueXmlString.append("<gst_code_state protect = \"0\" visible = \"1\">").append("<![CDATA["+gst_codeVal+"]]>").append("</gst_code_state>");
							valueXmlString.append("<state_descr protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</state_descr>");
							valueXmlString.append("<amount protect = \"0\" visible = \"1\">").append("<![CDATA[]]>").append("</amount>");
							valueXmlString.append("<cust_name protect = \"0\" visible = \"0\">").append("<![CDATA[]]>").append("</cust_name>");
							valueXmlString.append("<reas_code protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</reas_code>");
							valueXmlString.append("<ref_id__inv protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</ref_id__inv>");
							valueXmlString.append("<ref_date__inv protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</ref_date__inv>");
							valueXmlString.append("<reverse_chrg protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</reverse_chrg>");
							valueXmlString.append("<ecom_reg_no protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</ecom_reg_no>");
							valueXmlString.append("<gst_code protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</gst_code>");	
							valueXmlString.append("<name protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</name>");
							valueXmlString.append("<addr1 protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</addr1>");
							valueXmlString.append("<addr2 protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</addr2>");
							valueXmlString.append("<addr3 protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</addr3>");
							valueXmlString.append("<city protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</city>");
							valueXmlString.append("<gst_state_code protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</gst_state_code>");
							valueXmlString.append("<pin protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</pin>");
							valueXmlString.append("<reas_code protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</reas_code>");
							valueXmlString.append("<order_no protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</order_no>");
							valueXmlString.append("<lr_no protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</lr_no>");	  
							valueXmlString.append("<lr_date protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</lr_date>");
							valueXmlString.append("<tax_reg_no protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</tax_reg_no>");
							valueXmlString.append("<doc_no protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</doc_no>");
							valueXmlString.append("<doc_date protect = \"0\" visible = \"1\">").append("<![CDATA[]]>").append("</doc_date>");					
							valueXmlString.append("<doc_type protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</doc_type>");
						}
						else if("T".equalsIgnoreCase(gst_type))
						{
							valueXmlString.append("<gst_code_state protect = \"0\" visible = \"1\">").append("<![CDATA["+gst_codeVal+"]]>").append("</gst_code_state>");
							valueXmlString.append("<state_descr protect = \"0\" visible = \"0\">").append("<![CDATA[]]>").append("</state_descr>");
							valueXmlString.append("<amount protect = \"0\" visible = \"1\">").append("<![CDATA[]]>").append("</amount>");
							valueXmlString.append("<cust_name protect = \"0\" visible = \"0\">").append("<![CDATA[]]>").append("</cust_name>");
							valueXmlString.append("<reas_code protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</reas_code>");
							valueXmlString.append("<ref_id__inv protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</ref_id__inv>");
							valueXmlString.append("<ref_date__inv protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</ref_date__inv>");
							valueXmlString.append("<reverse_chrg protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</reverse_chrg>");
							valueXmlString.append("<ecom_reg_no protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</ecom_reg_no>");
							valueXmlString.append("<gst_code protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</gst_code>");	
							valueXmlString.append("<name protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</name>");
							valueXmlString.append("<addr1 protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</addr1>");
							valueXmlString.append("<addr2 protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</addr2>");
							valueXmlString.append("<addr3 protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</addr3>");
							valueXmlString.append("<city protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</city>");
							valueXmlString.append("<gst_state_code protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</gst_state_code>");
							valueXmlString.append("<pin protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</pin>");
							valueXmlString.append("<reas_code protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</reas_code>");
							valueXmlString.append("<order_no protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</order_no>");
							valueXmlString.append("<lr_no protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</lr_no>");	  
							valueXmlString.append("<lr_date protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</lr_date>");
							valueXmlString.append("<tax_reg_no protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</tax_reg_no>");
							valueXmlString.append("<doc_no protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</doc_no>");
							valueXmlString.append("<doc_date protect = \"0\" visible = \"1\">").append("<![CDATA[]]>").append("</doc_date>");
							valueXmlString.append("<doc_type protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</doc_type>");
						}
						else if("L".equalsIgnoreCase(gst_type))
						{
							valueXmlString.append("<doc_type protect = \"0\" visible = \"0\">").append("<![CDATA[]]>").append("</doc_type>");
							valueXmlString.append("<tax_reg_no protect = \"0\" visible = \"0\">").append("<![CDATA[]]>").append("</tax_reg_no>");
							valueXmlString.append("<cust_name protect = \"0\" visible = \"0\">").append("<![CDATA[]]>").append("</cust_name>");
							valueXmlString.append("<gst_code_state protect = \"0\" visible = \"0\">").append("<![CDATA[]]>").append("</gst_code_state>");
							valueXmlString.append("<state_descr protect = \"0\" visible = \"0\">").append("<![CDATA[]]>").append("</state_descr>");
							valueXmlString.append("<doc_no protect = \"0\" visible = \"0\">").append("<![CDATA[]]>").append("</doc_no>");
							valueXmlString.append("<doc_date protect = \"0\" visible = \"1\">").append("<![CDATA[]]>").append("</doc_date>");
							valueXmlString.append("<amount protect = \"0\" visible = \"0\">").append("<![CDATA[]]>").append("</amount>");
							valueXmlString.append("<reverse_chrg protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</reverse_chrg>");
							valueXmlString.append("<ecom_reg_no protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</ecom_reg_no>");
							valueXmlString.append("<gst_code protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</gst_code>");	
							valueXmlString.append("<ref_id__inv protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</ref_id__inv>");
							valueXmlString.append("<ref_date__inv protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</ref_date__inv>");
							valueXmlString.append("<name protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</name>");
							valueXmlString.append("<addr1 protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</addr1>");
							valueXmlString.append("<addr2 protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</addr2>");
							valueXmlString.append("<addr3 protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</addr3>");
							valueXmlString.append("<city protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</city>");
							valueXmlString.append("<gst_state_code protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</gst_state_code>");
							valueXmlString.append("<pin protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</pin>");
							valueXmlString.append("<reas_code protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</reas_code>");	
							valueXmlString.append("<order_no protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</order_no>");
							valueXmlString.append("<lr_no protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</lr_no>");	  
							valueXmlString.append("<lr_date protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</lr_date>");
						}
						else if("V".equalsIgnoreCase(gst_type))
						{
							valueXmlString.append("<doc_type protect = \"0\" visible = \"0\">").append("<![CDATA[]]>").append("</doc_type>");
							valueXmlString.append("<tax_reg_no protect = \"0\" visible = \"0\">").append("<![CDATA[]]>").append("</tax_reg_no>");
							valueXmlString.append("<cust_name protect = \"0\" visible = \"0\">").append("<![CDATA[]]>").append("</cust_name>");
							valueXmlString.append("<gst_code_state protect = \"0\" visible = \"0\">").append("<![CDATA[]]>").append("</gst_code_state>");
							valueXmlString.append("<state_descr protect = \"0\" visible = \"0\">").append("<![CDATA[]]>").append("</state_descr>");
							valueXmlString.append("<doc_no protect = \"0\" visible = \"0\">").append("<![CDATA[]]>").append("</doc_no>");
							valueXmlString.append("<doc_date protect = \"0\" visible = \"1\">").append("<![CDATA[]]>").append("</doc_date>");
							valueXmlString.append("<amount protect = \"0\" visible = \"0\">").append("<![CDATA[]]>").append("</amount>");
							valueXmlString.append("<reverse_chrg protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</reverse_chrg>");
							valueXmlString.append("<ecom_reg_no protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</ecom_reg_no>");
							valueXmlString.append("<gst_code protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</gst_code>");	
							valueXmlString.append("<ref_id__inv protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</ref_id__inv>");
							valueXmlString.append("<ref_date__inv protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</ref_date__inv>");
							valueXmlString.append("<name protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</name>");
							valueXmlString.append("<addr1 protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</addr1>");
							valueXmlString.append("<addr2 protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</addr2>");
							valueXmlString.append("<addr3 protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</addr3>");
							valueXmlString.append("<city protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</city>");
							valueXmlString.append("<gst_state_code protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</gst_state_code>");
							valueXmlString.append("<pin protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</pin>");
							valueXmlString.append("<reas_code protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</reas_code>");	
							valueXmlString.append("<order_no protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</order_no>");
							valueXmlString.append("<lr_no protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</lr_no>");	  
							valueXmlString.append("<lr_date protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</lr_date>");
						}
					}// end of if block for gst_type
					
					else if("tax_reg_no".equalsIgnoreCase(currentColumn.trim()))
					{
						gst_type =  gstUtility.checkNull(genericUtility.getColumnValue("gst_type", dom));
						tax_reg_no = gstUtility.checkNull(genericUtility.getColumnValue("tax_reg_no", dom));
						sql = "select count(*) as cnt from gst_registration where gst_no=?";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1,tax_reg_no);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							cnt = rs.getInt("cnt");//System.out.println("Count for tax_reg_no exist or not in gst_registration is=="+cnt);
						}
						if(pstmt != null)
						{
						    pstmt.close(); 
						    pstmt = null;
						}
						if(rs != null)
						{
							rs.close();
						    rs = null;
						}
						
						if(cnt > 0)
						{
							sql = "select name,addr1,addr2,addr3,city,state_code,pin from gst_registration where gst_no=?";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1,tax_reg_no);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								name = rs.getString("name");
								addr1 = rs.getString("addr1");
								addr2 = rs.getString("addr2");
								addr3 = rs.getString("addr3");
								city = rs.getString("city");
								state = rs.getString("state_code");
								pin = rs.getString("pin");
							}
							if(pstmt != null)
							{
							    pstmt.close(); 
							    pstmt = null;
							}
							if(rs != null)
							{
								rs.close();
							    rs = null;
							}
							System.out.println("name = ["+name+"]"+"addr1["+addr1+"]"+"addr2["+addr2+"]"+"addr3["+addr3+"]"+"city["+city+"]"+"state["+state+"]"+"pin["+pin+"]");
							if((name != null && name.trim().length() >0) || (addr1 != null && addr1.trim().length()>0) || (addr2 != null && addr2.trim().length()>0) || (addr3 != null && addr3.trim().length() >0) || (city != null && city.trim().length()>0) || (state != null && state.trim().length()>0) || (pin != null && pin.trim().length()>0) )
							{
								System.out.println("Inside if block !!!!!1");
								valueXmlString.append("<name protect = \"0\" visible = \"1\">").append("<![CDATA["+name+"]]>").append("</name>");
								valueXmlString.append("<addr1 protect = \"0\" visible = \"1\">").append("<![CDATA["+addr1+"]]>").append("</addr1>");
								valueXmlString.append("<addr2 protect = \"0\" visible = \"1\">").append("<![CDATA["+addr2+"]]>").append("</addr2>");
								valueXmlString.append("<addr3 protect = \"0\" visible = \"1\">").append("<![CDATA["+addr3+"]]>").append("</addr3>");
								valueXmlString.append("<city protect = \"0\" visible = \"1\">").append("<![CDATA["+city+"]]>").append("</city>");
								valueXmlString.append("<gst_state_code protect = \"0\" visible = \"1\">").append("<![CDATA["+state+"]]>").append("</gst_state_code>");
								valueXmlString.append("<pin protect = \"0\" visible = \"1\">").append("<![CDATA["+pin+"]]>").append("</pin>");
							}
							else
							{
								System.out.println("Inside else block!!!!");
								valueXmlString.append("<name protect = \"0\" visible = \"1\">").append("<![CDATA["+name+"]]>").append("</name>");
								valueXmlString.append("<addr1 protect = \"0\" visible = \"1\">").append("<![CDATA["+addr1+"]]>").append("</addr1>");
								valueXmlString.append("<addr2 protect = \"0\" visible = \"1\">").append("<![CDATA["+addr2+"]]>").append("</addr2>");
								valueXmlString.append("<addr3 protect = \"0\" visible = \"1\">").append("<![CDATA["+addr3+"]]>").append("</addr3>");
								valueXmlString.append("<city protect = \"0\" visible = \"1\">").append("<![CDATA["+city+"]]>").append("</city>");
								valueXmlString.append("<gst_state_code protect = \"0\" visible = \"1\">").append("<![CDATA["+state+"]]>").append("</gst_state_code>");
								valueXmlString.append("<pin protect = \"0\" visible = \"1\">").append("<![CDATA["+pin+"]]>").append("</pin>");
							}
						}
						else 
						{
							tax_reg_no = gstUtility.checkNull(genericUtility.getColumnValue("tax_reg_no", dom));
							if(tax_reg_no != null && tax_reg_no.trim().length() > 0)
							{
								stCode = tax_reg_no.substring(0,2);//System.out.println("State Code is ======"+stCode);	
								sql = "select state_code from state where gst_code=?";
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1,stCode);
								rs = pstmt.executeQuery();
								if(rs.next())
								{
									state1 = rs.getString("state_code");
								}
								if(pstmt != null)
								{
								    pstmt.close(); 
								    pstmt = null;
								}
								if(rs != null)
								{
									rs.close();
								    rs = null;
								}	
								valueXmlString.append("<name protect = \"0\" visible = \"1\">").append("<![CDATA[]]>").append("</name>");
								valueXmlString.append("<addr1 protect = \"0\" visible = \"1\">").append("<![CDATA[]]>").append("</addr1>");
								valueXmlString.append("<addr2 protect = \"0\" visible = \"1\">").append("<![CDATA[]]>").append("</addr2>");
								valueXmlString.append("<addr3 protect = \"0\" visible = \"1\">").append("<![CDATA[]]>").append("</addr3>");
								valueXmlString.append("<city protect = \"0\" visible = \"1\">").append("<![CDATA[]]>").append("</city>");
								valueXmlString.append("<gst_state_code protect = \"0\" visible = \"1\">").append("<![CDATA["+state1+"]]>").append("</gst_state_code>");
								valueXmlString.append("<pin protect = \"0\" visible = \"1\">").append("<![CDATA["+pin+"]]>").append("</pin>");							
							}
							else if(tax_reg_no == null || tax_reg_no.trim().length() == 0)
							{
								valueXmlString.append("<name protect = \"0\" visible = \"0\">").append("<![CDATA[]]>").append("</name>");
								valueXmlString.append("<addr1 protect = \"0\" visible = \"0\">").append("<![CDATA[]]>").append("</addr1>");
								valueXmlString.append("<addr2 protect = \"0\" visible = \"0\">").append("<![CDATA[]]>").append("</addr2>");
								valueXmlString.append("<addr3 protect = \"0\" visible = \"0\">").append("<![CDATA[]]>").append("</addr3>");
								valueXmlString.append("<city protect = \"0\" visible = \"0\">").append("<![CDATA[]]>").append("</city>");
								valueXmlString.append("<gst_state_code protect = \"0\" visible = \"0\">").append("<![CDATA[]]>").append("</gst_state_code>");
								valueXmlString.append("<pin protect = \"0\" visible = \"0\">").append("<![CDATA[]]>").append("</pin>");								
							}
						}
						if("I".equalsIgnoreCase(gst_type) || "R".equalsIgnoreCase(gst_type))
						{
							gst_codeVal = gstUtility.checkNull(getStateFromLoginSite(loginSite,conn));
							if(tax_reg_no != null && tax_reg_no.trim().length() > 0)
							{
								String plcOfSupp = tax_reg_no.substring(0,2);//System.out.println("Return Value::"+"plcOfSupp::::["+plcOfSupp+"]");
								valueXmlString.append("<gst_code_state protect = \"0\" visible = \"1\">").append("<![CDATA["+plcOfSupp+"]]>").append("</gst_code_state>");
							}
							else
							{
								valueXmlString.append("<gst_code_state protect = \"0\" visible = \"1\">").append("<![CDATA["+gst_codeVal+"]]>").append("</gst_code_state>");
							}
						}	
					}//end of if block for tax_reg_no 
					
					else if("doc_date".equalsIgnoreCase(currentColumn.trim()))	
					{
						docDate = gstUtility.checkNull(genericUtility.getColumnValue("doc_date", dom));
						doc_date = Timestamp.valueOf(genericUtility.getValidDateString(docDate, genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat()) + " 00:00:00.0");
						System.out.println("docDate:::::::::"+docDate+"doc_date>>>>>>>>>"+doc_date);		
						sql = "select code from period where ? between fr_date and to_date";
						pstmt = conn.prepareStatement(sql);
						pstmt.setTimestamp(1,doc_date);
						rs = pstmt.executeQuery();	
						if(rs.next())
						{
							code = rs.getString("code");//System.out.println("code////"+code);
						}
						if(pstmt != null)
						{
						    pstmt.close(); 
						    pstmt = null;
						}
						if(rs != null)
						{
							rs.close();
						    rs = null;
						}	
						year = code.substring(0,4);
						mnth = code.substring(4,6);
						finalCode = mnth+year;
						//System.out.println("Return Value::"+"Month["+mnth+"]"+"Year["+year+"]"+"Final Code["+finalCode+"]");
						valueXmlString.append("<prd_code>").append("<![CDATA["+finalCode+"]]>").append("</prd_code>");				
					}//end of if block for doc_date 
					
					else if("lr_date".equalsIgnoreCase(currentColumn.trim()))
					{
						gst_type =  gstUtility.checkNull(genericUtility.getColumnValue("gst_type", dom));
						if("G".equalsIgnoreCase(gst_type))
						{
							docDate = gstUtility.checkNull(genericUtility.getColumnValue("lr_date", dom));
							doc_date = Timestamp.valueOf(genericUtility.getValidDateString(docDate, genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat()) + " 00:00:00.0");
							System.out.println("lrDate is:::::::::"+docDate+"doc_date>>>>>>>>>"+doc_date);		
							sql = "select code from period where ? between fr_date and to_date";
							pstmt = conn.prepareStatement(sql);
							pstmt.setTimestamp(1,doc_date);
							rs = pstmt.executeQuery();	
							if(rs.next())
							{
								code = rs.getString("code");//System.out.println("code////"+code);
							}
							if(pstmt != null)
							{
							    pstmt.close(); 
							    pstmt = null;
							}
							if(rs != null)
							{
								rs.close();
							    rs = null;
							}	
							year = code.substring(0,4);
							mnth = code.substring(4,6);
							finalCode = mnth+year;
							//System.out.println("Return Value::"+"Month["+mnth+"]"+"Year["+year+"]"+"Final Code["+finalCode+"]");
							valueXmlString.append("<prd_code>").append("<![CDATA["+finalCode+"]]>").append("</prd_code>");		
						}
					}//end of if block for lr_date
					
					else if("gst_code_state".equalsIgnoreCase(currentColumn.trim()))
					{
						state_code = gstUtility.checkNull(genericUtility.getColumnValue("gst_code_state", dom));//System.out.println("State code value is ====="+state_code);
					    sql = "select descr from state where gst_code=?";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1,state_code);
						rs = pstmt.executeQuery();	
						if(rs.next())
						{
							stateDescr = rs.getString("descr");
							System.out.println("descr>>"+stateDescr);	
						}
						if(pstmt != null)
						{
						    pstmt.close(); 
						    pstmt = null;
						}
						if(rs != null)
						{
							rs.close();
						    rs = null;
						}		    
					    valueXmlString.append("<state_descr>").append("<![CDATA["+stateDescr+"]]>").append("</state_descr>");		
					}//end of if block for gst_code_state 
					valueXmlString.append("</Detail1>");
					break;
				}//end of case1
				case 2 :
				{
					parentNodeList = dom.getElementsByTagName("Detail2");
					parentList = dom.getElementsByTagName( "Detai2" + currentFormNo );
	    			objName = getObjNameFromDom( dom, "objName", "1" );
					System.out.println("Inside Itemchange OBJ Name="+objName);
					parentNode = parentNodeList.item(0);
					childNodeList = parentNode.getChildNodes();
					childNode = childNodeList.item(ctr);
					childNodeName = childNode.getNodeName();
					valueXmlString.append("<Detail2>");
					childNodeListLength = childNodeList.getLength();
					System.out.println("childNodeName-------->>[" + childNodeName + "]"+"currentColumn-------->>[" + currentColumn + "]");
					
					if("itm_default".equalsIgnoreCase(currentColumn.trim()))
					{
						ecomRegNo = gstUtility.checkNull(genericUtility.getColumnValue("ecom_reg_no", dom1));
						gst_type =  gstUtility.checkNull(genericUtility.getColumnValue("gst_type", dom1));
						itc_type =  gstUtility.checkNull(genericUtility.getColumnValue("itc_type", dom));//System.out.println("Return Value"+"ecom_reg_no is ====="+ecomRegNo + "gst_type:::::::"+gst_type);						
						if(ecomRegNo != null && ecomRegNo.trim().length() > 0 && gst_type.equalsIgnoreCase("I"))
						{
							valueXmlString.append("<supply_type protect = \"1\">").append("<![CDATA[E]]>").append("</supply_type>");
						}
						else if(ecomRegNo == null || ecomRegNo.trim().length() == 0 && gst_type.equalsIgnoreCase("I"))
						{
							valueXmlString.append("<supply_type protect = \"1\">").append("<![CDATA[OE]]>").append("</supply_type>");
						}
						else 
						{
							valueXmlString.append("<supply_type protect = \"0\">").append("<![CDATA[OE]]>").append("</supply_type>");
						}
						valueXmlString.append("<igst_amt protect = \"1\">").append("<![CDATA[]]>").append("</igst_amt>");
						valueXmlString.append("<cgst_amt protect = \"1\">").append("<![CDATA[]]>").append("</cgst_amt>");
						valueXmlString.append("<sgst_amt protect = \"1\">").append("<![CDATA[]]>").append("</sgst_amt>");
						
						if(itc_type.equalsIgnoreCase("NO"))
                		{
                			valueXmlString.append("<itc_igst protect = \"1\">").append("<![CDATA[0]]>").append("</itc_igst>");
    						valueXmlString.append("<itc_cgst protect = \"1\">").append("<![CDATA[0]]>").append("</itc_cgst>");
    						valueXmlString.append("<itc_sgst protect = \"1\">").append("<![CDATA[0]]>").append("</itc_sgst>");
    						valueXmlString.append("<itc_cess protect = \"1\">").append("<![CDATA[0]]>").append("</itc_cess>");
                		}
						
						valueXmlString.append("</Detail2>");
						valueXmlString.append("<Detail1>");
						valueXmlString.append("<gst_type protect = \"1\">").append("<![CDATA["+gstUtility.checkNull(genericUtility.getColumnValue("gst_type", dom1))+"]]>").append("</gst_type>");
						valueXmlString.append("<doc_type protect = \"1\">").append("<![CDATA["+gstUtility.checkNull(genericUtility.getColumnValue("doc_type", dom1))+"]]>").append("</doc_type>");
						valueXmlString.append("<tax_reg_no protect = \"1\">").append("<![CDATA["+gstUtility.checkNull(genericUtility.getColumnValue("tax_reg_no", dom1))+"]]>").append("</tax_reg_no>");
						valueXmlString.append("<gst_code_state protect = \"1\">").append("<![CDATA["+gstUtility.checkNull(genericUtility.getColumnValue("gst_code_state", dom1))+"]]>").append("</gst_code_state>");
                		valueXmlString.append("</Detail1>");
					}//end of if block for itm_default
					
					else if("itm_defaultedit".equalsIgnoreCase(currentColumn.trim()))
					{						
						double igst_amtEdit = gstUtility.getDouble(genericUtility.getColumnValue("igst_amt", dom));
						double cgst_amtEdit = gstUtility.getDouble(genericUtility.getColumnValue("cgst_amt", dom));
						double sgst_amtEdit = gstUtility.getDouble(genericUtility.getColumnValue("sgst_amt", dom));
						itc_type =  gstUtility.checkNull(genericUtility.getColumnValue("itc_type", dom));
						
						if(igst_amtEdit == 0)
						{
							valueXmlString.append("<igst_amt protect = \"1\">").append("<![CDATA["+igst_amtEdit+"]]>").append("</igst_amt>");
						}
						else if(cgst_amtEdit == 0 || sgst_amtEdit == 0)
						{
							valueXmlString.append("<cgst_amt protect = \"1\">").append("<![CDATA["+cgst_amtEdit+"]]>").append("</cgst_amt>");
							valueXmlString.append("<sgst_amt protect = \"1\">").append("<![CDATA["+sgst_amtEdit+"]]>").append("</sgst_amt>");
						}
						
						if(itc_type.equalsIgnoreCase("NO"))
                		{
                			valueXmlString.append("<itc_igst protect = \"1\">").append("<![CDATA[0]]>").append("</itc_igst>");
    						valueXmlString.append("<itc_cgst protect = \"1\">").append("<![CDATA[0]]>").append("</itc_cgst>");
    						valueXmlString.append("<itc_sgst protect = \"1\">").append("<![CDATA[0]]>").append("</itc_sgst>");
    						valueXmlString.append("<itc_cess protect = \"1\">").append("<![CDATA[0]]>").append("</itc_cess>");
                		}
						
						 valueXmlString.append("</Detail2>");
                         System.out.println("dom2.getElementsByTagName(DEATILS)"+dom2.getElementsByTagName("Detail2"));
						 System.out.println("Detail2 length::["+dom2.getElementsByTagName("Detail2").getLength()+"]");
						 int cnt1 = gstUtility.getNumOfNonDelDetail(dom2,currentFormNo);
						 System.out.println("Detail2 none deleted cnter"+cnt1);
						 if(cnt1 == 0)
						 {
							 System.out.println("in detail 1");
							 valueXmlString.append("<Detail1>");
							 valueXmlString.append("<gst_type protect = \"0\">").append("<![CDATA["+gstUtility.checkNull(genericUtility.getColumnValue("gst_type", dom1))+"]]>").append("</gst_type>");
							 valueXmlString.append("<doc_type protect = \"0\">").append("<![CDATA["+gstUtility.checkNull(genericUtility.getColumnValue("doc_type", dom1))+"]]>").append("</doc_type>");
							 valueXmlString.append("<tax_reg_no protect = \"0\">").append("<![CDATA["+gstUtility.checkNull(genericUtility.getColumnValue("tax_reg_no", dom1))+"]]>").append("</tax_reg_no>");
							 valueXmlString.append("<gst_code_state protect = \"0\">").append("<![CDATA["+gstUtility.checkNull(genericUtility.getColumnValue("gst_code_state", dom1))+"]]>").append("</gst_code_state>");
							 valueXmlString.append("</Detail1>");
						 }	 
					}//end of if block for itm_defaultedit
										
					else if("gst_rate".equalsIgnoreCase(currentColumn.trim()))
					{
						gst_rate = gstUtility.getDouble(gstUtility.checkNull(genericUtility.getColumnValue("gst_rate", dom)));
						state_code = gstUtility.checkNull(genericUtility.getColumnValue("gst_code_state", dom1)); // value of PlaceOfSupply
						gstnStateCode = gstUtility.checkNull(genericUtility.getColumnValue("tax_reg_no", dom1)).substring(0,2);//Value of StateCode set by using Supplier GSTIN number first 2digit.
						loginSiteCode = gstUtility.checkNull(getStateFromLoginSite(loginSite,conn));
						gst_type =  gstUtility.checkNull(genericUtility.getColumnValue("gst_type", dom1));
						doc_type =  gstUtility.checkNull(genericUtility.getColumnValue("doc_type", dom1)).trim();
						
						rate = (gst_rate);
						igst_amount = getIgst_Amt(rate, dom);
						cgst_amount = getCgst_Amt(rate, dom);
						sgst_amount = getSgst_Amt(rate, dom);
						System.out.println("Input Value::"+"gst_rate["+gst_rate+"]"+"state_code["+state_code+"]"+"loginSiteCode["+loginSiteCode+"]"+"gst_type["+gst_type+"]"+"gstnStateCode["+gstnStateCode+"]");
						
						if("G".equalsIgnoreCase(gst_type)  || ("I".equalsIgnoreCase(gst_type) && ("DE".equalsIgnoreCase(doc_type)) || ("Z".equalsIgnoreCase(doc_type))))
						{
							valueXmlString.append("<igst_perc>").append("<![CDATA["+gst_rate+"]]>").append("</igst_perc>");
							valueXmlString.append("<igst_amt protect = \"0\">").append("<![CDATA["+igst_amount+"]]>").append("</igst_amt>");
							valueXmlString.append("<cgst_amt protect = \"1\">").append("<![CDATA[0.0]]>").append("</cgst_amt>");
							valueXmlString.append("<sgst_amt protect = \"1\">").append("<![CDATA[0.0]]>").append("</sgst_amt>");
						}
						//Added by sarita on 30.08.2017[start]
						else if("I".equalsIgnoreCase(gst_type) && ("R".equalsIgnoreCase(doc_type)))
						{
							if(state_code != null && state_code.trim().length() > 0)
							{				
								 if(state_code.equalsIgnoreCase(gstnStateCode))
								{
									valueXmlString.append("<cgst_perc protect = \"1\">").append("<![CDATA["+rate/2+"]]>").append("</cgst_perc>");
									valueXmlString.append("<sgst_perc protect = \"1\">").append("<![CDATA["+rate/2+"]]>").append("</sgst_perc>");
									valueXmlString.append("<igst_amt protect = \"1\">").append("<![CDATA[0.0]]>").append("</igst_amt>");
									valueXmlString.append("<cgst_amt protect = \"0\">").append("<![CDATA["+cgst_amount+"]]>").append("</cgst_amt>");
									valueXmlString.append("<sgst_amt protect = \"0\">").append("<![CDATA["+sgst_amount+"]]>").append("</sgst_amt>");	
								}
								 else if(!(state_code.equalsIgnoreCase(gstnStateCode)))
								{							
									valueXmlString.append("<igst_perc>").append("<![CDATA["+gst_rate+"]]>").append("</igst_perc>");
									valueXmlString.append("<igst_amt protect = \"0\">").append("<![CDATA["+igst_amount+"]]>").append("</igst_amt>");
									valueXmlString.append("<cgst_amt protect = \"1\">").append("<![CDATA[0.0]]>").append("</cgst_amt>");
									valueXmlString.append("<sgst_amt protect = \"1\">").append("<![CDATA[0.0]]>").append("</sgst_amt>");	
								}					
							}//end of if block if state_code is not null
						}
						//Added by sarita on 30.08.2017[end]
						else if("C".equalsIgnoreCase(gst_type) || "D".equalsIgnoreCase(gst_type))
						{
							refIdInv = gstUtility.checkNull(genericUtility.getColumnValue("ref_id__inv", dom1));
				    	    ref_date__inv = gstUtility.checkNull(genericUtility.getColumnValue("ref_date__inv", dom1)).trim();
				    		refInvDateDate = Timestamp.valueOf(genericUtility.getValidDateString(ref_date__inv, genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat()) + " 00:00:00.0");
			    			String dt = "01/07/2017";
			    			invDate = Timestamp.valueOf(genericUtility.getValidDateString(dt, genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat()) + " 00:00:00.0");
			    			System.out.println("ref_id__inv is ["+refIdInv+"]"+"ref_date__inv["+ref_date__inv+"]"+"refInvDateDate["+refInvDateDate+"]"+"Date1/7/17["+dt+"]"+"invDate["+invDate+"]");
			    			if(refInvDateDate.equals(invDate) || refInvDateDate.after(invDate))
				    		{
				    			sql = "select gst_code from gst_data_hdr where doc_no=?";
				    			pstmt = conn.prepareStatement(sql);
								pstmt.setString(1,refIdInv);
								rs = pstmt.executeQuery();	
								if(rs.next())
								{
									gstCode = rs.getString("gst_code");
									System.out.println("gstCode::::::::::["+gstCode+"]");
								}
								if(pstmt != null)
								{
								    pstmt.close(); 
								    pstmt = null;
								}
								if(rs != null)
								{
									rs.close();
								    rs = null;
								}
								if(gstCode != null && gstCode.trim().length() > 0)
								{
									if(gstCode.equalsIgnoreCase(loginSiteCode))
									{
										igst_amt =   gstUtility.checkNull(genericUtility.getColumnValue("igst_amt", dom));
										valueXmlString.append("<cgst_perc protect = \"1\">").append("<![CDATA["+rate/2+"]]>").append("</cgst_perc>");
										valueXmlString.append("<sgst_perc protect = \"1\">").append("<![CDATA["+rate/2+"]]>").append("</sgst_perc>");
										valueXmlString.append("<igst_amt protect = \"1\">").append("<![CDATA[0.0]]>").append("</igst_amt>");
										valueXmlString.append("<cgst_amt protect = \"0\">").append("<![CDATA["+cgst_amount+"]]>").append("</cgst_amt>");
										valueXmlString.append("<sgst_amt protect = \"0\">").append("<![CDATA["+sgst_amount+"]]>").append("</sgst_amt>");	
									}
									 else if(!(state_code.equalsIgnoreCase(loginSiteCode)))
									{
										valueXmlString.append("<igst_perc>").append("<![CDATA["+gst_rate+"]]>").append("</igst_perc>");
										valueXmlString.append("<igst_amt protect = \"0\">").append("<![CDATA["+igst_amount+"]]>").append("</igst_amt>");
										valueXmlString.append("<cgst_amt protect = \"1\">").append("<![CDATA[0.0]]>").append("</cgst_amt>");
										valueXmlString.append("<sgst_amt protect = \"1\">").append("<![CDATA[0.0]]>").append("</sgst_amt>");
									}			
								}
				    		}
			    		}
						else
						{
							if(state_code != null && state_code.trim().length() > 0)
							{	
								//changes by sarita on 30.08.2017
								 if(state_code.equalsIgnoreCase(gstnStateCode))
								{
									valueXmlString.append("<cgst_perc protect = \"1\">").append("<![CDATA["+rate/2+"]]>").append("</cgst_perc>");
									valueXmlString.append("<sgst_perc protect = \"1\">").append("<![CDATA["+rate/2+"]]>").append("</sgst_perc>");
									valueXmlString.append("<igst_amt protect = \"1\">").append("<![CDATA[0.0]]>").append("</igst_amt>");
									valueXmlString.append("<cgst_amt protect = \"0\">").append("<![CDATA["+cgst_amount+"]]>").append("</cgst_amt>");
									valueXmlString.append("<sgst_amt protect = \"0\">").append("<![CDATA["+sgst_amount+"]]>").append("</sgst_amt>");	
								}
								 else if(!(state_code.equalsIgnoreCase(gstnStateCode)))
								{							
									valueXmlString.append("<igst_perc>").append("<![CDATA["+gst_rate+"]]>").append("</igst_perc>");
									valueXmlString.append("<igst_amt protect = \"0\">").append("<![CDATA["+igst_amount+"]]>").append("</igst_amt>");
									valueXmlString.append("<cgst_amt protect = \"1\">").append("<![CDATA[0.0]]>").append("</cgst_amt>");
									valueXmlString.append("<sgst_amt protect = \"1\">").append("<![CDATA[0.0]]>").append("</sgst_amt>");	
								}					
							}//end of if block if state_code is not null						
						}	
						valueXmlString.append("</Detail2>");
					}//end of if block for gst_rate
					
					else if("taxable_amt".equalsIgnoreCase(currentColumn.trim()))
					{
						String taxableAmt = gstUtility.checkNull(genericUtility.getColumnValue("taxable_amt", dom));
						gst_rate = gstUtility.getDouble(gstUtility.checkNull(genericUtility.getColumnValue("gst_rate", dom)));//System.out.println("INPUT VALUE"+"taxableAmt::["+taxableAmt+"]"+"[AND]"+"gst_rate::["+gst_rate+"]");
						doc_type =  gstUtility.checkNull(genericUtility.getColumnValue("doc_type", dom1)).trim();				
						if(gst_rate > 0)
						{
							rate = (gst_rate);
							igst_amount = getIgst_Amt(rate, dom);
							cgst_amount = getCgst_Amt(rate, dom);
							sgst_amount = getSgst_Amt(rate, dom);
							state_code = gstUtility.checkNull(genericUtility.getColumnValue("gst_code_state", dom1));//Value of Place of Supply
							loginSiteCode = gstUtility.checkNull(getStateFromLoginSite(loginSite,conn));
							gst_type =  gstUtility.checkNull(genericUtility.getColumnValue("gst_type", dom1));
							gstnStateCode = gstUtility.checkNull(genericUtility.getColumnValue("tax_reg_no", dom1)).substring(0,2);//Value of StateCode set by using Supplier GSTIN number first 2digit.
							if("G".equalsIgnoreCase(gst_type)  || ("I".equalsIgnoreCase(gst_type) && ("DE".equalsIgnoreCase(doc_type)) || ("Z".equalsIgnoreCase(doc_type))))
							{
								valueXmlString.append("<igst_perc>").append("<![CDATA["+gst_rate+"]]>").append("</igst_perc>");
								valueXmlString.append("<igst_amt protect = \"0\">").append("<![CDATA["+igst_amount+"]]>").append("</igst_amt>");
								valueXmlString.append("<cgst_amt protect = \"1\">").append("<![CDATA[0.0]]>").append("</cgst_amt>");
								valueXmlString.append("<sgst_amt protect = \"1\">").append("<![CDATA[0.0]]>").append("</sgst_amt>");
							}
							else if("I".equalsIgnoreCase(gst_type) && ("R".equalsIgnoreCase(doc_type)))
							{
								if(state_code != null && state_code.trim().length() > 0)
								{				
									 if(state_code.equalsIgnoreCase(gstnStateCode))
									{
										valueXmlString.append("<cgst_perc protect = \"1\">").append("<![CDATA["+rate/2+"]]>").append("</cgst_perc>");
										valueXmlString.append("<sgst_perc protect = \"1\">").append("<![CDATA["+rate/2+"]]>").append("</sgst_perc>");
										valueXmlString.append("<igst_amt protect = \"1\">").append("<![CDATA[0.0]]>").append("</igst_amt>");
										valueXmlString.append("<cgst_amt protect = \"0\">").append("<![CDATA["+cgst_amount+"]]>").append("</cgst_amt>");
										valueXmlString.append("<sgst_amt protect = \"0\">").append("<![CDATA["+sgst_amount+"]]>").append("</sgst_amt>");	
									}
									 else if(!(state_code.equalsIgnoreCase(gstnStateCode)))
									{							
										valueXmlString.append("<igst_perc>").append("<![CDATA["+gst_rate+"]]>").append("</igst_perc>");
										valueXmlString.append("<igst_amt protect = \"0\">").append("<![CDATA["+igst_amount+"]]>").append("</igst_amt>");
										valueXmlString.append("<cgst_amt protect = \"1\">").append("<![CDATA[0.0]]>").append("</cgst_amt>");
										valueXmlString.append("<sgst_amt protect = \"1\">").append("<![CDATA[0.0]]>").append("</sgst_amt>");	
									}					
								}//end of if block if state_code is not null
							}
							else if("C".equalsIgnoreCase(gst_type) || "D".equalsIgnoreCase(gst_type))
							{
								refIdInv = gstUtility.checkNull(genericUtility.getColumnValue("ref_id__inv", dom1));
					    	    ref_date__inv = gstUtility.checkNull(genericUtility.getColumnValue("ref_date__inv", dom1)).trim();
					    		refInvDateDate = Timestamp.valueOf(genericUtility.getValidDateString(ref_date__inv, genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat()) + " 00:00:00.0");
				    			String dt = "01/07/2017";
				    			invDate = Timestamp.valueOf(genericUtility.getValidDateString(dt, genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat()) + " 00:00:00.0");
				    			System.out.println("ref_id__inv is ["+refIdInv+"]"+"ref_date__inv["+ref_date__inv+"]"+"refInvDateDate["+refInvDateDate+"]"+"Date1/7/17["+dt+"]"+"invDate["+invDate+"]");
				    			if(refInvDateDate.equals(invDate) || refInvDateDate.after(invDate))
					    		{
					    			sql = "select gst_code from gst_data_hdr where doc_no=?";
					    			pstmt = conn.prepareStatement(sql);
									pstmt.setString(1,refIdInv);
									rs = pstmt.executeQuery();	
									if(rs.next())
									{
										gstCode = rs.getString("gst_code");
										System.out.println("gstCode::::::::::["+gstCode+"]");
									}
									if(pstmt != null)
									{
									    pstmt.close(); 
									    pstmt = null;
									}
									if(rs != null)
									{
										rs.close();
									    rs = null;
									}
									if(gstCode != null && gstCode.trim().length() > 0)
									{
										if(gstCode.equalsIgnoreCase(gstnStateCode))
										{
											igst_amt =   gstUtility.checkNull(genericUtility.getColumnValue("igst_amt", dom));
											//changes done by sarita on 21JUL2017
											valueXmlString.append("<cgst_perc protect = \"1\">").append("<![CDATA["+rate/2+"]]>").append("</cgst_perc>");
											valueXmlString.append("<sgst_perc protect = \"1\">").append("<![CDATA["+rate/2+"]]>").append("</sgst_perc>");
											valueXmlString.append("<igst_amt protect = \"1\">").append("<![CDATA[0.0]]>").append("</igst_amt>");
											valueXmlString.append("<cgst_amt protect = \"0\">").append("<![CDATA["+cgst_amount+"]]>").append("</cgst_amt>");
											valueXmlString.append("<sgst_amt protect = \"0\">").append("<![CDATA["+sgst_amount+"]]>").append("</sgst_amt>");	
										}
										 else if(!(state_code.equalsIgnoreCase(gstnStateCode)))
										{
											valueXmlString.append("<igst_perc>").append("<![CDATA["+gst_rate+"]]>").append("</igst_perc>");
											valueXmlString.append("<igst_amt protect = \"0\">").append("<![CDATA["+igst_amount+"]]>").append("</igst_amt>");
											valueXmlString.append("<cgst_amt protect = \"1\">").append("<![CDATA[0.0]]>").append("</cgst_amt>");
											valueXmlString.append("<sgst_amt protect = \"1\">").append("<![CDATA[0.0]]>").append("</sgst_amt>");
										}			
									}
					    		}
				    		}
							else
							{
								if(state_code != null && state_code.trim().length() > 0)
								{				
									 if(state_code.equalsIgnoreCase(loginSiteCode))
									{
										valueXmlString.append("<cgst_perc protect = \"1\">").append("<![CDATA["+rate/2+"]]>").append("</cgst_perc>");
										valueXmlString.append("<sgst_perc protect = \"1\">").append("<![CDATA["+rate/2+"]]>").append("</sgst_perc>");
										valueXmlString.append("<igst_amt protect = \"1\">").append("<![CDATA[0.0]]>").append("</igst_amt>");
										valueXmlString.append("<cgst_amt protect = \"0\">").append("<![CDATA["+cgst_amount+"]]>").append("</cgst_amt>");
										valueXmlString.append("<sgst_amt protect = \"0\">").append("<![CDATA["+sgst_amount+"]]>").append("</sgst_amt>");	
									}
									 else if(!(state_code.equalsIgnoreCase(loginSiteCode)))
									{							
										valueXmlString.append("<igst_perc>").append("<![CDATA["+gst_rate+"]]>").append("</igst_perc>");
										valueXmlString.append("<igst_amt protect = \"0\">").append("<![CDATA["+igst_amount+"]]>").append("</igst_amt>");
										valueXmlString.append("<cgst_amt protect = \"1\">").append("<![CDATA[0.0]]>").append("</cgst_amt>");
										valueXmlString.append("<sgst_amt protect = \"1\">").append("<![CDATA[0.0]]>").append("</sgst_amt>");	
									}					
								}//end of if block if state_code is not null
							}								
						}
						valueXmlString.append("</Detail2>");
					}//end of if block for taxable amount
					
					else if("itc_type".equalsIgnoreCase(currentColumn.trim()))
					{
						itc_type =  gstUtility.checkNull(genericUtility.getColumnValue("itc_type", dom)).trim();
						itc_igst =  gstUtility.checkNull(genericUtility.getColumnValue("itc_igst", dom)).trim();
						itc_cgst =  gstUtility.checkNull(genericUtility.getColumnValue("itc_cgst", dom)).trim();
						itc_sgst =  gstUtility.checkNull(genericUtility.getColumnValue("itc_sgst", dom)).trim();
						itc_cess =  gstUtility.checkNull(genericUtility.getColumnValue("itc_cess", dom)).trim();
						if(!("NO".equalsIgnoreCase(itc_type)))
						{
							valueXmlString.append("<itc_igst protect = \"0\">").append("<![CDATA[0]]>").append("</itc_igst>");
    						valueXmlString.append("<itc_cgst protect = \"0\">").append("<![CDATA[0]]>").append("</itc_cgst>");
    						valueXmlString.append("<itc_sgst protect = \"0\">").append("<![CDATA[0]]>").append("</itc_sgst>");
    						valueXmlString.append("<itc_cess protect = \"0\">").append("<![CDATA[0]]>").append("</itc_cess>");
						}
						else
						{
							valueXmlString.append("<itc_igst protect = \"1\">").append("<![CDATA[0]]>").append("</itc_igst>");
    						valueXmlString.append("<itc_cgst protect = \"1\">").append("<![CDATA[0]]>").append("</itc_cgst>");
    						valueXmlString.append("<itc_sgst protect = \"1\">").append("<![CDATA[0]]>").append("</itc_sgst>");
    						valueXmlString.append("<itc_cess protect = \"1\">").append("<![CDATA[0]]>").append("</itc_cess>");
						}
						valueXmlString.append("</Detail2>");
					}
					else 
					{
						valueXmlString.append("</Detail2>");
					}
					break;
				}
			}//end of switch block
			valueXmlString.append("</Root>");
		}
		catch(Exception e)
		{
			System.out.println(":::" + getClass().getSimpleName() + "::"+ e.getMessage());
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
					{
						rs.close();
						rs = null;
					}
					if (pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
					conn.close();
				}
				conn = null;
			} 
			catch (Exception d)
			{
				d.printStackTrace();
				throw new ITMException(d);
			}
		}
		return valueXmlString.toString();
	}
	
	private String errorType(Connection conn, String errorCode) throws ITMException
	{
		String msgType = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		try
		{
			String sql = "SELECT MSG_TYPE FROM MESSAGES WHERE MSG_NO = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, errorCode);
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				msgType = rs.getString("MSG_TYPE");
			}
			if(pstmt != null)
			{
			    pstmt.close(); 
			    pstmt = null;
			}
			if(rs != null)
			{
				rs.close();
			    rs = null;
			}
		} 
		catch (Exception ex)
		{
			ex.printStackTrace();
			throw new ITMException(ex);
		} 
		finally
		{
			try
			{
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if (pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			} 
			catch (Exception e)
			{
				e.printStackTrace();
				throw new ITMException(e);
			}
		}
		return msgType;
	}
	
	private String getObjNameFromDom(Document dom, String attribute, String objContext ) throws RemoteException,ITMException
	{
		System.out.println("Inside getObjNameFromDom method");
		NodeList detailList = null;
		Node currDetail = null,reqDetail = null;
		String objName = "";
		int	detailListLength = 0;

		try
		{
			detailList = dom.getElementsByTagName("Detail"+objContext);
			detailListLength = detailList.getLength();
			System.out.println("detailList>>>"+detailList.getLength());
			System.out.println("detailListLength>>>"+detailListLength);
			for (int ctr = 0; ctr < detailListLength; ctr++)
			{
				System.out.println("Inside for loop....");
				currDetail = detailList.item(ctr);
				System.out.println("currDetail>>>>>>"+currDetail);
				objName = currDetail.getAttributes().getNamedItem(attribute).getNodeValue();
				System.out.println("objName>>>>>>"+objName);
			}
		}
		catch ( Exception e )
		{
			throw new ITMException(e);
		}
		return objName;
	}//end of method getObjNameFromDom
	
	public String getStateFromLoginSite(String loginSite,Connection conn) throws ITMException
	{
		String sql="",state="",gst_code="";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		try
		{
			System.out.println("Login Site Code is===="+loginSite);
			sql = "select state_code from site where site_code=?"; 
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, loginSite);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				state = rs.getString("state_code");
			}
			System.out.println("State Code==========================="+state);
			if(pstmt != null)
			{
			    pstmt.close(); 
			    pstmt = null;
			}
			if(rs != null)
			{
				rs.close();
			    rs = null;
			}
			
			System.out.println("State code is ==================="+state);
			
			sql = "select gst_code from state where state_code=?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, state);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				gst_code = rs.getString("gst_code");
			}
			System.out.println("GST CODE is ====================="+gst_code);
			if(pstmt != null)
			{
			    pstmt.close(); 
			    pstmt = null;
			}
			if(rs != null)
			{
				rs.close();
			    rs = null;
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		return gst_code;
	}//end of method getStateFromLoginSite
	
	public double converStringToDouble(String value)
	{
		double amount = 0;
		if(value == "")
		{
			amount = 0;
		}
		else
		{
			amount = Double.valueOf(value);
		}
	    return amount;	
	}//end of method converStringToDouble 
	
	public boolean validGSTIN(String gstin,Connection conn)
	{
		boolean isValidFormat = false;
		 
		try
		{
			if (checkPattern(gstin, GSTINFORMAT_REGEX)) // if true return then call will go to verifyCheckDigit method
			{
				isValidFormat = verifyCheckDigit(gstin);
			} 
			System.out.println("isValidFormat[{{{{{{{{"+isValidFormat+"]");
		 }
		 catch(Exception e)
		 {
			 e.printStackTrace();
		 }
		 return isValidFormat;
	 }//end of method validGSTIN
	 
	 public boolean checkPattern(String inputval, String regxpatrn) 
	 {
			boolean result = false;
			System.out.println("inputval>>>>>>>>["+inputval+"]");
			System.out.println("regxpatrn>>>>>>>["+regxpatrn+"]");
			if ((inputval.trim()).matches(regxpatrn)) {
				result = true;
			}
			System.out.println("result is ======"+result);
			return result;
	}//end of method checkPattern
	 
	private boolean verifyCheckDigit(String gstinWCheckDigit) throws Exception 
	{
		Boolean isCDValid = false;
		String newGstninWCheckDigit = getGSTINWithCheckDigit(
		gstinWCheckDigit.substring(0, gstinWCheckDigit.length() - 1));

		System.out.println("gstinWCheckDigit::::::::::["+gstinWCheckDigit+"]");
		System.out.println("newGstninWCheckDigit::::::["+newGstninWCheckDigit+"]");
		if (gstinWCheckDigit.trim().equals(newGstninWCheckDigit))
		{
			isCDValid = true;
		}
		return isCDValid;
	}//end of method verifyCheckDigit
	 
	public String getGSTINWithCheckDigit(String gstinWOCheckDigit) throws Exception 
	{
		System.out.println("GSTIN in getGSTINWithCheckDigit is ["+gstinWOCheckDigit+"]");
		int factor = 2;
		int sum = 0;
		int checkCodePoint = 0;
		char[] cpChars;
		char[] inputChars;
		
		try 
		{
			if (gstinWOCheckDigit == null)
			{
				throw new Exception("GSTIN supplied for checkdigit calculation is null");
			}
				cpChars = GSTN_CODEPOINT_CHARS.toCharArray();
				inputChars = gstinWOCheckDigit.trim().toUpperCase().toCharArray();
				
				System.out.println("::::::::::::::cpChars["+cpChars+"]");
				System.out.println("::::::::::::::inputChars["+inputChars+"]");
				int mod = cpChars.length;
				for (int i = inputChars.length - 1; i >= 0; i--) 
				{
						int codePoint = -1;
						for (int j = 0; j < cpChars.length; j++) 
						{
						if (cpChars[j] == inputChars[i]) 
						{
							codePoint = j;
						}
					}
					int digit = factor * codePoint;
					factor = (factor == 2) ? 1 : 2;
					digit = (digit / mod) + (digit % mod);
					sum += digit;
				}
				checkCodePoint = (mod - (sum % mod)) % mod;
				System.out.println("::::::::::::::checkCodePoint["+checkCodePoint+"]");
				return gstinWOCheckDigit + cpChars[checkCodePoint];
			} 
		finally 
		{
			inputChars = null;
			cpChars = null;
		}
	}//end of method getGSTINWithCheckDigit
	
	public double getIgst_Amt(double rate,Document dom)
	{
		double igst_amt = 0.0;
		try
		{
			double taxable_amt =   Double.valueOf(gstUtility.checkNull(genericUtility.getColumnValue("taxable_amt", dom)));
			igst_amt = (taxable_amt * rate)/100;//System.out.println("RETURN VALUE"+"igst_amt::["+igst_amt+"]");
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		return igst_amt;
	}//end of method getIgst_Amt
	
	public double getCgst_Amt(double rate, Document dom)
	{
		System.out.println("Rate is :::["+rate+"]");
		double cgst_amt = 0.0,finalRate=0.0;
		String cgst_sgst_val;
		FinCommon  finCommon = null;
		Connection conn = null;
		try
		{
			conn = getConnection();
			finCommon = new FinCommon();
			double taxable_amt =   Double.valueOf(gstUtility.checkNull(genericUtility.getColumnValue("taxable_amt", dom)));
			System.out.println("taxable_amt::["+taxable_amt+"]");
			cgst_sgst_val = finCommon.getFinparams("999999", "CGST_SGST_RATIO_VAL", conn);
			System.out.println("cgst_sgst_val::["+cgst_sgst_val+"]");
			String[] retVal = cgst_sgst_val.split(":");
			String a = retVal[0];
			String b = retVal[1];
			Double num = Double.valueOf(a);
			Double den = Double.valueOf(b);
			finalRate = (rate * num)/(num+den);
			System.out.println("finalRate :::::::::["+finalRate+"]");
			cgst_amt = (taxable_amt * finalRate)/100;
			//System.out.println("RETURN VALUE"+"cgst_amt:::["+cgst_amt+"]");
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		return cgst_amt;
	}//end of method getCgst_Amt

	public double getSgst_Amt(double rate, Document dom)
	{
		System.out.println("Rate is :::["+rate+"]");
		double sgst_amt = 0.0,finalRate=0.0;
		String cgst_sgst_val;
		FinCommon  finCommon = null;
		Connection conn = null;
		try
		{
			conn = getConnection();
			finCommon = new FinCommon();
			double taxable_amt =   Double.valueOf(gstUtility.checkNull(genericUtility.getColumnValue("taxable_amt", dom)));
			System.out.println("taxable_amt for SGST::["+taxable_amt+"]");
			cgst_sgst_val = finCommon.getFinparams("999999", "CGST_SGST_RATIO_VAL", conn);
			System.out.println("cgst_sgst_val::["+cgst_sgst_val+"]");
			String[] retVal = cgst_sgst_val.split(":");
			String a = retVal[0];
			String b = retVal[1];
			Double num = Double.valueOf(a);
			Double den = Double.valueOf(b);
			finalRate = (rate * den)/(num+den);
			System.out.println("finalRate :::::::::["+finalRate+"]");
			sgst_amt = (taxable_amt * finalRate)/100;//System.out.println("RETURN VALUE"+"sgst_amt:::["+sgst_amt+"]");
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		return sgst_amt;
	}//end of method getSgst_Amt
}
