/********************************************************
	Title 	 : MiscPaySubAct[F14FSUN003]
	Date  	 : 17/SEP/14
	Developer: Sagar M.
 ********************************************************/
package ibase.webitm.ejb.fin.adv;

import ibase.utility.E12GenericUtility;
import ibase.webitm.utility.*;
import ibase.webitm.ejb.*;
import ibase.system.config.*;
import ibase.webitm.utility.ITMException;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.ejb.fin.FinCommon;
import ibase.webitm.ejb.sys.UtilMethods;

import java.rmi.RemoteException;
import java.sql.*;
import java.text.SimpleDateFormat;
import java.util.*;

import javax.ejb.Stateless; 

//import bsh.util.Util;

@Stateless 

public class MiscPaySubAct extends ActionHandlerEJB implements MiscPaySubActLocal, MiscPaySubActRemote 
{
	/**
	 * The public method is used for update the Workflow status
	 * @param tranId 
	 * @param xtraParams contais additional information such as loginEmpCode,loginCode,chgTerm etc
	 * @param forcedFlag (true or false)
	 */
	String userId = "", termId = "";
//	GenericUtility genericUtility = GenericUtility.getInstance();
	E12GenericUtility genericUtility = new E12GenericUtility();

	@Override
	public String actionHandler(String tranId, String xtraParams, String forcedFlag) throws RemoteException, ITMException
	{
		System.out.println("---ActionHandler---@@@@@@@@xtraParams["+xtraParams+"]@@@@@@forcedFlag["+forcedFlag+"]");
		Connection conn = null;
		PreparedStatement pstmt = null, pstmt1 = null, pstmt2 = null;
		ResultSet rs = null, rs1 = null, rs2 = null;
		String retString = "";
		String sql = ""; String sql1 = ""; String sql2 = "";
		String confStatus="",wfStatus="",sundryCode = "", payMode = "", supPayMod = "", bankCode = "", chqNo = "",sundryType="";
		String finparPayMode="";
		/*String currAppdate ="";
		String tranIdTest="",todayStr="";*/
		java.sql.Timestamp datesubmit=null;
		//added by vishakha on 03/Aug/2015 for validations on Submit button.
		double totAmt = 0.0,totAmtMiscPay = 0.0,adjAmtMiscPay = 0.0,payAmt = 0.0;
		int cnt = 0, cnt1 = 0;
		int dupChqCnt=0;
		double holdAmtMiscPay=0;
		ArrayList<String> stnCdList = new ArrayList<String>();
		ArrayList<String> finparPayModeArrList=new ArrayList<String>();
		String finparPayModeArr[];
		boolean stanCdBlank = false, stanCdDupl = false, stanCodeInv = false;

		//	String ignorechklimit ="",tranKeyFld = "",bankCode = "",siteCode = "",payType = "";
		Timestamp tranDate = null;
		String refNo = "",tranSer = "";
		FinCommon fin = new FinCommon();
		String stationCode="";
		String sundrtyTypeDet="";
		int countBankStanSer=0;
		String sundryCodeDet="";
		String bankAcct="",ifsc="";
		int countVouchNo=0;
		double subPayAmt=0;
		double payableAmt=0;

		String syndryTable="", tranIdColmn="", bankTable="";
		int cntNEFT=0;

		Timestamp miscPaySubDate= null;
		String miscPaySubDays="";
		int miscPaySubDay=0;

		try
		{
			ConnDriver connDriver = null;
			connDriver = new ConnDriver();
			//Changes and Commented By Bhushan on 06-06-2016 :START
//conn = connDriver.getConnectDB("DriverITM");
conn = getConnection();
//Changes and Commented By Bhushan on 06-06-2016 :END
			conn.setAutoCommit(false);
			connDriver = null;

			ITMDBAccessEJB itmDBAccessLocal = new ITMDBAccessEJB();
			userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginCode");  
			termId =  genericUtility.getValueFromXTRA_PARAMS(xtraParams, "termId");
			if (userId == null || userId.trim().length() == 0)
			{
				userId = "SYSTEM";
			}
			if (termId == null || termId.trim().length() == 0)
			{
				termId = "SYSTEM";
			}

			System.out.println(">>>>>>>>>>tranId:"+tranId);
			sql = "SELECT CONFIRMED,CASE WHEN WF_STATUS IS NULL THEN 'O' ELSE WF_STATUS END AS WF_STATUS,SUNDRY_CODE,SUNDRY_TYPE,PAY_MODE,"
					+ "BANK_CODE,REF_NO, TRAN_DATE" 
					+" FROM MISC_PAYMENT WHERE TRAN_ID= ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, tranId);
			rs = pstmt.executeQuery();
			if ( rs.next() )
			{
				confStatus = rs.getString("CONFIRMED").trim();
				wfStatus = rs.getString("WF_STATUS").trim();
				sundryCode = checkNull(rs.getString("SUNDRY_CODE"));
				sundryType = checkNull(rs.getString("SUNDRY_TYPE"));
				payMode = checkNull(rs.getString("PAY_MODE"));
				bankCode = checkNull(rs.getString("BANK_CODE"));
				chqNo = checkNull(rs.getString("REF_NO"));
				tranDate = rs.getTimestamp("TRAN_DATE");
			}
			pstmt.close();
			pstmt = null;					
			rs.close();
			rs = null;

			if( "Y".equalsIgnoreCase(confStatus) )
			{
				retString = itmDBAccessLocal.getErrorString("","VTDIST26","");
				return retString;
			}
			if( "S".equalsIgnoreCase(wfStatus) )
			{
				retString = itmDBAccessLocal.getErrorString("","ALRDYSUBMT","");
				return retString;
			}
			if( "N".equalsIgnoreCase(confStatus) && "O".equalsIgnoreCase(wfStatus))
			{		
				//added by vishakha on 03/Aug/2015 as to incorporate the validations on submit button like those on commit button.

				//Start added by chandrashekar on 28-dec-2015
				sql = " SELECT VAR_VALUE FROM FINPARM WHERE PRD_CODE = '999999' AND VAR_NAME = 'PAY_MOD_REFVAL'";
				pstmt = conn.prepareStatement(sql);
				rs = pstmt.executeQuery();
				if (rs.next())
				{
					finparPayMode = checkNull(rs.getString("VAR_VALUE"));
					System.out.println("finparPayMode :" + finparPayMode);
				}
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;
				if (finparPayMode == null || finparPayMode.trim().equalsIgnoreCase("NULLFOUND") || finparPayMode.trim().length()==0 )
				{
					System.out.println("FINPARM is not defind for PAY_MODE");
					retString = itmDBAccessLocal.getErrorString("","VTFPPAYMOD","");
					return retString;
				}
				if(finparPayMode.trim().length()>0)
				{
					finparPayModeArr=finparPayMode.split(",");
					finparPayModeArrList.addAll(Arrays.asList(finparPayModeArr));
				}

				if(finparPayModeArrList.contains(payMode.trim()))
				{
					if(chqNo.trim().length()>0)
					{
						retString = itmDBAccessLocal.getErrorString("","VTREFNTALW","");
						return retString;
					}
				}
				//End added by chandrashekar on 28-dec-2015

				sql = "select sum(pay_amt) as totAmt from misc_paydet where tran_id = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, tranId);
				rs = pstmt.executeQuery();
				if ( rs.next() )
				{
					totAmt = rs.getDouble("totAmt");//fetching totalAmount from details
				}
				pstmt.close();
				pstmt = null;					
				rs.close();
				rs = null;

				if(totAmt < 0.0)//total amount should not be negative
				{
					retString = itmDBAccessLocal.getErrorString("","VTAMTMIS1","");
					return retString;
				}

				// added by cpatil for validation of submission for perticular days

				Timestamp newsysDate = getCurrdateAppFormat();
				System.out.println("Now the date is :=>  ["+newsysDate+"]");

				sql = " SELECT VAR_VALUE FROM FINPARM WHERE PRD_CODE = '999999' AND VAR_NAME = 'MISCPAY_SUB_DAYS'";
				pstmt = conn.prepareStatement(sql);
				rs = pstmt.executeQuery();
				if (rs.next())
				{
					miscPaySubDays = checkNull(rs.getString("VAR_VALUE"));
				}
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;
				System.out.println("miscPaySubDays :[" + miscPaySubDays+"]");

				if(miscPaySubDays != null && miscPaySubDays.trim().length()>0 )
				{
					miscPaySubDay = Integer.parseInt(miscPaySubDays);
					System.out.println("miscPaySubDay :[" + miscPaySubDay+"]tranDate["+tranDate+"]");
					UtilMethods utilMethods = new UtilMethods();
					miscPaySubDate =  utilMethods.RelativeDate(newsysDate, -1 * miscPaySubDay);
					System.out.println("miscPaySubDate :[" + miscPaySubDate+"]");
					if( tranDate.before(miscPaySubDate)  )
					{
						retString = itmDBAccessLocal.getErrorString("","DATEBEFSUB","");
						return retString;
					}
				}
				// end

				sql1 = "select TRAN_SER,vouch_no,pay_amt,stan_code,sundry_type,sundry_code from misc_paydet where tran_id = ?";
				pstmt1 = conn.prepareStatement(sql1);
				pstmt1.setString(1, tranId);
				rs1 = pstmt1.executeQuery();
				while ( rs1.next() )
				{

					tranSer = checkNull(rs1.getString("TRAN_SER"));
					refNo = checkNull(rs1.getString("vouch_no"));
					payAmt = rs1.getDouble("pay_amt");
					stationCode= checkNull(rs1.getString("stan_code"));
					sundrtyTypeDet= checkNull(rs1.getString("sundry_type"));
					sundryCodeDet= checkNull(rs1.getString("sundry_code"));
					countVouchNo=0;
					/*sql="select count(a.tran_id) from misc_payment a,misc_paydet b where a.tran_id=b.tran_id and a.tran_id<>? " +
				    		" and b.vouch_no=? and case when a.wf_status is null then 'O' else a.wf_status end ='S' and case when a.confirmed is null then 'N' else a.confirmed end ='N' ";
				    pstmt=conn.prepareStatement(sql);
				    pstmt.setString(1,tranId);
				    pstmt.setString(2,refNo);
				    rs=pstmt.executeQuery();
				    if(rs.next())
				    {
				    	countVouchNo=rs.getInt(1);
				    }
				    rs.close();
				    rs=null;
				    pstmt.close();
				    pstmt=null;
				    if(countVouchNo>0)
				    {
				    	retString = itmDBAccessLocal.getErrorString("","VTIINVVCH","");
						return retString;
				    }*/



					if("T".equalsIgnoreCase(payMode) && "E".equalsIgnoreCase(sundrtyTypeDet))
					{

						sql="select count(1) from bank_stan_serv where bank_code=? and stan_code=?";
						pstmt=conn.prepareStatement(sql);
						pstmt.setString(1,bankCode);
						pstmt.setString(2, stationCode);
						rs=pstmt.executeQuery();
						if(rs.next())
						{
							countBankStanSer=rs.getInt(1);
						}
						rs.close();
						rs=null;
						pstmt.close();
						pstmt=null;
						if(countBankStanSer==0)
						{
							retString = itmDBAccessLocal.getErrorString("","VTINBNKSTN","");
							return retString;	
						}
						sql="select bank_acct,ifsc from employee where emp_code=? ";
						pstmt=conn.prepareStatement(sql);
						pstmt.setString(1,sundryCodeDet);
						rs=pstmt.executeQuery();
						while(rs.next())
						{
							bankAcct=checkNull(rs.getString("bank_acct"));
							ifsc=checkNull(rs.getString("ifsc"));
						}
						rs.close();
						rs=null;
						pstmt.close();
						pstmt=null;
						if(bankAcct.trim().length()==0)
						{
							retString = itmDBAccessLocal.getErrorString("","VTIINVACCT","");
							return retString;	
						}
						// remove commented by cpatil on 17/03/16 for ifsc code not validate
						if(ifsc.trim().length()==0)
						{
							retString = itmDBAccessLocal.getErrorString("","VTIINVIFSC","");
							return retString;	
						}

					}
					// if(!"E".equalsIgnoreCase(sundrtyTypeDet.trim()) && finparPayModeArrList.contains(payMode.trim()))

					// added by cpatil on 10/02/16 start  

					if("N".equalsIgnoreCase(payMode))
					{
						System.out.println("@@@@@ inside NEFT--->sundryType["+sundryType+"]bankCode["+bankCode+"]sundryCode["+sundryCode+"]");

						if("S".equalsIgnoreCase(sundryType))
						{
							syndryTable="supplier";
							tranIdColmn="supp_code";
							bankTable="supplier_bank";
						}
						else if("C".equalsIgnoreCase(sundryType))
						{
							syndryTable="customer";
							tranIdColmn="cust_code";
							bankTable="customer_bank";
						}
						else if("T".equalsIgnoreCase(sundryType))
						{
							syndryTable="transporter";
							tranIdColmn="tran_code";
							bankTable="transporter_bank";
						}
						else if("L".equalsIgnoreCase(sundryType))
						{
							syndryTable="loanparty";
							tranIdColmn="party_code";
							bankTable="loanparty_bank";
						}
						else if("P".equalsIgnoreCase(sundryType))
						{
							syndryTable="sales_pers";
							tranIdColmn="sales_pers";
							bankTable="sales_pers_bank";
						}
						System.out.println("@@@@@ sundryType["+sundryType+"]syndryTable["+syndryTable+"]tranIdColmn["+tranIdColmn+"]bankTable["+bankTable+"]");

						if(!"E".equalsIgnoreCase(sundryType)) //added by cpatil to not validate at a time of E 05/04/16
						{
							sql=" select count(1) from "+bankTable+" " +
									" where "+tranIdColmn+" = ? " +
									//	" and BANK_CODE__BEN = ?  " +
									" and   CASE WHEN ACTIVE_YN IS NULL THEN 'N' ELSE ACTIVE_YN END  = 'Y' " +
									" and   CASE WHEN CONFIRMED IS NULL THEN 'N' ELSE CONFIRMED END  = 'Y'  " ;
							//	" and ACTIVE_YN = 'Y' and CONFIRMED = 'Y' ";
							pstmt=conn.prepareStatement(sql);
							pstmt.setString(1,sundryCode);
							//pstmt.setString(2,bankCode);
							rs=pstmt.executeQuery();
							while(rs.next())
							{
								cntNEFT = rs.getInt(1);
							}
							rs.close();
							rs=null;
							pstmt.close();
							pstmt=null;
							System.out.println("@@@@1 cntNEFT["+cntNEFT+"]");
							if( cntNEFT == 0)
							{
								System.out.println("@@@@@@@@@ sundry bank details not define for sundry code"+ sundryCode);
								retString = itmDBAccessLocal.getErrorString("","VMSBDNODEF","");
								return retString;
							}
							cntNEFT=0;
							sql=" select count(1) from "+bankTable+" " +
									" where "+tranIdColmn+" = ? " +
									" and   CASE WHEN ACTIVE_YN IS NULL THEN 'N' ELSE ACTIVE_YN END  = 'Y' " +
									" and   CASE WHEN CONFIRMED IS NULL THEN 'N' ELSE CONFIRMED END  = 'Y'  " ;
							//	" and ACTIVE_YN = 'Y' and CONFIRMED = 'Y' ";
							pstmt=conn.prepareStatement(sql);
							pstmt.setString(1,sundryCode);
							rs=pstmt.executeQuery();
							while(rs.next())
							{
								cntNEFT = rs.getInt(1);
							}
							rs.close();
							rs=null;
							pstmt.close();
							pstmt=null;
							System.out.println("@@@@2 cntNEFT["+cntNEFT+"]");
							if( cntNEFT > 1)
							{
								System.out.println("@@@@@@@@@ multiple sundry bank details are define for sundry code"+ sundryCode);
								retString = itmDBAccessLocal.getErrorString("","VMSBDMLDEF","");
								return retString;
							}
						}	
					}
					// end by cpatil


					if ((stationCode.trim()).length()==0)
					{
						stanCdBlank = true;
						break;
					}
					else if(finparPayModeArrList.contains(payMode.trim()))
					{
						System.out.println("@V@ Stan code not blank");
						/*if (!"E".equalsIgnoreCase(sundryType))
				          {
				          System.out.println("@V@ Sundry type NOT 'E'");*/
						if (stnCdList.size() > 0)
						{
							System.out.println("@V@ List size is NOT 0 :-[" + stnCdList.size() + "]");
							if (!stnCdList.contains(stationCode))
							{
								System.out.println("@V@ Stan code match NOT found");
								stanCdDupl = true;
								break;
							}

						}
						else
						{
							System.out.println("@V@ First Stan code added in list");
							stnCdList.add(stationCode);
						}
						// }
					}

					sql = "SELECT tot_amt as tot_amt, adj_amt as adj_amt ,hold_amt,sundry_type as sundrytype from misc_payables where tran_ser = ?"
							+ "  and ref_no = ?  ";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1,tranSer);
					pstmt.setString(2,refNo);

					rs = pstmt.executeQuery();
					while ( rs.next() )
					{
						totAmtMiscPay = rs.getDouble("tot_amt");
						adjAmtMiscPay = rs.getDouble("adj_amt");
						holdAmtMiscPay= rs.getDouble("hold_amt");
						System.out.println("totAmtMiscPay ========="+ totAmtMiscPay);
						System.out.println("adjAmtMiscPay ========="+ adjAmtMiscPay);
						System.out.println("Pay Amount ============ "+ payAmt);
						sql = "select sum(case when b.pay_amt is null then 0 else b.pay_amt end) from misc_payment a,misc_paydet b where a.tran_id=b.tran_id and wf_status='S'"
								+ " AND CONFIRMED='N' and b.tran_id <> ? and b.VOUCH_NO=? and b.tran_ser=?";
						pstmt2=conn.prepareStatement(sql);
						pstmt2.setString(1,tranId);
						pstmt2.setString(2,refNo);
						pstmt2.setString(3,tranSer);
						rs2=pstmt2.executeQuery();
						if(rs2.next())
						{
							subPayAmt=rs2.getDouble(1);

						}
						rs2.close();
						rs2=null;
						pstmt2.close();
						pstmt2=null;
						System.out.println("subPayAmt["+subPayAmt+"]");
						System.out.println("holdAmtMiscPay["+holdAmtMiscPay+"]");
						if(Math.abs(totAmtMiscPay - adjAmtMiscPay-holdAmtMiscPay-subPayAmt) < Math.abs(payAmt))//if there is no balance in misc_payables
						{
							System.out.println("Entering the if condition Pay Amount ============ "+ payAmt);
							retString = itmDBAccessLocal.getErrorString("","VTBAL1","");
							return retString;
						}

					}
					pstmt.close();
					pstmt = null;					
					rs.close();
					rs = null;

				}
				pstmt1.close();
				pstmt1 = null;					
				rs1.close();
				rs1 = null;


				/**
				 * VALLABH KADAM
				 * Validation for [F14FSUN003]
				 * on [16/SEP/15]
				 * */
				System.out.println("@V@ Sundry Type :- [" + sundryType + "]");
				System.out.println("@V@ Sundry Code :- [" + sundryCode + "]");

				if ("S".equalsIgnoreCase(sundryType))
				{
					System.out.println("@V@ Pay Mode :- [" + payMode + "]");

					sql = "select pay_mode from SUPPLIER where supp_code=?";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, sundryCode);

					rs = pstmt.executeQuery();
					if (rs.next())
					{
						supPayMod = checkNull(rs.getString("pay_mode"));
					}
					pstmt.close();
					pstmt = null;
					rs.close();
					rs = null;

					System.out.println("@V@ Supplier Pay Mode :- [" + supPayMod + "]");

					if (("N".equalsIgnoreCase(supPayMod)) && (!supPayMod.equalsIgnoreCase(payMode)))
					{
						System.out.println("@V@ Pay Mode not matching");
						retString = itmDBAccessLocal.getErrorString("", "VTPYMDDIFF", "");		            
						return retString;
					}
				}

				/*sql = "select stan_code from misc_paydet where tran_id=?";
		        pstmt = conn.prepareStatement(sql);
		        pstmt.setString(1, tranId);

		        rs = pstmt.executeQuery();
		        while (rs.next())
		        {
		          if ((rs.getString("stan_code") == null) || (checkNull(rs.getString("stan_code")).length() == 0))
		          {
		            stanCdBlank = true;
		            break;
		          }
		          else
		          {
		          System.out.println("@V@ Stan code not blank");

//		          sql2 = "select count(*) a cnt from station where stan_code=?";
//		          pstmt2 = conn.prepareStatement(sql2);
//		          pstmt2.setString(1, checkNull(rs.getString("stan_code")));
//
//		          rs2 = pstmt2.executeQuery();
//		          if (rs2.next())
//		          {
//		            cnt1 = rs2.getInt("cnt");
//		          }
//		          pstmt2.close();
//		          pstmt2 = null;
//		          rs2.close();
//		          rs2 = null;
//
//		          if (cnt1 == 0)
//		          {
//		            stanCodeInv = true;
//		            break;
//		          }

		          if (!"E".equalsIgnoreCase(sundryType))
		          {
		          System.out.println("@V@ Sundry type NOT 'E'");
		          if (stnCdList.size() > 0)
		          {
		            System.out.println("@V@ List size is NOT 0 :-[" + stnCdList.size() + "]");
		            if (!stnCdList.contains(rs.getString("stan_code")))
		            {
		              System.out.println("@V@ Stan code match NOT found");
		              stanCdDupl = true;
		              break;
		            }

		          }
		          else
		          {
		            System.out.println("@V@ First Stan code added in list");
		            stnCdList.add(rs.getString("stan_code"));
		          }
		          }
		        }
		        }
		        pstmt.close();
		        pstmt = null;
		        rs.close();
		        rs = null;*/

				if (stanCdBlank)
				{
					System.out.println("@V@ Station code null found");
					retString = itmDBAccessLocal.getErrorString("", "VTSTNCDBLK", "");
					return retString;
				}
				if (stanCodeInv)
				{
					System.out.println("@V@ Station code invalid");
					retString = itmDBAccessLocal.getErrorString("", "VTSTNCDINV", "");
					return retString;
				}
				/* if (!"E".equalsIgnoreCase(sundryType))
		        {
		          if (stanCdDupl)
		          {
		            System.out.println("@V@ Station code Duplicate found");
		            retString = itmDBAccessLocal.getErrorString("", "VTSTNCDDPL", "");
		            return retString;
		          }
		        }*/
				if (stanCdDupl)
				{
					System.out.println("@V@ Station code Duplicate found");
					retString = itmDBAccessLocal.getErrorString("", "VTSTNCDDPL", "");
					return retString;
				}


				/* sql = "SELECT COUNT(*) AS CNT FROM BANKTRAN_LOG WHERE BANK_CODE=? AND TRAN_TYPE='P' AND TRAN_SER <> 'R-DIS' AND REF_NO=?";
		        pstmt = conn.prepareStatement(sql);
		        pstmt.setString(1, bankCode);
		        pstmt.setString(2, chqNo);

		        rs = pstmt.executeQuery();
		        if (rs.next())
		        {
		          cnt = rs.getInt("CNT");
		        }
		        pstmt.close();
		        pstmt = null;
		        rs.close();
		        rs = null;

		        if (cnt > 0)
		        {
		          System.out.println("@V@ Duplicate cheque found");
		          retString = itmDBAccessLocal.getErrorString("", "VTCHQ3", "");
		          return retString;
		        }*/	
				/* String[] arrStr =finparPayMode.split(",");
		          for(int i =0;i<arrStr.length;i++)
		          {
						PayMode1 =arrStr[i];
						System.out.println("PayMode1>>>>@@@@"+PayMode1);

						if(!payMode.equalsIgnoreCase(PayMode1))
						{
							sql = "select count(*) as cnt  from misc_paydet misdet,misc_payment mispay " +
									"where misdet.tran_id=mispay.tran_id and mispay.tran_id <> ? " +
									"and mispay.ref_no=? ";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, tranId);
							pstmt.setString(2, chqNo);

							rs = pstmt.executeQuery();
							if (rs.next())
							{
								dupChqCnt = rs.getInt("cnt");
							}
							pstmt.close();
							pstmt = null;
							rs.close();
							rs = null;
							if (dupChqCnt > 0)
							{
								System.out.println("@V@ Duplicate cheque found");
								retString = itmDBAccessLocal.getErrorString("", "VTCHQ3", "");
								return retString;
							}
						}
		          }*/

				//Start added by chandrashekar on 29-dec-2015
				System.out.println("payMode>>>"+payMode);
				//if(!finparPayModeArrList.contains(payMode.trim()))
				if( "Q".equalsIgnoreCase(payMode.trim()))
				{		
					System.out.println("list not match with paymode");
					sql = " select count(*) as cnt  from misc_payment mispay " +
							" where mispay.tran_id <> ? " +
							" and mispay.ref_no = ? " +
							" and bank_code = ? ";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, tranId);
					pstmt.setString(2, chqNo);
					pstmt.setString(3, bankCode);  // added bank_code condition on 30/12/15

					rs = pstmt.executeQuery();
					if (rs.next())
					{
						dupChqCnt = rs.getInt("cnt");
					}
					pstmt.close();
					pstmt = null;
					rs.close();
					rs = null;
					if (dupChqCnt > 0)
					{
						System.out.println("@V@ Duplicate cheque found");
						retString = itmDBAccessLocal.getErrorString("", "VTCHQ3", "");
						return retString;
					}
				}
				//End added by chandrashekar on 29-dec-2015


				/**
				 * VALLABH KADAM
				 * Validation for [F14FSUN003]
				 * on [16/SEP/15]
				 * END
				 * */

				//SQL for update the work flow status/..........
				sql = "UPDATE MISC_PAYMENT SET WF_STATUS='S',emp_code__submit=?,submit_date=? WHERE tran_id = ?";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,userId);
				datesubmit=new java.sql.Timestamp(System.currentTimeMillis());
				pstmt.setTimestamp(2,datesubmit);
				pstmt.setString(3,tranId);
				int rowcnt = pstmt.executeUpdate();
				pstmt.close();
				pstmt = null;
				if(rowcnt > 0)
				{
					retString = itmDBAccessLocal.getErrorString("","SUBMITSUCC","");
					System.out.println(">>>>>>>>>>>>>>>Before conn.commit()");
					conn.commit();
					//return retString;
				}					
			}			
		}
		catch(Exception e)
		{
			try
			{
				conn.rollback();
			}
			catch (Exception e1)
			{
			}
			e.printStackTrace();
			System.out.println("Exception ::"+e.getMessage());
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(pstmt1 != null)
				{
					pstmt1.close();
					pstmt1 = null;					
				}	
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;					
				}		
				if( conn != null && ! conn.isClosed() )
				{
					conn.close();
					conn = null;
				}
			}
			catch(Exception ef)
			{
				System.out.println(ef.getMessage());
				ef.printStackTrace();
				throw new ITMException(ef);
			}
		}
		System.out.println("Returning Result ::"+retString);
		return retString;
	}

	private Timestamp getCurrdateAppFormat()
	{
		//String s = "";	
		Timestamp timestamp = null;		
		E12GenericUtility genericUtility = new E12GenericUtility();
		try
		{
			java.util.Date date = null;
			timestamp = new Timestamp(System.currentTimeMillis());

			SimpleDateFormat simpledateformat = new SimpleDateFormat(genericUtility.getDBDateFormat());
			date = simpledateformat.parse(timestamp.toString());
			timestamp = Timestamp.valueOf(simpledateformat.format(date).toString() + " 00:00:00.0");
		}
		catch(Exception exception)
		{
			System.out.println("Exception in  getCurrdateAppFormat " + exception.getMessage());
		}
		return timestamp;
	}

	private String checkNull( String input )
	{
		if ( input == null )
		{
			input = "";
		}
		return input;
	}
}
/********CODE COMMENTED as it only checks the balance for bank_type = 'B'*********/
/*public String getBalChk(String bankCode,String siteCode,Timestamp tranDate,double netAmt,Connection conn)throws Exception
	{
		System.out.println("@@@@@@getBalChk method@@@@@@@");
		String errCode = "";
		double bal = 0.0;
		ITMDBAccessEJB itmDBAccessLocal = new ITMDBAccessEJB();
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String sql = "",bankType = "",acctprd = "";
		sql = "select bank_type as ls_type from bank where  bank_code = ? ";
		pstmt = conn.prepareStatement(sql);
		pstmt.setString(1,bankCode);
		rs = pstmt.executeQuery();
		if ( rs.next() )
		{
			bankType = checkNull(rs.getString("ls_type"));
		}
		pstmt.close();
		pstmt = null;					
		rs.close();
		rs = null;
		sql = "select code as ls_acctprd from acctprd where ?  between fr_date and to_date ";
		pstmt = conn.prepareStatement(sql);
		pstmt.setTimestamp(1,tranDate);
		rs = pstmt.executeQuery();
		if ( rs.next() )
		{
			acctprd = rs.getString("ls_acctprd");
		}
		pstmt.close();
		pstmt = null;					
		rs.close();
		rs = null;
		if(bankType == "C")
		{
			sql = "select sum(dr_amt - cr_amt) as lc_bal from sundrybal where acct_prd = ? and prd_code = 'zzzzzz' and site_code = ?  and sundry_type = 'B' and sundry_code = ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,acctprd);
			pstmt.setString(2,siteCode);
			pstmt.setString(3,bankCode);
			rs = pstmt.executeQuery();
			if ( rs.next() )
			{
				bal = rs.getDouble("lc_bal");
			}
			pstmt.close();
			pstmt = null;					
			rs.close();
			rs = null;
			System.out.println("Value of sum(dr_amt - cr_amt)"+bal);
			System.out.println("Value of net amount ==========="+netAmt);
		if(netAmt > 0.0 && netAmt > bal )
		{
			errCode =  itmDBAccessLocal.getErrorString("","VTPAYAMT","");
			return errCode;
		}

		}

		return errCode;
	}


	sql = "select tran_id as ls_keyfld, bank_code as ls_bank, net_amt as lc_net, site_code as ls_site, tran_date as ld_tran_date,ref_no , pay_type as ls_pay_type from misc_payment where tran_id = ?  for update nowait";
	pstmt = conn.prepareStatement(sql);
	pstmt.setString(1, tranId);
	rs = pstmt.executeQuery();
	if ( rs.next() )
	{
		tranKeyFld = checkNull(rs.getString("ls_keyfld"));
		bankCode = checkNull(rs.getString("ls_bank"));
		netAmt = rs.getDouble("lc_net");
		tranDate = rs.getTimestamp("ld_tran_date");
		siteCode = checkNull(rs.getString("ls_site"));
		payType = checkNull(rs.getString("ls_pay_type"));
		refNo = checkNull(rs.getString("ref_no"));
	}
	pstmt.close();
	pstmt = null;					
	rs.close(); 
	rs = null;


		ignorechklimit = fin.getFinparams("999999","IGNORE_WARNINGS",conn);
	System.out.println("Value of Ignore chk limit ===="+ignorechklimit);
	if("NULLFOUND".equals(ignorechklimit ) || ignorechklimit == null)
	{
		ignorechklimit = "N";
		System.out.println("Value of Ignore chk limit ===="+ignorechklimit);
	}
	if("N".equalsIgnoreCase(ignorechklimit))
	{
		System.out.println("Insiding****BalChk condition");
		retString = getBalChk(bankCode,siteCode,tranDate,netAmt,conn);
		if(retString.trim().length() > 0)
		{
			return retString;
		}
	}*/

