<?xml version='1.0' encoding='utf-8'?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html"/>
<xsl:decimal-format NaN="0"/>

<xsl:template match="/">

<html>

<body onload="formatDate();">
<script type="text/javascript" src="/ibase/webitm/js/gstRegNoWiz1.js"></script>
<script type="text/javascript" src="/ibase/webitm/js/gstRegNoWiz.js"></script>
<script type="text/javascript" src="/ibase/webitm/js/jquery-1.10.2.js"></script>
<script type="text/javascript" src="/ibase/webitm/js/jquery-ui-1.10.4.custom.min.js"></script>
<script type="text/javascript" src="/ibase/webitm/js/FixedTableHeader.js"></script>
<script language="Javascript" src="/ibase/webitm/js/jquery.datetimepicker.full.js"></script>
<script language="Javascript" src="/ibase/webitm/js/date.js"></script>

<link href="/ibase/webitm/css/jquery-ui-1.10.4.custom.min.css" rel="stylesheet"/>
<script type="text/javascript" src="/ibase/webitm/js/jquery.ui.core.js"></script>
<script type="text/javascript" src="/ibase/webitm/js/jquery.ui.widget.js"></script>
<script type="text/javascript" src="/ibase/webitm/js/jquery.ui.position.js"></script>
<script type="text/javascript" src="/ibase/webitm/js/jquery.ui.menu.js"></script>
<script type="text/javascript" src="/ibase/webitm/js/jquery.ui.autocomplete.js"></script>
		
<link href="/ibase/webitm/css/htmlWizard.css" rel="stylesheet"/>
<link href="/ibase/webitm/css/gstRegNoWiz.css" rel="stylesheet"/>
<link href="/ibase/webitm/css/jquery.datetimepicker.css" rel="stylesheet"/>
<script>
<![CDATA[
	$(document).on("keydown", function (e) {
    if (e.which === 8 && !$(e.target).is("input, textarea, form")) {
        e.preventDefault();
    }
    else if(e.which ===13){
    	 e.preventDefault();
    }
});
]]>
</script>

<form name="wavegenWizForm1" id="wavegenWizForm1" METHOD="post" ACTION="/ibase/ITMWizardHandlerServlet">
	<div id="innerDiv" style="overflow-y:hidden;overflow-x:auto;max-height:80%;width:98%;position:absolute;">
	    <table id="errorActivityTable" height="10%" class="tableClass"  style="margin: 12px 0px 0px 0px;position: relative;width: calc(literal('100% - 15px'));width: -moz-calc(literal('100% - 15px'));padding-right:0px; padding-left:5xp; width: -webkit-calc(literal('100% - 15px'));box-shadow: 3px 3px 3px gray;-moz-box-shadow:3px 3px 3px gray;-webkit-box-shadow: 3px 3px 3px gray;-o-box-shadow: 3px 3px 3px gray;background: rgba(255, 204, 0, 0.66);min-height: 50px;bottom:10px"  border="0" cellspacing="0" cellpadding="0"> 
            <xsl:for-each select="//error">
                <xsl:if test="position() = 1">
                    <tr>    
                        <td class="tdss_leftAlign" style="background: rgba(255, 204, 0, 0.66);"   nowrap="true" valign="bottom">
                            Message :
                        </td> 
                        <td class="tdss_leftAlign"   style="background: rgba(255, 204, 0, 0.66);"   nowrap="true" valign="bottom">
                            Description :
                        </td>
                        <td class="tdss_rightAlign"  style="background: rgba(255, 204, 0, 0.66);" nowrap="true" valign="bottom" colspan="2">
                            <a href="#" style="text-decoration:none;" onclick="doHideMsg('errorActivityTable')"><font style="color:#000;text-decoration:none;padding-right:5px;" ><b>X</b></font></a>
                        </td>
                    </tr>
                </xsl:if>
                <xsl:variable name="message"><xsl:value-of select="message"/></xsl:variable>
                <xsl:variable name="description"><xsl:value-of select="description"/></xsl:variable>
                <xsl:variable name="type"><xsl:value-of select="type"/></xsl:variable>
                <xsl:variable name="dbID"><xsl:value-of select="@domId"/></xsl:variable>  
                <xsl:variable name="column_name"><xsl:value-of select="@column_name"/></xsl:variable> 
                <tr style="background: rgba(255, 204, 0, 0.66);">
                     <td class="tdss_leftAlign" style="background: rgba(255, 204, 0, 0.66);" nowrap="true">
                        <xsl:value-of select="message"/>
                    </td> 
                    
                    <td class="tdss_leftAlign" style="background: rgba(255, 204, 0, 0.66);" nowrap="true">
                        <xsl:value-of select="description"/>
                    </td>
                    
                    <td class="tdss_leftAlign" style="background: rgba(255, 204, 0, 0.66);"  nowrap="true">
                    </td>
                </tr>
            </xsl:for-each>
            
            <xsl:for-each select="//error">
                <xsl:variable name="type"><xsl:value-of select="type"/></xsl:variable>
                <xsl:if test="position() = 1">
                    <xsl:if test="$type = 'W'">
                        <tr style="background: rgba(255, 204, 0, 0.66);">
                            <td class="tdss_leftAlign"  style="background: rgba(255, 204, 0, 0.66);"  nowrap="true" valign="bottom">
                                <input  type="checkbox" name="forceSave" value="true" checked="checked" onClick="setChecked(this)"/>
                            </td>
                            <td class="tdss_leftAlign" style="background: rgba(255, 204, 0, 0.66);"  nowrap="true"></td>
                        </tr>
                    </xsl:if>
                </xsl:if>    
            </xsl:for-each>
	    </table>
	</div>
	
	<div id="popHelpContainer"></div>
	<div id="overlay"></div>
	<div id="mainPageHeaderContatiner">
		<div id="mainPage-input-Container">
			<xsl:for-each select="//Detail1">
				<xsl:variable name="dbID"><xsl:value-of select="@domID"/></xsl:variable>
				<xsl:variable name="fin_entity"><xsl:value-of select="fin_entity"/></xsl:variable>
				<xsl:variable name="finent_descr"><xsl:value-of select="finent_descr"/></xsl:variable>
				<xsl:variable name="site_code"><xsl:value-of select="site_code"/></xsl:variable>
				<xsl:variable name="site_descr"><xsl:value-of select="site_descr"/></xsl:variable>
				<xsl:variable name="reg_no"><xsl:value-of select="reg_no"/></xsl:variable>
				<xsl:variable name="reg_no1"><xsl:value-of select="reg_no1"/></xsl:variable>
				<xsl:variable name="reg_no2"><xsl:value-of select="reg_no2"/></xsl:variable>
				<xsl:variable name="reg_date"><xsl:value-of select="reg_date"/></xsl:variable>
					<table id="activityTable" border="0" cellSpacing="1" cellPadding="0" style="margin-bottom:25px;">	
						<!-- ************* row for fin Entity   ********************* -->
						<h4 class="gstLabel">GST Registration Information</h4>
						
						<tr hidden="true">
							<td class="td_rightAlign" nowrap="true">
								<strong>Fin Entity :</strong>
							</td>
							<td class="td_leftAlign" colspan = "3" nowrap="true">
								<div style="width: 100%;">	
									<div style="width: 30%;float: left;">
									   <input type="text" class="input_editable" value="{$fin_entity}" name="Detail1.{normalize-space($dbID)}.fin_entity" id="Detail1.{normalize-space($dbID)}.fin_entity" onchange="callItemChange('fin_entity');" popupFldName="FIN_ENTITY" onkeyup="getAutoPopupData(this);" tabIndex="50" onfocus="displayPopUpIcon('popUpIcon4');" />
										<!-- <input type="text" class="input_editable" value="{$fin_entity}" name="Detail1.{normalize-space($dbID)}.fin_entity" id="Detail1.{normalize-space($dbID)}.fin_entity" onchange="callItemChange('fin_entity');" tabIndex="50" popupFldName="FIN_ENTITY" onkeyup="getAutoPopupData(this);" onfocus="displayPopUpIcon('popUpIcon4');" /> -->
										<a href="javascript:getListOfValues('FIN_ENTITY','Detail1.{normalize-space($dbID)}.fin_entity','{$site_code}');" id="popUpIcon4"  tabIndex="-1"><img src="/ibase/webitm/images/pophelp.png" /></a>
									</div>
									
									<div style="float: left;width: 65%;padding-left:2px" >
										 <input type="text" name="Detail1.{normalize-space($dbID)}.finent_descr" id="Detail1.{normalize-space($dbID)}.finent_descr" 
										 value="{$finent_descr}" class="editDisplayClass" maxlength="0" ISCHANGED="false" readOnly = "1" style="width: 100%" />
									</div>	
								</div>
							</td>	
							<td></td>
						</tr>
						
						<!-- ************* row for Site Code  ********************* -->
						<tr hidden="true">
						<td class="td_rightAlign" nowrap="true">
							<strong>Site Code :</strong>
						</td>
						<td class="td_leftAlign" colspan = "3" nowrap="true">
							<div style="width: 100%;">
								<div style="width: 20%;float: left;">
									<input type="text" class="input_editable" value="{$site_code}" name="Detail1.{normalize-space($dbID)}.site_code" id="Detail1.{normalize-space($dbID)}.site_code" onblur="callItemChange('site_code');" tabIndex="10" popupFldName="SITE_CODE" 
									onkeyup="getAutoPopupData(this);" onfocus="displayPopUpIcon('popUpIcon5');" style="width: 100%;"/>
								</div>
								<div style="width:2%;float: left;padding-left:2px">
									<a href="javascript:getListOfValues('SITE_CODE','Detail1.{normalize-space($dbID)}.site_code','{$site_code}');" id="popUpIcon5" tabIndex="-1"><img src="/ibase/webitm/images/pophelp.png" />
									</a>
								</div>
								<div style="float: left;width: 70%;padding-left:3px" >
									<input type="text" name="Detail1.{normalize-space($dbID)}.site_descr" id="Detail1.{normalize-space($dbID)}.site_descr" 
										 value="{$site_descr}" class="editDisplayClass" maxlength="0" ISCHANGED="false" readOnly = "1" style="width: 100%" />
								</div>	
							</div>
						</td>
						<td>
						</td>	
					</tr>
			
						<!-- ************* row for GSTN Number   ********************* -->
						<tr>	
			           		<td class="td_rightAlign" nowrap="true">
								<strong>GSTN Number :</strong>
							</td>
							<td class="td_leftAlign" colspan = "1">
								<input type="text" value="{$reg_no}" name="Detail1.{normalize-space($dbID)}.reg_no" id="Detail1.{normalize-space($dbID)}.reg_no" tabIndex="20" 
								 class="input_editable" maxlength="100" style="width:100%"/>
							</td>	
						</tr>
						
						<!-- ************* row for GST Username   ********************* -->
						<tr>	
				           <td class="td_rightAlign" nowrap="true">
								<strong>GST Username :</strong>
							</td>
							<td class="td_leftAlign" colspan = "2">
								<input type="text" value="{$reg_no1}" name="Detail1.{normalize-space($dbID)}.reg_no1" id="Detail1.{normalize-space($dbID)}.reg_no1" tabIndex="30" 
								 class="input_editable" maxlength="100" style="width:100%"/>
							</td>	
						</tr>
						
						<!-- ************* row for Gross Turnover   ********************* -->
						<tr>	
				           <td class="td_rightAlign" nowrap="true">
								<strong>Previous Financial Year<br/> Gross Turnover :</strong>
							</td>
							<td class="td_leftAlign" colspan = "2">
								<input type="text" value="{$reg_no2}" name="Detail1.{normalize-space($dbID)}.reg_no2" id="Detail1.{normalize-space($dbID)}.reg_no2" tabIndex="40" 
								 class="input_editable" maxlength="100" style="width:100%"/>
							</td>	
						</tr>
						
						<!-- ************* row for Registration Date  ********************* -->
						<tr>
							 <td class="td_rightAlign" nowrap="true">
								<strong>Registration Date :</strong>		
							</td>
							<td class="td_leftAlign" colspan = "2">
							<input type="text" class="input_editable" value="{$reg_date}" name="Detail1.{normalize-space($dbID)}.reg_date" id="reg_date" tabIndex="50"  onfocus="displayPopUpIcon('popUpIcon6');" />
							<a href="javascript:setDate('reg_date');" id="popUpIcon6"><img src="/ibase/webitm/images/calender.png" /></a>
							</td>
						</tr>
					</table>
		</xsl:for-each>
		</div>
		<div id="btnDiv">
		       <!-- <input type="hidden" value="1" name="FORM_NO" ID="FORM_NO" />
			<input type="hidden" value="gst_regno" name="OBJ_NAME" />
			<input type="hidden" value="finish" name="action" id="action" />
		        <input type="submit" style="margin-left:2px;" value="Finish" class="button" title="finish" id="finish" onclick="" />-->
		        
			<input  type="hidden" value="1" name="FORM_NO" ID="FORM_NO" />
			<input  type="hidden"  value="gst_regno" name="OBJ_NAME" id="OBJ_NAME"/>
			<input  type="hidden"  value="next" name="action" id="action" />
			
			<input type="submit" style="cursor:hand" value="Next" class="button" title='Next' id="next"  onclick="displayWaitImg();" />

		</div>
		
		<div id="buttonreplacement">
		<img src="/ibase/images/preload.gif" alt="Please wait work in progress" ></img>
		<span>Please wait......</span>
		<div id="overlay"></div>
	</div>
	</div>
</form>
</body>
</html>
</xsl:template>
</xsl:stylesheet>
