package ibase.dashboard.sfa.ejb;
import ibase.dashboard.Report.Utility.DashboardUtility;
import ibase.system.config.ConnDriver;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

import javax.ejb.Stateless;

import org.json.simple.JSONObject;
/**
 * Session Bean implementation class SalesPersonSales
 */
@Stateless
public class ProductAssessment extends ValidatorEJB implements ProductAssessmentLocal, ProductAssessmentRemote
{
	public ProductAssessment() {
        // TODO Auto-generated constructor stub
    }
	 GenericUtility genericUtility = GenericUtility.getInstance();
    @SuppressWarnings("unchecked")
	@Override
    public JSONObject getProductAssessmentEventServlet(String loginId, String dataSourceName,String zone,String region,String product,String team,String event) throws RemoteException, ITMException
    {
		JSONObject rawDataEmployeeProdSurveylJson = new JSONObject();
		JSONObject rowData = null;
		String sql = "";
		String zoneCodeFilter="";
		String regionCodeFilter="";
		String teamCodeFilter="";
		String productFilter="";
		String whereClause  = "";
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		Connection conn = null;
		ConnDriver connDriver = new ConnDriver();
		DashboardUtility dashbordUtil = new DashboardUtility();
		try
		{
			
			conn = connDriver.getConnectDB(dataSourceName);
			connDriver = null;	
			if ((product != null) && (product.trim().length() > 0))
			{
				product = dashbordUtil.getCommaSeparated(product);
				productFilter = " WHERE APPR.ENTITY_CODE IN (" + product + ") ";
			}
			if((zone.trim().length() > 0) || (region.trim().length() > 0) || (team.trim().length() > 0))
			{
				whereClause = " Where ";
			}
			if ((zone != null) && (zone.trim().length() > 0))
			{
				if((region.length()>0) || (team.length()>0))
				{
					System.out.println("zone" + zone);
					zone = dashbordUtil.getCommaSeparated(zone);
					zoneCodeFilter = " e.ZONECODE IN (" + zone + ") AND ";
				}
				else
				{
					zone = dashbordUtil.getCommaSeparated(zone);
					zoneCodeFilter = " e.ZONECODE IN (" + zone + ")";
				}
			}
			
			
			if ((region != null) && (region.trim().length() > 0))
			{
				if(team.length()>0) 
				{
					System.out.println("region" + region);
					region = dashbordUtil.getCommaSeparated(region);
					regionCodeFilter = "  r.Name IN (" + region + ") AND ";
				}
				else
				{
					region = dashbordUtil.getCommaSeparated(region);
					regionCodeFilter = "  r.Name IN (" + region + ")";
				}
			}
				
			if ((team != null) && (team.trim().length() > 0))
			{
				System.out.println("team" + team);
				team = dashbordUtil.getCommaSeparated(team);
				teamCodeFilter = "  e.teamcode IN (" + team + ") ";
			}
			
			
			/*working SQL on dated 04-11-2015*/
			sql=    "select e.ZONECODE ZONE, r.Name as REGION, e.teamcode TEAM, " +
					"(e.FIRSTNAME +' '+ e.LASTNAME) NAME ,COUNT(SUR.MGR) NOS, " +
					"SUM(SUR.RESULT) TOTAL from hr.dbo.employee e " +
					"INNER JOIN hr.dbo.REGION r on e.regionid = r.id " +
					"INNER JOIN (SELECT APP.ENTITY_CODE EMP_CODE, " +
					"SRE.EMP_CODE MGR, sum(CAST(SRD.result AS INT)) RESULT, " +
					"APPR.ENTITY_CODE PRD_CODE, APPR.ENTITY_DESCR PRD_DESC " +
					"FROM hr.dbo.survey_result_EMP SRE INNER JOIN hr.dbo.survey_result SR ON SRE.TRAN_ID = SR.TRAN_ID__FORM " +
					"INNER JOIN hr.dbo.survey_result_det SRD ON SR.TRAN_ID = SRD.TRAN_ID " +
					"INNER JOIN (SELECT * FROM hr.dbo.survey_result_appl WHERE APPL_ENTITY = 'E') APP ON SRD.TRAN_ID = APP.TRAN_ID " +
					"INNER JOIN (SELECT * FROM hr.dbo.survey_result_appl WHERE APPL_ENTITY = 'I') APPR ON SRD.TRAN_ID = APPR.TRAN_ID " +
					" "+productFilter+" GROUP BY APP.ENTITY_CODE, " +
					"SRE.EMP_CODE, APPR.ENTITY_CODE, " +
					"APPR.ENTITY_DESCR) SUR ON e.code = SUR.EMP_CODE " +
					" "+whereClause+"  "+zoneCodeFilter+regionCodeFilter+ teamCodeFilter+" " +
					"GROUP BY e.ZONECODE, " +
					"r.Name, e.teamcode, (e.FIRSTNAME +' '+ e.LASTNAME)";
            
			
		/* sql for Testing on dated 06-11-2015*/
			
			/*sql_base =   "select e.ZONECODE ZONE, r.Name as REGION, e.teamcode TEAM, " +
					"(e.FIRSTNAME +' '+ e.LASTNAME) NAME ,COUNT(SUR.MGR) NOS, " +
					"SUM(SUR.RESULT) TOTAL from hr.hr.dbo.employee e INNER JOIN HR.hr.hr.dbo.REGION r on e.regionid = r.id INNER JOIN (SELECT APP.ENTITY_CODE EMP_CODE, " +
					"SRE.EMP_CODE MGR, sum(CAST(SRD.result AS INT)) RESULT, " +
					"APPR.ENTITY_CODE PRD_CODE, " +
					"APPR.ENTITY_DESCR PRD_DESC FROM hr.hr.dbo.survey_result_EMP SRE INNER JOIN hr.hr.dbo.survey_result SR ON SRE.TRAN_ID = SR.TRAN_ID__FORM INNER JOIN hr.hr.dbo.survey_result_det SRD ON SR.TRAN_ID = SRD.TRAN_ID INNER JOIN (SELECT * FROM hr.hr.dbo.survey_result_appl WHERE APPL_ENTITY = 'E') APP ON SRD.TRAN_ID = APP.TRAN_ID INNER JOIN (SELECT * FROM hr.hr.dbo.survey_result_appl " +
					//"WHERE APPL_ENTITY = 'I' " +
					")APPR ON SRD.TRAN_ID = APPR.TRAN_ID " +
					//"and SRD.TRAN_ID IN ('ES00002043','ES00002044','ES00002045') " +
					"GROUP BY APP.ENTITY_CODE, SRE.EMP_CODE, APPR.ENTITY_CODE, APPR.ENTITY_DESCR) SUR ON e.code = SUR.EMP_CODE GROUP BY e.ZONECODE, r.Name, e.teamcode, (e.FIRSTNAME +' '+ e.LASTNAME)";
			*/
			
			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			int count = 0;	
			
			while (rs.next())
			{
				rowData = new JSONObject();
				rowData.put("zone",checkNull (rs.getString("ZONE")));						
				rowData.put("region", checkNull(rs.getString("REGION")));
				rowData.put("team",checkNull( rs.getString("TEAM")));
				rowData.put("name", checkNull(rs.getString("NAME")));
				rowData.put("nos",checkNull( rs.getString("NOS")));
				rowData.put("total",checkNull( rs.getString("TOTAL")));	
				rawDataEmployeeProdSurveylJson.put(count, rowData);
				count++;
			}
		}
		catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
					rs.close();
					rs = null;
					if (pstmt != null)
					pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in :ProductAssessment getProductAssessmentEventServlet :" + d.getMessage());
				throw new ITMException(d);
			}
		}
		
		return rawDataEmployeeProdSurveylJson;
		
	}
    
    @SuppressWarnings("unchecked")
    @Override
    public JSONObject getProductAssessmentProductPieServlet(String dataSourceName,String personName) throws RemoteException, ITMException
    {
    	JSONObject rawDataEmployeeProductlJson = new JSONObject();
		JSONObject rowData = null;
		String sql = "";
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		Connection conn = null;
		ConnDriver connDriver = new ConnDriver();
		double percntVal = 0.0;
		try
		{
			System.out.println(" Inside ProductAssessment for getProductAssessmentProductPieServlet Data Soruc Name ="+dataSourceName+ "==== personName :"+personName);
			conn = connDriver.getConnectDB(dataSourceName);
			connDriver = null;
		
			/*sql_base = "select MGR, NAME, SURVEY, SUM(RESULT) RESULT from ( SELECT (e1.FIRSTNAME +' '+ e1.LASTNAME) as MGR, " +
					"(e.FIRSTNAME +' '+ e.LASTNAME) as NAME, sm.descr as SURVEY, CAST(SRD.result AS INT) RESULT " +
					"FROM hr.hr.dbo.survey_result_EMP SRE INNER JOIN hr.hr.dbo.survey_result SR ON SRE.TRAN_ID = SR.TRAN_ID__FORM " +
					"INNER JOIN hr.hr.dbo.survey_result_det SRD ON SR.TRAN_ID = SRD.TRAN_ID " +
					"INNER JOIN (SELECT * FROM hr.hr.dbo.survey_result_appl " +
					"WHERE APPL_ENTITY = 'E') APP ON SRD.TRAN_ID = APP.TRAN_ID " +
					//"INNER JOIN (SELECT * FROM hr.hr.dbo.survey_result_appl " +
					//"WHERE APPL_ENTITY = 'P') APPR ON SRD.TRAN_ID = APPR.TRAN_ID " +
					"INNER JOIN hr.hr.dbo.employee e ON APP.ENTITY_CODE = e.code " +
					"INNER JOIN hr.hr.dbo.survey_master sm ON SRD.SURVEY_CODE = sm.SURVEY_CODE " +
					"LEFT OUTER JOIN hr.hr.dbo.employee e1 ON SRE.EMP_CODE = e1.code) A " +
					"WHERE NAME = 'Prasad  Kadam' " +
					"AND SURVEY IN ('Opening','Detailing','Probing','Listening') " +
					"GROUP BY MGR, NAME, SURVEY";
			*/
			/*wORKING SQL*/
			
			sql =   "SELECT NAME, PRD_NAME, PERC, REPORT,RESULTCNT,TOTAL FROM (SELECT DET_PRD.NAME , DET_PRD.PRD_NAME,RESULT,TOTAL, " +
					"Str((RESULT * 100.0/TOTAL),4,1) AS PERC, 'Marks' AS REPORT,(RESULT) as RESULTCNT " +
					"FROM ( select e.CODE, SUM(SUR.RESULT) TOTAL from hr.dbo.employee e " +
					"INNER JOIN hr.dbo.REGION r on e.regionid = r.id " +
					"INNER JOIN (SELECT APP.ENTITY_CODE EMP_CODE, SRE.EMP_CODE MGR, sum(CAST(SRD.result AS INT)) RESULT, " +
					"APPR.ENTITY_CODE PRD_CODE, APPR.ENTITY_DESCR PRD_DESC FROM hr.dbo.survey_result_EMP SRE " +
					"INNER JOIN hr.dbo.survey_result SR ON SRE.TRAN_ID = SR.TRAN_ID__FORM " +
					"INNER JOIN hr.dbo.survey_result_det SRD ON SR.TRAN_ID = SRD.TRAN_ID " +
					"INNER JOIN (SELECT * FROM hr.dbo.survey_result_appl WHERE APPL_ENTITY = 'E') APP ON SRD.TRAN_ID = APP.TRAN_ID " +
					"INNER JOIN (SELECT * FROM hr.dbo.survey_result_appl " +
					" WHERE APPL_ENTITY = 'I'" +
					") APPR ON SRD.TRAN_ID = APPR.TRAN_ID " +
					"GROUP BY APP.ENTITY_CODE, SRE.EMP_CODE, APPR.ENTITY_CODE, APPR.ENTITY_DESCR) " +
					"SUR ON e.code = SUR.EMP_CODE " +
					"WHERE (e.FIRSTNAME +' '+ e.LASTNAME) =  '"+personName+"' GROUP BY e.CODE ) HDR " +
					"INNER JOIN (SELECT (e.FIRSTNAME +' '+ e.LASTNAME) NAME, APPR.ENTITY_DESCR as PRD_NAME , " +
					"SUM(CAST(SRD.result AS INT)) RESULT , e.code FROM hr.dbo.survey_result_EMP SRE " +
					"INNER JOIN hr.dbo.survey_result SR ON SRE.TRAN_ID = SR.TRAN_ID__FORM " +
					"INNER JOIN hr.dbo.survey_result_det SRD ON SR.TRAN_ID = SRD.TRAN_ID " +
					"INNER JOIN (SELECT * FROM hr.dbo.survey_result_appl WHERE APPL_ENTITY = 'E') " +
					"APP ON SRD.TRAN_ID = APP.TRAN_ID INNER JOIN (SELECT * FROM hr.dbo.survey_result_appl " +
					" WHERE APPL_ENTITY = 'I'" +
					") APPR ON SRD.TRAN_ID = APPR.TRAN_ID " +
					"INNER JOIN hr.dbo.employee e ON APP.ENTITY_CODE = e.code " +
					"INNER JOIN hr.dbo.survey_master sm ON SRD.SURVEY_CODE = sm.SURVEY_CODE " +
					"WHERE (e.FIRSTNAME +' '+ e.LASTNAME) =  '"+personName+"' " +
					"GROUP BY (e.FIRSTNAME +' '+ e.LASTNAME) , APPR.ENTITY_DESCR , e.code) DET_PRD ON HDR.CODE = DET_PRD.CODE " +
					"UNION ALL " +
					"SELECT DET_PRD.NAME , DET_PRD.PRD_NAME,RESULT,TOTAL, Str((100-(RESULT * 100.0/TOTAL)),4,1) PERC, 'Remaining' AS REPORT,(TOTAL - RESULT) as RESULTCNT " +
					"FROM ( select e.CODE, SUM(SUR.RESULT) TOTAL from hr.dbo.employee e INNER JOIN hr.dbo.REGION r on e.regionid = r.id INNER JOIN (SELECT APP.ENTITY_CODE EMP_CODE, " +
					"SRE.EMP_CODE MGR, sum(CAST(SRD.result AS INT)) RESULT, APPR.ENTITY_CODE PRD_CODE, APPR.ENTITY_DESCR PRD_DESC FROM hr.dbo.survey_result_EMP SRE " +
					"INNER JOIN hr.dbo.survey_result SR ON SRE.TRAN_ID = SR.TRAN_ID__FORM " +
					"INNER JOIN hr.dbo.survey_result_det SRD ON SR.TRAN_ID = SRD.TRAN_ID INNER JOIN (SELECT * FROM hr.dbo.survey_result_appl WHERE APPL_ENTITY = 'E') APP ON SRD.TRAN_ID = APP.TRAN_ID " +
					"INNER JOIN (SELECT * FROM hr.dbo.survey_result_appl " +
					"WHERE APPL_ENTITY = 'I'" +
					") APPR ON SRD.TRAN_ID = APPR.TRAN_ID " +					
					"GROUP BY APP.ENTITY_CODE, SRE.EMP_CODE, APPR.ENTITY_CODE, APPR.ENTITY_DESCR) SUR ON e.code = SUR.EMP_CODE " +
					"WHERE (e.FIRSTNAME +' '+ e.LASTNAME) =  '"+personName+"' GROUP BY e.CODE ) HDR INNER JOIN (SELECT (e.FIRSTNAME +' '+ e.LASTNAME) NAME, APPR.ENTITY_DESCR as PRD_NAME , " +
					"SUM(CAST(SRD.result AS INT)) RESULT , e.code FROM hr.dbo.survey_result_EMP SRE INNER JOIN hr.dbo.survey_result SR ON SRE.TRAN_ID = SR.TRAN_ID__FORM " +
					"INNER JOIN hr.dbo.survey_result_det SRD ON SR.TRAN_ID = SRD.TRAN_ID INNER JOIN (SELECT * FROM hr.dbo.survey_result_appl WHERE APPL_ENTITY = 'E') APP ON SRD.TRAN_ID = APP.TRAN_ID " +
					"INNER JOIN (SELECT * FROM hr.dbo.survey_result_appl " +
					"WHERE APPL_ENTITY = 'I'" +
					") APPR ON SRD.TRAN_ID = APPR.TRAN_ID INNER JOIN hr.dbo.employee e ON APP.ENTITY_CODE = e.code " +
					"INNER JOIN hr.dbo.survey_master sm ON SRD.SURVEY_CODE = sm.SURVEY_CODE " +
					"WHERE (e.FIRSTNAME +' '+ e.LASTNAME) =  '"+personName+"' GROUP BY (e.FIRSTNAME +' '+ e.LASTNAME) , APPR.ENTITY_DESCR , e.code) DET_PRD ON HDR.CODE = DET_PRD.CODE) X " +
					"ORDER BY NAME, PRD_NAME";
			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			int count = 0;	
			int rsltCnt=0,total=0;
			while (rs.next())
			{
				rowData = new JSONObject();
				rowData.put("prd_name", checkNull(rs.getString("PRD_NAME")));
				rowData.put("name", checkNull(rs.getString("NAME")));
				rowData.put("perc", checkNull(rs.getString("PERC")));	
				rowData.put("report", checkNull( rs.getString("RESULTCNT"))+" "+ checkNull( rs.getString("REPORT"))+" out of "+checkNull( rs.getString("TOTAL")));
				rowData.put("resultcnt", checkNull(rs.getString("RESULTCNT")));
				rowData.put("tooltext",checkNull( rs.getString("TOTAL")));
				 
				rawDataEmployeeProductlJson.put(count, rowData);
				count++;
			}
		}
		catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
					rs.close();
					rs = null;
					if (pstmt != null)
					pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in :getProductAssessmentProductPieServlet:" + d.getMessage());
				throw new ITMException(d);
			}
		}
		System.out.println("ProductAssessment ppie rawDataEmployeeProductlJson String======>>"+rawDataEmployeeProductlJson.toString());
	    return rawDataEmployeeProductlJson;
    }
    
    @SuppressWarnings("unchecked")
    @Override
    public JSONObject getProductAssessmentProductServlet(String dataSourceName,String personName) throws RemoteException, ITMException
    {
    	JSONObject rawDataEmployeeProductlJson = new JSONObject();
		JSONObject rowData = null;
		String sql = "";
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		Connection conn = null;
		ConnDriver connDriver = new ConnDriver();
		double percntVal = 0.0;
		try
		{
			System.out.println(" Inside ProductAssessment for getProductAssessmentProductServlet Data Soruc Name ="+dataSourceName+ "==== personName :"+personName);
			conn = connDriver.getConnectDB(dataSourceName);
			connDriver = null;
		
			/*sql_base = "select MGR, NAME, SURVEY, SUM(RESULT) RESULT from ( SELECT (e1.FIRSTNAME +' '+ e1.LASTNAME) as MGR, " +
					"(e.FIRSTNAME +' '+ e.LASTNAME) as NAME, sm.descr as SURVEY, CAST(SRD.result AS INT) RESULT " +
					"FROM hr.hr.dbo.survey_result_EMP SRE INNER JOIN hr.hr.dbo.survey_result SR ON SRE.TRAN_ID = SR.TRAN_ID__FORM " +
					"INNER JOIN hr.hr.dbo.survey_result_det SRD ON SR.TRAN_ID = SRD.TRAN_ID " +
					"INNER JOIN (SELECT * FROM hr.hr.dbo.survey_result_appl " +
					"WHERE APPL_ENTITY = 'E') APP ON SRD.TRAN_ID = APP.TRAN_ID " +
					//"INNER JOIN (SELECT * FROM hr.hr.dbo.survey_result_appl " +
					//"WHERE APPL_ENTITY = 'P') APPR ON SRD.TRAN_ID = APPR.TRAN_ID " +
					"INNER JOIN hr.hr.dbo.employee e ON APP.ENTITY_CODE = e.code " +
					"INNER JOIN hr.hr.dbo.survey_master sm ON SRD.SURVEY_CODE = sm.SURVEY_CODE " +
					"LEFT OUTER JOIN hr.hr.dbo.employee e1 ON SRE.EMP_CODE = e1.code) A " +
					"WHERE NAME = 'Prasad  Kadam' " +
					"AND SURVEY IN ('Opening','Detailing','Probing','Listening') " +
					"GROUP BY MGR, NAME, SURVEY";
			*/
			/*wORKING SQL*/
			
			sql =   "SELECT NAME, PRD_NAME, PERC, REPORT,RESULTCNT,TOTAL FROM (SELECT DET_PRD.NAME , DET_PRD.PRD_NAME,RESULT,TOTAL, " +
					"Str((RESULT * 100.0/TOTAL),4,1) AS PERC, 'Marks' AS REPORT,(RESULT) as RESULTCNT " +
					"FROM ( select e.CODE, SUM(SUR.RESULT) TOTAL from hr.dbo.employee e " +
					"INNER JOIN hr.dbo.REGION r on e.regionid = r.id " +
					"INNER JOIN (SELECT APP.ENTITY_CODE EMP_CODE, SRE.EMP_CODE MGR, sum(CAST(SRD.result AS INT)) RESULT, " +
					"APPR.ENTITY_CODE PRD_CODE, APPR.ENTITY_DESCR PRD_DESC FROM hr.dbo.survey_result_EMP SRE " +
					"INNER JOIN hr.dbo.survey_result SR ON SRE.TRAN_ID = SR.TRAN_ID__FORM " +
					"INNER JOIN hr.dbo.survey_result_det SRD ON SR.TRAN_ID = SRD.TRAN_ID " +
					"INNER JOIN (SELECT * FROM hr.dbo.survey_result_appl WHERE APPL_ENTITY = 'E') APP ON SRD.TRAN_ID = APP.TRAN_ID " +
					"INNER JOIN (SELECT * FROM hr.dbo.survey_result_appl " +
					" WHERE APPL_ENTITY = 'I'" +
					") APPR ON SRD.TRAN_ID = APPR.TRAN_ID " +
					"GROUP BY APP.ENTITY_CODE, SRE.EMP_CODE, APPR.ENTITY_CODE, APPR.ENTITY_DESCR) " +
					"SUR ON e.code = SUR.EMP_CODE " +
					"WHERE (e.FIRSTNAME +' '+ e.LASTNAME) =  '"+personName+"' GROUP BY e.CODE ) HDR " +
					"INNER JOIN (SELECT (e.FIRSTNAME +' '+ e.LASTNAME) NAME, APPR.ENTITY_DESCR as PRD_NAME , " +
					"SUM(CAST(SRD.result AS INT)) RESULT , e.code FROM hr.dbo.survey_result_EMP SRE " +
					"INNER JOIN hr.dbo.survey_result SR ON SRE.TRAN_ID = SR.TRAN_ID__FORM " +
					"INNER JOIN hr.dbo.survey_result_det SRD ON SR.TRAN_ID = SRD.TRAN_ID " +
					"INNER JOIN (SELECT * FROM hr.dbo.survey_result_appl WHERE APPL_ENTITY = 'E') " +
					"APP ON SRD.TRAN_ID = APP.TRAN_ID INNER JOIN (SELECT * FROM hr.dbo.survey_result_appl " +
					" WHERE APPL_ENTITY = 'I'" +
					") APPR ON SRD.TRAN_ID = APPR.TRAN_ID " +
					"INNER JOIN hr.dbo.employee e ON APP.ENTITY_CODE = e.code " +
					"INNER JOIN hr.dbo.survey_master sm ON SRD.SURVEY_CODE = sm.SURVEY_CODE " +
					"WHERE (e.FIRSTNAME +' '+ e.LASTNAME) =  '"+personName+"' " +
					"GROUP BY (e.FIRSTNAME +' '+ e.LASTNAME) , APPR.ENTITY_DESCR , e.code) DET_PRD ON HDR.CODE = DET_PRD.CODE " +
					"UNION ALL " +
					"SELECT DET_PRD.NAME , DET_PRD.PRD_NAME,RESULT,TOTAL, Str((100-(RESULT * 100.0/TOTAL)),4,1) PERC, 'Remaining' AS REPORT,(TOTAL - RESULT) as RESULTCNT " +
					"FROM ( select e.CODE, SUM(SUR.RESULT) TOTAL from hr.dbo.employee e INNER JOIN hr.dbo.REGION r on e.regionid = r.id INNER JOIN (SELECT APP.ENTITY_CODE EMP_CODE, " +
					"SRE.EMP_CODE MGR, sum(CAST(SRD.result AS INT)) RESULT, APPR.ENTITY_CODE PRD_CODE, APPR.ENTITY_DESCR PRD_DESC FROM hr.dbo.survey_result_EMP SRE " +
					"INNER JOIN hr.dbo.survey_result SR ON SRE.TRAN_ID = SR.TRAN_ID__FORM " +
					"INNER JOIN hr.dbo.survey_result_det SRD ON SR.TRAN_ID = SRD.TRAN_ID INNER JOIN (SELECT * FROM hr.dbo.survey_result_appl WHERE APPL_ENTITY = 'E') APP ON SRD.TRAN_ID = APP.TRAN_ID " +
					"INNER JOIN (SELECT * FROM hr.dbo.survey_result_appl " +
					"WHERE APPL_ENTITY = 'I'" +
					") APPR ON SRD.TRAN_ID = APPR.TRAN_ID " +					
					"GROUP BY APP.ENTITY_CODE, SRE.EMP_CODE, APPR.ENTITY_CODE, APPR.ENTITY_DESCR) SUR ON e.code = SUR.EMP_CODE " +
					"WHERE (e.FIRSTNAME +' '+ e.LASTNAME) =  '"+personName+"' GROUP BY e.CODE ) HDR INNER JOIN (SELECT (e.FIRSTNAME +' '+ e.LASTNAME) NAME, APPR.ENTITY_DESCR as PRD_NAME , " +
					"SUM(CAST(SRD.result AS INT)) RESULT , e.code FROM hr.dbo.survey_result_EMP SRE INNER JOIN hr.dbo.survey_result SR ON SRE.TRAN_ID = SR.TRAN_ID__FORM " +
					"INNER JOIN hr.dbo.survey_result_det SRD ON SR.TRAN_ID = SRD.TRAN_ID INNER JOIN (SELECT * FROM hr.dbo.survey_result_appl WHERE APPL_ENTITY = 'E') APP ON SRD.TRAN_ID = APP.TRAN_ID " +
					"INNER JOIN (SELECT * FROM hr.dbo.survey_result_appl " +
					"WHERE APPL_ENTITY = 'I'" +
					") APPR ON SRD.TRAN_ID = APPR.TRAN_ID INNER JOIN hr.dbo.employee e ON APP.ENTITY_CODE = e.code " +
					"INNER JOIN hr.dbo.survey_master sm ON SRD.SURVEY_CODE = sm.SURVEY_CODE " +
					"WHERE (e.FIRSTNAME +' '+ e.LASTNAME) =  '"+personName+"' GROUP BY (e.FIRSTNAME +' '+ e.LASTNAME) , APPR.ENTITY_DESCR , e.code) DET_PRD ON HDR.CODE = DET_PRD.CODE) X " +
					" where upper(report)='MARKS' "+
					"ORDER BY NAME, PRD_NAME";
			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			int count = 0;	
			double rsltCnt=0,total=0;
			while (rs.next())
			{
				rowData = new JSONObject();
		/*		rowData.put("prd_name", checkNull(rs.getString("PRD_NAME")));
				rowData.put("name", checkNull(rs.getString("NAME")));
				rowData.put("perc", checkNull(rs.getString("PERC")));	
				rowData.put("report", checkNull( rs.getString("RESULTCNT"))+" "+ checkNull( rs.getString("REPORT"))+" out of "+checkNull( rs.getString("TOTAL")));
				rowData.put("resultcnt", checkNull(rs.getString("RESULTCNT")));
				rowData.put("tooltext",checkNull( rs.getString("TOTAL")));*/
				 rsltCnt= Double.parseDouble(checkNull( rs.getString("RESULTCNT")));
				 total= Double.parseDouble(checkNull( rs.getString("TOTAL")));
				 System.out.println("rsltCnt:"+rsltCnt);
				 System.out.println("total:"+total);
				 percntVal =( (rsltCnt/total) * 100) ; 
				 System.out.println("percntVal:"+percntVal);
				 rowData.put("descr", "Marks");
				    rowData.put("percentage", Math.round(percntVal));
				    rowData.put("spanvalue", Math.round(percntVal)+"%");
				    rowData.put("person_name", checkNull(rs.getString("NAME")));
				    rowData.put("prd_name", checkNull(rs.getString("PRD_NAME")));
				    rowData.put("ontimeval", checkNull( rs.getString("RESULTCNT")));
				    rowData.put("totalval", checkNull( rs.getString("TOTAL")));
				    rowData.put("tbldisplay", "style='display: visible'");
				    rowData.put("circledisplay", "c100");
				rawDataEmployeeProductlJson.put(count, rowData);
				count++;
			}
		}
		catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
					rs.close();
					rs = null;
					if (pstmt != null)
					pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in :getProductAssessmentProductServlet:" + d.getMessage());
				throw new ITMException(d);
			}
		}
		System.out.println("ProductAssessment rawDataEmployeeProductlJson String======>>"+rawDataEmployeeProductlJson.toString());
	    return rawDataEmployeeProductlJson;
    }
    @SuppressWarnings("unchecked")
    @Override
    public JSONObject getProductAssessmentProductRatingServlet(String dataSourceName,String personName,String productName) throws RemoteException, ITMException
    {
    	JSONObject rawDataEmployeeProductlRatingJson = new JSONObject();
		JSONObject rowData = null;
		String sql = "";
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		Connection conn = null;
		ConnDriver connDriver = new ConnDriver();
		try
		{
			System.out.println(" Inside ProductAssessment for getProductAssessmentProductRatingServlet Data Soruc Name ="+dataSourceName+" personName=:"+ personName + "=== productName :"+ productName);
			conn = connDriver.getConnectDB(dataSourceName);
			connDriver = null;
			
			
			/*sql=  "select MGR, SUM(RESULT) RESULT from ( SELECT (e1.FIRSTNAME +' '+ e1.LASTNAME) as MGR, " +
					"(e.FIRSTNAME +' '+ e.LASTNAME) as NAME, sm.descr as SURVEY, CAST(SRD.result AS INT) RESULT " +
					"FROM hr.hr.dbo.survey_result_EMP SRE INNER JOIN hr.hr.dbo.survey_result SR ON SRE.TRAN_ID = SR.TRAN_ID__FORM " +
					"INNER JOIN hr.hr.dbo.survey_result_det SRD ON SR.TRAN_ID = SRD.TRAN_ID " +
					"INNER JOIN (SELECT * FROM hr.hr.dbo.survey_result_appl " +
					"WHERE APPL_ENTITY = 'E') APP ON SRD.TRAN_ID = APP.TRAN_ID " +
					"INNER JOIN (SELECT * FROM hr.hr.dbo.survey_result_appl " +
					"WHERE APPL_ENTITY = 'I') APPR ON SRD.TRAN_ID = APPR.TRAN_ID " +
					"INNER JOIN hr.hr.dbo.employee e ON APP.ENTITY_CODE = e.code " +
					"INNER JOIN hr.hr.dbo.survey_master sm ON SRD.SURVEY_CODE = sm.SURVEY_CODE " +
					"LEFT OUTER JOIN hr.hr.dbo.employee e1 ON SRE.EMP_CODE = e1.code) A " +
					"WHERE NAME = 'Prasad  Kadam' " +
					"AND SURVEY IN ('Opening','Detailing','Probing','Listening') " +
					"GROUP BY MGR ";*/
			
			/*wORKING SQL*/
			sql =   "SELECT sm.DESCR as SURVEY , SUM(CAST(SRD.result AS INT)) RESULT FROM hr.dbo.survey_result_EMP SRE " +
					"INNER JOIN hr.dbo.survey_result SR ON SRE.TRAN_ID = SR.TRAN_ID__FORM " +
					"INNER JOIN hr.dbo.survey_result_det SRD ON SR.TRAN_ID = SRD.TRAN_ID " +
					"INNER JOIN (SELECT * FROM hr.dbo.survey_result_appl " +
					"WHERE APPL_ENTITY = 'E') APP ON SRD.TRAN_ID = APP.TRAN_ID " +
					"INNER JOIN (SELECT * FROM hr.dbo.survey_result_appl " +
					"WHERE APPL_ENTITY = 'I') APPR ON SRD.TRAN_ID = APPR.TRAN_ID " +
					"INNER JOIN hr.dbo.employee e ON APP.ENTITY_CODE = e.code " +
					"INNER JOIN hr.dbo.survey_master sm ON SRD.SURVEY_CODE = sm.SURVEY_CODE " +
					"WHERE (e.FIRSTNAME +' '+ e.LASTNAME) = '"+personName+"' and APPR.ENTITY_DESCR = '"+productName+"' " +
					"GROUP BY sm.DESCR";
			
			
			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			int count = 0;		
			while (rs.next())
			{
				rowData = new JSONObject();
				rowData.put("survey", checkNull(rs.getString("SURVEY")));
				rowData.put("result", checkNull(rs.getString("RESULT")));
				rawDataEmployeeProductlRatingJson.put(count, rowData);
				count++;
			}
		}
		catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
					rs.close();
					rs = null;
					if (pstmt != null)
					pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in :getProductAssessmentProductRatingServlet:" + d.getMessage());
				throw new ITMException(d);
			}
		}
		System.out.println("ProductAssessment rawDataEmployeeProductlRatingJson String======>>"+rawDataEmployeeProductlRatingJson.toString());
	    return rawDataEmployeeProductlRatingJson;
    }
    private String checkNull(String str)
   	{
   		if(str == null)
   		{
   			return "";
   		}
   		else
   		{
   			return str ;
   		}

   	}
	
}
