package ibase.webitm.ejb.fin;


import ibase.system.config.ConnDriver;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.ejb.fin.FinCommon;
import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

import javax.ejb.Stateless; // added for ejb3

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Stateless
public class AssetSales extends ValidatorEJB implements AssetSalesLocal,AssetSalesRemote
{
	GenericUtility genericUtility = GenericUtility.getInstance(); 
    FinCommon finCommon = new FinCommon();
	public String wfValData(String xmlString, String xmlString1, String xmlString2,String objContext, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		System.out.println("------------@ wfvalData method called-----------------");
		System.out.println("Xml String : ["+xmlString+"]");
		String errString = null;
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		try
		{
			dom = parseString(xmlString);
			dom1 = parseString(xmlString1);
			dom2 = parseString(xmlString2);
			errString = wfValData(dom,dom1,dom2,objContext,editFlag,xtraParams);
			
		}
		catch(Exception e)
		{
			System.out.println("Exception : AssetSales.java : wfValData(String xmlString) : ==>\n"+e.getMessage());
			throw new ITMException(e);
		}
		
		return errString;
	}

	public String wfValData(Document dom, Document dom1, Document dom2,String objContext, String editFlag, String xtraParams) throws RemoteException,ITMException
	{

		NodeList parentNodeList = null;
		NodeList childNodeList = null;
		Node parentNode = null;
		Node childNode = null;
		int ctr=0;
		String childNodeName = null;
		String errString = "";
		Connection conn = null;
		PreparedStatement pstmt = null ;
		ResultSet rs = null;
		String sql = "";
		String userId="",siteCode = "",errCode="",itemser="",pricelist="",reasCode="",remarks="",amtOld="",cctrCodeInv="",cctrCodeInvrev="";
		String tranId = "",keyFlag="",tranDate = "",effDate="",itemCode="",locCode="",lotNo="",lotSl="",quantity="",acctCodeInv="",acctCodeInvrev="";
		double conquan,getquan = 0;
		int cnt=0;
		int currentFormNo=0;
		int childNodeListLength;
		String oRate="",tranType="",assetCode="",custCode="",currCode="",taxClass="",taxchat="",taxChap="",acctCdAr="",acctCdMd="",cctrCdAr="",cctrCdMd="",taxEnv="";
		String acctCdPl="",acctCdLo="",cctrCdPl="",cctrCdLo="";
		double rate =0,saleAmt=0,taxAmt=0;
		
		String oldRate="",AmtRate="",oldAmtRate="";
		double conoldate= 0.0,highval = 0.0,conAmtdate=0.0,conolAmtdate=0.0;
		
		ConnDriver connDriver = new ConnDriver();
		
		try
		{
			conn = connDriver.getConnectDB("DriverITM");
			connDriver = null;
			userId = getValueFromXTRA_PARAMS(xtraParams,"loginCode");
			System.out.println("user ID form XtraParam : "+userId);
			if(objContext != null && objContext.trim().length()>0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			switch(currentFormNo)
			{
			case 1 :
				parentNodeList = dom.getElementsByTagName("Detail1");
				parentNode = parentNodeList.item(0);
				childNodeList = parentNode.getChildNodes();
				childNodeListLength = childNodeList.getLength();
				
				for(ctr = 0; ctr < childNodeListLength; ctr++)
				{
					childNode = childNodeList.item(ctr);
					childNodeName = childNode.getNodeName();
					
					if(childNodeName.equalsIgnoreCase("tran_id"))
					{
						tranId = genericUtility.getColumnValue("tran_id",dom);
						
						sql = "select key_flag from transetup where tran_window = ?";
						pstmt=conn.prepareStatement(sql);
						pstmt.setString(1,"w_asset_sales");
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							keyFlag = rs.getString(1) == null ? "":rs.getString(1);
						}
						pstmt.close();
						rs.close();
						pstmt = null;
						rs = null;
						
						
						if(keyFlag.equalsIgnoreCase("M"))
						{
							if (tranId == null || tranId.trim().length() == 0)
							{
								errCode = "STKVALTRNU";
								errString = getErrorString("tran_id",errCode,userId);
								break;
							}
							else
							{

								sql = "select count(1) from asset_sales where tran_id = ?";
								pstmt=conn.prepareStatement(sql);
								pstmt.setString(1,tranId);
								rs = pstmt.executeQuery();
								if(rs.next())
								{
									cnt = rs.getInt(1);
								}
								pstmt.close();
								rs.close();
								pstmt = null;
								rs = null;
								if(cnt > 0)
								{
									errCode = "STKVALTRNE";
									errString = getErrorString("tran_id",errCode,userId);
									break;
								}
							
							}
						}
					}
					
					else if(childNodeName.equalsIgnoreCase("tran_date"))
					{

						tranDate = genericUtility.getColumnValue("tran_date",dom);
						if (tranDate == null || tranDate.trim().length() == 0 )
						{
							errCode = "";
							errString = getErrorString("tran_date",errCode,userId);
							break;
						}
					
					}
					else if(childNodeName.equalsIgnoreCase("tran_type"))
					{

						tranType = genericUtility.getColumnValue("tran_type",dom);
						if (tranType == null || tranType.trim().length() == 0 )
						{
							errCode = "VTTRANTYPE";
							errString = getErrorString("tran_type",errCode,userId);
							break;
						}
					
					}
				
					else if(childNodeName.equalsIgnoreCase("cust_code"))
					{

						custCode = genericUtility.getColumnValue("cust_code",dom);
						if (custCode == null || custCode.trim().length() == 0 )
						{
							System.out.println("cust code");
							errCode = " ";
							errString = getErrorString("cust_code",errCode,userId);
							break;
						}else
						{

                            sql = "select count(1) from customer where cust_code = ?";
							pstmt=conn.prepareStatement(sql);
							pstmt.setString(1,custCode);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								cnt = rs.getInt(1);
							}
							pstmt.close();
							rs.close();
							pstmt = null;
							rs = null;
							if(cnt == 0)
							{
								errCode = "VTCUSTCD1";
								errString = getErrorString("cust_code",errCode,userId);
								break;
							}
						
						
						}
					
					}
					
					else if(childNodeName.equalsIgnoreCase("curr_code"))
					{

						currCode = genericUtility.getColumnValue("curr_code",dom);
						if (currCode == null || currCode.trim().length() == 0 )
						{
							errCode = " ";
							errString = getErrorString("curr_code",errCode,userId);
							break;
						}
						else
						{



							sql = "select count(1) from currency where curr_code = ?";
							pstmt=conn.prepareStatement(sql);
							pstmt.setString(1,currCode);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								cnt = rs.getInt(1);
							}
							pstmt.close();
							rs.close();
							pstmt = null;
							rs = null;
							if(cnt == 0)
							{
								errCode = "VTCURRCD1";
								errString = getErrorString("curr_code",errCode,userId);
								break;
							}
						
						
						
						}
					
					}
					
					else if(childNodeName.equalsIgnoreCase("tax_class"))
					{
                           taxClass = genericUtility.getColumnValue("tax_class",dom);
                            sql = "select count(1) from taxclass where tax_class = ?";
							pstmt=conn.prepareStatement(sql);
							pstmt.setString(1,taxClass);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								cnt = rs.getInt(1);
							}
							pstmt.close();
							rs.close();
							pstmt = null;
							rs = null;
							if(cnt == 0)
							{
								errCode = "VMTACLA1";
								errString = getErrorString("tax_class",errCode,userId);
								break;
							}
						
					}
					else if(childNodeName.equalsIgnoreCase("tax_chap"))
					{
                            taxChap = genericUtility.getColumnValue("tax_chap",dom);
                            sql = "select count(1) from taxchap where tax_chap = ?";
							pstmt=conn.prepareStatement(sql);
							pstmt.setString(1,taxChap);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								cnt = rs.getInt(1);
							}
							pstmt.close();
							rs.close();
							pstmt = null;
							rs = null;
							if(cnt == 0)
							{
								errCode = "VMTACHA1";
								errString = getErrorString("tax_chap",errCode,userId);
								break;
							}
						
					}
					
					else if(childNodeName.equalsIgnoreCase("tax_env"))
					{
                            taxEnv = genericUtility.getColumnValue("tax_env",dom);
                           
                            sql = "select count(1) from taxenv where tax_env = ?";
							pstmt=conn.prepareStatement(sql);
							pstmt.setString(1,taxEnv);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								cnt = rs.getInt(1);
							}
							pstmt.close();
							rs.close();
							pstmt = null;
							rs = null;
							if(cnt == 0)
							{
								errCode = "VMTAENV1";
								errString = getErrorString("tax_env",errCode,userId);
								break;
							}
                            
					}
					
					else if(childNodeName.equalsIgnoreCase("sale_amt"))
					{

						saleAmt = Double.parseDouble(genericUtility.getColumnValue("sale_amt",dom));
		
						
						if(saleAmt <= 0)
						{
							errCode = "VTSLAMT";
							errString = getErrorString("sale_amt",errCode,userId);        // Sale amount can not be less than 0
							break;
							
						}
					
					
					}
				
					else if(childNodeName.equalsIgnoreCase("tax_amt"))
					{

						taxAmt = Double.parseDouble(genericUtility.getColumnValue("tax_amt",dom));
		
						
						if(taxAmt < 0)
						{
							errCode = "VTTAXAMT";
							errString = getErrorString("tax_amt",errCode,userId);       
							break;
							
						}
					
					
					}
					
					
					
				}
				
				break;
			    case 2:
			    	
			    	parentNodeList = dom.getElementsByTagName("Detail2");
					parentNode = parentNodeList.item(0);
					childNodeList = parentNode.getChildNodes();
					childNodeListLength = childNodeList.getLength();
					
					for(ctr = 0; ctr < childNodeListLength; ctr++)
					{
						childNode = childNodeList.item(ctr);
						childNodeName = childNode.getNodeName();
						System.out.println("value of child node : "+childNode);
						
						if(childNodeName.equalsIgnoreCase("asset_code"))
						{

							assetCode = genericUtility.getColumnValue("asset_code",dom);
							if (assetCode == null || assetCode.trim().length() == 0 )
							{
								errCode = " ";
								errString = getErrorString("asset_code",errCode,userId);
								break;
							}else
							{


								sql = "select count(1) from asset_register where asset_code = ?";
								pstmt=conn.prepareStatement(sql);
								pstmt.setString(1,assetCode);
								rs = pstmt.executeQuery();
								if(rs.next())
								{
									cnt = rs.getInt(1);
								}
								pstmt.close();
								rs.close();
								pstmt = null;
								rs = null;
								if(cnt == 0)
								{
									errCode = "VTASSETCD";
									errString = getErrorString("asset_code",errCode,userId);
									break;
								}
							
							
							}
						
						}
						
						else if(childNodeName.equalsIgnoreCase("sale_amt"))
						{

							
							
						String	saleAmts = genericUtility.getColumnValue("sale_amt",dom);

							if(saleAmts == null || saleAmts.trim().length() == 0)
							{
								saleAmt = 0;
							}else
							{
								saleAmt = Double.parseDouble(genericUtility.getColumnValue("sale_amt",dom));
							}
							
							if(saleAmt <= 0)
							{
								errCode = "VTSLAMT";
								errString = getErrorString("sale_amt",errCode,userId);        // Sale amount can not be less than 0
								break;
								
							}
						
						
						}
						
						else if(childNodeName.equalsIgnoreCase("tax_amt"))
						{

							String	taxAmts = genericUtility.getColumnValue("tax_amt",dom);

							if(taxAmts == null || taxAmts.trim().length() == 0)
							{
								taxAmt = 0;
							}else
							{
								taxAmt = Double.parseDouble(genericUtility.getColumnValue("tax_amt",dom));
							}
							
							if(taxAmt < 0)
							{
								errCode = "VTTAXAMT";
								errString = getErrorString("tax_amt",errCode,userId);       
								break;
								
							}
						
						
						}
						
						else if(childNodeName.equalsIgnoreCase("acct_code__ar"))
						{
	                            acctCdAr = genericUtility.getColumnValue("acct_code__ar",dom);
	                           
	                            if (acctCdAr == null || acctCdAr.trim().length() == 0 )
	    						{
	    							errCode = " ";
	    							errString = getErrorString("acct_code__ar",errCode,userId);
	    							break;
	    						}
	    						else
	    						{



	    							sql = "select count(1) from accounts where acct_code = ?";
	    							pstmt=conn.prepareStatement(sql);
	    							pstmt.setString(1,acctCdAr);
	    							rs = pstmt.executeQuery();
	    							if(rs.next())
	    							{
	    								cnt = rs.getInt(1);
	    							}
	    							pstmt.close();
	    							rs.close();
	    							pstmt = null;
	    							rs = null;
	    							if(cnt == 0)
	    							{
	    								errCode = "VMACCTR";
	    								errString = getErrorString("acct_code__ar",errCode,userId);
	    								break;
	    							}
	    						
	    						
	    						
	    						}
	                            
						}
						
						else if(childNodeName.equalsIgnoreCase("cctr_code__ar"))
						{
	                            cctrCdAr = genericUtility.getColumnValue("cctr_code__ar",dom);
	                           
	                            if (cctrCdAr == null || cctrCdAr.trim().length() == 0 )
	    						{
	    							errCode = " ";
	    							errString = getErrorString("cctr_code__ar",errCode,userId);
	    							break;
	    						}
	    						else
	    						{



	    							sql = "select count(1) from costctr where cctr_code = ?";
	    							pstmt=conn.prepareStatement(sql);
	    							pstmt.setString(1,cctrCdAr);
	    							rs = pstmt.executeQuery();
	    							if(rs.next())
	    							{
	    								cnt = rs.getInt(1);
	    							}
	    							pstmt.close();
	    							rs.close();
	    							pstmt = null;
	    							rs = null;
	    							if(cnt == 0)
	    							{
	    								errCode = "VMCCTR";
	    								errString = getErrorString("cctr_code__ar",errCode,userId);
	    								break;
	    							}
	    						
	    						
	    						
	    						}
	                            
						}
						else if(childNodeName.equalsIgnoreCase("acct_code__mod"))
						{
	                            acctCdMd = genericUtility.getColumnValue("acct_code__mod",dom);
	                           
	                            if (acctCdMd == null || acctCdMd.trim().length() == 0 )
	    						{
	    							errCode = " ";
	    							errString = getErrorString("acct_code__mod",errCode,userId);
	    							break;
	    						}
	    						else
	    						{



	    							sql = "select count(1) from accounts where acct_code = ?";
	    							pstmt=conn.prepareStatement(sql);
	    							pstmt.setString(1,acctCdMd);
	    							rs = pstmt.executeQuery();
	    							if(rs.next())
	    							{
	    								cnt = rs.getInt(1);
	    							}
	    							pstmt.close();
	    							rs.close();
	    							pstmt = null;
	    							rs = null;
	    							if(cnt == 0)
	    							{
	    								errCode = "VTACCTCDMD";
	    								errString = getErrorString("acct_code__mod",errCode,userId);
	    								break;
	    							}
	    						
	    						
	    						
	    						}
	                            
						}
						
						else if(childNodeName.equalsIgnoreCase("cctr_code__mod"))
						{
	                            cctrCdMd = genericUtility.getColumnValue("cctr_code__mod",dom);
	                           
	                            if (cctrCdMd == null || cctrCdMd.trim().length() == 0 )
	    						{
	    							errCode = " ";
	    							errString = getErrorString("cctr_code__mod",errCode,userId);
	    							break;
	    						}
	    						else
	    						{



	    							sql = "select count(1) from costctr where cctr_code = ?";
	    							pstmt=conn.prepareStatement(sql);
	    							pstmt.setString(1,cctrCdMd);
	    							rs = pstmt.executeQuery();
	    							if(rs.next())
	    							{
	    								cnt = rs.getInt(1);
	    							}
	    							pstmt.close();
	    							rs.close();
	    							pstmt = null;
	    							rs = null;
	    							if(cnt == 0)
	    							{
	    								errCode = "VMCCTR";
	    								errString = getErrorString("cctr_code__mod",errCode,userId);
	    								break;
	    							}
	    						
	    						
	    						
	    						}
	                            
						}
					// case "acct_code__pl","acct_code__loss"
					
						
						else if(childNodeName.equalsIgnoreCase("acct_code__pl") 
								|| childNodeName.equalsIgnoreCase("acct_code__loss"))
						{
							
							 acctCdPl = genericUtility.getColumnValue("acct_code__pl",dom);
							 acctCdLo = genericUtility.getColumnValue("acct_code__loss",dom);
							 
							 if(acctCdPl == null || acctCdPl == "")
							 {
								 acctCdPl = " ";
							 }
							 else if (acctCdLo == null || acctCdLo == "") 
							 {
								 acctCdLo = " ";
							 }
							
							 if (acctCdPl == null || acctCdPl.trim().length() == 0 )
	    						{
	    							errCode = " ";
	    							errString = getErrorString("acct_code__pl",errCode,userId);
	    							break;
	    						}
							 
							 else
							 {
								 sql = "select count(1) from accounts where acct_code = ?";
	    							pstmt=conn.prepareStatement(sql);
	    							pstmt.setString(1,acctCdPl);
	    							rs = pstmt.executeQuery();
	    							if(rs.next())
	    							{
	    								cnt = rs.getInt(1);
	    							}
	    							pstmt.close();
	    							rs.close();
	    							pstmt = null;
	    							rs = null;
	    							if(cnt == 0)
	    							{
	    								errCode = "VTACCTCDPL";
	    								errString = getErrorString("acct_code__pl",errCode,userId);
	    								break;
	    							}
							 }
							 
							 if (acctCdLo == null || acctCdLo.trim().length() == 0 )
	    						{
	    							errCode = " ";
	    							errString = getErrorString("acct_code__loss",errCode,userId);
	    							break;
	    						}
							 
							 else
							 { 
						    sql = "select count(1) from accounts where acct_code = ?";
 							pstmt=conn.prepareStatement(sql);
 							pstmt.setString(1,acctCdLo);
 							rs = pstmt.executeQuery();
 							if(rs.next())
 							{
 								cnt = rs.getInt(1);
 							}
 							pstmt.close();
 							rs.close();
 							pstmt = null;
 							rs = null;
 							if(cnt == 0)
 							{
 								errCode = "VTACCTCDLS";
 								errString = getErrorString("acct_code__loss",errCode,userId);
 								break;
 							}}
							 
						}
						
						else if(childNodeName.equalsIgnoreCase("cctr_code__pl") 
								|| childNodeName.equalsIgnoreCase("cctr_code__loss"))
						{
							
							 cctrCdPl = genericUtility.getColumnValue("cctr_code__pl",dom);
							 cctrCdLo = genericUtility.getColumnValue("cctr_code__loss",dom);
							 
							 if(cctrCdPl == null || cctrCdPl == "")
							 {
								 cctrCdPl = " ";
							 }
							 else if (cctrCdLo == null || cctrCdLo == "") 
							 {
								 cctrCdLo = " ";
							 }
							
							 if (cctrCdPl == null || cctrCdPl.trim().length() == 0 )
	    						{
	    							errCode = " ";
	    							errString = getErrorString("cctr_code__pl",errCode,userId);
	    							break;
	    						}
							 
							 else
							 {
								 sql = "select count(1) from costctr where cctr_code = ?";
	    							pstmt=conn.prepareStatement(sql);
	    							pstmt.setString(1,cctrCdPl);
	    							rs = pstmt.executeQuery();
	    							if(rs.next())
	    							{
	    								cnt = rs.getInt(1);
	    							}
	    							pstmt.close();
	    							rs.close();
	    							pstmt = null;
	    							rs = null;
	    							if(cnt == 0)
	    							{
	    								errCode = "VMCCTR";
	    								errString = getErrorString("cctr_code__pl",errCode,userId);
	    								break;
	    							}
							 }
							 
							 if (cctrCdLo == null || cctrCdLo.trim().length() == 0 )
	    						{
	    							errCode = " ";
	    							errString = getErrorString("cctr_code__loss",errCode,userId);
	    							break;
	    						}
							 
							 else
							 { 
						    sql = "select count(1) from costctr where cctr_code = ?";
 							pstmt=conn.prepareStatement(sql);
 							pstmt.setString(1,cctrCdLo);
 							rs = pstmt.executeQuery();
 							if(rs.next())
 							{
 								cnt = rs.getInt(1);
 							}
 							pstmt.close();
 							rs.close();
 							pstmt = null;
 							rs = null;
 							if(cnt == 0)
 							{
 								errCode = "VMCCTR";
 								errString = getErrorString("cctr_code__loss",errCode,userId);
 								break;
 							}}
							 
						}
						
						
						
					}
			}
			
		}catch(Exception e)
		{

			System.out.println("Exception ::"+e);
			e.printStackTrace();
			errString=e.getMessage();
            throw new ITMException(e);
		
		}
		finally
		{

			try
			{
				if(conn!=null)
				{
					if(rs != null )
					{
						rs.close();
						rs = null;
					}
					if(pstmt != null )pstmt.close();
					pstmt =null;
					conn.close();
				}
				conn = null;
			}
			catch(Exception d)
			{
			  d.printStackTrace();
			}
		
		}
		System.out.println("ErrString ::[ "+errString+" ]");
		return errString;
	
	}

	public String itemChanged(String xmlString,String xmlString1,String xmlString2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		System.out.println("------------------ itemChanged called------------------");
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String valueXmlString = "";
		try
		{   
			dom = parseString(xmlString);
			dom1 = parseString(xmlString1);
			dom2 = parseString(xmlString2);
			valueXmlString = itemChanged(dom,dom1,dom2,objContext,currentColumn,editFlag,xtraParams);
		}
		catch(Exception e)
		{
			System.out.println("Exception : [AssetSales][itemChanged(String,String)] :==>\n"+e.getMessage());
		}
		return valueXmlString;
	}

	public String itemChanged(Document dom, Document dom1,Document dom2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException,ITMException
	{

		System.out.println("@@@@@@@ itemChanged called");
		StringBuffer valueXmlString = new StringBuffer();
		NodeList parentNodeList = null;
		NodeList childNodeList = null;
		Node parentNode = null;
		Node childNode = null;
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null ;
		String childNodeName = null;
		GenericUtility genericUtility = GenericUtility.getInstance();
		ConnDriver connDriver = new ConnDriver();
		String siteCode = "",sql="",sitedesc="",priclit="",ItemSer="";
		int currentFormNo =0;
		String columnValue="",chgTerm="",chgUser="",priceList="",tranDate="",listType="",oRate="",oldRateS="";
		String itemCode="",locCode="",lotNo="",lotsl="",quantity="",itmdesc="",loginSite="";
		Date utranDate;
		double rate = 0,conquan,conOldRate,oldAmount,amount,amtdiff,oldRate=0,getquantity=0;
		
		String asstCode="",itemSer="",grpCode="",descr="",cctrCode="",tranType="",getAcctCctrPl="",getAcctCctrLo="";
		String custCode="",getAcctCctrAr="";
		Date procDate2;
		double taxRecoAmt= 0;
		String[] acctCctrPl,acctCctrLo,acctCctrAr;
		String acctCodePl="",acctCodeLo="",cctrCodePl="",cctrCodeLo="",acctCodeAr="",cctrCodeAr="";
		String custName="",currCode="",acctCodeArLs="",cctrCodeArLs="",saleAmts="",taxAmts="",taxRecos="";
		double excRate=0,saleAmt,taxAmt = 0,taxReco=0;
		
		try
		{
			conn = connDriver.getConnectDB("DriverITM");
			conn.setAutoCommit(false);
			connDriver=null;
			if(objContext != null && objContext.trim().length()>0)
			{
				currentFormNo = Integer.parseInt(objContext.trim());
			}
			valueXmlString = new StringBuffer("<?xml version=\"1.0\"?><Root><header><editFlag>");
			valueXmlString.append(editFlag).append("</editFlag></header>");
			chgTerm = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "chg_termr");
			chgUser = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "chg_user");
			System.out.println("-------- currentFormNo : "+currentFormNo);
			
			switch(currentFormNo)
			{
			case 1 :
				parentNodeList = dom.getElementsByTagName("Detail1");
				parentNode = parentNodeList.item(0);
				childNodeList = parentNode.getChildNodes();
				
				valueXmlString.append("<Detail1>");
				int childNodeListLength = childNodeList.getLength();
				
				if( currentColumn.trim().equalsIgnoreCase( "itm_default" ) )
				{
					System.out.println("------------@@@@@@@@in itm_default@@@@@@@@@---------");
					Calendar currentDate = Calendar.getInstance();
					SimpleDateFormat simpleDateFormatObj = new SimpleDateFormat(genericUtility.getApplDateFormat());
					String systemDate = simpleDateFormatObj.format(currentDate.getTime());
					System.out.println("Now the date is :=>  " + systemDate);
					valueXmlString.append("<tran_date>").append("<![CDATA[" + systemDate + "]]>").append("</tran_date>");
					//loginSite = getValueFromXTRA_PARAMS(xtraParams, "loginSiteCode");
					//loginSite = loginSite == null ? "":loginSite.trim();
					//valueXmlString.append("<site_code>").append("<![CDATA[" + loginSite + "]]>").append("</site_code>");
					
					/*sql = "select descr,price_list from site where site_code = ?";
					pstmt=conn.prepareStatement(sql);
					pstmt.setString(1,loginSite);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						sitedesc = rs.getString(1) == null ? "":rs.getString(1);
						priclit = rs.getString(2) == null ? "":rs.getString(2);
					}
					pstmt.close();
					rs.close();
					pstmt = null;
					rs = null;
					valueXmlString.append("<site_descr>").append("<![CDATA[" + sitedesc + "]]>").append("</site_descr>");
					valueXmlString.append("<price_list>").append("<![CDATA[" + priclit + "]]>").append("</price_list>");
					
					*/
					
				}
				
				if((currentColumn.trim().equalsIgnoreCase("cust_code")))
				{
					
					custCode = genericUtility.getColumnValue("cust_code",dom);
					tranType = genericUtility.getColumnValue("tran_type",dom);
					
					sql = "select cust_name,curr_code,acct_code__ar,cctr_code__ar from "
							+ "customer where cust_code = ?";
							
					pstmt=conn.prepareStatement(sql);
					pstmt.setString(1,custCode);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						custName = rs.getString(1) == null ? "":rs.getString(1);
						currCode = rs.getString(2) == null ? "":rs.getString(2);
						acctCodeArLs = rs.getString(3) == null ? "":rs.getString(3);
						cctrCodeArLs = rs.getString(4) == null ? "":rs.getString(4);
						
					}
					pstmt.close();
					rs.close();
					pstmt = null;
					rs = null;
					
					sql = "select std_exrt from currency where curr_code = ?";
							
					pstmt=conn.prepareStatement(sql);
					pstmt.setString(1,currCode);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						excRate = rs.getDouble(1);
						
					}
					pstmt.close();
					rs.close();
					pstmt = null;
					rs = null;
					
					if(custCode != null && custCode.trim().length()>0 )
					{
						
					
					valueXmlString.append("<exch_rate>").append("<![CDATA[" + excRate + "]]>").append("</exch_rate>");
					valueXmlString.append("<cust_name>").append("<![CDATA[" + custName + "]]>").append("</cust_name>");
					valueXmlString.append("<curr_code>").append("<![CDATA[" + currCode + "]]>").append("</curr_code>");
				
					
					}
					else
					{
						valueXmlString.append("<exch_rate>").append("<![CDATA[]]>").append("</exch_rate>");
						valueXmlString.append("<cust_name>").append("<![CDATA[]]>").append("</cust_name>");
						valueXmlString.append("<curr_code>").append("<![CDATA[]]>").append("</curr_code>");
					
					}
					
				}
				if((currentColumn.trim().equalsIgnoreCase("curr_code")))
				{
					currCode = genericUtility.getColumnValue("curr_code",dom);
					
					if(currCode != null && currCode.trim().length()>0 )
					{
					
					sql = "select std_exrt from currency where curr_code = ?";
					pstmt=conn.prepareStatement(sql);
					pstmt.setString(1,currCode);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						excRate = rs.getDouble(1);
						
					}
					pstmt.close();
					rs.close();
					pstmt = null;
					rs = null;
					
					valueXmlString.append("<exch_rate>").append("<![CDATA[" + excRate + "]]>").append("</exch_rate>");
					}
					else
					{
						valueXmlString.append("<exch_rate>").append("<![CDATA[]]>").append("</exch_rate>");
					}
					}
				  /*  if((currentColumn.trim().equalsIgnoreCase("sale_amt")))
				    {
				    	        
				    	        saleAmts = genericUtility.getColumnValue("sale_amt",dom);
				    	        taxAmts = genericUtility.getColumnValue("tax_amt",dom);
				    	        
				    	        if(saleAmts == null)
				    	        {
				    	        	saleAmt = 0;
				    	        }else
				    	        {
				    	        	saleAmt = Double.parseDouble(saleAmts);
				    	        }
				    	        
				    	        if(taxAmts == null)
				    	        {
				    	        	taxAmt = 0;
				    	        }else
				    	        {
				    	        	taxAmt = Double.parseDouble(taxAmts);
				    	        }
				    	        
				    	        
				    	        
				    	        if(saleAmt > 0)
				    	        {
				    	        	double totamt = saleAmt + taxAmt;
				    	        	valueXmlString.append("<total_amt>").append("<![CDATA[" + totamt + "]]>").append("</total_amt>");
				    	        }else
				    	        {
				    	        	valueXmlString.append("<total_amt>").append("<![CDATA[]]>").append("</total_amt>");
				    	        }
				    
				    	        
				    	        
				    	        
				    }*/
				    if(currentColumn.trim().equalsIgnoreCase("sale_amt") || currentColumn.trim().equalsIgnoreCase("tax_amt") || currentColumn.trim().equalsIgnoreCase("excreco_amt") )
				    {
				    	    saleAmts = genericUtility.getColumnValue("sale_amt",dom);
			    	        taxAmts = genericUtility.getColumnValue("tax_amt",dom);
			    	        taxRecos = genericUtility.getColumnValue("excreco_amt",dom);
			    	        
			    	        if(saleAmts == null)
			    	        {
			    	        	saleAmt = 0;
			    	        }else
			    	        {
			    	        	saleAmt = Double.parseDouble(saleAmts);
			    	        }
			    	        
			    	        if(taxAmts == null)
			    	        {
			    	        	taxAmt = 0;
			    	        }else
			    	        {
			    	        	taxAmt = Double.parseDouble(taxAmts);
			    	        }
			    	        
			    	        
			    	        if(taxRecos == null)
			    	        {
			    	        	taxReco = 0;
			    	        }else
			    	        {
			    	        	taxReco = Double.parseDouble(taxRecos);
			    	        }
			    	        
			    	        
			    	        if((saleAmts != null && saleAmts.trim().length()>0) || (taxAmts != null && taxAmts.trim().length()>0) || (taxRecos != null && taxRecos.trim().length()>0))
			    	        {
			    	        	double totchk = saleAmt + taxAmt + taxReco;
			    	        	valueXmlString.append("<total_amt>").append("<![CDATA[" + totchk + "]]>").append("</total_amt>");
			    	        }else
			    	        {
			    	        	valueXmlString.append("<total_amt>").append("<![CDATA[]]>").append("</total_amt>");
			    	        }
				    }
				
				
				
				
				valueXmlString.append("</Detail1>");
				break;
				
			case 2:
				
				valueXmlString.append("<Detail2>");	
				parentNodeList = dom.getElementsByTagName("Detail2");
				parentNode = parentNodeList.item(0);
				childNodeList = parentNode.getChildNodes();
				System.out.println("[" + currentColumn + "] ==> '" + columnValue + "'");
				
				siteCode = checkNull(genericUtility.getColumnValue("site_code",dom1));
			    tranDate = checkNull(genericUtility.getColumnValue("tran_date",dom1));
				SimpleDateFormat simpleDateFormatObj = new SimpleDateFormat(genericUtility.getApplDateFormat());
				utranDate = simpleDateFormatObj.parse(tranDate);
				
				
				
				if((currentColumn.trim().equalsIgnoreCase("asset_code")))
				{
					
					asstCode = genericUtility.getColumnValue("asset_code",dom);
					tranType = genericUtility.getColumnValue("tran_type",dom1);
					
					if(asstCode != null && asstCode.trim().length()>0 )
					{
									
						sql = "select item_ser, grp_code, item_code, descr, site_code, cctr_code, "
								+ "proc_date_2,tax_reco_amt from asset_register where asset_code = ?";
						pstmt=conn.prepareStatement(sql);
						pstmt.setString(1,asstCode);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							itemSer = rs.getString(1) == null ? "":rs.getString(1);
							grpCode = rs.getString(2) == null ? "":rs.getString(2);
							itemCode = rs.getString(3) == null ? "":rs.getString(3);
							descr = rs.getString(4) == null ? "":rs.getString(4);
							siteCode = rs.getString(5) == null ? "":rs.getString(5);
							cctrCode = rs.getString(6) == null ? "":rs.getString(6);
							procDate2 = rs.getDate(7);
							taxRecoAmt = rs.getDouble(8);
						}
						pstmt.close();
						rs.close();
						pstmt = null;
						rs = null;
						
						getAcctCctrPl = finCommon.getAcctDetrTtype(itemCode, itemSer, "FA-PL", tranType, conn);
					
						if(getAcctCctrPl.equals(" , ") || getAcctCctrPl.equals(","))
						{
							acctCodePl = "";
						}
						else
						{
							acctCctrPl = getAcctCctrPl.split(",");
							System.out.println(">>>>"+acctCctrPl[0]);
							acctCodePl = acctCctrPl[0];
						}
						
					
						cctrCodePl = cctrCode;
						
						
						getAcctCctrLo = finCommon.getAcctDetrTtype(itemCode, itemSer, "FA-LOSS", tranType, conn);
						
						if(getAcctCctrLo.equals(" , ") || getAcctCctrLo.equals(","))
						{
							acctCodeLo = "";
						}
						else
						{
							acctCctrLo = getAcctCctrLo.split(",");
							System.out.println(">>>>"+acctCctrLo[1]);
							
							acctCodeLo = acctCctrLo[0];
						}
						
						
						cctrCodeLo = cctrCode;
						
						
					
						getAcctCctrAr = finCommon.getAcctDetrTtype(itemCode, itemSer, "AR", tranType, conn);
						
						if((getAcctCctrAr.equals(" , ") || getAcctCctrAr.equals(",")))
						{
							acctCodeAr = "";
							cctrCodeAr = "";
						}
						else
						{
							acctCctrAr = getAcctCctrAr.split(",");
							System.out.println(">>>>"+acctCctrAr[1]);
							
							acctCodeAr = acctCctrAr[0];
							cctrCodeAr = acctCctrAr[1];
						}
						
						
						
						
						//acct_code__mod cctr_code__mod remain
						
						valueXmlString.append("<site_code>").append("<![CDATA[" + siteCode + "]]>").append("</site_code>");
						valueXmlString.append("<descr>").append("<![CDATA[" + descr + "]]>").append("</descr>");
						valueXmlString.append("<grp_code>").append("<![CDATA[" + grpCode + "]]>").append("</grp_code>");
						valueXmlString.append("<acct_code__pl>").append("<![CDATA[" + acctCodePl + "]]>").append("</acct_code__pl>");
						valueXmlString.append("<cctr_code__pl>").append("<![CDATA[" + cctrCodePl + "]]>").append("</cctr_code__pl>");
						valueXmlString.append("<acct_code__loss>").append("<![CDATA[" + acctCodeLo + "]]>").append("</acct_code__loss>");
						valueXmlString.append("<cctr_code__loss>").append("<![CDATA[" + cctrCodeLo + "]]>").append("</cctr_code__loss>");
						valueXmlString.append("<acct_code__ar>").append("<![CDATA[" + acctCodeAr + "]]>").append("</acct_code__ar>");
						valueXmlString.append("<cctr_code__ar>").append("<![CDATA[" + cctrCodeAr + "]]>").append("</cctr_code__ar>");
						
					}else{
						
						valueXmlString.append("<site_code>").append("<![CDATA[]]>").append("</site_code>");
						valueXmlString.append("<descr>").append("<![CDATA[]]>").append("</descr>");
						valueXmlString.append("<grp_code>").append("<![CDATA[]]>").append("</grp_code>");
						valueXmlString.append("<acct_code__pl>").append("<![CDATA[]]>").append("</acct_code__pl>");
						valueXmlString.append("<cctr_code__pl>").append("<![CDATA[]]>").append("</cctr_code__pl>");
						valueXmlString.append("<acct_code__loss>").append("<![CDATA[]]>").append("</acct_code__loss>");
						valueXmlString.append("<cctr_code__loss>").append("<![CDATA[]]>").append("</cctr_code__loss>");
						valueXmlString.append("<acct_code__ar>").append("<![CDATA[]]>").append("</acct_code__ar>");
						valueXmlString.append("<cctr_code__ar>").append("<![CDATA[]]>").append("</cctr_code__ar>");
					}
				}
			
				
			/*	 if((currentColumn.trim().equalsIgnoreCase("sale_amt")))
				    {
				    	        
				    	        saleAmts = genericUtility.getColumnValue("sale_amt",dom);
				    	        taxAmts = genericUtility.getColumnValue("tax_amt",dom);
				    	        
				    	        if(saleAmts == null )
				    	        {
				    	        	saleAmt = 0;
				    	        }else
				    	        {
				    	        	saleAmt = Double.parseDouble(saleAmts);
				    	        }
				    	        
				    	        if(taxAmts == null )
				    	        {
				    	        	taxAmt = 0;
				    	        }else
				    	        {
				    	        	taxAmt = Double.parseDouble(taxAmts);
				    	        }
				    	        
				    	        
				    	        
				    	        if(saleAmt > 0)
				    	        {
				    	        	double totamt = saleAmt + taxAmt;
				    	        	valueXmlString.append("<total_amt>").append("<![CDATA[" + totamt + "]]>").append("</total_amt>");
				    	        }else
				    	        {
				    	        	valueXmlString.append("<total_amt>").append("<![CDATA[]]>").append("</total_amt>");
				    	        }
				    
				    	        
				    	        
				    	        
				    }*/
				
				 if((currentColumn.trim().equalsIgnoreCase("tax_amt")) || (currentColumn.trim().equalsIgnoreCase("excreco_amt")) || (currentColumn.trim().equalsIgnoreCase("sale_amt")))
				    {
				    	    saleAmts = genericUtility.getColumnValue("sale_amt",dom);
			    	        taxAmts = genericUtility.getColumnValue("tax_amt",dom);
			    	        taxRecos = genericUtility.getColumnValue("excreco_amt",dom);
			    	        
			    	        if(saleAmts == null )
			    	        {
			    	        	saleAmt = 0;
			    	        }else
			    	        {
			    	        	saleAmt = Double.parseDouble(saleAmts);
			    	        }
			    	        
			    	        if(taxAmts == null)
			    	        {
			    	        	taxAmt = 0;
			    	        }else
			    	        {
			    	        	taxAmt = Double.parseDouble(taxAmts);
			    	        }
			    	        
			    	        
			    	        if(taxRecos == null)
			    	        {
			    	        	taxReco = 0;
			    	        }else
			    	        {
			    	        	taxReco = Double.parseDouble(taxRecos);
			    	        }
			    	        
			    	        
			    	        if((saleAmts != null && saleAmts.trim().length()>0) || (taxAmts != null && taxAmts.trim().length()>0) || (taxRecos != null && taxRecos.trim().length()>0))
			    	        {
			    	        	double totchk = saleAmt + taxAmt + taxReco;
			    	        	valueXmlString.append("<total_amt>").append("<![CDATA[" + totchk + "]]>").append("</total_amt>");
			    	        }else
			    	        {
			    	        	valueXmlString.append("<total_amt>").append("<![CDATA[]]>").append("</total_amt>");
			    	        }
				    }
				 
				
				
				valueXmlString.append("</Detail2>");
				
			}// end switch
			
			valueXmlString.append("</Root>");
		}
		catch(Exception e)
		{
            e.printStackTrace();
			System.out.println("Exception ::"+e.getMessage());
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(conn!=null)
				{
					if(rs != null)
					{
						rs.close();
						rs = null;
					}
					if(pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
					conn.close();
					conn = null;
				}
			}
			catch(Exception d)
			{
			  d.printStackTrace();
			}			
		}
		return valueXmlString.toString();
	
	}

	private String checkNull(String input)
	{
		if(input == null)
		{
		  return "";
		}
		return input.trim();
	}
}
