package ibase.webitm.utility.wms;

import ibase.scheduler.utility.interfaces.Schedule;
import ibase.system.config.ConnDriver;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;

import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPReply;
import org.apache.commons.net.ftp.FTP;
import org.apache.commons.vfs2.FileSystemOptions;
import org.w3c.dom.Document;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;

public class DDUpdStockSchedule implements Schedule
{
	private String hostName = "";  
	private String username = "";     
	private String password = "";  	
	//Changed by Samadhan D15IKAT004 on 10/12/2015 for SFTP And configurable remote path
	//private String remoteFilePath = "uat/Stock.csv"; 	
	private String remoteFilePath = "";
	private String csvFileNameUpd = "";
	private String uploadProtocol = "";

	private FileSystemOptions opts = null;
	public String schedulePriority( String wrkflwPriority )throws Exception
	{
		return "";
	}
	public String schedule(HashMap map)throws Exception
	{
		return "";
	}
	public String schedule(String scheduleParamXML)throws Exception
	{
		System.out.println("calling schedule DDUpdStockSchedule..................");
		Connection conn = null;
		ConnDriver connDriver = null;		
		String tranDate="",fileName = "Stock.csv";
		String remoteFileName = "Stock.csv";
		try
		{
			setDDSalesConfig();
			connDriver = new ConnDriver();
			conn = connDriver.getConnectDB("DriverITM");
			connDriver = null;
			E12GenericUtility genericUtility = new E12GenericUtility();
			Calendar currentDate = Calendar.getInstance();
			SimpleDateFormat simpleDateFormat = new SimpleDateFormat(genericUtility.getApplDateFormat());
			tranDate = simpleDateFormat.format(currentDate.getTime());
			System.out.println("csvFileNameUpd12---->>["+csvFileNameUpd+"]");

			File file = new File(csvFileNameUpd);
			System.out.println("file.separatorChar---->>["+file.separatorChar+"]");
			file.mkdirs();
			char ch = csvFileNameUpd.charAt(csvFileNameUpd.length() -1 );
			System.out.println("Ch @@@@---->>["+ch+"]");			
			if(ch != file.separatorChar)
			{
				fileName = file.separator+fileName;
			}			

			generateCsvFile (csvFileNameUpd +fileName,conn);	
			System.out.println("CSV file successfully created....... ");
			//Changed By Samadhan D15IKAT004 on 10/12/2015 for SFTP potocol Start
			//final  String vtest = csvFileNameUpd+fileName;
			final  String localFile = csvFileNameUpd+fileName;
			char ch1 = remoteFilePath.charAt(remoteFilePath.length() -1 );
			System.out.println("Ch @@@@---->>["+ch1+"]");			
			if(ch1 != file.separatorChar)
			{
				remoteFileName = file.separator+remoteFileName;
			}
			final  String remoteFile = remoteFilePath+remoteFileName;
			//Changed By Samadhan D15IKAT004 on 10/12/2015 for SFTP potocol End
			//putFile(username, hostName, password, remoteFilePath, csvFileNameUpd+fileName);

			Thread t = new Thread()
			{
				public void run()
				{
					System.out.println("Thread started........");
					//Changed By Samadhan D15IKAT004 on 10/12/2015 for SFTP potocol Start
					//putFile(username, hostName, password, remoteFilePath, vtest);
					if("SFTP".equalsIgnoreCase(uploadProtocol))
					{
						putFileSFTP(username, hostName, password, remoteFilePath,localFile,22);
					}
					else
					{
						putFileFTP(username, hostName, password, remoteFile,localFile,21);
					}
					//Changed By Samadhan D15IKAT004 on 10/12/2015 for SFTP potocol End
					System.out.println("Thread commited........");
				}

			};

			t.start();

			System.out.println("End of program........");


			//System.out.println("The file is uploaded successfully.......");
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		finally
		{

			if(conn != null)
			{
				conn.close();
				conn = null;
			}
		}
		return "";
	}
	private  void generateCsvFile(String sFileName,Connection conn) throws IOException,Exception
	{	
		System.out.println("calling generateCsvFile..................");
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		String sql="";	
		// Changed by Sneha on 11-03-2016, added try, catch and finally  block [Start]
		try
		{
		// Changed by Sneha on 11-03-2016, added try, catch and finally  block [End]
			File newFile = new File(sFileName);
			if(newFile.exists())
				newFile.createNewFile();
			BufferedWriter writer = new BufferedWriter(new FileWriter(sFileName));
			//FileWriter writer = new FileWriter(sFileName);
			writer.append("sku");
			writer.append(',');
			writer.append("qty");
			writer.append('\n');
			//Changed by Samadhan D15IKAT004 on 10/12/2015 for getting Record Not in 'DOCK','ISTAG','NOSL','INTR' as per nilay and shailesh sir Start 
			/*sql="SELECT S.ITEM_CODE,SUM(S.QUANTITY) - (CASE WHEN SUM(S.ALLOC_QTY) IS NULL THEN 0 ELSE SUM(S.ALLOC_QTY) END + CASE WHEN SUM(S.HOLD_QTY) IS NULL THEN 0 ELSE SUM(S.HOLD_QTY) END) AS QUANTITY "
					+ "FROM STOCK S,ITEM I WHERE INV_STAT NOT IN (?,?,?) AND S.ITEM_CODE = I.ITEM_CODE "
					+ "AND I.ACTIVE = 'Y' GROUP BY I.ACTIVE, S.ITEM_CODE";
			pstmt =conn.prepareStatement(sql);
			pstmt.setString(1, "SALE");
			pstmt.setString(2, "GRL");
			pstmt.setString(3, "PGRL");*/
	
			// Changed by Sneha on 11-03-2016, Change the sql [Start]
			/*		
	 		sql="SELECT S.ITEM_CODE,SUM(S.QUANTITY) - (CASE WHEN SUM(S.ALLOC_QTY) IS NULL THEN 0 ELSE SUM(S.ALLOC_QTY) END + CASE WHEN SUM(S.HOLD_QTY) IS NULL THEN 0 ELSE SUM(S.HOLD_QTY) END) AS QUANTITY "
				+ "FROM STOCK S,ITEM I WHERE INV_STAT NOT IN (?,?,?,?) AND S.ITEM_CODE = I.ITEM_CODE "
				+ "AND I.ACTIVE = 'Y' GROUP BY I.ACTIVE, S.ITEM_CODE";
				pstmt =conn.prepareStatement(sql);
				pstmt.setString(1, "DOCK");
				pstmt.setString(2, "ISTAG");
				pstmt.setString(3, "NOSL");
				pstmt.setString(4, "INTR");
			*/
			//Added Nvl() to hold_qty to retrun 0 if hold_qty is null in stock master by Santosh on 06-04-2016
			//sql = " select A.Item_code, A.stk_qty- Nvl(H.Order_QTY,0) FinStk from (select stk.Item_code, sum(quantity-Alloc_Qty-Hold_qty) stk_qty " 
			
			//Changed by Santosh on 06-04-2016 [Start]
			/*sql = " select A.Item_code, A.stk_qty- Nvl(H.Order_QTY,0) FinStk from (select stk.Item_code, sum(quantity-Alloc_Qty-Nvl(Hold_qty,0)) stk_qty "
				+ " from stock Stk group by stk.Item_code) A left outer join (select G.item_code,G.Order_QTY from (select item_code, Sum(Quantity) Order_QTY, " 
				+ " (select sum(quantity) from stock Stk where stk.Item_code = S.Item_code) as Stock_Qty from sorddet S, Sorder SO " 
				+ " where SO.Sale_order=S.Sale_order and SO.Confirmed = ? and SO.Status not in (?, ?) and " 
				+ " (select count(1) from sordalloc a where a.sale_order = s.sale_order and Trim(s.line_no) = Trim(a.line_no)) = 0 and S.status not in (?, ?) " 
				+ " group by item_code) G ) H on A.Item_code = H.Item_code  ";*/
			sql = " SELECT SKU, SUM(FINSTK) FINSTK FROM ( SELECT S.ITEM_CODE SKU, SUM(S.QUANTITY - S.ALLOC_QTY - CASE WHEN S.HOLD_QTY IS NULL THEN 0 ELSE S.HOLD_QTY END) FINSTK "
				+ " FROM STOCK S GROUP BY S.ITEM_CODE HAVING SUM(S.QUANTITY - S.ALLOC_QTY - CASE WHEN S.HOLD_QTY IS NULL THEN 0 ELSE S.HOLD_QTY END) > 0 "
				+ " UNION ALL SELECT SI.ITEM_CODE, -1 * SUM(SI.QUANTITY - SI.QTY_ALLOC - SI.QTY_DESP) FROM SORDITEM SI , SORDER S, SORDDET SD "
				+ " WHERE SI.SALE_ORDER = S.SALE_ORDER AND SI.SALE_ORDER = SD.SALE_ORDER AND SI.LINE_NO = SD.LINE_NO AND SI.LINE_TYPE = 'I' "
				+ " AND S.STATUS NOT IN ('C','X') AND SI.STATUS NOT IN ('C','X') AND SD.STATUS NOT IN ('C','X') "
				+ " GROUP BY SI.ITEM_CODE HAVING SUM(SI.QUANTITY - SI.QTY_ALLOC - SI.QTY_DESP) <> 0 ) GROUP BY SKU HAVING SUM(FINSTK) > 0 ";
			pstmt = conn.prepareStatement(sql);
			/*pstmt.setString(1, "Y");
			pstmt.setString(2, "X");
			pstmt.setString(3, "C");
			pstmt.setString(4, "X");
			pstmt.setString(5, "C");*/
			//Changed by Santosh on 06-04-2016 [End]
			
			// Changed by Sneha on 11-03-2016, Change the sql [End]
			
			//Changed by Samadhan D15IKAT004 on 10/12/2015 for getting Record Not in 'DOCK','ISTAG','NOSL','INTR' as per nilay and shailesh sir End
		
			rs = pstmt.executeQuery();
			
			while(rs.next())
			{
				//Changed by Samadhan D14HKAT002 on 10/06/2015 from upload file on katdev.com. start
				/*
				writer.append(rs.getString(1)));
				writer.append(',');
				writer.append(rs.getString(2)));
				writer.append('\n');
				*/
				writer.append("\""+checkNullAndTrim(rs.getString(1))+"\"");
				writer.append(',');
				writer.append("\""+checkNullAndTrim(rs.getString(2))+"\"");
				writer.append('\n');
				//Changed by Samadhan D14HKAT002 on 10/06/2015 from upload file on katdev.com. end
			}		
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt !=null)
			{
				pstmt.close();
				pstmt = null;
			}
	
			writer.flush();
			writer.close();		
		// Changed by Sneha on 11-03-2016, added try, catch and finally  block [Start]
		}
		
		catch(Exception e)
		{
			System.out.println("Exception in generateCsvFile ::::::::::: " + e);
			e.printStackTrace();
			throw new Exception(e);
		}
		finally
		{
			if(rs!=null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
		}
		// Changed by Sneha on 11-03-2016, added try, catch and finally  block [End]

	}
	//Changed by Samadhan D14HKAT002 on 10/06/2015 from upload file on katdev.com. start
	/* 
	private  void putFile(String username, String host, String password, String remotefile, String localfile)
	{
		JSch jsch = new JSch();
		Session session = null;
		try {
			System.out.println("inside put file");
			System.out.println("user name: ["+username+"]password["+password+"]host["+host+"]");
			
			
			System.out.println("putFile success...........");
			session = jsch.getSession(username, host, 21);
			session.setConfig("StrictHostKeyChecking", "no");
			session.setPassword(password);
			session.connect();			
			Channel channel = session.openChannel("sftp");
			channel.connect();
			System.out.println("channel success...........");
			ChannelSftp sftpChannel = (ChannelSftp) channel;
			sftpChannel.put(localfile, remotefile);
			System.out.println("The first file is uploaded successfully.");
			sftpChannel.exit();
			session.disconnect();
		} catch (JSchException e) {
			e.printStackTrace();  
		} catch (SftpException e) {
			e.printStackTrace();
		}
	}
	*/
	private  void putFileFTP(String username, String host, String password, String remotefile, String localfile,int port)
	{
		 FTPClient ftpClient = new FTPClient();
		 System.out.println("preparing the host information for ftp.");
	        try 
	        {
	        	System.out.println("Remote File: "+remotefile);
	        	System.out.println("Local File: "+localfile);
	            ftpClient.connect(host, port);
	            showServerReply(ftpClient);
	            int replyCode = ftpClient.getReplyCode();
	            //Changed by Samadhan for getting file upload status using DDSalesConfig.xml
	            boolean uploadStatus= false;
	            if (!FTPReply.isPositiveCompletion(replyCode)) 
	            {
	                System.out.println("Operation failed. Server reply code: " + replyCode);
	                return;
	            }
	            boolean success = ftpClient.login(username, password);
	            showServerReply(ftpClient);
	            ftpClient.setFileType(FTP.BINARY_FILE_TYPE);
	            ftpClient.enterLocalPassiveMode();
	            if (!success) 
	            {
	                System.out.println("Could not login to the server");
	                return;
	            } 
	            else 
	            {
	                System.out.println("LOGGED IN SERVER");
	   
	                File firstLocalFile = new File(localfile);
	                InputStream inputStream = new FileInputStream(firstLocalFile);
	                //Changed by Samadhan for getting file upload status using DDSalesConfig.xml
	                //ftpClient.storeFile(remotefile, inputStream);
	                uploadStatus = ftpClient.storeFile(remotefile, inputStream);
	                inputStream.close();
	                
	                if (ftpClient.isConnected()) 
	                {
	                    ftpClient.logout();
	                    ftpClient.disconnect();
	                }
	                //Changed by Samadhan for getting file upload status using DDSalesConfig.xml Start
	                //System.out.println("File Uploaded successfully");
	                System.out.println("File Uploaded Status:"+uploadStatus);
	                if(uploadStatus)
	                {
	                	System.out.println("File Uploaded successfully");
	                }
	                else
	                {
	                	System.out.println("File can't Uploaded successfully");
	                }
	                //Changed by Samadhan for getting file upload status using DDSalesConfig.xml End
	            }
	        } 
	        catch (IOException ex) 
	        {
	            System.out.println("Oops! Something wrong happened");
	            ex.printStackTrace();
	        }	
	}
	private static void showServerReply(FTPClient ftpClient) 
	{
		String[] replies = ftpClient.getReplyStrings();
		if (replies != null && replies.length > 0) 
		{
			for (String aReply : replies) 
			{
				System.out.println("SERVER: " + aReply);
			}
		}
	}
	
	public String checkNullAndTrim(String input)
	{
		if (input == null || "null".equalsIgnoreCase(input))
		{
			input= "";
		}
		return input.trim();
	}
	// Changed by Samadhan D14HKAT002 on 10/06/2015 from upload file on katdev.com. end
	private void setDDSalesConfig()
	{
		CommonConstants objCommon =new CommonConstants();
		E12GenericUtility genericUtility=new E12GenericUtility();
		String fileName = null,xmlString = "";
		Document dom=null;
		String sCurrentLine = "";
		String xmlFile="DDSalesConfig";
		System.out.println("  in setDDSalesConfig -------------------------");
		String xmlFileName = CommonConstants.APPLICATION_CONTEXT + "setting" + File.separator + "DDSalesConfig.xml";
		//fileName = ".." + File.separator + "setting" + File.separator + xmlFile + ".xml";
		StringBuilder sb = new StringBuilder();
		System.out.println("xmlFileName-->>["+xmlFileName+"]");          
		try 
		{ 
			BufferedReader br = new BufferedReader(new FileReader(xmlFileName));
			while (( sCurrentLine = br.readLine()) != null)
			{
				sb.append(sCurrentLine);
			}
			xmlString =sb.toString();
			System.out.println("DDSalesConfig xmlString---->>["+xmlString+"]");            	 
			dom = genericUtility.parseString(xmlString);                 
			if(dom != null)
			{                	
				this.csvFileNameUpd = genericUtility.getColumnValue("STOCK_TEMP_UPD_PATH",dom);               	 
				this.hostName = genericUtility.getColumnValue("SFTP_HOST",dom);
				this.username = genericUtility.getColumnValue("SFTP_USER",dom);
				this.password = genericUtility.getColumnValue("SFTP_PWD",dom);	
				//Changed by Samadhan for set remote path using DDSalesConfig.xml Start
				this.remoteFilePath = genericUtility.getColumnValue("SFTP_REMOTE_DIR",dom);
				this.uploadProtocol = genericUtility.getColumnValue("FILE_UPLOAD_PROTOCOL",dom);	
				//Changed by Samadhan for set remote path using DDSalesConfig.xml End
			}                 
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}      
	}
	//Changed by Samadhan D15IKAT004 on 10/12/2015 for SFTP File upload Start
	private  void putFileSFTP(String username, String host, String password, String remoteDestPath, String localFile,int port)
	{
		Session session = null;
		Channel channel = null;
		ChannelSftp channelSftp = null;
		System.out.println("preparing the host information for sftp.");
		try 
		{
			System.out.println("user name: ["+username+"]password["+password+"]host["+host+"]Port["+port+"]");
			System.out.println("Localfile:"+localFile);
			System.out.println("RemotePath:"+remoteDestPath);
			JSch jsch = new JSch();
			session = jsch.getSession(username, host, port);
			session.setPassword(password);
			java.util.Properties config = new java.util.Properties();
			config.put("StrictHostKeyChecking", "no");
			session.setConfig(config);
			session.connect();
			System.out.println("Host connected.");
			channel = session.openChannel("sftp");
			channel.connect();
			System.out.println("sftp channel opened and connected.");
			channelSftp = (ChannelSftp) channel;
			channelSftp.cd(remoteDestPath);
			File f = new File(localFile);
			channelSftp.put(new FileInputStream(f), f.getName());
			System.out.println("File Uploaded successfully");
		} catch (Exception ex) 
		{
			System.out.println("Exception found while Uploading a file.");
			ex.printStackTrace();
		}
		finally
		{
			channelSftp.exit();
			System.out.println("sftp Channel exited.");
			channel.disconnect();
			System.out.println("Channel disconnected.");
			session.disconnect();
			System.out.println("Host Session disconnected.");
		}
	}
	//Changed by Samadhan D15IKAT004 on 10/12/2015 for SFTP File upload End
}
