package ibase.e12ria.e12widgets.client;

import ibase.e12ria.e12widgets.collections.FeedData;

import com.google.gwt.user.client.Command;

public class Feed
{

    protected final FeedData feedData;
    protected final PanelLabel[] feedWidgets;
    protected final Command[] feedCommands;
    
    public static enum FilterMode 
    {
    	MATCH_LIKE, 
    	MATCH_EXACT;
    }
    
    public Feed( FeedData feedData, PanelLabel[] feedWidgets )
    {
        if( feedData == null )
        {
            throw new NullPointerException( "<feedData> is null" );
        }
        if( feedWidgets == null )
        {
            throw new NullPointerException( "<feedWidgets> is null" );
        }
        if( feedWidgets.length < 1 )
        {
            throw new IllegalArgumentException( "<feedWidgets> size cannot be less than 1" );
        }
        this.feedData = feedData;
        this.feedWidgets = feedWidgets;
        
        feedCommands = new Command[ feedWidgets.length ];
        for( int i = 0; i < feedWidgets.length; i++ )
        {
            feedCommands[ i ] = feedWidgets[ i ].getCommand();
        }
    }
    
    public void setVisible( boolean isVisible )
    {
        for( PanelLabel panelLabel : feedWidgets )
        {
            panelLabel.setVisible( isVisible );
        }
    }
    
    public boolean isVisible()
    {
        for( PanelLabel panelLabel : feedWidgets )
        {
            if( panelLabel.isVisible() )
            {
                return true;
            }
        }
        return false;
    }
    
    public boolean isSelected()
    {
        return match( "selected", "Y" );
    }
    
    public boolean match( String fieldName, String fieldValue )
    {
    	return match( fieldName, fieldValue, FilterMode.MATCH_EXACT );
    }
    
    public boolean match( String fieldName, String fieldValue, FilterMode filterMode )
    {
    	if( "".equals( fieldValue ) )
    	{
    		return true;
    	}
        for( String feedDataFieldName : feedData.keySet() )
        {
            String feedDataFieldValue = feedData.get( feedDataFieldName );
            boolean conditionResult = false;
        	switch (filterMode)
        	{
        	case MATCH_EXACT:
        		conditionResult = feedDataFieldValue.equals( fieldValue );
        		break;
        	case MATCH_LIKE: 
        		conditionResult = feedDataFieldValue.toUpperCase().indexOf( fieldValue.toUpperCase() ) != -1;
        		break;
        	}
            if( feedDataFieldName.equals( fieldName ) && feedDataFieldValue != null &&  conditionResult )
            {
                return true;
            }
        }
        return false;
    }
    
    public void setEnabled( boolean isEnabled )
    {
        for( int i = 0; i < feedWidgets.length; i++ )
        {
            feedWidgets[ i ].setCommand( isEnabled ? feedCommands[ i ] : null );
        }
    }
    
    public void execute( int index )
    {
        feedCommands[ index ].execute();
    }
    
    public PanelLabel getFeedWidget( int index) {
    	try
    	{
    		return feedWidgets[index];
    	}
    	catch (Exception e) {
    		return null;
		}
	}

}

