package ibase.webitm.utility.wms;

import ibase.scheduler.utility.interfaces.Schedule;
import ibase.system.config.ConnDriver;
import ibase.utility.CommonConstants;
import ibase.webitm.bean.wms.Product;
import ibase.utility.E12GenericUtility;
import ibase.webitm.utility.wms.CommonWmsUtil;
import ibase.webitm.ejb.ValidatorEJB;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Random;

import org.w3c.dom.Document;

public class MagentoProductSchedule implements Schedule
{
	
	private String apiSimpleUrl = "",apiConfigUrl = "",loginSite = ""; 	
	CommonWmsUtil commonutility = new CommonWmsUtil();
	boolean isError = false;
	public String schedulePriority( String wrkflwPriority )throws Exception
	{
		return "";
	}
	public String schedule(HashMap map)throws Exception
	{
		return "";//
	}
	public String schedule(String scheduleParamXML)throws Exception
	{
		isError = false;
		System.out.println("calling schedule MagentoProductSchedule@..................");
		Connection conn = null;
		ConnDriver connDriver = null;		
		String tranDate="",fileName = "Stock.csv";
		Document dom = null;
		try
		{	
			
			CommonConstants.setIBASEHOME();	
			
			setDDSalesConfig();
			connDriver = new ConnDriver();
			conn = connDriver.getConnectDB("DriverITM");
			connDriver = null;
			E12GenericUtility genericUtility = new E12GenericUtility();
			Calendar currentDate = Calendar.getInstance();
			SimpleDateFormat simpleDateFormat = new SimpleDateFormat(genericUtility.getApplDateFormat());
			tranDate = simpleDateFormat.format(currentDate.getTime());	
			
			dom = new ValidatorEJB().parseString(scheduleParamXML);
			if(dom != null)
			{
				loginSite = checkNull(genericUtility.getColumnValue("siteCode", dom));				
			}
			
			
			updateMagentoProducts(this.apiSimpleUrl,this.apiConfigUrl,conn);
			//createParent(conn);
			
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		finally
		{
			System.out.println("in Finally isError---->>"+isError);
			if(isError)
			{
				conn.rollback();				
			}
			else
			{
				conn.commit();
			}
			
			if(conn != null)
			{
				conn.close();
				conn = null;
			}
		}
		return "";
	}
	
	private void updateMagentoProducts(String apiSimpleURL,String apiConfigURL,Connection conn)
	{	
		System.out.println("--------updateMagentoProducts12------------------");
		String sSQL = "";
		ResultSet rsParent = null;
		ResultSet rsSku = null;
		PreparedStatement pstmtParent = null;
		PreparedStatement pstmtSku = null;
		String simpleSku = "Product0001";
		int udfNumParent = 0;
        String configSku = "Product0002";
        //Product objProducts = null;
		
		try
		{
			/*sSQL = "SELECT ITEM_CODE,UDF_NUM FROM ITEM WHERE ITEM_PARNT IS NULL  AND "
					+ "(UDF_NUM  IS NULL OR UDF_NUM = 0)  ";*/
					
			sSQL = "SELECT * FROM ITEM A WHERE ITEM_PARNT IS NULL "
					+" AND (SELECT COUNT(*) FROM ITEM WHERE ITEM.ITEM_PARNT = A.ITEM_CODE AND UDF_NUM IS NULL) > 0 ";

			pstmtSku = conn.prepareStatement(sSQL);
			rsParent = pstmtSku.executeQuery();
			//for parent iteration
			while(rsParent.next()) 
			{
				simpleSku = checkNull((String)rsParent.getString("ITEM_CODE"));
				udfNumParent = rsParent.getInt("UDF_NUM");	
				getProductList(simpleSku, udfNumParent, conn);
			}

		}
		catch(Exception e)
		{
			isError =true;
			e.printStackTrace();
		}
		
	}
	
	
	private void getProductList(String itemCodec,int udfNum, Connection conn) throws Exception
	{
		List<Integer> simpleProductIdCollection = new ArrayList<Integer>();
		ArrayList<Double> parentMaxPrice = new ArrayList<Double>();
		Product objProductsParent = new Product();
		Product objProductsChild = null;
		ResultSet rs = null,rs1= null;
		PreparedStatement pstmt = null, pstmt1 = null;
		double rate = 0,grossWeight = 0;
		String sql = "",sql1="",phyAttribute2 = "",udfCategory = "",categoryId = "",colorId = "",manufacturerId = "",
				suppCode="",itemCodeParent = "",itemCodeDescrP = "",itemCodeSDescrP = "",itemCodeChild = "",
				itemCodeDescrC = "",itemCodeSDescrC = "",phyAttrib17="",phyAttrib18 ="",countCodeMfg = "",sizeStrGen = "",
				phyAttrib19 ="",phyAttrib20 ="",phyAttrib21 ="",categoty = "",dimensionStr = "",sizeStr = "";
		int simpleProductId = 0,dimension = 0;	
		try
		{			
			sql = "SELECT ITEM_CODE,DESCR,SH_DESCR,PHY_ATTRIB_17,COUNT_CODE__MFG,PHY_ATTRIB_18,"
					+ "PHY_ATTRIB_19,PHY_ATTRIB_20,PHY_ATTRIB_21,GROSS_WEIGHT,DIMENSION  "
					+ " FROM ITEM WHERE ITEM_CODE = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, itemCodec);
			rs = pstmt.executeQuery();

			if (rs.next())
			{			
				itemCodeParent = checkNull(rs.getString("ITEM_CODE"));					
				itemCodeDescrP = checkNull(rs.getString("DESCR"));
				itemCodeSDescrP  = checkNull(rs.getString("SH_DESCR"));

				countCodeMfg = checkNull(rs.getString("COUNT_CODE__MFG"));
				phyAttrib17 = checkNull(rs.getString("PHY_ATTRIB_17"));
				phyAttrib18 = checkNull(rs.getString("PHY_ATTRIB_18"));
				phyAttrib19 = checkNull(rs.getString("PHY_ATTRIB_19"));
				phyAttrib20 = checkNull(rs.getString("PHY_ATTRIB_20"));
				phyAttrib21 = checkNull(rs.getString("PHY_ATTRIB_21"));
				grossWeight = rs.getDouble("GROSS_WEIGHT");
				dimension = rs.getInt("DIMENSION");			
				
							
				
				//child start

				/*sql = "SELECT I.ITEM_CODE,P.RATE,I.PHY_ATTRIB_2,I.UDF__STR2,S.SUPP_CODE,I.DESCR,I.SH_DESCR,"
						+ "I.PHY_ATTRIB_17,I.COUNT_CODE__MFG,I.PHY_ATTRIB_18,I.PHY_ATTRIB_19,I.PHY_ATTRIB_20,I.PHY_ATTRIB_21,"
						+ "I.GROSS_WEIGHT,I.DIMENSION "
						+ " FROM ITEM I,SUPPLIERITEM S,PRICELIST P WHERE I.ITEM_PARNT = ? "
						+ "AND I.ITEM_CODE = S.ITEM_CODE AND I.ITEM_CODE = P.ITEM_CODE "
						+ " AND (I.UDF_NUM  IS NULL OR I.UDF_NUM = 0)";*/
				
				sql = "SELECT I.ITEM_CODE,P.RATE,I.PHY_ATTRIB_2,I.PHY_ATTRIB_23,S.SUPP_CODE,I.DESCR,I.SH_DESCR,I.PHY_ATTRIB_17,"
						+"SP.COUNT_CODE,I.PHY_ATTRIB_18,I.PHY_ATTRIB_19,I.PHY_ATTRIB_20,I.PHY_ATTRIB_21,"
						+ "I.GROSS_WEIGHT,I.PHY_ATTRIB_3,I.PHY_ATTRIB_1  "  
						+"FROM ITEM I,SUPPLIERITEM S,PRICELIST P ,SUPPLIER SP "
						+"WHERE I.ITEM_PARNT = ? "
						+"AND I.ITEM_CODE = S.ITEM_CODE " 
						+"AND I.ITEM_CODE = P.ITEM_CODE "  
						+"AND P.PRICE_LIST = SP.PRICE_LIST "
						+"AND SP.SUPP_CODE = S.SUPP_CODE "
						+"AND (I.UDF_NUM  IS NULL OR I.UDF_NUM = 0)";
				pstmt1 = conn.prepareStatement(sql);
				pstmt1.setString(1, itemCodeParent);
				rs1 = pstmt1.executeQuery();

				while (rs1.next())
				{						
					itemCodeChild = checkNull(rs1.getString("ITEM_CODE"));					
					rate = rs1.getDouble("RATE");
					phyAttribute2 = checkNull(rs1.getString("PHY_ATTRIB_2"));					
					colorId = checkNull(getGencodesValue("UDF_STR1",phyAttribute2, "COLOR_CODE", conn));					
					System.out.println("colorId------>>["+colorId+"]");
					colorId = colorId.length() == 0 ? "0" : colorId;
					udfCategory = checkNull(rs1.getString("PHY_ATTRIB_23"));
					System.out.println("udfCategory---->>"+udfCategory);					
					String [] id = udfCategory.split(",");
					categoty ="";
					for(String str : id)
					{						
						categoryId = checkNull(getGencodesValue("FLD_VALUE",checkNull(str), "CATEGORY", conn));
						categoty = categoty + categoryId+",";
						//categoty = categoty + str;
					}
					categoty = categoty.substring(0 ,categoty.length() -1);
					//categoryId = checkNull(getGencodesValue(udfCategory, "CATEGORY", conn));
					System.out.println("categoty------>>["+categoty+"]");
					suppCode = checkNull(rs1.getString("SUPP_CODE"));
					itemCodeDescrC = checkNull(rs1.getString("DESCR"));
					itemCodeSDescrC = checkNull(rs1.getString("SH_DESCR"));

					countCodeMfg = checkNull(rs1.getString("COUNT_CODE"));
					phyAttrib17 = checkNull(rs1.getString("PHY_ATTRIB_17"));
					//phyAttrib18 = checkNull(rs1.getString("PHY_ATTRIB_18"));
					//phyAttrib19 = checkNull(rs1.getString("PHY_ATTRIB_19"));
					//phyAttrib20 = checkNull(rs1.getString("PHY_ATTRIB_20"));
					//phyAttrib21 = checkNull(rs1.getString("PHY_ATTRIB_21"));
					grossWeight = rs1.getDouble("GROSS_WEIGHT");
					dimensionStr = rs1.getString("PHY_ATTRIB_3");			 	
					sizeStr = rs1.getString("PHY_ATTRIB_1");
					
					System.out.println("phyAttrib17@---->>["+phyAttrib17+"]");
					System.out.println("phyAttrib18---->>["+phyAttrib18+"]");
					System.out.println("phyAttrib19---->>["+phyAttrib19+"]");
					System.out.println("phyAttrib20---->>["+phyAttrib20+"]");
					System.out.println("phyAttrib21---->>["+phyAttrib21+"]");
					
					System.out.println("sizeStr@@@@---->>["+sizeStr+"]");
					
					objProductsChild = new Product();
					double price = getPriceListRate(suppCode, itemCodeChild, conn);
					parentMaxPrice.add(price);
					objProductsChild.setCost(price);//-------------------------
					objProductsChild.setStoreId(0);
					objProductsChild.setColorId(Integer.parseInt(colorId));	
					objProductsChild.setTaxClass(2);
					sizeStrGen = checkNull(getGencodesValue("UDF_STR1",sizeStr,"", conn));
					 sizeStrGen = sizeStrGen.length() == 0 ? "0" : sizeStrGen;
					 System.out.println("sizeStrGen@@------------>>["+sizeStrGen+"]");					 
					objProductsChild.setProductSizeId(Integer.parseInt(sizeStrGen)); //4.5	
					
					String dimension1 = checkNull(getGencodesValue("UDF_STR1",dimensionStr, "DIMENSION", conn));
					dimension1 = dimension1.length() == 0 ? "0" : dimension1;
					dimension = Integer.parseInt(dimension1);
					 System.out.println("dimension@@------------>>["+dimension+"]");		
					objProductsChild.setProductDimensionId(dimension); //MEDIUM				
					objProductsChild.setImagePath("");//phy_attrib_17					
					objProductsChild.setLongDescription(phyAttrib18);//.phy_attrib_18			        
					objProductsChild.setCategories(categoty);	
					
					manufacturerId = getColumnDescr(conn,"udf_1","supplier","supp_code",suppCode);		        
					manufacturerId = manufacturerId.length() == 0 ? "0" :manufacturerId;
					objProductsChild.setManufacturerId(Integer.parseInt(manufacturerId));//supplier code
					System.out.println("countCodeMfg------->>["+countCodeMfg+"]");
					objProductsChild.setManufacturerCountryCode(countCodeMfg); //count_code__mfg

					objProductsChild.setMetaDescription(phyAttrib19); //.phy_attrib_19
					objProductsChild.setMetaKeywords(phyAttrib20);//phy_attrib_20
					objProductsChild.setMetaTitle(phyAttrib21);//phy_attrib_21
					
					objProductsChild.setPrice(price);	
					System.out.println("Price------------>>["+price+"]");
					objProductsChild.setProductName(itemCodeDescrC);
					objProductsChild.setProductStatus(1);
					objProductsChild.setProductWeight(grossWeight);
					objProductsChild.setQty(5);
					objProductsChild.setShortDescription(itemCodeSDescrP);
					objProductsChild.setSku(itemCodeChild);		
					
					
					
					/*objProductsChild.setStoreId(1);
					objProductsChild.setTaxClass(2);*/


					int simpleId =  commonutility.Call(objProductsChild,this.apiSimpleUrl, null);
					System.out.println("simpleId child---->>["+simpleId+"]");					
					if(simpleId != 0)
					{
						simpleProductIdCollection.add(simpleId);
						updateItemUdfNum(itemCodeChild,simpleId,conn);
					}
				} //end child while
				
				
				System.out.println("simpleProductId Parent@------>>["+simpleProductId+"]");
				System.out.println("simpleProductIdCollection Parent------>>["+simpleProductIdCollection+"]");
				if(simpleProductIdCollection !=null && ! simpleProductIdCollection.isEmpty())
				{
					System.out.println("itemCodec Parent@------>>["+itemCodec+"] itemCodeDescrP--->>"+itemCodeDescrP);
					System.out.println("parentMaxPrice parentMaxPrice@------>>["+parentMaxPrice+"]");
					objProductsChild.setProductName(itemCodeDescrP);					
					objProductsChild.setSku(itemCodec);
					double objMaxPrice = Collections.max(parentMaxPrice);
					objProductsChild.setPrice(objMaxPrice);
					
					simpleProductId = commonutility.Call(objProductsChild,this.apiConfigUrl, simpleProductIdCollection);
					//simpleProductIdCollection.add(simpleProductId);
					updateItemUdfNum(itemCodeParent,simpleProductId,conn);
				}
				
				if(rs1!=null)
				{
					rs1.close();
					rs1 = null;
				}
				if(pstmt1!=null)
				{
					pstmt1.close();
					pstmt1 = null;
				}

				//Child End
			}

			if(rs != null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
		}
		catch(Exception e)
		{
			isError = true;
			e.printStackTrace();
			throw new Exception(e);
		}

		//return objProducts ;

	}
	
	private void updateItemUdfNum(String itemCode,int simpleProductId,Connection conn) throws Exception
	{
		String sql = "";
		int count = 0;
		PreparedStatement pstmt = null;
		try
		{
			sql = "update item set udf_num = ? where item_code = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setInt(1, simpleProductId);
			pstmt.setString(2, itemCode);
			count = pstmt.executeUpdate();
			// Changed by Sneha on 12-09-2016, for Closing the Open Cursor [Start]
			if ( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}
			// Changed by Sneha on 12-09-2016, for Closing the Open Cursor [End]
		}
		catch(Exception e)
		{
			isError = true;
			throw new Exception(e);
		}

	}
	private double getPriceListRate(String suppCode,String itemCode,Connection conn) throws Exception
	{
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		String sql = "",supplierPriceList = "",pricelist = "";
		double rate = 0;
		loginSite = loginSite == null ? "" : loginSite.trim();
		suppCode = suppCode == null ? "" : suppCode.trim();
		System.out.println("getPriceListRate loginSite------>["+loginSite+"]");
		try
		{	
			supplierPriceList=checkNull(getColumnDescr(conn, "price_list", "supplier", "supp_code", suppCode));
			System.out.println("getPriceListRate supplierPriceList------>["+supplierPriceList+"]");
			
			sql ="SELECT DESCR FROM GENCODES WHERE MOD_NAME = ? AND FLD_NAME = ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, "W_DD_PRODUCTWIZ");
			pstmt.setString(2, "SITE_PRICE");
			//pstmt.setString(3, loginSite);
			
			rs = pstmt.executeQuery();
			
			while(rs.next())
			{				
				pricelist = checkNull(rs.getString(1));
				System.out.println("pricelist while------>>["+pricelist+"]");				
				if(!(supplierPriceList.equalsIgnoreCase(pricelist)) )
				{
					break;
				}
			}
			rs.close();
			rs= null;
			pstmt.close();
			pstmt = null;
			System.out.println("getPriceListRate pricelist------>["+pricelist+"]");
			
			
			sql = "SELECT RATE FROM PRICELIST WHERE PRICE_LIST = ? AND ITEM_CODE = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, pricelist);
			pstmt.setString(2, itemCode);
			
			rs = pstmt.executeQuery();
			
			if(rs.next())
			{
				rate = rs.getDouble(1);
			}
			rs.close();
			rs= null;
			pstmt.close();
			pstmt = null;
		}
		catch(Exception e)
		{
			isError = true;
			throw new Exception(e);
		}
		System.out.println("getPriceListRate rate------>["+rate+"]");
		return rate;
	}
	private String getGencodesValue(String selectColumn,String descr,String fldName,Connection conn) throws Exception
	{	
		//("UDF_STR1",sizeStr,"", conn));
		ResultSet rs = null;
		PreparedStatement pstmt =null;
		String sql = "",udfStr1 = "";

		try
		{
			fldName = fldName == null ? "" :fldName.trim();
			if(fldName.length() > 0)
			{
				sql ="select "+selectColumn+" from gencodes where mod_name = ? and fld_name = ? and descr = ?";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, "W_DD_PRODUCTWIZ");
				pstmt.setString(2, fldName);
				pstmt.setString(3, descr);
			}
			else
			{
				sql ="select "+selectColumn+" from gencodes where mod_name = ? and  descr = ?";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, "W_DD_PRODUCTWIZ");				
				pstmt.setString(2, descr);
			}
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				udfStr1 = rs.getString(1);			
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
		}
		catch(Exception e)
		{
			isError = true;
			throw new Exception(e);
		}
		return udfStr1;

	}
	
	public String getColumnDescr(Connection conn, String columnName ,String tableName, String columnName2, String value)throws Exception 
	{
		PreparedStatement pstmt = null ;
		ResultSet rs = null ; 
		String sql = "";
		String findValue = "";

		sql = "SELECT " + columnName + " from " + tableName + " where " + columnName2 +"= ?";
		pstmt = conn.prepareStatement(sql);
		pstmt.setString(1,value);
		rs = pstmt.executeQuery();
		if(rs.next())
		{					
			findValue = rs.getString(1);					
		}
		rs.close();
		rs = null;
		pstmt.close();
		pstmt = null;        


		System.out.println("returning String from getColumnDescr " + findValue);
		return checkNull(findValue);

	}
	private void setDDSalesConfig()
	{
		CommonConstants objCommon =new CommonConstants();
		E12GenericUtility genericUtility=new E12GenericUtility();
		String fileName = null,xmlString = "",xmlFileName = "";
		Document dom=null;
		String sCurrentLine = "";
		String xmlFile="DDSalesConfig";
		System.out.println("  in setDDSalesConfig -------------------------");
		System.out.println("CommonConstants.APPLICATION_CONTEXT-->>["+CommonConstants.APPLICATION_CONTEXT+"]");   
		System.out.println("CommonConstants.JBOSSHOME-->>["+CommonConstants.JBOSSHOME+"]");   
		if(CommonConstants.APPLICATION_CONTEXT != null)
		{
			xmlFileName = CommonConstants.APPLICATION_CONTEXT + "setting" + File.separator + "DDSalesConfig.xml";
		}
		else
		{
			xmlFileName = CommonConstants.JBOSSHOME + File.separator + "server" + File.separator + "default" + File.separator + "deploy" + File.separator + "ibase.ear" + File.separator + "ibase.war" + File.separator +"setting" + File.separator +"DDSalesConfig.xml";
		}
		
		//fileName = ".." + File.separator + "setting" + File.separator + xmlFile + ".xml";
		StringBuilder sb = new StringBuilder();
		System.out.println("xmlFileName-->>["+xmlFileName+"]");          
		try 
		{ 
			BufferedReader br = new BufferedReader(new FileReader(xmlFileName));
			while (( sCurrentLine = br.readLine()) != null)
			{
				sb.append(sCurrentLine);
			}
			xmlString =sb.toString();
			System.out.println("DDSalesConfig xmlString---->>["+xmlString+"]");            	 
			dom = genericUtility.parseString(xmlString);                 
			if(dom != null)
			{                	
				this.apiSimpleUrl = genericUtility.getColumnValue("PROD_SIMPLE_API_URL",dom);               	 
				this.apiConfigUrl = genericUtility.getColumnValue("PROD_CONFIG_API_URL",dom);		
			}                 
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}      
	}
	private String checkNull(String input) 
	{
		if(input == null)
		{
			input = "";
		}
		return input.trim();
	}

}
