/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package ibase.webitm.ejb.sys;
import java.rmi.RemoteException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.*;
import ibase.system.config.ConnDriver;
import ibase.utility.GenericUtility;
import ibase.webitm.ejb.*;
import java.sql.*;
import ibase.webitm.utility.ITMException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import javax.ejb.Stateless;
import java.util.Date;
import java.util.HashMap;
import java.util.Vector;
import ibase.system.config.AppConnectParm;
import javax.naming.InitialContext;
import org.apache.axis.client.Call;
import org.apache.axis.client.Service;
import org.apache.axis.encoding.XMLType;
import javax.xml.rpc.ParameterMode;
import ibase.utility.UserInfoBean;

/**
 *
 * @author msharma
 */
 @Stateless
public class LoadBatch extends ActionHandlerEJB implements LoadBatchLocal,LoadBatchRemote
{
    public String actionHandler(String tranId, String xtraParams, String forcedFlag) throws RemoteException, ITMException
    {
       String errString=null;
	   Connection conn=null;
       ConnDriver ConnDriver = new ConnDriver();
       PreparedStatement pstmt=null,pstmt1=null;
       ResultSet rs=null;
	   String loadStat="";

       System.out.println("tranId----"+tranId);
	   try
	   {
	   //changes and commented by sarita for DBConnection on 01/06/2017 :START   
	   //conn = ConnDriver.getConnectDB("DriverITM");
       //conn.setAutoCommit(false);
	   conn = getConnection();
       //changes and commented by sarita for DBConnection on 01/06/2017 :END
       ITMDBAccessEJB itmDBAccess = new ITMDBAccessEJB();
       System.out.println("xtraParams----"+xtraParams);
       System.out.println("forcedFlag----"+forcedFlag);
	   tranId=tranId.substring(0,tranId.indexOf(":"));
	   tranId=tranId.trim();
       if(tranId!=null || tranId.trim().length()>0)
       {
	       pstmt=conn.prepareStatement("select load_stat from batchload where batch_id=?");
		   pstmt.setString(1,tranId);
		   rs=pstmt.executeQuery();
		   if(rs.next())
		   {
		    loadStat=rs.getString(1);
		   }
		   if(rs!=null)
		   {
		   rs.close();
		   rs=null;
		   }
		   if(pstmt!=null)
		   {
		   pstmt.close();
		   pstmt=null;
		   }
		   if(loadStat.equalsIgnoreCase("N"))
		   {
	          errString=AppBatch(tranId,xtraParams,forcedFlag);
		   }
		   else
		   {
		     System.out.println("Batch Load:errCode:"+"VTLOBATCH");
             errString = itmDBAccess.getErrorString("","VTLOBATCH","");
             System.out.println("errString:"+errString+":");
		   }
       }
	   }catch(Exception e)
	   {
	    e.printStackTrace();
	   }
	   finally
	   {
		 if(conn!=null)
           {
                try {
                    conn.close();
                    conn = null;
                } catch (SQLException ex)
                {
                    ex.printStackTrace();
                }
           }
	   }
       return errString;
   }
     String AppBatch(String tranId,String xtraParams,String forcedFlag)
    {
	   String errString="";
	   UserInfoBean userInfo=null;
	   MasterApplyEJBLocal masterAppLocal=null;
	   try
	   {
	   masterAppLocal =getComponent("MasterApplyEJB");
	   userInfo=new UserInfoBean();
	   masterAppLocal.applyMasterTable(tranId,xtraParams,userInfo);
	   }catch(Exception e)
	   {
	   e.printStackTrace();
	   }
	   
        return errString;
    }
	private MasterApplyEJBLocal getComponent( String EjbComponent) throws ITMException
	{
		InitialContext ctx = null;
		MasterApplyEJBLocal masterAppLocal = null; // for ejb3
		try
		{
			AppConnectParm appConnect = new AppConnectParm();
			ctx = new InitialContext(appConnect.getProperty());
			System.out.println("************InitialContext ctx = *******************************************");
			masterAppLocal = (MasterApplyEJBLocal)ctx.lookup("ibase/" +EjbComponent +"/local");
			System.out.println("************ masterAppLocal = *******************************************");
		}
		catch(ITMException itme)
		{
			System.out.println("ITMException :EjbComponent : getComponent :==>");
			throw itme;
		}
		catch(Exception e)
		{
			System.out.println("Exception :getComponent : getComponent :==>");
			throw new ITMException(e);
		}
		return masterAppLocal;
	}

}