/********************************************************
Title 	 : BankGauranteeAmdIC [F15DSUN031]
Date  	 : 10/AUG/15
Developer: Priyanka Shinde.
********************************************************/
package ibase.webitm.ejb.fin;

import ibase.system.config.ConnDriver;
import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.ValidatorEJB;
//import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;

import javax.ejb.Stateless;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Stateless
public class BankGauranteeAmdIC extends ValidatorEJB implements BankGauranteeAmdICLocal, BankGauranteeAmdICRemote
{
	E12GenericUtility genericUtility = new E12GenericUtility();

	//method for validation
	public String wfValData(String xmlString, String xmlString1, String xmlString2, String objContext, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		String errString = "";
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		try
		{
			System.out.println("Val xmlStrling :: " + xmlString);
			System.out.println("Val xmlString1 :: " + xmlString1);
			System.out.println("Val xmlString2 :: " + xmlString2);
			dom = parseString(xmlString);
			dom1 = parseString(xmlString1);
			dom2 = parseString(xmlString2);
			errString = wfValData(dom, dom1, dom2, objContext, editFlag, xtraParams);
	
		}
		catch(Exception e)
		{
			throw new ITMException(e);
		}
		return(errString);
	}

	public String wfValData(Document dom, Document dom1, Document dom2, String objContext, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		NodeList parentNodeList = null;
		NodeList childNodeList = null;	
		Node parentNode = null;
		Node childNode = null;
		String errorType = "";
		String childNodeName = null;
		String errString = "";
		String errCode = "";
		String userId = "";
		String sql = "",sql1="";
		String siteCode = "",siteCodeFor="";
		String purcOrder="";
		String keyFlag="",tranId="",noOfDays="",currCode="",tranDateStr="",dueDateStr="",effDateStr="";
		String currDate="";
		Date dueDate=null,tranDate=null,effDate=null,currentDate=null;
		String tranIdLC="";
		SimpleDateFormat sdf = null;
		Timestamp duedt=null,	timestamp = null,trandt=null,effdt=null,currDt=null,tranDateTs=null;
		String confirmed="",status="";
		int ctr=0,noDays=0;
		int cnt = 0,cnt1=0;
		int currentFormNo = 0;
		int childNodeListLength;
		String prdCode="",statFin="";
String siteCodlogin="";
		ArrayList<String> errList = new ArrayList<String>();
		ArrayList<String> errFields = new ArrayList<String>();
		Connection conn = null;
		PreparedStatement pstmt = null,pstmt1=null;
		ResultSet rs = null,rs1=null;
		String lcAmt="";
		double lcAmtVal=0;
		String bankNameIss="",bankAdd="";
		ConnDriver connDriver = new ConnDriver();
		StringBuffer errStringXml = new StringBuffer("<?xml version = \"1.0\"?> \r\n <Root> <Errors>"); 
		try
		{
			//Changes and Commented By Bhushan on 06-06-2016 :START
//conn = connDriver.getConnectDB("DriverITM");
conn = getConnection();
//Changes and Commented By Bhushan on 06-06-2016 :END
			userId = getValueFromXTRA_PARAMS(xtraParams, "loginCode");
			sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			timestamp = new Timestamp(System.currentTimeMillis());
			currDate = (sdf.format(timestamp).toString()).trim();
			System.out.println("Current Date>>>>>>>>>"+currDate);
			siteCodlogin =(genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginSiteCode"));
			if(objContext != null && objContext.trim().length() > 0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			switch(currentFormNo)
			{
			case 1 :
				parentNodeList = dom.getElementsByTagName("Detail1");
				parentNode = parentNodeList.item(0);
				childNodeList = parentNode.getChildNodes();
				childNodeListLength = childNodeList.getLength();
				for(ctr = 0; ctr < childNodeListLength; ctr ++)
				{
					childNode = childNodeList.item(ctr);
					childNodeName = childNode.getNodeName();
					
					if(childNodeName.equalsIgnoreCase("tran_id"))
					{  
						sql="select key_flag from transetup where tran_window='w_bg_amend'";
						pstmt=conn.prepareStatement(sql);
						rs=pstmt.executeQuery();
						if(rs.next())
						{
							keyFlag=rs.getString("key_flag");
							System.out.println("Key Flag>>>>>>>>>"+keyFlag);
						}
						rs.close();
						rs = null;
						pstmt.close();
						pstmt = null;
											
						//if(keyFlag.equalsIgnoreCase("M") && editFlag. )
						if("M".equalsIgnoreCase(keyFlag) && "A".equalsIgnoreCase(editFlag))
						{
							tranId= genericUtility.getColumnValue("tran_id", dom);
							System.out.println("Tran Id:>>"+tranId);
							if(tranId == null || (tranId.length() == 0))
							{
								errList.add("VMTRANID");
								errFields.add(childNodeName.toLowerCase());
							}
							else
							{
								
								sql="select count(1) from lc_voucher_amend where tran_id= ? ";
								pstmt=conn.prepareStatement(sql);
								pstmt.setString(1,tranId);
								rs=pstmt.executeQuery();
								if(rs.next())
								{
									cnt =  rs.getInt(1);
									System.out.println("Count>>>>>>>>>"+cnt);
								}
								rs.close();
								rs = null;
								pstmt.close();
								pstmt = null;
								
								if(cnt > 0) 
								{
									System.out.println("Tran Id already exist, please enter another tran id.");
									errCode = "VMTRANIDEX";
									errList.add(errCode);
									errFields.add(childNodeName.toLowerCase());	
								}	
							}
						}
					}
					
					//tran_date
					else if(childNodeName.equalsIgnoreCase("tran_date"))
					{
						tranDateStr = genericUtility.getColumnValue("tran_date",dom);
						tranDateTs = Timestamp.valueOf(genericUtility.getValidDateString(tranDateStr,genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat())+ " 00:00:00.0");
						siteCode = genericUtility.getColumnValue("site_code", dom);
						sql = "Select code from period where ? between fr_date and to_date ";
						pstmt = conn.prepareStatement(sql);
						pstmt.setTimestamp(1, tranDateTs);
						rs = pstmt.executeQuery();
						if (rs.next()) 
						{
							prdCode = rs.getString("code");
							System.out.println("Period Code>>>>>>"+prdCode);
						}
						rs.close();
						rs = null;
						pstmt.close();
						pstmt = null;
						
						if (prdCode != null && prdCode.trim().length() > 0) 
						{
							sql = "Select count(1) from period_stat where prd_code = ? "
									+ " AND site_code = ? ";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, prdCode.trim());
							pstmt.setString(2, siteCodlogin.trim());
							rs = pstmt.executeQuery();
							if (rs.next()) 
							{
								cnt = rs.getInt(1);
								System.out.println("Count for prdCode>>>>>>>>>>"+cnt);
							}
							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;
							
							if (cnt > 0) 
							{
								sql = "Select stat_fin from period_stat where prd_code = ? and site_code = ? ";
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1, prdCode.trim());
								pstmt.setString(2, siteCodlogin.trim());
								rs = pstmt.executeQuery();
								if (rs.next())
								{
									statFin = rs.getString("stat_fin");
									System.out.println("Status Fin>>>>>>>"+statFin);
								}
								rs.close();
								rs = null;
								pstmt.close();
								pstmt = null;
								//if(statFin != null && statFin.equalsIgnoreCase("N"))
								if(statFin != null && "N".equalsIgnoreCase(statFin))
								{																		
									errCode = "VTPRDFIN";
									errList.add(errCode);
									errFields.add(childNodeName.toLowerCase());
									
								}
							} 
							else 
							{
								errCode = "VMSTATSND";
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());
							}
						} 
						else 
						{
							errCode = "VMPRDNTDF";
							errList.add(errCode);
							errFields.add(childNodeName.toLowerCase());
						}
					}
					
					
					else if(childNodeName.equalsIgnoreCase("site_code"))
					{ 
						siteCode = genericUtility.getColumnValue("site_code", dom);
						tranIdLC = genericUtility.getColumnValue("tran_id__lc", dom);
						System.out.println("Site Code >>>>>>>>"+siteCode);
						System.out.println("tranIdLC >>>>>>>>"+tranIdLC);
						if(siteCode == null || siteCode.trim().length()==0)
						{
							errCode = "NULLSITECD";
							errList.add(errCode);
							errFields.add(childNodeName.toLowerCase());
						}
						else
						{
							sql = " select count(1) from site where site_code = ? ";
							pstmt =  conn.prepareStatement(sql);
							pstmt.setString(1,siteCode);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								cnt =  rs.getInt(1);
							}
							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;
							if(cnt == 0) 
							{
								errCode = "VTSITECD1";
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());	
							}
							
							
							sql="select site_code__for from lc_voucher where tran_id=?";
							pstmt =  conn.prepareStatement(sql);
							pstmt.setString(1,tranIdLC);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								siteCodeFor =  rs.getString("site_code__for");
							}
							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;
							
							if(!siteCode.equalsIgnoreCase(siteCodeFor))
							{
								errCode = "VTSITECD3";
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());	
							}
						}
					}
					else if(childNodeName.equalsIgnoreCase("tran_id__lc"))
					{ 
						tranIdLC = genericUtility.getColumnValue("tran_id__lc", dom);
						System.out.println("tranIdLC>>>>>>>>"+tranIdLC);
						if(tranIdLC== null || (tranIdLC.length() == 0))
						{
							errCode = "VTTRANIDLC";//tranIdLc cannot be blank
							errList.add(errCode);
							errFields.add(childNodeName.toLowerCase());
						}
						else
						{
							sql = " select count(1) from lc_voucher where tran_id= ?";
							pstmt =  conn.prepareStatement(sql);
							pstmt.setString(1,tranIdLC);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								cnt =  rs.getInt(1);
							}
							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;
							if(cnt == 0)
							{
								errCode = "VTLCTRAN1";// Transaction Id LC should exist in LC_VOUCHER
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());	
							}
							
							
							sql="select count(1) from lc_voucher where tran_id= ?  and tran_type='B'";
							pstmt =  conn.prepareStatement(sql);
							pstmt.setString(1,tranIdLC);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								
							  cnt1=rs.getInt(1);
							  
							}
							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;
							if(cnt1==0)
							{
								errCode = "VTAMDBG1";// Enter only  TRAN_ID__LC whose tran_type is 'BG'.
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());	
							}
							
							
							sql = " select confirmed,status FROM lc_voucher where tran_id= ? ";
							pstmt =  conn.prepareStatement(sql);
							pstmt.setString(1,tranIdLC);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								
							  confirmed=rs.getString("confirmed");
							  status= rs.getString("status");
							}
							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;
							
							System.out.println("Confirmed====="+confirmed);
							System.out.println("status====="+status);
							
							//if("N".equalsIgnoreCase(confirmed)) ;
							if(confirmed.equalsIgnoreCase("N"))
							{
							System.out.println("Tran Id Lc not confirmed");	
								errCode = "VTTRCONF";//tran_id_lc should be confirmed
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());	
							}
							//if("C".equalsIgnoreCase(status))
							if(status.equalsIgnoreCase("C"))
							{
								errCode = "VTLCTRAN2";//tran_id_lc should not be closed
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());	
							}
								
						}
					}
					//no_days
					else if(childNodeName.equalsIgnoreCase("no_days"))
					{
						noOfDays=genericUtility.getColumnValue("no_days", dom);
						System.out.println("No. of Days>>>>>>>>"+noOfDays);
						if(noOfDays!=null && noOfDays.trim().length() > 0)
						{
							noDays=Integer.parseInt(noOfDays);
							System.out.println("No of Days>>>"+noDays);
						}
						//if(noDays <= 0) //comment by cpatil... for validate only upto two digit
						if(noDays <= 0 || noDays > 99)
						{
							errCode = "VTBGVAL";
							errList.add(errCode);
							errFields.add(childNodeName.toLowerCase());	
						}
					}	
					else if(childNodeName.equalsIgnoreCase("due_date"))
					{
						tranDateStr=(genericUtility.getColumnValue("tran_date", dom));
						System.out.println("Tran Date>>>>>>>>>"+tranDateStr);
						
						dueDateStr=(genericUtility.getColumnValue("due_date", dom));
						System.out.println("Due Date in String>>>>>"+dueDateStr);
						if(dueDateStr==null || (dueDateStr.trim().length()==0))
						{
							System.out.println("Date is null>>>>>>>");
							errCode = "VTCLAIMDT";
							errList.add(errCode);
							errFields.add(childNodeName.toLowerCase());	
						}
						else 
						{						
							
							duedt = Timestamp.valueOf(genericUtility.getValidDateString(dueDateStr, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat()) + " 00:00:00.0");
							trandt = Timestamp.valueOf(genericUtility.getValidDateString(tranDateStr, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat()) + " 00:00:00.0");
							System.out.println("Due date  duedt>>>>>>>>"+duedt);
							System.out.println(" trandt>>>>>>>>"+trandt);
													
							if((duedt!=null &&  trandt!=null) && duedt.before(trandt))
							{
								System.out.println("Due Date < Tran Date  : "+duedt+" < "+trandt);
								errCode = "VTCLAIMDT1";
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());	
							}
						}
					}
					
					//eff_date
					else if(childNodeName.equalsIgnoreCase("eff_date"))
					{
						effDateStr=(genericUtility.getColumnValue("eff_date", dom));
						System.out.println("Eff Date Str>>>>>>>>>"+effDateStr);
						System.out.println("Getting current system date===="+currDate);
						
						if(effDateStr==null || (effDateStr.trim().length()==0))
						{
							System.out.println("Eff Date is null>>>>>>>");
							errCode = "VTSUBDTNUL";//Submission Date cannot be empty
							errList.add(errCode);
							errFields.add(childNodeName.toLowerCase());	
						}
						else //(dueDateStr!=null && (dueDateStr.length() > 0))
						{
							effDate=sdf.parse(effDateStr);
							System.out.println("Eff date >>>>>>>>"+effDate);
							currentDate=sdf.parse(currDate);

							sdf = new SimpleDateFormat(genericUtility.getDBDateFormat());
							effdt = java.sql.Timestamp.valueOf(sdf.format(effDate).toString() + " 00:00:00.0");
							currDt = java.sql.Timestamp.valueOf(sdf.format(currentDate).toString() + " 00:00:00.0");
						if(currDt!=null && effdt!=null)
						{
							//if(currDt.before(effdt))
								if(effdt.before(currDt))
							{
								System.out.println("eff date > Current Date  : "+effdt+" > "+currDt);
								errCode = "VTSUBDT1";//Submission Date should be less than today Date
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());	
							}
						 }
					   }
					}
					else if(childNodeName.equalsIgnoreCase("curr_code"))
					{
						currCode=genericUtility.getColumnValue("curr_code", dom);
						System.out.println("Currency Code>>>>"+currCode);
						if(currCode==null || currCode.trim().length()==0)
						{
							errCode = "VTCURR";
							errList.add(errCode);
							errFields.add(childNodeName.toLowerCase());	
						}
						//if(currCode != null && (currCode.trim().length() > 0))
						else
						{
							sql = " select count(1) from currency where curr_code= ? ";
							pstmt =  conn.prepareStatement(sql);
							pstmt.setString(1,currCode);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								cnt =  rs.getInt(1);
							}
							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;
							if(cnt == 0) 
							{
								errCode = "VTCURRCD1";
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());	
							}	
						}
					}
					
					
					//lc_amt should be gratere than 0
					else if(childNodeName.equalsIgnoreCase("lc_amt"))
					{
						lcAmt=genericUtility.getColumnValue("lc_amt", dom);
						System.out.println("lcAmt(Value)>>>>>>>>"+lcAmt);
						if(lcAmt!=null && lcAmt.trim().length() > 0)
						{
							lcAmtVal=Double.parseDouble(lcAmt);
							System.out.println("lcAmtVal>>>"+lcAmtVal);
						}
						if(lcAmtVal <= 0)
						{
							errCode = "VTBGAMT";
							errList.add(errCode);
							errFields.add(childNodeName.toLowerCase());	
						}
					}
					
					
					
					//bank_name_iss should not be blank
					else if(childNodeName.equalsIgnoreCase("bank_name_iss"))
					{
						bankNameIss=genericUtility.getColumnValue("bank_name_iss", dom);
						System.out.println("Bank Issuing Name>>>>"+bankNameIss);
						if(bankNameIss==null || bankNameIss.trim().length()==0)
						{
							errCode = "VTBGISS";
							errList.add(errCode);
							errFields.add(childNodeName.toLowerCase());	
						}
					
					}
					
					//bank_address should not be blank
					else if(childNodeName.equalsIgnoreCase("bank_address"))
					{
						bankAdd=genericUtility.getColumnValue("bank_address", dom);
						System.out.println("Bank Address>>>>"+bankAdd);
						if(bankAdd==null || bankAdd.trim().length()==0)
						{
							errCode = "VTBGADDR";
							errList.add(errCode);
							errFields.add(childNodeName.toLowerCase());	
						}
					
					}
					
				}			
				break;
			}//end switch
			int errListSize = errList.size();
			cnt = 0;
			String errFldName = null;
			if(errList != null && errListSize > 0)
			{
				for(cnt = 0; cnt < errListSize; cnt ++)
				{
					errCode = errList.get(cnt);
					errFldName = errFields.get(cnt);
					System.out.println("errCode .........." + errCode);
					errString = getErrorString(errFldName, errCode, userId);
					errorType =  errorType(conn , errCode);
					if(errString.length() > 0)
					{
						String bifurErrString = errString.substring(errString.indexOf("<Errors>") + 8, errString.indexOf("<trace>"));
						bifurErrString = bifurErrString + errString.substring(errString.indexOf("</trace>") + 8, errString.indexOf("</Errors>"));
						errStringXml.append(bifurErrString);
						errString = "";
					}
					if(errorType.equalsIgnoreCase("E"))
					{
						break;
					}
				}
				errList.clear();
				errList = null;
				errFields.clear();
				errFields = null;
				errStringXml.append("</Errors> </Root> \r\n");
			}
			else
			{
				errStringXml = new StringBuffer("");
			}
		}//end try
		catch(Exception e)
		{
			e.printStackTrace();
			errString = e.getMessage();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(conn != null)
				{
					if(rs != null) 
					{
						rs.close();
						rs = null;
					}
					if(pstmt != null) 
					{
						pstmt.close();
						pstmt = null;

					}
					conn.close();
				}
				conn = null;
			} 
			catch(Exception d)
			{
				d.printStackTrace();
				throw new ITMException(d);
			}
		}
		errString = errStringXml.toString();
		return errString;
	}//end of validation

	public String itemChanged(String xmlString, String xmlString1, String xmlString2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		System.out.println("XML STRING@@@@@@@@@");
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String valueXmlString = "";
		try
		{   
			if(xmlString!=null && xmlString.trim().length()>0)
			{
				dom = parseString(xmlString);
			}
			
			if(xmlString1!=null && xmlString1.trim().length()>0)
			{
				dom1 = parseString(xmlString1);
			}
			if(xmlString2!=null && xmlString2.trim().length()>0)
			{
				dom2 = parseString(xmlString2);
			}
			System.out.println("XML STRING@@@@@@@@@@@@@!1"+xmlString1);
			
			System.out.println("XML STRING@@@@@@@@@@@@@@@2"+xmlString2);
			valueXmlString = itemChanged(dom, dom1, dom2, objContext, currentColumn, editFlag, xtraParams);
		}
		catch(Exception e)
		{
			System.out.println("Exception : [BankGauranteeAmdIC][itemChanged( String, String )] :==>\n" + e.getMessage());
		}
		System.out.println("valueXmlStringvalueXmlStrin ST"+valueXmlString);
		return valueXmlString;
	}

	public String itemChanged(Document dom, Document dom1, Document dom2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		StringBuffer valueXmlString = new StringBuffer();
		NodeList parentNodeList = null;
		NodeList childNodeList = null;
		Node parentNode = null;
		Node childNode = null;
		SimpleDateFormat sdf =null;
		Timestamp timestamp = null,ordDate=null;
		String currDate="";
		String childNodeName = null;
		String siteCode = "",siteCodeFor="",ordDateStr="";
		String chgUser = "";
		String chgTerm = "";
		String sql = "";
		String siteDescr = "",siteDescrFor="",columnValue="",tranId="";
		String purcOrder="";
		String tranIdLc="";
		String currCode="";
		double exchRate=0,lcAmt=0;
		Date dueDate=null,effDate=null,orddate=null;
		int noOfDays=0;
		String tranType="",bankAdd="";
		String bankNameIss="";
		int ctr = 0;
		int currentFormNo = 0;
		
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		ConnDriver connDriver = new ConnDriver();
		try
		{			 
			System.out.println("@@@@@@@@@@@ itemchange method called for ---->>>>["+currentColumn+"]");
			//Changes and Commented By Bhushan on 06-06-2016 :START
//conn = connDriver.getConnectDB("DriverITM");
conn = getConnection();
//Changes and Commented By Bhushan on 06-06-2016 :END
			conn.setAutoCommit(false);
			connDriver = null;
			sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			timestamp = new Timestamp(System.currentTimeMillis());	
		
			if(objContext != null && objContext.trim().length() > 0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}

			/*siteCode =(genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginSiteCode"));
			siteDescr = findValue(conn, "descr" ,"site", "site_code", siteCode);
			System.out.println("@@@@@@ 1 siteCode["+siteCode+"]::::::siteDescr["+siteDescr+"]");*/
			
			chgUser =(genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginEmpCode"));
			chgTerm =(genericUtility.getValueFromXTRA_PARAMS(xtraParams, "chgTerm"));
			
			System.out.println("Change User====="+chgUser);
			System.out.println("Change Term====="+chgTerm);
			currDate = (sdf.format(timestamp).toString()).trim();
			System.out.println("Current Date>>>>"+currDate);
			
			valueXmlString = new StringBuffer("<?xml version = \"1.0\"?> <Root> <header> <editFlag>");
			valueXmlString.append(editFlag).append("</editFlag> </header>");

			switch(currentFormNo)
			{
			case 1 : 
				parentNodeList = dom.getElementsByTagName("Detail1");
				parentNode = parentNodeList.item(0);
				childNodeList = parentNode.getChildNodes();
				valueXmlString.append("<Detail1>");
				int childNodeListLength = childNodeList.getLength();
			
				if(currentColumn.trim().equalsIgnoreCase("itm_default"))
				{
					System.out.println("@@@@@@  itm_default itemchange called");
					//System.out.println("@@@@@@ siteCode["+siteCode+"]");
					String loginSiteCode = null;
					
					loginSiteCode =(genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginSiteCode")); 
					
					if( loginSiteCode != null && loginSiteCode.trim().length()>0 )
					{
						sql = "select descr from site where site_code= ? ";

						pstmt = conn.prepareStatement( sql );
						pstmt.setString(1,loginSiteCode);
						rs = pstmt.executeQuery();
						if( rs.next() )
						{
							siteDescr = rs.getString( "descr" );
						}	
						rs.close();
						rs = null;
						pstmt.close();
						pstmt = null;

						valueXmlString.append("<tran_date>").append("<![CDATA[" + currDate + "]]>").append("</tran_date>");
						valueXmlString.append("<site_code>").append("<![CDATA[" + ( loginSiteCode != null ? loginSiteCode.trim() : ""  )+ "]]>").append("</site_code>");
						valueXmlString.append("<site_descr>").append("<![CDATA[" + ( siteDescr != null ? siteDescr.trim() : ""  )+ "]]>").append("</site_descr>");	
						valueXmlString.append("<chg_date>").append("<![CDATA["+ currDate+ "]]>").append("</chg_date>");
						valueXmlString.append("<chg_user>").append("<![CDATA["+ chgUser + "]]>").append("</chg_user>");
						valueXmlString.append("<chg_term>").append("<![CDATA["+ chgTerm + "]]>").append("</chg_term>");
						
						valueXmlString.append("<pay_date>").append("<![CDATA[" + currDate + "]]>").append("</pay_date>");
					
					
				     }//end of if
				}
				
				else if(currentColumn.trim().equalsIgnoreCase("site_code"))
				{
					siteCode = genericUtility.getColumnValue("site_code", dom);
					if(siteCode!=null && siteCode.trim().length()>0)
					{
						sql = "select descr from site where site_code= ? ";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1,siteCode);
						rs = pstmt.executeQuery();
						if( rs.next() )
						{
							siteDescr = checkNull(rs.getString( "descr"));
						}	
						
						rs.close();
						rs = null;
						pstmt.close();
						pstmt = null;
						valueXmlString.append("<site_descr>").append("<![CDATA[" + siteDescr+ "]]>").append("</site_descr>");
					}
					else
					{
						valueXmlString.append("<site_descr>").append("<![CDATA[" + "" + "]]>").append("</site_descr>");
					}
					
					
				}
				else if(currentColumn.trim().equalsIgnoreCase("tran_id__lc"))
				{
					System.out.println("@@@@@@  tran_id__lc itemchange called");
					tranIdLc = genericUtility.getColumnValue("tran_id__lc", dom);
					System.out.println("tranIdLc========"+tranIdLc);
					//sql = "SELECT purc_order,curr_code,exch_rate,bank_address,due_date,eff_date,lc_amt,no_days,tran_type FROM lc_voucher WHERE tran_id=?";
					String blankDt="";
					if(tranIdLc!=null && tranIdLc.trim().length()>0)
					{
						
					
					sql="SELECT lc.purc_order,po.ord_date,lc.curr_code,lc.exch_rate,lc.bank_address,lc.bank_name_iss,lc.due_date," +
							"lc.eff_date,lc.lc_amt,lc.no_days,lc.tran_type " +
							"FROM lc_voucher lc,porder po" +
							" WHERE lc.purc_order=po.purc_order and lc.tran_id= ? ";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, tranIdLc);
					rs = pstmt.executeQuery();
					if (rs.next())
					{
						
						
						//ordDate= rs.getTimestamp("ord_date");
						purcOrder=checkNull(rs.getString("purc_order"));
						currCode=checkNull(rs.getString("curr_code"));
						exchRate=rs.getDouble("exch_rate");
						bankAdd=checkNull(rs.getString("bank_address"));	
						bankNameIss=checkNull(rs.getString("bank_name_iss"));	
						dueDate=rs.getDate("due_date");
						effDate=rs.getDate("eff_date");
						lcAmt=rs.getDouble("lc_amt");
						noOfDays=rs.getInt("no_days");
						tranType=checkNull(rs.getString("tran_type"));
						orddate=rs.getDate("ord_date");
						
						
					}
					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null;
					System.out.println("purcOrder>>>>>"+purcOrder);
					System.out.println("currCode>>>>>"+currCode);
					System.out.println("exchRate>>>>>"+exchRate);
					System.out.println("bankAdd>>>>>"+bankAdd);
					System.out.println("bankNameIss>>>>>"+bankNameIss);
					System.out.println("dueDate>>>>>"+dueDate);
					System.out.println("effDate>>>>"+effDate);
					System.out.println("lcAmt>>>>>"+lcAmt);
					System.out.println("noOfDays>>>>>"+noOfDays);
					System.out.println("tranType>>>>>"+tranType);
					System.out.println("ord_date===="+orddate);
					
					
					
					valueXmlString.append("<purc_order>").append("<![CDATA[" +  purcOrder + "]]>").append("</purc_order>");
					
					if(orddate!=null)
					{						
						valueXmlString.append("<ord_date>").append("<![CDATA[" +   sdf.format(orddate).toString() + "]]>").append("</ord_date>");
					}
					else
					{
						valueXmlString.append("<ord_date>").append("<![CDATA[]]>").append("</ord_date>");
					//	valueXmlString.append("<ord_date>").append("<![CDATA["+"DD/MM/YY"+"]]>").append("</ord_date>");
					}
					
					valueXmlString.append("<curr_code>").append("<![CDATA[" +  currCode + "]]>").append("</curr_code>");
					valueXmlString.append("<exch_rate>").append("<![CDATA[" +  exchRate + "]]>").append("</exch_rate>");
					valueXmlString.append("<bank_address__o>").append("<![CDATA[" +  bankAdd + "]]>").append("</bank_address__o>");
					valueXmlString.append("<bank_address>").append("<![CDATA[" +  bankAdd + "]]>").append("</bank_address>");
					
					valueXmlString.append("<bank_name_iss__o>").append("<![CDATA[" +  bankNameIss + "]]>").append("</bank_name_iss__o>");
					valueXmlString.append("<bank_name_iss>").append("<![CDATA[" +  bankNameIss + "]]>").append("</bank_name_iss>");
					
					if(dueDate!=null)
					{
						valueXmlString.append("<due_date__o>").append("<![CDATA[" +  sdf.format(dueDate).toString() + "]]>").append("</due_date__o>");
						valueXmlString.append("<due_date>").append("<![CDATA[" +   sdf.format(dueDate).toString() + "]]>").append("</due_date>");
					}
					else
					{
						/*valueXmlString.append("<due_date__o>").append("<![CDATA["+"DD/MM/YY"+"]]>").append("</due_date__o>");
						valueXmlString.append("<due_date>").append("<![CDATA["+"DD/MM/YY"+"]]>").append("</due_date>");*/
						valueXmlString.append("<due_date__o>").append("<![CDATA[]]>").append("</due_date__o>");
						valueXmlString.append("<due_date>").append("<![CDATA[]]>").append("</due_date>");
					}
					
					if(effDate!=null)
					{
						valueXmlString.append("<eff_date__o>").append("<![CDATA[" + sdf.format(effDate).toString() + "]]>").append("</eff_date__o>");
						valueXmlString.append("<eff_date>").append("<![CDATA[" +  sdf.format(effDate).toString()  + "]]>").append("</eff_date>");
					}
					else
					{
						/*valueXmlString.append("<eff_date__o>").append("<![CDATA["+"DD/MM/YY"+"]]>").append("</eff_date__o>");
						valueXmlString.append("<eff_date>").append("<![CDATA["+"DD/MM/YY"+"]]>").append("</eff_date>");*/
						
						valueXmlString.append("<eff_date__o>").append("<![CDATA[]]>").append("</eff_date__o>");
						valueXmlString.append("<eff_date>").append("<![CDATA[]]>").append("</eff_date>");
					}
					
					valueXmlString.append("<lc_amt__o>").append("<![CDATA[" +  lcAmt + "]]>").append("</lc_amt__o>");
					valueXmlString.append("<lc_amt>").append("<![CDATA[" +  lcAmt + "]]>").append("</lc_amt>");
					
					
					valueXmlString.append("<no_days__o>").append("<![CDATA[" +  noOfDays + "]]>").append("</no_days__o>");
					valueXmlString.append("<no_days>").append("<![CDATA[" +  noOfDays + "]]>").append("</no_days>");
					
					valueXmlString.append("<tran_type>").append("<![CDATA[" +  tranType + "]]>").append("</tran_type>");
			
					
					}
					else
					{
											
						
						valueXmlString.append("<purc_order>").append("<![CDATA[]]>").append("</purc_order>");		
						valueXmlString.append("<ord_date>").append("<![CDATA[]]>").append("</ord_date>");
									
						valueXmlString.append("<curr_code>").append("<![CDATA[]]>").append("</curr_code>");
						valueXmlString.append("<exch_rate>").append("<![CDATA[]]>").append("</exch_rate>");
						valueXmlString.append("<bank_address__o>").append("<![CDATA[]]>").append("</bank_address__o>");
						valueXmlString.append("<bank_address>").append("<![CDATA[]]>").append("</bank_address>");	
						
						valueXmlString.append("<bank_name_iss__o>").append("<![CDATA[]]>").append("</bank_name_iss__o>");
						valueXmlString.append("<bank_name_iss>").append("<![CDATA[]]>").append("</bank_name_iss>");	
													
						valueXmlString.append("<lc_amt__o>").append("<![CDATA[]]>").append("</lc_amt__o>");
						valueXmlString.append("<lc_amt>").append("<![CDATA[]]>").append("</lc_amt>");					
						
						valueXmlString.append("<no_days__o>").append("<![CDATA[]]>").append("</no_days__o>");
						valueXmlString.append("<no_days>").append("<![CDATA[]]>").append("</no_days>");
						
						valueXmlString.append("<tran_type>").append("<![CDATA[ ]]>").append("</tran_type>");
				
						valueXmlString.append("<due_date__o>").append("<![CDATA[]]>").append("</due_date__o>");
						valueXmlString.append("<due_date>").append("<![CDATA[]]>").append("</due_date>");
						
						valueXmlString.append("<eff_date__o>").append("<![CDATA[]]>").append("</eff_date__o>");
						valueXmlString.append("<eff_date>").append("<![CDATA[]]>").append("</eff_date>");
					}
				
				
				
				}
				valueXmlString.append("</Detail1>");
				break;
			}//end of switch-case
			valueXmlString.append("</Root>");
		}
		catch(Exception e)
		{
			e.printStackTrace();
			System.out.println("Exception ::"+ e.getMessage());
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(conn != null)
				{
					if(pstmt != null)
						pstmt.close();
					if(rs != null)
						rs.close();
					rs = null;
					pstmt = null;
					conn.close();
					conn = null;
				}
			}
			catch(Exception d)
			{
				d.printStackTrace();
			}			
		}
		return valueXmlString.toString();
	}//end of itemChanged

	private String errorType(Connection conn , String errorCode)
	{
		String msgType = "";
		PreparedStatement pstmt = null ; 
		ResultSet rs = null;
		try
		{			
			String  sql = "SELECT MSG_TYPE FROM MESSAGES WHERE MSG_NO = ?";
			pstmt = conn.prepareStatement(sql);			
			pstmt.setString(1,errorCode);			
			rs = pstmt.executeQuery();
			while(rs.next())
			{
				msgType = rs.getString("MSG_TYPE");
			}			
		}
		catch(Exception ex)
		{
			ex.printStackTrace();
		}		
		finally
		{
			try
			{
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}		
		return msgType;
	}//end of errorType

	/*private String findValue(Connection conn, String columnName ,String tableName, String columnName2, String value) throws  ITMException, RemoteException
	{
		PreparedStatement pstmt = null ;
		ResultSet rs = null ; 
		String sql = "";
		String findValue = "";
		try
		{			
			sql = "SELECT " + columnName + " from " + tableName + " where " + columnName2 +"= ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,value);
			rs = pstmt.executeQuery();
			if(rs.next())
			{					
				findValue = rs.getString(1);
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;	        
			if (findValue == null )
			{
				findValue = "";
			}
		}
		catch(Exception e)
		{
			System.out.println("Exception in findValue ");
			e.printStackTrace();
			throw new ITMException(e); 
		}
		System.out.println("returning String from findValue " + findValue);
		return findValue;
	}//end of findValue
*/
	private String checkNull( String input )
	{
		if (input == null )
		{
			input = "";
		}
		return input;
	}//end of checkNull
}



