package ibase.webitm.ejb.appraisal;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.ITMException;
@javax.ejb.Stateless

public class ApprSpecTbl extends ValidatorEJB implements ApprSpecTblRemote,ApprSpecTblLocal
{
	public String wfValData(String xmlString, String xmlString1, String xmlString2, String objContext, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String errString = null;

		E12GenericUtility genericUtility = new E12GenericUtility();
		try
		{
			if(xmlString != null && xmlString.trim().length()!=0)
			{
				dom = genericUtility.parseString(xmlString); 
			}
			if(xmlString1 != null && xmlString1.trim().length()!=0)
			{
				dom1 = genericUtility.parseString(xmlString1); 
			}
			if(xmlString2 != null && xmlString2.trim().length()!=0)
			{
				dom2 = genericUtility.parseString(xmlString2); 
			}
			errString = wfValData( dom, dom1, dom2, objContext, editFlag, xtraParams );
			System.out.println("[WsfaEffCovgEJB][wfValData][ErrString:] " + errString);
		}
		catch(Exception e)
		{
			System.out.println("Exception: WsfaEffCovgEJB: wfValData(String xmlString): " + e.getMessage() + ":");
			errString = genericUtility.createErrorString(e);
			e.printStackTrace();
		}
		System.out.println("Returning from WsfaEffCovgEJB wfValData");
		return errString; 
	}

	public String wfValData(Document dom, Document dom1,Document dom2, String objContext, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		NodeList parentNodeList = null;
		NodeList childNodeList = null;
		Node parentNode = null;
		Node childNode = null;
		int ctr = 0, currentFormNo = 0, childNodeListLength = 0, cnt = 0;
		String loginSite = "", userId = "";
		String childNodeName = null, childNodeValue = null;
		String errString = "";
		String errCode = "";
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String sql = "";	
		try
		{
			conn = getConnection();
			userId = getValueFromXTRA_PARAMS( xtraParams, "loginCode" );
			loginSite = getValueFromXTRA_PARAMS(xtraParams, "loginSiteCode");
			E12GenericUtility genericUtility = new E12GenericUtility();
			if(objContext != null && objContext.trim().length()>0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			switch(currentFormNo)
			{
			case 1 :
				parentNodeList = dom.getElementsByTagName("Detail1");
				parentNode = parentNodeList.item(0);
				childNodeList = parentNode.getChildNodes();
				childNodeListLength = childNodeList.getLength();
				for(ctr = 0; ctr < childNodeListLength; ctr++)
				{	
					childNode = childNodeList.item(ctr);
					childNodeName = childNode.getNodeName();
					if(childNode.getFirstChild() != null)
					{
						childNodeValue = childNode.getFirstChild().getNodeValue();
					}
					if( "appr_tblno".equalsIgnoreCase( childNodeName ) )
					{
						if( childNode.getFirstChild() == null )
						{
							errString = getErrorString( "appr_tblno", "NLAPRTBLNO", userId );
							break ;
						}
					}
					else if( "appr_spec".equalsIgnoreCase( childNodeName ) )
					{ 
						if( childNode.getFirstChild() == null )
						{
							errString = getErrorString( "appr_spec", "NULAPPRSPC", userId );
							break ;
						}
						else
						{
							String apprSpec = checkNull(genericUtility.getColumnValue("appr_spec", dom));
							sql = " SELECT APPR_SPEC FROM APPRAISAL_SPEC WHERE APPR_SPEC = ? ";
							pstmt =  conn.prepareStatement(sql);
							pstmt.setString(1, apprSpec);
							rs = pstmt.executeQuery();
							if( ! rs.next() )
							{
								errString = getErrorString("appr_spec","NTFMLSTAPS",userId);
								break ;
							}
							if(editFlag != null && editFlag.equalsIgnoreCase("A"))
							{
								String apprTblNo = checkNull(genericUtility.getColumnValue("appr_tblno", dom));
								sql = " SELECT APPR_SPEC FROM APPRAISAL_SPEC_TABLE WHERE APPR_SPEC = ?  AND APPR_TBLNO = ?";
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1, apprSpec);
								pstmt.setString(2, apprTblNo);
								rs = pstmt.executeQuery();
								if(  rs.next() )
								{
									errString = getErrorString("appr_tblno","APRTBLNONL",userId);
									break ;
								}
							}
						}
					}

				} 
				break;	
			}
		}
		catch(Exception e)
		{
			System.out.println("Exception  : ApprSpecTbl : wfValData :");
			e.printStackTrace();
			errString=e.getMessage();
		}
		finally
		{
			try
			{
				if(conn!=null)
				{
					conn.close();
				}
				conn = null;
			}
			catch(Exception d)
			{
				d.printStackTrace();
			}			
		}
		System.out.println("ErrString ::"+errString);
		return errString;
	}

	public String itemChanged(String xmlString, String xmlString1,String xmlString2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String valueXmlString = "";
		try
		{
			dom = parseString(xmlString); 
			System.out.println("xmlString" + xmlString);
			dom1 = parseString(xmlString1); 
			if(xmlString2.trim().length() > 0 )
			{
				dom2 = parseString(xmlString2);
			}
			valueXmlString = itemChanged(dom,dom1,dom2,objContext,currentColumn,editFlag,xtraParams);
		}
		catch(Exception e)
		{
			System.out.println("Exception : [ApprSpecTbl][itemChanged(String,String)] :==>\n"+e.getMessage());
		}
		return valueXmlString; 
	}

	public String itemChanged(Document dom, Document dom1,Document dom2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException,ITMException
	{		
		StringBuffer valueXmlString = new StringBuffer();
		NodeList parentNodeList = null;
		NodeList childNodeList = null;
		Node parentNode = null;
		Node childNode = null;
		int ctr=0,k=0,childNodeListLength=0;
		String columnValue = null;
		String childNodeName = null;
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String sql = "";
		String loginSite="", query =""; 
		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
		try
		{	
			conn = getConnection();
			System.out.println("conn connection-'-["+conn+"]");
			loginSite = getValueFromXTRA_PARAMS(xtraParams, "loginSiteCode");
			if(objContext != null && objContext.trim().length() > 0)
				k = Integer.parseInt(objContext);
			System.out.println("[ApprSpecTbl][itemChanged][FORM NO][" + k+"]");
			valueXmlString = new StringBuffer("<?xml version=\"1.0\"?><Root><header><editFlag>");
			valueXmlString.append(editFlag).append("</editFlag></header>");
			switch(k)
			{
			case 1 :																	
				parentNodeList = dom.getElementsByTagName("Detail1");
				parentNode = parentNodeList.item(0);
				childNodeList = parentNode.getChildNodes();
				ctr = 0;
				valueXmlString.append("<Detail1>");
				childNodeListLength = childNodeList.getLength();
				do
				{
					childNode = childNodeList.item(ctr);
					System.out.println("child node in apprtbl-["+childNode+"]");
					childNodeName = childNode.getNodeName();
					if(childNodeName.equals(currentColumn))
					{
						if (childNode.getFirstChild() != null)
						{
							columnValue=childNode.getFirstChild().getNodeValue().trim();
						}
					}
					ctr++;
				}
				while(ctr < childNodeListLength  && !childNodeName.equals(currentColumn));

				if(currentColumn.trim().equalsIgnoreCase("appr_spec"))
				{	
					String apprSpec = checkNull(genericUtility.getColumnValue("appr_spec", dom));
					if(apprSpec != null)
					{
						query = " SELECT SPEC_DETAILS FROM APPRAISAL_SPEC  WHERE APPR_SPEC = ? " ;		
						if (conn != null)
						{
							pstmt = conn.prepareStatement(query);
						}
						pstmt.setString(1, apprSpec);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							String recCnt = rs.getString("SPEC_DETAILS");
							System.out.println("reccnt ="+recCnt+" for["+query+"]");

							valueXmlString.append("<spec_details>").append("<![CDATA[" + rs.getString("SPEC_DETAILS") + "]]>").append("</spec_details>");
						}
						else
						{
							valueXmlString.append("<spec_details>").append("<![CDATA[]]>").append("</spec_details>");
						}
					}
				}

				valueXmlString.append("</Detail1 >");
				System.out.println("itemchange string :::" +valueXmlString);
				break;
			}
			valueXmlString.append("</Root>");
		}
		catch(Exception e)
		{	
			e.printStackTrace();
			System.out.println("Exception ::" + e.getMessage());
			throw new ITMException(e);
		}
		finally 
		{
			try
			{
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(conn != null)
					conn.close();
				conn = null;
			}
			catch(Exception e1)
			{
				e1.printStackTrace();
			}

		}
		System.out.println("[ApprSpecTbl] Connection is Closed");
		System.out.println("valueXmlString:::::" + valueXmlString.toString());
		return valueXmlString.toString();
	}  

	private String checkNull( String input )
	{
		if(input == null)
		{
			input = "";
		}
		return input;
	}

}
