package ibase.webitm.ejb.gst;

import java.io.InputStream;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.rmi.RemoteException;
import java.security.PrivateKey;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;

import javax.annotation.PostConstruct;

import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.params.KeyParameter;
import org.json.JSONArray;
import org.json.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.JsonNode;
import com.mashape.unirest.http.Unirest;
import com.sun.jmx.snmp.Timestamp;

import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.webitm.bean.gst.AT;
import ibase.webitm.bean.gst.ATA;
import ibase.webitm.bean.gst.B2B;
import ibase.webitm.bean.gst.B2CL;
import ibase.webitm.bean.gst.B2CLA;
import ibase.webitm.bean.gst.B2CS;
import ibase.webitm.bean.gst.B2CSA;
import ibase.webitm.bean.gst.CDNDetails;
import ibase.webitm.bean.gst.CDNR;
import ibase.webitm.bean.gst.CDNRA;
import ibase.webitm.bean.gst.CDNUR;
import ibase.webitm.bean.gst.DocDetails;
import ibase.webitm.bean.gst.DocIssued;
import ibase.webitm.bean.gst.EXP;
import ibase.webitm.bean.gst.GSTR1;
import ibase.webitm.bean.gst.HSN;
import ibase.webitm.bean.gst.HSNDetails;
import ibase.webitm.bean.gst.InvLineItem;
import ibase.webitm.bean.gst.Invoice;
import ibase.webitm.bean.gst.Nil;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.ejb.fin.FinCommon;
import ibase.webitm.util.gst.AESEncryption;
import ibase.webitm.util.gst.GSPSignature;
import ibase.webitm.util.gst.PubKeyEncryption;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.TransIDGenerator;

@javax.ejb.Stateless
public class GSTDataSubmitWizPos extends ValidatorEJB implements GSTDataSubmitWizPosLocal, GSTDataSubmitWizPosRemote
{
	private String GSP_API_URL = "";
	private String GST_API_URL = "";
	private String AUTH_TOKEN_URL_V2 = "";
	private String GSTR1_URL_V2 = "";
	private String GSTR2_URL_V2 = "";
	private String GSTR1_URL_V3 = "";
	private String GSTR2_URL_V3 = "";
	private final String APPLICATION_JSON = "application/json";
	private String appKey = "";
	InetAddress ipAddress = null;
	private byte[] appKeyInBytes = null;
	private String appKeyEncryptedAndCoded = "";
	private String clientId = "";
	private String clientSecret = "";
	AESEncryption aesEncryption = null;
	PubKeyEncryption pubKeyEncryption = null;
	Connection conn = null;
	GSPSignature gspSignature;
	PrivateKey aspPrivateKey = null;
	
	E12GenericUtility e12GeneticUitlity = null;
	
	@PostConstruct
	public void postConstruct()
	{
		String sql = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		try
		{
			System.out.println("GSTDataSubmitWizPos PostConstruct called!");
			InputStream pubKeyInpStream = Thread.currentThread().getContextClassLoader().getResourceAsStream("ibase/webitm/resources/gst/GSTN_Public_Key.cer");
			conn = getConnection();
			e12GeneticUitlity = new E12GenericUtility();
			FinCommon finCommon = new FinCommon();
			clientId = finCommon.getFinparams("999999", "GST_CLIENT_ID", conn);
			clientSecret = finCommon.getFinparams("999999", "GST_CLIENT_SECRET", conn);
			aesEncryption = new AESEncryption();
			pubKeyEncryption = new PubKeyEncryption(pubKeyInpStream);
			ipAddress = Inet4Address.getLocalHost();
			System.out.println("host ipAddress["+ipAddress.getHostAddress()+"]");
			gspSignature = new GSPSignature();
			String privateKeyPath = "/ibase/webitm/resources/gst/privatekey.pem";
			aspPrivateKey = gspSignature.loadPrivateKey(Thread.currentThread().getContextClassLoader().getResourceAsStream(privateKeyPath));
			
			sql = "SELECT SERVICE_CODE, SERVICE_URI FROM SYSTEM_EVENT_SERVICES WHERE METHOD_NAME = 'GST_API_URL'";
			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			while(rs.next())
			{
				switch(rs.getString("SERVICE_CODE"))
				{
					case "gsp_base_url" :
					{
						GSP_API_URL = rs.getString("SERVICE_URI");
					}
					break;
					case "gst_base_url" :
					{
						GST_API_URL = rs.getString("SERVICE_URI");
					}
					break;
					case "gstr_auth_url_v2" :
					{
						AUTH_TOKEN_URL_V2 = rs.getString("SERVICE_URI");
					}
					break;
					case "gstr1_url_v2" :
					{
						GSTR1_URL_V2 = rs.getString("SERVICE_URI");
					}
					break;
					case "gstr2_url_v2" :
					{
						GSTR2_URL_V2 = rs.getString("SERVICE_URI");
					}
					break;
					case "gstr1_url_v3" :
					{
						GSTR1_URL_V3 = rs.getString("SERVICE_URI");
					}
					break;
					case "gstr2_url_v3" :
					{
						GSTR2_URL_V3 = rs.getString("SERVICE_URI");
					}
					break;
				}
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
			if(rs!=null)
			{
				rs.close();
				rs = null;
			}
			
			System.out.println("GST_API_URL["+GST_API_URL+"]");
			System.out.println("AUTH_TOKEN_URL_V2["+AUTH_TOKEN_URL_V2+"]");
			System.out.println("GSTR1_URL_V2["+GSTR1_URL_V2+"]");
			System.out.println("GSTR2_URL_V2["+GSTR2_URL_V2+"]");
			System.out.println("GSTR1_URL_V3["+GSTR1_URL_V3+"]");
			System.out.println("GSTR2_URL_V3["+GSTR2_URL_V3+"]");
		}
		catch (Exception e) 
		{
			System.out.println("GSTDataSubmitWizPos.postConstruct()["+e.getMessage()+"]");
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if(conn!= null && !conn.isClosed())
				{
					conn.close();
					conn = null;
				}
			}
			catch(SQLException se)
			{
				System.out.println("GSTDataSubmitWizPos.postConstruct()["+se.getMessage()+"]");
				se.printStackTrace();
			}
		}
		
	}
	@Override
	public String postSave(String xmlStringAll, String dcrId, String editFlag, String xtraParams, Connection conn) throws RemoteException,ITMException
	{
		Document allXMLDom = null;
		NodeList detail1NList = null, detail1ChildNList = null;
		String retString = "", nodeName = "", otp = "", stateCode = "", sek = "", returnsType = "", gstin = "", periodCode = "", grossTurnover = "",
			   action = "", siteCode = "", gspAuthString = "", gspAuthSignature = "";
		byte[] authSEK = null;
		
		try
		{
			String userName = "", authToken = "";
			String transactionId = UUID.randomUUID().toString().replaceAll("-", "");
			
			System.out.println("xmlStringAll["+xmlStringAll+"]");
			System.out.println("dcrId["+dcrId+"]");
			System.out.println("editFlag["+editFlag+"]");
			
			allXMLDom = e12GeneticUitlity.parseString(xmlStringAll);
			
			detail1NList = allXMLDom.getElementsByTagName("Detail1");
			detail1ChildNList = detail1NList.item(0).getChildNodes();
			
			for(int i=0; i<detail1ChildNList.getLength();i++)
			{
				Node eachDetail1Element = detail1ChildNList.item(i);
				nodeName = eachDetail1Element.getNodeName();
				
				if(!"#text".equalsIgnoreCase(nodeName) && !"attribute".equals(nodeName))
				{
					if("username".equalsIgnoreCase(nodeName))
					{
						userName = eachDetail1Element.getTextContent();
					}
					else if("state_code".equalsIgnoreCase(nodeName))
					{
						stateCode = eachDetail1Element.getTextContent();;
					}
					else if("app_key".equalsIgnoreCase(nodeName))
					{
						appKey = eachDetail1Element.getTextContent();
					}
					else if("otp".equalsIgnoreCase(nodeName))
					{
						otp = eachDetail1Element.getTextContent();
					}
					else if("returns_type".equalsIgnoreCase(nodeName))
					{
						returnsType = eachDetail1Element.getTextContent();
					}
					else if("gstin".equalsIgnoreCase(nodeName))
					{
						gstin = eachDetail1Element.getTextContent();
					}
					else if("period_code".equalsIgnoreCase(nodeName))
					{
						periodCode = eachDetail1Element.getTextContent();
					}
					else if("gross_turnover".equalsIgnoreCase(nodeName))
					{
						grossTurnover = eachDetail1Element.getTextContent();
					}
					else if("action".equalsIgnoreCase(nodeName))
					{
						action = eachDetail1Element.getTextContent();
					}
					else if("site_code".equalsIgnoreCase(nodeName))
					{
						siteCode = eachDetail1Element.getTextContent();
					}
				}
			}		
			
			System.out.println("returnsType["+returnsType+"] action ["+action+"]");
			
			appKeyInBytes = aesEncryption.decodeBase64StringTOByte(appKey);
			appKeyEncryptedAndCoded = pubKeyEncryption.encrypt(appKeyInBytes);
			
			String encryptedOTP = aesEncryption.encryptEK(otp.getBytes(), appKeyInBytes);
			
			JSONObject authTokenReq = new JSONObject();
	        authTokenReq.put("action", "AUTHTOKEN");
	        authTokenReq.put("username", userName);
	        authTokenReq.put("app_key", appKeyEncryptedAndCoded);
	        authTokenReq.put("otp", encryptedOTP);
	        
	        long timeStamp = new Timestamp().getDateTime();
	        gspAuthString = clientId + ":" + transactionId + ":" + timeStamp + ":" + gstin;
			gspAuthSignature = gspSignature.sign(gspAuthString, aspPrivateKey);

	        HttpResponse<JsonNode> authTokenResp = Unirest.post(String.format("%s%s", GSP_API_URL, AUTH_TOKEN_URL_V2))
												   .header("Content-Type",APPLICATION_JSON)
												   .header("clientid", clientId)
												   .header("client-secret", clientSecret)
												   .header("state-cd", stateCode)
												   .header("ip-usr", ipAddress.getHostAddress())
												   .header("txn", transactionId)
												   .header("app_key", appKeyEncryptedAndCoded)
												   .header("X-Asp-Auth-Token", gspAuthString)
							    	               .header("X-Asp-Auth-Signature", gspAuthSignature)
												   .body(new JsonNode(authTokenReq.toString()))
												   .asJson();

	        System.out.println(String.format("authTokenResp Request : Status[%s] Response[%s]", authTokenResp.getStatus(), authTokenResp.getBody()));
	        if (authTokenResp.getStatus() == 200) 
	        {
	            JSONObject object = authTokenResp.getBody().getObject();
	            if (object.has("auth_token") && object.has("sek") && object.has("status_cd") && Objects.equals(object.getString("status_cd"), "1")) 
	            {
	                authToken = object.getString("auth_token");
	                sek = object.getString("sek");

	                authSEK = aesEncryption.decrypt(sek, appKeyInBytes);
	                System.out.println("AuthSEK = "+ aesEncryption.encodeBase64String(authSEK));
	                
	                if("GSTR1".equalsIgnoreCase(returnsType))
	                {
	                	if("SAVE".equalsIgnoreCase(action))
	                	{
	                		retString = saveGstr1(authToken, siteCode, stateCode, userName, gstin, periodCode, grossTurnover, authSEK, conn);
	                	}
	                	else if ("RETSUM".equalsIgnoreCase(action) || "FILE".equalsIgnoreCase(action))
	                	{
	                		retString = getGstr1Summary(authToken, stateCode, userName, gstin, periodCode, authSEK, action, conn);
	                	}
	                	else if ("SUBMIT".equalsIgnoreCase(action))
	                	{
	                		retString = submitGstr1(authToken, stateCode, userName, gstin, periodCode, authSEK, conn);
	                	}
	                }
	                else if("GSTR2".equalsIgnoreCase(returnsType))
	                {
	                	if("GETINV".equalsIgnoreCase(action))
	                	{
	                		retString = getGstr2Invoices(authToken, stateCode, userName, gstin, periodCode, siteCode, authSEK, conn);
	                	}
	                }
	            }
	            else
	            {
	            	JSONObject errorJSON = authTokenResp.getBody().getObject().getJSONObject("error");
	            	
	            	if("AUTH4033".equalsIgnoreCase(errorJSON.getString("error_cd")))
	            	{
	            		retString = new ITMDBAccessEJB().getErrorString("","VTINVOTP","","",conn);
	            	}
	            	else
	            	{
	            		String errMsg = "Message : "+errorJSON.getString("message")+" \nError code : "+errorJSON.getString("error_cd");
	            		retString = getError(errMsg, "GSTAPIERR", conn);
	            	}
	            }
	        }
	        else
	        {
	        	JSONObject errorJSON = authTokenResp.getBody().getObject().getJSONObject("error");
	        	String errMsg = "Message : "+errorJSON.getString("message")+" \nError code : "+errorJSON.getString("error_cd");
	        	retString = getError(errMsg, "GSTAPIERR", conn);
	        }
		}
		catch(Exception e)
		{
			System.out.println("GSTDataSubmitWizPos.postSave()["+e.getMessage()+"]");
			e.printStackTrace();
			throw new ITMException(e);
		}
		
		return retString;
	}
	
	private String saveGstr1(String authToken, String siteCode, String stateCode, String userName, String gstin, String periodCode, String grossTurnover, byte[] authSek, Connection conn) throws ITMException
	{
		String retString = "", errMsg = "";
		String gstr1Data = "", gstr1Rek = "";
		String retStatsData = "", retStatsRek = "";
		String transactionId = UUID.randomUUID().toString().replaceAll("-", "");
		int num = 0;
		
		boolean isDataFound = false;
		
		String sql = "", lineSql = "", refDataSql = "";
		PreparedStatement pstmt = null, linePstmt = null, refDataPstmt = null;
		ResultSet rs = null, lineRs = null, refDataRs = null;
		
		String tranId = "", tranType = "", tranIdRef = "", ctin = "", posStateCode = "", posStateCodeStr = "", supplyType = "";
		
		ArrayList<String> tranIdList = new ArrayList<String>();
		
		Map<String, ArrayList<Invoice>> invoicesHMap = new HashMap<String, ArrayList<Invoice>>();
		Map<String, Object> invTypObjHMap = new HashMap<String, Object>();
		ArrayList<B2B> b2bInvoiceList = new ArrayList<B2B>();
		ArrayList<B2CL> b2clInvoiceList = new ArrayList<B2CL>();
		ArrayList<B2CLA> b2claInvoiceList = new ArrayList<B2CLA>();
		ArrayList<B2CS> b2csInvoiceList = new ArrayList<B2CS>();
		ArrayList<B2CSA> b2csaInvoiceList = new ArrayList<B2CSA>();
		ArrayList<CDNR> cdnrList = new ArrayList<CDNR>();
		ArrayList<CDNRA> cdnraList = new ArrayList<CDNRA>();
		ArrayList<AT> atList = new ArrayList<AT>();
		ArrayList<ATA> ataList = new ArrayList<ATA>();
		ArrayList<EXP> expInvoiceList = new ArrayList<EXP>();
		ArrayList<AT> atPaidList = new ArrayList<AT>();
		ArrayList<CDNUR> cdnurList = new ArrayList<CDNUR>();
		ArrayList<DocIssued> docIssuedList = new ArrayList<DocIssued>();
		

		ArrayList<InvLineItem> invLineItems = null;
		ArrayList<Invoice> invoices = null;
		ArrayList<CDNDetails> cdnDetailsList = null;
		ArrayList<HSNDetails> hsnList = new ArrayList<HSNDetails>();
		ArrayList<DocDetails> docDetailsList = new ArrayList<DocDetails>();
		
		GSTR1 gstr1 = null;
		Invoice invoice = null;
		InvLineItem invLineItem = null;
		B2B b2b = null;
		B2CL b2cl = null;
		B2CS b2cs = null;
		CDNR cdnr = null;
		CDNDetails cdnDetails = null;
		AT at = null;
		EXP exp = null;
		CDNUR cdnur = null;
		Nil nil = null;
		HSN hsn = null;	
		HSNDetails hsnDetails = null;
		DocIssued docIssued = null;
		DocDetails docDetails = null;
		
		try
		{
			gstr1 = new GSTR1();
			gstr1.gstin = gstin;
			gstr1.financialPeriod = periodCode;
			gstr1.grossTurnOver = Double.valueOf(grossTurnover);
			
			sql = "SELECT * FROM GST_DATA_HDR WHERE PRD_CODE = ? AND SITE_CODE = ? AND SUBMIT_STATUS = 'P' AND REC_TYPE ='1'";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, periodCode);
			pstmt.setString(2, siteCode);
			rs = pstmt.executeQuery();
			
			while(rs.next())
			{
				isDataFound = true;
				tranId = checkNullandTrim(rs.getString("TRAN_ID"));
				tranType = checkNullandTrim(rs.getString("TRAN_TYPE"));
				ctin = checkNullandTrim(rs.getString("TAX_REG_NO"));
				posStateCodeStr = checkNullandTrim(rs.getString("STATE_CODE"));
				tranIdRef = checkNullandTrim(rs.getString("TRAN_ID__REF"));
				
				System.out.println("tranId["+tranId+"] tranType["+tranType+"] ctin["+ctin+"] posStateCodeStr["+posStateCodeStr+"] tranIdRef["+tranIdRef+"]");
				
				if(posStateCodeStr.length() > 0)
				{
					lineSql = "SELECT GST_CODE FROM STATE WHERE STATE_CODE = ?";
					linePstmt = conn.prepareStatement(lineSql);
					linePstmt.setString(1, posStateCodeStr);
					lineRs = linePstmt.executeQuery();
					
					if(lineRs.next())
					{
						posStateCode = checkNullandTrim(lineRs.getString("GST_CODE")) ;
					}
					
					if(linePstmt != null)
					{
						linePstmt.close();
						linePstmt = null;
					}
					if(lineRs != null)
					{
						lineRs.close();
						lineRs = null;
					}
				}
				
				invoices = new ArrayList<Invoice>();
				invoice = new Invoice();
				invLineItems = new ArrayList<InvLineItem>();
				cdnDetailsList = new ArrayList<CDNDetails>();
				
				if(invoicesHMap.containsKey(ctin+"~"+tranType))
				{
					invoices = invoicesHMap.get(ctin+"~"+tranType);
				}
				
				//tran_type : 01 = B2B invoices, 02 B2BA invoices
				if("01".equalsIgnoreCase(tranType) || "02".equalsIgnoreCase(tranType))
				{
					lineSql = "SELECT * FROM GST_DATA_DET WHERE TRAN_ID = ? ORDER BY LINE_NO ";
					linePstmt = conn.prepareStatement(lineSql);
					linePstmt.setString(1, tranId);
					lineRs = linePstmt.executeQuery();
					
					while(lineRs.next())
					{
						invLineItem = new InvLineItem();
						invLineItem.num = lineRs.getInt("LINE_NO");
						invLineItem.rate = lineRs.getDouble("IGST_PERC")+lineRs.getDouble("CGST_PERC")+lineRs.getDouble("SGST_PERC");
						invLineItem.taxval = lineRs.getDouble("TAXABLE_AMT");
						invLineItem.iamt = lineRs.getDouble("IGST_AMT");
						invLineItem.camt = lineRs.getDouble("CGST_AMT");
						invLineItem.samt = lineRs.getDouble("SGST_AMT");
						invLineItem.csamt = lineRs.getDouble("CESS_AMT");
						
						invLineItems.add(invLineItem);
					}
					if(linePstmt != null)
					{
						linePstmt.close();
						linePstmt = null;
					}
					if(lineRs != null)
					{
						lineRs.close();
						lineRs = null;
					}
					
					invoice.inum = rs.getString("DOC_NO");
					invoice.idt = rs.getDate("DOC_DATE");
					invoice.val = rs.getDouble("AMOUNT");
					invoice.pos = posStateCode;
					invoice.invoiceType = checkNullandTrim(rs.getString("DOC_TYPE"));
					invoice.rchrg = "Y".equalsIgnoreCase(rs.getString("REVERSE_CHRG"));
					invoice.etin = rs.getString("ECOM_REG_NO");
					invoice.items = invLineItems;
					
					invoices.add(invoice);
					
					invoicesHMap.put(ctin+"~"+tranType, invoices);
					
					if("01".equalsIgnoreCase(tranType))
					{
						b2b = new B2B();
						if(invTypObjHMap.containsKey(ctin+"~"+tranType))
						{
							b2b = (B2B)invTypObjHMap.get(ctin+"~"+tranType);
							if(b2bInvoiceList.contains(b2b))
							{
								int index = b2bInvoiceList.indexOf(b2b);
								b2bInvoiceList.remove(index);
							}
						}
						b2b.ctin = ctin;
						b2b.isReverseCharge = true;
						b2b.invoices = invoices;
						
						invTypObjHMap.put(ctin+"~"+tranType, b2b);
						b2bInvoiceList.add(b2b);
					}
				}
				//tran_type : 03 = B2CL invoices, 04 B2CLA invoices
				if("03".equalsIgnoreCase(tranType) || "04".equalsIgnoreCase(tranType))
				{
					invoices = new ArrayList<Invoice>();
					invoice = new Invoice();
					invLineItems = new ArrayList<InvLineItem>();
					
					lineSql = "SELECT * FROM GST_DATA_DET WHERE TRAN_ID = ? ORDER BY LINE_NO ";
					linePstmt = conn.prepareStatement(lineSql);
					linePstmt.setString(1, tranId);
					lineRs = linePstmt.executeQuery();
					
					while(lineRs.next())
					{
						invLineItem = new InvLineItem();
						invLineItem.num = lineRs.getInt("LINE_NO");
						invLineItem.rate = lineRs.getDouble("IGST_PERC")+lineRs.getDouble("CGST_PERC")+lineRs.getDouble("SGST_PERC");
						invLineItem.taxval = lineRs.getDouble("TAXABLE_AMT");
						invLineItem.iamt = lineRs.getDouble("IGST_AMT");
						invLineItem.camt = lineRs.getDouble("CGST_AMT");
						invLineItem.samt = lineRs.getDouble("SGST_AMT");
						invLineItem.csamt = lineRs.getDouble("CESS_AMT");
						
						invLineItems.add(invLineItem);
					}
					if(linePstmt != null)
					{
						linePstmt.close();
						linePstmt = null;
					}
					if(lineRs != null)
					{
						lineRs.close();
						lineRs = null;
					}
					
					invoice.inum = checkNullandTrim(rs.getString("DOC_NO"));
					invoice.idt = rs.getDate("DOC_DATE");
					invoice.val = rs.getDouble("AMOUNT");
					invoice.etin = rs.getString("ECOM_REG_NO");
					invoice.items = invLineItems;
					
					invoices.add(invoice);
					
					if("03".equalsIgnoreCase(tranType))
					{
						b2cl = new B2CL();
						b2cl.isReverseCharge = false;
						b2cl.stateCode = posStateCode;
						b2cl.invoices = invoices;
						
						b2clInvoiceList.add(b2cl);
					}
				}
				//tran_type : 05 = B2CS invoices, 06 B2CSA invoices
				if("05".equalsIgnoreCase(tranType) || "06".equalsIgnoreCase(tranType))
				{
					
					lineSql = "SELECT * FROM GST_DATA_DET WHERE TRAN_ID = ? ORDER BY LINE_NO ";
					linePstmt = conn.prepareStatement(lineSql);
					linePstmt.setString(1, tranId);
					lineRs = linePstmt.executeQuery();
					
					while(lineRs.next())
					{
						if("05".equalsIgnoreCase(tranType))
						{
							b2cs = new B2CS();
							
							refDataSql = "SELECT DESCR FROM GENCODES WHERE MOD_NAME = 'W_GSTR' AND FLD_NAME = 'SUPPLY_TYPE' AND FLD_VALUE = ?";
							refDataPstmt = conn.prepareStatement(refDataSql);
							refDataPstmt.setString(1, checkNullandTrim(lineRs.getString("SUPPLY_TYPE")));
							refDataRs = refDataPstmt.executeQuery();
							
							if(refDataRs.next())
							{
								supplyType = checkNullandTrim(refDataRs.getString("DESCR"));
							}
							if(refDataPstmt != null)
							{
								refDataPstmt.close();
								refDataPstmt = null;
							}
							if(refDataRs != null)
							{
								refDataRs.close();
								refDataRs = null;
							}
							
							b2cs.supplyType = checkNullandTrim(rs.getString("DOC_TYPE"));
							b2cs.txval = lineRs.getDouble("TAXABLE_AMT");
							b2cs.typ = supplyType;
							b2cs.etin = rs.getString("ECOM_REG_NO");
							b2cs.pos = posStateCode;
							b2cs.rate = lineRs.getDouble("IGST_PERC")+lineRs.getDouble("CGST_PERC")+lineRs.getDouble("SGST_PERC");
							b2cs.iamt = lineRs.getDouble("IGST_AMT");
							b2cs.camt = lineRs.getDouble("CGST_AMT");
							b2cs.samt = lineRs.getDouble("SGST_AMT");
							b2cs.csamt = lineRs.getDouble("CESS_AMT");
							
							b2csInvoiceList.add(b2cs);
						}
					}
					if(linePstmt != null)
					{
						linePstmt.close();
						linePstmt = null;
					}
					if(lineRs != null)
					{
						lineRs.close();
						lineRs = null;
					}
				}
				//tran_type : 07 = CDNR, 08 CDNRA
				if("07".equalsIgnoreCase(tranType) || "08".equalsIgnoreCase(tranType))
				{
					if("07".equalsIgnoreCase(tranType))
					{
						lineSql = "SELECT * FROM GST_DATA_DET WHERE TRAN_ID = ? ORDER BY LINE_NO";
						linePstmt = conn.prepareStatement(lineSql);
						linePstmt.setString(1, tranId);
						lineRs = linePstmt.executeQuery();
						
						while(lineRs.next())
						{
							invLineItem = new InvLineItem();
							invLineItem.num = lineRs.getInt("LINE_NO");
							invLineItem.rate = lineRs.getDouble("IGST_PERC")+lineRs.getDouble("CGST_PERC")+lineRs.getDouble("SGST_PERC");
							invLineItem.taxval = lineRs.getDouble("TAXABLE_AMT");
							invLineItem.iamt = lineRs.getDouble("IGST_AMT");
							invLineItem.camt = lineRs.getDouble("CGST_AMT");
							invLineItem.samt = lineRs.getDouble("SGST_AMT");
							invLineItem.csamt = lineRs.getDouble("CESS_AMT");
							
							invLineItems.add(invLineItem);
						}
						if(linePstmt != null)
						{
							linePstmt.close();
							linePstmt = null;
						}
						if(lineRs != null)
						{
							lineRs.close();
							lineRs = null;
						}
						
						cdnDetails = new CDNDetails();
						
						cdnDetails.cdnNoteType = checkNullandTrim(rs.getString("DOC_TYPE"));
						cdnDetails.cdNoteNumber = checkNullandTrim(rs.getString("DOC_NO"));
						cdnDetails.cdNoteDate = rs.getDate("DOC_DATE");
						cdnDetails.invoiceNumber = checkNullandTrim(rs.getString("REF_ID__INV"));
						cdnDetails.invoiceDate = rs.getDate("REF_DATE__INV");
						cdnDetails.val = rs.getDouble("AMOUNT");
						cdnDetails.items = invLineItems;
						
						cdnDetailsList.add(cdnDetails);
						
						cdnr = new CDNR();
						cdnr.isReverseCharge = false;
						cdnr.ctin = ctin;
						cdnr.customerFilingStatus = false;//TODO Need to change cfs value
						cdnr.cdnDetails = cdnDetailsList;
						
						cdnrList.add(cdnr);
					}
				}
				//tran_type : 09 = Nil Supplies
				if("09".equalsIgnoreCase(tranType))
				{
					
					invoice.supplyType = "INTRB2B"; //TODO need to change
					invoice.totalNilAmount = rs.getDouble("AMOUNT");
					invoice.totalExemptedAmount = 123.45; //TODO need to change
					invoice.totalNonGSTAmout = 1258.5; //TODO need to change
					
					invoices.add(invoice);
					
					nil = new Nil();
					nil.invoices = invoices;
				}
				//tran_type : 10 = Exports and tran_type : 11 = Exports amendments
				if("10".equalsIgnoreCase(tranType) || "11".equalsIgnoreCase(tranType))
				{
					invoices = new ArrayList<Invoice>();
					invoice = new Invoice();
					invLineItems = new ArrayList<InvLineItem>();
					
					if("10".equalsIgnoreCase(tranType))
					{
						
						lineSql = "SELECT * FROM GST_DATA_DET WHERE TRAN_ID = ? ORDER BY LINE_NO ";
						linePstmt = conn.prepareStatement(lineSql);
						linePstmt.setString(1, tranId);
						lineRs = linePstmt.executeQuery();
						
						while(lineRs.next())
						{
							invLineItem = new InvLineItem();
							invLineItem.taxval = lineRs.getDouble("TAXABLE_AMT");
							invLineItem.rate = lineRs.getDouble("IGST_PERC")+lineRs.getDouble("CGST_PERC")+lineRs.getDouble("SGST_PERC");
							invLineItem.iamt = lineRs.getDouble("IGST_AMT");
							invLineItem.camt = lineRs.getDouble("CGST_AMT");
							invLineItem.samt = lineRs.getDouble("SGST_AMT");
							invLineItem.csamt = lineRs.getDouble("CESS_AMT");
							
							invLineItems.add(invLineItem);
						}
						if(linePstmt != null)
						{
							linePstmt.close();
							linePstmt = null;
						}
						if(lineRs != null)
						{
							lineRs.close();
							lineRs = null;
						}
						
						invoice.inum = rs.getString("DOC_NO");
						invoice.idt = rs.getDate("DOC_DATE");
						invoice.val = rs.getDouble("AMOUNT");
						invoice.shippingBillNum = checkNullandTrim(rs.getString("LR_NO"));
						invoice.shippingBillDt = rs.getDate("LR_DATE");
						invoice.items = invLineItems;
						
						invoices.add(invoice);
						
						exp = new EXP();
						exp.isReverseCharge = false;
						exp.exportType = checkNullandTrim(rs.getString("DOC_TYPE"));
						exp.invoices = invoices;
						
						expInvoiceList.add(exp);
					}
				}
				//tran_type : 12 = Advance Tax and tran_type : 13 = Adv. Tax amendments
				if("12".equalsIgnoreCase(tranType) || "13".equalsIgnoreCase(tranType))
				{
					invLineItems = new ArrayList<InvLineItem>();
					
					if("12".equalsIgnoreCase(tranType))
					{
						lineSql = "SELECT * FROM GST_DATA_DET WHERE TRAN_ID = ? ORDER BY LINE_NO";
						linePstmt = conn.prepareStatement(lineSql);
						linePstmt.setString(1, tranId);
						lineRs = linePstmt.executeQuery();
						
						while(lineRs.next())
						{
							invLineItem = new InvLineItem();
							
							invLineItem.taxval = rs.getDouble("AMOUNT");
							invLineItem.rate = lineRs.getDouble("IGST_PERC")+lineRs.getDouble("CGST_PERC")+lineRs.getDouble("SGST_PERC");
							invLineItem.iamt = lineRs.getDouble("IGST_AMT");
							invLineItem.camt = lineRs.getDouble("CGST_AMT");
							invLineItem.samt = lineRs.getDouble("SGST_AMT");
							invLineItem.csamt = lineRs.getDouble("CESS_AMT");
							
							invLineItems.add(invLineItem);
						}
						if(linePstmt != null)
						{
							linePstmt.close();
							linePstmt = null;
						}
						if(lineRs != null)
						{
							lineRs.close();
							lineRs = null;
						}
						
						at = new AT();
						at.isReverseCharge = false;
						
						at.pos = posStateCode;
						at.supplyType = checkNullandTrim(rs.getString("DOC_TYPE"));
						at.itms = invLineItems;
						
						atList.add(at);
					}
				}
				//tran_type : 14 = Advance Tax paid
				if("14".equalsIgnoreCase(tranType))
				{
					invLineItems = new ArrayList<InvLineItem>();
					
					lineSql = "SELECT * FROM GST_DATA_DET WHERE TRAN_ID = ? ORDER BY LINE_NO";
					linePstmt = conn.prepareStatement(lineSql);
					linePstmt.setString(1, tranId);
					lineRs = linePstmt.executeQuery();
					
					while(lineRs.next())
					{
						invLineItem = new InvLineItem();
						
						invLineItem.taxval = rs.getDouble("AMOUNT");
						invLineItem.rate = lineRs.getDouble("IGST_PERC")+lineRs.getDouble("CGST_PERC")+lineRs.getDouble("SGST_PERC");
						invLineItem.iamt = lineRs.getDouble("IGST_AMT");
						invLineItem.camt = lineRs.getDouble("CGST_AMT");
						invLineItem.samt = lineRs.getDouble("SGST_AMT");
						invLineItem.csamt = lineRs.getDouble("CESS_AMT");
						
						invLineItems.add(invLineItem);
					}
					if(linePstmt != null)
					{
						linePstmt.close();
						linePstmt = null;
					}
					if(lineRs != null)
					{
						lineRs.close();
						lineRs = null;
					}
					
					at = new AT();
					at.isReverseCharge = false;
					
					at.pos = posStateCode;
					at.supplyType = checkNullandTrim(rs.getString("DOC_TYPE"));
					at.itms = invLineItems;
					
					atPaidList.add(at);
				}
				//tran_type : 14 = CDNUR
				if("16".equalsIgnoreCase(tranType))
				{
					lineSql = "SELECT * FROM GST_DATA_DET WHERE TRAN_ID = ? ORDER BY LINE_NO";
					linePstmt = conn.prepareStatement(lineSql);
					linePstmt.setString(1, tranId);
					lineRs = linePstmt.executeQuery();
					
					while(lineRs.next())
					{
						invLineItem = new InvLineItem();
						invLineItem.num = lineRs.getInt("LINE_NO");
						invLineItem.rate = lineRs.getDouble("IGST_PERC")+lineRs.getDouble("CGST_PERC")+lineRs.getDouble("SGST_PERC");
						invLineItem.taxval = lineRs.getDouble("TAXABLE_AMT");
						invLineItem.iamt = lineRs.getDouble("IGST_AMT");
						invLineItem.camt = lineRs.getDouble("CGST_AMT");
						invLineItem.samt = lineRs.getDouble("SGST_AMT");
						invLineItem.csamt = lineRs.getDouble("CESS_AMT");
						
						invLineItems.add(invLineItem);
					}
					if(linePstmt != null)
					{
						linePstmt.close();
						linePstmt = null;
					}
					if(lineRs != null)
					{
						lineRs.close();
						lineRs = null;
					}
					
					cdnur = new CDNUR();
					cdnur.isReverseCharge = false;
					cdnur.customerType = "B2CL";//TODO need to change typ value
					cdnur.cdnNoteType = checkNullandTrim(rs.getString("DOC_TYPE"));
					cdnur.cdNoteNumber = checkNullandTrim(rs.getString("DOC_NO"));
					cdnur.cdNoteDate = rs.getDate("DOC_DATE");
					cdnur.invoiceNumber = checkNullandTrim(rs.getString("REF_ID__INV"));
					cdnur.invoiceDate = rs.getDate("REF_DATE__INV");
					cdnur.val = rs.getDouble("AMOUNT");
					cdnur.items = invLineItems;
					
					cdnurList.add(cdnur);
				}
				
				tranIdList.add(tranId);
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
			
			//HSN summary data will be sent every time
			sql = " SELECT GDD.GS_CODE, GDD.GS_DESCR, GDD.UNIT, SUM(GDD.QUANTITY) AS TOT_QTY, SUM(GDD.TAXABLE_AMT) AS TOT_TAXVAL,"
				+ " SUM(GDD.IGST_AMT) AS TOT_IAMT, SUM(CGST_AMT) AS TOT_CAMT, SUM(SGST_AMT) AS TOT_SAMT, SUM(CESS_AMT) AS TOT_CSAMT"
				+ " FROM GST_DATA_HDR GDH, GST_DATA_DET GDD"
				+ " WHERE GDH.TRAN_ID = GDD.TRAN_ID AND GDD.GS_CODE IS NOT NULL "
				+ " AND GDH.PRD_CODE = ?"
				+ " GROUP BY GDD.GS_CODE, GDD.GS_DESCR, GDD.UNIT";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, periodCode);
			rs = pstmt.executeQuery();
			
			while (rs.next()) 
			{
				hsnDetails = new HSNDetails();
				
				hsnDetails.num = ++num;
				hsnDetails.itemOrServiceCode = checkNullandTrim(rs.getString("GS_CODE"));
				hsnDetails.description = checkNullandTrim(rs.getString("GS_DESCR"));
				hsnDetails.unitOfMeasure = checkNullandTrim(rs.getString("UNIT"));
				hsnDetails.quantity = rs.getDouble("TOT_QTY");
				hsnDetails.totalAmount = rs.getDouble("TOT_TAXVAL"); // TODO need to change
				hsnDetails.totalTaxableAmount = rs.getDouble("TOT_TAXVAL");
				hsnDetails.totalIGSTAmount = rs.getDouble("TOT_IAMT");
				hsnDetails.totalCGSTAmount = rs.getDouble("TOT_CAMT");
				hsnDetails.totalSGSTAmount = rs.getDouble("TOT_SAMT");
				hsnDetails.totalCESSAmount = rs.getDouble("TOT_CSAMT");
				
				hsnList.add(hsnDetails);
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
			
			if(hsnList.size() > 0)
			{
				hsn = new HSN();
				hsn.hsnDetails = hsnList;
			}
			
			//TODO need to change START
			docDetails = new DocDetails();
			
			docDetails.docNum = 1;
			docDetails.fromSerialNo = "1";
			docDetails.toSerialNo = "20";
			docDetails.totalNo = 20;
			docDetails.cancelNo = 3;
			docDetails.toatlNetIssued = 17;
			
			docDetailsList.add(docDetails);
			
			docIssued = new DocIssued();
			
			docIssued.serialNumber = 1;
			docIssued.docDescr = "Invoices for outward supply";
			docIssued.docDetails = docDetailsList;
			
			docIssuedList.add(docIssued);
			//TODO need to change END
			
			if(b2bInvoiceList.size() > 0)
			{
				gstr1.b2b = b2bInvoiceList;
			}
			if(b2clInvoiceList.size() > 0)
			{
				gstr1.b2cl = b2clInvoiceList;
			}
			if(b2claInvoiceList.size() > 0)
			{
				gstr1.b2cla = b2claInvoiceList;
			}
			if(b2csInvoiceList.size() > 0)
			{
				gstr1.b2cs = b2csInvoiceList;
			}
			if(b2csaInvoiceList.size() > 0)
			{
				gstr1.b2csa = b2csaInvoiceList;
			}
			if(cdnrList.size() > 0)
			{
				gstr1.cdnr = cdnrList;
			}
			if(cdnraList.size() > 0)
			{
				gstr1.cdnra = cdnraList;
			}
			if(atList.size() > 0)
			{
				gstr1.at = atList;
			}
			if(ataList.size() > 0)
			{
				gstr1.ata = ataList;
			}
			if(expInvoiceList.size() > 0)
			{
				gstr1.exp = expInvoiceList;
			}
			if(atPaidList.size() > 0)
			{
				gstr1.txpd = atPaidList;
			}
			if(cdnurList.size() > 0)
			{
				gstr1.cdnur = cdnurList;
			}
			if(nil != null)
			{
				gstr1.nil = nil;
			}
			if(hsn != null)
			{
				gstr1.hsn = hsn;
			}
			if(docIssuedList.size() > 0)
			{
				gstr1.docIssued = docIssuedList;
			}
			
			if(isDataFound)
			{
				
				String gspAuthString = "", gspAuthSignature = "", gspAuthStringRet = "", gspAuthSignatureRet = "";
				
				ObjectMapper objectMapper = new ObjectMapper();
				
				String json = objectMapper.writeValueAsString(gstr1);
				
				System.out.println("jsonPayload to SAVE GSTR1["+json+"]");
				
				byte[] jsonBase64 = Base64.getEncoder().encode(json.getBytes());
				String encryptedPayload = aesEncryption.encryptEK(jsonBase64, authSek);
				 
				HMac hmac = new HMac(new SHA256Digest());
				byte[] resBuf = new byte[hmac.getMacSize()];
				
				hmac.init(new KeyParameter(authSek));
				hmac.update(jsonBase64, 0, jsonBase64.length);
				hmac.doFinal(resBuf, 0);
				
				JSONObject gstr1HeaderObj = new JSONObject();
				gstr1HeaderObj.put("action", "RETSAVE");
				gstr1HeaderObj.put("data", encryptedPayload);
				gstr1HeaderObj.put("hmac", new String(Base64.getEncoder().encode(resBuf)));
				
				long timeStamp = new Timestamp().getDateTime();
		        gspAuthString = clientId + ":" + transactionId + ":" + timeStamp + ":" + gstin;
				gspAuthSignature = gspSignature.sign(gspAuthString, aspPrivateKey);
				
				HttpResponse<JsonNode> gstr1Resp = Unirest.put(String.format("%s/%s", GSP_API_URL, GSTR1_URL_V3))
												   .header("Content-Type", APPLICATION_JSON)
												   .header("clientid", clientId)
												   .header("client-secret", clientSecret)
												   .header("txn",transactionId)
												   .header("state-cd", stateCode)
												   .header("auth-token", authToken)
												   .header("gstin", gstin)
												   .header("username", userName)
												   .header("ret_period", periodCode)
												   .header("ip-usr", ipAddress.getHostAddress())
												   .header("app_key", appKeyEncryptedAndCoded)
												   .header("X-Asp-Auth-Token", gspAuthString)
							    	               .header("X-Asp-Auth-Signature", gspAuthSignature)
												   .body(new JsonNode(gstr1HeaderObj.toString()))
												   .asJson();
				
				System.out.println(String.format("gstr1Resp Request : Status[%s] Response[%s]", gstr1Resp.getStatus(), gstr1Resp.getBody()));
				
				if (gstr1Resp.getStatus() == 200) 
		        {
					JSONObject gstr1RespObj = gstr1Resp.getBody().getObject();
					
					if(gstr1RespObj.has("data") && gstr1RespObj.has("rek"))
					{
						gstr1Data = gstr1RespObj.getString("data");
						gstr1Rek = gstr1RespObj.getString("rek");
						
						byte[] apiEKGstr1 = aesEncryption.decrypt(gstr1Rek, authSek);
						String Gstr1RespJsoninBase64 = new String(aesEncryption.decrypt(gstr1Data, apiEKGstr1));
						
						byte[] Gstr1RespJsonInBytes = aesEncryption.decodeBase64StringTOByte(Gstr1RespJsoninBase64);
						
						JSONObject Gstr1RespObj = new JSONObject(new String(Gstr1RespJsonInBytes));
						String transId = Gstr1RespObj.getString("reference_id");
						
						System.out.println("transId to getStatus["+transId+"]");
						
						while(true)
						{
							long timeStampRet = new Timestamp().getDateTime();
					        gspAuthStringRet = clientId + ":" + transactionId + ":" + timeStampRet + ":" + gstin;
							gspAuthSignatureRet = gspSignature.sign(gspAuthStringRet, aspPrivateKey);
							
							HttpResponse<JsonNode> retStatusResp = Unirest.get(String.format("%s/%s", GSP_API_URL, GSTR1_URL_V3))
																   .queryString("action","RETSTATUS")
																   .queryString("gstin", gstin)
																   .queryString("ret_period", periodCode)
																   .queryString("trans_id",transId)
																   .header("Content-Type", APPLICATION_JSON)
																   .header("state-cd", stateCode)
																   .header("clientid", clientId)
																   .header("client-secret", clientSecret)
																   .header("ip-usr", ipAddress.getHostAddress())
																   .header("username", userName)
																   .header("auth-token", authToken)
																   .header("app_key", appKeyEncryptedAndCoded)
																   .header("txn", transactionId)
																   .header("ret_period", periodCode)
																   .header("gstin", gstin)
																   .header("X-Asp-Auth-Token", gspAuthStringRet)
											    	               .header("X-Asp-Auth-Signature", gspAuthSignatureRet)
																   .asJson();

							System.out.println(String.format("retStatusResp Request : Status[%s] Response[%s]", retStatusResp.getStatus(), retStatusResp.getBody()));

							if (retStatusResp.getStatus() == 200) 
							{
								JSONObject retStatsRespObj = retStatusResp.getBody().getObject();
								if(retStatsRespObj.has("data") && retStatsRespObj.has("rek"))
								{
									retStatsData = retStatsRespObj.getString("data");
									retStatsRek = retStatsRespObj.getString("rek");

									byte[] apiEKRetstats = aesEncryption.decrypt(retStatsRek, authSek);

									String retStatsRespJsoninBase64 = new String(aesEncryption.decrypt(retStatsData, apiEKRetstats));

									byte[] retStatsRespJsonInBytes = aesEncryption.decodeBase64StringTOByte(retStatsRespJsoninBase64);

									JSONObject retStatsJsonData = new JSONObject(new String(retStatsRespJsonInBytes));
									System.out.println( "retStatsJsonData["+retStatsJsonData+"]");
									
									if("IP".equalsIgnoreCase((String)retStatsJsonData.get("status_cd")))
									{
										continue;
									}
									else if("P".equalsIgnoreCase((String)retStatsJsonData.get("status_cd")))
									{
										if(tranIdList.size() > 0)
										{
											updateSubmissionStatus(tranIdList, conn);
										}
										break;
									}
									else if("PE".equalsIgnoreCase((String)retStatsJsonData.get("status_cd")))
									{
										errMsg = getRetStatusErrMsg(retStatsJsonData);
										retString = getError(errMsg, "GSTAPIERR", conn);
										break;
									}
									else if("ER".equalsIgnoreCase(retStatsJsonData.getString("status_cd")))
									{
										errMsg = "Message : "+retStatsJsonData.getString("error_msg")+" \nError code : "+retStatsJsonData.getString("errorCd");
										retString = getError(errMsg, "GSTAPIERR", conn);
										break;
									}
								}
								else
								{
									JSONObject errorJSON = retStatusResp.getBody().getObject().getJSONObject("error");
									errMsg = "Message : "+errorJSON.getString("message")+" \nError code : "+errorJSON.getString("error_cd");
									retString = getError(errMsg, "GSTAPIERR", conn);
									break;
								}
							}
							else
							{
								JSONObject errorJSON = retStatusResp.getBody().getObject().getJSONObject("error");
								errMsg = "Message : "+errorJSON.getString("desc")+" \nError code : "+errorJSON.getString("code");
								retString = getError(errMsg, "GSTAPIERR", conn);
								break;
							}
						}
					}
					else
		            {
						JSONObject errorJSON = gstr1Resp.getBody().getObject().getJSONObject("error");
			        	errMsg = "Message : "+errorJSON.getString("message")+" \nError code : "+errorJSON.getString("error_cd");
			        	retString = getError(errMsg, "GSTAPIERR", conn);
		            }
		        }
				else
	            {
	            	JSONObject errorJSON = gstr1Resp.getBody().getObject().getJSONObject("error");
		        	errMsg = "Message : "+errorJSON.getString("desc")+" \nError code : "+errorJSON.getString("code");
		        	retString = getError(errMsg, "GSTAPIERR", conn);
	            }
			}
			else
			{
				retString = new ITMDBAccessEJB().getErrorString("","VTNOGSDATA","","",conn);
			}
		}
		catch (Exception e) 
		{
			System.out.println("GSTDataSubmitWizPos.saveGstr1()["+e.getMessage()+"]");
			e.printStackTrace();
			throw new ITMException(e);
		}
		return retString;
	}
	private String getGstr1Summary(String authToken, String stateCode, String userName, String gstin, String periodCode, byte[] authSek, String action, Connection conn) throws ITMException
	{
		String retString = "";
		String errMsg = "", gspAuthString = "", gspAuthSignature = "";
		String transactionId = UUID.randomUUID().toString().replaceAll("-", "");
		try
		{
			long timeStamp = new Timestamp().getDateTime();
	        gspAuthString = clientId + ":" + transactionId + ":" + timeStamp + ":" + gstin;
			gspAuthSignature = gspSignature.sign(gspAuthString, aspPrivateKey);
			
			HttpResponse<JsonNode> getGstr1SumryResp = Unirest.get(String.format("%s/%s", GSP_API_URL, GSTR1_URL_V3))
													   .queryString("action","RETSUM")
													   .queryString("gstin", gstin)
													   .queryString("ret_period", periodCode)
													   .header("Content-Type", APPLICATION_JSON)
													   .header("state-cd", stateCode)
													   .header("clientid", clientId)
													   .header("client-secret", clientSecret)
													   .header("ip-usr", ipAddress.getHostAddress())
													   .header("username", userName)
													   .header("auth-token", authToken)
													   .header("app_key", appKeyEncryptedAndCoded)
													   .header("txn", transactionId)
													   .header("ret_period", periodCode)
													   .header("gstin", gstin)
													   .header("X-Asp-Auth-Token", gspAuthString)
								    	               .header("X-Asp-Auth-Signature", gspAuthSignature)
													   .asJson();
			
			System.out.println(String.format("getGstr1SumryResp Request : Status[%s] Response[%s]", getGstr1SumryResp.getStatus(), getGstr1SumryResp.getBody()));
			
			if (getGstr1SumryResp.getStatus() == 200) 
	        {
				JSONObject getGstr1SumryRespObj = getGstr1SumryResp.getBody().getObject();
				if(getGstr1SumryRespObj.has("data") && getGstr1SumryRespObj.has("rek"))
				{
					String gstr1Sumrydata = getGstr1SumryRespObj.getString("data");
					String gstr1Sumryrek = getGstr1SumryRespObj.getString("rek");
					
					byte[] apiEK = aesEncryption.decrypt(gstr1Sumryrek, authSek);
					
					String respJsoninBase64 = new String(aesEncryption.decrypt(gstr1Sumrydata, apiEK));
					
					byte[] respJsonInBytes = aesEncryption.decodeBase64StringTOByte(respJsoninBase64);
					
					JSONObject gstr1SumryJsonObj = new JSONObject(new String(respJsonInBytes));
					//String jsonData = new String(respJsonInBytes);
					System.out.println(gstr1SumryJsonObj);
					
					if("FILE".equalsIgnoreCase(action))
					{
						String gspAuthStringFile = "", gspAuthSignatureFile = "";
						
						byte[] jsonBase64 = Base64.getEncoder().encode(gstr1SumryJsonObj.toString().getBytes());
						String encryptedPayload = aesEncryption.encryptEK(jsonBase64, authSek);
						
						HMac hmac = new HMac(new SHA256Digest());
						byte[] resBuf = new byte[hmac.getMacSize()];
						
						hmac.init(new KeyParameter(authSek));
						hmac.update(jsonBase64, 0, jsonBase64.length);
						hmac.doFinal(resBuf, 0);
						
						JSONObject fileGstr1DataJsonObj = new JSONObject();
						fileGstr1DataJsonObj.put("action", "RETFILE");
						fileGstr1DataJsonObj.put("data", encryptedPayload);
						fileGstr1DataJsonObj.put("hmac", new String(Base64.getEncoder().encode(resBuf)));
						fileGstr1DataJsonObj.put("sign", "asfasfasfu3dsfkj3kjdv=");
						fileGstr1DataJsonObj.put("st", "DSC");
						fileGstr1DataJsonObj.put("sid", "AMAPT8269L");
						
						long timeStampFile = new Timestamp().getDateTime();
				        gspAuthStringFile = clientId + ":" + transactionId + ":" + timeStamp + ":" + gstin;
						gspAuthSignatureFile = gspSignature.sign(gspAuthStringFile, aspPrivateKey);
						
						HttpResponse<JsonNode> fileGstr1Resp = Unirest.post(String.format("%s/%s", GSP_API_URL, GSTR1_URL_V3))
															   .header("Content-Type", APPLICATION_JSON)
															   .header("state-cd", stateCode)
															   .header("clientid", clientId)
															   .header("client-secret", clientSecret)
															   .header("ip-usr", ipAddress.getHostAddress())
															   .header("username", userName)
															   .header("auth-token", authToken)
															   .header("app_key", appKeyEncryptedAndCoded)
															   .header("txn", transactionId)
															   .header("ret_period", periodCode)
															   .header("gstin", gstin)
															   .header("X-Asp-Auth-Token", gspAuthStringFile)
										    	               .header("X-Asp-Auth-Signature", gspAuthSignatureFile)
															   .body(new JsonNode(fileGstr1DataJsonObj.toString()))
															   .asJson();
						
						System.out.println(String.format("fileGstr1Resp Request : Status[%s] Response[%s]", fileGstr1Resp.getStatus(), fileGstr1Resp.getBody()));
						if (fileGstr1Resp.getStatus() == 200) 
				        {
							JSONObject fileGstr1RespObj = fileGstr1Resp.getBody().getObject();
							if(fileGstr1RespObj.has("data") && fileGstr1RespObj.has("rek"))
							{
								String fileGstr1Data = fileGstr1RespObj.getString("data");
								String fileGstr1Rek = fileGstr1RespObj.getString("rek");
								
								byte[] fileGstr1ApiEK = aesEncryption.decrypt(fileGstr1Rek, authSek);
								
								String fileGstr1JsoninBase64 = new String(aesEncryption.decrypt(fileGstr1Data, fileGstr1ApiEK));
								
								byte[] fileGstr1JsonInBytes = aesEncryption.decodeBase64StringTOByte(fileGstr1JsoninBase64);
								
								System.out.println(new String(fileGstr1JsonInBytes));
							}
							else
							{
								JSONObject errorJSON = fileGstr1Resp.getBody().getObject().getJSONObject("error");
					        	errMsg = "Message : "+errorJSON.getString("message")+" \nError code : "+errorJSON.getString("error_cd");
					        	retString = getError(errMsg, "GSTAPIERR", conn);
							}
				        }
						else
						{
							JSONObject errorJSON = fileGstr1Resp.getBody().getObject().getJSONObject("error");
				        	errMsg = "Message : "+errorJSON.getString("message")+" \nError code : "+errorJSON.getString("error_cd");
				        	retString = getError(errMsg, "GSTAPIERR", conn);
						}
					}
				}
				else
	            {
					JSONObject errorJSON = getGstr1SumryResp.getBody().getObject().getJSONObject("error");
		        	errMsg = "Message : "+errorJSON.getString("message")+" \nError code : "+errorJSON.getString("error_cd");
		        	retString = getError(errMsg, "GSTAPIERR", conn);
	            }
	        }
			else
            {
            	JSONObject errorJSON = getGstr1SumryResp.getBody().getObject().getJSONObject("error");
            	errMsg = "Message : "+errorJSON.getString("desc")+" \nError code : "+errorJSON.getString("code");
	        	retString = getError(errMsg, "GSTAPIERR", conn);
            }
		}
		catch(Exception e)
		{
			System.out.println("GSTDataSubmitWizPos.getGstr1Summary()["+e.getMessage()+"]");
			e.printStackTrace();
			throw new ITMException(e);
		}
		return retString;
	}
	
	private String submitGstr1(String authToken, String stateCode, String userName, String gstin, String periodCode, byte[] authSEK, Connection conn) throws ITMException
	{
		String retString = "";
		String errMsg = "", gspAuthString = "", gspAuthSignature = "";
		String transactionId = UUID.randomUUID().toString().replaceAll("-", "");
		try
		{
			
			String json = "{\"gstin\":\""+gstin+"\",\"ret_period\":\""+periodCode+"\"}";
            
            byte[] jsonBase64 = Base64.getEncoder().encode(json.getBytes());
			String encryptedPayload = aesEncryption.encryptEK(jsonBase64, authSEK);
			 
			HMac hmac = new HMac(new SHA256Digest());
			byte[] resBuf = new byte[hmac.getMacSize()];
			
			hmac.init(new KeyParameter(authSEK));
			hmac.update(jsonBase64, 0, jsonBase64.length);
			hmac.doFinal(resBuf, 0);
            
			JSONObject reqBody = new JSONObject();
            reqBody.put("action", "RETSUBMIT");
            reqBody.put("data", encryptedPayload);
            reqBody.put("hmac", new String(Base64.getEncoder().encode(resBuf)));
            
            long timeStamp = new Timestamp().getDateTime();
	        gspAuthString = clientId + ":" + transactionId + ":" + timeStamp + ":" + gstin;
			gspAuthSignature = gspSignature.sign(gspAuthString, aspPrivateKey);
            
            HttpResponse<JsonNode> gstr1SubmitResp = Unirest.post(String.format("%s/%s", GSP_API_URL, GSTR1_URL_V3))
            										.header("Content-Type", APPLICATION_JSON)
            										.header("action", "RETSUBMIT")
            				                        .header("state-cd", stateCode)
            				                        .header("clientid", clientId)
            				                        .header("client-secret", clientSecret)
            				                        .header("ip-usr", ipAddress.getHostAddress())
            				                        .header("username", userName)
            				                        .header("auth-token", authToken)
            				                        .header("app_key", appKeyEncryptedAndCoded)
            				                        .header("txn", transactionId)
            				                        .header("ret_period", periodCode)
            				                        .header("gstin", gstin)
            				                        .header("X-Asp-Auth-Token", gspAuthString)
								    	              .header("X-Asp-Auth-Signature", gspAuthSignature)
            				                        .body(new JsonNode(reqBody.toString()))
            				                        .asJson();
            
            System.out.println(String.format("gstr1SubmitResp Request : Status[%s] Response[%s]", gstr1SubmitResp.getStatus(), gstr1SubmitResp.getBody()));
            
            if (gstr1SubmitResp.getStatus() == 200) 
	        {
				JSONObject gstr1SubmitRespObj = gstr1SubmitResp.getBody().getObject();
				if(gstr1SubmitRespObj.has("data") && gstr1SubmitRespObj.has("rek"))
				{
					String gstr1Submitdata = gstr1SubmitRespObj.getString("data");
					String gstr1Submitrek = gstr1SubmitRespObj.getString("rek");
					
					byte[] apiEK = aesEncryption.decrypt(gstr1Submitrek, authSEK);
					String respJsoninBase64 = new String(aesEncryption.decrypt(gstr1Submitdata, apiEK));
					
					byte[] respJsonInBytes = aesEncryption.decodeBase64StringTOByte(respJsoninBase64);
					
					JSONObject gstr1SubmitObj = new JSONObject(new String(respJsonInBytes));
					String transId = gstr1SubmitObj.getString("reference_id");
					
					System.out.println("transId to getStatus after SUBMIT call["+transId+"]");
				}
				else
	            {
					JSONObject errorJSON = gstr1SubmitResp.getBody().getObject().getJSONObject("error");
		        	errMsg = "Message : "+errorJSON.getString("message")+" \nError code : "+errorJSON.getString("error_cd");
		        	retString = getError(errMsg, "GSTAPIERR", conn);
	            }
	        }
			else
            {
            	JSONObject errorJSON = gstr1SubmitResp.getBody().getObject().getJSONObject("error");
            	errMsg = "Message : "+errorJSON.getString("desc")+" \nError code : "+errorJSON.getString("code");
	        	retString = getError(errMsg, "GSTAPIERR", conn);
            }
		}
		catch(Exception e)
		{
			System.out.println("GSTDataSubmitWizPos.submitGstr1()["+e.getMessage()+"]");
			e.printStackTrace();
			throw new ITMException(e);
		}
		return retString;
	}
	
	private String getGstr2Invoices(String authToken, String stateCode, String userName, String gstin, String periodCode, String siteCode, byte[] authSEK, Connection conn) throws ITMException
	{
		String retString = "";
		String errMsg = "", gspAuthString = "", gspAuthSignature = "";
		String transactionId = UUID.randomUUID().toString().replaceAll("-", "");
		
		try
		{
			long timeStamp = new Timestamp().getDateTime();
	        gspAuthString = clientId + ":" + transactionId + ":" + timeStamp + ":" + gstin;
			gspAuthSignature = gspSignature.sign(gspAuthString, aspPrivateKey);
			
			 HttpResponse<JsonNode> getGstr2InvoicesResp = Unirest.get(String.format("%s/%s", GSP_API_URL, GSTR2_URL_V3))
						     				  		   	   .queryString("action", "B2B")
						     				  		   	   .queryString("gstin", gstin)
						     				  		   	   .queryString("ret_period", periodCode)
						     				  		   	   .header("Content-Type", APPLICATION_JSON)
						     				  		   	   .header("state-cd", stateCode)
						     				  		   	   .header("clientid", clientId)
						     				  		   	   .header("client-secret", clientSecret)
						     				  		   	   .header("ip-usr", ipAddress.getHostAddress())
						     				  		   	   .header("username", userName)
						     				  		   	   .header("auth-token", authToken)
						     				  		   	   .header("app_key", appKeyEncryptedAndCoded)
						     				  		   	   .header("txn", transactionId)
						     				  		   	   .header("ret_period", periodCode)
						     				  		   	   .header("gstin", gstin)
						     				  		   	   .header("X-Asp-Auth-Token", gspAuthString)
									    	               .header("X-Asp-Auth-Signature", gspAuthSignature)
						     				  		   	   .asJson();
			 
			 System.out.println(String.format("getGstr2InvoicesResp Request : Status[%s] Response[%s]", getGstr2InvoicesResp.getStatus(), getGstr2InvoicesResp.getBody()));
			 
			 if (getGstr2InvoicesResp.getStatus() == 200) 
			 {
				 JSONObject getGstr2InvoicesRespObj = getGstr2InvoicesResp.getBody().getObject();
				 if(getGstr2InvoicesRespObj.has("data") && getGstr2InvoicesRespObj.has("rek"))
				 {
					 String gstr2InvoicesData = getGstr2InvoicesRespObj.getString("data");
					 String gstr2InvoicesRek = getGstr2InvoicesRespObj.getString("rek");

					 byte[] apiEK = aesEncryption.decrypt(gstr2InvoicesRek, authSEK);
					 String respJsoninBase64 = new String(aesEncryption.decrypt(gstr2InvoicesData, apiEK));

					 byte[] respJsonInBytes = aesEncryption.decodeBase64StringTOByte(respJsoninBase64);
					 
					 JSONObject gstr2InvoiceJsonObj = new JSONObject(new String(respJsonInBytes));

					 System.out.println("respJsonInBytes["+new String(respJsonInBytes)+"]");
					 
					 saveDownloadedData(siteCode, gstr2InvoiceJsonObj, conn);

				 }
				 else
				 {
					 JSONObject errorJSON = getGstr2InvoicesResp.getBody().getObject().getJSONObject("error");
					 errMsg = "Message : "+errorJSON.getString("message")+" \nError code : "+errorJSON.getString("error_cd");
					 retString = getError(errMsg, "GSTAPIERR", conn);
				 }
			 }
			 else
			 {
				 JSONObject errorJSON = getGstr2InvoicesResp.getBody().getObject().getJSONObject("error");
				 errMsg = "Message : "+errorJSON.getString("desc")+" \nError code : "+errorJSON.getString("code");
				 retString = getError(errMsg, "GSTAPIERR", conn);
			 }
		}
		catch(Exception e)
		{
			System.out.println("GSTDataSubmitWizPos.getGstr2Invoices()["+e.getMessage()+"]");
			e.printStackTrace();
			throw new ITMException(e);
		}
		return retString;
	}
	
	private void saveDownloadedData(String siteCode,JSONObject gstr2InvoiceJsonObj, Connection conn) throws ITMException
	{
		JSONArray b2bInvArry = new JSONArray();
		JSONObject b2bJsonObj = new JSONObject();
		JSONArray b2bInvJsonArry = new JSONArray();
		JSONObject b2bInvJsonObj = new JSONObject();
		JSONArray b2bInvLineItmsArry = new JSONArray();
		JSONObject b2bInvLineItemObj = new JSONObject();
		String tranId, cptyGSTIN, iNum, iDate, reversCharge, docCheckSum, stateCode="", gstStateCode; 
		String lineType, hsnSC;
		
		int lineNo;
		double amount, lineAmt, irt, iamt, crt, camt, srt, samt, csrt, csamt; 
	 	
		String hdrSql, detSql, dataSql;
		PreparedStatement hdrPstmt, detPstmt, dataPstmt;
		ResultSet dataRs;
		
		try
		{
			b2bInvArry = gstr2InvoiceJsonObj.getJSONArray("b2b");
			
			for(int i = 0; i < b2bInvArry.length(); i++)
			{
				b2bJsonObj = b2bInvArry.getJSONObject(i);
				cptyGSTIN = b2bJsonObj.getString("ctin");
				
				b2bInvJsonArry = b2bJsonObj.getJSONArray("inv");
				
				for(int j=0; j<b2bInvJsonArry.length(); j++)
				{
					b2bInvJsonObj = b2bInvJsonArry.getJSONObject(j);
					
					iNum = b2bInvJsonObj.getString("inum");
					iDate = b2bInvJsonObj.getString("idt");
					amount = b2bInvJsonObj.getDouble("val");
					docCheckSum = b2bInvJsonObj.getString("chksum");
					reversCharge = b2bInvJsonObj.getString("rchrg");
					gstStateCode = b2bInvJsonObj.getString("pos");
					
					dataSql = "SELECT STATE_CODE FROM STATE WHERE GST_CODE = ? ";
					dataPstmt = conn.prepareStatement(dataSql);
					dataPstmt.setString(1, gstStateCode);
					dataRs = dataPstmt.executeQuery();
					
					if(dataRs.next())
					{
						stateCode = checkNullandTrim(dataRs.getString("STATE_CODE"));
					}
					if(dataPstmt != null)
					{
						dataPstmt.close();
						dataPstmt = null;
					}
					if(dataRs != null)
					{
						dataRs.close();
						dataRs = null;
					}
					
					tranId = generateTranId("w_gstr_purc","","",conn);
					
					hdrSql = "INSERT INTO GST_DATA_HDR (TRAN_ID, TRAN_DATE, REC_TYPE, TRAN_TYPE, STATE_CODE, SUBMIT_STATUS, DOC_CHECKSUM, DOC_NO, DOC_DATE, AMOUNT, REVERSE_CHRG, TAX_REG_NO, SITE_CODE) "
						   + "VALUES (?,?,'2','01',?,'D',?,?,?,?,?,?,?)";
					hdrPstmt = conn.prepareStatement(hdrSql);
					hdrPstmt.setString(1, tranId);
					hdrPstmt.setString(2, new SimpleDateFormat(new E12GenericUtility().getApplDateFormat()).format(new Date()));
					hdrPstmt.setString(3, stateCode);
					hdrPstmt.setString(4, docCheckSum);
					hdrPstmt.setString(5, iNum);
					hdrPstmt.setString(6, iDate);
					hdrPstmt.setDouble(7, amount);
					hdrPstmt.setString(8, reversCharge);
					hdrPstmt.setString(9, cptyGSTIN);
					hdrPstmt.setString(10, siteCode);
					
					int hdrCnt = hdrPstmt.executeUpdate();
					
					System.out.println("GST_DATA_HDR insert count ["+hdrCnt+"]");
					
					b2bInvLineItmsArry = b2bInvJsonObj.getJSONArray("itms");
					
					detSql = "INSERT INTO GST_DATA_DET (TRAN_ID, LINE_NO, LINE_TYPE, GS_CODE, TAXABLE_AMT, IGST_PERC, IGST_AMT, CGST_PERC, CGST_AMT, SGST_PERC, SGST_AMT, CESS_PERC, CESS_AMT) "
						   + "VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?)";
					
					detPstmt = conn.prepareStatement(detSql);
					
					for(int k=0; k<b2bInvLineItmsArry.length(); k++)
					{
						b2bInvLineItemObj = b2bInvLineItmsArry.getJSONObject(k);
						
						lineNo = b2bInvLineItemObj.getInt("num");
						
						JSONObject tempJSONObj = b2bInvLineItemObj.getJSONObject("itm_det");
						
						lineType = tempJSONObj.getString("ty");
						lineAmt = tempJSONObj.getDouble("txval");
						hsnSC = tempJSONObj.getString("hsn_sc");
						irt = tempJSONObj.getDouble("irt");
						iamt = tempJSONObj.getDouble("iamt");
						crt = tempJSONObj.getDouble("crt");
						camt = tempJSONObj.getDouble("camt");
						srt = tempJSONObj.getDouble("srt");
						samt = tempJSONObj.getDouble("samt");
						csrt = tempJSONObj.getDouble("csrt");
						csamt = tempJSONObj.getDouble("csamt");
						
						detPstmt.setString(1, tranId);
						detPstmt.setInt(2, lineNo);
						detPstmt.setString(3, lineType);
						detPstmt.setString(4, hsnSC);
						detPstmt.setDouble(5, lineAmt);
						detPstmt.setDouble(6, irt);
						detPstmt.setDouble(7, iamt);
						detPstmt.setDouble(8, crt);
						detPstmt.setDouble(9, camt);
						detPstmt.setDouble(10, srt);
						detPstmt.setDouble(11, samt);
						detPstmt.setDouble(12, csrt);
						detPstmt.setDouble(13, csamt);
						
						detPstmt.addBatch();
						detPstmt.clearParameters();
					}
					
					int[] detCnt = detPstmt.executeBatch();
					
					System.out.print("GST_DATA_DET insert count");
					
					for(int eachRowCnt : detCnt)
					{
						System.out.print(eachRowCnt + ",");
					}
				}
				
			}
		}
		catch (Exception e)
		{
			System.out.println("GSTDataSubmitWizPos.saveDownloadedData()["+e.getMessage()+"]");
			e.printStackTrace();
			throw new ITMException(e);
		}
	}
	
	private void updateSubmissionStatus(ArrayList<String> tranIdList, Connection conn) throws ITMException
	{
		String updateSql = "";
		PreparedStatement pstmtUpd = null;
		
		try
		{
			updateSql = "UPDATE GST_DATA_HDR SET SUBMISSION_STATUS = ?, SUBMISSION_DATE = ? WHERE TRAN_ID = ?";
			pstmtUpd = conn.prepareStatement(updateSql);
			
			for(String tranId : tranIdList)
			{
				pstmtUpd.setString(1, "S");
				pstmtUpd.setString(2, new SimpleDateFormat(new E12GenericUtility().getApplDateFormat()).format(new Date()));
				pstmtUpd.setString(3, tranId);
				
				pstmtUpd.addBatch();
				pstmtUpd.clearParameters();
			}
			
			int[] updateCount = pstmtUpd.executeBatch();
			
			System.out.print("GST_DATA_HSR Update count");
			
			for(int eachRowCnt : updateCount)
			{
				System.out.print(eachRowCnt + ",");
			}
		}
		catch (Exception e) 
		{
			System.out.println("GSTDataSubmitWizPos.updateSubmissionStatus()["+e.getMessage()+"]");
			e.printStackTrace();
			throw new ITMException(e);
		}
	}
	
	private String getError(String errMsg, String Code, Connection conn)  throws ITMException, Exception
	{
		String mainStr ="";

		try
		{
			String errString = "";
			errString =  new ITMDBAccessEJB().getErrorString("",Code,"","",conn);
			
			String begPart = errString.substring(0,errString.indexOf("</description>"));
			String endDesc = errString.substring(errString.indexOf("</description>"),errString.length());
			mainStr = checkNullandTrim(begPart) + "<![CDATA[" +errMsg+ " ]]>" + checkNullandTrim(endDesc);
			System.out.println("mainStr:::::::::::::::::: "+mainStr);
			begPart = null;
		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		return mainStr;
	}
	
	private String getRetStatusErrMsg(JSONObject retStatusJsonObj) throws ITMException
	{
		String retString = "";
		JSONObject errorJsonObj = null;
		JSONArray eachInvErrorJsonArry = null;
		
		try
		{
			errorJsonObj = retStatusJsonObj.getJSONObject("error_report");
			
			if(errorJsonObj.has("b2b"))
			{
				eachInvErrorJsonArry = errorJsonObj.getJSONArray("b2b");
			}
			else if(errorJsonObj.has("b2ba"))
			{
				eachInvErrorJsonArry = errorJsonObj.getJSONArray("b2ba");
			}
			else if(errorJsonObj.has("b2cl"))
			{
				eachInvErrorJsonArry = errorJsonObj.getJSONArray("b2cl");
			}
			else if(errorJsonObj.has("b2cla"))
			{
				eachInvErrorJsonArry = errorJsonObj.getJSONArray("b2cla");
			}
			else if(errorJsonObj.has("b2cs"))
			{
				eachInvErrorJsonArry = errorJsonObj.getJSONArray("b2cs");
			}
			else if(errorJsonObj.has("b2csa"))
			{
				eachInvErrorJsonArry = errorJsonObj.getJSONArray("b2csa");
			}
			else if(errorJsonObj.has("cdnr"))
			{
				eachInvErrorJsonArry = errorJsonObj.getJSONArray("cdnr");
			}
			else if(errorJsonObj.has("cdnra"))
			{
				eachInvErrorJsonArry = errorJsonObj.getJSONArray("cdnra");
			}
			else if(errorJsonObj.has("at"))
			{
				eachInvErrorJsonArry = errorJsonObj.getJSONArray("at");
			}
			else if(errorJsonObj.has("ata"))
			{
				eachInvErrorJsonArry = errorJsonObj.getJSONArray("ata");
			}
			
			
			for(int i=0; i<eachInvErrorJsonArry.length(); i++)
			{
				JSONObject tempJsonObj = (JSONObject) eachInvErrorJsonArry.get(i); 
				retString += tempJsonObj.getString("error_msg")+"\n";
				if(tempJsonObj.has("ty") && tempJsonObj.has("hsn_sc"))
				{
					retString += " Line Type : "+tempJsonObj.optString("ty")+ " Item/Service Code : "+tempJsonObj.optString("hsn_sc")+"\n";
				}
				else if(tempJsonObj.has("nt_num") && tempJsonObj.has("nt_dt"))
				{
					retString += " Credit/Debit No. : "+tempJsonObj.optString("nt_num")+ " Credit/Debit Dt. : "+tempJsonObj.optString("nt_dt")+"\n";
				}
				else if(tempJsonObj.has("doc_num") && tempJsonObj.has("doc_dt") && tempJsonObj.has("typ"))
				{
					retString += " Doc No. : "+tempJsonObj.optString("doc_num")+ " Doc Dt. : "+tempJsonObj.optString("doc_dt")+ " Inv Type : "+tempJsonObj.optString("typ")+"\n";
				}
			}
		}
		catch(Exception e)
		{
			System.out.println("GSTDataSubmitWizPos.getRetStatusErrMsg()["+e.getMessage()+"]");
			e.printStackTrace();
			throw new ITMException(e);
		}
		
		return retString;
	}
	
	private static String checkNullandTrim(String input)
	{
		if (input==null)
		{
			input="";
		}
		return input.trim();
	}
	
	private String generateTranId( String windowName, String siteCode, String tranDateStr, Connection conn )throws ITMException,Exception
	{
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String selSql = "";
		String tranId = "";
		String tranSer = "";
		String keyString = "";
		String keyCol = "";
		String xmlValues = "";	

		try
		{
			selSql = "SELECT KEY_STRING, TRAN_ID_COL, REF_SER FROM TRANSETUP WHERE TRAN_WINDOW = ? ";
			pstmt = conn.prepareStatement(selSql);
			pstmt.setString( 1, windowName );
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				keyString = rs.getString("KEY_STRING");
				keyCol = rs.getString("TRAN_ID_COL");
				tranSer = rs.getString("REF_SER");
			}
			rs.close();rs = null;
			pstmt.close();pstmt = null;
			System.out.println("keyString :"+keyString);
			System.out.println("keyCol :"+keyCol);
			System.out.println("tranSer :"+tranSer);

			xmlValues ="<?xml version=\"1.0\" encoding=\"utf-8\"?><Root>";
			xmlValues = xmlValues + "<Header></Header>";
			xmlValues = xmlValues + "<Detail1>";
			xmlValues = xmlValues +		"<tran_id></tran_id>";
			xmlValues = xmlValues +		"<site_code>" + siteCode + "</site_code>";
			xmlValues = xmlValues +		"<tran_date>" + tranDateStr + "</tran_date>"; 
			xmlValues = xmlValues + "</Detail1></Root>";
			System.out.println("xmlValues  :["+xmlValues+"]");
			TransIDGenerator tg = new TransIDGenerator(xmlValues, "BASE", CommonConstants.DB_NAME);
			tranId = tg.generateTranSeqID(tranSer, keyCol, keyString, conn);
			System.out.println("tranId :"+tranId);

		}
		catch (SQLException ex)
		{
			System.out.println("Exception ::" +selSql+ ex.getMessage() + ":");
			ex.printStackTrace();
			throw new ITMException(ex);
		}
		catch (Exception e)
		{
			System.out.println("Exception ::" + e.getMessage() + ":");
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			if (rs != null)
			{
				rs.close();
				rs = null;
			}
			if (pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
		}
		return tranId;
	}

}
