package ibase.dashboard.sfa.ejb;
import ibase.dashboard.Report.Utility.DashboardUtility;
import ibase.system.config.ConnDriver;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.ITMException;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import javax.ejb.Stateless;
import org.json.simple.JSONObject;
/**
 * Session Bean implementation class RSRSurveyDetails
 */
@Stateless
public class RSRSurveyEJB extends ValidatorEJB implements RSRSurveyRemote, RSRSurveyLocal {
    public RSRSurveyEJB() {
    }
    
    @SuppressWarnings("unchecked")
	public JSONObject getRSRSurveyDetails(String loginId, String salesPerson, String month, String year,String dataSourceName) throws RemoteException, ITMException
    {
		JSONObject rawDataRSRSurveyWiseJson = new JSONObject();
		JSONObject rowData = null;
		String sql = "";
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		Connection conn = null;
		ConnDriver connDriver = new ConnDriver();
		DashboardUtility dashbordUtil = null;
		
		try
		{
			System.out.println(" Inside RSRSurveyEJB for Data Soruc Name ="+dataSourceName+" loginId:"+loginId+" salesPerson is =" + salesPerson +" month is =" + month +" year is =" + year);			
			dashbordUtil = new DashboardUtility();
			salesPerson  = dashbordUtil.getCommaSeparated(salesPerson);
			conn         = connDriver.getConnectDB(dataSourceName);
			connDriver   = null;	
			
			/*sql = 	" select a.date_1,a.sales_pers as insight_id,sales_pers.sp_name as sales_person_name,a. strg_code as strg_code, "
					+" nvl(strg_customer.first_name,' ') ||nvl(strg_customer.middle_name,' ') || nvl(strg_customer.last_name,' ')  as strg_name, "
					+" survey_master.descr as Questions,a.answer as answers,station.descr as territory,a.dcr_id,a.question_code "
					+" from ( select (max(sprs_act_tran.event_date) over (PARTITION BY  strg_surv_res.strg_code,sprs_act_tran.sales_pers)) as date_1, "
					+" sprs_act_tran.event_date  as date_2,sprs_act_tran.sales_pers as sales_pers,sprs_act_tran.dcr_id as dcr_id, "
					+" strg_surv_res.strg_code as strg_code,strg_surv_res.survey_code as question_code,strg_surv_res.result as answer "
					+" from sprs_act_tran,strg_surv_res where sprs_act_tran.dcr_id=strg_surv_res.dcr_id "
					+" and sprs_act_tran.event_date between trunc(to_date('"+month+"'||'"+year+"','MONYYYY'),'MON') "
					+" and last_day(to_date('"+month+"'||'"+year+"','MONYYYY')) "
					+" AND sprs_act_tran.sales_pers IN (select emp_code from employee start with "
					+" emp_code = (select emp_code from users where code='"+loginId+"' "
					+" and (Profile_Id = 'RSR-BEM1' OR Profile_Id = 'ADMIN' OR Profile_Id ='FLM-RBM' ) ) "
					+" connect by prior emp_code = report_to ) "
					+" and sprs_act_tran.sales_pers in ("+ salesPerson +") ) a, "
					+" survey_master, sales_pers, strg_customer ,employee left outer join station on trim(employee.hobby4)=trim(station.stan_code) "
					+" where a.date_1=a.date_2 and a.question_code=survey_master.survey_code "
					+" and sales_pers.sales_pers=a.sales_pers and a.strg_code=strg_customer.sc_code "
					+" and sales_pers.sales_pers=employee.emp_code and sales_pers.item_ser='OTC' "
					+" order by a.sales_pers, a. strg_code, a.question_code";
			*/
			
			sql = " select a.date_1, a.sales_pers as insight_id, sales_pers.sp_name as sales_person_name, a. strg_code " +
					" as strg_code, nvl(strg_customer.first_name,' ') ||nvl(strg_customer.middle_name,' ') " +
					" || nvl(strg_customer.last_name,' ')  as strg_name, survey_master.descr as Questions, " +
					" a.answer as answers, station.descr as territory, a.dcr_id, a.question_code   " +
					" from ( select (max(sprs_act_tran.event_date) over (PARTITION BY strg_surv_res.strg_code,sprs_act_tran.sales_pers)) " +
					" as date_1, sprs_act_tran.event_date  as date_2, sprs_act_tran.sales_pers as sales_pers, " +
					" sprs_act_tran.dcr_id as dcr_id, strg_surv_res.strg_code as strg_code, " +
					" strg_surv_res.survey_code as question_code, strg_surv_res.result as answer " +
					" from sprs_act_tran, strg_surv_res where sprs_act_tran.dcr_id=strg_surv_res.dcr_id  and sprs_act_tran.event_date  " +
					" between trunc(to_date('"+month+"'||'"+year+"','MONYYYY'),'MON') and last_day(to_date('"+month+"'||'"+year+"','MONYYYY'))  " +
					" and sprs_act_tran.sales_pers in (SELECT CODE FROM USERS WHERE PROFILE_ID='RSR-BEM1') ) a, " +
					" survey_master, sales_pers, strg_customer ,employee left outer join station on employee.hobby4=station.stan_code " +
					" where a.date_1=a.date_2 and a.question_code=survey_master.survey_code and sales_pers.sales_pers=a.sales_pers " +
					" and a.strg_code=strg_customer.sc_code and sales_pers.sales_pers=employee.emp_code and sales_pers.item_ser='OTC'    " +
					" order by a.sales_pers, a. strg_code, a.question_code ";
			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			int count = 0;			
			while (rs.next())
			{
				rowData = new JSONObject();
				rowData.put("date_1", rs.getString("date_1"));
				rowData.put("insight_id", rs.getString("insight_id"));
				rowData.put("sp_name", rs.getString("sales_person_name"));		
				rowData.put("strg_code", rs.getString("strg_code"));		
				rowData.put("strg_name", rs.getString("strg_name"));		
				rowData.put("question", rs.getString("Questions"));		
				rowData.put("answer", rs.getString("answers"));
				rowData.put("territory", (rs.getString("territory")));
				rowData.put("dcr_id", (rs.getString("dcr_id")));
				rowData.put("question_code", (rs.getString("question_code")));
				rawDataRSRSurveyWiseJson.put(count, rowData);
				count++;
			}
		}
		catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
					rs.close();
					rs = null;
					if (pstmt != null)
					pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in :RSRSurveyEJB : " + d.getMessage());
				throw new ITMException(d);
			}
		}
		return rawDataRSRSurveyWiseJson;
		
	}
}
