package ibase.webitm.ejb.wms;

import ibase.system.config.AppConnectParm;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.ITMException;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.image.BufferedImage;
import java.io.File;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

import javax.imageio.ImageIO;
import javax.naming.InitialContext;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@javax.ejb.Stateless
public class WavegenWizEJB extends ValidatorEJB implements WavegenWizEJBLocal, WavegenWizEJBRemote
{
	public String globalXtraParams = "";
	@Override
	public String itemChanged(String xmlString, String xmlString1, String xmlString2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String retString = null;
		
		E12GenericUtility genericUtility = new E12GenericUtility();
		try
		{
			globalXtraParams = xtraParams;
			
			if (xmlString != null && xmlString.trim().length()!=0)
			{
				dom = genericUtility.parseString(xmlString); 
			}
			if (xmlString1 != null && xmlString1.trim().length()!=0)
			{
				dom1 = genericUtility.parseString(xmlString1); 
			}
			if (xmlString2 != null && xmlString2.trim().length()!=0)
			{
				dom2 = genericUtility.parseString(xmlString2); 
			}
			retString = itemChanged( dom, dom1, dom2, objContext, currentColumn, editFlag, xtraParams );
		}
		catch (Exception e)
		{
			System.out.println ( "Exception :WavegenWizEJB :itemChanged(String,String):" + e.getMessage() + ":" );
			retString = genericUtility.createErrorString(e);
		}
		System.out.println ( "Return String from WavegenWizEJB ["+retString+"]" );
		
		return retString;
	}
	@Override
	public String itemChanged(Document dom, Document dom1, Document dom2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		Document detail2dom = null;
		
		E12GenericUtility e12genericUtility = new E12GenericUtility();
		StringBuffer valueXmlString = new StringBuffer();
		int currentFormNo = 0;
		String siteCode = "", currDate = "", retString ="", dateFormat = "";
		InitialContext ctx = null;
		Connection conn = null;
		WaveGenerationPrcRemote waveGenerationPrcRemote = null;
		try
		{
			System.out.println("itemChanged called for WavegenWiz");
			
			conn = getConnection();
			
			siteCode = e12genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginSiteCode");
			dateFormat = e12genericUtility.getApplDateFormat();
			
			if( objContext != null && objContext.trim().length() > 0 )
			{
				currentFormNo = Integer.parseInt( objContext );
			}
			
			SimpleDateFormat sdf = new SimpleDateFormat(e12genericUtility.getApplDateFormat());
			currDate = sdf.format(new java.util.Date());
			
			System.out.println("currentColumn["+currentColumn+"] currentFormNo["+currentFormNo+"]" );
			
			valueXmlString = new StringBuffer( "<?xml version=\"1.0\"?><Root><Header><editFlag>" );
			valueXmlString.append( editFlag ).append( "</editFlag></Header>" );
			
			switch(currentFormNo)
			{
				case 1:
				{
					System.out.println(" -------- Inside itemchange case 1111111 ------------ ");
					
					if( currentColumn.trim().equalsIgnoreCase( "itm_default" ))
					{
						valueXmlString.append("<Detail1 domID='1'>");
						valueXmlString.append("<site_code><![CDATA[").append(siteCode).append( "]]></site_code>");
						valueXmlString.append("<sort_order><![CDATA[" ).append("Default").append( "]]></sort_order>");
						valueXmlString.append("<item_ser__from><![CDATA[").append("00").append( "]]></item_ser__from>");
						valueXmlString.append("<item_ser__to><![CDATA[").append("ZZ").append( "]]></item_ser__to>");
						valueXmlString.append("<product_style__from><![CDATA[").append("00").append( "]]></product_style__from>");
						valueXmlString.append("<product_style__to><![CDATA[").append("ZZ").append( "]]></product_style__to>");
						valueXmlString.append("<item_code__from><![CDATA[").append("00").append( "]]></item_code__from>");
						valueXmlString.append("<item_code__to><![CDATA[").append("ZZ").append( "]]></item_code__to>");
						valueXmlString.append("<cust_code__from><![CDATA[").append("00").append( "]]></cust_code__from>");
						valueXmlString.append("<cust_code__to><![CDATA[").append("ZZ").append( "]]></cust_code__to>");
						valueXmlString.append("<due_date__from><![CDATA[").append( currDate ).append( "]]></due_date__from>");
						valueXmlString.append("<due_date__to><![CDATA[").append( currDate ).append( "]]></due_date__to>");
						valueXmlString.append("<sale_order__from><![CDATA[").append("00").append( "]]></sale_order__from>");
						valueXmlString.append("<sale_order__to><![CDATA[").append("ZZ").append( "]]></sale_order__to>");
						valueXmlString.append("<cust_code__dlv__from><![CDATA[").append("00").append( "]]></cust_code__dlv__from>");
						valueXmlString.append("<cust_code__dlv__to><![CDATA[").append("ZZ").append( "]]></cust_code__dlv__to>");
						valueXmlString.append( "<credit_term__from><![CDATA[" ).append( "00" ).append( "]]></credit_term__from>");
						valueXmlString.append( "<credit_term__to><![CDATA[" ).append( "ZZ" ).append( "]]></credit_term__to>");
						valueXmlString.append("<carrier_code><![CDATA[]]></carrier_code>");
						valueXmlString.append("<carrier_name><![CDATA[]]></carrier_name>");
						valueXmlString.append("<default_qty_flag><![CDATA[Y]]></default_qty_flag>");
						valueXmlString.append("<wave_mode><![CDATA[").append("R").append( "]]></wave_mode>");
						valueXmlString.append("<order_type><![CDATA[]]></order_type>");
						valueXmlString.append("<loc_type_parent><![CDATA[]]></loc_type_parent>");
						valueXmlString.append("<tran_code><![CDATA[]]></tran_code>");
						valueXmlString.append("<tran_name><![CDATA[]]></tran_name>");
						valueXmlString.append("<remarks><![CDATA[]]></remarks>");
						valueXmlString.append("<active_pick_allow><![CDATA[").append("").append( "]]></active_pick_allow>");
						valueXmlString.append("<master_pack_allow><![CDATA[").append("").append( "]]></master_pack_allow>");
						valueXmlString.append("<parcelpack_allow><![CDATA[").append("").append( "]]></parcelpack_allow>");
						valueXmlString.append("<stock_to_dock_allow><![CDATA[").append("").append( "]]></stock_to_dock_allow>");
						valueXmlString.append("<single_lot><![CDATA[" ).append("").append("]]></single_lot>");
						valueXmlString.append("<ship_type><![CDATA[").append("A").append("]]></ship_type>");
						valueXmlString.append("<pallet_no><![CDATA[]]></pallet_no>");
						valueXmlString.append("<direct_pick_loc><![CDATA[]]></direct_pick_loc>");
						valueXmlString.append("<print_label><![CDATA[").append( "N" ).append( "]]></print_label>");
						valueXmlString.append("<printer_name><![CDATA[").append( "" ).append( "]]></printer_name>");
						valueXmlString.append("<date_format><![CDATA["+dateFormat+"]]></date_format>");
						valueXmlString.append("<app_context><![CDATA[false]]></app_context>");
						valueXmlString.append("</Detail1>" );
					}
					
					break;
				}
				case 2:
				{
					System.out.println(" -------- Inside itemchange case 222222 ------------ ");
					if( currentColumn.trim().equalsIgnoreCase( "itm_default" ))
					{
						String nodeName = "";
						String custCode = "", custName = "", saleOrder = "", custPO = "", pordDate = "", dlvCity = "", errCode ="";
						Map<String,HashMap<String,String>> detailDataMap = new LinkedHashMap<String,HashMap<String,String>>();
						HashMap<String,String> saleOrderDataMap = null;
						Set<String> detailDataMapKeySet = new LinkedHashSet<String>();
						int domID = 0, custDomID = 0, soDomID = 0;
						
						ITMDBAccessEJB itmDBAccessEJB = new ITMDBAccessEJB();
						
						valueXmlString.append("<Detail2 domID='0'>");
						valueXmlString.append("<site_code><![CDATA[").append(checkNull(e12genericUtility.getColumnValue("site_code", dom1))).append( "]]></site_code>");
						valueXmlString.append("<sort_order><![CDATA[").append(checkNull(e12genericUtility.getColumnValue("sort_order", dom1))).append( "]]></sort_order>");
						valueXmlString.append("<item_ser__from><![CDATA[").append(checkNull(e12genericUtility.getColumnValue("item_ser__from", dom1))).append( "]]></item_ser__from>");
						valueXmlString.append("<item_ser__to><![CDATA[").append(checkNull(e12genericUtility.getColumnValue("item_ser__to", dom1))).append( "]]></item_ser__to>");
						valueXmlString.append("<product_style__from><![CDATA[").append(checkNull(e12genericUtility.getColumnValue("product_style__from", dom1))).append( "]]></product_style__from>");
						valueXmlString.append("<product_style__to><![CDATA[").append(checkNull(e12genericUtility.getColumnValue("product_style__to", dom1))).append( "]]></product_style__to>");
						valueXmlString.append("<item_code__from><![CDATA[").append(checkNull(e12genericUtility.getColumnValue("item_code__from", dom1))).append( "]]></item_code__from>");
						valueXmlString.append("<item_code__to><![CDATA[").append(checkNull(e12genericUtility.getColumnValue("item_code__to", dom1))).append( "]]></item_code__to>");
						valueXmlString.append("<cust_code__from><![CDATA[").append(checkNull(e12genericUtility.getColumnValue("cust_code__from", dom1))).append( "]]></cust_code__from>");
						valueXmlString.append("<cust_code__to><![CDATA[").append(checkNull(e12genericUtility.getColumnValue("cust_code__to", dom1))).append( "]]></cust_code__to>");
						valueXmlString.append("<due_date__from><![CDATA[").append( checkNull(e12genericUtility.getColumnValue("due_date__from", dom1)) ).append( "]]></due_date__from>");
						valueXmlString.append("<due_date__to><![CDATA[").append( checkNull(e12genericUtility.getColumnValue("due_date__to", dom1)) ).append( "]]></due_date__to>");
						valueXmlString.append("<sale_order__from><![CDATA[").append(checkNull(e12genericUtility.getColumnValue("sale_order__from", dom1))).append( "]]></sale_order__from>");
						valueXmlString.append("<sale_order__to><![CDATA[").append(checkNull(e12genericUtility.getColumnValue("sale_order__to", dom1))).append( "]]></sale_order__to>");
						valueXmlString.append("<cust_code__dlv__from><![CDATA[").append(checkNull(e12genericUtility.getColumnValue("cust_code__dlv__from", dom1))).append( "]]></cust_code__dlv__from>");
						valueXmlString.append("<cust_code__dlv__to><![CDATA[").append(checkNull(e12genericUtility.getColumnValue("cust_code__dlv__to", dom1))).append( "]]></cust_code__dlv__to>");
						valueXmlString.append("<credit_term__from><![CDATA[").append(checkNull(e12genericUtility.getColumnValue("credit_term__from", dom1))).append( "]]></credit_term__from>");
						valueXmlString.append("<credit_term__to><![CDATA[").append(checkNull(e12genericUtility.getColumnValue("credit_term__to", dom1))).append( "]]></credit_term__to>");
						valueXmlString.append("<carrier_code><![CDATA["+checkNull(e12genericUtility.getColumnValue("carrier_code", dom1))+"]]></carrier_code>");
						valueXmlString.append("<carrier_name><![CDATA["+checkNull(e12genericUtility.getColumnValue("carrier_name", dom1))+"]]></carrier_name>");
						valueXmlString.append("<default_qty_flag><![CDATA["+checkNull(e12genericUtility.getColumnValue("default_qty_flag", dom1))+"]]></default_qty_flag>");
						valueXmlString.append("<wave_mode><![CDATA[").append(checkNull(e12genericUtility.getColumnValue("wave_mode", dom1))).append( "]]></wave_mode>");
						valueXmlString.append("<order_type><![CDATA["+checkNull(e12genericUtility.getColumnValue("order_type", dom1))+"]]></order_type>");
						valueXmlString.append("<loc_type_parent><![CDATA["+checkNull(e12genericUtility.getColumnValue("loc_type_parent", dom1))+"]]></loc_type_parent>");
						valueXmlString.append("<tran_code><![CDATA["+checkNull(e12genericUtility.getColumnValue("tran_code", dom1))+"]]></tran_code>");
						valueXmlString.append("<tran_name><![CDATA["+checkNull(e12genericUtility.getColumnValue("tran_name", dom1))+"]]></tran_name>");
						valueXmlString.append("<remarks><![CDATA["+checkNull(e12genericUtility.getColumnValue("remarks", dom1))+"]]></remarks>");
						valueXmlString.append("<active_pick_allow><![CDATA["+checkNull(e12genericUtility.getColumnValue("active_pick_allow", dom1))+"]]></active_pick_allow>");
						valueXmlString.append("<master_pack_allow><![CDATA["+checkNull(e12genericUtility.getColumnValue("master_pack_allow", dom1))+"]]></master_pack_allow>");
						valueXmlString.append("<parcelpack_allow><![CDATA["+checkNull(e12genericUtility.getColumnValue("parcelpack_allow", dom1))+"]]></parcelpack_allow>");
						valueXmlString.append("<stock_to_dock_allow><![CDATA["+checkNull(e12genericUtility.getColumnValue("stock_to_dock_allow", dom1))+"]]></stock_to_dock_allow>");
						valueXmlString.append("<single_lot><![CDATA["+checkNull(e12genericUtility.getColumnValue("single_lot", dom1))+"]]></single_lot>");
						valueXmlString.append("<ship_type><![CDATA["+checkNull(e12genericUtility.getColumnValue("ship_type", dom1))+"]]></ship_type>");
						valueXmlString.append("<pallet_no><![CDATA["+checkNull(e12genericUtility.getColumnValue("pallet_no", dom1))+"]]></pallet_no>");
						valueXmlString.append("<direct_pick_loc><![CDATA["+checkNull(e12genericUtility.getColumnValue("direct_pick_loc", dom1))+"]]></direct_pick_loc>");
						valueXmlString.append("<print_label><![CDATA["+checkNull(e12genericUtility.getColumnValue("print_label", dom1))+"]]></print_label>");
						valueXmlString.append("<printer_name><![CDATA["+checkNull(e12genericUtility.getColumnValue("printer_name", dom1))+"]]></printer_name>");
						valueXmlString.append("<date_format><![CDATA["+dateFormat+"]]></date_format>");
						valueXmlString.append("<app_context><![CDATA[true]]></app_context>");
						valueXmlString.append("</Detail2>");
						
						ctx=getInitialContext();
						waveGenerationPrcRemote = (ibase.webitm.ejb.wms.WaveGenerationPrcRemote) ctx.lookup("ibase/WaveGenerationPrc/remote");
						retString = waveGenerationPrcRemote.getData(dom1, dom1, "wavegen", xtraParams);
						
						System.out.println("getData return String["+retString+"]");
						
						
						if(retString != null && retString.trim().length()!=0)
						{
							if(retString.indexOf("<Errors>") != -1)
							{
								errCode = retString.substring(retString.indexOf("id=")+4, retString.indexOf("type=")-2);
								
								if (!errCode.equals(""))
								{
									retString = itmDBAccessEJB.getErrorString("", errCode, "", "", conn);
									System.out.println("itmDBAccessEJB retString: ["+retString+"]");
									return retString;
								}
							}
							else
							{
								detail2dom = new E12GenericUtility().parseString(retString);
							}
						}
						
						NodeList detail2NodeList = detail2dom.getElementsByTagName("Detail2");
						int detail2NodeListLen = detail2NodeList.getLength();
						
						for(int i=0; i<detail2NodeListLen; i++)
						{
							StringBuffer saleOrderDataStr = new StringBuffer();
							
							NodeList eachDetail2NodeList = detail2NodeList.item(i).getChildNodes();

							for(int j=0; j<eachDetail2NodeList.getLength();j++)
							{
								Node eachDetail2Element = eachDetail2NodeList.item(j);
								nodeName = eachDetail2Element.getNodeName();
								
								if("cust_code".equalsIgnoreCase(nodeName))
								{
									custCode = eachDetail2Element.getTextContent();
									System.out.println("customer code ["+custCode+"]");
								}
								else if("cust_name".equalsIgnoreCase(nodeName))
								{
									custName = eachDetail2Element.getTextContent();
									System.out.println("customer name ["+custName+"]");
								}
								else if("sale_order".equalsIgnoreCase(nodeName))
								{
									saleOrder = eachDetail2Element.getTextContent();
									System.out.println("saleOrder ["+saleOrder+"]");
								}
								else if("cust_pord".equalsIgnoreCase(nodeName))
								{
									custPO = eachDetail2Element.getTextContent();
									System.out.println("custPO ["+custPO+"]");
								}
								else if("pord_date".equalsIgnoreCase(nodeName))
								{
									pordDate = eachDetail2Element.getTextContent();
									System.out.println("pordDate ["+pordDate+"]");
								}
								else if("dlv_city".equalsIgnoreCase(nodeName))
								{
									dlvCity = eachDetail2Element.getTextContent().trim();
									System.out.println("dlvCity ["+dlvCity+"]");
								}
								
								if(!"#text".equalsIgnoreCase(nodeName) && !"attribute".equals(nodeName))
								{
									saleOrderDataStr.append("<"+nodeName+"><![CDATA["+eachDetail2Element.getTextContent()+"]]></"+nodeName+">");
								}
							}
							
							if(detailDataMap.containsKey(custCode))
							{
								HashMap<String,String> oldSaleOrderMap = detailDataMap.get(custCode);
								
								if(oldSaleOrderMap.containsKey(saleOrder))
								{
									int newLineItemCnt = Integer.parseInt(oldSaleOrderMap.get("lineItemCount"))+1;
									String oldSaleOrderStr = oldSaleOrderMap.get(saleOrder);
									oldSaleOrderStr +="~"+saleOrderDataStr.toString();
									oldSaleOrderMap.put(saleOrder, oldSaleOrderStr);
									oldSaleOrderMap.put("lineItemCount", String.valueOf(newLineItemCnt));
									detailDataMap.put(custCode, oldSaleOrderMap);
								}
								else
								{
									int newOrderCount = Integer.parseInt(oldSaleOrderMap.get("orderCount"))+1;
									int newLineItemCnt = Integer.parseInt(oldSaleOrderMap.get("lineItemCount"))+1;
									String newSaleOrderStr = oldSaleOrderMap.get("saleOrders")+"~"+saleOrder;
									oldSaleOrderMap.put("custName", custName);
									oldSaleOrderMap.put("dlvCity", dlvCity);
									oldSaleOrderMap.put("orderCount", String.valueOf(newOrderCount));
									oldSaleOrderMap.put("lineItemCount", String.valueOf(newLineItemCnt));
									oldSaleOrderMap.put(saleOrder+"custPO",custPO);
									oldSaleOrderMap.put(saleOrder+"pordDate",pordDate);
									oldSaleOrderMap.put("saleOrders",newSaleOrderStr);
									oldSaleOrderMap.put(saleOrder, saleOrderDataStr.toString());
									detailDataMap.put(custCode, oldSaleOrderMap);
								
								}
							}
							else
							{
								saleOrderDataMap = new HashMap<String,String>();
								saleOrderDataMap.put("custName", custName);
								saleOrderDataMap.put("dlvCity", dlvCity);
								saleOrderDataMap.put("orderCount", "1");
								saleOrderDataMap.put("lineItemCount", "1");
								saleOrderDataMap.put(saleOrder+"custPO",custPO);
								saleOrderDataMap.put(saleOrder+"pordDate",pordDate);
								saleOrderDataMap.put("saleOrders",saleOrder);
								saleOrderDataMap.put(saleOrder, saleOrderDataStr.toString());
								detailDataMap.put(custCode, saleOrderDataMap);
							}
						}
						
						detailDataMapKeySet = detailDataMap.keySet();
						
						for(String eachKey : detailDataMapKeySet)
						{
							HashMap<String, String> eachDetailDataMap = detailDataMap.get(eachKey);
							HashMap<String, HashMap<String, String>> allocationDataMap = getAllocationData(eachDetailDataMap, eachKey);
							HashMap<String,String> tempMap = allocationDataMap.get(eachKey);
							getCustomImagePath(eachKey.trim(),eachDetailDataMap.get("custName"),"customer");
							valueXmlString.append("<Detail2 domID='"+(++custDomID)+"'>");
							valueXmlString.append("<cust_code><![CDATA["+eachKey.trim()+"]]></cust_code>");
							valueXmlString.append("<cust_name><![CDATA["+eachDetailDataMap.get("custName")+"]]></cust_name>");
							valueXmlString.append("<dlv_city><![CDATA["+eachDetailDataMap.get("dlvCity")+"]]></dlv_city>");
							valueXmlString.append("<order_count><![CDATA["+eachDetailDataMap.get("orderCount")+"]]></order_count>");
							valueXmlString.append("<line_item_count><![CDATA["+eachDetailDataMap.get("lineItemCount")+"]]></line_item_count>");
							valueXmlString.append("<alloc_line_item><![CDATA["+tempMap.get("allocLineItem")+"]]></alloc_line_item>");
							valueXmlString.append("<total_alloc_perc><![CDATA["+tempMap.get("totalAllocPerc")+"]]></total_alloc_perc>");
							
							valueXmlString.append("<saleOrders>");
							
							
							String saleOrdersStr = eachDetailDataMap.get("saleOrders");
							String [] saleOrdersStrArry = saleOrdersStr.split("~");
							for(String eachSaleOrder : saleOrdersStrArry)
							{
								String customerPO = eachDetailDataMap.get(eachSaleOrder+"custPO");
								String customerPODate = eachDetailDataMap.get(eachSaleOrder+"pordDate");
								HashMap<String,String> tempMap1 = allocationDataMap.get(eachSaleOrder);
								valueXmlString.append("<saleOrder domID='"+(++soDomID)+"' >");
								valueXmlString.append("<sale_order><![CDATA["+eachSaleOrder+"]]></sale_order>");
								valueXmlString.append("<cust_pord><![CDATA["+customerPO+"]]></cust_pord>");
								valueXmlString.append("<pord_date><![CDATA["+customerPODate+"]]></pord_date>");
								valueXmlString.append("<no_line_item><![CDATA["+tempMap1.get("totalLineItme")+"]]></no_line_item>");
								valueXmlString.append("<so_alloc_line_item><![CDATA["+tempMap1.get("allocLineItem")+"]]></so_alloc_line_item>");
								valueXmlString.append("<alloc_perc><![CDATA["+tempMap1.get("totalAllocPerc")+"]]></alloc_perc>");
								String saleOrderStr = eachDetailDataMap.get(eachSaleOrder);
								String[] saleOrderStrArray = saleOrderStr.split("~");
								valueXmlString.append("<lineItems>");
								for(int i=0; i<saleOrderStrArray.length; i++)
								{
									valueXmlString.append("<lineItem domID='"+(++domID)+"'>");
									valueXmlString.append(saleOrderStrArray[i]);
									valueXmlString.append("<qty_highlighter><![CDATA["+getColorValue(saleOrderStrArray[i])+"]]></qty_highlighter>");
									valueXmlString.append("<image_path><![CDATA["+getImagePath(saleOrderStrArray[i])+"]]></image_path>");
									valueXmlString.append("</lineItem>");
								}
								valueXmlString.append("</lineItems>");
								valueXmlString.append("</saleOrder>");
							}
							valueXmlString.append("</saleOrders>");
							valueXmlString.append("</Detail2>");
						}
					}
					break;
				}
			}
			valueXmlString.append( "</Root>" );	
		}
		catch(Exception e)
		{
			System.out.println("WavegenWizEJB.itemChanged():catchBlock"+e.getMessage());
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if(!conn.isClosed() && conn != null)
				{
					conn.close();
					conn = null;
				}
			}
			catch(Exception e)
			{
				System.out.println("WavegenWizEJB.itemChanged():finally block");
				e.printStackTrace();
			}
		}
		
		return valueXmlString.toString();
	}
	@Override
	public String wfValData(String xmlString, String xmlString1, String xmlString2, String objContext,String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		String errString = "";
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		System.out.println("WavegenWizEJB.wfValData()");
		System.out.println("xmlString :"+xmlString);
		System.out.println("xmlString1 :"+xmlString1);
		System.out.println("xmlString2 :"+xmlString2);
		System.out.println("objContext :"+objContext);
		System.out.println("editFlag :"+editFlag);
		System.out.println("xtraParams :"+xtraParams);
		try
		{
			if (xmlString != null && xmlString.trim().length() > 0)
			{
				dom = parseString(xmlString);
			}
			if (xmlString1 != null && xmlString1.trim().length() > 0)
			{
				dom1 = parseString(xmlString1);
			}
			if (xmlString2 != null && xmlString2.trim().length() > 0)
			{
				dom2 = parseString(xmlString2);
			}
			System.out.println("Before calling function wfvalData****");
			errString = wfValData(dom, dom1, dom2, objContext, editFlag, xtraParams);

			System.out.println("After calling method wfVAlData Error String===="+errString);
		} 
		catch (Exception e)
		{
			System.out.println("Exception : [WavegenWizEJB][wfValData( String, String )] :==>\n" + e.getMessage());
			throw new ITMException(e);
		}
		return (errString);
	}
	
	@Override
	public String wfValData(Document currFormDataDom, Document hdrDataDom, Document allFormDataDom, String objContext, String editFlag, String xtraParams)throws RemoteException, ITMException 
	{
		String errString = "";
		int currentFormNo = 0;
		InitialContext ctx = null;
		WaveGenerationICRemote waveGenerationICRemote = null;
		try
		{
			ctx=getInitialContext();
			waveGenerationICRemote = (ibase.webitm.ejb.wms.WaveGenerationICRemote) ctx.lookup("ibase/WaveGenerationIC/remote");
			
			if (objContext != null && objContext.trim().length() > 0)
			{
				currentFormNo = Integer.parseInt(objContext);
				System.out.println("currentFormNo ["+currentFormNo+"]");
			}
			switch (currentFormNo)
			{
				case 1:
				{
					errString = waveGenerationICRemote.wfValData(currFormDataDom, hdrDataDom, allFormDataDom, objContext, xtraParams);
					
					System.out.println("errString["+errString+"]");
				
					break;
				}
				case 2:
				{
					errString = waveGenerationICRemote.wfValData(currFormDataDom, hdrDataDom, allFormDataDom, objContext, xtraParams);
					System.out.println("errString["+errString+"]");
				
					break;
				}
			}
			
		}
		catch(Exception e)
		{
			System.out.println("WavegenWizEJB.wfValData()");
			e.printStackTrace();
			
		}
		return errString;
	}
	
	@Override
	public String handleRequest(HashMap<String, String> reqParamMap) 
	{
		String action = "", retXMLStr = "";
		InitialContext ctx = null;
		WaveGenerationICRemote waveGenerationICRemote = null;
		
		try
		{
			
			action = (String)reqParamMap.get("action");
			
			if("ITEM_CHANGE".equalsIgnoreCase(action))
			{
				String currXmlDataStr = "", hdrXmlDataStr = "", allXmlDataStr = "", currentColumn = "", objContext = "", editFlag = "";
				
				ctx=getInitialContext();
				currXmlDataStr = (String)reqParamMap.get("CUR_XML_STR");
				hdrXmlDataStr = (String)reqParamMap.get("HDR_XML_STR");
				allXmlDataStr = (String)reqParamMap.get("ALL_XML_STR");
				currentColumn = (String)reqParamMap.get("CUR_COLUMN");
				objContext = (String)reqParamMap.get("OBJ_CONTEXT");
				editFlag = (String)reqParamMap.get("EDIT_FLAG");
				
				waveGenerationICRemote = (ibase.webitm.ejb.wms.WaveGenerationICRemote) ctx.lookup("ibase/WaveGenerationIC/remote");
				retXMLStr = waveGenerationICRemote.itemChanged(currXmlDataStr, hdrXmlDataStr, allXmlDataStr, objContext, currentColumn, editFlag, globalXtraParams);
				
				System.out.println("retXMLStr["+retXMLStr+"] for action ["+action+"]");
			}
			else if("GET_IMG_PATH".equalsIgnoreCase(action))
			{
				String lineItemStr = "";
				String itemCode = (String)reqParamMap.get("REF_ID");
				String itemDescr = (String)reqParamMap.get("ITEM_DESCR");
				
				lineItemStr += "<item_code><![CDATA["+itemCode+"]]></item_code>";
				lineItemStr	+= "<item_descr><![CDATA["+itemDescr+"]]></item_descr>";
				
				retXMLStr = "<imgPath><![CDATA["+getImagePath(lineItemStr)+"]]></imgPath>";
				
				System.out.println("retXMLStr["+retXMLStr+"] for action ["+action+"]");
			}
			
		}
		catch(Exception e)
		{
			System.out.println("WavegenWizEJB.handleRequest()"+e.getMessage());
			e.printStackTrace();
		}
		
		return retXMLStr;
	}
	
	private static HashMap<String, HashMap<String,String>> getAllocationData(HashMap<String, String> dataMap, String custCode)
	{
		HashMap<String, HashMap<String,String>> allocationData = new HashMap<String, HashMap<String,String>>();
		HashMap<String,String> eachAllocationMap = null;
		int totalAllocLineItem = 0, custAllocPerc = 0;
		double  custAllocQty = 0, custTotalQty = 0;
		
		try
		{
			String saleOrdersStr = dataMap.get("saleOrders");
			String [] saleOrdersStrArry = saleOrdersStr.split("~");
			for(String eachSaleOrder : saleOrdersStrArry)
			{
				int allocatedLineItem = 0, totalAllocPerc = 0;
				double  totalAllocQty = 0, totalQty = 0, allocQty = 0, manualAllocQty = 0;
				
				String saleOrderStr = dataMap.get(eachSaleOrder);
				String[] saleOrderStrArray = saleOrderStr.split("~");
				
				for(int i=0; i<saleOrderStrArray.length; i++)
				{
					String saleOrderLineStr = "<detail>"+saleOrderStrArray[i]+"</detail>";
					Document saleOrderLineDom = new E12GenericUtility().parseString(saleOrderLineStr);
					
					allocQty = Double.parseDouble(saleOrderLineDom.getElementsByTagName("qty_alloc").item(0).getTextContent());
					manualAllocQty = Double.parseDouble(saleOrderLineDom.getElementsByTagName("manual_allocqty").item(0).getTextContent());
					totalQty += Double.parseDouble(saleOrderLineDom.getElementsByTagName("pending_quantity").item(0).getTextContent());
					if(allocQty > 0 || manualAllocQty > 0)
					{
						allocatedLineItem += 1;
						
						if(allocQty > 0)
						{
							totalAllocQty += allocQty;
						}
						else if(manualAllocQty > 0)
						{
							totalAllocQty += manualAllocQty;
						}
					}
				}
				
				totalAllocPerc = (int) Math.round((totalAllocQty/totalQty)*100);
				
				eachAllocationMap = new HashMap<String, String>();
				eachAllocationMap.put("totalLineItme", String.valueOf(saleOrderStrArray.length));
				eachAllocationMap.put("allocLineItem", String.valueOf(allocatedLineItem));
				eachAllocationMap.put("totalAllocPerc", String.valueOf(totalAllocPerc));
				eachAllocationMap.put("totalQty", String.valueOf(totalQty));
				eachAllocationMap.put("totalAllocQty", String.valueOf(totalAllocQty));
				
				allocationData.put(eachSaleOrder, eachAllocationMap);
			}
			
			for(String eachSaleOrder : saleOrdersStrArry)
			{
				HashMap<String,String> tempMap = allocationData.get(eachSaleOrder);
				totalAllocLineItem += (int)Double.parseDouble(tempMap.get("allocLineItem"));
				custAllocQty += (int)Double.parseDouble(tempMap.get("totalAllocQty"));
				custTotalQty += (int)Double.parseDouble(tempMap.get("totalQty"));
				
			}
			custAllocPerc = (int) Math.round((custAllocQty/custTotalQty)*100);
			
			eachAllocationMap = new HashMap<String, String>();
			eachAllocationMap.put("allocLineItem", String.valueOf(totalAllocLineItem));
			eachAllocationMap.put("totalAllocPerc", String.valueOf(custAllocPerc));
			
			allocationData.put(custCode, eachAllocationMap);
			
		}
		catch(Exception e)
		{
			try 
			{
				System.out.println("WavegenWizEJB.getAllocationData()"+e.getMessage());
				throw new ITMException(e);
			}
			catch (ITMException e1) 
			{
				e1.printStackTrace();
			}
		}
		
		return allocationData;
	}
	
	private static String checkNull(String input)
	{
		if (input==null)
		{
			input="";
		}
		return input;
	}
	
	public InitialContext getInitialContext()throws ITMException
	{
		InitialContext ctx = null;
		try
		{
			AppConnectParm appConnect = new AppConnectParm();
			ctx = new InitialContext(appConnect.getProperty());
		}
		catch(ITMException itme)
		{
			System.out.println("WavegenWizEJB.getInitialContext()");
			throw itme;
		}
		catch(Exception e)
		{
			System.out.println("WavegenWizEJB.getInitialContext()"+e.getMessage());
			throw new ITMException(e);
		}
		return ctx;
	}
	
	public String getValue(String lineItemStr, String column) throws ITMException
	{
		String retValue = "";
		Document lineDom = null;
		
		try
		{
			lineDom =new E12GenericUtility().parseString("<detail>"+lineItemStr+"</detail>");
			retValue = lineDom.getElementsByTagName(column).item(0).getTextContent();
		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		
		return retValue;
	}
	
	public String getColorValue(String lineItemStr)throws ITMException
	{
		String colorCode = "", shipType = "";
		double pendQty = 0.0, orderQty = 0.0, allocQty = 0.0, balStockQty = 0.0;
		
		try
		{
			shipType = getValue(lineItemStr,"part_qty");
			pendQty = Double.parseDouble(getValue(lineItemStr,"pending_quantity"));
			orderQty = Double.parseDouble(getValue(lineItemStr, "quantity"));
			allocQty = Double.parseDouble(getValue(lineItemStr, "qty_alloc"));
			balStockQty = Double.parseDouble(getValue(lineItemStr, "bal_qty"));
			
			if("Ship Complete".equalsIgnoreCase(shipType) || "Ship Complete Lines".equalsIgnoreCase(shipType))
			{
				if(balStockQty > orderQty)
				{
					if(allocQty<pendQty)
					{
						colorCode="red";
					}
					else if(allocQty == pendQty)
					{
						colorCode="green";
					}
				}
				else if(balStockQty > 0)
				{
					if(allocQty<pendQty)
					{
						colorCode="red";
					}
					else if(allocQty == pendQty)
					{
						colorCode="green";
					}
				}
				else if(balStockQty <= 0)
				{
					if(allocQty<pendQty)
					{
						colorCode="red";
					}
					else if(allocQty == pendQty)
					{
						colorCode="green";
					}
				}
			}
			else if("Ship Available".equalsIgnoreCase(shipType))
			{
				if(balStockQty > orderQty)
				{
					if(allocQty<pendQty)
					{
						colorCode="yellow";
					}
					else if(allocQty == pendQty)
					{
						colorCode="green";
					}
				}
				else if(balStockQty > 0)
				{
					if(allocQty<pendQty)
					{
						colorCode="red";
					}
					else if(allocQty == pendQty)
					{
						colorCode="green";
					}
				}
				else if(balStockQty <= 0)
				{
					if(allocQty<pendQty)
					{
						colorCode="red";
					}
					else if(allocQty == pendQty)
					{
						colorCode="green";
					}
				}
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		
		return colorCode;
	}
	
	public String getImagePath(String lineItemStr) throws ITMException
	{
		String retImgPath = "", itemParnt = "", itemCode = "", itemRefSer = "", docId = "",itemDescr = "", docType = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String sql = "";
		Connection conn = null;
		
		try
		{
			conn = getConnection();
			itemCode = getValue(lineItemStr, "item_code").trim();
			itemDescr = removeSpecialChar(getValue(lineItemStr, "item_descr"));
			
			sql = " SELECT ITEM_PARNT FROM ITEM WHERE ITEM_CODE = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, itemCode);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				itemParnt = checkNullAndTrim(rs.getString("ITEM_PARNT"));
			}	
			if(rs != null)
			{
				rs.close();rs = null;
			}	
			if(pstmt != null)
			{	
				pstmt.close();pstmt = null;
			}
			
			sql = " SELECT REF_SER FROM TRANSETUP WHERE TRAN_WINDOW = 'w_item'";
			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				itemRefSer = checkNullAndTrim(rs.getString("REF_SER"));
			}	
			if(rs != null)
			{
				rs.close();rs = null;
			}	
			if(pstmt != null)
			{	
				pstmt.close();pstmt = null;
			}
			
			sql = " SELECT DOC_CONTENTS.DOC_ID,DOC_CONTENTS.DOC_TYPE FROM DOC_CONTENTS, DOC_TRANSACTION_LINK, USERS "
				+ " WHERE DOC_TRANSACTION_LINK.DOC_ID = DOC_CONTENTS.DOC_ID AND USERS.CODE = DOC_CONTENTS.ADD_USER "
				+ " AND REF_SER = ? AND (REF_ID = ? OR REF_ID = ?) ORDER BY DOC_CONTENTS.DOC_ID ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, itemRefSer);
			pstmt.setString(2, itemCode);
			pstmt.setString(3, itemParnt);

			rs = pstmt.executeQuery();
			
			if(rs.next())
			{
				docId = checkNullAndTrim(rs.getString("DOC_ID"));
				docType= checkNullAndTrim(rs.getString("DOC_TYPE"));
				retImgPath = "/ibase/WebITMDocumentHandlerServlet?OBJ_NAME=item&REF_ID="+itemCode.trim()+"&ACTION=GET_DOCUMENT&CLIENT=WEB1&DOC_ID="+docId+"&DOC_TYPE="+docType+"";
			}
			else
			{
				retImgPath = getCustomImagePath(itemCode.trim(),itemDescr,"itemcode");
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try 
			{
				if (rs != null) 
				{					
					rs.close();rs = null;
				}
				if (pstmt != null ) 
				{					
					pstmt.close();pstmt = null;
				}
				if (conn != null && !conn.isClosed()) 
				{					
					conn.close();conn = null;
				}
			} 
			catch (Exception e) 
			{
				throw new ITMException(e);
			}
		}
		
		return retImgPath;
	}
	
	public String getCustomImagePath(String value,String altColImg, String object)
	{
		String imagePath = "";
		try
		{
			File objDir = new File (CommonConstants.RIALITE_PROFILE_PATH +File.separator+ object);
			if(!objDir.exists())
			{
				objDir.mkdir();
			}
			if( fileExist(value, object))
			{
				imagePath = File.separator+"ibase"+File.separator+"resource"+File.separator+ object+File.separator + value + ".png";
			}
			else
			{
				File f = new File(CommonConstants.RIALITE_PROFILE_PATH +File.separator+ object+File.separator + value + ".png");
				BufferedImage bi = createLabelImage(altColImg);
				ImageIO.write(bi,"PNG",f);
				imagePath = File.separator+"ibase"+File.separator+"resource"+File.separator+ object+File.separator + value + ".png";
			}
			
		}
		catch(Exception e)
		{
			System.out.println("PopUpDataAccessEJB.getCustomeImagePath()::getCustomImagePath");
			e.printStackTrace();
		}
		return imagePath;		
	}
	
	public boolean fileExist(String value, String object)
	{
		boolean flag = true;
		try
		{
			String path = CommonConstants.RIALITE_PROFILE_PATH +File.separator+ object+File.separator + value + ".png";
			File f = new File(path);
			if( !f.exists() )
			{
				flag = false;
			}
			else
			{
				flag = true;
			}
		}
		catch (Exception e) 
		{
			System.out.println("PopUpDataAccessEJB.fileExist()"+e.getMessage());
		}
		return flag;
	}
	
	public BufferedImage createLabelImage(String value)
	{
		int width = 400, height = 400;
		BufferedImage bi = new BufferedImage(width, height, BufferedImage.TYPE_INT_ARGB);
		try 
		{
			GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
			File fontFile = new File(CommonConstants.APPLICATION_CONTEXT+"webitm"+File.separator+"css"+File.separator+"fonts"+File.separator+"Museo300-Regular.ttf");
			ge.registerFont(Font.createFont(Font.TRUETYPE_FONT, fontFile));
			Graphics2D g = bi.createGraphics();
			String text = checkNull(dynamicMenuImage(value));
			int centerX = 200, centerY = 200;
			int ovalWidth = 400, ovalHeight = 400;
			Font font = new Font("Museo 300", Font.PLAIN, 200);
			g.setFont(font);
			Color c = Color.decode("#cfbebe");
			g.setColor(c);
			g.fillOval(centerX-ovalWidth/2, centerY-ovalHeight/2,ovalWidth, ovalHeight);
			FontMetrics fm = g.getFontMetrics();
			double textWidth = fm.getStringBounds(text,g).getWidth();
			g.setColor(Color.WHITE);
			g.drawString(text, (int) (centerX - textWidth/2), (int) ( (centerY + fm.getMaxAscent() / 2) ) - 2);
		}
		catch (Exception e) 
		{
			System.out.println("PopUpDataAccessEJB.createLabelImage()"+e.getMessage());
		}
		return bi;
	}
	
	private String dynamicMenuImage(String objDescr)
	{
		StringBuffer mnIconBuffer = new StringBuffer();
		String[] refSr = null;
		
		objDescr = objDescr.toUpperCase();
		objDescr = checkNull(objDescr);
		objDescr = objDescr.trim();
		if( objDescr != "" )
		{
			if( objDescr.indexOf(" ") != -1 )
			{
				refSr = objDescr.split(" ");
			}
			else if( objDescr.indexOf("-") != -1 )
			{
				refSr = objDescr.split("-");
			}
			else if( objDescr.indexOf("_") != -1 )
			{
				refSr = objDescr.split("_");
			}
			else if( objDescr.indexOf(":") != -1 )
			{
				refSr = objDescr.split(":");
			}
			String menuStr = "";
			
			if( refSr != null )
			{
				for( int i = 0; i <= refSr.length; i++ )
				{
					if( mnIconBuffer.length() < 2 && checkNull( refSr[i] ) != "" )
					{
						menuStr = refSr[i];
						menuStr = menuStr.trim();
						if( menuStr != ":" && !"".equalsIgnoreCase(menuStr) )
						{
							mnIconBuffer.append( menuStr.charAt(0) );
						}
					}
				}
			}
			else
			{
				mnIconBuffer.append( objDescr.charAt(0) );
			}
		}
		
		String menuIconPath = mnIconBuffer.toString();
		
		return menuIconPath;
	}
	public String removeSpecialChar(String inputStr)
	{
		String retStr = "";
		
		if(inputStr.indexOf("&")!= -1)
		{
			retStr = inputStr.replaceAll("&", "AND");
		}
		else
		{
			retStr = inputStr.replaceAll("[-()%^!@#$%*{}]", " ");
		}
		
		return retStr;
	}
	
	private static String checkNullAndTrim(String input)
	{
		if (input==null)
		{
			input="";
		}
		return input.trim();
	}
}
