package ibase.dashboard.sfa.ejb;

import ibase.system.config.ConnDriver;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.text.SimpleDateFormat;


import javax.ejb.Stateless;
import org.json.simple.JSONObject;

@Stateless
public class AttendanceCompliance extends ValidatorEJB implements AttendanceComplianceLocal,
		AttendanceComplianceRemote
{
	public AttendanceCompliance()
	{
	}

	@SuppressWarnings("unchecked")
	public JSONObject getAttendance(String dataSourceName, String empCode)
			throws RemoteException, ITMException
	{
		JSONObject rowDataPendingTaskJson = new JSONObject();
		JSONObject rowData = null;
		String sql = "";
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		Connection conn = null;
		ConnDriver connDriver = new ConnDriver();
		int count = 0;
		try
		{
			SimpleDateFormat convertToDbDate =new SimpleDateFormat(new GenericUtility().getDBDateFormat());
			SimpleDateFormat simpleDateFormat =new SimpleDateFormat(new GenericUtility().getApplDateFormat());
			//simpleDateFormat.format(convertToDbDate.parse(""));
			conn = connDriver.getConnectDB(dataSourceName);
			connDriver = null;
	/*sql_main =   " SELECT  SALES_PERS, SP_NAME, to_char(LAST_REPORT,'dd/mm/yyyy') AS LAST_REPORT, ROUND(TRUNC(SYSDATE)-TRUNC(LAST_REPORT)) NOT_REPORTED,"
			+ " EMP_NAME, MOBILE_NO FROM (SELECT  SP.SALES_PERS, SP.SP_NAME,MAX(S.EVENT_DATE) LAST_REPORT,"
			+ " (NVL(TRIM(E1.EMP_FNAME),'')||NVL(TRIM(E1.EMP_MNAME),' ')||NVL(TRIM(E1.EMP_LNAME),'')) EMP_NAME, "
			+ " E.MOBILE_NO FROM SPRS_ACT_TRAN S INNER JOIN EMPLOYEE E ON S.SALES_PERS = E.EMP_CODE "
			+ " INNER JOIN SALES_PERS SP ON E.EMP_CODE = SP.SALES_PERS LEFT "
			+ " OUTER JOIN EMPLOYEE E1 ON E1.EMP_CODE = E.REPORT_TO "
			+ " WHERE E.REPORT_TO = '" + empCode + "'"
			+ " GROUP BY SP.SALES_PERS, SP.SP_NAME, (NVL(TRIM(E1.EMP_FNAME),'')||NVL(TRIM(E1.EMP_MNAME),' ')||NVL(TRIM(E1.EMP_LNAME),'')), E.MOBILE_NO) A order by to_date(LAST_REPORT)";
    */
	
	/*sql = "SELECT SALES_PERS, sp_name, LAST_REPORT  AS LAST_REPORT, ROUND(TRUNC(SYSDATE)-TRUNC(LAST_REPORT)) NOT_REPORTED, " +
			"EMP_NAME, mobile_no  FROM (SELECT SP.SALES_PERS, SP.SP_NAME, MAX(S.EVENT_DATE) LAST_REPORT, (NVL(TRIM(E1.EMP_FNAME),'') ||NVL(TRIM(E1.EMP_MNAME),' ') ||NVL(TRIM(E1.EMP_LNAME),'')) EMP_NAME, " +
			"E.MOBILE_NO, to_char(MAX(S.EVENT_DATE),'dd/mm/yy') LAST_REPORT1 FROM SPRS_ACT_TRAN S INNER JOIN EMPLOYEE E ON S.SALES_PERS = E.EMP_CODE INNER JOIN SALES_PERS SP ON E.EMP_CODE = SP.SALES_PERS LEFT OUTER JOIN EMPLOYEE E1 ON E1.EMP_CODE    = E.REPORT_TO " +
			//"WHERE E.REPORT_TO = 'G009' " +
			"GROUP BY SP.SALES_PERS, SP.SP_NAME, (NVL(TRIM(E1.EMP_FNAME),'') ||NVL(TRIM(E1.EMP_MNAME),' ') ||NVL(TRIM(E1.EMP_LNAME),'')), E.MOBILE_NO ) a order by last_report desc ";
	
	sql_local =   "SELECT SALES_PERS, sp_name, TRUNC(LAST_REPORT )AS LAST_REPORT, " +
			"ROUND(TRUNC(SYSDATE)-TRUNC(LAST_REPORT)) NOT_REPORTED, EMP_NAME, mobile_no FROM (SELECT SP.SALES_PERS, SP.SP_NAME, MAX(S.EVENT_DATE) LAST_REPORT, (NVL(TRIM(E1.EMP_FNAME),'') ||NVL(TRIM(E1.EMP_MNAME),' ') ||NVL(TRIM(E1.EMP_LNAME),'')) EMP_NAME, " +
			"E.MOBILE_NO, TO_CHAR(MAX(S.EVENT_DATE),'dd/mm/yy') LAST_REPORT1 FROM SPRS_ACT_TRAN S INNER JOIN EMPLOYEE E ON S.SALES_PERS = E.EMP_CODE INNER JOIN SALES_PERS SP ON E.EMP_CODE = SP.SALES_PERS LEFT OUTER JOIN EMPLOYEE E1 ON E1.EMP_CODE    = E.REPORT_TO " +
			"WHERE E.REPORT_TO = 'G009' " +
			"GROUP BY SP.SALES_PERS, SP.SP_NAME, (NVL(TRIM(E1.EMP_FNAME),'') ||NVL(TRIM(E1.EMP_MNAME),' ') ||NVL(TRIM(E1.EMP_LNAME),'')), E.MOBILE_NO ) a order by trunc(last_report) desc ";
	*/
	
	
	/*sql_160316 =   " select A.SALES_PERS, SP.SP_NAME, A.LAST_REPORT, " +
			" ROUND(TRUNC(sysdate)-TRUNC(A.LAST_REPORT)) NOT_REPORTED, I.DESCR ITEM_SERIES," +
			" E.HOBBY1 REGION, E.CUR_STATE STATE, (NVL(TRIM(E1.EMP_FNAME),'')||NVL(TRIM(E1.EMP_MNAME),' ')||NVL(TRIM(E1.EMP_LNAME),'')) EMP_NAME, E.MOBILE_NO " +
			" FROM (SELECT t.SALES_PERS,Max(T.EVENT_DATE) LAST_REPORT FROM SPRS_ACT_TRAN T " +
			" WhERE T.SALEs_PERS IN (SELECT S.SALES_pERS FROM SALES_PErS S  INNER JOIN  EMPLOYEE E ON S.SALES_PERS = E.EMP_CODE " +
			" WHERE S.ACTIVE_YN='Y' " +
			" start with e.emp_code = '" + empCode + "' " +
			" connect by prior E.EMP_CODE = E.REPORT_TO) " +
			" GRoup by t.SALES_PERS)A INNER JOIN SALES_PERS SP ON A.SALES_PERS = SP.SALES_PERS INNER  JOIN EMPLOYEE E ON SP.SALES_PERS = E.EMP_CODE INNER JOIN ITEMSER I ON I.ITEM_SER=SP.ITEM_SER LEFT OUTER JOIN EMPLOYEE E1 ON E1.EMP_CODE = E.REPORT_TO ";
	*/
			
	/*Sql Changes on 150316*/
	/*sql =   " select A.SALES_PERS, SP.SP_NAME, A.LAST_REPORT, ROUND(TRUNC(sysdate)-TRUNC(A.LAST_REPORT)) " +
			" NOT_REPORTED_DAYS," +
			" I.DESCR DIVISION , E.HOBBY1 REGION, S.DESCR STATE, (NVL(TRIM(E1.EMP_FNAME),'')||NVL(TRIM(E1.EMP_MNAME),' ')||NVL(TRIM(E1.EMP_LNAME),'')) EMP_NAME," +
			" E.MOBILE_NO FROM (SELECT t.SALES_PERS,Max(T.EVENT_DATE) LAST_REPORT " +
			" FROM SPRS_ACT_TRAN T WhERE T.SALEs_PERS IN (SELECT S.SALES_pERS " +
			" FROM SALES_PErS S  INNER JOIN  EMPLOYEE E ON S.SALES_PERS = E.EMP_CODE " +
			" WHERE S.ACTIVE_YN='Y' " +
			" start with e.emp_code = '" + empCode + "' " +
			" connect by prior E.EMP_CODE = E.REPORT_TO) " +
			" GRoup by t.SALES_PERS)A INNER JOIN SALES_PERS SP ON A.SALES_PERS = SP.SALES_PERS INNER  JOIN EMPLOYEE E ON SP.SALES_PERS = E.EMP_CODE INNER JOIN ITEMSER I ON I.ITEM_SER=SP.ITEM_SER LEFT OUTER JOIN EMPLOYEE E1 ON E1.EMP_CODE = E.REPORT_TO LEFT OUTER JOIN STATE S ON S.STATE_CODE = E.CUR_STATE  ";
	*/
	
	/*Final SQL On dated 160316		
	
	sql =   " select A.SALES_PERS, SP.SP_NAME, A.LAST_REPORT, ROUND(TRUNC(sysdate)-TRUNC(A.LAST_REPORT)) NOT_REPORTED_DAYS, " +
			" I.DESCR DIVISION , E.HOBBY1 REGION, S.DESCR STATE, (NVL(TRIM(E1.EMP_FNAME),'')||NVL(TRIM(E1.EMP_MNAME),' ')||NVL(TRIM(E1.EMP_LNAME),'')) EMP_NAME, E.MOBILE_NO " +
			" FROM ( SELECT t.SALES_PERS,Max(T.EVENT_DATE) LAST_REPORT " +
			" FROM SPRS_ACT_TRAN T " +
			" WhERE T.SALEs_PERS IN ( SELECT S.SALES_pERS FROM SALES_PErS S  " +
			" INNER JOIN  EMPLOYEE E ON S.SALES_PERS = E.EMP_CODE " +
			//" WHERE S.ACTIVE_YN='Y' " +
			//" start with e.emp_code = '" + empCode + "' " +
			//" connect by prior E.EMP_CODE = E.REPORT_TO  " +
			" )AND T.CONFIRMED='Y' " +
			" GRoup by t.SALES_PERS )A INNER JOIN SALES_PERS SP ON A.SALES_PERS = SP.SALES_PERS INNER  JOIN EMPLOYEE E ON SP.SALES_PERS = E.EMP_CODE " +
			" INNER JOIN ITEMSER I ON I.ITEM_SER=SP.ITEM_SER LEFT OUTER JOIN EMPLOYEE E1 ON E1.EMP_CODE = E.REPORT_TO LEFT OUTER JOIN STATE S ON S.STATE_CODE = E.CUR_STATE ";
	*/
	
	/*Final SQL After E.STATUS ='Y' changes in SQL  On dated 050516*/
	
	sql =   " SELECT A.SALES_PERS, SP.SP_NAME, A.LAST_REPORT, ROUND(TRUNC(sysdate)-TRUNC(A.LAST_REPORT)) NOT_REPORTED_DAYS," +
			" I.DESCR DIVISION , E.HOBBY1 REGION, S.DESCR STATE, (NVL(TRIM(E1.EMP_FNAME),'') ||NVL(TRIM(E1.EMP_MNAME),' ') ||NVL(TRIM(E1.EMP_LNAME),'')) EMP_NAME, " +
			" E.MOBILE_NO FROM (SELECT t.SALES_PERS, MAX(T.EVENT_DATE) LAST_REPORT " +
			" FROM SPRS_ACT_TRAN T " +
			" WHERE T.SALEs_PERS IN (SELECT S.SALES_pERS FROM SALES_PErS S " +
			" INNER JOIN EMPLOYEE E ON S.SALES_PERS = E.EMP_CODE " +
			" WHERE E.STATUS ='Y' " +
			" START WITH e.emp_code = '" + empCode + "' " +
			" CONNECT BY prior E.EMP_CODE = E.REPORT_TO " +
			" ) AND T.CONFIRMED='Y' " +
			" GROUP BY t.SALES_PERS )A INNER JOIN SALES_PERS SP ON A.SALES_PERS = SP.SALES_PERS " +
			" INNER JOIN EMPLOYEE E ON SP.SALES_PERS = E.EMP_CODE " +
			" INNER JOIN ITEMSER I ON I.ITEM_SER=SP.ITEM_SER LEFT " +
			" OUTER JOIN EMPLOYEE E1 ON E1.EMP_CODE = E.REPORT_TO " +
			" LEFT OUTER JOIN STATE S ON S.STATE_CODE = E.CUR_STATE ";

	
	System.out.println("sql is =" + sql);
	pstmt = conn.prepareStatement(sql);
	rs = pstmt.executeQuery();

	while (rs.next())
	{

		rowData = new JSONObject();
		rowData.put("salespersn",   checkNull(rs.getString("SALES_PERS")));
		rowData.put("spname",       checkNull(rs.getString("SP_NAME")));
		String dueDate             =checkNull(rs.getString("LAST_REPORT"));
		if(dueDate.trim().length()>0)
        {
            rowData.put("lastreport", simpleDateFormat.format(convertToDbDate.parse(dueDate)));
        }
        else
        {
            rowData.put("lastreport",checkNull (rs.getString("LAST_REPORT")));
        }
		
		rowData.put("notreporteddays",  checkNull(rs.getString("NOT_REPORTED_DAYS")));
		rowData.put("division",         checkNull(rs.getString("DIVISION")));
		rowData.put("region",           checkNull(rs.getString("REGION")));
		rowData.put("state",            checkNull(rs.getString("STATE")));
		rowData.put("empname",          checkNull(rs.getString("EMP_NAME")));
		rowData.put("mobileno",         checkNull(rs.getString("MOBILE_NO")));
		rowDataPendingTaskJson.put(Integer.valueOf(count), rowData);
		count++;
			}
			System.out.println(" rowDataPendingTaskJson is =" + rowDataPendingTaskJson);

		}
		catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
						rs.close();
					rs = null;
					if (pstmt != null)
						pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			}
			catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in :getTask():" + d.getMessage());
				throw new ITMException(d);
			}
		}

		return rowDataPendingTaskJson;
	}

	private String checkNull(String str)
	{
		if (str == null)
		{
			return "";
		} else
		{
			return str;
		}
	}

}
