
<%System.out.println("***In Catalog.jsp****"); %>
<%@page import="java.io.*"%>
<%@page import="java.util.*"%>
<%@page import="javax.naming.*"%>
<%@page import="org.json.*"%>

<%@page import="ibase.system.config.*"%>
<%@page import="ibase.webitm.webService.ejb.*"%>
<%@page import="ibase.webitm.utility.*"%>
<%@page import="ibase.utility.*"%>

<%!

    private InitialContext getInitialContext() throws ITMException
	{
		InitialContext ctx = null;
		try
		{
			AppConnectParm appConnect = new AppConnectParm();
			ctx = new InitialContext( appConnect.getProperty() );
		}
		catch( ITMException itme )
		{
			System.out.println( "ITMException : getInitialContext : "+ itme.getMessage() );
			throw itme;
		}
		catch(Exception e)
		{
			System.out.println( "Exception : getInitialContext : "+ e.getMessage() );
			throw new ITMException(e);
		}
		return ctx;
	}

    public JSONObject getUserDetails(UserInfoBean userInfo) throws ITMException, NamingException  
	{
        JSONObject resultDtlJson = new JSONObject();
		try 
		{
			System.out.println("in get user dtl");
			ExtServiceRemote extServices = (ExtServiceRemote) getInitialContext().lookup("ibase/ExtServiceEJB/remote");
			
			System.out.println("User InfoBean in getUserDetails = "+userInfo);
			userInfo = extServices.updateUseInfo(userInfo);
		
			HashMap<String, String> resultMap = extServices.getLoginUserDetails( userInfo);

			if( resultMap != null && resultMap.size() > 0 )
			{
				for ( Map.Entry<String, String> entry : resultMap.entrySet() )
				{
					resultDtlJson.put( entry.getKey(), entry.getValue() );
				}
			}
		}
		catch (Exception e) 
		{
			System.out.println("Exception in getUserDetails "+e.getMessage());
			e.printStackTrace();
		}
		System.out.println( "resultDtlJson-["+ resultDtlJson +"]" );
		return resultDtlJson;
	}

%>
<%
String userDetailStr = "{}";
String siteCode = "L2D01";
String catalog = "local2do";
String loginCode = "";
//ibase.utility.UserInfoBean userInfo = ( ibase.utility.UserInfoBean )session.getAttribute("USER_INFO");
UserInfoBean userInfo = new UserInfoBean( session.getAttribute("USER_INFO").toString() );
if( userInfo == null )
{
	System.out.println("[Forwarding to DirectAccess.jsp] ..........");
	String directAccessPathStr = ".." + File.separator + ".." + File.separator + "jsp" + File.separator + "DirectAccess.jsp";
}
else
{
    loginCode = userInfo.getLoginCode();
    JSONObject resultDtlJson = getUserDetails(userInfo);
    System.out.println("**************************resultDtlJson["+resultDtlJson+"]");
    if(resultDtlJson != null)
    {
       userDetailStr = resultDtlJson.toString();    
    }
    System.out.println("**************************Catalog["+userInfo.toString()+"]");
    siteCode = userInfo.getSiteCode();
    System.out.println("**************************Catalog site code["+siteCode+"]");
    catalog = request.getParameter("catalog");
    System.out.println("**************************Catalog catalog["+catalog+"]");
}
%>


<html>
<head>
<style>
.content{
	display: flex;
    flex-direction: column;
    display: grid;
    position: relative;
    padding: 20px;
    margin: 20px;
    background: #7bc6ff;
}

#catalog-link{
    width: 150px;
    height: 40px;
    line-height: 40px;
    color: white;
    padding: 0;
    padding-left: 15px;
    font-size: 18px;
    text-decoration: none;
}

#hint-message{
    display: block;
    height: 35px;
    line-height: 35px;
    color: red;
    padding: 0;
    padding-left: 25px;
}

</style>
<script type="text/javascript"> 
    var enterprise = 'local2do';
    var siteCode = '<%=siteCode%>';
    var SYS_REST_ENTRY = '/ibase/ecm/service/sys';
	function loadEnterprise()
	{ 
		console.log('window loading');
	      var userDetailJsonStr = '<%=userDetailStr%>';
	      var userDetailJson = JSON.parse( userDetailJsonStr );
	      userDetailJson.jti = '<%=loginCode%>';
	      userDetailJson.profileImageLink = "/ibase/resource/images/users/" + '<%=loginCode%>' + ".png?temp=" + Math.random();;
	      localStorage.setItem('userInfo', JSON.stringify( userDetailJson ) );

		var w = window.open('/ibase/ecm/' + enterprise + '/index.html?siteCode=<%=siteCode%>', '_blank');
        if( w ) 
        {
            var hintMessage = document.getElementById('hint-message');
            hintMessage.style.display = 'none';
        }
        var openCatalog = document.getElementById('catalog-link');
        openCatalog.setAttribute('href','/ibase/ecm/' + enterprise + '/index.html?siteCode=<%=siteCode%>');
	}

    function postSite(path, callback)
	{
		var url = SYS_REST_ENTRY + path ;
		var xhttp = new XMLHttpRequest();
		xhttp.onreadystatechange = function() {
			if (this.readyState == 4 && (this.status == 200 || this.status == 204)) 
			{
				console.log('onreadystatechange', this, callback);
				enterprise = JSON.parse(this.response).enterPrise.trim();
				console.log("the enterprise",enterprise,JSON.parse(this.response));
				if (callback)
				{
					callback.call(this.enterprise);
				}
			}
		};
		xhttp.open("GET", url, true);
		xhttp.setRequestHeader("Accept", "application/json");
		xhttp.setRequestHeader('Content-Type', 'application/json')
		xhttp.send();
	}


</script>
</head>
<body onload="postSite('/site/' + siteCode, loadEnterprise);">
<div class='content'>
<a id="catalog-link" href="" target="_blank"> Open <%=catalog%> catalog </a>
<span id="hint-message" > It seems popup blocker is enabled. To access Catalog site click on above link.</span>
</div>
<body>
</body>

</html>
