import { Component, Input, ViewChild, ViewEncapsulation } from '@angular/core';
export class BBImageComponent {
    constructor() {
        this.isThumbnail = false;
        this.isSmallIcon = false;
    }
    ngOnInit() {
        if (this.attachType) {
            //this.initImage(this.object,this.refSer, this.refId, this.attachType);
        }
        else {
            ////this.initAttachImage(this.object,this.refSer, this.refId, 'V', this.isSingleImage, this.height, this.width);
            //this.initSingleImage(this.object,this.refSer, this.refId);
            this.attachType = "";
        }
        this.initSingleImage(this.object, this.refSer, this.refId);
    }
    //192.168.0.222:9090/ibase/rest/E12ExtService/getAttachDocument?
    //OBJ_NAME=objName&
    //REF_SER=refSer&
    //REF_ID=refId&
    //DOC_TYPE=attachType&
    //TOKEN_ID=localStorage.getItem('TOKEN_ID')&
    //DATA_FORMAT=JSON
    initImage(objName, refSer, refId, attachType) {
        this.imageUrl = "?OBJ_NAME=" + objName + "&REF_SER=" + refSer + "&REF_ID=" + refId +
            "&DOC_TYPE=" + attachType + "&TOKEN_ID=" + localStorage.getItem('TOKEN_ID') + "&DATA_FORMAT=JSON" +
            "&TEST=ON";
        console.log("initImage calling /ibase/rest/E12ExtService/getAttachDocument ");
        console.log("created imageUrl " + this.imageUrl);
    }
    /*
      initAttachImage(objName:string, refSer:string, refId:string, uiMode:string, isSingleImage:any, height:string, width:string)
      {
          console.log("loadImage check window.getAttachmentsPlugin ");
          if (! getAttachmentsPlugin ){
              console.log("window.getAttachmentsPlugin is null" );
              return;
          }
          // Get the target element in which you want to add AttachmentsPlugin.
          console.log("loadImage after check window.getAttachmentsPlugin ");
          this.attchPluginViewUI = getAttachmentsPlugin({
              OBJ_NAME : objName,
              REF_SER : refSer,
              REF_ID : refId,//ITEM_CODE
              // host url can be empty in browser
              // for mobile devices it has be specified correctly
              HOST_URL : "",
              DOC_TYPE : "",
              // A - For gettig add ui (user can add new attachments and view attached files)
              // E - For getting edit ui (user can view attachments, add new attachments as well as delete attachments)
              // V - For getting view ui (user can only view attachments)
              UI : uiMode,
              // The thumbnail height and width
              THUMBNAIL_WIDTH : width ? width : '100%',
              THUMBNAIL_HEIGHT : height ? height : '100%',
              // Maximum width of attachment plugin, can be specified in pixels
              MAX_WIDTH : "100%",
              // true for browser, false for mobile.
              IS_HOSTED_MODE : true || false,
              ENABLE_SINGLE_IMAGE : isSingleImage
          });
          
          //console.log("created attchPluginViewUI " + this.attchPluginViewUI);
          //this.nodeToString( this.attchPluginViewUI );
               
          if (this.targetDiv && this.attchPluginViewUI)
          {
              this.targetDiv.nativeElement.innerHTML = "";
          }
      }
    */
    initSingleImage(objName, refSer, refId) {
        console.log("initSingleImage check window.getImagePlugin chitraaaaaa [", objName + "] [", refSer + "] [", refId);
        console.log(" getImagePlugin -------->>");
        if (!getImagePlugin) {
            console.log("window.getImagePlugin is null");
            return;
        }
        // Get the target element in which you want to add AttachmentsPlugin.
        console.log("loadImage after check window.getImagePlugin ");
        getImagePlugin({
            OBJ_NAME: objName,
            REF_SER: refSer,
            REF_ID: refId,
            HOST_URL: "",
            DOC_TYPE: this.attachType,
            IS_HOSTED_MODE: true || false,
            ENABLE_SINGLE_IMAGE: true
        }, this, 'imageCallback');
    }
    imageCallback(imgData) {
        console.log("imageCallback imgData>>", imgData);
        if (imgData && imgData[0]) {
            this.targetDiv.nativeElement.appendChild(imgData[0]);
            this.loadingDiv.nativeElement.style.display = 'none';
        }
    }
    ngAfterViewChecked() {
        //console.log("EcmImageComponent ngAfterViewChecked... ");
        if (this.targetDiv && this.attchPluginViewUI && this.attchPluginViewUI.innerHTML !== "" && this.targetDiv.nativeElement.innerHTML === "") {
            console.log("EcmImageComponent ngAfterViewChecked... ");
            this.targetDiv.nativeElement.appendChild(this.attchPluginViewUI);
            this.loadingDiv.nativeElement.style.display = 'none';
        }
        if (this.targetImg && this.imageUrl) {
            console.log("this.targetImg ngAfterViewChecked... " + this.targetImg.nativeElement);
            this.targetImg.nativeElement.src = "/ibase/rest/E12ExtService/getAttachDocument" + this.imageUrl;
            //this.targetImg.nativeElement.onerror ="this.src = '/ecm/assets/images/svg/img_not_found.svg'; this.onerror = null;";
            this.targetImg.nativeElement.onerror = this.onEcmImageError;
            this.imageUrl = null;
        }
    }
    onEcmImageError(elem) {
        console.log("onEcmImageError", this);
        console.log("onEcmImageError", elem);
    }
}
BBImageComponent.decorators = [
    { type: Component, args: [{
                selector: 'bb-image',
                template: `

      <!-- <h2>bb- image component</h2>
       -->
       <div *ngIf=" isThumbnail " class="img-mask" [ngClass]="attachType == 'Icon' ? 'img-mask-icon' : ''"> </div>

       <div *ngIf="!attachType" class="img-loading" #loadingImage></div>
       <div *ngIf="!attachType" class="bb-image" #targetAttachImage></div>
 
      <!--  <img *ngIf="attachType == 'Image'" class="bb-image" #targetImage /> -->
      <!--  <img *ngIf="attachType == 'Icon'" [ngClass]="isSmallIcon ? 'bb-small-image-icon' : 'bb-image-icon'" #targetImage /> -->

       <div *ngIf=" attachType == 'Image' " class="bb-image" #targetAttachImage></div>
       <div *ngIf=" attachType == 'Icon' " [ngClass]="isSmallIcon ? 'bb-small-image-icon' : 'bb-image-icon'" #targetAttachImage></div>		


 
    `,
                styles: [`
      .bb-image {
      	border-top-right-radius: 5px;
      	border-top-left-radius: 5px;
      	width: 100%;
      	height: calc( 100% - 70px);
      	text-align: center;
      }

      .bb-image:before {
      	content: ' ';
          display: inline-block;
          vertical-align: middle;
          height: 100%;
      }

      .ecm-card > bb-image > .bb-image > img
      {
        /* height: 330px; */
       	height: 230px;
      } 

      .carousel-cell .ecm-card > bb-image > .bb-image,
      .products-section  .ecm-card > bb-image > .bb-image {
      	height: 100%;
      }
      .categories-section .ecm-card > bb-image > .bb-image > img,
      .subcategories-section .ecm-card > bb-image > .bb-image > img,
      .carousel-cell .ecm-card > bb-image > .bb-image > img,
      .products-section  .ecm-card > bb-image > .bb-image > img  
      {
      	height: 100%;
          width: 100%;
          border-top-right-radius: 5px;
          border-top-left-radius: 5px;
      }

      .bb-image-icon {
      	float: left;
      	/*background-color: mediumvioletred;*/
      	border: none;
      	border-radius: 100%;
      	height: 47px;
      	width: 51px;
      }

      .bb-small-image-icon {
      	float: left;
      	/*background-color: mediumvioletred;*/
      	border: none;
      	border-radius: 100%;
      	height: 38px;
      	width: 42px;
      }

      .img-loading {
      	width: 20px;
      	height: 20px;
      	border-radius: 50%;
      	background: #ddd;
      	box-shadow: 0 0 1px #ccc, 15px 30px 1px #ccc, -15px 30px 1px #ccc;
      	position: absolute;
      	top: 45%;
      	left: 55%;
      	margin: -25px 0 0 -25px;
      	-webkit-animation: loader 0.5s infinite ease-in-out both;
      	-moz-animation: loader 0.5s infinite ease-in-out both;
      	animation: loader 0.5s infinite ease-in-out both;
      }

      @-webkit-keyframes loader {
      	0% { background: #ddd; }
      	33% { background: #ccc; box-shadow: 0 0 1px #ccc, 15px 30px 1px #ccc, -15px 30px 1px #ddd; }
      	66% { background: #ccc; box-shadow: 0 0 1px #ccc, 15px 30px 1px #ddd, -15px 30px 1px #ccc; }
      }

      @-moz-keyframes loader {
      	0% { background: #ddd; }
      	33% { background: #ccc; box-shadow: 0 0 1px #ccc, 15px 30px 1px #ccc, -15px 30px 1px #ddd; }
      	66% { background: #ccc; box-shadow: 0 0 1px #ccc, 15px 30px 1px #ddd, -15px 30px 1px #ccc; }
      }

      @keyframes loader {
      	0% { background: #ddd; }
      	33% { background: #ccc; box-shadow: 0 0 1px #ccc, 15px 30px 1px #ccc, -15px 30px 1px #ddd; }
      	66% { background: #ccc; box-shadow: 0 0 1px #ccc, 15px 30px 1px #ddd, -15px 30px 1px #ccc; }
      }

      .img-mask {
      	width: 100%;
      	height: 100%;
      	position: absolute;
      }

      .img-mask-icon {
      	height: 47px;
          width: 51px;
      }

      /* ContentPlugin - External Component CSS*/

      .contentPopupTitle{
      	color: mediumvioletred;
      }
      .galaxyButton {
          cursor: pointer;
          background: mediumvioletred;
          border-radius: 2px;
          margin: 5px 0 5px 0;
          padding: 5px 20px 5px 20px;
          color: #fff;
      }

      .close-button {
      	right: 0 !important;
      	position: absolute !important;
      	display: inline-block !important;
      	width: 24px !important;
      	height: 24px !important;
      	margin: 15px !important;
      	background-color: transparent !important;
      	border: none !important;
      	cursor: pointer !important;
      	border-radius: 100% !important;
      	transition: 0.6s !important;
      	-webkit-transition: 0.6s !important;
      	z-index: 4 !important;
      	box-shadow: none !important;
          left: auto !important;
      }
      .close-button:hover {
      	box-shadow: 0 0 0 8px rgba(0, 0, 0, 0.1), inset 0 0 0 20px
      		rgba(0, 0, 0, 0.1);
          color: transparent;
      }
      .close-button:before, .close-button:after {
      	position: absolute;
      	content: '';
      	top: 50%;
      	left: 0;
      	width: 100%;
      	height: 2px;
      	background-color: #EC7263;
      	background-color: mediumvioletred;
      	border-radius: 5px;
      	transition: 0.5s;
      }
      .close-button:before {
      	transform: translateY(-50%) rotate(45deg) scale(1);
      }
      .close-button:after {
      	transform: translateY(-50%) rotate(-45deg) scale(1);
      }

      .attachedFile {
          border: none !important;
          height: auto !important;
      }

      .thumbnailView {
      	height: calc( 100% - 90px) !important;
      	display: block !important;
      	top: 0 !important;
      	left: 0 !important;
      }
    `],
                encapsulation: ViewEncapsulation.None
            },] },
];
/** @nocollapse */
BBImageComponent.ctorParameters = () => [];
BBImageComponent.propDecorators = {
    'refId': [{ type: Input },],
    'refSer': [{ type: Input },],
    'object': [{ type: Input },],
    'attachType': [{ type: Input },],
    'isSingleImage': [{ type: Input },],
    'height': [{ type: Input },],
    'width': [{ type: Input },],
    'isThumbnail': [{ type: Input },],
    'isSmallIcon': [{ type: Input },],
    'targetDiv': [{ type: ViewChild, args: ['targetAttachImage',] },],
    'targetImg': [{ type: ViewChild, args: ['targetImage',] },],
    'loadingDiv': [{ type: ViewChild, args: ['loadingImage',] },],
};
//# sourceMappingURL=bb-image.component.js.map