import { Component, OnInit, Output, EventEmitter, ViewEncapsulation, Input, ElementRef } from '@angular/core';
import { MdDialog } from '@angular/material';

import { Review } from './review.model';
import { Reviews } from '../../ecm-model/product-review.model';
import { IScreenEditor } from '../screen-editor';
import { UserReviewService } from '../ecm-user-review.service';
import { ECMConfirmDialog } from '../../ecm-view/ecm-cart/ecm-cart.component';

import { Observable } from 'rxjs/Observable';

@Component({
  selector: 'review-manager',
  templateUrl: './review-manager.component.html',
  styleUrls: ['./review-manager.component.css']
})
export class ReviewEditor implements OnInit {

    @Output() onDiscard : EventEmitter<string>  = new EventEmitter<string>();
    @Output() onAddNew : EventEmitter<Reviews>  = new EventEmitter<Reviews>();
    @Output() onSave : EventEmitter<Reviews>  = new EventEmitter<Reviews>();
    @Output() onCancel = new EventEmitter();
    
    @Input() editorId : string;
    @Input() editMode : string = 'V';
    @Input() reviewList : Review;
    @Input('isDetailPage') isDetailPage: boolean = false;
    
    @Input('itemCode') itemCode;
    oldReview : Review;
    isNullReview: boolean = true;

    @Input() userReview: Reviews;

    constructor(private userReviewService:UserReviewService, public dialog: MdDialog){

    }

    ngOnInit() {
        console.log('isDetailPage-Manager',this.isDetailPage);

            /* */
            this.initializeUserReview();
            
            this.userReviewService.getUserReview(this.itemCode).subscribe(
                   userReview => {
                       
                       if(Object.keys(userReview).length){
                           this.isNullReview = false;
                           this.userReview.productRating = userReview.rating;
                           this.userReview.productRemarks = userReview.remarks;
                           this.userReview.productComments = userReview.comments;
                       }
                   }
            );        
    }
    
    initializeUserReview(){
        this.userReview = new Reviews();
        
        this.userReview.productRemarks = "";
        this.userReview.productComments = "";
        this.userReview.productRating = 0;
        this.userReview.item_code = this.itemCode;
    }
    
    edit() {
        this.oldReview = this.simpleClone( this.reviewList );
        this.editMode = 'E';
        localStorage.setItem('editorId', this.editorId );
    }
    
    save(){
        console.log('save', this.userReview);

        this.onSave.emit(this.userReview);
        console.log('save...');
        localStorage.removeItem('editorId');
        this.isNullReview = false;
        this.editMode = 'V';
    }
    
    cancel(){
        //console.log('cancel', this.profileData, this.oldProfile);
        this.reviewList = this.oldReview;
        localStorage.removeItem('editorId');
        if(this.isDetailPage){
            this.onCancel.emit();
        }
        else{
            this.editMode = 'V';
        }
    }
    
    
    simpleClone(obj: any) {
        return Object.assign({}, obj);
    }
    
    remove() {
        this.userReviewService.removeReview(this.itemCode);
        this.initializeUserReview();
        this.isNullReview = true;
    }
    
    confirmDialog() {
        let dialogRef = this.dialog.open( ECMConfirmDialog,{
            width:'300px',
            height:'180px',
            disableClose: true
        });
        dialogRef.componentInstance.dialogTitle = "Remove Review ?";
        //dialogRef.componentInstance.confirmMsg = "Would you like to remove item from cart?";
        dialogRef.componentInstance.cancelText = "No";
        dialogRef.componentInstance.confirmText = "Yes";
        dialogRef.afterClosed().subscribe( result => {
            if( result == 'true')
            {
                this.remove();
            }
        });
    }

}
