/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import org.infinispan.configuration.cache.AsyncConfiguration;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.HashConfiguration;
import org.infinispan.configuration.cache.L1Configuration;
import org.infinispan.configuration.cache.PartitionHandlingConfiguration;
import org.infinispan.configuration.cache.StateTransferConfiguration;
import org.infinispan.configuration.cache.SyncConfiguration;

public class ClusteringConfiguration {
    private final CacheMode cacheMode;
    private final AsyncConfiguration asyncConfiguration;
    private final HashConfiguration hashConfiguration;
    private final L1Configuration l1Configuration;
    private final StateTransferConfiguration stateTransferConfiguration;
    private final SyncConfiguration syncConfiguration;
    private final PartitionHandlingConfiguration partitionHandlingConfiguration;

    ClusteringConfiguration(CacheMode cacheMode, AsyncConfiguration asyncConfiguration, HashConfiguration hashConfiguration, L1Configuration l1Configuration, StateTransferConfiguration stateTransferConfiguration, SyncConfiguration syncConfiguration, PartitionHandlingConfiguration partitionHandlingStrategy) {
        this.cacheMode = cacheMode;
        this.asyncConfiguration = asyncConfiguration;
        this.hashConfiguration = hashConfiguration;
        this.l1Configuration = l1Configuration;
        this.stateTransferConfiguration = stateTransferConfiguration;
        this.syncConfiguration = syncConfiguration;
        this.partitionHandlingConfiguration = partitionHandlingStrategy;
    }

    public CacheMode cacheMode() {
        return this.cacheMode;
    }

    public PartitionHandlingConfiguration partitionHandling() {
        return this.partitionHandlingConfiguration;
    }

    public String cacheModeString() {
        return this.cacheMode == null ? "none" : this.cacheMode.toString();
    }

    public AsyncConfiguration async() {
        return this.asyncConfiguration;
    }

    public HashConfiguration hash() {
        return this.hashConfiguration;
    }

    public L1Configuration l1() {
        return this.l1Configuration;
    }

    public SyncConfiguration sync() {
        return this.syncConfiguration;
    }

    public StateTransferConfiguration stateTransfer() {
        return this.stateTransferConfiguration;
    }

    public String toString() {
        return "ClusteringConfiguration{async=" + this.asyncConfiguration + ", cacheMode=" + (Object)((Object)this.cacheMode) + ", hash=" + this.hashConfiguration + ", l1=" + this.l1Configuration + ", stateTransfer=" + this.stateTransferConfiguration + ", sync=" + this.syncConfiguration + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusteringConfiguration that = (ClusteringConfiguration)o;
        if (this.asyncConfiguration != null ? !this.asyncConfiguration.equals(that.asyncConfiguration) : that.asyncConfiguration != null) {
            return false;
        }
        if (this.cacheMode != that.cacheMode) {
            return false;
        }
        if (this.hashConfiguration != null ? !this.hashConfiguration.equals(that.hashConfiguration) : that.hashConfiguration != null) {
            return false;
        }
        if (this.l1Configuration != null ? !this.l1Configuration.equals(that.l1Configuration) : that.l1Configuration != null) {
            return false;
        }
        if (this.stateTransferConfiguration != null ? !this.stateTransferConfiguration.equals(that.stateTransferConfiguration) : that.stateTransferConfiguration != null) {
            return false;
        }
        return !(this.syncConfiguration != null ? !this.syncConfiguration.equals(that.syncConfiguration) : that.syncConfiguration != null);
    }

    public int hashCode() {
        int result = this.cacheMode != null ? this.cacheMode.hashCode() : 0;
        result = 31 * result + (this.asyncConfiguration != null ? this.asyncConfiguration.hashCode() : 0);
        result = 31 * result + (this.hashConfiguration != null ? this.hashConfiguration.hashCode() : 0);
        result = 31 * result + (this.l1Configuration != null ? this.l1Configuration.hashCode() : 0);
        result = 31 * result + (this.stateTransferConfiguration != null ? this.stateTransferConfiguration.hashCode() : 0);
        result = 31 * result + (this.syncConfiguration != null ? this.syncConfiguration.hashCode() : 0);
        return result;
    }
}

