/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.facet;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.PriorityQueue;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.DocSet;
import org.apache.solr.search.facet.FacetContext;
import org.apache.solr.search.facet.FacetField;
import org.apache.solr.search.facet.FacetFieldProcessor;
import org.apache.solr.search.facet.SlotAcc;

abstract class FacetFieldProcessorFCBase
extends FacetFieldProcessor {
    BytesRefBuilder prefixRef;
    int startTermIndex;
    int endTermIndex;
    int nTerms;
    int nDocs;
    int maxSlots;
    int allBucketsSlot;

    public FacetFieldProcessorFCBase(FacetContext fcontext, FacetField freq, SchemaField sf) {
        super(fcontext, freq, sf);
    }

    @Override
    public void process() throws IOException {
        super.process();
        this.sf = this.fcontext.searcher.getSchema().getField(((FacetField)this.freq).field);
        this.response = this.getFieldCacheCounts();
    }

    protected abstract BytesRef lookupOrd(int var1) throws IOException;

    protected abstract void findStartAndEndOrds() throws IOException;

    protected abstract void collectDocs() throws IOException;

    public SimpleOrderedMap<Object> getFieldCacheCounts() throws IOException {
        String prefix = ((FacetField)this.freq).prefix;
        if (prefix == null || prefix.length() == 0) {
            this.prefixRef = null;
        } else {
            this.prefixRef = new BytesRefBuilder();
            this.prefixRef.copyChars((CharSequence)prefix);
        }
        this.findStartAndEndOrds();
        this.maxSlots = ((FacetField)this.freq).missing && this.startTermIndex != -1 ? this.nTerms + 1 : this.nTerms;
        this.allBucketsSlot = ((FacetField)this.freq).allBuckets ? this.maxSlots++ : -1;
        this.createAccs(this.nDocs, this.maxSlots);
        this.setSortAcc(this.maxSlots);
        this.prepareForCollection();
        this.collectDocs();
        return this.findTopSlots();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SimpleOrderedMap<Object> findTopSlots() throws IOException {
        int i;
        int off;
        SimpleOrderedMap res = new SimpleOrderedMap();
        int numBuckets = 0;
        ArrayList<Object> bucketVals = null;
        if (((FacetField)this.freq).numBuckets && this.fcontext.isShard()) {
            bucketVals = new ArrayList<Object>(100);
        }
        int n = off = this.fcontext.isShard() ? 0 : (int)((FacetField)this.freq).offset;
        int lim = ((FacetField)this.freq).limit >= 0L ? (this.fcontext.isShard() ? (int)((double)((FacetField)this.freq).limit * 1.1 + 4.0) : (int)((FacetField)this.freq).limit) : Integer.MAX_VALUE;
        int maxsize = (int)(((FacetField)this.freq).limit > 0L ? ((FacetField)this.freq).offset + (long)lim : 0x7FFFFFFEL);
        maxsize = Math.min(maxsize, this.nTerms);
        final int sortMul = ((FacetField)this.freq).sortDirection.getMultiplier();
        final SlotAcc sortAcc = this.sortAcc;
        PriorityQueue<FacetFieldProcessor.Slot> queue = new PriorityQueue<FacetFieldProcessor.Slot>(maxsize){

            protected boolean lessThan(FacetFieldProcessor.Slot a, FacetFieldProcessor.Slot b) {
                int cmp = sortAcc.compare(a.slot, b.slot) * sortMul;
                return cmp == 0 ? b.slot < a.slot : cmp < 0;
            }
        };
        FacetFieldProcessor.Slot bottom = null;
        int n2 = i = this.startTermIndex == -1 ? 1 : 0;
        while (i < this.nTerms) {
            if (this.countAcc.getCount(i) >= this.effectiveMincount) {
                ++numBuckets;
                if (bucketVals != null && bucketVals.size() < 100) {
                    int ord = this.startTermIndex + i;
                    BytesRef br = this.lookupOrd(ord);
                    Object object = this.sf.getType().toObject(this.sf, br);
                    bucketVals.add(object);
                }
                if (bottom != null) {
                    if (sortAcc.compare(bottom.slot, i) * sortMul < 0) {
                        bottom.slot = i;
                        bottom = (FacetFieldProcessor.Slot)queue.updateTop();
                    }
                } else {
                    FacetFieldProcessor.Slot s = new FacetFieldProcessor.Slot();
                    s.slot = i;
                    queue.add((Object)s);
                    if (queue.size() >= maxsize) {
                        bottom = (FacetFieldProcessor.Slot)queue.top();
                    }
                }
            }
            ++i;
        }
        if (((FacetField)this.freq).numBuckets) {
            if (!this.fcontext.isShard()) {
                res.add("numBuckets", (Object)numBuckets);
            } else {
                SimpleOrderedMap map = new SimpleOrderedMap(2);
                map.add("numBuckets", (Object)numBuckets);
                map.add("vals", bucketVals);
                res.add("numBuckets", (Object)map);
            }
        }
        int collectCount = Math.max(0, queue.size() - off);
        assert (collectCount <= lim);
        int[] sortedSlots = new int[collectCount];
        for (int i2 = collectCount - 1; i2 >= 0; --i2) {
            sortedSlots[i2] = ((FacetFieldProcessor.Slot)queue.pop()).slot;
        }
        if (((FacetField)this.freq).allBuckets) {
            SimpleOrderedMap allBuckets = new SimpleOrderedMap();
            this.countAcc.setValues((SimpleOrderedMap<Object>)allBuckets, this.allBucketsSlot);
            for (SlotAcc acc : this.accs) {
                acc.setValues((SimpleOrderedMap<Object>)allBuckets, this.allBucketsSlot);
            }
            res.add("allBuckets", (Object)allBuckets);
        }
        ArrayList<SimpleOrderedMap> bucketList = new ArrayList<SimpleOrderedMap>(collectCount);
        res.add("buckets", bucketList);
        for (int slotNum : sortedSlots) {
            SimpleOrderedMap bucket = new SimpleOrderedMap();
            int ord = this.startTermIndex + slotNum;
            BytesRef br = this.lookupOrd(ord);
            Object val = this.sf.getType().toObject(this.sf, br);
            bucket.add("val", val);
            this.addStats((SimpleOrderedMap<Object>)bucket, slotNum);
            if (((FacetField)this.freq).getSubFacets().size() > 0) {
                TermQuery filter = new TermQuery(new Term(this.sf.getName(), br.clone()));
                this.processSubs((SimpleOrderedMap<Object>)bucket, (Query)filter, this.fcontext.searcher.getDocSet((Query)filter, this.fcontext.base));
            }
            bucketList.add(bucket);
        }
        if (((FacetField)this.freq).missing) {
            SimpleOrderedMap simpleOrderedMap = new SimpleOrderedMap();
            DocSet missingDocSet = null;
            try {
                if (this.startTermIndex == -1) {
                    this.addStats((SimpleOrderedMap<Object>)simpleOrderedMap, 0);
                } else {
                    missingDocSet = FacetFieldProcessorFCBase.getFieldMissing(this.fcontext.searcher, this.fcontext.base, ((FacetField)this.freq).field);
                    this.countAcc.incrementCount(this.nTerms, missingDocSet.size());
                    this.collect(missingDocSet, this.nTerms);
                    this.addStats((SimpleOrderedMap<Object>)simpleOrderedMap, this.nTerms);
                }
                if (((FacetField)this.freq).getSubFacets().size() > 0) {
                    if (missingDocSet == null) {
                        missingDocSet = FacetFieldProcessorFCBase.getFieldMissing(this.fcontext.searcher, this.fcontext.base, ((FacetField)this.freq).field);
                    }
                    this.processSubs((SimpleOrderedMap<Object>)simpleOrderedMap, FacetFieldProcessorFCBase.getFieldMissingQuery(this.fcontext.searcher, ((FacetField)this.freq).field), missingDocSet);
                }
                res.add("missing", (Object)simpleOrderedMap);
            }
            finally {
                if (missingDocSet != null) {
                    missingDocSet = null;
                }
            }
        }
        return res;
    }
}

