/**
 * PURPOSE : Process for Perk Claim verification
 * AUTHOR : Kunal Mandhre
 * DATE : 10/10/2012
 */
package ibase.webitm.ejb.adm;

import ibase.webitm.ejb.*;
import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.ejb.adm.AdmCommon;
import ibase.webitm.ejb.adm.adv.PayrollVoucherConf;
import ibase.webitm.ejb.dis.DistCommon;
import ibase.webitm.ejb.fin.FinCommon;
import ibase.webitm.ejb.sys.CreateRCPXML;
import ibase.webitm.utility.TransIDGenerator;
import ibase.utility.CommonConstants;
import java.rmi.RemoteException;
import java.sql.*;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;

import org.w3c.dom.*;


@javax.ejb.Stateless
public class PerkClaimProcessComm extends ValidatorEJB implements PerkClaimProcessCommLocal, PerkClaimProcessCommRemote
{
	public String postSave()throws RemoteException,ITMException
	{
		return "";
	}
	public String postSave(String domString, String tranId,String editFlag, String xtraParams, Connection conn ) throws RemoteException,ITMException
	{
		String errString = "";
		String sql = "";
		String empCode = "", adCode = "" , paySite = "" , bankCodeHdr = "";
		String payrollVoucher = "" , payrollPrd = "",envVar = "",mounth = "",fullAmt = "";
		String finEntity = "",deptCode = "", payMode = "", payModeHdr = "",currCode = "",bankCode = ""; 
		String acctCode = "" , cctrCode = "";
		String refNo = "",schemeNo = "",loanAdCode = "" ;
		String tranIdForLoan = "";
		double claimAmount = 0,balAmount = 0,adjAmt = 0 ,claimPaid = 0;
		double monInst = 0, interest = 0,loanAmt = 0;;
		int count = 0,noRowInst = 0;
		Timestamp frDate = null , toDate = null ;
		Date startDate = null, endDate = null;
		HashMap payHdr = new HashMap();
		ArrayList payDetList = new ArrayList();
		HashMap payDet = null;
		GenericUtility genericUtility = GenericUtility.getInstance();
		ITMDBAccessEJB itmDBAccess = new ITMDBAccessEJB();		
		PreparedStatement pstmt = null;		
		ResultSet rs = null;
		java.util.Date claimDate = null;
		Document dom = null;
		Timestamp  currDate = null;
		NodeList parentNodeList = null;
		Node parentNode = null;
		System.out.println("dom String = "+domString);
		String chgTerm = "";
		String userId = "",tranIdGenerate="",lineNo="";
		int parentNodeListLength = 0;
		AdmCommon admCommon = null;
		SimpleDateFormat sdf = null,simpleDateFormat =null;

		try
		{
			conn.setAutoCommit(false);	
			dom=parseString(domString);
			admCommon = new AdmCommon();
			simpleDateFormat = new SimpleDateFormat("dd/MM/yy");
			sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());

			//NodeList detail2List = dom.getElementsByTagName("Detail2");
			//if(detail2List != null && detail2List.getLength() > 0)
			//{
			//parse  Detail2 start 
			/*System.out.println("Detail2 length = "+detail2List.getLength());
				if(detail2List.getLength() < 1)
				{
					errString = itmDBAccess.getErrorString("","VTNOSEL","","",conn);
					return errString;
				}*/
			parentNodeList = dom.getElementsByTagName("Detail2");
			parentNodeListLength = parentNodeList.getLength();
			System.out.println("Detail2 length = "+parentNodeList.getLength());
			if(parentNodeList.getLength() < 1)
			{
				errString = itmDBAccess.getErrorString("","VTNOSEL","","",conn);
				return errString;
			}
			payrollVoucher =  genericUtility.getColumnValue("payroll_voucher", dom);
			payrollPrd =  checkNull(genericUtility.getColumnValue("payroll_prd", dom));
			empCode =  genericUtility.getColumnValue("emp_code", dom);
			adCode =  checkNull(genericUtility.getColumnValue("ad_code", dom));
			fullAmt =  checkNull(genericUtility.getColumnValue("full_amt", dom));
			if(genericUtility.getColumnValue("claim_date", dom) == null)
			{
				claimDate = null;
			}
			else
			{
				claimDate =  sdf.parse(genericUtility.getColumnValue("claim_date", dom));
			}

			System.out.println(payrollVoucher+"   "+payrollPrd+"    "+empCode+"    "+adCode+"   "+claimDate+"       "+fullAmt );
			///To check for previous pending claims
			
			for(int ctr = 0; ctr < parentNodeListLength ; ctr++ )
			{
				//System.out.println("TEST LENGTH="+parentNodeListLength);
				parentNode = parentNodeList.item(ctr);
				//Element  parentNode1 = (Element)parentNodeList.item(ctr);
				//String selected = parentNode1.getAttribute("selected");//change by Kunal on 31/08/12

				//claimAmount = Double.parseDouble(genericUtility.getColumnValue("claim_amt", dom, "2")== null?"0":genericUtility.getColumnValue("claim_amt", dom, "2"));
				claimAmount = Double.parseDouble(genericUtility.getColumnValueFromNode( "claim_amt", parentNodeList.item(ctr) )== null?"0":genericUtility.getColumnValueFromNode( "claim_amt", parentNodeList.item(ctr) ));
				balAmount = Double.parseDouble(genericUtility.getColumnValueFromNode( "amt_bal", parentNodeList.item(ctr) )== null?"0":genericUtility.getColumnValueFromNode( "amt_bal", parentNodeList.item(ctr) ));
				//balAmount = Double.parseDouble(genericUtility.getColumnValue("amt_bal", dom, "2")== null?"0":genericUtility.getColumnValue("amt_bal", dom, "2"));
				if("Y".equalsIgnoreCase(fullAmt))
				{
					if(balAmount != claimAmount)
					{
						errString = itmDBAccess.getErrorString("","VTPERK1","","",conn);
						return errString;
					}
				}

			}

			if(payrollPrd != null && payrollPrd.trim().length() >= 6)
			{
				mounth = payrollPrd.trim().substring(4,6);
			}
			System.out.println("mounth==="+mounth);

			
			if("P".equalsIgnoreCase(payrollVoucher))
			{
				envVar = admCommon.getEnv("999999", adCode.trim()+"_CLAIMAD", conn);
				System.out.println("env Var="+envVar);
				if("NULLFOUND".equalsIgnoreCase(envVar))
				{
					errString = itmDBAccess.getErrorString("","VSENVAR1","","",conn);
					return errString;
				}
				sql = " select fr_date, to_date  from period where code = ?";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, payrollPrd);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					frDate = rs.getTimestamp("fr_date");
					toDate = rs.getTimestamp("to_date");
				}
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;
			}

			/*sql = " select key_string from transetup where upper(tran_window) = 'W_LOAN_RECO' ";
			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			if(rs == null)
			{
				errString = itmDBAccess.getErrorString("","VTSEQ","","",conn);
				return errString;
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
*/
			parentNodeList = dom.getElementsByTagName("Detail2");
			parentNodeListLength = parentNodeList.getLength();
			double claimTotalAmt = 0.0;
			System.out.println("TEST LENGTH 2="+parentNodeListLength);
			// get the total claim amt 
			for(int ctr = 0; ctr < parentNodeListLength ; ctr++ )
			{
				
				//parentNode = parentNodeList.item(ctr);
				//Element  parentNode1 = (Element)parentNodeList.item(ctr);
				//claimAmount = Double.parseDouble(genericUtility.getColumnValue("claim_amt", dom, "2")== null?"0":genericUtility.getColumnValue("claim_amt", dom, "2"));
				claimAmount = Double.parseDouble(genericUtility.getColumnValueFromNode( "claim_amt", parentNodeList.item(ctr) )== null?"0":genericUtility.getColumnValueFromNode( "claim_amt", parentNodeList.item(ctr) ));
				System.out.println("claimAmount="+claimAmount);
				claimTotalAmt = claimTotalAmt + claimAmount;
			}
			System.out.println("claimTotalAmount="+claimTotalAmt);

			parentNodeList = dom.getElementsByTagName("Detail3");
			parentNodeListLength = parentNodeList.getLength();
			System.out.println("TEST LENGTH 3="+parentNodeListLength);
			double totalAdjAmt = 0.0; 
			// get the total loan adjusted amount
			for(int ctr = 0; ctr < parentNodeListLength ; ctr++ )
			{
				
				parentNode = parentNodeList.item(ctr);
				//Element  parentNode1 = (Element)parentNodeList.item(ctr);
				adjAmt = Double.parseDouble(genericUtility.getColumnValue("adj_amt", dom, "2")== null?"0":genericUtility.getColumnValue("adj_amt", dom, "2"));
				System.out.println("adjAmt="+adjAmt);
				totalAdjAmt = totalAdjAmt + adjAmt;
			}
			System.out.println("totalAdjAmt="+totalAdjAmt);
			claimPaid = claimTotalAmt - totalAdjAmt;
			if(claimPaid < 0 && totalAdjAmt > 0)
			{
				errString = itmDBAccess.getErrorString("","VMADJAMT2","","",conn);
				return errString;
			}

			// get other information to create the voucher and to generate id
			sql = " select pay_site, site.fin_entity, dept_code, pay_mode, curr_code, employee.bank_code "
					+"	from employee, site, finent where employee.pay_site = site.site_code and "
					+"	site.fin_entity = finent.fin_entity and  emp_code = ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, empCode);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				paySite = checkNull(rs.getString("pay_site"));
				finEntity = checkNull(rs.getString("fin_entity"));
				deptCode= checkNull(rs.getString("dept_code"));
				payMode = checkNull(rs.getString("pay_mode"));
				currCode = checkNull(rs.getString("curr_code"));
				bankCode = checkNull(rs.getString("bank_code"));
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;

			bankCodeHdr =  genericUtility.getColumnValue("bank_code", dom);
			payModeHdr =  genericUtility.getColumnValue("pay_mode", dom);
			if(bankCodeHdr != null && bankCodeHdr.trim().length() > 0)
			{
				bankCode = bankCodeHdr;
			}
			if(payModeHdr != null && payModeHdr.trim().length() > 0)
			{
				payMode = payModeHdr;
			}

			/*sql = " select key_string from transetup where upper(tran_window) ='T_EMP_ADCLAIM'";
			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			if(rs == null)
			{
				errString = itmDBAccess.getErrorString("","VTSEQ","","",conn);
				return errString;
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;*/

			currDate = new java.sql.Timestamp(System.currentTimeMillis());
			userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode");
			chgTerm = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "chgTerm" );
			//siteCode = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "site_code" );
			SimpleDateFormat sdfAppl = new SimpleDateFormat(genericUtility.getApplDateFormat());
			//String currDateStr = sdfAppl.format(currDate);
			String claimDateStr = sdfAppl.format(claimDate);
			//tranIdGenerate = generateTranId( "t_emp_adclaim", siteCode, currDateStr, conn );
			tranIdGenerate = generateTranId( "t_emp_adclaim", paySite, claimDateStr, conn );
			System.out.println("tranIdGenerate for emp claim = "+tranIdGenerate);

			if(tranIdGenerate == null || tranIdGenerate.trim().length() == 0)
			{
				errString = itmDBAccess.getErrorString("","VTTRANID","","",conn);
				return errString;
			}
			// insert single record into emp_adclaimhdr
			sql = " insert into emp_adclaimhdr (tran_id, tran_date, emp_code, claim_amt, loan_adjamt,"
					+" payroll_voucher, prd_code__payroll, chg_date, chg_user, chg_term, ad_code,confirmed) "
					+"	values (?, ?,?,?,?,?,?,?,?,?,?,'Y')";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, tranIdGenerate);
			pstmt.setDate(2,claimDate ==null?null:new java.sql.Date(claimDate.getTime()));
			pstmt.setString(3, empCode);
			pstmt.setDouble(4, claimTotalAmt);
			pstmt.setDouble(5, totalAdjAmt);
			pstmt.setString(6, payrollVoucher);
			pstmt.setString(7, payrollPrd);
			// Modified by Piyush on 03/06/2016 [To  update time in change date]
			// pstmt.setTimestamp(8, currDate);
			pstmt.setTimestamp(8, new java.sql.Timestamp(System.currentTimeMillis()));
			pstmt.setString(9, userId);
			pstmt.setString(10, chgTerm);
			pstmt.setString(11, adCode);
			noRowInst = pstmt.executeUpdate();
			System.out.println("no of row inserted emp_adclaimhdr = "+noRowInst);
			pstmt.close();
			pstmt = null;
			if("P".equalsIgnoreCase(payrollVoucher))
			{
				if(claimPaid > 0)
				{
					sql = " select count(*) from employee_mthad where emp_code = ? "
							+" and ad_code = ? 	and eff_date = ?  and exp_date = ? ";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, empCode);
					pstmt.setString(2, envVar);
					pstmt.setTimestamp(3, frDate);
					pstmt.setTimestamp(4,toDate);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						count = rs.getInt(1);
					}
					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null;
					if(count > 0)
					{
						sql = " update employee_mthad set type = 'F', amount =amount + ? ,  ref_type  = 'C'," 
								+" ref_no = ? , prop_yn = 'N' 	where emp_code = ?  "
								+" and ad_code = ? 	and eff_date = ?  and exp_date = ? ";
						pstmt = conn.prepareStatement(sql);
						pstmt.setDouble(1, claimTotalAmt);
						pstmt.setString(2, tranIdGenerate);
						pstmt.setString(3, empCode);
						pstmt.setString(4, envVar);
						pstmt.setTimestamp(5, frDate);
						pstmt.setTimestamp(6, toDate);
						noRowInst = pstmt.executeUpdate();
						System.out.println("no of row updated employee_mthad= "+noRowInst);
						pstmt.close();
						pstmt = null;
					}
					else
					{
						//issue
						sql = "insert into employee_mthad (emp_code, month_code, ad_code, eff_date, exp_date, type, amount,"
								+" chg_date, chg_user, chg_term, ref_type, ref_no, prop_yn) "
								+" Values(?,?,?,?,?,'F',?,?,?,?,'C',?,'N')";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1,empCode);
						pstmt.setString(2,mounth);
						pstmt.setString(3,envVar);
						pstmt.setTimestamp(4, frDate);
						pstmt.setTimestamp(5, toDate);
						pstmt.setDouble(6, claimTotalAmt);
						// Modified by Piyush on 03/06/2016 [To  update time in change date]
						// pstmt.setTimestamp(7, currDate);
						pstmt.setTimestamp(7, new java.sql.Timestamp(System.currentTimeMillis()));
						pstmt.setString(8, userId);
						pstmt.setString(9, chgTerm);
						pstmt.setString(10, tranIdGenerate);
						noRowInst = pstmt.executeUpdate();
						System.out.println("no of row inserted employee_mthad = "+noRowInst);
						pstmt.close();
						pstmt = null;
					}
				}
			}
			else
			{
				// Create record in payr_voucher

				// set1 - if bank_code i.e. ls_bank is empty, then take it from parameter table
				if(bankCode == null || bankCode.trim().length() == 0)
				{
					bankCode = admCommon.getEnv("999999", "BANKCODE", conn);
					System.out.println("env Var bankCode="+bankCode);
					if("NULLFOUND".equalsIgnoreCase(bankCode))
					{
						errString = itmDBAccess.getErrorString("","VSENVAR1","","",conn);
						return errString;
					}	
				}
				sql = " select acct_code, cctr_code from department where dept_code = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, deptCode);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					acctCode = checkNull(rs.getString("acct_code"));
					cctrCode = checkNull(rs.getString("cctr_code"));
				}
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;

				payHdr.put("tran_date",claimDate);
				payHdr.put("tran_type","PRK");
				payHdr.put("eff_date",claimDate);
				payHdr.put("emp_code",empCode);
				payHdr.put("ref_no",tranIdGenerate);
				payHdr.put("ref_date",claimDate);
				payHdr.put("bank_code",bankCode);
				payHdr.put("auto_pay","Y");
				payHdr.put("site_code",paySite);
				payHdr.put("fin_entity",finEntity);
				payHdr.put("tot_amt",claimPaid);
				payHdr.put("anal_code",null);
				payHdr.put("confirmed","N");
				payHdr.put("paid","N");
				payHdr.put("acct_code__pay",acctCode);
				payHdr.put("cctr_code__pay",cctrCode);
				payHdr.put("pay_mode",payMode);
				payHdr.put("batch_no",paySite+"          ");
				payHdr.put("vouch_type","O");
				payHdr.put("curr_code",currCode);
				payHdr.put("exch_rate",1.0);
				payHdr.put("remarks","Through claim, " + envVar + " , on " + claimDate.toString());
				payHdr.put("chg_date",currDate);
				payHdr.put("chg_user",userId);
				payHdr.put("chg_term",chgTerm);

			}

			parentNodeList = dom.getElementsByTagName("Detail2");
			parentNodeListLength = parentNodeList.getLength();
			for(int ctr = 0; ctr < parentNodeListLength ; ctr++ )
			{
				//parse  Detail2 start 
				System.out.println("TEST LENGTH Detail2 ="+parentNodeListLength);
				//parentNode = parentNodeList.item(ctr);
				//claimAmount = Double.parseDouble(genericUtility.getColumnValue("claim_amt", dom, "2")== null?"0":genericUtility.getColumnValue("claim_amt", dom, "2"));
				claimAmount = Double.parseDouble(genericUtility.getColumnValueFromNode( "claim_amt", parentNodeList.item(ctr) )== null?"0":genericUtility.getColumnValueFromNode( "claim_amt", parentNodeList.item(ctr) ));
				balAmount = Double.parseDouble(genericUtility.getColumnValueFromNode( "amt_bal", parentNodeList.item(ctr) )== null?"0":genericUtility.getColumnValueFromNode( "amt_bal", parentNodeList.item(ctr) ));
				//balAmount = Double.parseDouble(genericUtility.getColumnValue("amt_bal", dom, "2")== null?"0":genericUtility.getColumnValue("amt_bal", dom, "2"));
				if(genericUtility.getColumnValueFromNode( "start_date", parentNodeList.item(ctr) ) == null)
				{
					startDate = null;
				}
				else
				{
					startDate =  simpleDateFormat.parse(genericUtility.getColumnValueFromNode( "start_date", parentNodeList.item(ctr) ));
				}
				if(genericUtility.getColumnValueFromNode( "end_date", parentNodeList.item(ctr) ) == null)
				{
					endDate = null;
				}
				else
				{
					endDate =  simpleDateFormat.parse(genericUtility.getColumnValueFromNode( "end_date", parentNodeList.item(ctr) ));
				}
				System.out.println("457  "+claimAmount+"   "+balAmount+"        "+startDate+"      "+endDate);
				//ls_errcode = nvo_claimproc.gbf_claim_proc(ls_ad ,ls_emp ,ld_start,ld_end ,lc_claimamt)
				sql = " update allowdedn_bal set 	amt_bal	= amt_bal - ? ,amt_adj  = amt_adj + ? "
						+"	where emp_code = ?   and ad_code    = ?  and start_date = ?  and end_date   = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setDouble(1,claimAmount );
				pstmt.setDouble(2,claimAmount );
				pstmt.setString(3, empCode);
				pstmt.setString(4, adCode);
				pstmt.setDate(5,startDate ==null?null:new java.sql.Date(startDate.getTime()));
				pstmt.setDate(6,endDate ==null?null:new java.sql.Date(endDate.getTime()));
				noRowInst = pstmt.executeUpdate();
				System.out.println("no of row updated allowdedn_bal= "+noRowInst);
				pstmt.close();
				pstmt = null;

				sql = "insert into emp_adclaim 	(tran_id, emp_code, ad_code, eff_date, bal_amt, claim_amt) "
						+" values 	(? , ? , ? , ? ,? ,?)";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,tranIdGenerate);
				pstmt.setString(2, empCode);
				pstmt.setString(3, adCode);
				pstmt.setDate(4,startDate ==null?null: new java.sql.Date(startDate.getTime()));
				pstmt.setDouble(5,balAmount );
				pstmt.setDouble(6,claimAmount );
				noRowInst = pstmt.executeUpdate();
				System.out.println("no of row inserted emp_adclaim= "+noRowInst);
				pstmt.close();
				pstmt = null;

				//issue
				/*sql = "insert into payr_vouchdet (tran_id,line_no,acct_code,cctr_code,amount,ad_code,anal_code) "
							+" values ( ?,?,?,?,?,?,?) ";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1,"");
					pstmt.setInt(2, 1);
					pstmt.setString(3, "");
					pstmt.setString(4, "");
					pstmt.setDouble(5,claimAmount );
					pstmt.setString(6, adCode);
					pstmt.setString(7, "");
					noRowInst = pstmt.executeUpdate();
					System.out.println("no of row inserted payr_vouchdet= "+noRowInst);
					pstmt.close();
					pstmt = null;*/
				payDet = new HashMap();
				payDet.put("amount", claimAmount);
				payDet.put("ad_code", adCode);
				payDetList.add(payDet);


			}//parse  Detail2 end


			NodeList detail3List = dom.getElementsByTagName("Detail3");
			parentNodeListLength = detail3List.getLength();
			System.out.println("TEST LENGTH LOAN=="+parentNodeListLength);
			for(int ctr = 0; ctr < parentNodeListLength ; ctr++ )
			{
				//parse Detail3 start 
				
				//parentNode = parentNodeList.item(ctr);
				//tranId = genericUtility.getColumnValueFromNode( "tran_id", parentNodeList.item(ctr) );


				//refNo =  genericUtility.getColumnValue("ref_no", dom, "3");		
				refNo =  genericUtility.getColumnValueFromNode( "ref_no", detail3List.item(ctr) );
				loanAdCode =  genericUtility.getColumnValueFromNode( "ad_code", detail3List.item(ctr) ) ; 
				//loanAmt = Double.parseDouble(genericUtility.getColumnValue("loan_amt", dom, "3")== null?"0":genericUtility.getColumnValue("loan_amt", dom, "3"));
				loanAmt =  Double.parseDouble( checkNull(genericUtility.getColumnValueFromNode( "loan_amt", detail3List.item(ctr))).trim().length() == 0 ?"0": (genericUtility.getColumnValueFromNode( "loan_amt", detail3List.item(ctr))).trim() );
				
				//adjAmt = Double.parseDouble(genericUtility.getColumnValue("adj_amt", dom, "3")== null?"0":genericUtility.getColumnValue("adj_amt", dom, "3"));
				adjAmt =  Double.parseDouble( checkNull(genericUtility.getColumnValueFromNode( "adj_amt", detail3List.item(ctr))).trim().length() == 0 ?"0": (genericUtility.getColumnValueFromNode( "adj_amt", detail3List.item(ctr))).trim() );
				//monInst = Double.parseDouble(genericUtility.getColumnValue("mon_inst", dom, "3")== null?"0":genericUtility.getColumnValue("mon_inst", dom, "3"));
				monInst =  Double.parseDouble( checkNull(genericUtility.getColumnValueFromNode( "mon_inst", detail3List.item(ctr))).trim().length() == 0 ?"0": (genericUtility.getColumnValueFromNode( "mon_inst", detail3List.item(ctr))).trim() );
				//interest = Double.parseDouble(genericUtility.getColumnValue("interest", dom, "3")== null?"0":genericUtility.getColumnValue("interest", dom, "3"));
				interest =  Double.parseDouble( checkNull(genericUtility.getColumnValueFromNode( "interest", detail3List.item(ctr))).trim().length() == 0 ?"0": (genericUtility.getColumnValueFromNode( "interest", detail3List.item(ctr))).trim() );
				//schemeNo =  genericUtility.getColumnValue("scheme_no", dom, "3");
				schemeNo =  genericUtility.getColumnValueFromNode( "scheme_no", detail3List.item(ctr) );
				//lineNo =  genericUtility.getColumnValue("line_no", dom, "3");

				System.out.println("refNo::"+refNo+"   adjAmt="+adjAmt+"  schemeNo="+schemeNo);
				if(genericUtility.getColumnValueFromNode( "start_date", detail3List.item(ctr) )  == null)
				{
					startDate = null;
				}
				else
				{
					startDate =  simpleDateFormat.parse(genericUtility.getColumnValueFromNode( "start_date", detail3List.item(ctr) ));
				}
				if(genericUtility.getColumnValueFromNode( "end_date", detail3List.item(ctr) )  == null)
				{
					endDate = null;
				}
				else
				{
					endDate =  simpleDateFormat.parse(genericUtility.getColumnValueFromNode( "end_date", detail3List.item(ctr) ));
				}
				
				
				// update dw_payrv for voucher creation with loan amount adjusted in voucher detail
				/*ll_crow = dw_payrv_det.insertrow(0)
					dw_payrv_det.setitem(ll_crow, "ad_code", ls_loan_ad)
					dw_payrv_det.setitem(ll_crow, "amount", 0 - lc_adjamt)

					ls_remarks = 'Through claim, ' + ls_ad + ' , on ' + string(ld_claim, 'dd/mm/yy')*/

				/*sql = "insert into payr_vouchdet (tran_id,line_no,acct_code,cctr_code,amount,ad_code,anal_code) "
							+" values ( ?,?,?,?,?,?,?) ";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1,"");
					pstmt.setInt(2, 1);
					pstmt.setString(3, "");
					pstmt.setString(4, "");
					pstmt.setDouble(5,0-adjAmt );
					pstmt.setString(6, loanAdCode);
					pstmt.setString(7, "");
					noRowInst = pstmt.executeUpdate();
					System.out.println("no of row inserted payr_vouchdet= "+noRowInst);
					pstmt.close();
					pstmt = null;*/
				payDet = new HashMap();
				payDet.put("amount", 0-adjAmt);
				payDet.put("ad_code",loanAdCode);
				payDetList.add(payDet);
				//issue
				tranIdForLoan = generateTranId( "w_loan_reco", paySite, claimDateStr, conn );
				System.out.println("tranIdGenerate for Loan Reco = "+tranIdForLoan);
				/*if(tranIdForLoan == null || tranIdForLoan.trim().length() == 0)
				{
					errString = itmDBAccess.getErrorString("","VTTRANID","","",conn);
					return errString;
				}*/
			
				sql = "insert into loan_reco (reco_no, reco_date, loan_no, scheme_no, emp_code,"
						+" start_date, loan_amt, loan_interest, mon_inst, ad_code,	reco_amt, chg_date, chg_user, chg_term, remarks, confirmed)"
						+"	values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,'Y') ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,tranIdForLoan);
				pstmt.setDate(2, claimDate ==null?null:new java.sql.Date(claimDate.getTime()));
				pstmt.setString(3, refNo);
				pstmt.setString(4, schemeNo);
				pstmt.setString(5, empCode);
				pstmt.setDate(6, startDate ==null?null: new java.sql.Date(startDate.getTime()));
				pstmt.setDouble(7,loanAmt);
				pstmt.setDouble(8,interest);
				pstmt.setDouble(9,monInst);
				pstmt.setString(10, loanAdCode);
				pstmt.setDouble(11,adjAmt);
				// Modified by Piyush on 03/06/2016 [To  update time in change date]
				// pstmt.setTimestamp(12, currDate);
				pstmt.setTimestamp(12, new java.sql.Timestamp(System.currentTimeMillis()));
				pstmt.setString(13, userId);
				pstmt.setString(14, chgTerm);
				pstmt.setString(15, "Through claim," + adCode + "," + claimDate.toString());
				noRowInst = pstmt.executeUpdate();
				System.out.println("no of row inserted loan_reco= "+noRowInst);
				pstmt.close();
				pstmt = null;

				// call function for direct loan recovery adjustment of installments
				//dw_loan_reco.reset()
				//dw_loan_reco.retrieve(ls_ref_no)
				//if gf_loan_reco(ls_recono, dw_loan_reco) = -1 then
				//421 ls_errcode  = nvo_loan_reco.gbf_loan_reco_retrieve ( ls_recono, ls_recono, 1 )
				errString = gbfLoanRecoRetrieve ( tranIdForLoan, tranIdForLoan, xtraParams,conn);
				System.out.println("errString 608="+errString);
				if(errString != null && errString.trim().length() > 0)
				{
					return errString;
				}
				/*if(errString != null && errString.trim().length() == 0)
				{
					errString = itmDBAccess.getErrorString("","VMDLOANRECO","","",conn);
					return errString;	
				}*/
			}//parse Detail3 end Loan  
				/*else issue
						if dw_loan_reco.update() <> 1 then
							ls_errcode = "DS000" + string(sqlca.sqldbcode) +'~t Error updating Loan_reco from employee : '+ls_emp
							exit
						end if
					end if*/
				if ("V".equalsIgnoreCase(payrollVoucher))
				{
					//ls_errcode = gf_payroll_voucher(s_payr_hdr, dw_payrv_det, 'dw_claim')
					errString = payrollVoucher(payHdr,payDetList, "dw_claim",xtraParams,conn);
					System.out.println("errString 625=="+errString);
					if(errString != null && errString.trim().length() > 0)
					{
						return errString;
					}
				}
				else
				{
					if(totalAdjAmt > 0)
					{
						sql = " select count(*) from employee_mthad where emp_code = ? and ad_code = ?	and eff_date = ? and exp_date = ? ";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, empCode);
						pstmt.setString(2, loanAdCode);
						pstmt.setTimestamp(3, frDate);
						pstmt.setTimestamp(4,toDate);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							count = rs.getInt(1);
						}
						rs.close();
						rs = null;
						pstmt.close();
						pstmt = null;
						if(count > 0)
						{
							sql = "update employee_mthad set type = 'F',amount =amount + ?,ref_type  = 'C', ref_no = ?, prop_yn = 'N' "
									+" where emp_code = ? and ad_code = ? and eff_date = ? and exp_date = ? ";
							pstmt = conn.prepareStatement(sql);
							pstmt.setDouble(1,totalAdjAmt);
							pstmt.setString(2,tranIdGenerate);
							pstmt.setString(3,empCode);
							pstmt.setString(4,loanAdCode);
							pstmt.setDate(5, frDate==null?null:new java.sql.Date(frDate.getTime()));
							pstmt.setDate(6, toDate==null?null:new java.sql.Date(toDate.getTime()));
							noRowInst = pstmt.executeUpdate();
							System.out.println("no of row update employee_mthad= "+noRowInst);
							pstmt.close();
							pstmt = null;
						}
						else
						{
							sql = "insert into employee_mthad(emp_code, month_code, ad_code, eff_date, exp_date, type, amount,"
									+" chg_date, chg_user, chg_term, ref_type, ref_no,prop_yn)"
									+" Values(?,?,?,?,?,'F',?,?,?,?,'C',?,'N')";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1,empCode);
							pstmt.setString(2,mounth);
							pstmt.setString(3,loanAdCode);
							pstmt.setDate(4, frDate==null?null:new java.sql.Date(frDate.getTime()));
							pstmt.setDate(5, toDate==null?null:new java.sql.Date(toDate.getTime()));
							pstmt.setDouble(6,totalAdjAmt);
							// Modified by Piyush on 03/06/2016 [To  update time in change date]
							// pstmt.setTimestamp(7, currDate);
							pstmt.setTimestamp(7, new java.sql.Timestamp(System.currentTimeMillis()));
							pstmt.setString(8,userId);
							pstmt.setString(9,chgTerm);
							pstmt.setString(10,tranIdGenerate);
							noRowInst = pstmt.executeUpdate();
							System.out.println("no of row insert employee_mthad= "+noRowInst);
							pstmt.close();
							pstmt = null;
						}
					}
				} //check cond. for payrollVoucher end

				/*//code for edi
					select edi_option into :ls_edi_option from transetup
					where tran_window = 'w_perk_claim';
					if get_sqlcode() <> 0 then //2
						ls_errcode = 'DS000' + string(sqlca.sqldbcode) + '~t Error creating perk claim '
						exit
					end if //2

					if ls_edi_option >'0' then //3

						lds_empadclaimhdr.dataobject = 'd_perk_claim_hdr_edit'
						lds_empadclaimhdr.settransobject(sqlca)
						lds_empadclaimhdr.reset()
						lds_empadclaim.dataobject = 'd_perk_claim_brow'
						lds_empadclaim.settransobject(sqlca)
						lds_empadclaim.reset()
						lds_empadclaimdet.dataobject = 'd_perk_claim_det_brow'
						lds_empadclaimdet.settransobject(sqlca)
						lds_empadclaimdet.reset()
						lds_empadclaimhdr.retrieve(ls_tranid)
						lds_empadclaim.retrieve(ls_tranid)
						lds_empadclaimdet.retrieve(ls_tranid)
						if ls_edi_option='2' then //4
							nvo_functions_adv.post nf_create_edi_multi("w_perk_claim", &
							lds_empadclaimhdr.describe("datawindow.syntax") &
							+ '~r' + lds_empadclaimhdr.describe("datawindow.syntax.data"), &
							'E', ls_edi_option, 3,lds_empadclaim.describe("datawindow.syntax") &
							+ '~r' + lds_empadclaim.describe("datawindow.syntax.data"),& 
							lds_empadclaimdet.describe("datawindow.syntax") &
							+ '~r' + lds_empadclaimdet.describe("datawindow.syntax.data"), '', '', '', '')

						else
							nvo_functions_adv.nf_create_edi_multi("w_perk_claim", &
							lds_empadclaimhdr.describe("datawindow.syntax") &
							+ '~r' + lds_empadclaimhdr.describe("datawindow.syntax.data"), &
							'E', ls_edi_option, 3,lds_empadclaim.describe("datawindow.syntax") &
							+ '~r' + lds_empadclaim.describe("datawindow.syntax.data"),& 
							lds_empadclaimdet.describe("datawindow.syntax") &
							+ '~r' + lds_empadclaimdet.describe("datawindow.syntax.data"), '', '', '', '')

						end if //4

					end if //3
					if len(trim(ls_errcode)) > 0 then
						exit
					end if
					//end code for edi
				 */				
			



			//}//parse  Detail2 end



		} //end of try 
		catch(Exception e)
		{
			try
			{

				System.out.println("Exception IN PerlClaimPos::::"+e.getMessage());
				e.printStackTrace();			
				throw new ITMException(e);
			}
			catch (Exception e1)
			{
				e1.printStackTrace();
				throw new ITMException(e1);
			}
		}
		finally
		{
			try
			{	
				if(errString != null && errString.trim().length() > 0)
				{
					if(errString.indexOf("CONFSUCCES") > -1)
					{
						conn.commit();
					}
					else
					{
						conn.rollback();
					}
				}

				if( rs != null )
				{
					rs.close();
					rs = null;
				}
				if( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				System.out.println("Exception "+e.getMessage());
				e.printStackTrace();
				throw new ITMException(e);
			}
		}
		return errString;
	}//postSave end 
	public String gbfLoanRecoRetrieve(String recoNoFrom,String recoNoTo,String xtraParams ,Connection conn) throws ITMException
	{
		String errString = "",sql = "" , userId = "";
		String loadMode = "A", editOption = "0";	
		String recNo = "";
		PreparedStatement pstmt = null,pstmtUpd = null;
		ResultSet rs = null;
		Timestamp currDate = null;
		GenericUtility genericUtility = null;
		try 
		{
			System.out.println("gbfLoanRecoRetrieve called........... ");
			currDate = new java.sql.Timestamp(System.currentTimeMillis());
			genericUtility = GenericUtility.getInstance();
			userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode");
			String loginEmpCode  = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginEmpCode");
			//sql = "select nvl(edi_option , '0') , nvl(load_mode , 'A')  from transetup where tran_window  = 'w_loan_reco' ";
			sql = "select edi_option ,load_mode  from transetup where tran_window  = 'w_loan_reco' ";
			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				editOption = rs.getString("edi_option") == null?"0":rs.getString("edi_option") ;
				loadMode = rs.getString("load_mode") == null?"A":rs.getString("load_mode") ;
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;

			sql = "select	reco_no from loan_reco where reco_no >= ?  and reco_no <= ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, recoNoFrom);
			pstmt.setString(2, recoNoTo);
			rs = pstmt.executeQuery();
			while(rs.next())
			{
				recNo = rs.getString("reco_no") == null?"":rs.getString("reco_no") ;

				sql = " update loan_reco set confirmed = 'Y', conf_date = ? ,emp_code__aprv = ? where reco_no = ? ";
				pstmtUpd = conn.prepareStatement(sql);
				pstmtUpd.setTimestamp(1, currDate);
				//pstmtUpd.setString(2,userId);
				pstmtUpd.setString(2,loginEmpCode);
				pstmtUpd.setString(3, recNo);
				pstmtUpd.executeUpdate();
				pstmtUpd.close();
				pstmtUpd = null;
				//63 ls_errcode = gbf_post_loan_reco(ls_recono , 1)
				errString = gbfPostLoanReco(recNo , xtraParams,conn);
				System.out.println("847 errString= "+errString);
				if(errString != null && errString.trim().length() > 0)
				{
					return errString;
				}

				if(editOption != null && editOption.trim().equalsIgnoreCase("0"))
				{

					/*String dataStr = "";
					if ( "1".equals(editOption.trim()) )
					{
						CreateRCPXML createRCPXML = new CreateRCPXML("w_loan_reco","reco_no");
						dataStr = createRCPXML.getTranXML( recNo, conn );
						System.out.println( "dataStr =[ "+ dataStr + "]" );
						Document ediDataDom = genericUtility.parseString(dataStr);
						E12CreateBatchLoadEjb e12CreateBatchLoad = new E12CreateBatchLoadEjb();
						String retString = e12CreateBatchLoad.createBatchLoad(ediDataDom, "w_loan_reco", "0", xtraParams, conn );
						createRCPXML = null;
						e12CreateBatchLoad = null;
						if( retString != null && "SUCCESS".equals(retString) )
						{
							System.out.println("retString from batchload = 	["+retString+"]");
						}
					}*/

				}

			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;

		} catch (SQLException e) 
		{
			System.out.println("Exception :PerkClaimPos :gbfLoanRecoRetrieve :SQLException :==>\n"+e.getMessage());
			e.printStackTrace();
			throw new ITMException(e);
		}catch (Exception e) 
		{
			System.out.println("Exception :PerkClaimPos :gbfLoanRecoRetrieve :Exception :==>\n"+e.getMessage());
			e.printStackTrace();
			throw new ITMException(e);
		}
		return errString;
	}//gbfLoanRecoRetrieve end

	public String payrollVoucher(HashMap payHdr,ArrayList payDetList,String detWinName ,String xtraParams, Connection conn) throws ITMException
	{
		//// Function to insert Payroll Vouchers into payr_voucher and
		//// payr_vouchdet tables.

		String errString = "",sql = "" , userId = "",tranId = "",tranDateStr = "",chgTerm = "";
		String autopost = "",bankCode = "",suppCodeCon = "",keyType = "",winName = "", errCode = "" , keyString = "";
		String siteCodeAcct = "" , hdrBankCode = "",vouchType = "",empCode = "",withHeld = "", hold = "" ;
		String acctCode = "", cctrCode = "", crTerm = "",finEntity = "";
		String currCode = "",autoPay = "",batchNo = "",remarks = "",tranType = "",analCode = "",confiremed = "",paid = "";
		String acctCodePay = "", cctrCodePay = "",payMode = "",refNo = "",acctCodeSal = "", cctrCodeSal = "",acctCodeSal1 = "", cctrCodeSal1 = "";
		String adCode = "",balOpt = "",payable = "",refType = "";
		double totalAmtbc = 0,totalAmt = 0,exchRate = 0,amount = 0,miscTotAmt = 0;
		int count = 0;
		Date tranDate = null,relieveDate = null , effDate = null,refDate = null,chgDate = null;
		PreparedStatement pstmt = null,pstmtUpd = null;
		ResultSet rs = null;
		Timestamp currDate = null;
		HashMap payDet = null;
		GenericUtility genericUtility = null;
		AdmCommon admCommon = null;
		FinCommon finCommon = null;
		ITMDBAccessEJB itmDBAccess = new ITMDBAccessEJB();	
		PayrollVoucherConf payrollVoucherConf = new PayrollVoucherConf();
		try 
		{
			System.out.println("payrollVoucher called........... ");
			admCommon = new AdmCommon();
			finCommon = new FinCommon();
			currDate = new java.sql.Timestamp(System.currentTimeMillis());
			genericUtility = GenericUtility.getInstance();
			userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode");
			chgTerm = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "chgTerm" );
			SimpleDateFormat sdfAppl = new SimpleDateFormat(genericUtility.getApplDateFormat());
			System.out.println("pay header ===="+payHdr.toString());
			System.out.println("payDetList ===="+payDetList.toString());
			tranDate = (Date)payHdr.get("tran_date");
			totalAmt = (Double)payHdr.get("tot_amt");
			exchRate = (Double)payHdr.get("exch_rate");
			empCode = (String)payHdr.get("emp_code");
			effDate = (Date)payHdr.get("eff_date");
			finEntity = (String)payHdr.get("fin_entity");
			vouchType = (String)payHdr.get("vouch_type");
			currCode = (String)payHdr.get("curr_code");
			autoPay = (String)payHdr.get("auto_pay");
			remarks = (String)payHdr.get("remarks");
			batchNo = (String)payHdr.get("batch_no");
			tranType = (String)payHdr.get("tran_type");
			analCode = (String)payHdr.get("anal_code");
			paid = (String)payHdr.get("paid");
			confiremed = (String)payHdr.get("confirmed");
			acctCodePay = (String)payHdr.get("acct_code__pay");
			cctrCodePay = (String)payHdr.get("cctr_code__pay");
			payMode = (String)payHdr.get("pay_mode");
			refNo = (String)payHdr.get("ref_no");
			refDate = (Date)payHdr.get("ref_date");
			chgDate = (Date)payHdr.get("chg_date");
			tranDateStr = sdfAppl.format(tranDate);

			
			sql = "select ddf_hr_site_env_value(?,sysdate,'AUTO_POST') as autopost from dual";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, empCode);
			rs = pstmt.executeQuery();
			if(rs.next()) {
				autopost = checkNull(rs.getString("autopost"));
			} else {
				autopost = "NULLFOUND";
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
			
			//autopost = checkNull(admCommon.getEnv("999999","AUTO_POST",conn));
			System.out.println("Value for prd_code [999999] var_name[AUTO_POST] value["+ autopost +"] in payrparm");
			if("NULLFOUND".equalsIgnoreCase(autopost))
			{
				errString = itmDBAccess.getErrorString("","VSENVAR1","","",conn);
				return errString;
			}
			bankCode = checkNull(admCommon.getEnv("999999","BANKCODE",conn));
			System.out.println("Value for prd_code [999999] var_name[BANKCODE] value["+ bankCode +"] in payrparm");
			if("NULLFOUND".equalsIgnoreCase(bankCode))
			{
				errString = itmDBAccess.getErrorString("","VSENVAR1","","",conn);
				return errString;
			}

			sql = "select supp_code__con  from employee where emp_code = ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, empCode);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				suppCodeCon = rs.getString("supp_code__con")  ;
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
			if(suppCodeCon != null && suppCodeCon.trim().length() > 0)
			{
				keyType = "M-VOUC";
				winName = "w_misc_voucher";
			}
			else
			{
				keyType = "P-VOUC";
				winName = "w_payr_voucher";
			}

			//do
			//{

			/*sql = "select key_string  from transetup 	where tran_window = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,winName);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				keyString = rs.getString("key_string")  ;
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;*/

			sql = "select site_code__acct  from site where site_code = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,(String)payHdr.get("site_code"));
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				siteCodeAcct = rs.getString("site_code__acct")  ;
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
			hdrBankCode = (String)payHdr.get("bank_code");
			if(hdrBankCode == null || hdrBankCode.trim().length() == 0)
			{
				hdrBankCode = bankCode;
			}

			if(vouchType == null || vouchType.trim().length() == 0)
			{
				vouchType = "O";
			}

			tranId = generateTranId(winName, siteCodeAcct, tranDateStr, conn);
			System.out.println("1026 tranId ="+tranId);
			/*if(tranId == null || tranId.trim().length() == 0)
			{
				errString = itmDBAccess.getErrorString("","VTTRANID","","",conn);
				return errString;
			}
			if("ERROR".equalsIgnoreCase(tranId))
			{
				errString = itmDBAccess.getErrorString("","VTTRANID","","",conn);
				return errString;
			}*/
			totalAmtbc = totalAmt*exchRate;

			errCode = nfCheckPeriod("ADM",tranDate,(String)payHdr.get("site_code"));
			if(errCode == null || errCode.trim().length() == 0)
			{
				errCode = nfCheckPeriod("FIN",tranDate,(String)payHdr.get("site_code"));
				if(errCode != null && errCode.trim().length() > 0)
				{
					errString = itmDBAccess.getErrorString("",errCode,"","",conn);
					return errString;
				}

			}
			else
			{
				errString = itmDBAccess.getErrorString("",errCode,"","",conn);
				return errString;
			}
			sql = "	select relieve_date , with_held from employee 	where emp_code = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,empCode);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				withHeld = rs.getString("with_held")  ;
				relieveDate = rs.getDate("relieve_date");
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;	
			hold = "N"; // Modified by Piyush on 28/06/2016[To set hold default value]
			if(relieveDate != null || "Y".equalsIgnoreCase(withHeld))
			{
				hold = admCommon.getEnv("999999","HOLD_FLAG",conn);
				if("NULLFOUND".equalsIgnoreCase(hold))
				{
					errString = itmDBAccess.getErrorString("","VSENVAR1","","",conn);
					return errString;
				}
			}
			if(suppCodeCon != null && suppCodeCon.trim().length() > 0)
			{
				sql = "	select acct_code__ap, cctr_code__ap, cr_term from supplier where supp_code = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,suppCodeCon);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					acctCode = rs.getString("acct_code__ap");
					cctrCode = rs.getString("cctr_code__ap");
					crTerm = rs.getString("cr_term");
				}
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;	
				String rndOff ="";
				int rndTo ;
				rndOff = finCommon.getFinparams("999999", "PAY_RND_OFF", conn);
				if("NULLFOUND".equalsIgnoreCase(rndOff))
				{
					rndTo = 1;
				}
				else
				{
					rndOff = "N";
					rndTo = 0;
				}
				sql = " insert into misc_voucher (tran_id, tran_date, tran_type, eff_date, vouch_type,"
						+" sundry_type, sundry_code, acct_code__ap, cctr_code__ap, site_code, fin_entity, due_date,"
						+" curr_code, cr_term, auto_pay, bank_code, entry_batch_no,confirmed, chg_date, chg_user, chg_term,"
						+" exch_rate, net_amt, net_amt__bc, tot_amt, rnd_off, rnd_to, sundry_type__pay, sundry_code__pay,"
						+" remarks, acct_code__pay, cctr_code__pay, pay_mode, adv_amt, bill_amt, tax_amt,tran_mode ) "
						+" Values (?,?, 'PAY',?,?, 'S', ?,?,?,?, ?,?,"
						+" ?, ?, ?, ?, ?,'N',?, ?,?,?," 
						+" ?,?,?,?, ? , 'S', ?, ?, ?, ?, 'Q',0, ?, 0,'A')";
				pstmtUpd = conn.prepareStatement(sql);
				pstmtUpd.setString(1,tranId);
				pstmtUpd.setDate(2,tranDate == null?null:new java.sql.Date(tranDate.getTime()) );
				pstmtUpd.setDate(3,effDate == null?null:new java.sql.Date(effDate.getTime()));
				pstmtUpd.setString(4,vouchType);
				pstmtUpd.setString(5,suppCodeCon);
				pstmtUpd.setString(6,acctCode);
				pstmtUpd.setString(7,cctrCode);
				pstmtUpd.setString(8,siteCodeAcct);
				pstmtUpd.setString(9,finEntity);
				pstmtUpd.setDate(10,tranDate == null?null:new java.sql.Date(tranDate.getTime()));
				pstmtUpd.setString(11,currCode);
				pstmtUpd.setString(12,crTerm);
				pstmtUpd.setString(13,autoPay);
				pstmtUpd.setString(14,hdrBankCode);
				pstmtUpd.setString(14,batchNo);
				// Modified by Piyush on 03/06/2016 [To  update time in change date]
				// pstmtUpd.setTimestamp(15,currDate);
				pstmtUpd.setTimestamp(15, new java.sql.Timestamp(System.currentTimeMillis()));
				pstmtUpd.setString(16,userId);
				pstmtUpd.setString(17,chgTerm);
				pstmtUpd.setDouble(18, exchRate);
				pstmtUpd.setDouble(19, totalAmt);
				pstmtUpd.setDouble(20, totalAmtbc);
				pstmtUpd.setDouble(21, totalAmt);
				pstmtUpd.setString(22,rndOff);
				pstmtUpd.setInt(23,rndTo);
				pstmtUpd.setString(24,suppCodeCon);
				pstmtUpd.setString(25,remarks);
				pstmtUpd.setString(26,acctCode);
				pstmtUpd.setString(27,cctrCode);
				pstmtUpd.setDouble(28, totalAmt);
				int i = pstmtUpd.executeUpdate();
				System.out.println("row insert into misc_voucher "+i);
				pstmtUpd.close();
				pstmtUpd = null;

			}
			else
			{
				sql = " insert into payr_voucher (tran_id, tran_date, tran_type, eff_date, emp_code, ref_no,"
						+" ref_date, bank_code, auto_pay, chg_date, chg_user, chg_term,site_code, fin_entity,"
						+" anal_code, confirmed, paid, acct_code__pay, cctr_code__pay, tot_amt, pay_mode, "
						+" entry_batch_no, vouch_type, curr_code, tot_amt__bc, remarks, exch_rate ,hold) "
						+" values (?,?,?,?,?,?,?,?,?,  ?,?, ?, ?," 
						+" ?,?,?,?,?,?, ?, ?, ?," 
						+" ?,?,?,?, ?,?)";
				pstmtUpd = conn.prepareStatement(sql);
				pstmtUpd.setString(1,tranId);
				pstmtUpd.setDate(2,tranDate == null?null:new java.sql.Date(tranDate.getTime()) );
				pstmtUpd.setString(3,tranType);
				pstmtUpd.setDate(4,effDate == null?null:new java.sql.Date(effDate.getTime()));
				pstmtUpd.setString(5,empCode);
				pstmtUpd.setString(6,refNo);
				pstmtUpd.setDate(7,refDate == null?null:new java.sql.Date(refDate.getTime()));
				pstmtUpd.setString(8,hdrBankCode);
				pstmtUpd.setString(9,autoPay);

				// Modified by Piyush on 02/06/2016 [To update chg_date with time]
				// pstmtUpd.setDate(10,chgDate == null?null:new java.sql.Date(chgDate.getTime()));
				pstmtUpd.setTimestamp(10, new java.sql.Timestamp(System.currentTimeMillis()));
				
				pstmtUpd.setString(11,(String)payHdr.get("chg_user"));
				pstmtUpd.setString(12,(String)payHdr.get("chg_term"));
				pstmtUpd.setString(13,siteCodeAcct);
				pstmtUpd.setString(14,finEntity);
				pstmtUpd.setString(15,analCode);
				pstmtUpd.setString(16,confiremed);
				pstmtUpd.setString(17,paid);
				pstmtUpd.setString(18,acctCodePay);
				pstmtUpd.setString(19,cctrCodePay);
				pstmtUpd.setDouble(20, totalAmt);
				pstmtUpd.setString(21,payMode);
				pstmtUpd.setString(22,batchNo);
				pstmtUpd.setString(23,vouchType);
				pstmtUpd.setString(24,currCode);
				pstmtUpd.setDouble(25,totalAmtbc);
				pstmtUpd.setString(26,remarks);
				pstmtUpd.setDouble(27,exchRate);
				pstmtUpd.setString(28,hold);
				int i = pstmtUpd.executeUpdate();
				System.out.println("row insert into payr_voucher "+i);
				pstmtUpd.close();
				pstmtUpd = null;
			}
			//get data from  detail window start 
			for (int ctr =0; ctr < payDetList.size(); ctr++)
			{
				payDet = new HashMap();
				payDet = (HashMap) payDetList.get(ctr);
				System.out.println("Pay Detail=="+payDet.toString());

				adCode = (String)payDet.get("ad_code");
				amount = (Double)payDet.get("amount");
				System.out.println("Amount Value [" + amount + "]");
				if(amount == 0) {
					System.out.println("Amount Value is ZERO, loading next Value...");
					continue;
				}
				
				sql = "	select payable, acct_code__sal, cctr_code__sal, bal_opt from allwdedn where ad_code = ?  ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,adCode);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					payable = rs.getString("payable");
					acctCodeSal = rs.getString("acct_code__sal");
					cctrCodeSal = rs.getString("cctr_code__sal");
					balOpt = rs.getString("bal_opt");
				}
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;
				if(balOpt == null)
				{
					balOpt = " ";
				}
				
				System.out.println("acctCodeSal.. acct_code__sal...["+acctCodeSal+"]");

				sql = "	select acct_code__sal, cctr_code__sal from employee where emp_code = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,empCode);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					acctCodeSal1 = rs.getString("acct_code__sal");
					cctrCodeSal1 = rs.getString("cctr_code__sal");
				}
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;
				
				System.out.println("acctCodeSal1.. acct_code__sal...["+acctCodeSal1+"]");
				
				if(acctCodeSal1 != null && acctCodeSal1.trim().length() > 0)
				{
					System.out.println("Inside acct_code__sal...["+acctCodeSal1+"]");
					acctCodeSal = acctCodeSal1;
				}
				if(cctrCodeSal1 != null && cctrCodeSal1.trim().length() > 0)
				{
					cctrCodeSal = cctrCodeSal1;
				}
				System.out.println("acctCodeSalpopa..["+acctCodeSal+"]");
				String cctrCodeExp = (String)payHdr.get("cctr_code__exp");
				if (cctrCodeExp != null && cctrCodeExp.length() > 0)
				{
					cctrCodeSal = cctrCodeExp;
				}
				System.out.println("cctrCodeSalpopa..["+cctrCodeSal+"]");
				//issue
				if("dw_payrolldet".equalsIgnoreCase(detWinName))
				{
					//not migrated 
				}
				else if("dw_fullfinal_det_vouch".equalsIgnoreCase(detWinName))
				{
					//not migrated
				}
				else if("dw_sales_comm".equalsIgnoreCase(detWinName))
				{
					//not migrated
				}
				if(adCode != null && adCode.trim().length() > 0)//396
				{
					if(suppCodeCon != null && suppCodeCon.trim().length() > 0 )
					{
						sql = "	select count(1) from misc_vouchdet where tran_id = ? and acct_code = ? 	and cctr_code = ? ";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1,tranId);
						pstmt.setString(2,acctCodeSal);
						pstmt.setString(3,cctrCodeSal);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							count = rs.getInt(1);
						}
						rs.close();
						rs = null;
						pstmt.close();
						pstmt = null;
						if(count > 0)
						{
							double amount1 = 0;
							sql = "	select (case when amount is null then 0 else amount end ) as amount  from misc_vouchdet "
									+" where tran_id = ?  	and acct_code = ? and cctr_code = ? ";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1,tranId);
							pstmt.setString(2,acctCodeSal);
							pstmt.setString(3,cctrCodeSal);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								amount1 = rs.getDouble("amount");
							}
							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;

							sql = " update misc_vouchdet set amount = ? + ? where tran_id = ? 	and acct_code = ? and cctr_code = ? ";
							pstmtUpd = conn.prepareStatement(sql);
							pstmtUpd.setDouble(1, amount1);
							pstmtUpd.setDouble(2, amount);
							pstmtUpd.setString(3,tranId);
							pstmtUpd.setString(4,acctCodeSal);
							pstmtUpd.setString(5,cctrCodeSal);
							int i = pstmtUpd.executeUpdate();
							System.out.println("row update into misc_vouchdet "+i);
							pstmtUpd.close();
							pstmtUpd = null;

						}
						else
						{
							sql = " insert into misc_vouchdet ( tran_id, line_no, acct_code, cctr_code, amount, apply_tax) "
									+" values ( ? , ?, ?, ?,? , 'Y'  )";
							pstmtUpd = conn.prepareStatement(sql);
							pstmtUpd.setString(1,tranId);
							pstmtUpd.setInt(2,(ctr)+1);
							pstmtUpd.setString(3,acctCodeSal);
							pstmtUpd.setString(4,cctrCodeSal);
							pstmtUpd.setDouble(5, amount);
							int i = pstmtUpd.executeUpdate();
							System.out.println("row update into misc_vouchdet "+i);
							pstmtUpd.close();
							pstmtUpd = null;
						}
						miscTotAmt = miscTotAmt + amount ;
					}
					else
					{
						sql = " insert into payr_vouchdet ( tran_id, line_no, acct_code, cctr_code, amount, ad_code ) "
								+" values (? , ? ,?,?  , ?,? ) ";
						pstmtUpd = conn.prepareStatement(sql);
						pstmtUpd.setString(1,tranId);
						// Modified by Piyush on 02/06/2016 [To set line no with space on right side].Start
						// pstmtUpd.setInt(2,(ctr)+1);
						String lineNoStr = "";
						lineNoStr = "   " + ((ctr)+1);
						lineNoStr = lineNoStr.substring(lineNoStr.length() - 3);
						pstmtUpd.setString(2,lineNoStr);
						// Modified by Piyush on 02/06/2016 [To set line no with space on right side].End
						pstmtUpd.setString(3,acctCodeSal);
						pstmtUpd.setString(4,cctrCodeSal);
						pstmtUpd.setDouble(5, amount);
						pstmtUpd.setString(6,adCode);
						int i = pstmtUpd.executeUpdate();
						System.out.println("row update into misc_vouchdet "+i);
						pstmtUpd.close();
						pstmtUpd = null;
					}
				}
				// check for non-zero amount 453
				if(amount != 0)
				{
					if("C".equalsIgnoreCase(balOpt.trim()) || "A".equalsIgnoreCase(balOpt.trim()))
					{
						if("dw_fullfinal_det_vouch".equalsIgnoreCase(detWinName))
						{
							//not migrated
						}
						else if("dw_payrolldet".equalsIgnoreCase(detWinName))
						{
							//not migrated
						}
						else
						{
							refNo = "";
							refType = "";
						}

						if("L".equalsIgnoreCase(refType) && "dw_payrolldet".equalsIgnoreCase(detWinName))
						{
							//not migrated
						}
						/*sql = "	select count(*)  from allowdedn_bal where emp_code = ? and &  ad_code = ? and   ? >= start_date and ? <= end_date  ";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1,empCode);
						pstmt.setString(2,adCode);
						pstmt.setDate(3,tranDate == null?null:new java.sql.Date(tranDate.getTime())); //issue
						pstmt.setDate(4,tranDate == null?null:new java.sql.Date(tranDate.getTime())); //issue
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							count = rs.getInt(1);
						}
						rs.close();
						rs = null;
						pstmt.close();
						pstmt = null;*/ // not required for dw_claim window 

						if(!"dw_claim".equalsIgnoreCase(detWinName))
						{
							//not migrated
						}
					}
				}
			}
			//get data from  detail window end
			if("dw_payrolldet".equalsIgnoreCase(detWinName))
			{
				//not migrated
			}
			else if("dw_payrolldet".equalsIgnoreCase(detWinName))
			{
				//not migrated
			}
			if("Y".equalsIgnoreCase(autopost))
			{
				if(suppCodeCon != null && suppCodeCon.trim().length() > 0)
				{
					//ls_errcode = nvo_misc_voucher.gbf_retrieve_misc_vou(ls_tranid, ls_tranid, 1, ls_warning) 710
					//errString = gbfRetrieveMiscVou("","","","","",conn);
					//MiscValConf miscConf = new MiscValConf();
					//errString = miscConf.gbfRetriveMiscVouch(tranId,xtraParams,conn);//issue
					if(errString != null && errString.trim().length() > 0)
					{
						return errString;
					}
					else
					{
						sql = "	select case when confirmed is null then 'N' else confirmed end as confirmed from misc_voucher where tran_id =  ?  ";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1,tranId);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							confiremed = rs.getString("confirmed");
						}
						rs.close();
						rs = null;
						pstmt.close();
						pstmt = null;
						if(!"Y".equalsIgnoreCase(confiremed))
						{
							errString = itmDBAccess.getErrorString("","PAYVCHCNF1","","",conn);
							return errString;
						}
					}
				}
				else
				{
					//ls_errcode = nvo_payr_voucher.gbf_retrieve_payr_vou(ls_tranid, ls_tranid, 1, &
					//       header_data.tran_type, header_data.tran_type, header_data.batch_no)
					//errString = gbfRetrievePayrVoucher(tranId,tranType,tranType,batchNo,siteCodeAcct,xtraParams,conn);
					errString = payrollVoucherConf.confirm(tranId,"N",xtraParams,conn);
					if(errString != null && errString.trim().length() > 0 && errString.indexOf("VTMCONF2") == -1)
					{
						return errString;
					}
					else 
					{
						sql = "	select case when confirmed is null then 'N' else confirmed end as confirmed  from payr_voucher where tran_id = ? ";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1,tranId);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							confiremed = rs.getString("confirmed");
						}
						rs.close();
						rs = null;
						pstmt.close();
						pstmt = null;
						if(!"Y".equalsIgnoreCase(confiremed))
						{
							errString = itmDBAccess.getErrorString("","PAYVCHCNF1","","",conn);
							return errString;
						}
					}
				}
			}

			//}while(errCode == null || errCode.trim().length() == 0);


		} catch (SQLException e) 
		{
			System.out.println("Exception :PerkClaimPos :payrollVoucher :SQLException :==>\n"+e.getMessage());
			e.printStackTrace();
			throw new ITMException(e);
		}catch (Exception e) 
		{
			System.out.println("Exception :PerkClaimPos :payrollVoucher :Exception :==>\n"+e.getMessage());
			e.printStackTrace();
			throw new ITMException(e);
		}
		return errString;
	}//payrollVoucher end

	private String gbfPostLoanReco(String recoNo,String xtraParams ,Connection conn) throws ITMException
	{
		String errString = "",sql = "" , userId = "", chgTerm = "";
		String empCode = "", loanNo = "", adCode = "", confirmed = "" ,transer ="" , refNo = "";
		String sundryType = "",sundryCode = "", status = "";
		double  recoAmt = 0,balanceAmt = 0;
		Date recoDate = null, startDate = null,  confDate = null ,refDate = null; 
		PreparedStatement pstmt = null,pstmtUpd = null;
		ResultSet rs = null;
		Timestamp currDate = null;
		GenericUtility genericUtility = null;
		try 
		{
			System.out.println("gbfPostLoanReco called........... ");
			ITMDBAccessEJB itmDBAccess = new ITMDBAccessEJB();
			currDate = new java.sql.Timestamp(System.currentTimeMillis());
			genericUtility = GenericUtility.getInstance();
			userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode");
			chgTerm = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "chgTerm" );
			sql = " select emp_code, loan_no, ad_code, reco_date, start_date, confirmed , conf_date ," 
					+" tran_ser__pay, ref_no__pay, reco_amt from loan_reco where reco_no = ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, recoNo);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				empCode = checkNull(rs.getString("emp_code"));
				loanNo = checkNull(rs.getString("loan_no"));
				adCode = checkNull(rs.getString("ad_code"));
				recoDate = rs.getDate("reco_date");
				startDate = rs.getDate("start_date");
				confDate = rs.getDate("conf_date");
				confirmed = rs.getString("confirmed");
				transer = rs.getString("tran_ser__pay");
				refNo = rs.getString("ref_no__pay");
				recoAmt = rs.getDouble("reco_amt");

			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;

			if((transer != null && transer.trim().length() > 0) && (refNo != null && refNo.trim().length() > 0))
			{
				sql = " select sundry_type, sundry_code, tot_amt - adj_amt , ref_date "
						+" from misc_payables where tran_ser = ?  and ref_no = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, transer);
				pstmt.setString(2, refNo);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					sundryType = checkNull(rs.getString("sundry_type"));
					sundryCode = checkNull(rs.getString("sundry_code"));
					balanceAmt = rs.getDouble(3);
					refDate = rs.getDate("ref_date");
				}
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;

				if(!"E".equalsIgnoreCase(sundryType) && ! sundryCode.trim().equalsIgnoreCase(empCode.trim()))
				{
					//errString = "VTPAYSUNTY";
					errString = itmDBAccess.getErrorString("","VTPAYSUNTY","","",conn);
					return errString;
				}
				else if(recoAmt > balanceAmt)
				{
					//errString = "VTPAYBAL";
					errString = itmDBAccess.getErrorString("","VTPAYBAL","","",conn);
					return errString;
				}
				else
				{
					if(recoAmt == balanceAmt)
					{
						status = "A";
					}
					else
					{
						status = "P";
					}
					sql = " update misc_payables set adj_amt = adj_amt + ?, status = ? , status_date = ? "
							+" where tran_ser = ? and ref_no = ?";
					pstmtUpd = conn.prepareStatement(sql);
					pstmtUpd.setDouble(1,recoAmt);
					pstmtUpd.setString(2,status);
					pstmtUpd.setDate(3, new java.sql.Date(confDate.getTime()));
					pstmtUpd.setString(4,transer);
					pstmtUpd.setString(5,refNo);
					System.out.println("NO ROW UPDATE:"+pstmtUpd.executeUpdate());
					pstmtUpd.close();
					pstmtUpd = null;
				}
			}

			sql = " select amt_bal  from allowdedn_bal where ref_type = 'L' and ref_no = ? ";

			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,loanNo);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				balanceAmt = rs.getDouble("amt_bal");
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;

			System.out.println(""+balanceAmt+"::"+recoAmt);
			if(balanceAmt < recoAmt)
			{
				System.out.println("balanceAmt < recoAmt:::::::");
				errString = itmDBAccess.getErrorString("","VPNOBAL1","","",conn);
				return errString;
				
			}
			else
			{//101
				sql = " update allowdedn_bal    set amt_adj = amt_adj + ?, amt_bal = amt_bal - ? "
						+"	 where ref_type = 'L' and        ref_no = :ls_loanno";
				pstmtUpd = conn.prepareStatement(sql);
				pstmtUpd.setDouble(1,recoAmt);
				pstmtUpd.setDouble(2,recoAmt);
				pstmtUpd.setString(3,loanNo);
				System.out.println("NO ROW UPDATE:"+pstmtUpd.executeUpdate());
				pstmtUpd.close();
				pstmtUpd = null;
			}

			double balanceAmt1 = 0.0;

			sql = " select balance_amt 	from loans 	where loan_no = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,loanNo);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				balanceAmt1 = rs.getDouble("balance_amt");
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
			balanceAmt1 = balanceAmt1 -  recoAmt ;
			System.out.println("balanceAmt1="+balanceAmt1);
			if(balanceAmt1 < 0)
			{
				errString = itmDBAccess.getErrorString("","VPNOBAL1","","",conn);
				return errString;
				
			}
			if(balanceAmt1 > 0)
			{
				sql = " update loans  set balance_amt = balance_amt - ?, date__balance = ?  where loan_no = ? ";
				pstmtUpd = conn.prepareStatement(sql);
				pstmtUpd.setDouble(1,recoAmt);
				pstmtUpd.setDate(2,recoDate == null?null:new java.sql.Date(recoDate.getTime()) );
				pstmtUpd.setString(3,loanNo);
				System.out.println("NO ROW UPDATE:"+pstmtUpd.executeUpdate());
				pstmtUpd.close();
				pstmtUpd = null;
			}
			else
			{
				sql = " update loans set balance_amt = balance_amt - ?, date__balance = ?, status = 'E' "
						+"  where loan_no = ? ";
				pstmtUpd = conn.prepareStatement(sql);
				pstmtUpd.setDouble(1,recoAmt);
				pstmtUpd.setDate(2,recoDate == null?null:new java.sql.Date(recoDate.getTime()) );
				pstmtUpd.setString(3,loanNo);
				System.out.println("NO ROW UPDATE:"+pstmtUpd.executeUpdate());
				pstmtUpd.close();
				pstmtUpd = null;
			}
			if(refDate == null)
			{
				refDate = recoDate;
			}

			sql = " insert into loan_reg( loan_no ,tran_no,tran_date,tran_type,amount ,int_calculated,chg_date,chg_user,chg_term ) " 
					+" values(? , ? ,? , 'R' ,? , 'N' ,? ,?,?) ";
			pstmtUpd = conn.prepareStatement(sql);
			pstmtUpd.setString(1,loanNo);
			pstmtUpd.setString(2,recoNo);
			pstmtUpd.setDate(3,recoDate == null?null:new java.sql.Date(recoDate.getTime()) );
			pstmtUpd.setDouble(4,recoAmt);
			// Modified by Piyush on 03/06/2016 [To  update time in change date]
			// pstmtUpd.setTimestamp(5,currDate);
			pstmtUpd.setTimestamp(5,new java.sql.Timestamp(System.currentTimeMillis()));
			pstmtUpd.setString(6,userId);
			pstmtUpd.setString(7,chgTerm);
			System.out.println("NO ROW UPDATE:"+pstmtUpd.executeUpdate());
			pstmtUpd.close();
			pstmtUpd = null;



		} catch (SQLException e) 
		{
			System.out.println("Exception :PerkClaimPos :gbfPostLoanReco :SQLException :==>\n"+e.getMessage());
			e.printStackTrace();
			throw new ITMException(e);
		}catch (Exception e) 
		{
			System.out.println("Exception :PerkClaimPos :gbfPostLoanReco :Exception :==>\n"+e.getMessage());
			e.printStackTrace();
			throw new ITMException(e);
		}
		return errString;
	}//gbfPostLoanReco end

	private String gbfRetrievePayrVoucher(String tranId,String tranTypeFr,String tranTypeTo,String batchNo,String siteCode,String xtraParams ,Connection conn) throws ITMException
	{
		String errString = "",sql = "" ;
		String tranType = "",rights = "",ledgPostConf = "";
		int count = 0 ;
		double totalAmt = 0; 
		Date tranDate = null,today = new java.util.Date();
		HashMap payVouchHdr = null;
		HashMap payVouchDet = null;
		HashMap payVouchAdv = null;
		ArrayList payVouchDetList = new ArrayList();
		ArrayList payVouchAdvList = new ArrayList();
		PreparedStatement pstmt = null,pstmtUpd = null;
		ResultSet rs = null;
		//Timestamp currDate = null;
		//GenericUtility genericUtility = null;
		try 
		{
			System.out.println("gbfRetrievePayrVoucher called........... ");
			//currDate = new java.sql.Timestamp(System.currentTimeMillis());
			ITMDBAccessEJB itmDBAccess = new ITMDBAccessEJB();
			GenericUtility genericUtility = GenericUtility.getInstance();
			//userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode");
			//chgTerm = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "chgTerm" );

			/*sql = "  SELECT tran_id    FROM payr_voucher  WHERE tran_id 	= ?  AND site_code = ? AND "
					+" tran_type >= ? and 	tran_type <= ? and  entry_batch_no = ? and  confirmed = 'N'  ";
			pstmtHdr = conn.prepareStatement(sql);
			pstmtHdr.setString(1, tranId);
			pstmtHdr.setString(2,siteCode);
			pstmtHdr.setString(3, tranTypeFr);
			pstmtHdr.setString(4, tranTypeTo);
			pstmtHdr.setString(5, batchNo);
			rsHdr = pstmtHdr.executeQuery();
			if(rsHdr.next())
			{
				tranId = checkNull(rsHdr.getString("tran_id"));
			}
			rsHdr.close();
			rsHdr = null;
			pstmtHdr.close();
			pstmtHdr = null;*/


			if ("db2".equalsIgnoreCase(CommonConstants.DB_NAME ))
			{
				sql = "select tran_id, tran_type, tot_amt 	from payr_voucher 	where tran_id = ? for update ";
			}

			else if ( "mssql".equalsIgnoreCase(CommonConstants.DB_NAME ))
			{
				sql = " select tran_id, tran_type, tot_amt 	from payr_voucher (updlock) where tran_id =  ?   " ;
			}
			else
			{
				sql =" select tran_id, tran_type, tot_amt from payr_voucher where tran_id = ? for update nowait " ;
			}
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, tranId);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				tranId = checkNull(rs.getString("tran_id"));
				tranType = checkNull(rs.getString("tran_type"));
				totalAmt = rs.getDouble("tot_amt");
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;

			if(!"PAY".equalsIgnoreCase(tranType.trim()) && !"ARR".equalsIgnoreCase(tranType.trim()) && !"LN".equalsIgnoreCase(tranType.trim()) && !"LEN".equalsIgnoreCase(tranType.trim()) && !"FFS".equalsIgnoreCase(tranType.trim()) && !"INC".equalsIgnoreCase(tranType.trim()))
			{
				if(totalAmt == 0)
				{
					sql = "select count(*)   from payr_vouchdet  where tran_id = ? 	and amount <> 0";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, tranId);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						count = rs.getInt(1);
					}
					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null;
					if(count == 0)
					{
						errString = itmDBAccess.getErrorString("","VTVOUAMT","","",conn);
						return errString;
					}
				}
				else if(totalAmt < 0)//isuue 
				{
					/*if pos(is_rights,'*') = 0 and pos(is_rights,'N') = 0 then 
							populateerror(9999,'populateerror')
							ls_errcode = "VTVOUAMT"
							ls_errcode = gf_error_location(ls_errcode)
							continue
						end if*/
				}
			}


			// Modified by Piyush on 01/06/2016 [To update amount in header].Start
			double hdrExchRate = 0d;
			double totDetAmt = 0d;
			double totAmtBc = 0d;
			// Modified by Piyush on 01/06/2016 [To update amount in header].End

			sql = "   SELECT tran_id,tran_date,tran_type,eff_date,emp_code,ref_no,ref_date,bank_code,"
					+"auto_pay,chg_date,chg_user,chg_term,site_code,fin_entity,tot_amt,anal_code,confirmed,"
					+"paid,acct_code__pay,cctr_code__pay, vouch_type,curr_code,exch_rate,entry_batch_no,tot_amt__bc,"+
					"remarks,pay_mode,conf_date,emp_code__aprv,hold  FROM payr_voucher WHERE  tran_id = ?  ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, tranId);
			rs = pstmt.executeQuery();
			
	// Hemlata cahnges done to solve issue comming on tran date
		/*	SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			SimpleDateFormat sdfnew = new SimpleDateFormat("yyyy-mm-dd");
			String tranDat = "2013-04-04";
			
			java.util.Date tempDt = sdfnew.parse(tranDat);
			System.out.println("tempDt::::1822:::::["+tempDt+"]");
			
			String tempDate = sdfnew.format(tempDt);
			System.out.print( "tempDate....1825.....["+tempDate+"]");
			
			tempDt = sdfnew.parse(tempDate);
			System.out.println("tempDt::::1828:::::["+tempDt+"]");
		*/	
			
			if(rs.next())
			{
				payVouchHdr = new HashMap();
				payVouchHdr.put("tran_id",rs.getString("tran_id"));
				payVouchHdr.put("tran_type",rs.getString("tran_type"));
		//		payVouchHdr.put("tran_date",rs.getDate("eff_date"));
				payVouchHdr.put("tran_date",rs.getDate("tran_date"));
				//payVouchHdr.put("tran_date",tempDt);
				payVouchHdr.put("eff_date",rs.getDate("eff_date"));
				payVouchHdr.put("ref_date",rs.getDate("ref_date"));
				payVouchHdr.put("emp_code",rs.getString("emp_code"));
				payVouchHdr.put("ref_no",rs.getString("ref_no"));
				payVouchHdr.put("bank_code",rs.getString("bank_code"));
				payVouchHdr.put("auto_pay",rs.getString("auto_pay"));
				payVouchHdr.put("chg_date",rs.getDate("chg_date"));
				payVouchHdr.put("chg_user",rs.getString("chg_user"));
				payVouchHdr.put("chg_term",rs.getString("chg_term"));
				payVouchHdr.put("site_code",rs.getString("site_code"));
				payVouchHdr.put("fin_entity",rs.getString("fin_entity"));
				payVouchHdr.put("tot_amt",rs.getDouble("tot_amt"));
				payVouchHdr.put("anal_code",rs.getString("anal_code"));
				payVouchHdr.put("confirmed",rs.getString("confirmed"));
				payVouchHdr.put("paid",rs.getString("paid"));
				payVouchHdr.put("acct_code__pay",rs.getString("acct_code__pay"));
				payVouchHdr.put("cctr_code__pay",rs.getString("cctr_code__pay"));
				payVouchHdr.put("vouch_type",rs.getString("vouch_type"));
				payVouchHdr.put("curr_code",rs.getString("curr_code"));
				payVouchHdr.put("entry_batch_no",rs.getString("entry_batch_no"));
				payVouchHdr.put("exch_rate",rs.getDouble("exch_rate"));
				payVouchHdr.put("tot_amt__bc",rs.getDouble("tot_amt__bc"));
				payVouchHdr.put("tot_amt",rs.getDouble("tot_amt"));
				payVouchHdr.put("remarks",rs.getString("remarks"));
				payVouchHdr.put("pay_mode",rs.getString("pay_mode"));
				payVouchHdr.put("conf_date",rs.getDate("conf_date"));
				payVouchHdr.put("emp_code__aprv",rs.getString("emp_code__aprv"));
				payVouchHdr.put("hold",rs.getString("hold"));

				System.out.println("payVouchHdr="+payVouchHdr);
				// Modified by Piyush on 01/06/2016 [To update amount in header]
				hdrExchRate = rs.getDouble("exch_rate");
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;

			sql = "SELECT tran_id,line_no,acct_code,cctr_code,amount,ad_code,anal_code FROM payr_vouchdet  WHERE tran_id = ? order by line_no";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, tranId);
			rs = pstmt.executeQuery();
			while(rs.next())
			{
				payVouchDet = new HashMap();
				payVouchDet.put("tran_id",rs.getString("tran_id"));
				payVouchDet.put("line_no",rs.getString("line_no"));
				payVouchDet.put("acct_code",rs.getString("acct_code"));
				payVouchDet.put("cctr_code",rs.getString("cctr_code"));
				payVouchDet.put("amount",rs.getDouble("amount"));
				payVouchDet.put("ad_code",rs.getString("ad_code"));
				payVouchDet.put("anal_code",rs.getString("anal_code"));
				System.out.println("payVouchDet ="+payVouchDet);
				payVouchDetList.add(payVouchDet);
				// Modified by Piyush on 01/06/2016 [To update amount in header]
				totDetAmt = totDetAmt + rs.getDouble("amount");
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;

			sql = "SELECT tran_id, ref_ser,ref_no,adj_amt,tot_amt,curr_code,exch_rate__vouch,"
					+"diff_amt__exch,acct_code,cctr_code   FROM  payr_vouchadv WHERE tran_id = ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, tranId);
			rs = pstmt.executeQuery();
			while(rs.next())
			{
				payVouchAdv = new HashMap();
				payVouchAdv.put("tran_id",rs.getString("tran_id"));
				payVouchAdv.put("ref_ser",rs.getString("ref_ser"));
				payVouchAdv.put("ref_no",rs.getString("ref_no"));
				payVouchAdv.put("curr_code",rs.getString("curr_code"));
				payVouchAdv.put("adj_amt",rs.getDouble("adj_amt"));
				payVouchAdv.put("tot_amt",rs.getDouble("tot_amt"));
				payVouchAdv.put("exch_rate__vouch",rs.getDouble("exch_rate__vouch"));
				payVouchAdv.put("diff_amt__exch",rs.getDouble("diff_amt__exch"));
				payVouchAdv.put("acct_code",rs.getString("acct_code"));
				payVouchAdv.put("cctr_code",rs.getString("cctr_code"));
				System.out.println("payVouchAdv ="+payVouchAdv);
				payVouchAdvList.add(payVouchAdv);
				// Modified by Piyush on 01/06/2016 [To update amount in header]
				totDetAmt = totDetAmt + rs.getDouble("adj_amt");
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;


			// Modified by Piyush on 01/06/2016 [To update amount in header].Start
			totAmtBc = totDetAmt * hdrExchRate;
			sql = " update payr_voucher set tot_amt = ? , tot_amt__bc = ? where tran_id   = ? "; 
			pstmtUpd = conn.prepareStatement(sql);
			pstmtUpd.setDouble(1,totDetAmt);
			pstmtUpd.setDouble(2,totAmtBc);
			pstmtUpd.setString(3,tranId);
			int hdrTotUpd = pstmtUpd.executeUpdate();
			System.out.println("row update totals into payr_voucher ="+hdrTotUpd);
			pstmtUpd.close();
			pstmtUpd = null;
			payVouchHdr.put("tot_amt__bc",totAmtBc);
			payVouchHdr.put("tot_amt",totDetAmt);
			// Modified by Piyush on 01/06/2016 [To update amount in header].End

			tranDate = (Date)payVouchHdr.get("tran_date");
			System.out.println("tranDate:::1920::::::"+tranDate);

			sql = "select ledg_post_conf  from transetup where upper(tran_window) = 'W_PAYR_VOUCHER' ";
			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				ledgPostConf = checkNull(rs.getString("ledg_post_conf"));
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
			if("Y".equalsIgnoreCase(ledgPostConf.trim()))
			{
				if(!today.equals(tranDate))
				{
					tranDate = today;
					System.out.println("tranDate:::::1938::::::"+tranDate);
					
					sql = " update payr_voucher set tran_date = :ld_tran_date  	where tran_id   = ? "; 
					pstmtUpd = conn.prepareStatement(sql);
					pstmtUpd.setDate(1,tranDate == null?null:new java.sql.Date(tranDate.getTime()) );
					pstmtUpd.setString(2,tranId);
					int i = pstmtUpd.executeUpdate();
					System.out.println("row update into payr_voucher ="+i);
					pstmtUpd.close();
					pstmtUpd = null;
				}
			//	SimpleDateFormat sdfnew = new SimpleDateFormat("yyyy-mm-dd");
			//	SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
				
				System.out.println("tranDate:::::1951:::::"+tranDate);
				
			//	String tempDt1 = ;
				//System.out.print( "tempDt1..["+tempDt1+"]" );
				//java.util.Date newDt = sdfnew.parse(sdfnew.format(tranDate));
				//System.out.println("newDt..["+newDt+"]");
				
				payVouchHdr.put("tran_date",tranDate);
				//payVouchHdr.put("tran_date",newDt);

			}
			//ls_errcode = gbf_post_payr_vou(lds_hdr.describe("datawindow.data"), lds_det.describe("datawindow.data"),ai_commit)
			errString = gbfPostPayrVoucher(payVouchHdr,payVouchDetList,payVouchAdvList,xtraParams,conn);
			System.out.println("1908"+errString);
			if(errString != null && errString.trim().length() > 0)
			{
				return errString;
			}

		} catch (SQLException e) 
		{

			System.out.println("Exception :PerkClaimPos :gbfRetrievePayrVoucher :SQLException :==>\n"+e.getMessage());
			e.printStackTrace();
			throw new ITMException(e);
		}
		catch (Exception e) 
		{

			System.out.println("Exception :PerkClaimPos :gbfRetrievePayrVoucher :Exception :==>\n"+e.getMessage());
			e.printStackTrace();
			throw new ITMException(e);
		}
		return errString;
	}//gbfRetrievePayrVoucher end


	private String gbfPostPayrVoucher(HashMap payVouchHdr,ArrayList payVouchDetList,ArrayList payVouchAdvList,String xtraParams ,Connection conn) throws ITMException
	{
		String errString = "",sql = "" , userId = "", chgTerm = "";
		String empCode = "", loanNo = "", adCode = "", confirmed = "" ,transer ="" , refId = "" ,tranId = "" ,refType = "" ;
		String tranType = "",ledgPostConf = "",siteCode = "", siteCodePayment = "", finEntity = "",finEntityFr = "",finEntityTo = "";
		String linkType = "",acctCodePay = "",cctrCodePay = "",acctCodeRCP = "",cctrCodeRCP = "",keyString = "";
		String entryBatchNo = "",currCode = "",remarks = "",payMode = "",bankCode = "",acctCodeHdr = "",cctrCodeHdr = "" ;
		int lineNo = 0,count = 0 ;
		double advAmt = 0,billAmt = 0,totalAmt = 0,exchRate = 0,totalAmtBC = 0; 
		Date recoDate = null, startDate = null,  confDate = null ,refDate = null;
		Date tranDate = null,today = new java.util.Date();

		PreparedStatement pstmt = null,pstmtUpd = null,pstmtHdr = null,pstmtInner = null;
		ResultSet rs = null,rsHdr = null,rsInner = null;
		Timestamp currDate = null;
		GenericUtility genericUtility = null;
		FinCommon finCommon = new FinCommon();
		try 
		{
			System.out.println("gbfPostPayrVoucher called........... ");
			currDate = new java.sql.Timestamp(System.currentTimeMillis());
			ITMDBAccessEJB itmDBAccess = new ITMDBAccessEJB();
			genericUtility = GenericUtility.getInstance();
			userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode");
			chgTerm = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "chgTerm" );
			System.out.println("payVouch Header = "+payVouchHdr);
			if(payVouchHdr == null)
			{
				errString = itmDBAccess.getErrorString("","VTIMP","","",conn);
				return errString;
			}
			else if(payVouchHdr.size() == 0)
			{
				errString = itmDBAccess.getErrorString("","VTIMPNOREC","","",conn);
				return errString;
			}
			tranDate = (Date)payVouchHdr.get("tran_date");
			System.out.println("tranDate:::::::2026:::::::"+tranDate);
			
			refId = (String)payVouchHdr.get("tran_id");
			tranType = (String)payVouchHdr.get("tran_type");
			empCode = (String)payVouchHdr.get("emp_code");
			siteCode = checkNull((String)payVouchHdr.get("site_code"));
			totalAmt = (Double)payVouchHdr.get("tot_amt");
			exchRate = (Double)payVouchHdr.get("exch_rate");
			totalAmtBC = (Double)payVouchHdr.get("tot_amt__bc");
			currCode = (String)payVouchHdr.get("curr_code");
			bankCode = (String)payVouchHdr.get("bank_code");
			payMode = (String)payVouchHdr.get("pay_mode");
			entryBatchNo = (String)payVouchHdr.get("entry_batch_no");
			acctCodeHdr = (String)payVouchHdr.get("acct_code__pay");
			cctrCodeHdr = (String)payVouchHdr.get("cctr_code__pay");
			remarks = "Transfer for HR related payment of " + empCode;

			//ls_errcode = gbf_post_payr_vouhdr(as_tran_hdr)
			errString = gbfPostPayrVoucherHdr(payVouchHdr,payVouchDetList,payVouchAdvList,xtraParams,conn);
			if(errString != null && errString.trim().length() > 0)
			{
				return errString;
			}

			//ls_errcode = gbf_post_payr_voudet(as_tran_hdr, as_tran_det)
			errString = gbfPostPayrVoucherDet(payVouchHdr,payVouchDetList,xtraParams,conn);
			if(errString != null && errString.trim().length() > 0)
			{
				return errString;
			}
			/*if gbf_post_online() = 'Y' then
					ls_errcode = gbf_check_gltran_drcr('P-VOUC',ls_ref_id)
				end if*/
			// gbf_post_online() always retutn 'Y'; 
			//ls_errcode = gbf_check_gltran_drcr('P-VOUC',ls_ref_id)

			// Modified by Piyush on 01/06/2016 [Ref Series should be 'P-VOUC' and not 'M-VOUC'. Rectified on issue reported from Sun]
			// errString = finCommon.checkGlTranDrCr("M-VOUC",refId,conn);
			errString = finCommon.checkGlTranDrCr("P-VOUC",refId,conn);
			System.out.println("errString in checkGlTranDrCr ::"+errString);

			if(errString != null && errString.trim().length() > 0)
			{
				return errString;
			}
			// create ibca if site code in voucher does not match the payment site of the employee

			sql = "select site_code__payment  from employee where emp_code = ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, empCode);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				siteCodePayment = rs.getString("site_code__payment");
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
			if(siteCodePayment == null || siteCodePayment.trim().length() == 0)
			{
				siteCodePayment = siteCode;
			}

			if(! siteCode.trim().equalsIgnoreCase(siteCodePayment.trim()))
			{
				sql = "select fin_entity  from site where site_code = ?  ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, siteCode);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					finEntityFr = rs.getString("fin_entity");
				}
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;

				sql = "select fin_entity  from site where site_code = ?  ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, siteCodePayment);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					finEntityTo = rs.getString("fin_entity");
				}
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;

				sql = "select link_type, acct_code__pay, cctr_code__pay, acct_code__rcp, cctr_code__rcp "
						+"	from ibca_pay_ctrl 	where site_code__from 	=  ? and 	site_code__to 	= ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, siteCode);
				pstmt.setString(2, siteCodePayment);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					/*errString = itmDBAccess.getErrorString("","VMSITE","","",conn);
					return errString;
				}
				else
				{*/
					linkType = rs.getString("link_type");
					acctCodePay = rs.getString("acct_code__pay");
					cctrCodePay = rs.getString("cctr_code__pay");
					acctCodeRCP = rs.getString("acct_code__rcp");
					cctrCodeRCP = rs.getString("cctr_code__rcp");
				}
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;

				String xmlValues =	"";
				sql = "select key_string  from transetup where upper(tran_window) = 'W_PAY_IBCA' ";
				pstmt = conn.prepareStatement(sql);
				rs = pstmt.executeQuery();
				if (rs.next())
				{
					keyString = rs.getString("key_string");
				}
				rs.close();rs = null;
				pstmt.close();pstmt = null;

				System.out.println("keyString :"+keyString);
				SimpleDateFormat sdfAppl = new SimpleDateFormat(genericUtility.getApplDateFormat());
				String tranDateStr = sdfAppl.format(today);

				xmlValues ="<?xml version=\"1.0\" encoding=\"utf-8\"?><Root>";
				xmlValues = xmlValues + "<Header></Header>";
				xmlValues = xmlValues + "<Detail1>";
				xmlValues = xmlValues +		"<tran_id></tran_id>";
				xmlValues = xmlValues +		"<site_code>" + siteCode + "</site_code>";
				xmlValues = xmlValues +		"<tran_date>" + tranDateStr + "</tran_date>"; 
				xmlValues = xmlValues +		"<link_type>" + linkType + "</link_type>";
				xmlValues = xmlValues + "</Detail1></Root>";
				System.out.println("xmlValues  :["+xmlValues+"]");
				TransIDGenerator tg = new TransIDGenerator(xmlValues, "BASE", CommonConstants.DB_NAME);
				tranId = tg.generateTranSeqID("P-IBCA", "tran_id", keyString, conn);
				//refNo  = generateTranId( "t_miscpay_ref", siteCode, tranDateStr, conn );
				System.out.println("tranIdGenerate for w_pay_ibca = "+tranId);
				/*if(tranId == null || tranId.trim().length() == 0)
				{
					errString = itmDBAccess.getErrorString("","VTTRANID","","",conn);
					return errString;
				}
				else if("ERROR".equalsIgnoreCase(tranId))
				{
					errString = itmDBAccess.getErrorString("","VTTRANID","","",conn);
					return errString;
				}*/

				/*SimpleDateFormat sdfAppl = new SimpleDateFormat(genericUtility.getApplDateFormat());
				String claimDateStr = sdfAppl.format(today);

				tranId = generateTranId( "w_pay_ibca", siteCode, claimDateStr, conn );
				System.out.println("tranIdGenerate for Loan Reco = "+tranIdForLoan);
				if(tranId == null || tranId.trim().length() == 0)
				{
					errString = itmDBAccess.getErrorString("","VTTRANID","","",conn);
					return errString;
				}
				 */

				sql = " insert into pay_ibca (tran_id, tran_date, eff_date, site_code__from, fin_entity__from,"
						+" site_code__to, fin_entity__to, amount, curr_code, exch_rate, confirmed, acct_code__ifr,"
						+" cctr_code__ifr, acct_code__ito, cctr_code__ito, chg_date, chg_user, chg_term, amount__bc,"
						+"	tran_type, tran_ser, link_type, remarks) 	values ( ?, ?,?, ?, ?,"
						+" ?, ?,?,?, ?,    'N', ?,?, ?, ?,?,     ?, ?, ?,?, 'I',?, ?)  "; 
				pstmtUpd = conn.prepareStatement(sql);
				pstmtUpd.setString(1,tranId);
				pstmtUpd.setDate(2,today == null?null:new java.sql.Date(today.getTime()) );
				pstmtUpd.setDate(3,today == null?null:new java.sql.Date(today.getTime()) );
				pstmtUpd.setString(4,siteCode);
				pstmtUpd.setString(5,finEntityFr);
				pstmtUpd.setString(6,siteCodePayment);
				pstmtUpd.setString(7,finEntityTo);
				pstmtUpd.setDouble(8,totalAmt);
				pstmtUpd.setString(9,currCode);
				pstmtUpd.setDouble(10,exchRate);

				pstmtUpd.setString(11,acctCodePay);
				pstmtUpd.setString(12,cctrCodePay);
				pstmtUpd.setString(13,acctCodeRCP);
				pstmtUpd.setString(14,cctrCodeRCP);
				// Modified by Piyush on 03/06/2016 [To  update time in change date]
				//pstmtUpd.setDate(15,today == null?null:new java.sql.Date(today.getTime()) );
				pstmtUpd.setTimestamp(15,new java.sql.Timestamp(System.currentTimeMillis()));
				pstmtUpd.setString(16,userId);
				pstmtUpd.setString(17,chgTerm);
				pstmtUpd.setDouble(18,totalAmtBC);
				pstmtUpd.setString(19,tranType);
				pstmtUpd.setString(20,linkType);

				pstmtUpd.setString(21,remarks);

				int i = pstmtUpd.executeUpdate();
				System.out.println("row insert into pay_ibca ="+i);
				pstmtUpd.close();
				pstmtUpd = null;

				sql = " insert into pay_ibca_det (tran_id, ref_ser, ref_no, ref_date, curr_code, exch_rate,"
						+" sundry_type, sundry_code, acct_code, cctr_code, due_date, tot_amt, discount,"
						+"	tax_amt, auto_pay, bank_code, ref_type, pay_mode, entry_batch_no) "
						+"	values (?, 'P-VOUC',?, ?, ?, ?,"
						+"	'E', ?, ?, ?, ?, ?, 0,  	0, 'Y', ?, ?, ?, ?)  "; 
				pstmtUpd = conn.prepareStatement(sql);
				pstmtUpd.setString(1,tranId);
				pstmtUpd.setString(2,refId);
				pstmtUpd.setDate(3,tranDate == null?null:new java.sql.Date(tranDate.getTime()) );
				pstmtUpd.setString(4,currCode);
				pstmtUpd.setDouble(5,exchRate);

				pstmtUpd.setString(6,empCode);
				pstmtUpd.setString(7,acctCodeHdr);
				pstmtUpd.setString(8,cctrCodeHdr);
				pstmtUpd.setDate(9,tranDate == null?null:new java.sql.Date(tranDate.getTime()) );
				pstmtUpd.setDouble(10,totalAmt);

				pstmtUpd.setString(11,bankCode);
				pstmtUpd.setString(12,refType);//issue
				pstmtUpd.setString(13,payMode);
				pstmtUpd.setString(14,entryBatchNo);

				i = pstmtUpd.executeUpdate();
				System.out.println("row insert into pay_ibca_det ="+i);
				pstmtUpd.close();
				pstmtUpd = null;

				/*// call posting for ibca
					if itm_structure.fin_comp > 0 then
						itm_app_server[itm_structure.fin_comp].createinstance(nvo_payibca)
					else
						nvo_payibca = create nvo_business_object_pay_ibca
					end if
					ls_errcode = nvo_payibca.gbf_retrieve_pibca(ls_ibca_id, ls_ibca_id, 1,ls_site)
					destroy nvo_payibca*/
				//ls_errcode = nvo_payibca.gbf_retrieve_pibca(ls_ibca_id, ls_ibca_id, 1,ls_site)
				errString =  gbfRetrievePibca(tranId,siteCode,xtraParams,conn);
				if(errString != null && errString.trim().length() > 0)
				{
					return errString;
				}


			}

		} catch (SQLException e) 
		{

			System.out.println("Exception :PerkClaimPos :gbfPostPayrVoucher :SQLException :==>\n"+e.getMessage());
			e.printStackTrace();
			throw new ITMException(e);
		}
		catch (Exception e) 
		{

			System.out.println("Exception :PerkClaimPos :gbfPostPayrVoucher :Exception :==>\n"+e.getMessage());
			e.printStackTrace();
			throw new ITMException(e);
		}
		return errString;
	}//gbfPostPayrVoucher end


	private String gbfPostPayrVoucherHdr(HashMap payVouchHdr,ArrayList payVouchDetList,ArrayList payVouchAdvList,String xtraParams ,Connection conn) throws ITMException
	{
		String errString = "",sql = "" , userId = "", chgTerm = "";
		String empCode = "", loanNo = "", adCode = "", confirmed = "" ,transer ="" , refId = "";
		String tranType = "",acctCodePay = "",siteCode = "",tranId = "",postOption = "";
		String status = "",sType = "",sCode = "",finEntity = "",cctrCodePay = "";
		String entryBatchNo = "",currCode = "",remarks = "",hold = "",keyString = "",refNo = "",payMode = "",bankCode = "";
		String sundryCode = "" , withHeld = "",loginEmpCode = "",editOption = "",refSer = "" ;
		int lineNo = 0,count = 0 ;
		double  recoAmt = 0,balanceAmt = 0,amount = 0;
		double advAmt = 0,adjAmt = 0,totalAmt = 0,netAmt = 0,taxAmt = 0,adjAmt1 = 0;
		double exchRate = 0 , holdAmt = 0;
		Date recoDate = null, startDate = null,  confDate = null ,refDate = null;
		Date tranDate = null,today = new java.util.Date(),resiDate = null,effDate = null;
		HashMap glTraceMap = null,sundryBalMap = null,miscPayMap = null,payVouchAdv = null;
		PreparedStatement pstmt = null,pstmtUpd = null,pstmtHdr = null,pstmtInner = null;
		ResultSet rs = null,rsHdr = null,rsInner = null;
		Timestamp currDate = null;
		GenericUtility genericUtility = null;
		FinCommon finCommon = new FinCommon();
		DistCommon distCommon = new DistCommon();
		AdmCommon admCommon = null;
		try 
		{
			System.out.println("gbfPostPayrVoucherHdr called........... ");
			currDate = new java.sql.Timestamp(System.currentTimeMillis());
			ITMDBAccessEJB itmDBAccess = new ITMDBAccessEJB();
			genericUtility = GenericUtility.getInstance();
			admCommon = new AdmCommon();
			userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode");
			loginEmpCode  = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginEmpCode");
			chgTerm = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "chgTerm" );
			System.out.println("payVouch Header = "+payVouchHdr);
			if(payVouchHdr == null)
			{
				errString = itmDBAccess.getErrorString("","VTIMP","","",conn);
				return errString;
			}
			else if(payVouchHdr.size() == 0)
			{
				errString = itmDBAccess.getErrorString("","VTIMPNOREC","","",conn);
				return errString;
			}
			glTraceMap = new HashMap();
			sundryBalMap = new HashMap();
			miscPayMap = new HashMap();

			/// 25-02-04 amish ... call  the udf accounting		
			/*			ls_errcode = gbf_ud_accountposting('w_payr_voucher', 'P-VOUC', '', 3 , &
							 lds_hdr.describe("datawindow.syntax") &
							 + '~r' + lds_hdr.describe("datawindow.syntax.data"), &
							 lds_det.describe("datawindow.syntax") + &
							 '~r' + lds_det.describe("datawindow.syntax.data"), &
							lds_deta.describe("datawindow.syntax") + &
							 '~r' + lds_deta.describe("datawindow.syntax.data"), '', '', '', '')*/		
			//not migrated as pay S Manoharan Sir instruction  issue


			tranDate = (Date)payVouchHdr.get("tran_date");
			System.out.println("tranDate:::::2348:::::"+tranDate);
			
			tranId = (String)payVouchHdr.get("tran_id");
			effDate = (Date)payVouchHdr.get("eff_date");
			finEntity = (String)payVouchHdr.get("fin_entity");
			tranType = (String)payVouchHdr.get("tran_type");
			siteCode = (String)payVouchHdr.get("site_code");
			empCode = (String)payVouchHdr.get("emp_code");
			acctCodePay = (String)payVouchHdr.get("acct_code__pay");
			cctrCodePay = (String)payVouchHdr.get("cctr_code__pay");
			currCode = (String)payVouchHdr.get("curr_code");
			exchRate = (Double)payVouchHdr.get("exch_rate");
			entryBatchNo = (String)payVouchHdr.get("entry_batch_no");
			totalAmt = (Double)payVouchHdr.get("tot_amt");
			remarks = (String)payVouchHdr.get("remarks");
			hold = (String)payVouchHdr.get("hold");
			if(hold == null || hold.trim().length() == 0)
			{
				hold = "N";
			}
			refDate = (Date)payVouchHdr.get("ref_date");
			bankCode = (String)payVouchHdr.get("bank_code");
			payMode = (String)payVouchHdr.get("pay_mode");
			confirmed = (String)payVouchHdr.get("confirmed") == null?"N":(String)payVouchHdr.get("confirmed");

			postOption = checkNull(admCommon.getSiteEnv(siteCode	, "FIN", "X", "ZZZZZ", "PAYR_POSTING", new Timestamp(tranDate.getTime()), conn));
			if(!"S".equalsIgnoreCase(postOption.trim())  && !"D".equalsIgnoreCase(postOption.trim()))
			{
				errString = itmDBAccess.getErrorString("","VTSITEPARM","","",conn);
				return errString;
			}

			if("S".equalsIgnoreCase(postOption.trim()) && ("PAY".equalsIgnoreCase(tranType) || "ARR".equalsIgnoreCase(tranType)))
			{
				sql = "select resi_date  from employee where emp_code = ?  ";
				pstmt = conn.prepareStatement(sql);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					resiDate = rs.getDate("resi_date");
				}
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;
				if(resiDate != null)
					status = "S";
				else
					status = "A";
				if("S".equalsIgnoreCase(status))
				{
					sType = "E";
					sCode = empCode;
					acctCodePay = admCommon.getSiteEnv(siteCode, "FIN", "X", "ZZZZZ", "NET_PAY_AC", new Timestamp(tranDate.getTime()), conn);
					if("NULLFOUND".equalsIgnoreCase(acctCodePay))
					{
						errString = itmDBAccess.getErrorString("","VTSITEPARM","","",conn);
						return errString;
					}
				}
				sType = "O";
				sCode = "";
			}
			else
			{
				postOption = "D";
				sType = "E";
				sCode = empCode;
			}
			glTraceMap.put("ref_id", tranId);
			glTraceMap.put("tran_date", new Timestamp(tranDate ==null?null:tranDate.getTime()));
			glTraceMap.put("eff_date", new Timestamp(effDate ==null?null:effDate.getTime()) );
			glTraceMap.put("fin_entity", finEntity);
			glTraceMap.put("site_code", siteCode);
			glTraceMap.put("sundry_type", sType);
			glTraceMap.put("sundry_code", sCode);
			glTraceMap.put("acct_code", acctCodePay);
			glTraceMap.put("cctr_code", cctrCodePay);
			glTraceMap.put("emp_code", empCode);
			glTraceMap.put("anal_code", null);
			glTraceMap.put("curr_code", currCode);
			glTraceMap.put("exch_rate", exchRate);
			glTraceMap.put("entry_batch_no", entryBatchNo);
			if(totalAmt > 0)
			{
				glTraceMap.put("dr_amt", 0.0);
				glTraceMap.put("cr_amt", totalAmt);
			}
			else
			{
				glTraceMap.put("dr_amt", 0-totalAmt);
				glTraceMap.put("cr_amt", 0.0);
			}
			glTraceMap.put("ref_type", "A");
			glTraceMap.put("ref_ser", "P-VOUC");
			glTraceMap.put("remarks", remarks);

			errString = finCommon.glTraceUpdate(glTraceMap, conn);
			System.out.println("errString2386="+errString);
			if(errString != null && errString.trim().length() > 0)
			{
				return errString;
			}

			if("O".equalsIgnoreCase(sType))
			{
				System.out.println("tranDate:::::2454::::::"+tranDate);
				
				sundryBalMap.put("tran_date",new Timestamp(tranDate ==null?null:tranDate.getTime()));
				sundryBalMap.put("eff_date ",new Timestamp(effDate ==null?null:effDate.getTime()));
				sundryBalMap.put("fin_entity",finEntity);
				sundryBalMap.put("site_code",siteCode);
				sundryBalMap.put("sundry_type",sType);
				sundryBalMap.put("sundry_code",sCode);
				sundryBalMap.put("acct_code",acctCodePay);
				sundryBalMap.put("cctr_code",cctrCodePay);
				sundryBalMap.put("curr_code ",currCode);
				sundryBalMap.put("exch_rate",exchRate);


				if(totalAmt > 0)
				{
					sundryBalMap.put("dr_amt",0.0);
					sundryBalMap.put("cr_amt",totalAmt);
				}
				else
				{
					sundryBalMap.put("dr_amt",0-totalAmt);
					sundryBalMap.put("cr_amt",0.0);
				}
				//sundryBalMap.put("adv_amt",0);
				sundryBalMap.put("adv_amt",0.0);
				sType = (String)sundryBalMap.get("sundry_type");
				sCode = (String)sundryBalMap.get("sundry_code");
				sundryBalMap.put("contact_code",finCommon.getContactCode(sType,sCode,conn));
				
				System.out.println("sundryBalMap:::::2483::::::"+sundryBalMap);
				
				errString = finCommon.gbf_sundrybal_upd(sundryBalMap,conn);
				System.out.println("2422 errString="+errString);
				if(errString != null && errString.trim().length() > 0)
				{
					return errString;
				}
			}
			// should be done only if it is a payroll / arrear voucher not for any other voucher 229
			if("PAY".equalsIgnoreCase(tranType) || "ARR".equalsIgnoreCase(tranType))
			{
				if("S".equalsIgnoreCase(postOption))
				{
					sql = " select count(*)  from misc_payables where site_code = ? and entry_batch_no = ? "
							+"	and acct_code = ? and cctr_code = ? ";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, siteCode);
					pstmt.setString(2, entryBatchNo);
					pstmt.setString(3, acctCodePay);
					pstmt.setString(4, cctrCodePay);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						count = rs.getInt(1);
					}
					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null;
					if(count == 0)
					{
						// insert into misc_payables
						String xmlValues =	"";
						sql = "select key_string  from transetup where upper(tran_window) = 'T_MISCPAY_REF' ";
						pstmt = conn.prepareStatement(sql);
						rs = pstmt.executeQuery();
						if (rs.next())
						{
							keyString = rs.getString("key_string");
						}
						rs.close();rs = null;
						pstmt.close();pstmt = null;
						
						if(keyString == null || keyString.trim().length() == 0)
						{
							sql = " select key_string  from transetup where upper(tran_window) = 'GENERAL' ";
							pstmt = conn.prepareStatement(sql);
							rs = pstmt.executeQuery();
							if (rs.next())
							{
								keyString = rs.getString("key_string");
							}
							rs.close();rs = null;
							pstmt.close();pstmt = null;
						}
						System.out.println("keyString :"+keyString);
						SimpleDateFormat sdfAppl = new SimpleDateFormat(genericUtility.getApplDateFormat());
						String tranDateStr = sdfAppl.format(tranDate);

						xmlValues ="<?xml version=\"1.0\" encoding=\"utf-8\"?><Root>";
						xmlValues = xmlValues + "<Header></Header>";
						xmlValues = xmlValues + "<Detail1>";
						xmlValues = xmlValues +		"<tran_id></tran_id>";
						xmlValues = xmlValues +		"<site_code>" + siteCode + "</site_code>";
						xmlValues = xmlValues +		"<tran_date>" + tranDateStr + "</tran_date>"; 
						xmlValues = xmlValues + "</Detail1></Root>";
						System.out.println("xmlValues  :["+xmlValues+"]");
						TransIDGenerator tg = new TransIDGenerator(xmlValues, "BASE", CommonConstants.DB_NAME);
						refNo = tg.generateTranSeqID("PAY_R", "tran_id", keyString, conn);
						//refNo  = generateTranId( "t_miscpay_ref", siteCode, tranDateStr, conn );
						System.out.println("tranIdGenerate for Loan Reco = "+refNo);
						if(refNo == null || refNo.trim().length() == 0)
						{
							errString = itmDBAccess.getErrorString("","VTTRANID","","",conn);
							return errString;
						}
						else if("ERROR".equalsIgnoreCase(refNo))
						{
							errString = itmDBAccess.getErrorString("","VTTRANID","","",conn);
							return errString;
						}
						miscPayMap.put("tran_ser","P-VOUC");
						miscPayMap.put("tran_date",new Timestamp(tranDate ==null?null:tranDate.getTime()));
						miscPayMap.put("ref_no",refNo);
						miscPayMap.put("ref_date",new Timestamp(tranDate ==null?null:tranDate.getTime()));
						miscPayMap.put("bill_no"," ");
						miscPayMap.put("bill_date",new Timestamp(refDate ==null?null:refDate.getTime()));
						miscPayMap.put("curr_code",currCode);
						miscPayMap.put("exch_rate",exchRate);
						miscPayMap.put("sundry_type","O");
						miscPayMap.put("sundry_code","");
						miscPayMap.put("acct_code",acctCodePay);
						miscPayMap.put("cctr_code",cctrCodePay);
						miscPayMap.put("due_date",new Timestamp(tranDate ==null?null:tranDate.getTime()));
						miscPayMap.put("site_code",siteCode);
						miscPayMap.put("fin_entity",finEntity);
						miscPayMap.put("tot_amt",totalAmt);
						miscPayMap.put("bank_code",bankCode); 
						miscPayMap.put("auto_pay","Y");
						miscPayMap.put("pay_mode",payMode);
						miscPayMap.put("paid","N");
						miscPayMap.put("adv_amt",0.0);
						miscPayMap.put("entry_batch_no",entryBatchNo);
						sundryCode = empCode;
						if("Y".equalsIgnoreCase(hold))
						{
							miscPayMap.put("hold_amt",totalAmt);
						}
						else if("N".equalsIgnoreCase(hold) && "E".equalsIgnoreCase(sType))
						{
							sql = " select with_held  from employee where emp_code = ? ";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, empCode);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								withHeld = checkNull(rs.getString(1));
							}
							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;
							if("Y".equalsIgnoreCase(withHeld))
							{
								miscPayMap.put("hold_amt",totalAmt);
								sql = " update payr_voucher set hold = 'Y' where tran_id = ? "; 
								pstmtUpd = conn.prepareStatement(sql);
								pstmtUpd.setString(1,tranId);
								int i = pstmtUpd.executeUpdate();
								System.out.println("row update into payr_voucher ="+i);
								pstmtUpd.close();
								pstmtUpd = null;

							}
							else
							{
								miscPayMap.put("hold_amt",0.0);
							}
						}
						else
						{
							miscPayMap.put("hold_amt",0.0);
						}

						errString = finCommon.gbfMiscPayUpd(miscPayMap,conn);
						System.out.println("2565="+errString);
						if(errString != null && errString.trim().length() > 0)
						{
							return errString;
						}
					}
					else if(count == 1)
					{
						// update the record in misc_payables 340
						sundryCode = empCode;
						if("Y".equalsIgnoreCase(hold))
						{
							holdAmt = totalAmt;
						}
						else if("N".equalsIgnoreCase(hold) && "E".equalsIgnoreCase(sType))
						{
							sql = " select with_held  from employee where emp_code = ? ";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, empCode);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								withHeld = checkNull(rs.getString(1));
							}
							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;
							if("Y".equalsIgnoreCase(withHeld))
							{
								holdAmt = totalAmt;
								sql = " update payr_voucher set hold = 'Y' where tran_id = ? "; 
								pstmtUpd = conn.prepareStatement(sql);
								pstmtUpd.setString(1,tranId);
								int i = pstmtUpd.executeUpdate();
								System.out.println("row update into payr_voucher ="+i);
								pstmtUpd.close();
								pstmtUpd = null;

							}
							else
							{
								holdAmt = 0;
							}
						}
						sql = " update misc_payables set tot_amt = tot_amt + ?,hold_amt = hold_amt + ?, status_date = ?  "
								+" where site_code = ? and entry_batch_no = ? and acct_code = ? and cctr_code =  ?  "; 
						pstmtUpd = conn.prepareStatement(sql);
						pstmtUpd.setDouble(1,totalAmt);
						pstmtUpd.setDouble(2,holdAmt);
						pstmtUpd.setDate(3,today == null?null:new java.sql.Date(today.getTime()) );
						pstmtUpd.setString(4,siteCode);
						pstmtUpd.setString(5,entryBatchNo);
						pstmtUpd.setString(6,acctCodePay);
						pstmtUpd.setString(7,cctrCodePay);
						int i = pstmtUpd.executeUpdate();
						System.out.println("row update into misc_payables ="+i);
						pstmtUpd.close();
						pstmtUpd = null;

					}
					else
					{
						errString = itmDBAccess.getErrorString("","VTPAYSUM","","",conn);
						return errString;
					}
				}
			}// end of ls_trantype
			// insert into misc_payables only for ls_post_option = 'D' 402
			// for all vouchers non payroll / arrears ls_post_option is forced to 'D'
			if("D".equalsIgnoreCase(postOption))
			{
				miscPayMap.put("tran_ser","P-VOUC");
				miscPayMap.put("tran_date",new Timestamp(tranDate ==null?null:tranDate.getTime()));
				miscPayMap.put("ref_no",tranId);
				miscPayMap.put("ref_date",new Timestamp(tranDate ==null?null:tranDate.getTime()));
				miscPayMap.put("bill_no"," ");
				miscPayMap.put("bill_date",new Timestamp(refDate ==null?null:refDate.getTime()));
				miscPayMap.put("curr_code",currCode);
				miscPayMap.put("exch_rate",exchRate);
				miscPayMap.put("sundry_type","E");
				miscPayMap.put("sundry_code",empCode);
				miscPayMap.put("acct_code",acctCodePay);
				miscPayMap.put("cctr_code",cctrCodePay);
				miscPayMap.put("due_date",new Timestamp(tranDate ==null?null:tranDate.getTime()));
				miscPayMap.put("site_code",siteCode);
				miscPayMap.put("fin_entity",finEntity);
				miscPayMap.put("tot_amt",totalAmt);
				miscPayMap.put("bank_code",bankCode); 
				miscPayMap.put("auto_pay","Y");
				miscPayMap.put("pay_mode",payMode);
				miscPayMap.put("paid","N");
				miscPayMap.put("adv_amt",0.0);
				miscPayMap.put("entry_batch_no",entryBatchNo);

				sundryCode = empCode;
				if("Y".equalsIgnoreCase(hold))
				{
					miscPayMap.put("hold_amt",totalAmt);
				}
				else if("N".equalsIgnoreCase(hold) && "E".equalsIgnoreCase(sType))
				{
					sql = " select with_held  from employee where emp_code = ? ";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, empCode);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						withHeld = checkNull(rs.getString(1));
					}
					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null;
					if("Y".equalsIgnoreCase(withHeld))
					{
						miscPayMap.put("hold_amt",totalAmt);
						sql = " update payr_voucher set hold = 'Y' where tran_id = ? "; 
						pstmtUpd = conn.prepareStatement(sql);
						pstmtUpd.setString(1,tranId);
						int i = pstmtUpd.executeUpdate();
						System.out.println("row update into payr_voucher ="+i);
						pstmtUpd.close();
						pstmtUpd = null;

					}
					else
					{
						miscPayMap.put("hold_amt",0.0);
					}
				}
				errString = finCommon.gbfMiscPayUpd(miscPayMap,conn);	
				System.out.println("2697  errString="+errString);
				if(errString != null && errString.trim().length() > 0)
				{
					return errString;
				}
			}// post_option = 'D'

			if(!"Y".equalsIgnoreCase(confirmed))
			{
				sql = " update payr_voucher set confirmed = 'Y', conf_date = ?, emp_code__aprv = ? where tran_id = ? "; 
				pstmtUpd = conn.prepareStatement(sql);
				// Modified by Piyush on 28/06/2016 [To update time in confirmation date]
				//pstmtUpd.setDate(1,today == null?null:new java.sql.Date(today.getTime()) );
				pstmtUpd.setTimestamp(1,new java.sql.Timestamp(System.currentTimeMillis()));
				pstmtUpd.setString(2,loginEmpCode);
				pstmtUpd.setString(3,tranId);
				int i = pstmtUpd.executeUpdate();
				System.out.println("row update into payr_voucher ="+i);
				pstmtUpd.close();
				pstmtUpd = null;
			}

			sql = " select edi_option  from transetup where tran_window = 'w_payr_voucher'";
			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				editOption = checkNull(rs.getString(1));
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;

			if(editOption != null && editOption.trim().equalsIgnoreCase("0"))
			{

				String dataStr = "";
				if ( "1".equals(editOption.trim()) )
				{
					CreateRCPXML createRCPXML = new CreateRCPXML("w_payr_voucher","tran_id");
					dataStr = createRCPXML.getTranXML( tranId, conn );
					System.out.println( "dataStr =[ "+ dataStr + "]" );
					Document ediDataDom = genericUtility.parseString(dataStr);
					E12CreateBatchLoadEjb e12CreateBatchLoad = new E12CreateBatchLoadEjb();
					String retString = e12CreateBatchLoad.createBatchLoad(ediDataDom, "w_payr_voucher", "0", xtraParams, conn );
					createRCPXML = null;
					e12CreateBatchLoad = null;
					if( retString != null && "SUCCESS".equals(retString) )
					{
						System.out.println("retString from pay voucher = 	["+retString+"]");
					}
				}

			} 

			for (int ctr =0; ctr < payVouchAdvList.size(); ctr++)
			{
				// adjust the misc_payable entry for each misc_payable adjusted 535
				glTraceMap = new HashMap();
				payVouchAdv = new HashMap();
				payVouchAdv = (HashMap) payVouchAdvList.get(ctr);
				System.out.println("2755 payVouchAdv="+payVouchAdv);
				
				System.out.println("glTraceMap::::::tranDate:::::"+tranDate);
				
				glTraceMap.put("tran_date", new Timestamp(tranDate ==null?null:tranDate.getTime()));
				glTraceMap.put("eff_date", new Timestamp(effDate ==null?null:effDate.getTime()) );
				glTraceMap.put("fin_entity", finEntity);
				glTraceMap.put("site_code", siteCode);
				glTraceMap.put("sundry_type", "E");
				glTraceMap.put("sundry_code", empCode);
				glTraceMap.put("acct_code", (String)payVouchAdv.get("acct_code"));
				glTraceMap.put("cctr_code", (String)payVouchAdv.get("cctr_code"));
				glTraceMap.put("emp_code", null);
				glTraceMap.put("anal_code", null);
				glTraceMap.put("curr_code", (String)payVouchAdv.get("curr_code"));
				glTraceMap.put("exch_rate", (Double)payVouchAdv.get("exch_rate__vouch"));

				if((Double)payVouchAdv.get("adj_amt") > 0)
				{
					glTraceMap.put("dr_amt", (Double)payVouchAdv.get("adj_amt") );
					glTraceMap.put("cr_amt", 0.0);
				}
				else
				{
					glTraceMap.put("dr_amt", 0.0);
					glTraceMap.put("cr_amt", 0 - (Double)payVouchAdv.get("adj_amt") );
				}
				glTraceMap.put("ref_type", "A");
				glTraceMap.put("ref_ser", "P-VOUC");
				glTraceMap.put("ref_id", tranId);
				glTraceMap.put("remarks", remarks);

				errString = finCommon.glTraceUpdate(glTraceMap, conn);
				System.out.println("2788 errString="+errString);
				if(errString != null && errString.trim().length() > 0)
				{
					return errString;
				}
				System.out.println(" sundryBalMap::::tranDate:::::"+tranDate);
				
				sundryBalMap.put("tran_date",new Timestamp(tranDate ==null?null:tranDate.getTime()));
				sundryBalMap.put("eff_date ",new Timestamp(effDate ==null?null:effDate.getTime()));
				sundryBalMap.put("fin_entity",finEntity);
				sundryBalMap.put("site_code",siteCode);
				sundryBalMap.put("sundry_type","E");
				sundryBalMap.put("sundry_code",empCode);
				sundryBalMap.put("acct_code",(String)payVouchAdv.get("acct_code"));
				sundryBalMap.put("cctr_code",(String)payVouchAdv.get("cctr_code"));
				sundryBalMap.put("curr_code ",(String)payVouchAdv.get("curr_code"));
				sundryBalMap.put("exch_rate",(Double)payVouchAdv.get("exch_rate__vouch"));	


				if((Double)payVouchAdv.get("adj_amt") > 0)
				{
					sundryBalMap.put("dr_amt",(Double)payVouchAdv.get("adj_amt"));
					sundryBalMap.put("cr_amt",0.0);
				}
				else
				{
					sundryBalMap.put("dr_amt",0.0);
					sundryBalMap.put("cr_amt",0 - (Double)payVouchAdv.get("adj_amt"));
				}
				sundryBalMap.put("adv_amt",0.0);
				sType = (String)sundryBalMap.get("sundry_type");
				sCode = (String)sundryBalMap.get("sundry_code");
				sundryBalMap.put("contact_code",finCommon.getContactCode(sType,sCode,conn));

				errString = finCommon.gbf_sundrybal_upd(sundryBalMap,conn);	
				System.out.println("2822 errString ="+errString);
				if(errString != null && errString.trim().length() > 0)
				{
					return errString;
				}

				refSer = (String)payVouchAdv.get("ref_ser");
				refNo = (String)payVouchAdv.get("ref_no");
				adjAmt = (Double)payVouchAdv.get("adj_amt");
				sql = " select tot_amt, adj_amt  from misc_payables		where tran_ser = ? and ref_no = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, refSer);
				pstmt.setString(2, refNo);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					amount = rs.getDouble("tot_amt");
					adjAmt1 = rs.getDouble("adj_amt");
				}
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;

				if(Math.abs(amount - adjAmt1) < Math.abs(adjAmt))
				{
					errString = itmDBAccess.getErrorString("","VTBAL1","","",conn);
					return errString;
				}
				adjAmt1 = adjAmt1 +  adjAmt ;
				if(amount == adjAmt)
					status = "A";
				else
					status = "P"; 

				sql = " update misc_payables set adj_amt = adj_amt + ? , hold_amt = 0,status = ?, status_date = ? "
						+" 	where tran_ser = ? and ref_no = ?  "; 
				pstmtUpd = conn.prepareStatement(sql);
				pstmtUpd.setDouble(1, adjAmt);
				pstmtUpd.setString(2,status );
				pstmtUpd.setDate(3,today == null?null:new java.sql.Date(today.getTime()) );
				pstmtUpd.setString(4,refSer);
				pstmtUpd.setString(5,refNo);
				int i = pstmtUpd.executeUpdate();
				System.out.println("row update into misc_payables ="+i);
				pstmtUpd.close();
				pstmtUpd = null;


				sql = " select count(*)   from payr_voucher  where tran_id = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, refNo);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					count = rs.getInt(1);
				}
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;
				if(count > 0)
				{
					sql = " update payr_voucher set hold = 'N' 	where tran_id = ?   "; 
					pstmtUpd = conn.prepareStatement(sql);
					pstmtUpd.setString(1,refNo);
					i = pstmtUpd.executeUpdate();
					System.out.println("row update into payr_voucher ="+i);
					pstmtUpd.close();
					pstmtUpd = null;
				}

			}

		} catch (SQLException e) 
		{

			System.out.println("Exception :PerkClaimPos :gbfPostPayrVoucherHdr :SQLException :==>\n"+e.getMessage());
			e.printStackTrace();
			throw new ITMException(e);
		}
		catch (Exception e) 
		{

			System.out.println("Exception :PerkClaimPos :gbfPostPayrVoucherHdr :Exception :==>\n"+e.getMessage());
			e.printStackTrace();
			throw new ITMException(e);
		}
		return errString;
	}//gbfPostPayrVoucherHdr end




	private String gbfPostPayrVoucherDet(HashMap payVouchHdr,ArrayList payVouchDetList,String xtraParams ,Connection conn) throws ITMException
	{
		String errString = "",sql = "" , userId = "", chgTerm = "";
		String empCode = "", loanNo = "", adCode = "", confirmed = "" ,transer ="" , refId = "";
		String tranType = "",ledgPostConf = "",balOpt = "";
		String status = "",sType = "",sCode = "",finEntity = "",cctrCodePay = "", tranId = "", siteCode = "";
		String entryBatchNo = "",currCode = "",remarks = "",hold = "",keyString = "",refNo = "",payMode = "",bankCode = "";
		int lineNo = 0,count = 0 ;
		double  recoAmt = 0,balanceAmt = 0,amount = 0;
		double advAmt = 0,billAmt = 0,totalAmt = 0,netAmt = 0,taxAmt = 0; 
		double exchRate = 0;
		Date recoDate = null, startDate = null,  confDate = null ,refDate = null;
		Date tranDate = null,today = new java.util.Date(),effDate = null;
		HashMap glTraceMap = null, payVouchDet = null ,sundryBalMap = null;
		PreparedStatement pstmt = null,pstmtUpd = null,pstmtHdr = null,pstmtInner = null;
		ResultSet rs = null,rsHdr = null,rsInner = null;
		Timestamp currDate = null;
		GenericUtility genericUtility = null;
		FinCommon finCommon = new FinCommon();
		DistCommon distCommon = new DistCommon();
		try 
		{
			System.out.println("gbfPostPayrVoucherDet called........... ");
			currDate = new java.sql.Timestamp(System.currentTimeMillis());
			ITMDBAccessEJB itmDBAccess = new ITMDBAccessEJB();
			genericUtility = GenericUtility.getInstance();
			userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode");
			chgTerm = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "chgTerm" );
			System.out.println("payVouch Header = "+payVouchHdr);
			if(payVouchHdr == null)
			{
				errString = itmDBAccess.getErrorString("","VTIMP","","",conn);
				return errString;
			}
			else if(payVouchHdr.size() == 0)
			{
				errString = itmDBAccess.getErrorString("","VTIMPNOREC","","",conn);
				return errString;
			}

			System.out.println("payVouch Detail = "+payVouchDetList);
			if(payVouchDetList == null)
			{
				errString = itmDBAccess.getErrorString("","VTIMP","","",conn);
				return errString;
			}
			else if(payVouchDetList.size() == 0)
			{
				errString = itmDBAccess.getErrorString("","VTIMPNOREC","","",conn);
				return errString;
			}
			tranDate = (Date)payVouchHdr.get("tran_date");
			System.out.println("payVouchHdr::::::::tranDate:::::"+tranDate);
			tranId = (String)payVouchHdr.get("tran_id");
			effDate = (Date)payVouchHdr.get("eff_date");
			finEntity = (String)payVouchHdr.get("fin_entity");
			tranType = (String)payVouchHdr.get("tran_type");
			siteCode = (String)payVouchHdr.get("site_code");
			empCode = (String)payVouchHdr.get("emp_code");
			currCode = (String)payVouchHdr.get("curr_code");
			exchRate = (Double)payVouchHdr.get("exch_rate");
			entryBatchNo = (String)payVouchHdr.get("entry_batch_no");
			totalAmt = (Double)payVouchHdr.get("tot_amt");
			remarks = (String)payVouchHdr.get("remarks");
			hold = (String)payVouchHdr.get("hold");

			for (int ctr =0; ctr < payVouchDetList.size(); ctr++)
			{
				glTraceMap = new HashMap();
				payVouchDet = new HashMap();
				payVouchDet = (HashMap)payVouchDetList.get(ctr);
				adCode = (String)payVouchDet.get("ad_code");

				sql = "select bal_opt  from allwdedn where ad_code = ?  ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, adCode);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					balOpt = rs.getString("bal_opt") == null?" ":rs.getString("bal_opt");
				}
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;

				// Modified by Piyush on 02/04/2015[To resolve date casting issue on posting].Start
				/*
				glTraceMap.put("tran_date", tranDate);
				glTraceMap.put("eff_date", effDate);
				*/
				glTraceMap.put("tran_date", new Timestamp(tranDate == null ? null : tranDate.getTime()));
				glTraceMap.put("eff_date", new Timestamp(effDate == null ? null : effDate.getTime()));
				// Modified by Piyush on 02/04/2015[To resolve date casting issue on posting].End
				glTraceMap.put("fin_entity", finEntity);
				glTraceMap.put("site_code", siteCode);
				if("C".equalsIgnoreCase(balOpt.trim()) || "P".equalsIgnoreCase(balOpt.trim()))
				{
					glTraceMap.put("sundry_type", "E");
					glTraceMap.put("sundry_code", empCode);
				}
				else
				{
					glTraceMap.put("sundry_type", "O");
					glTraceMap.put("sundry_code", " ");
				}

				glTraceMap.put("acct_code", (String)payVouchDet.get("acct_code"));
				glTraceMap.put("cctr_code", (String)payVouchDet.get("cctr_code"));
				glTraceMap.put("emp_code", empCode);
				glTraceMap.put("anal_code", (String)payVouchDet.get("anal_code"));
				glTraceMap.put("curr_code", currCode);
				glTraceMap.put("exch_rate", exchRate);
				glTraceMap.put("entry_batch_no", entryBatchNo);

				if((Double)payVouchDet.get("amount") > 0)
				{
					glTraceMap.put("dr_amt", (Double)payVouchDet.get("amount") );
					glTraceMap.put("cr_amt", 0.0);
				}
				else
				{
					//glTraceMap.put("dr_amt", 0);
					glTraceMap.put("dr_amt", 0.0);
					glTraceMap.put("cr_amt", 0 - (Double)payVouchDet.get("amount") );
				}
				glTraceMap.put("ref_type", "A");
				glTraceMap.put("ref_ser", "P-VOUC");
				glTraceMap.put("ref_id", tranId);
				glTraceMap.put("remarks", remarks);

				errString = finCommon.glTraceUpdate(glTraceMap, conn);
				System.out.println("3040 errString="+errString);
				if(errString != null && errString.trim().length() > 0)
				{
					return errString;
				}
				if("C".equalsIgnoreCase(balOpt.trim()) || "P".equalsIgnoreCase(balOpt.trim()))
				{
					sundryBalMap = new HashMap();
					
					System.out.println("tranDate:::sundry:::"+tranDate);
					
					//sundryBalMap.put("tran_date",tranDate);
					sundryBalMap.put("tran_date",new Timestamp(tranDate == null ? null : tranDate.getTime()));
				
					sundryBalMap.put("eff_date ",effDate);
					sundryBalMap.put("fin_entity",finEntity);
					sundryBalMap.put("site_code",siteCode);
					sundryBalMap.put("sundry_type","E");
					sundryBalMap.put("sundry_code",empCode);
					sundryBalMap.put("acct_code",(String)payVouchDet.get("acct_code"));
					sundryBalMap.put("cctr_code",(String)payVouchDet.get("cctr_code"));
					System.out.println("currCode:::::::["+currCode+"]");
					sundryBalMap.put("curr_code",currCode);
					sundryBalMap.put("exch_rate",exchRate);	


					if((Double)payVouchDet.get("amount") > 0)
					{
						sundryBalMap.put("dr_amt",(Double)payVouchDet.get("amount"));
						sundryBalMap.put("cr_amt",0.0);
					}
					else
					{
						//sundryBalMap.put("dr_amt",0);
						sundryBalMap.put("dr_amt",0.0);
						sundryBalMap.put("cr_amt",0 - (Double)payVouchDet.get("amount"));
					}
					sundryBalMap.put("adv_amt",0.0);
					sType = (String)sundryBalMap.get("sundry_type");
					sCode = (String)sundryBalMap.get("sundry_code");
					sundryBalMap.put("contact_code",finCommon.getContactCode(sType,sCode,conn));
					
					System.out.println("sundryBalMap::::::::::"+sundryBalMap);
					
					errString = finCommon.gbf_sundrybal_upd(sundryBalMap,conn);	
					System.out.println("3076 errString="+errString);
					if(errString != null && errString.trim().length() > 0)
					{
						return errString;
					}

				}
			}

		} catch (SQLException e) 
		{

			System.out.println("Exception :PerkClaimPos :gbfPostPayrVoucherDet :SQLException :==>\n"+e.getMessage());
			e.printStackTrace();
			throw new ITMException(e);
		}
		catch (Exception e) 
		{

			System.out.println("Exception :PerkClaimPos :gbfPostPayrVoucherDet :Exception :==>\n"+e.getMessage());
			e.printStackTrace();
			throw new ITMException(e);
		}
		return errString;
	}//gbfPostPayrVoucherDet end


	private String gbfRetrievePibca(String tranId,String siteCode,String xtraParams ,Connection conn) throws ITMException
	{
		String errString = "",sql = "" ;
		String tranType = "",rights = "",ledgPostConf = "";
		int count = 0 ;
		double totalAmt = 0; 
		Date tranDate = null,today = new java.util.Date();
		HashMap payIbcaHdr = null;
		HashMap payIbcaDet = null;
		ArrayList payIbcaDetList = new ArrayList();
		PreparedStatement pstmt = null,pstmtUpd = null;
		ResultSet rs = null;
		try 
		{
			System.out.println("gbfRetrievePibca called........... ");
			ITMDBAccessEJB itmDBAccess = new ITMDBAccessEJB();

			if ("db2".equalsIgnoreCase(CommonConstants.DB_NAME ))
			{
				sql = " select tran_id  from pay_ibca 	where tran_id =  ?  for update  ";
			}

			else if ( "mssql".equalsIgnoreCase(CommonConstants.DB_NAME ))
			{
				sql = " select tran_id  from pay_ibca (updlock) where tran_id = ?  " ;
			}
			else
			{
				sql ="  select tran_id  from pay_ibca where tran_id = ? for update nowait " ;
			}
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, tranId);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				tranId = checkNull(rs.getString("tran_id"));
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;



			sql = " SELECT tran_id,tran_ser,tran_id__iss,tran_type,tran_date,eff_date,site_code__from,"
					+" fin_entity__from,site_code__to,fin_entity__to,acct_code__ifr,cctr_code__ifr,acct_code__ito,"
					+" cctr_code__ito,amount,curr_code,link_type,confirmed,conf_date,emp_code__aprv,amount__bc,"
					+" chg_date,chg_user,chg_term,add_date,add_user,add_term, exch_rate,remarks,sundry_type,sundry_code "
					+" FROM pay_ibca WHERE  tran_id =  ?  ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, tranId);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				payIbcaHdr = new HashMap();
				payIbcaHdr.put("tran_id",rs.getString("tran_id"));
				payIbcaHdr.put("tran_ser",rs.getString("tran_ser"));
				payIbcaHdr.put("tran_id__iss",rs.getString("tran_id__iss"));
				payIbcaHdr.put("tran_type",rs.getString("tran_type"));
				payIbcaHdr.put("tran_date",rs.getDate("tran_date"));
				payIbcaHdr.put("eff_date",rs.getDate("eff_date"));
				payIbcaHdr.put("site_code__from",rs.getString("site_code__from"));
				payIbcaHdr.put("fin_entity__from",rs.getString("fin_entity__from"));
				payIbcaHdr.put("site_code__to",rs.getString("site_code__to"));
				payIbcaHdr.put("fin_entity__to",rs.getString("fin_entity__to"));
				payIbcaHdr.put("acct_code__ifr",rs.getString("acct_code__ifr"));
				payIbcaHdr.put("cctr_code__ifr",rs.getString("cctr_code__ifr"));
				payIbcaHdr.put("acct_code__ito",rs.getString("acct_code__ito"));
				payIbcaHdr.put("cctr_code__ito",rs.getString("cctr_code__ito"));
				payIbcaHdr.put("amount",rs.getDouble("amount"));
				payIbcaHdr.put("curr_code",rs.getString("curr_code"));
				payIbcaHdr.put("link_type",rs.getString("link_type"));
				payIbcaHdr.put("confirmed",rs.getString("confirmed"));
				payIbcaHdr.put("conf_date",rs.getDate("conf_date"));
				payIbcaHdr.put("emp_code__aprv",rs.getString("emp_code__aprv"));
				payIbcaHdr.put("amount__bc",rs.getDouble("amount__bc"));
				payIbcaHdr.put("chg_date",rs.getDate("chg_date"));
				payIbcaHdr.put("chg_user",rs.getString("chg_user"));
				payIbcaHdr.put("chg_term",rs.getString("chg_term"));
				payIbcaHdr.put("add_date",rs.getDate("add_date"));
				payIbcaHdr.put("add_user",rs.getString("add_user"));
				payIbcaHdr.put("add_term",rs.getString("add_term"));
				payIbcaHdr.put("exch_rate",rs.getDouble("exch_rate"));
				payIbcaHdr.put("remarks",rs.getString("remarks"));
				payIbcaHdr.put("sundry_type",rs.getString("sundry_type"));
				payIbcaHdr.put("sundry_code",rs.getString("sundry_code"));
				System.out.println("payIbcaHdr="+payIbcaHdr);
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;

			sql = " SELECT tran_id,ref_ser,ref_no,ref_date,curr_code,acct_code,cctr_code,due_date,tot_amt,"
					+" discount,tax_amt,auto_pay,bank_code,ref_type,cr_term,bill_no,bill_date,sundry_type,"
					+" sundry_code,pay_mode,exch_rate,entry_batch_no,purc_order,supp_bill_amt,adv_amt,tds_amt,"
					+"  ref_ser__org   FROM pay_ibca_det WHERE  tran_id = ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, tranId);
			rs = pstmt.executeQuery();
			while(rs.next())
			{
				payIbcaDet = new HashMap();
				payIbcaDet.put("tran_id",rs.getString("tran_id"));
				payIbcaDet.put("ref_ser",rs.getString("ref_ser"));
				payIbcaDet.put("ref_no",rs.getString("ref_no"));
				payIbcaDet.put("ref_date",rs.getDate("ref_date"));
				payIbcaDet.put("curr_code",rs.getString("curr_code"));
				payIbcaDet.put("acct_code",rs.getString("acct_code"));
				payIbcaDet.put("cctr_code",rs.getString("cctr_code"));
				payIbcaDet.put("due_date",rs.getDate("due_date"));
				payIbcaDet.put("tot_amt",rs.getDouble("tot_amt"));
				payIbcaDet.put("discount",rs.getDouble("discount"));
				payIbcaDet.put("tax_amt",rs.getDouble("tax_amt"));
				payIbcaDet.put("auto_pay",rs.getString("auto_pay"));
				payIbcaDet.put("bank_code",rs.getString("bank_code"));
				payIbcaDet.put("ref_type",rs.getString("ref_type"));
				payIbcaDet.put("cr_term",rs.getString("cr_term"));
				payIbcaDet.put("bill_no",rs.getString("bill_no"));
				payIbcaDet.put("bill_date",rs.getDate("bill_date"));
				payIbcaDet.put("sundry_type",rs.getString("sundry_type"));
				payIbcaDet.put("sundry_code",rs.getString("sundry_code"));
				payIbcaDet.put("pay_mode",rs.getString("pay_mode"));
				payIbcaDet.put("entry_batch_no",rs.getString("entry_batch_no"));
				payIbcaDet.put("exch_rate",rs.getDouble("exch_rate"));
				payIbcaDet.put("purc_order",rs.getString("purc_order"));
				payIbcaDet.put("supp_bill_amt",rs.getDouble("supp_bill_amt"));
				payIbcaDet.put("adv_amt",rs.getDouble("adv_amt"));
				payIbcaDet.put("tds_amt",rs.getDouble("tds_amt"));
				payIbcaDet.put("ref_ser__org",rs.getString("ref_ser__org"));
				System.out.println("payIbcaDet ="+payIbcaDet);
				payIbcaDetList.add(payIbcaDet);
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;

			tranDate = (Date)payIbcaHdr.get("tran_date");

			sql = "select ledg_post_conf  from transetup where upper(tran_window) = 'W_PAY_IBCA' ";
			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			if(rs == null)
			{
				errString = itmDBAccess.getErrorString("","VTSEQ","","",conn);
				return errString;
			}
			else if(rs.next())
			{
				ledgPostConf = checkNull(rs.getString("ledg_post_conf"));
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
			if("Y".equalsIgnoreCase(ledgPostConf.trim()))
			{
				if(!today.equals(tranDate))
				{
					tranDate = today;
					sql = " update pay_ibca  set tran_date = ? 	where tran_id   = ?  "; 
					pstmtUpd = conn.prepareStatement(sql);
					pstmtUpd.setDate(1,tranDate == null?null:new java.sql.Date(tranDate.getTime()) );
					pstmtUpd.setString(2,tranId);
					int i = pstmtUpd.executeUpdate();
					System.out.println("row update into pay_ibca ="+i);
					pstmtUpd.close();
					pstmtUpd = null;
				}
				payIbcaHdr.put("tran_date",tranDate);

			}
			//ls_errcode = gbf_post_pibca(ls_exp_hdr,ls_exp_det,ai_commit)
			//errString = gbfPostPayrIbca(payIbcaHdr,payIbcaDetList,xtraParams,conn);
			if(errString != null && errString.trim().length() > 0)
			{
				return errString;
			}

		} catch (SQLException e) 
		{

			System.out.println("Exception :PerkClaimPos :gbfRetrievePibca :SQLException :==>\n"+e.getMessage());
			e.printStackTrace();
			throw new ITMException(e);
		}
		catch (Exception e) 
		{

			System.out.println("Exception :PerkClaimPos :gbfRetrievePibca :Exception :==>\n"+e.getMessage());
			e.printStackTrace();
			throw new ITMException(e);
		}
		return errString;
	}//gbfRetrievePibca end


	private String gbfPostPayrIbca(HashMap payIbcaHdr,ArrayList payIbcaDetList,String xtraParams ,Connection conn) throws ITMException
	{
		String errString = "",sql = "" , userId = "", chgTerm = "";
		String empCode = "",  confirmed = "" ,transer ="" , refId = "" ,tranId = "" ,refType = "" ,editOption = "0";
		String tranType = "",ledgPostConf = "",linkType = "",payMode = "";
		Date tranDate = null,today = new java.util.Date(),confDate = null ;

		PreparedStatement pstmt = null,pstmtUpd = null,pstmtHdr = null,pstmtInner = null;
		ResultSet rs = null,rsHdr = null,rsInner = null;
		Timestamp currDate = null;
		GenericUtility genericUtility = null;
		FinCommon finCommon = new FinCommon();
		try 
		{
			System.out.println("gbfPostPayrIbca called........... ");
			currDate = new java.sql.Timestamp(System.currentTimeMillis());
			ITMDBAccessEJB itmDBAccess = new ITMDBAccessEJB();
			genericUtility = GenericUtility.getInstance();
			userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode");
			chgTerm = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "chgTerm" );
			System.out.println("payIbca Header = "+payIbcaHdr.toString());
			if(payIbcaHdr == null)
			{
				errString = itmDBAccess.getErrorString("","VTIMP","","",conn);
				return errString;
			}
			else if(payIbcaHdr.size() == 0)
			{
				errString = itmDBAccess.getErrorString("","VTIMPNOREC","","",conn);
				return errString;
			}
			System.out.println("payIbca Detail = "+payIbcaDetList);
			if(payIbcaDetList == null)
			{
				errString = itmDBAccess.getErrorString("","VTIMP","","",conn);
				return errString;
			}
			else if(payIbcaDetList.size() == 0)
			{
				errString = itmDBAccess.getErrorString("","VTIMPNOREC","","",conn);
				return errString;
			}

			tranId = (String)payIbcaHdr.get("tran_id");
			transer = checkNull((String)payIbcaHdr.get("tran_ser"));
			linkType = (String)payIbcaHdr.get("link_type");
			confDate = (Date)payIbcaHdr.get("conf_date");
			empCode = (String)payIbcaHdr.get("emp_code__aprv");
			confirmed = (String)payIbcaHdr.get("confirmed");

			sql = "select edi_option  from transetup where tran_window  = 'w_pay_ibca' ";
			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				editOption = rs.getString("edi_option") == null?"0":rs.getString("edi_option") ;
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;

			if("I".equalsIgnoreCase(transer.trim()))
			{
				// Call the hdr and detail posting for pibca - issue type
				errString = gbfPostPayrIbcaHdrIss(payIbcaHdr,xtraParams,conn);
				System.out.println("3368 errString="+errString);
				if(errString != null && errString.trim().length() > 0)
				{
					return errString;
				}
				errString = gbfPostPayrIbcaDetIss(payIbcaHdr,payIbcaDetList,xtraParams,conn);
				System.out.println("3374 errString="+errString);
				if(errString != null && errString.trim().length() > 0)
				{
					return errString;
				}
				if("E".equalsIgnoreCase(linkType.trim()) || !"0".equalsIgnoreCase(editOption))
				{
					if(!"0".equalsIgnoreCase(editOption))
					{
						payIbcaHdr.put("confirmed","Y");
						payIbcaHdr.put("conf_date",today);
						payIbcaHdr.put("emp_code__aprv",genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginEmpCode"));

					}
					if("2".equalsIgnoreCase(editOption))
					{
						String dataStr = "";
						CreateRCPXML createRCPXML = new CreateRCPXML("w_pay_ibca","tran_id");
						dataStr = createRCPXML.getTranXML( tranId, conn );
						System.out.println( "dataStr =[ "+ dataStr + "]" );
						Document ediDataDom = genericUtility.parseString(dataStr);
						E12CreateBatchLoadEjb e12CreateBatchLoad = new E12CreateBatchLoadEjb();
						String retString = e12CreateBatchLoad.createBatchLoad(ediDataDom, "w_pay_ibca", "0", xtraParams, conn );
						createRCPXML = null;
						e12CreateBatchLoad = null;
						if( retString != null && "SUCCESS".equals(retString) )
						{
							System.out.println("retString from pay voucher = 	["+retString+"]");
						}

					}
					else
					{
						String dataStr = "";
						CreateRCPXML createRCPXML = new CreateRCPXML("w_pay_ibca","tran_id");
						dataStr = createRCPXML.getTranXML( tranId, conn );
						System.out.println( "dataStr =[ "+ dataStr + "]" );
						Document ediDataDom = genericUtility.parseString(dataStr);
						E12CreateBatchLoadEjb e12CreateBatchLoad = new E12CreateBatchLoadEjb();
						String retString = e12CreateBatchLoad.createBatchLoad(ediDataDom, "w_pay_ibca", "0", xtraParams, conn );
						createRCPXML = null;
						e12CreateBatchLoad = null;
						if( retString != null && "SUCCESS".equals(retString) )
						{
							System.out.println("retString from pay voucher = 	["+retString+"]");
						}
					}
				}
			}// Call the hdr and detail posting for pibca - issue type end

			if("R".equalsIgnoreCase(transer.trim()))
			{
				// Call the hdr and detail posting for pibca - receipt type
				//ls_errcode = gbf_post_pibca_hdr_rcp(ls_exp_hdr)
				errString = gbfPostPayrIbcaHdrRcp(payIbcaHdr,xtraParams,conn);
				if(errString != null && errString.trim().length() > 0)
				{
					return errString;
				}
				errString = gbfPostPayrIbcaDetRcp(payIbcaHdr,payIbcaDetList,xtraParams,conn);
				if(errString != null && errString.trim().length() > 0)
				{
					return errString;
				}
				if("E".equalsIgnoreCase(linkType.trim()) || !"0".equalsIgnoreCase(editOption))
				{
					if(!"0".equalsIgnoreCase(editOption))
					{
						payIbcaHdr.put("confirmed","Y");
						payIbcaHdr.put("conf_date",today);
						payIbcaHdr.put("emp_code__aprv",genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginEmpCode"));

					}
					if("2".equalsIgnoreCase(editOption))
					{
						String dataStr = "";
						CreateRCPXML createRCPXML = new CreateRCPXML("w_pay_ibca","tran_id");
						dataStr = createRCPXML.getTranXML( tranId, conn );
						System.out.println( "dataStr =[ "+ dataStr + "]" );
						Document ediDataDom = genericUtility.parseString(dataStr);
						E12CreateBatchLoadEjb e12CreateBatchLoad = new E12CreateBatchLoadEjb();
						String retString = e12CreateBatchLoad.createBatchLoad(ediDataDom, "w_pay_ibca", "0", xtraParams, conn );
						createRCPXML = null;
						e12CreateBatchLoad = null;
						if( retString != null && "SUCCESS".equals(retString) )
						{
							System.out.println("retString from pay voucher = 	["+retString+"]");
						}

					}
					else
					{
						String dataStr = "";
						CreateRCPXML createRCPXML = new CreateRCPXML("w_pay_ibca","tran_id");
						dataStr = createRCPXML.getTranXML( tranId, conn );
						System.out.println( "dataStr =[ "+ dataStr + "]" );
						Document ediDataDom = genericUtility.parseString(dataStr);
						E12CreateBatchLoadEjb e12CreateBatchLoad = new E12CreateBatchLoadEjb();
						String retString = e12CreateBatchLoad.createBatchLoad(ediDataDom, "w_pay_ibca", "0", xtraParams, conn );
						createRCPXML = null;
						e12CreateBatchLoad = null;
						if( retString != null && "SUCCESS".equals(retString) )
						{
							System.out.println("retString from pay voucher = 	["+retString+"]");
						}
					}
				}
			}// // Call the hdr and detail posting for pibca - receipt type



			errString = finCommon.checkGlTranDrCr("P-IBCA",tranId,conn);
			System.out.println("errString in checkGlTranDrCr ::"+errString);

			if(errString != null && errString.trim().length() > 0)
			{
				return errString;
			}

			sql = " update pay_ibca  set confirmed  = 'Y',conf_date = ?, emp_code__aprv = ?	where tran_id   = ?  "; 
			pstmtUpd = conn.prepareStatement(sql);
			pstmtUpd.setDate(1,today == null?null:new java.sql.Date(today.getTime()) );
			pstmtUpd.setString(2,genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginEmpCode"));
			pstmtUpd.setString(3,tranId);
			int i = pstmtUpd.executeUpdate();
			System.out.println("row update into pay_ibca ="+i);
			pstmtUpd.close();
			pstmtUpd = null;


		} catch (SQLException e) 
		{

			System.out.println("Exception :PerkClaimPos :gbfPostPayrIbca :SQLException :==>\n"+e.getMessage());
			e.printStackTrace();
			throw new ITMException(e);
		}
		catch (Exception e) 
		{

			System.out.println("Exception :PerkClaimPos :gbfPostPayrIbca :Exception :==>\n"+e.getMessage());
			e.printStackTrace();
			throw new ITMException(e);
		}
		return errString;
	}//gbfPostPayrIbca end

	private String gbfPostPayrIbcaHdrIss(HashMap payIbcaHdr,String xtraParams ,Connection conn) throws ITMException
	{
		String errString = "",linkType = "";
		String tranType = "",acctCodePay = "",siteCode = "",tranId = "",finEntity = "",cctrCodePay = "";
		String currCode = "",remarks = "",payMode = "";
		double exchRate = 0 , amount = 0;
		Date tranDate = null,today = new java.util.Date(),resiDate = null,effDate = null;
		HashMap glTraceMap = null;
		GenericUtility genericUtility = null;
		FinCommon finCommon = new FinCommon();
		AdmCommon admCommon = null;
		try 
		{
			System.out.println("gbfPostPayrIbcaHdrIss called........... ");
			ITMDBAccessEJB itmDBAccess = new ITMDBAccessEJB();
			genericUtility = GenericUtility.getInstance();
			admCommon = new AdmCommon();
			System.out.println("payVouch Header = "+payIbcaHdr);
			if(payIbcaHdr == null)
			{
				errString = itmDBAccess.getErrorString("","VTIMP","","",conn);
				return errString;
			}
			else if(payIbcaHdr.size() == 0)
			{
				errString = itmDBAccess.getErrorString("","VTIMPNOREC","","",conn);
				return errString;
			}
			glTraceMap = new HashMap();

			linkType = checkNull((String)payIbcaHdr.get("link_type"));
			tranDate = (Date)payIbcaHdr.get("tran_date");
			tranId = (String)payIbcaHdr.get("tran_id");
			effDate = (Date)payIbcaHdr.get("eff_date");
			finEntity = (String)payIbcaHdr.get("fin_entity__from");
			siteCode = (String)payIbcaHdr.get("site_code__from");
			acctCodePay = (String)payIbcaHdr.get("acct_code__ifr");
			cctrCodePay = (String)payIbcaHdr.get("cctr_code__ifr");
			currCode = (String)payIbcaHdr.get("curr_code");
			exchRate = (Double)payIbcaHdr.get("exch_rate");
			amount = (Double)payIbcaHdr.get("amount");
			remarks = (String)payIbcaHdr.get("remarks");

			if(!"R".equalsIgnoreCase(linkType.trim()) || !"C".equalsIgnoreCase(linkType.trim()))
			{
				glTraceMap.put("ref_type", "F");
				glTraceMap.put("ref_ser", "P-IBCA");
				glTraceMap.put("ref_id", tranId);
				// Modified by Piyush on 02/04/2015[To resolve date casting issue on posting].Start
				/*
				glTraceMap.put("tran_date", tranDate);
				glTraceMap.put("eff_date", effDate);
				*/
				glTraceMap.put("tran_date", new Timestamp(tranDate == null ? null : tranDate.getTime()));
				glTraceMap.put("eff_date", new Timestamp(effDate == null ? null : effDate.getTime()));
				// Modified by Piyush on 02/04/2015[To resolve date casting issue on posting].End
				glTraceMap.put("fin_entity", finEntity);
				glTraceMap.put("site_code", siteCode);
				glTraceMap.put("sundry_type", "O");
				glTraceMap.put("sundry_code", null);
				glTraceMap.put("acct_code", acctCodePay);
				glTraceMap.put("cctr_code", cctrCodePay);
				glTraceMap.put("emp_code", null);
				glTraceMap.put("anal_code", null);
				glTraceMap.put("curr_code", currCode);
				glTraceMap.put("exch_rate", exchRate);
				if(amount > 0)
				{
					//glTraceMap.put("dr_amt", 0);
					glTraceMap.put("dr_amt", 0.0);
					glTraceMap.put("cr_amt", amount);
				}
				else
				{
					glTraceMap.put("dr_amt", 0-amount);
					glTraceMap.put("cr_amt", 0.0);
				}

				glTraceMap.put("remarks", remarks);

				errString = finCommon.glTraceUpdate(glTraceMap, conn);
				if(errString != null && errString.trim().length() > 0)
				{
					return errString;
				}
			}

			if("A".equalsIgnoreCase(linkType.trim()))// automatic opp entry posting
			{
				System.out.println("automatic opp entry posting.......");
				//ls_errcode = gbf_post_pibca_hdr_rcp(as_hdrdata)
				errString = gbfPostPayrIbcaHdrIss(payIbcaHdr, xtraParams, conn);
				if(errString != null && errString.trim().length() > 0 )
				{
					return errString;
				}
			}
			else if("P".equalsIgnoreCase(linkType.trim()))// create another ibca
			{
				//ls_errcode = gbf_create_pibca(lst_s_gltrace.ref_id, lst_s_gltrace.ref_id)
				errString = gbfCreatePibca((String)glTraceMap.get("ref_id"), xtraParams, conn);
				if(errString != null && errString.trim().length() > 0 )
				{
					return errString;
				}

			}
			else if("R".equalsIgnoreCase(linkType.trim())) //// opp. entry posting
			{
				//ls_errcode = gbf_post_pibca_hdr_rcp(as_hdrdata)
				errString = gbfPostPayrIbcaHdrRcp(payIbcaHdr, xtraParams, conn);
				if(errString != null && errString.trim().length() > 0 )
				{
					return errString;
				}
			}
			else if("C".equalsIgnoreCase(linkType.trim()))// opp. entry posting
			{
				//ls_errcode = gbf_post_pibca_hdr_rcp(as_hdrdata)
				errString = gbfPostPayrIbcaHdrRcp(payIbcaHdr, xtraParams, conn);
				if(errString != null && errString.trim().length() > 0 )
				{
					return errString;
				}
			}	



		}catch (Exception e) 
		{

			System.out.println("Exception :PerkClaimPos :gbfPostPayrIbcaHdrIss :Exception :==>\n"+e.getMessage());
			e.printStackTrace();
			throw new ITMException(e);
		}
		return errString;
	}//gbfPostPayrIbcaHdrIss end


	private String gbfPostPayrIbcaDetIss(HashMap payIbcaHdr,ArrayList payIbcaDetList,String xtraParams ,Connection conn) throws ITMException
	{
		String errString = "",sql = "" , userId = "", chgTerm = "",finLink = "",linkType = "";
		String empCode = "", loanNo = "", adCode = "", confirmed = "" ,transer ="" , refId = "";
		String tranType = "",ledgPostConf = "",balOpt = "",refSer = "",code = "";
		String status = "",sType = "",sCode = "",finEntity = "",cctrCodePay = "", tranId = "", siteCode = "";
		String entryBatchNo = "",currCode = "",remarks = "",hold = "",keyString = "",refNo = "",payMode = "",bankCode = "";
		int lineNo = 0,count = 0 ;
		double  balanceAmt = 0,amount = 0,adjAmt = 0,billAmt = 0,totalAmt = 0,exchRate = 0;
		Date frDate = null,toDate = null;
		Date tranDate = null,today = new java.util.Date(),effDate = null,interestDate = null;
		HashMap glTraceMap = null, payIbcaDet = null ,sundryBalMap = null;
		PreparedStatement pstmt = null,pstmtUpd = null;
		ResultSet rs = null;
		Timestamp currDate = null;
		GenericUtility genericUtility = null;
		FinCommon finCommon = new FinCommon();
		AdmCommon admCommon = new AdmCommon();
		try 
		{
			System.out.println("gbfPostPayrIbcaDetIss called........... ");
			currDate = new java.sql.Timestamp(System.currentTimeMillis());
			ITMDBAccessEJB itmDBAccess = new ITMDBAccessEJB();
			genericUtility = GenericUtility.getInstance();
			userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode");
			chgTerm = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "chgTerm" );
			System.out.println("payIbca Header = "+payIbcaHdr);
			if(payIbcaHdr == null)
			{
				errString = itmDBAccess.getErrorString("","VTIMP","","",conn);
				return errString;
			}
			else if(payIbcaHdr.size() == 0)
			{
				errString = itmDBAccess.getErrorString("","VTIMPNOREC","","",conn);
				return errString;
			}

			System.out.println("payIbca Detail = "+payIbcaDetList);
			if(payIbcaDetList == null)
			{
				errString = itmDBAccess.getErrorString("","VTIMP","","",conn);
				return errString;
			}
			else if(payIbcaDetList.size() == 0)
			{
				errString = itmDBAccess.getErrorString("","VTIMPNOREC","","",conn);
				return errString;
			}

			finLink = checkNull(admCommon.getEnv("999999","ADM_FIN_LINK",conn));

			if("NULLFOUND".equalsIgnoreCase(finLink))
			{
				errString = itmDBAccess.getErrorString("","VSENVAR1","","",conn);
				return errString;
			}

			tranDate = (Date)payIbcaHdr.get("tran_date");
			tranId = (String)payIbcaHdr.get("tran_id");
			effDate = (Date)payIbcaHdr.get("eff_date");
			finEntity = (String)payIbcaHdr.get("fin_entity__from");
			//tranType = (String)payIbcaHdr.get("tran_type");
			siteCode = (String)payIbcaHdr.get("site_code__from");
			linkType = (String)payIbcaHdr.get("link_type");
			remarks = (String)payIbcaHdr.get("remarks");

			for (int ctr =0; ctr < payIbcaDetList.size(); ctr++)
			{
				if(!"R".equalsIgnoreCase(linkType) || !"C".equalsIgnoreCase(linkType))
				{
					glTraceMap = new HashMap();
					payIbcaDet = new HashMap();
					payIbcaDet = (HashMap)payIbcaDetList.get(ctr);

					totalAmt =  (Double)payIbcaDet.get("tot_amt");
					refNo =  (String)payIbcaDet.get("ref_no");
					refSer =  checkNull((String)payIbcaDet.get("ref_ser"));

					glTraceMap.put("ref_type", "F");
					glTraceMap.put("ref_ser", "P-IBCA");
					glTraceMap.put("ref_id", tranId);
					// Modified by Piyush on 02/04/2015[To resolve date casting issue on posting].Start
					/*
					glTraceMap.put("tran_date", tranDate);
					glTraceMap.put("eff_date", effDate);
					*/
					glTraceMap.put("tran_date", new Timestamp(tranDate == null ? null : tranDate.getTime()));
					glTraceMap.put("eff_date", new Timestamp(effDate == null ? null : effDate.getTime()));
					// Modified by Piyush on 02/04/2015[To resolve date casting issue on posting].End
					glTraceMap.put("fin_entity", finEntity);
					glTraceMap.put("site_code", siteCode);
					glTraceMap.put("sundry_type", (String)payIbcaDet.get("sundry_type"));
					glTraceMap.put("sundry_code", (String)payIbcaDet.get("sundry_code"));
					glTraceMap.put("acct_code", (String)payIbcaDet.get("acct_code"));
					glTraceMap.put("cctr_code", (String)payIbcaDet.get("cctr_code"));
					glTraceMap.put("emp_code", null);
					glTraceMap.put("anal_code",null);
					glTraceMap.put("curr_code",(Double)payIbcaDet.get("curr_code"));
					glTraceMap.put("exch_rate", (Double)payIbcaDet.get("exch_rate"));
					if(totalAmt > 0)
					{
						glTraceMap.put("dr_amt", totalAmt );
						glTraceMap.put("cr_amt", 0.0);
					}
					else
					{
						glTraceMap.put("dr_amt", 0.0);
						glTraceMap.put("cr_amt", 0 - totalAmt );
					}

					glTraceMap.put("remarks", remarks);
					glTraceMap.put("party_doc_ref",finCommon.gfGetPartyDocRef(refSer, refNo,conn) );


					// Populate sundry balance structure /////////////////

					sundryBalMap = new HashMap();
					sundryBalMap.put("tran_date",tranDate);
					sundryBalMap.put("eff_date ",effDate);
					sundryBalMap.put("fin_entity",finEntity);
					sundryBalMap.put("site_code",siteCode);
					sundryBalMap.put("sundry_type",glTraceMap.get("sundry_type"));
					sundryBalMap.put("sundry_code",glTraceMap.get("sundry_code"));
					sundryBalMap.put("acct_code",glTraceMap.get("acct_code"));
					sundryBalMap.put("cctr_code",glTraceMap.get("cctr_code"));
					sundryBalMap.put("curr_code ",glTraceMap.get("curr_code"));
					sundryBalMap.put("exch_rate",glTraceMap.get("exch_rate"));	
					sundryBalMap.put("dr_amt",glTraceMap.get("dr_amt"));
					sundryBalMap.put("cr_amt",glTraceMap.get("cr_amt"));
					sundryBalMap.put("adv_amt",0.0);
					sundryBalMap.put("contact_code",finCommon.getContactCode(sType,sCode,conn));

					errString = finCommon.gbf_sundrybal_upd(sundryBalMap,conn);	
					if(errString != null && errString.trim().length() > 0)
					{
						return errString;
					}
					else
					{
						errString = finCommon.glTraceUpdate(glTraceMap, conn);
						if(errString != null && errString.trim().length() > 0)
						{
							return errString;
						}
					}

					if ("db2".equalsIgnoreCase(CommonConstants.DB_NAME ))
					{
						sql = " SELECT tot_amt,adj_amt 	FROM misc_payables 	WHERE tran_ser = ? and ref_no = ? for update ";
					}

					else if ( "mssql".equalsIgnoreCase(CommonConstants.DB_NAME ))
					{
						sql = " SELECT tot_amt,adj_amt 	FROM misc_payables (updlock) WHERE tran_ser = ? and ref_no = ?  " ;
					}
					else
					{
						sql = " SELECT tot_amt,adj_amt FROM misc_payables 	WHERE tran_ser = ? and ref_no = ? for update nowait  " ;
					}
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, refSer);
					pstmt.setString(2, refNo);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						amount = rs.getDouble("tot_amt");
						adjAmt = rs.getDouble("tran_id");
					}
					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null;
					if(Math.abs(amount - adjAmt) < Math.abs(totalAmt))
					{
						errString = itmDBAccess.getErrorString("","VTBAL1","","",conn);
						return errString;
					}
					adjAmt = adjAmt +  totalAmt ;
					if(amount == adjAmt)
						status = "A";
					else
						status = "P"; 

					sql = " update misc_payables set adj_amt = adj_amt + ? , status = ?,status_date = ? "
							+"	where tran_ser = ? and ref_no = ? "; 
					pstmtUpd = conn.prepareStatement(sql);
					pstmtUpd.setDouble(1, totalAmt);
					pstmtUpd.setString(2,status );
					pstmtUpd.setDate(3,today == null?null:new java.sql.Date(today.getTime()) );
					pstmtUpd.setString(4,refSer);
					pstmtUpd.setString(5,refNo);
					int i = pstmtUpd.executeUpdate();
					System.out.println("row update into misc_payables ="+i);
					pstmtUpd.close();
					pstmtUpd = null;

				}//end if 

			}//end for loop

			// if ibca is for loans related to payroll then update the interest date
			// in the loans table
			if("P-VOUC".equalsIgnoreCase(refSer.trim()) && "Y".equalsIgnoreCase(finLink.trim()))
			{
				sql = "select tran_type, ref_no  from payr_voucher where tran_id = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, refNo);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					tranType = checkNull(rs.getString("tran_type"));
					refNo = checkNull(rs.getString("ref_no"));
				}
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;

				if("LN".equalsIgnoreCase(tranType.trim()))
				{
					sql = "select date__interest  from loans where loan_no = ? ";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, refNo);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						interestDate = rs.getDate("date__interest");
					}
					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null;
					if(interestDate == null)
					{
						sql = "select code, fr_date, to_date  from period 	where ?  between fr_date and to_date";
						pstmt = conn.prepareStatement(sql);
						pstmt.setDate(1,tranDate == null?null:new java.sql.Date(tranDate.getTime()) );
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							code = rs.getString("code");
							frDate = rs.getDate("fr_date");
							toDate = rs.getDate("to_date");
						}
						rs.close();
						rs = null;
						pstmt.close();
						pstmt = null;

						sql = "select count(*) 	where prd_code = ? and emp_code = ? ";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, code);
						pstmt.setString(2, (String)glTraceMap.get("sundry_code"));//discuss  with PB developer
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							count = rs.getInt(1);
						}
						rs.close();
						rs = null;
						pstmt.close();
						pstmt = null;
						if(count > 0)
						{
							frDate = addDays(toDate, 1);
							sql = " select code  from period  where fr_date = ? ";
							pstmt = conn.prepareStatement(sql);
							pstmt.setDate(1,frDate == null?null:new java.sql.Date(frDate.getTime()) );
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								code = rs.getString("code");
							}
							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;
						}

						sql = " update loans set start_reco = ?  where loan_no = ? "; 
						pstmtUpd = conn.prepareStatement(sql);
						pstmtUpd.setDate(1,frDate == null?null:new java.sql.Date(frDate.getTime()) );
						pstmtUpd.setString(2,refNo);
						int i = pstmtUpd.executeUpdate();
						System.out.println("row update into loans ="+i);
						pstmtUpd.close();
						pstmtUpd = null;
						//ls_errcode = nvo_loanchk.gbf_inst_create(ls_refno)
						errString = gbfInstCreate(refNo,xtraParams,conn);
						if(errString != null && errString.trim().length() > 0)
						{
							return errString;
						}

						sql = " update loans set date__interest = ? , start_dedn = 'Y' 	where loan_no = ?  "; 
						pstmtUpd = conn.prepareStatement(sql);
						pstmtUpd.setDate(1,tranDate == null?null:new java.sql.Date(tranDate.getTime()) );
						pstmtUpd.setString(2,refNo);
						i = pstmtUpd.executeUpdate();
						System.out.println("row update into loans ="+i);
						pstmtUpd.close();
						pstmtUpd = null;

					}
				}
			}//in the loans table end
			if("A".equalsIgnoreCase(linkType.trim()))// automatic opp entry posting of detail
			{
				//ls_errcode = gbf_post_pibca_det_rcp(as_hdrdata, as_detdata)
				errString = gbfPostPayrIbcaDetRcp(payIbcaHdr, payIbcaDetList, xtraParams, conn);
				if(errString != null && errString.trim().length() > 0 )
				{
					return errString;
				}
			}
			else if("R".equalsIgnoreCase(linkType.trim()))// opp. entry posting of detail
			{
				//ls_errcode = gbf_post_pibca_det_rcp(as_hdrdata, as_detdata)
				errString = gbfPostPayrIbcaDetRcp(payIbcaHdr, payIbcaDetList, xtraParams, conn);
				if(errString != null && errString.trim().length() > 0 )
				{
					return errString;
				}
			}
			else if("C".equalsIgnoreCase(linkType.trim()))// opp. entry posting of detail
			{
				//ls_errcode = gbf_post_pibca_det_rcp(as_hdrdata, as_detdata)
				errString = gbfPostPayrIbcaDetRcp(payIbcaHdr, payIbcaDetList, xtraParams, conn);
				if(errString != null && errString.trim().length() > 0 )
				{
					return errString;
				}
			}

		} catch (SQLException e) 
		{

			System.out.println("Exception :PerkClaimPos :gbfPostPayrIbcaDetIss :SQLException :==>\n"+e.getMessage());
			e.printStackTrace();
			throw new ITMException(e);
		}
		catch (Exception e) 
		{

			System.out.println("Exception :PerkClaimPos :gbfPostPayrIbcaDetIss :Exception :==>\n"+e.getMessage());
			e.printStackTrace();
			throw new ITMException(e);
		}
		return errString;
	}//gbfPostPayrIbcaDetIss end

	private String gbfPostPayrIbcaHdrRcp(HashMap payIbcaHdr,String xtraParams ,Connection conn) throws ITMException
	{
		String errString = "",currCode = "",remarks = "",payMode = "";
		String tranType = "",acctCodePay = "",siteCode = "",tranId = "",finEntity = "",cctrCodePay = "";
		double exchRate = 0 , amount = 0;
		Date tranDate = null,today = new java.util.Date(),effDate = null;
		HashMap glTraceMap = null;
		GenericUtility genericUtility = null;
		FinCommon finCommon = new FinCommon();
		try 
		{
			System.out.println("gbfPostPayrIbcaHdrRcp called........... ");
			ITMDBAccessEJB itmDBAccess = new ITMDBAccessEJB();
			genericUtility = GenericUtility.getInstance();
			System.out.println("payVouch Header = "+payIbcaHdr);
			if(payIbcaHdr == null)
			{
				errString = itmDBAccess.getErrorString("","VTIMP","","",conn);
				return errString;
			}
			else if(payIbcaHdr.size() == 0)
			{
				errString = itmDBAccess.getErrorString("","VTIMPNOREC","","",conn);
				return errString;
			}
			glTraceMap = new HashMap();


			tranDate = (Date)payIbcaHdr.get("tran_date");
			tranId = (String)payIbcaHdr.get("tran_id");

			effDate = (Date)payIbcaHdr.get("eff_date");
			finEntity = (String)payIbcaHdr.get("fin_entity__to");
			siteCode = (String)payIbcaHdr.get("site_code__to");
			acctCodePay = (String)payIbcaHdr.get("acct_code__ito");
			cctrCodePay = (String)payIbcaHdr.get("cctr_code__ito");
			currCode = (String)payIbcaHdr.get("curr_code");
			exchRate = (Double)payIbcaHdr.get("exch_rate");
			amount = (Double)payIbcaHdr.get("amount");
			remarks = (String)payIbcaHdr.get("remarks");

			glTraceMap.put("ref_type", "F");
			glTraceMap.put("ref_ser", "P-IBCA");
			glTraceMap.put("ref_id", tranId);
			// Modified by Piyush on 02/04/2015[To resolve date casting issue on posting].Start
			/*
			glTraceMap.put("tran_date", tranDate);
			glTraceMap.put("eff_date", effDate);
			*/
			glTraceMap.put("tran_date", new Timestamp(tranDate == null ? null : tranDate.getTime()));
			glTraceMap.put("eff_date", new Timestamp(effDate == null ? null : effDate.getTime()));
			// Modified by Piyush on 02/04/2015[To resolve date casting issue on posting].End
			glTraceMap.put("fin_entity", finEntity);
			glTraceMap.put("site_code", siteCode);
			glTraceMap.put("sundry_type", "O");
			glTraceMap.put("sundry_code", null);
			glTraceMap.put("acct_code", acctCodePay);
			glTraceMap.put("cctr_code", cctrCodePay);
			glTraceMap.put("emp_code", null);
			glTraceMap.put("anal_code", null);
			glTraceMap.put("curr_code", currCode);
			glTraceMap.put("exch_rate", exchRate);
			if(amount > 0)
			{
				glTraceMap.put("dr_amt", amount	);
				glTraceMap.put("cr_amt", 0.0);
			}
			else
			{
				glTraceMap.put("dr_amt", 0.0);
				glTraceMap.put("cr_amt", 0 - amount);
			}
			glTraceMap.put("remarks", remarks);
			errString = finCommon.glTraceUpdate(glTraceMap, conn);
			if(errString != null && errString.trim().length() > 0)
			{
				return errString;
			}

		}catch (Exception e) 
		{

			System.out.println("Exception :PerkClaimPos :gbfPostPayrIbcaHdrRcp :Exception :==>\n"+e.getMessage());
			e.printStackTrace();
			throw new ITMException(e);
		}
		return errString;
	}//gbfPostPayrIbcaHdrRcp end


	private String gbfPostPayrIbcaDetRcp(HashMap payIbcaHdr,ArrayList payIbcaDetList,String xtraParams ,Connection conn) throws ITMException
	{
		String errString = "",sql = "" , userId = "", chgTerm = "",finLink = "",linkType = "";
		String empCode = "", loanNo = "", adCode = "", confirmed = "" ,transer ="" , refId = "";
		String tranType = "",ledgPostConf = "",balOpt = "",refSer = "",code = "";
		String status = "",sType = "",sCode = "",finEntity = "",cctrCodePay = "", tranId = "", siteCode = "";
		String entryBatchNo = "",currCode = "",remarks = "",hold = "",keyString = "",refNo = "",payMode = "",bankCode = "";
		int lineNo = 0,count = 0 ;
		double  balanceAmt = 0,amount = 0,adjAmt = 0,billAmt = 0,totalAmt = 0,exchRate = 0;
		Date frDate = null,toDate = null;
		Date tranDate = null,today = new java.util.Date(),effDate = null,interestDate = null;
		HashMap glTraceMap = null, payIbcaDet = null ,sundryBalMap = null,miscPayMap = null;;
		PreparedStatement pstmt = null,pstmtUpd = null;
		ResultSet rs = null;
		Timestamp currDate = null;
		GenericUtility genericUtility = null;
		FinCommon finCommon = new FinCommon();
		DistCommon distCommon = new DistCommon();
		AdmCommon admCommon = new AdmCommon();
		try 
		{
			System.out.println("gbfPostPayrIbcaDetRcp called........... ");
			currDate = new java.sql.Timestamp(System.currentTimeMillis());
			ITMDBAccessEJB itmDBAccess = new ITMDBAccessEJB();
			genericUtility = GenericUtility.getInstance();
			userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode");
			chgTerm = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "chgTerm" );
			System.out.println("payIbca Header = "+payIbcaHdr);
			if(payIbcaHdr == null)
			{
				errString = itmDBAccess.getErrorString("","VTIMP","","",conn);
				return errString;
			}
			else if(payIbcaHdr.size() == 0)
			{
				errString = itmDBAccess.getErrorString("","VTIMPNOREC","","",conn);
				return errString;
			}

			System.out.println("payIbca Detail = "+payIbcaDetList);
			if(payIbcaDetList == null)
			{
				errString = itmDBAccess.getErrorString("","VTIMP","","",conn);
				return errString;
			}
			else if(payIbcaDetList.size() == 0)
			{
				errString = itmDBAccess.getErrorString("","VTIMPNOREC","","",conn);
				return errString;
			}

			finLink = checkNull(admCommon.getEnv("999999","ADM_FIN_LINK",conn));

			if("NULLFOUND".equalsIgnoreCase(finLink))
			{
				errString = itmDBAccess.getErrorString("","VSENVAR1","","",conn);
				return errString;
			}
			tranType = (String)payIbcaHdr.get("tran_type");
			tranDate = (Date)payIbcaHdr.get("tran_date");
			tranId = (String)payIbcaHdr.get("tran_id");
			effDate = (Date)payIbcaHdr.get("eff_date");
			finEntity = (String)payIbcaHdr.get("fin_entity__to");
			siteCode = (String)payIbcaHdr.get("site_code__to");
			remarks = (String)payIbcaHdr.get("remarks");

			for (int ctr =0; ctr < payIbcaDetList.size(); ctr++)
			{

				glTraceMap = new HashMap();
				payIbcaDet = new HashMap();
				payIbcaDet = (HashMap)payIbcaDetList.get(ctr);

				totalAmt =  (Double)payIbcaDet.get("tot_amt");
				refNo =  (String)payIbcaDet.get("ref_no");
				refSer =  checkNull((String)payIbcaDet.get("ref_ser"));

				glTraceMap.put("ref_type", "F");
				glTraceMap.put("ref_ser", "P-IBCA");
				glTraceMap.put("ref_id", tranId);
				// Modified by Piyush on 02/04/2015[To resolve date casting issue on posting].Start
				/*
				glTraceMap.put("tran_date", tranDate);
				glTraceMap.put("eff_date", effDate);
				*/
				glTraceMap.put("tran_date", new Timestamp(tranDate == null ? null : tranDate.getTime()));
				glTraceMap.put("eff_date", new Timestamp(effDate == null ? null : effDate.getTime()));
				// Modified by Piyush on 02/04/2015[To resolve date casting issue on posting].End
				glTraceMap.put("fin_entity", finEntity);
				glTraceMap.put("site_code", siteCode);
				glTraceMap.put("sundry_type", (String)payIbcaDet.get("sundry_type"));
				glTraceMap.put("sundry_code", (String)payIbcaDet.get("sundry_code"));
				glTraceMap.put("acct_code", (String)payIbcaDet.get("acct_code"));
				glTraceMap.put("cctr_code", (String)payIbcaDet.get("cctr_code"));
				glTraceMap.put("emp_code", null);
				glTraceMap.put("anal_code",null);
				glTraceMap.put("curr_code",(Double)payIbcaDet.get("curr_code"));
				glTraceMap.put("exch_rate", (Double)payIbcaDet.get("exch_rate"));
				if(totalAmt > 0)
				{
					glTraceMap.put("dr_amt", 0.0 );
					glTraceMap.put("cr_amt", totalAmt);
				}
				else
				{
					glTraceMap.put("dr_amt", 0- totalAmt);
					glTraceMap.put("cr_amt", 0.0 );
				}

				glTraceMap.put("remarks", remarks);
				glTraceMap.put("party_doc_ref",finCommon.gfGetPartyDocRef(refSer, refNo,conn) );

				// Populate sundry balance structure /////////////////

				sundryBalMap = new HashMap();
				sundryBalMap.put("tran_date",tranDate);
				sundryBalMap.put("eff_date ",effDate);
				sundryBalMap.put("fin_entity",finEntity);
				sundryBalMap.put("site_code",siteCode);
				sundryBalMap.put("sundry_type",glTraceMap.get("sundry_type"));
				sundryBalMap.put("sundry_code",glTraceMap.get("sundry_code"));
				sundryBalMap.put("acct_code",glTraceMap.get("acct_code"));
				sundryBalMap.put("cctr_code",glTraceMap.get("cctr_code"));
				sundryBalMap.put("curr_code ",glTraceMap.get("curr_code"));
				sundryBalMap.put("exch_rate",glTraceMap.get("exch_rate"));	
				sundryBalMap.put("dr_amt",glTraceMap.get("dr_amt"));
				sundryBalMap.put("cr_amt",glTraceMap.get("cr_amt"));
				sundryBalMap.put("adv_amt",0.0);

				// insert into misc_payables

				sql = "select count(*)  from misc_payables where tran_ser  like 'P-IBC%' 	AND REF_NO = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, refNo);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					count = rs.getInt(1);
				}
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;
				if(count == 0)
				{
					refSer = "P-IBCA";
				}
				else
				{
					refSer ="P-IBC"+String.valueOf(count);
				}

				miscPayMap = new HashMap();

				miscPayMap.put("tran_ser",refSer);
				miscPayMap.put("tran_date",tranDate);
				miscPayMap.put("ref_no",refNo);
				miscPayMap.put("ref_date",(Date)payIbcaDet.get("ref_date"));
				miscPayMap.put("bill_no",(String)payIbcaDet.get("bill_no"));
				miscPayMap.put("bill_date",(Date)payIbcaDet.get("bill_date"));
				miscPayMap.put("curr_code",(String)payIbcaDet.get("curr_code"));
				miscPayMap.put("exch_rate",(Double)payIbcaDet.get("exch_rate"));
				miscPayMap.put("sundry_type",glTraceMap.get("sundry_type"));
				miscPayMap.put("sundry_code",glTraceMap.get("sundry_code"));
				miscPayMap.put("acct_code",glTraceMap.get("acct_code"));
				miscPayMap.put("cctr_code",glTraceMap.get("cctr_code"));
				miscPayMap.put("due_date",(Date)payIbcaDet.get("due_date"));
				miscPayMap.put("site_code",siteCode);
				miscPayMap.put("fin_entity",finEntity);
				miscPayMap.put("tot_amt",(Double)payIbcaDet.get("tot_amt"));
				miscPayMap.put("bank_code",(String)payIbcaDet.get("bank_code")); 
				miscPayMap.put("auto_pay",(String)payIbcaDet.get("auto_pay"));
				miscPayMap.put("pay_mode",(String)payIbcaDet.get("pay_mode"));
				miscPayMap.put("paid","N");
				miscPayMap.put("adv_amt",(Double)payIbcaDet.get("adv_amt"));
				miscPayMap.put("tds_amt",(Double)payIbcaDet.get("tds_amt"));
				miscPayMap.put("supp_bill_amt",(Double)payIbcaDet.get("supp_bill_amt"));
				miscPayMap.put("entry_batch_no",(String)payIbcaDet.get("entry_batch_no"));
				miscPayMap.put("purc_order",(String)payIbcaDet.get("purc_order"));
				miscPayMap.put("ref_ser__org",(String)payIbcaDet.get("ref_ser__org"));

				errString = finCommon.gbf_sundrybal_upd(sundryBalMap,conn);	
				if(errString != null && errString.trim().length() > 0)
				{
					return errString;
				}
				else
				{
					errString = finCommon.glTraceUpdate(glTraceMap, conn);
					if(errString != null && errString.trim().length() > 0)
					{
						return errString;
					}
					else
					{
						errString = finCommon.gbfMiscPayUpd(miscPayMap,conn);	
						if(errString != null && errString.trim().length() > 0)
						{
							return errString;
						}
					}
				}
			}//end for loop



		} catch (SQLException e) 
		{

			System.out.println("Exception :PerkClaimPos :gbfPostPayrIbcaDetRcp :SQLException :==>\n"+e.getMessage());
			e.printStackTrace();
			throw new ITMException(e);
		}
		catch (Exception e) 
		{

			System.out.println("Exception :PerkClaimPos :gbfPostPayrIbcaDetRcp :Exception :==>\n"+e.getMessage());
			e.printStackTrace();
			throw new ITMException(e);
		}
		return errString;
	}//gbfPostPayrIbcaDetRcp end


	private String gbfCreatePibca(String tranId,String xtraParams ,Connection conn) throws ITMException
	{
		String errString = "",sql = "",xmlValues =	"",keyString = "",finEntityFr = "",finEntityTo = "";
		String tranType = "",autoConfirm = "",siteCodeTo = "",siteCodeFr = "",linkType = "",siteCode = "",generateTranId = "";
		String userId = "",chgTerm = "";
		int count = 0 ;
		Date tranDate = null,today = new java.util.Date();
		HashMap payIbcaHdr = null;
		HashMap payIbcaDet = null;
		ArrayList payIbcaDetList = new ArrayList();
		PreparedStatement pstmt = null,pstmtUpd = null;
		ResultSet rs = null;
		//Timestamp currDate = null;
		GenericUtility genericUtility = null;
		try 
		{
			System.out.println("gbfCreatePibca called........... ");
			//currDate = new java.sql.Timestamp(System.currentTimeMillis());
			ITMDBAccessEJB itmDBAccess = new ITMDBAccessEJB();
			genericUtility = GenericUtility.getInstance();
			userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode");
			chgTerm = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "chgTerm" );
			siteCode = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginSiteCode" );

			sql = "select key_string  from transetup where upper(tran_window) = 'W_PAY_IBCA' ";
			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			if(rs == null)
			{

				sql = " select key_string  from transetup where upper(tran_window) = 'GENERAL' ";
				pstmt = conn.prepareStatement(sql);
				rs = pstmt.executeQuery();
				if (rs.next())
				{
					keyString = rs.getString("key_string");

				}

			}
			else if (rs.next())
			{
				keyString = rs.getString("key_string");

			}
			rs.close();rs = null;
			pstmt.close();pstmt = null;

			sql = " select count(*) from pay_ibca where tran_id = ? and upper(confirmed) <> 'Y' ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, tranId);
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				count = rs.getInt(1);

			}
			rs.close();rs = null;
			pstmt.close();pstmt = null;
			if(count > 0)
			{


				sql = " select tran_id from pay_ibca where tran_id = ? and upper(confirmed) <> 'Y' ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, tranId);
				rs = pstmt.executeQuery();
				if (rs.next())
				{
					tranId = rs.getString("tran_id");

				}
				rs.close();rs = null;
				pstmt.close();pstmt = null;


				/*System.out.println("keyString :"+keyString);
			SimpleDateFormat sdfAppl = new SimpleDateFormat(genericUtility.getApplDateFormat());
			String tranDateStr = sdfAppl.format(tranDate);

			xmlValues ="<?xml version=\"1.0\" encoding=\"utf-8\"?><Root>";
			xmlValues = xmlValues + "<Header></Header>";
			xmlValues = xmlValues + "<Detail1>";
			xmlValues = xmlValues +		"<tran_id></tran_id>";
			xmlValues = xmlValues +		"<site_code>" + siteCode + "</site_code>";
			xmlValues = xmlValues +		"<tran_date>" + tranDateStr + "</tran_date>"; 
			xmlValues = xmlValues + "</Detail1></Root>";
			System.out.println("xmlValues  :["+xmlValues+"]");
			TransIDGenerator tg = new TransIDGenerator(xmlValues, "BASE", CommonConstants.DB_NAME);
			refNo = tg.generateTranSeqID("P-IBCA", "tran_id", keyString, conn);
			//refNo  = generateTranId( "t_miscpay_ref", siteCode, tranDateStr, conn );
				 */


				sql = " SELECT tran_id,tran_ser,tran_id__iss,tran_type,tran_date,eff_date,site_code__from,"
						+" fin_entity__from,site_code__to,fin_entity__to,acct_code__ifr,cctr_code__ifr,acct_code__ito,"
						+" cctr_code__ito,amount,curr_code,link_type,confirmed,conf_date,emp_code__aprv,amount__bc,"
						+" chg_date,chg_user,chg_term,add_date,add_user,add_term, exch_rate,remarks,sundry_type,sundry_code "
						+" FROM pay_ibca WHERE  tran_id =  ?  ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, tranId);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					payIbcaHdr = new HashMap();
					payIbcaHdr.put("tran_id",rs.getString("tran_id"));
					payIbcaHdr.put("tran_ser",rs.getString("tran_ser"));
					payIbcaHdr.put("tran_id__iss",rs.getString("tran_id__iss"));
					payIbcaHdr.put("tran_type",rs.getString("tran_type"));
					payIbcaHdr.put("tran_date",rs.getDate("tran_date"));
					payIbcaHdr.put("eff_date",rs.getDate("eff_date"));
					payIbcaHdr.put("site_code__from",rs.getString("site_code__from"));
					payIbcaHdr.put("fin_entity__from",rs.getString("fin_entity__from"));
					payIbcaHdr.put("site_code__to",rs.getString("site_code__to"));
					payIbcaHdr.put("fin_entity__to",rs.getString("fin_entity__to"));
					payIbcaHdr.put("acct_code__ifr",rs.getString("acct_code__ifr"));
					payIbcaHdr.put("cctr_code__ifr",rs.getString("cctr_code__ifr"));
					payIbcaHdr.put("acct_code__ito",rs.getString("acct_code__ito"));
					payIbcaHdr.put("cctr_code__ito",rs.getString("cctr_code__ito"));
					payIbcaHdr.put("amount",rs.getDouble("amount"));
					payIbcaHdr.put("curr_code",rs.getString("curr_code"));
					payIbcaHdr.put("link_type",rs.getString("link_type"));
					payIbcaHdr.put("confirmed",rs.getString("confirmed"));
					payIbcaHdr.put("conf_date",rs.getDate("conf_date"));
					payIbcaHdr.put("emp_code__aprv",rs.getString("emp_code__aprv"));
					payIbcaHdr.put("amount__bc",rs.getDouble("amount__bc"));
					payIbcaHdr.put("chg_date",rs.getDate("chg_date"));
					payIbcaHdr.put("chg_user",rs.getString("chg_user"));
					payIbcaHdr.put("chg_term",rs.getString("chg_term"));
					payIbcaHdr.put("add_date",rs.getDate("add_date"));
					payIbcaHdr.put("add_user",rs.getString("add_user"));
					payIbcaHdr.put("add_term",rs.getString("add_term"));
					payIbcaHdr.put("exch_rate",rs.getDouble("exch_rate"));
					payIbcaHdr.put("remarks",rs.getString("remarks"));
					payIbcaHdr.put("sundry_type",rs.getString("sundry_type"));
					payIbcaHdr.put("sundry_code",rs.getString("sundry_code"));
					System.out.println("payIbcaHdr="+payIbcaHdr);
				}
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;

				sql = " SELECT tran_id,ref_ser,ref_no,ref_date,curr_code,acct_code,cctr_code,due_date,tot_amt,"
						+" discount,tax_amt,auto_pay,bank_code,ref_type,cr_term,bill_no,bill_date,sundry_type,"
						+" sundry_code,pay_mode,exch_rate,entry_batch_no,purc_order,supp_bill_amt,adv_amt,tds_amt,"
						+"  ref_ser__org   FROM pay_ibca_det WHERE  tran_id = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, tranId);
				rs = pstmt.executeQuery();
				while(rs.next())
				{
					payIbcaDet = new HashMap();
					payIbcaDet.put("tran_id",rs.getString("tran_id"));
					payIbcaDet.put("ref_ser",rs.getString("ref_ser"));
					payIbcaDet.put("ref_no",rs.getString("ref_no"));
					payIbcaDet.put("ref_date",rs.getDate("ref_date"));
					payIbcaDet.put("curr_code",rs.getString("curr_code"));
					payIbcaDet.put("acct_code",rs.getString("acct_code"));
					payIbcaDet.put("cctr_code",rs.getString("cctr_code"));
					payIbcaDet.put("due_date",rs.getDate("due_date"));
					payIbcaDet.put("tot_amt",rs.getDouble("tot_amt"));
					payIbcaDet.put("discount",rs.getDouble("discount"));
					payIbcaDet.put("tax_amt",rs.getDouble("tax_amt"));
					payIbcaDet.put("auto_pay",rs.getString("auto_pay"));
					payIbcaDet.put("bank_code",rs.getString("bank_code"));
					payIbcaDet.put("ref_type",rs.getString("ref_type"));
					payIbcaDet.put("cr_term",rs.getString("cr_term"));
					payIbcaDet.put("bill_no",rs.getString("bill_no"));
					payIbcaDet.put("bill_date",rs.getDate("bill_date"));
					payIbcaDet.put("sundry_type",rs.getString("sundry_type"));
					payIbcaDet.put("sundry_code",rs.getString("sundry_code"));
					payIbcaDet.put("pay_mode",rs.getString("pay_mode"));
					payIbcaDet.put("entry_batch_no",rs.getString("entry_batch_no"));
					payIbcaDet.put("exch_rate",rs.getDouble("exch_rate"));
					payIbcaDet.put("purc_order",rs.getString("purc_order"));
					payIbcaDet.put("supp_bill_amt",rs.getDouble("supp_bill_amt"));
					payIbcaDet.put("adv_amt",rs.getDouble("adv_amt"));
					payIbcaDet.put("tds_amt",rs.getDouble("tds_amt"));
					payIbcaDet.put("ref_ser__org",rs.getString("ref_ser__org"));
					System.out.println("payIbcaDet ="+payIbcaDet);
					payIbcaDetList.add(payIbcaDet);
				}
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;


				tranType = (String)payIbcaHdr.get("tran_ser");
				linkType = (String)payIbcaHdr.get("link_type");
				siteCodeFr = (String)payIbcaHdr.get("site_code__from");
				siteCodeTo = (String)payIbcaHdr.get("site_code__to");
				finEntityFr = (String)payIbcaHdr.get("fin_entity__from");
				finEntityTo = (String)payIbcaHdr.get("fin_entity__to");

				System.out.println("keyString :"+keyString);
				SimpleDateFormat sdfAppl = new SimpleDateFormat(genericUtility.getApplDateFormat());
				String tranDateStr = sdfAppl.format(today);

				xmlValues ="<?xml version=\"1.0\" encoding=\"utf-8\"?><Root>";
				xmlValues = xmlValues + "<Header></Header>";
				xmlValues = xmlValues + "<Detail1>";
				xmlValues = xmlValues +		"<tran_id></tran_id>";
				xmlValues = xmlValues +		"<site_code>" + siteCode + "</site_code>";
				xmlValues = xmlValues +		"<tran_date>" + tranDateStr + "</tran_date>"; 
				xmlValues = xmlValues + "</Detail1></Root>";
				System.out.println("xmlValues  :["+xmlValues+"]");
				TransIDGenerator tg = new TransIDGenerator(xmlValues, "BASE", CommonConstants.DB_NAME);
				generateTranId = tg.generateTranSeqID("P-IBCA", "tran_id", keyString, conn);
				//generateTranId  = generateTranId( "t_miscpay_ref", siteCode, tranDateStr, conn );
				sql = " insert into  pay_ibca (tran_id,tran_ser,tran_id__iss,tran_type,tran_date,eff_date,site_code__from,"
						+" fin_entity__from,site_code__to,fin_entity__to,acct_code__ifr,cctr_code__ifr,acct_code__ito, cctr_code__ito,"
						+"	amount,curr_code,link_type,confirmed,conf_date,emp_code__aprv,amount__bc, "
						+"	chg_date,chg_user,chg_term,add_date,add_user,add_term, exch_rate,"
						+"	remarks,sundry_type,sundry_code )  "
						+"	values (?,?,?,?,?,  ?,?,?,?,?,  ?,?,?,?,?,   ?,?,?,?,?,  ?,?,?,?,?, ?,?,?,?,?, ?   ) "; 
				pstmtUpd = conn.prepareStatement(sql);
				pstmtUpd.setString(1,generateTranId);
				pstmtUpd.setString(2,"R");
				pstmtUpd.setString(3,tranId);
				pstmtUpd.setString(4,(String)payIbcaHdr.get("tran_type"));
				Date temp = (Date)payIbcaHdr.get("tran_type");
				pstmtUpd.setDate(5,temp == null?null:new java.sql.Date(temp.getTime()) );
				temp = (Date)payIbcaHdr.get("eff_date");
				pstmtUpd.setDate(6,temp == null?null:new java.sql.Date(temp.getTime()) );
				pstmtUpd.setString(7,(String)payIbcaHdr.get("site_code__from"));

				pstmtUpd.setString(8,(String)payIbcaHdr.get("fin_entity__from"));
				pstmtUpd.setString(9,(String)payIbcaHdr.get("site_code__to"));
				pstmtUpd.setString(10,(String)payIbcaHdr.get("fin_entity__to"));
				pstmtUpd.setString(11,(String)payIbcaHdr.get("acct_code__ifr"));
				pstmtUpd.setString(12,(String)payIbcaHdr.get("cctr_code__ifr"));
				pstmtUpd.setString(13,(String)payIbcaHdr.get("acct_code__ito"));
				pstmtUpd.setString(14,(String)payIbcaHdr.get("cctr_code__ito"));

				pstmtUpd.setDouble(15,(Double)payIbcaHdr.get("amount"));
				pstmtUpd.setString(16,(String)payIbcaHdr.get("curr_code"));
				pstmtUpd.setString(17,"R");
				pstmtUpd.setString(18,(String)payIbcaHdr.get("confirmed"));
				temp = (Date)payIbcaHdr.get("conf_date");
				pstmtUpd.setDate(19,temp == null?null:new java.sql.Date(temp.getTime()) );
				pstmtUpd.setString(20,(String)payIbcaHdr.get("emp_code__aprv"));
				pstmtUpd.setDouble(21,(Double)payIbcaHdr.get("amount__bc"));

				pstmtUpd.setDate(22,new java.sql.Date(today.getTime()) );
				pstmtUpd.setString(23,userId);
				pstmtUpd.setString(24,chgTerm);
				temp = (Date)payIbcaHdr.get("add_date");
				pstmtUpd.setDate(25,temp == null?null:new java.sql.Date(temp.getTime()));
				pstmtUpd.setString(26,(String)payIbcaHdr.get("add_user"));
				pstmtUpd.setString(27,(String)payIbcaHdr.get("add_term"));
				pstmtUpd.setDouble(28,(Double)payIbcaHdr.get("exch_rate"));

				pstmtUpd.setString(29,(String)payIbcaHdr.get("remarks"));
				pstmtUpd.setString(30,(String)payIbcaHdr.get("sundry_type"));
				pstmtUpd.setString(31,(String)payIbcaHdr.get("sundry_code"));
				int i = pstmtUpd.executeUpdate();
				System.out.println("row insert into pay_ibca ="+i);
				pstmtUpd.close();
				pstmtUpd = null;

				if(i > 0)
				{
					for (int ctr =0; ctr < payIbcaDetList.size(); ctr++)
					{
						payIbcaDet = new HashMap();
						payIbcaDet = (HashMap)payIbcaDetList.get(ctr);
						//refNo =  (String)payIbcaDet.get("ref_no");
						sql = " insert into pay_ibca_det(tran_id,ref_ser,ref_no,ref_date,curr_code,acct_code,cctr_code,"
								+" due_date,tot_amt,discount,tax_amt,auto_pay,bank_code,ref_type,"
								+" cr_term,bill_no,bill_date,sundry_type, sundry_code,pay_mode,exch_rate,"
								+" entry_batch_no,purc_order,supp_bill_amt,adv_amt,tds_amt,ref_ser__org)"            
								+" values(?,?,?,?,?,   ?,?,?,?,?,   ?,?,?,?,?,    ?,?,?,?,?,    ?,?,?,?,?,  ?,?)";

						pstmtUpd = conn.prepareStatement(sql);
						pstmtUpd.setString(1,generateTranId);
						pstmtUpd.setString(2,(String)payIbcaDet.get("ref_ser"));
						pstmtUpd.setString(3,(String)payIbcaDet.get("ref_no"));
						temp = (Date)payIbcaDet.get("ref_date");
						pstmtUpd.setDate(4,temp == null?null:new java.sql.Date(temp.getTime()) );
						pstmtUpd.setString(5,(String)payIbcaDet.get("curr_code"));
						pstmtUpd.setString(6,(String)payIbcaDet.get("acct_code"));
						pstmtUpd.setString(7,(String)payIbcaDet.get("cctr_code"));

						temp = (Date)payIbcaDet.get("due_date");
						pstmtUpd.setDate(8,temp == null?null:new java.sql.Date(temp.getTime()) );
						pstmtUpd.setDouble(9,(Double)payIbcaHdr.get("tot_amt"));
						pstmtUpd.setDouble(10,(Double)payIbcaHdr.get("discount"));
						pstmtUpd.setDouble(11,(Double)payIbcaHdr.get("tax_amt"));
						pstmtUpd.setString(12,(String)payIbcaDet.get("auto_pay"));
						pstmtUpd.setString(13,(String)payIbcaDet.get("bank_code"));
						pstmtUpd.setString(14,(String)payIbcaDet.get("ref_type"));

						pstmtUpd.setString(15,(String)payIbcaDet.get("cr_term"));
						pstmtUpd.setString(16,(String)payIbcaDet.get("bill_no"));
						temp = (Date)payIbcaDet.get("bill_date");
						pstmtUpd.setDate(17,temp == null?null:new java.sql.Date(temp.getTime()) );
						pstmtUpd.setString(18,(String)payIbcaDet.get("sundry_type"));
						pstmtUpd.setString(19,(String)payIbcaDet.get("sundry_code"));
						pstmtUpd.setString(20,(String)payIbcaDet.get("pay_mode"));
						pstmtUpd.setDouble(21,(Double)payIbcaHdr.get("exch_rate"));

						pstmtUpd.setString(22,(String)payIbcaDet.get("entry_batch_no"));
						pstmtUpd.setString(23,(String)payIbcaDet.get("purc_order"));
						pstmtUpd.setDouble(24,(Double)payIbcaHdr.get("supp_bill_amt"));
						pstmtUpd.setDouble(25,(Double)payIbcaHdr.get("adv_amt"));
						pstmtUpd.setDouble(26,(Double)payIbcaHdr.get("tds_amt"));
						pstmtUpd.setString(27,(String)payIbcaDet.get("ref_ser__org"));
						i = pstmtUpd.executeUpdate();
						System.out.println("row insert into pay_ibca_det ="+i);
						pstmtUpd.close();
						pstmtUpd = null;

					}
				}

				sql = " select 	case when auto_confirm is null then 'N' else auto_confirm end case from   IBCA_PAY_CTRL "
						+"	where  site_code__from  = ? and site_code__to = ?  and  fin_entity__from  = ? and  fin_entity__to  = ? 	and  link_type   = 'P' ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, siteCodeFr);
				pstmt.setString(2, siteCodeTo);
				pstmt.setString(3, finEntityFr);
				pstmt.setString(4, finEntityTo);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					autoConfirm = rs.getString(1);
				}
				else
				{
					autoConfirm = "N";
				}
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;
				if("Y".equalsIgnoreCase(autoConfirm.trim()))
				{
					errString = gbfRetrievePibca(tranId, siteCodeFr, xtraParams, conn);
					if(errString != null && errString.trim().length() > 0)
					{
						return errString;
					}
				}

			}//end if
			else
			{
				errString = itmDBAccess.getErrorString("","VTIMP","","",conn);
				return errString;
			}

		} catch (SQLException e) 
		{

			System.out.println("Exception :PerkClaimPos :gbfCreatePibca :SQLException :==>\n"+e.getMessage());
			e.printStackTrace();
			throw new ITMException(e);
		}
		catch (Exception e) 
		{

			System.out.println("Exception :PerkClaimPos :gbfCreatePibca :Exception :==>\n"+e.getMessage());
			e.printStackTrace();
			throw new ITMException(e);
		}
		return errString;
	}//gbfCreatePibca end


	//gbfRetrieveMiscVou alredy migraded 
	/*String gbfRetrieveMiscVou(String tranIdFr,String tranIdTo,String warning,String siteCode,String xtraParams ,Connection conn) throws ITMException
	{
		String errString = "",sql = "" , userId = "", chgTerm = "";
		String empCode = "", loanNo = "", adCode = "", confirmed = "" ,transer ="" , refNo = "";
		String sundryType = "",sundryCode = "", status = "";
		String tranId = "",tranId1 = "",tranType = "",winName = "",ledgPostConf = "",acctCode = "",cctrCode = "";
		String taxRecoCctr = "",taxRecoAcct = "", rndOff = "";
		int lineNo = 0,count = 0 ,rndTo = 0,maxLine =0;
		double  recoAmt = 0,balanceAmt = 0,amount = 0;
		double advAmt = 0,billAmt = 0,totalAmt = 0,netAmt = 0,taxAmt = 0,sumRecoAmt = 0,sumTaxAmt = 0; 
		Date recoDate = null, startDate = null,  confDate = null ,refDate = null;
		Date tranDate = null,today = new java.util.Date();
		HashMap miscVouchHdr = null;
		HashMap miscVouchDet = null;
		HashMap miscVouchAdv = null;
		HashMap miscVouchAcct = null;
		ArrayList miscVouchDetList = new ArrayList();
		ArrayList miscVouchAdvList = new ArrayList();
		ArrayList miscVouchAcctList = new ArrayList();

		PreparedStatement pstmt = null,pstmtUpd = null,pstmtHdr = null,pstmtInner = null;
		ResultSet rs = null,rsHdr = null,rsInner = null;
		Timestamp currDate = null;
		GenericUtility genericUtility = null;
		FinCommon finCommon = new FinCommon();
		DistCommon distCommon = new DistCommon();
		try 
		{
			currDate = new java.sql.Timestamp(System.currentTimeMillis());
			ITMDBAccessEJB itmDBAccess = new ITMDBAccessEJB();
			genericUtility = GenericUtility.getInstance();
			userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode");
			chgTerm = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "chgTerm" );

			if(userId == null || userId.trim().length() > 0)
			{
				return "EMPAPRV";
			}


			sql = " SELECT tran_id  FROM misc_voucher  WHERE tran_id 	>=  ? AND tran_id 	<= ? "
					+" AND site_code = ? and confirmed = 'N' ORDER BY tran_id ASC  ";
			pstmtHdr = conn.prepareStatement(sql);
			pstmtHdr.setString(1, tranIdFr);
			pstmtHdr.setString(2, tranIdTo);
			pstmtHdr.setString(3, tranIdFr);
			rsHdr = pstmtHdr.executeQuery();
			while(rsHdr.next())
			{
				tranId = checkNull(rsHdr.getString("tran_id"));

				if ("db2".equalsIgnoreCase(CommonConstants.DB_NAME ))
				{
					sql = "select tran_id  from misc_voucher where tran_id = ? for update  ";
				}

				else if ( "mssql".equalsIgnoreCase(CommonConstants.DB_NAME ))
				{
					sql = "select tran_id  from misc_voucher (updlock) where tran_id = ?  " ;
				}
				else
				{
					sql =" select tran_id  from misc_voucher where tran_id = ? for update nowait " ;
				}
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, tranId);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					tranId1 = checkNull(rs.getString("tran_id"));
				}
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;

				sql = "select * from misc_voucher where tran_id = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, tranId1);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					miscVouchHdr = new HashMap();
					miscVouchHdr.put("tran_type",rs.getString("tran_type"));
					miscVouchHdr.put("tran_date",rs.getDate("tran_date"));
					miscVouchHdr.put("adv_amt",rs.getDouble("adv_amt"));
					miscVouchHdr.put("bill_amt",rs.getDouble("bill_amt"));
					miscVouchHdr.put("tot_amt",rs.getDouble("tot_amt"));
					miscVouchHdr.put("net_amt",rs.getDouble("net_amt"));
					miscVouchHdr.put("tax_amt",rs.getDouble("tax_amt"));
					miscVouchHdr.put("rnd_off",rs.getString("rnd_off"));
					miscVouchHdr.put("rnd_to",rs.getDouble("rnd_to"));
					miscVouchHdr.put("net_amt__bc",rs.getDouble("net_amt__bc"));
					miscVouchHdr.put("exch_rate",rs.getDouble("exch_rate"));
					miscVouchHdr.put("sundry_code",rs.getString("sundry_code"));
					System.out.println("miscVouchHdr="+miscVouchHdr);
				}
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;

				sql = "select * from misc_vouchdet where tran_id = ? order by line_no";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, tranId1);
				rs = pstmt.executeQuery();
				while(rs.next())
				{
					miscVouchDet = new HashMap();
					miscVouchDet.put("tran_id",rs.getString("tran_id"));
					miscVouchDet.put("line_no",rs.getString("line_no"));
					miscVouchDet.put("tran_id",rs.getString("tran_id"));
					System.out.println("miscVouchDet="+miscVouchDet);
					miscVouchDetList.add(miscVouchDet);
				}
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;

				sql = " select  * from misc_vouchacct where tran_id = ? order by line_no ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, tranId1);
				rs = pstmt.executeQuery();
				while(rs.next())
				{
					miscVouchAcct = new HashMap();
					miscVouchAcct.put("tran_id",rs.getString("tran_id"));
					miscVouchAcct.put("line_no",rs.getString("line_no"));
					miscVouchAcct.put("tran_id",rs.getString("tran_id"));
					System.out.println("miscVouchAcct="+miscVouchAcct);
					miscVouchAcctList.add(miscVouchAcct);
				}
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;

				sql = " select tran_id,ref_ser,ref_no from misc_vouchadv where tran_id = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, tranId1);
				rs = pstmt.executeQuery();
				while(rs.next())
				{
					miscVouchAdv = new HashMap();
					miscVouchAdv.put("tran_id",rs.getString("tran_id"));
					miscVouchAdv.put("ref_ser",rs.getString("ref_ser"));
					miscVouchAdv.put("ref_no",rs.getString("ref_no"));
					System.out.println("miscVouchAdv="+miscVouchAdv);
					miscVouchAdvList.add(miscVouchAdvList);
				}
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;

				sql = " select max(line_no)  from 	misc_vouchdet where tran_id = ?   ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, tranId);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					maxLine = rs.getInt(1);
				}
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;
				System.out.println("max line = "+maxLine);

				tranDate =  (Date)miscVouchHdr.get("tran_date");
				tranType =  (String)miscVouchHdr.get("tran_type");
				winName = "W_MISC_VOUCHER";

				sql = " select ledg_post_conf  from transetup where upper(tran_window) = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, winName);
				rs = pstmt.executeQuery();
				if(rs == null)
				{
					errString = itmDBAccess.getErrorString("","VTSEQ","","",conn);
					return errString;
				}
				else
				{
					ledgPostConf = rs.getString("ledg_post_conf");
				}
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;

				if("Y".equalsIgnoreCase(ledgPostConf))
				{
					if(tranDate != today)
					{
						tranDate = today;
						sql = " update misc_voucher set tran_date = :ld_tran_date  	where tran_id   =  :ls_tran_id[ll_ctr]";
						pstmtUpd = conn.prepareStatement(sql);
						pstmtUpd.setDate(1, new java.sql.Date(tranDate.getTime()));
						pstmtUpd.setString(2,tranId);
						pstmtUpd.executeUpdate();
						pstmtUpd.close();
						pstmtUpd = null;
					}
					//lds_hdr.setitem(1, "tran_date", ld_tran_date)
				}

				advAmt =  (Double)miscVouchHdr.get("adv_amt");
				billAmt =  (Double)miscVouchHdr.get("bill_amt");
				totalAmt =  (Double)miscVouchHdr.get("tot_amt");
				netAmt =  (Double)miscVouchHdr.get("net_amt");
				taxAmt =  (Double)miscVouchHdr.get("tax_amt");		

				if((billAmt + taxAmt) != totalAmt || ((totalAmt + advAmt) ) != netAmt)
				{
					errString = itmDBAccess.getErrorString("","VTAMTMIS","","",conn);
					return errString;
				}

				sql = " select line_no, acct_code, cctr_code, sum(tax_amt) as sumTaxAmt, case when sum(reco_amount) is null then 0 else sum(reco_amount) end as sumRecoAmt "
						+" from taxtran where tran_code = 'M-VOUC' and tran_id = ? and tax_amt <> 0 	and effect <> 'N' group by line_no, acct_code, cctr_code ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, tranId);
				rs = pstmt.executeQuery();
				while(rs.next())
				{

					lineNo = rs.getInt("line_no");
					acctCode = rs.getString("acct_code");
					cctrCode = rs.getString("cctr_code");
					sumTaxAmt = rs.getDouble("sumTaxAmt");
					sumRecoAmt = rs.getDouble("sumRecoAmt");

					if(acctCode == null || acctCode.trim().length() == 0)
					{
						sql = " select acct_code from misc_vouchdet where tran_id = ? and line_no = ?  ";
						pstmtInner = conn.prepareStatement(sql);
						pstmtInner.setString(1, tranId);
						pstmtInner.setInt(2, lineNo);
						rsInner = pstmtInner.executeQuery();
						if(rsInner.next())
						{
							acctCode =  checkNull(rsInner.getString("acct_code"));
						}
						rsInner.close();
						rsInner = null;
						pstmtInner.close();
						pstmtInner = null;
					}

					if(cctrCode == null || cctrCode.trim().length() == 0)
					{
						sql = "select cctr_code  from misc_vouchdet where tran_id = ? and line_no = ? ";
						pstmtInner = conn.prepareStatement(sql);
						pstmtInner.setString(1, tranId);
						pstmtInner.setInt(2, lineNo);
						rsInner = pstmtInner.executeQuery();
						if(rsInner.next())
						{
							cctrCode =  checkNull(rsInner.getString("cctr_code"));
						}
						rsInner.close();
						rsInner = null;
						pstmtInner.close();
						pstmtInner = null;
					}

					//String str = "acct_code = '" + acctCode + "' and cctr_code = '" + cctrCode+ "'";


					sql = "select count(*) from misc_vouchdet where acct_code = ? and cctr_code = ? ";
					pstmtInner = conn.prepareStatement(sql);
					pstmtInner.setString(1, acctCode);
					pstmtInner.setString(2, cctrCode);
					rsInner = pstmtInner.executeQuery();
					if(rsInner.next())
					{
						count = rsInner.getInt(1);
					}
					rsInner.close();
					rsInner = null;
					pstmtInner.close();
					pstmtInner = null;

					if(count == 0)
					{

						sql = " select max(line_no)  from misc_vouchdet where tran_id = ?  ";
						pstmtInner = conn.prepareStatement(sql);
						pstmtInner.setString(1, tranId);
						rsInner = pstmtInner.executeQuery();
						if(rsInner.next())
						{
							maxLine = rsInner.getInt(1);
						}
						rsInner.close();
						rsInner = null;
						pstmtInner.close();
						pstmtInner = null;

						sql = " insert into misc_vouchdet(tran_id,line_no,acct_code,cctr_code,amount,emp_code,anal_code) values (?,?,?,?,?,     ?,?)  "; 
						pstmtUpd = conn.prepareStatement(sql);
						pstmtUpd.setString(1,tranId);
						pstmtUpd.setInt(2,maxLine+1);
						pstmtUpd.setString(3,acctCode);
						pstmtUpd.setString(4,cctrCode);
						pstmtUpd.setDouble(5,sumTaxAmt - sumRecoAmt);
						pstmtUpd.setString(6,null);
						pstmtUpd.setString(7,null);
						pstmtUpd.executeUpdate();
						pstmtUpd.close();
						pstmtUpd = null;

					}
					else
					{
						sql = " select amount from misc_vouchdet where tran_id = ? and line_no = ?  ";
						pstmtInner = conn.prepareStatement(sql);
						pstmtInner.setString(1, tranId);
						pstmtInner.setInt(2, lineNo);
						rsInner = pstmtInner.executeQuery();
						if(rsInner.next())
						{
							amount =  rsInner.getDouble("amount");
						}
						rsInner.close();
						rsInner = null;
						pstmtInner.close();
						pstmtInner = null;

						sql = " update misc_vouchdet set amount = ?  where tran_id = ?  and line_no = ?   "; 
						pstmtUpd = conn.prepareStatement(sql);
						pstmtUpd.setDouble(1,amount + (sumTaxAmt - sumRecoAmt));
						pstmtUpd.setString(2,tranId);
						pstmtUpd.setInt(3,lineNo);
						pstmtUpd.executeUpdate();
						pstmtUpd.close();
						pstmtUpd = null;

					}

				}
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;
				//ls_tax_reco_cctr = gbf_acct_detr_ttype(' ',' ','TAXRECO', ls_tran_type)
				//ls_tax_reco_acct = f_get_token(ls_tax_reco_cctr,'~t')
				//finCommon.getAcctDetrTtype(arg0, arg1, arg2, arg3, arg4);
				taxRecoCctr = finCommon.getAcctDetrTtype("", "", "TAXRECO", tranType, conn);

				taxRecoAcct = distCommon.getToken(taxRecoCctr, "~t");
				// Cursor for Tax recovery for the item, if any
				sql = " select line_no, acct_code__reco,	cctr_code__reco, case when sum(reco_amount) is null then 0 else sum(reco_amount) end "
				     +" from taxtran where tran_code= 'M-VOUC' and 	tran_id	=  ? and 	reco_amount <> 0 and effect <> 'N' 	group by line_no,acct_code__reco,cctr_code__reco";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, tranId);
				rs = pstmt.executeQuery();
				while(rs.next())
				{
					lineNo = rs.getInt("line_no");
					acctCode = rs.getString("acct_code__reco");
					cctrCode = checkNull(rs.getString("cctr_code__reco"));
					sumRecoAmt = rs.getDouble(4);
					if(acctCode != null || acctCode.trim().length() == 0)
					{
						acctCode = taxRecoAcct;
					}
					if(cctrCode != null || cctrCode.trim().length() > 0)
					{
						cctrCode = taxRecoCctr;
					}

					if(acctCode == null || acctCode.trim().length() > 0)
					{
						errString = itmDBAccess.getErrorString("","VTACCTRECO","","",conn);
						return errString;
					}
					sql = "select count(*) from misc_vouchdet where acct_code = ? and cctr_code = ? ";
					pstmtInner = conn.prepareStatement(sql);
					pstmtInner.setString(1, acctCode);
					pstmtInner.setString(2, cctrCode);
					rsInner = pstmtInner.executeQuery();
					if(rsInner.next())
					{
						count = rsInner.getInt(1);
					}
					rsInner.close();
					rsInner = null;
					pstmtInner.close();
					pstmtInner = null;

					if(count == 0)
					{

						sql = " select max(line_no)  from 	misc_vouchdet where tran_id = ?   ";
						pstmtInner = conn.prepareStatement(sql);
						pstmtInner.setString(1, tranId);
						rsInner = pstmtInner.executeQuery();
						if(rsInner.next())
						{
							maxLine = rsInner.getInt(1);
						}
						rsInner.close();
						rsInner = null;
						pstmtInner.close();
						pstmtInner = null;

						sql = " insert into misc_vouchdet(tran_id,line_no,acct_code,cctr_code,amount,emp_code,anal_code) values (?,?,?,?,?,     ?,?)  "; 
						pstmtUpd = conn.prepareStatement(sql);
						pstmtUpd.setString(1,tranId);
						pstmtUpd.setInt(2,maxLine+1);
						pstmtUpd.setString(3,acctCode);
						pstmtUpd.setString(4,cctrCode);
						pstmtUpd.setDouble(5, sumRecoAmt);
						pstmtUpd.setString(6,null);
						pstmtUpd.setString(7,null);
						pstmtUpd.executeUpdate();
						pstmtUpd.close();
						pstmtUpd = null;

					}
					else
					{
						sql = " select amount from misc_vouchdet where tran_id = ? and line_no = ?  ";
						pstmtInner = conn.prepareStatement(sql);
						pstmtInner.setString(1, tranId);
						pstmtInner.setInt(2, lineNo);
						rsInner = pstmtInner.executeQuery();
						if(rsInner.next())
						{
							amount =  rsInner.getDouble("amount");
						}
						rsInner.close();
						rsInner = null;
						pstmtInner.close();
						pstmtInner = null;

						sql = " update misc_vouchdet set amount = ?  where tran_id = ?  and line_no = ?   "; 
						pstmtUpd = conn.prepareStatement(sql);
						pstmtUpd.setDouble(1,amount +  sumRecoAmt);
						pstmtUpd.setString(2,tranId);
						pstmtUpd.setInt(3,lineNo);
						pstmtUpd.executeUpdate();
						pstmtUpd.close();
						pstmtUpd = null;

					}

				}
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;

				rndOff = (String)miscVouchHdr.get("rnd_off");
				if(!"N".equalsIgnoreCase(rndOff))
				{
					double netAmtTemp = 0; 
					double rndAmt = 0;
					rndTo = (Integer)miscVouchHdr.get("rnd_to");
					netAmtTemp = netAmt;
					//lc_netamt = gf_get_rndamt(lc_netamt, ls_rndoff, lc_rndto)
					netAmt = distCommon.getRndamt(netAmt, rndOff, rndTo);
					rndAmt = netAmt - netAmtTemp;
					if(rndAmt != 0)
					{
						//ls_cctrcode_rnd = gf_getfinparm('999999', 'RND_ACCT') 299
						String cctrCodeRnd = "";
						String  acctCodeRnd = "";
						cctrCodeRnd = finCommon.getFinparams("999999", "RND_ACCT", conn);
						if(!"NULLFOUND".equalsIgnoreCase(cctrCodeRnd))
						{
							acctCodeRnd  = distCommon.getToken(cctrCodeRnd, ";") == null?"":distCommon.getToken(cctrCodeRnd, ";").trim();
						}
						else
						{
							errString = itmDBAccess.getErrorString("","VTACCTRECO","","",conn);
							return errString;
						}

						sql = " insert into misc_vouchdet(tran_id,line_no,acct_code,cctr_code,amount) values (?,?,?,?,?)  "; 
						pstmtUpd = conn.prepareStatement(sql);
						pstmtUpd.setString(1,tranId);
						pstmtUpd.setInt(2,maxLine+1);
						pstmtUpd.setString(3,acctCodeRnd);
						pstmtUpd.setString(4,cctrCodeRnd);
						pstmtUpd.setDouble(5,rndAmt);
						pstmtUpd.executeUpdate();
						pstmtUpd.close();
						pstmtUpd = null;
					}
					sql = " update misc_voucher set rnd_amt = ? where tran_id = ? "; 
					pstmtUpd = conn.prepareStatement(sql);
					pstmtUpd.setDouble(1,rndAmt);
					pstmtUpd.setString(2,tranId);
					pstmtUpd.executeUpdate();
					pstmtUpd.close();
					pstmtUpd = null;
				}
			}
			rsHdr.close();
			rsHdr = null;
			pstmtHdr.close();
			pstmtHdr = null;


				//prince --10-07-06-- retrieve of header reqd. again as values are updated above
				//lds_hdr.retrieve(ls_tran_id[ll_ctr])
				//lds_det.retrieve(ls_tran_id[ll_ctr])	
				//ended by prince	
				//ls_errcode = gbf_post_misc_vou(lds_hdr.describe("datawindow.data"), lds_det.describe("datawindow.data"), lds_deta.describe("datawindow.data"),ai_commit, as_warning)

			//errString = gbfPostMiscVou(miscVouchHdr,miscVouchDetList,miscVouchAdvList, xtraParams , conn);



			//pending






		} catch (SQLException e) 
		{

			e.printStackTrace();
			throw new ITMException(e);
		}
		catch (Exception e) 
		{

			e.printStackTrace();
			throw new ITMException(e);
		}
		return errString;
	}*/


	/*String gbfPostMiscVou(HashMap miscVouchHdr,ArrayList miscVouchDetList,ArrayList miscVouchAdvList,String xtraParams ,Connection conn) throws ITMException
	{
		String errString = "",sql = "" , userId = "", chgTerm = "";
		String sundryType = "",sundryCode = "", status = "";
		String tranId = "";
		double  recoAmt = 0,balanceAmt = 0;
		Date recoDate = null, startDate = null,  confDate = null ,refDate = null; 
		PreparedStatement pstmt = null,pstmtUpd = null;
		ResultSet rs = null;
		Timestamp currDate = null;
		GenericUtility genericUtility = null;
		try 
		{
			currDate = new java.sql.Timestamp(System.currentTimeMillis());
			genericUtility = GenericUtility.getInstance();
			ITMDBAccessEJB itmDBAccess = new ITMDBAccessEJB();
			userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode");
			chgTerm = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "chgTerm" );

			if(miscVouchHdr == null)
			{
				errString = itmDBAccess.getErrorString("","VTIMP","","",conn);
				return errString;
			}
			else if(miscVouchHdr.size() == 0)
			{
				errString = itmDBAccess.getErrorString("","VTIMPNOREC","","",conn);
				return errString;
			}
			if(miscVouchAdvList == null || miscVouchAdvList.size() == 0)
			{
				errString = itmDBAccess.getErrorString("","VTIMP","","",conn);
				return errString;
			}
			tranId = miscVouchHdr();









		} catch (SQLException e) 
		{

			e.printStackTrace();
			throw new ITMException(e);
		}
		catch (Exception e) 
		{

			e.printStackTrace();
			throw new ITMException(e);
		}
		return errString;
	}*/

	private String gbfInstCreate(String loanNo,String xtraParams ,Connection conn) throws ITMException
	{
		String errString = "",sql = "" , userId = "", chgTerm = "";
		String empCode = "", adCode = "", confirmed = "" ,transer ="" , schemeNo = "";
		String sundryType = "",sundryCode = "", status = "";
		int  term = 0,count =0;
		double  loanAmt = 0,monInst = 0;
		Date endDate = null, startDate = null,  confDate = null ,reqDate = null; 
		PreparedStatement pstmt = null,pstmtUpd = null;
		ResultSet rs = null;
		Timestamp currDate = null;
		GenericUtility genericUtility = null;
		try 
		{
			System.out.println("gbfInstCreate called........... ");
			currDate = new java.sql.Timestamp(System.currentTimeMillis());
			genericUtility = GenericUtility.getInstance();
			ITMDBAccessEJB itmDBAccess = new ITMDBAccessEJB();
			userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode");
			chgTerm = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "chgTerm" );
			sql = " select start_reco, emp_code, loan_amt, mon_inst, term, scheme_no  from loans where loan_no = ?  ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, loanNo);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				startDate = rs.getDate("start_reco");
				empCode = checkNull(rs.getString("emp_code"));
				loanAmt = rs.getDouble("loan_amt");
				monInst = rs.getDouble("mon_inst");
				term = rs.getInt("term");
				schemeNo = rs.getString("scheme_no");
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;

			// Insert records in Employee wise Allowance Deduction Table.
			sql = " select ad_code__ded   from loan_scheme 	where scheme_no = ?  ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, schemeNo);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				adCode = rs.getString("ad_code__ded");
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;

			// the last reqd. date
			if(term > 1)
			{
				//req_date = gf_addmonth(ld_start, li_term - 1)
				//req_date = gf_lastdate(req_date)
				reqDate = addMonths(startDate, term-1);
				reqDate = lastDay(reqDate);
			}
			else
			{
				reqDate = lastDay(startDate);   
			}
			endDate = reqDate;

			sql = " select count(*)  from allowdedn_bal where emp_code = ?  and ad_code = ? "
					+"	and start_date = ? 	and end_date = ?  ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, empCode);
			pstmt.setString(2, adCode);
			pstmt.setDate(3,startDate == null?null:new java.sql.Date(startDate.getTime()) );
			pstmt.setDate(4,endDate == null?null:new java.sql.Date(endDate.getTime()) );
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				count = rs.getInt(1);
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
			if(count == 0)
			{
				sql = " Insert into allowdedn_bal (emp_code, ad_code, start_date, end_date, amount, amt_adj,"
						+"	 amt_bal, chg_date, chg_user, chg_term,ref_type,ref_no)"
						+"	values (?,?,?,?,?, 0,  ?, ?, ?,?,'L',?) "; 
				pstmtUpd = conn.prepareStatement(sql);
				pstmtUpd.setString(1,empCode);
				pstmtUpd.setString(2,adCode);
				pstmtUpd.setDate(3,startDate == null?null:new java.sql.Date(startDate.getTime()) );
				pstmtUpd.setDate(4,endDate == null?null:new java.sql.Date(endDate.getTime()) );
				pstmtUpd.setDouble(5,loanAmt);
				pstmtUpd.setDouble(6,loanAmt);
				//pstmtUpd.setDate(7,new java.sql.Date(new java.util.Date().getTime()) );
				pstmtUpd.setTimestamp(7,new java.sql.Timestamp(System.currentTimeMillis()) );
				pstmtUpd.setString(8,userId);
				pstmtUpd.setString(9,chgTerm);
				pstmtUpd.setString(10,loanNo);
				int i = pstmtUpd.executeUpdate();
				System.out.println("row insert into allowdedn_bal ="+i);
				pstmtUpd.close();
				pstmtUpd = null;
			}
			else
			{
				errString = itmDBAccess.getErrorString("","VTLNFND","","",conn);// loan already found for same scheme and start reco.
				return errString;
			}

		} catch (SQLException e) 
		{
			System.out.println("Exception :PerkClaimPos :gbfInstCreate :SQLException :==>\n"+e.getMessage());
			e.printStackTrace();
			throw new ITMException(e);
		}catch (Exception e) 
		{
			System.out.println("Exception :PerkClaimPos :gbfInstCreate :Exception :==>\n"+e.getMessage());
			e.printStackTrace();
			throw new ITMException(e);
		}
		return errString;
	}//gbfInstCreate end
	private String generateTranId( String windowName, String siteCode, String tranDateStr, Connection conn )throws ITMException
	{
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String selSql = "";
		String tranId = "";
		String tranSer = "";
		String keyString = "";
		String keyCol = "";
		String xmlValues = "";
		String paySiteCode = "";
		String effectiveDate = "";
		java.sql.Date effDate = null;

		try
		{
			System.out.println("generateTranId() called");

			selSql = "SELECT KEY_STRING, TRAN_ID_COL, REF_SER FROM TRANSETUP WHERE TRAN_WINDOW = ? ";
			//System.out.println("selSql :"+selSql);
			pstmt = conn.prepareStatement(selSql);
			pstmt.setString( 1, windowName );
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				keyString = rs.getString("KEY_STRING");
				keyCol = rs.getString("TRAN_ID_COL");
				tranSer = rs.getString("REF_SER");
			}
			rs.close();rs = null;
			pstmt.close();pstmt = null;
			System.out.println("keyString :"+keyString);
			System.out.println("keyCol :"+keyCol);
			System.out.println("tranSer :"+tranSer);

			xmlValues ="<?xml version=\"1.0\" encoding=\"utf-8\"?><Root>";
			xmlValues = xmlValues + "<Header></Header>";
			xmlValues = xmlValues + "<Detail1>";
			xmlValues = xmlValues +		"<tran_id></tran_id>";
			xmlValues = xmlValues +		"<site_code>" + siteCode + "</site_code>";
			xmlValues = xmlValues +		"<tran_date>" + tranDateStr + "</tran_date>"; 
			xmlValues = xmlValues + "</Detail1></Root>";
			System.out.println("xmlValues  :["+xmlValues+"]");
			TransIDGenerator tg = new TransIDGenerator(xmlValues, "BASE", CommonConstants.DB_NAME);
			tranId = tg.generateTranSeqID(tranSer, keyCol, keyString, conn);
			System.out.println("tranId :"+tranId);

		}
		catch (SQLException ex)
		{
			System.out.println("Exception :PerkClaimPos :generateTranId :SQLException ::" +selSql+ ex.getMessage() + ":");
			ex.printStackTrace();
			throw new ITMException(ex);
		}
		catch (Exception e)
		{
			System.out.println("Exception :PerkClaimPos :generateTranId :Exception ::" + e.getMessage() + ":");
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if (pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				//errString = e.getMessage();
				e.printStackTrace();
				throw new ITMException(e);
			}
		}
		return tranId;
	}
	private String getAttribValue(Node detailNode, String nodeName, String attribStr)
	{
		String attribValue = "";
		try
		{
			String domStr = GenericUtility.getInstance().serializeDom(detailNode);
			Document dom = GenericUtility.getInstance().parseString(domStr);
			if( dom != null /*&& dom.getAttributes() != null*/)
			{
				Node attributeNode = dom.getElementsByTagName( nodeName ).item(0);
				attribValue = getAttribValue(attributeNode, attribStr);
			}
		}
		catch(Exception e)
		{
			System.out.println("Exception : getAttribValue :" + e.getMessage());
		}
		return attribValue;
	}

	private String getAttribValue(Node detailNode, String attribStr)
	{
		String attribValue = "";
		try
		{
			if( detailNode != null && detailNode.getAttributes() != null)
			{
				Node attribNode = detailNode.getAttributes().getNamedItem( attribStr );
				if( attribNode != null )
				{
					attribValue = checkNull( attribNode.getNodeValue() );
				}
			}
		}
		catch(Exception e)
		{
			System.out.println("Exception : getAttribValue :" + e.getMessage());
		}
		return attribValue;
	}
	private String checkNull( String inputVal )
	{
		if ( inputVal == null )
		{
			inputVal = "";
		}
		return inputVal;
	}
	public static java.util.Date addDays(java.util.Date date, int days) 
	{
		java.sql.Date calculatedDate = null;
		if (date != null) 
		{
			final GregorianCalendar calendar = new GregorianCalendar();
			calendar.setTime(date);
			calendar.add(Calendar.DATE,days);
			calculatedDate = new java.sql.Date(calendar.getTime().getTime());
		}

		return calculatedDate;
	}
	public static java.util.Date addMonths(java.util.Date date, int months) 
	{
		java.sql.Date calculatedDate = null;
		if (date != null) 
		{
			final GregorianCalendar calendar = new GregorianCalendar();
			calendar.setTime(date);
			calendar.add(Calendar.MONTH,months);
			calculatedDate = new java.sql.Date(calendar.getTime().getTime());
		}

		return calculatedDate;
	}
	public static java.util.Date lastDay(java.util.Date date) 
	{
		java.sql.Date calculatedDate = null;
		if (date != null) 
		{
			final GregorianCalendar calendar = new GregorianCalendar();
			calendar.setTime(date);
			//calendar.add(Calendar.MONTH,months);
			int lastDate =  calendar.getActualMaximum(Calendar.DAY_OF_MONTH);
			calendar.set(Calendar.DATE, lastDate);
			calculatedDate = new java.sql.Date(calendar.getTime().getTime());
		}

		return calculatedDate;
	}

}



