/*
 * Author: Wasim Ansari
 * Date: 08-AUG-2016
 * Request: S16EBAS006 (ASN Wizard)
 */

package ibase.webitm.bean.wms;

import java.io.File;

import ibase.system.config.AppConnectParm;
import ibase.utility.CommonConstants;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.wms.DDPorderWizEJBRemote;
import ibase.webitm.ejb.wms.PackLabelWizEJBRemote;
import ibase.webitm.ejb.wms.PackLabelWizPosEJBRemote;
import ibase.webitm.utility.ITMException;
import ibase.utility.E12GenericUtility;

import javax.naming.InitialContext;
import javax.servlet.http.HttpSession;

public class PackLabelWizBean 
{
	E12GenericUtility genericUtility = new E12GenericUtility();
	private ibase.utility.UserInfoBean userInfo = null;
	private HttpSession sessionCtx = null;
	private String objName = "";
	private String user_lang ="en"; 
	private String user_country = "US";
	
	public PackLabelWizBean(String objName, HttpSession sessionCtx) throws ITMException 
	{
		try
		{
			this.objName = objName;
			this.sessionCtx = sessionCtx;
			this.userInfo = ( ibase.utility.UserInfoBean ) this.sessionCtx.getAttribute("USER_INFO");
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
	}
	
	public PackLabelWizBean() {
		// TODO Auto-generated constructor stub
	}
	
	public String getList( String field, String[] values, String details, UserInfoBean userInfo) throws ITMException
	{
		String List = "";
		
		PackLabelWizEJBRemote packWizRemote = null;
		
		try
		{
			InitialContext ctx = new InitialContext( new AppConnectParm().getProperty() );
			packWizRemote = (ibase.webitm.ejb.wms.PackLabelWizEJBRemote) ctx.lookup("ibase/PackLabelWizEJB/remote");
			List = packWizRemote.getList(field,values,details,userInfo);

			String xslFileName = getXSLFileName( "packLabelWiz_List_wiz_" + this.user_lang + "_" + this.user_country + ".xsl" );
			
			List = (genericUtility).transformToString( xslFileName, List, CommonConstants.APPLICATION_CONTEXT + File.separator + "temp", "Output", ".html" );
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		finally
		{
			if ( packWizRemote != null )
			{
				packWizRemote = null;
			}
		}
		return List;
	}
	
	
	private String getXSLFileName( String xslFileName )throws ITMException
	{   
		String retFileName = null;
		try
		{
			String defaultPath = null;
			if( CommonConstants.APPLICATION_CONTEXT != null )
			{
				defaultPath = CommonConstants.APPLICATION_CONTEXT + CommonConstants.ITM_CONTEXT + File.separator;
			}
			else
			{
				defaultPath = ".." + File.separator + "webapps" + File.separator + "ibase" + File.separator + CommonConstants.ITM_CONTEXT + File.separator;
			}
			File xslPath = new File( defaultPath + File.separator  + "xsl" + File.separator + CommonConstants.THEME + File.separator + "WIZARD"+ File.separator + "Galaxy");
			if ( !xslPath.exists() )
			{
				xslPath.mkdir();
			}
			System.out.println( " xslPath [" + xslPath +"] xslFileName ["+xslFileName +"]");
			File xslFile = new File(xslPath , xslFileName);
			if( xslFile.exists() )
			{
				retFileName = xslFile.getAbsolutePath();
			}
			else
			{
				throw new ITMException( new Exception( retFileName + " Wizard XSL file Not Found") );	
			}
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		return retFileName;
	}

	/**
	 * go to prevoius form
	 * @param formNo
	 * @param xmlData
	 * @return
	 * @throws ITMException
	 */
	public String previousForm( String formNo, String xmlData ) throws ITMException 
	{
		String retHtmlData = null;
		
		try
		{
			System.out.println("In Method : [previousForm]"+xmlData);

			String xslFileName = getXSLFileName( this.objName + formNo + "_wiz_" + this.user_lang + "_" + this.user_country + "_" + "A" + ".xsl" );

			retHtmlData = (genericUtility).transformToString( xslFileName, xmlData, CommonConstants.APPLICATION_CONTEXT + File.separator + "temp", "Output", ".html" );
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		finally
		{
			
		}
		return retHtmlData;
	}
	public String getPoDetails( String objName) throws ITMException 
	{
		String details = null;
		PackLabelWizPosEJBRemote packLabelWizPosEJBRemote = null;
		try
		{
			System.out.println("*******In Method : [nextForm]************");
			
			InitialContext ctx = new InitialContext( new AppConnectParm().getProperty() );
			packLabelWizPosEJBRemote = (ibase.webitm.ejb.wms.PackLabelWizPosEJBRemote) ctx.lookup("ibase/PackLabelWizPosEJB/remote");
			details = packLabelWizPosEJBRemote.getPoDetails(objName);
			String xslFileName = getXSLFileName( "packLabelWiz_Finish_wiz_" + this.user_lang + "_" + this.user_country + ".xsl" );
			details = (genericUtility).transformToString( xslFileName, details, CommonConstants.APPLICATION_CONTEXT + File.separator + "temp", "Output", ".html" );

		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		finally
		{
			if ( packLabelWizPosEJBRemote != null )
			{
				packLabelWizPosEJBRemote = null;
			}
		}
		return details;
	}	
	
}
