/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.nio.conn.ssl;

import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import org.apache.http.HttpHost;
import org.apache.http.conn.ssl.BrowserCompatHostnameVerifier;
import org.apache.http.conn.ssl.SSLContexts;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.nio.conn.SchemeIOSessionFactory;
import org.apache.http.nio.reactor.IOSession;
import org.apache.http.nio.reactor.ssl.SSLIOSession;
import org.apache.http.nio.reactor.ssl.SSLMode;
import org.apache.http.nio.reactor.ssl.SSLSetupHandler;

public class SSLIOSessionFactory
implements SchemeIOSessionFactory {
    private final SSLContext sslContext;
    private final X509HostnameVerifier hostnameVerifier;

    public static SSLIOSessionFactory getDefaultStrategy() {
        return new SSLIOSessionFactory(SSLContexts.createDefault());
    }

    public static SSLIOSessionFactory getSystemDefaultStrategy() {
        return new SSLIOSessionFactory(SSLContexts.createSystemDefault());
    }

    public SSLIOSessionFactory(SSLContext sslContext, X509HostnameVerifier hostnameVerifier) {
        this.sslContext = sslContext;
        this.hostnameVerifier = hostnameVerifier;
    }

    public SSLIOSessionFactory(SSLContext sslcontext) {
        this(sslcontext, (X509HostnameVerifier)new BrowserCompatHostnameVerifier());
    }

    public SSLIOSession create(final HttpHost host, IOSession iosession) {
        SSLIOSession ssliosession = new SSLIOSession(iosession, SSLMode.CLIENT, this.sslContext, new SSLSetupHandler(){

            public void initalize(SSLEngine sslengine) throws SSLException {
                SSLIOSessionFactory.this.initializeEngine(sslengine);
            }

            public void verify(IOSession iosession, SSLSession sslsession) throws SSLException {
                SSLIOSessionFactory.this.verifySession(host, iosession, sslsession);
            }
        });
        iosession.setAttribute("http.session.ssl", (Object)ssliosession);
        return ssliosession;
    }

    protected void initializeEngine(SSLEngine engine) {
    }

    protected void verifySession(HttpHost host, IOSession iosession, SSLSession sslsession) throws SSLException {
        Certificate[] certs = sslsession.getPeerCertificates();
        X509Certificate x509 = (X509Certificate)certs[0];
        this.hostnameVerifier.verify(host.getHostName(), x509);
    }

    public boolean isLayering() {
        return false;
    }
}

