package ibase.dashboard.scm.ejb;
import java.rmi.RemoteException;

import ibase.webitm.ejb.ValidatorRemote;
import ibase.webitm.utility.ITMException;

import javax.ejb.Remote;

import org.json.simple.JSONObject;

@Remote
public interface SalesPerformanceRemote extends ValidatorRemote
{
	public JSONObject getSalesGraphData(String dataSourceName,String month) throws RemoteException, ITMException;
	public JSONObject getProfitGraphData(String dataSourceName ,String month) throws RemoteException, ITMException;
	public JSONObject getMnthlySalesGraphData(String dataSourceName,String month) throws RemoteException, ITMException;
	public JSONObject getYTDSalesGraphData(String dataSourceName,String month) throws RemoteException, ITMException;
	public JSONObject getMnthSalesDivWiseGraphData(String dataSourceName,String month) throws RemoteException, ITMException;
	public JSONObject getDivisionWiseGraph(String dataSourceName,String month,String divGrp) throws RemoteException, ITMException ;
	public JSONObject getTopBrandYTD(String dataSourceName,String month,String divCode) throws RemoteException, ITMException;
	 public JSONObject getZoneWiseDetail(String dataSourceName,String month,String divCode) throws RemoteException, ITMException;
	 public JSONObject getZoneWiseMetroDetail(String dataSourceName, String month, String divGrp,String divCode, String zoneDescr) throws RemoteException, ITMException;
	 public JSONObject getTopBrandMTH(String dataSourceName,String month,String divCode) throws RemoteException, ITMException;
	 public JSONObject getBrandWiseZoneDetail(String dataSourceName,String month,String brandName) throws RemoteException, ITMException;
	 public JSONObject getBrandZoneWiseMetroDetail(String dataSourceName,String month,String brandName,String zoneDescr,String divDescr) throws RemoteException, ITMException;
}
