package ibase.webitm.util.gst;

import java.io.IOException;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.SerializerProvider;

import ibase.webitm.bean.gst.DocDetails;
import ibase.webitm.bean.gst.DocIssued;
import ibase.webitm.bean.gst.Docs;

public class DocSerializer extends BaseSerializer<DocIssued>
{
	@Override
	public void serialize(DocIssued docIssued, JsonGenerator json, SerializerProvider serializeProvider) throws IOException, JsonProcessingException
	{
		json.writeStartObject();
		if(docIssued.taxPayerAction != null)
		{
			json.writeStringField("flag", docIssued.taxPayerAction);
		}

		json.writeFieldName("doc_det");
		json.writeStartArray();
		for(DocDetails docDetail : docIssued.docDetails)
		{
			json.writeStartObject();
			json.writeNumberField("doc_num", docDetail.serialNumber);
			
			json.writeFieldName("docs");
			
			json.writeStartArray();
			for(Docs doc : docDetail.docs)
			{
				json.writeStartObject();
				
				json.writeNumberField("num", doc.docNum);
				json.writeStringField("from", doc.fromSerialNo);
				json.writeStringField("to", doc.toSerialNo);
				json.writeNumberField("totnum", doc.totalNo);
				json.writeNumberField("cancel", doc.cancelNo);
				json.writeNumberField("net_issue", doc.toatlNetIssued);
				
				json.writeEndObject();
			}
			json.writeEndArray();
			json.writeEndObject();
		}
		json.writeEndArray();
		json.writeEndObject();
	}
}
