package ibase.webitm.util.gst;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.List;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;

import ibase.webitm.bean.gst.CDNUR;
import ibase.webitm.bean.gst.InvLineItem;

public class CDNURSerializer extends JsonSerializer<CDNUR>
{
	GSTCommonUtil gstCommonUtil = new GSTCommonUtil();
    final SimpleDateFormat gstFmt = new SimpleDateFormat(gstCommonUtil.getGSTDateFormat());
	@Override
	public void serialize(CDNUR cdnur, JsonGenerator json, SerializerProvider serializerProvider) throws IOException, JsonProcessingException 
	{
		json.writeStartObject();
		
		if("1".equalsIgnoreCase(cdnur.recType))
		{
			json.writeStringField("typ", cdnur.customerType);
		}
		else if("2".equalsIgnoreCase(cdnur.recType))
		{
			if(cdnur.receiverGSTIN != null && cdnur.receiverGSTIN.length() > 0)
			{
				json.writeStringField("rtin", cdnur.receiverGSTIN);
			}
		}
		json.writeStringField("ntty", cdnur.cdnNoteType);
		json.writeStringField("nt_num", cdnur.cdNoteNumber);
		json.writeStringField("nt_dt", gstFmt.format(cdnur.cdNoteDate));
		json.writeStringField("inum", cdnur.invoiceNumber);
		json.writeStringField("idt", gstFmt.format(cdnur.invoiceDate));
		json.writeNumberField("val", cdnur.val);
		if(cdnur.reason != null && cdnur.reason.trim().length() > 0)
		{
			json.writeStringField("rsn", cdnur.reason);
		}
		json.writeStringField("p_gst", cdnur.isPreGSTInvoice ? "Y" : "N");
		
		writeLineItems(cdnur.items, json);

		json.writeEndObject();
	}
	
	private void writeLineItems(List<InvLineItem> items, JsonGenerator json)
	{
		try 
		{
			json.writeFieldName("itms");
			json.writeStartArray();
	        
	        for(InvLineItem li : items)
	        {
	        	writeLineItem(li, json);
	        }

	        json.writeEndArray();
		} 
		catch (IOException e) 
		{
			System.out.println("CDNRSerializer.writeCDNLineItems()["+e.getMessage()+"]");
			e.printStackTrace();
		}
	}
	
	private void writeLineItem(InvLineItem li, JsonGenerator json) 
    {
        try 
        {
            json.writeStartObject();
            
        	json.writeNumberField("num", li.num);
        	
        	json.writeFieldName("itm_det");
        	json.writeStartObject();
        	
            json.writeNumberField("rt", li.rate);
            json.writeNumberField("txval", li.taxval);

            if(li.iamt > 0)
            {
            	json.writeNumberField("iamt", li.iamt);
            }
            if(li.camt > 0)
            {
            	json.writeNumberField("camt", li.camt);
            }
            if(li.samt > 0)
            {
            	json.writeNumberField("samt", li.samt);
            }
            if(li.csamt > 0)
            {
            	json.writeNumberField("csamt", li.csamt);
            }
            json.writeEndObject();
            
            if(li.itcType != null)
            {
            	json.writeFieldName("itc");
            	json.writeStartObject();
            	
            	json.writeStringField("elg", li.itcType);
            	json.writeNumberField("tx_i", li.igstInputTax);
            	json.writeNumberField("tx_c", li.cgstInputTax);
            	json.writeNumberField("tx_s", li.sgstInputTax);
            	json.writeNumberField("tx_cs", li.cessInputTax);
            	
            	json.writeEndObject();
            }
            
            json.writeEndObject();
        }
        catch (Exception e) 
        {
        	System.out.println("CDNRSerializer.writeLineItem()["+e.getMessage()+"]");
            e.printStackTrace();
        }
    }

}
