SET DEFINE OFF

ALTER TABLE EMP_STATUSCHG ADD REASON_CODE CHAR(5);

ALTER TABLE EMP_EMPLOY_EVENTS ADD REASON_CODE CHAR(5);
ALTER TABLE EMP_EMPLOY_EVENTS ADD JOB_TITLE_FR VARCHAR2(200);
ALTER TABLE EMP_EMPLOY_EVENTS ADD JOB_TITLE_TO VARCHAR2(200);

ALTER TABLE ORG_STRUCTURE ADD DEPT_CODE CHAR(5);

INSERT INTO OBJ_ITEMCHANGE 
(
	OBJ_NAME,
	FORM_NO,
	FIELD_NAME,
	MANDATORY
)
VALUES 
(
	'emp_status',
	'1',
	'reason_code',
	'Y'
);

COMMIT;

INSERT INTO POPHELP
(
	FIELD_NAME,
	MOD_NAME,
	SQL_STR,
	MSG_TITLE,
	WIDTH,
	HEIGHT,
	CHG_DATE,
	CHG_USER,
	CHG_TERM,
	SQL_INPUT,
	DEFAULT_COL,
	HELP_OPTION
)
VALUES
(
	'REASON_CODE',
	'W_EMP_STATUS',
	'SELECT FLD_VALUE AS Reason, DESCR AS Description FROM GENCODES WHERE FLD_NAME=''REASON_CODE'' AND MOD_NAME IN (''W_EMP_STATUS'') AND UDF_STR1 = ''?'' AND UDF_STR2 = ''?'' AND CASE WHEN ACTIVE IS NULL THEN ''Y'' ELSE ACTIVE END = ''Y''  ORDER BY FLD_VALUE',
	'Reason of Actions',
	0,
	0,
	SYSDATE,
	'BASE',
	'BASE',
	':status_type,:extend',
	1,
	1
);

COMMIT;

INSERT INTO MESSAGES
(
	MSG_NO,
	MSG_STR,
	MSG_DESCR,
	MSG_TYPE,
	MSG_OPT,
	MSG_TIME,
	ALARM,
	ERR_SOURCE,
	CHG_DATE,
	CHG_USER,
	CHG_TERM,
	OVERRIDE_INPUT,
	MAIL_OPTION
) 
VALUES 
(
	'VTEMPSTS06',
	'Invalid Reason of Action!',
	'Reason of Action can not be blank, Please enter Reason of Action defined in system or Select the Same from List',
	'E',
	'Y',
	NULL,
	NULL,
	NULL,
	SYSDATE,
	'BASE',
	'BASE',
	NULL,
	NULL
);

INSERT INTO MESSAGES
(
	MSG_NO,
	MSG_STR,
	MSG_DESCR,
	MSG_TYPE,
	MSG_OPT,
	MSG_TIME,
	ALARM,
	ERR_SOURCE,
	CHG_DATE,
	CHG_USER,
	CHG_TERM,
	OVERRIDE_INPUT,
	MAIL_OPTION
) 
VALUES 
(
	'VTEMPSTS07',
	'Invalid Reason of Action!',
	'REason of Action is not defined in system, Please enter Reason of Action defined in system or Select the Same from List',
	'E',
	'Y',
	NULL,
	NULL,
	NULL,
	SYSDATE,
	'BASE',
	'BASE',
	NULL,
	NULL
);


COMMIT;

INSERT INTO GENCODES 
(
	FLD_NAME ,
	MOD_NAME ,
	FLD_VALUE ,
	DESCR ,
	SH_DESCR ,
	CHG_DATE ,
	CHG_USER ,
	CHG_TERM ,
	ACTIVE ,
	UDF_STR1 ,
	UDF_STR2 ,
	UDF_STR3 
)
VALUES 
(
	'REASON_CODE',
	'W_EMP_STATUS',
	'ES001',
	'Unsatisfactory Performance',
	'Unsatisfactory',
	SYSDATE,
	'BASE',
	'BASE',
	'Y',
	'P',
	'Y',
	NULL
);

INSERT INTO GENCODES 
(
	FLD_NAME ,
	MOD_NAME ,
	FLD_VALUE ,
	DESCR ,
	SH_DESCR ,
	CHG_DATE ,
	CHG_USER ,
	CHG_TERM ,
	ACTIVE ,
	UDF_STR1 ,
	UDF_STR2 ,
	UDF_STR3 
)
VALUES 
(
	'REASON_CODE',
	'W_EMP_STATUS',
	'ES002',
	'Diciplinary Action',
	'Diciplinary Action',
	SYSDATE,
	'BASE',
	'BASE',
	'Y',
	'P',
	'Y',
	NULL
);

INSERT INTO GENCODES 
(
	FLD_NAME ,
	MOD_NAME ,
	FLD_VALUE ,
	DESCR ,
	SH_DESCR ,
	CHG_DATE ,
	CHG_USER ,
	CHG_TERM ,
	ACTIVE ,
	UDF_STR1 ,
	UDF_STR2 ,
	UDF_STR3 
)
VALUES 
(
	'REASON_CODE',
	'W_EMP_STATUS',
	'ES003',
	'Lack of professional behaviour',
	'Lack of prof behav',
	SYSDATE,
	'BASE',
	'BASE',
	'Y',
	'P',
	'Y',
	NULL
);

INSERT INTO GENCODES 
(
	FLD_NAME ,
	MOD_NAME ,
	FLD_VALUE ,
	DESCR ,
	SH_DESCR ,
	CHG_DATE ,
	CHG_USER ,
	CHG_TERM ,
	ACTIVE ,
	UDF_STR1 ,
	UDF_STR2 ,
	UDF_STR3 
)
VALUES 
(
	'REASON_CODE',
	'W_EMP_STATUS',
	'ES004',
	'Absenteeism',
	'Absenteeism',
	SYSDATE,
	'BASE',
	'BASE',
	'Y',
	'P',
	'Y',
	NULL
);

INSERT INTO GENCODES 
(
	FLD_NAME ,
	MOD_NAME ,
	FLD_VALUE ,
	DESCR ,
	SH_DESCR ,
	CHG_DATE ,
	CHG_USER ,
	CHG_TERM ,
	ACTIVE ,
	UDF_STR1 ,
	UDF_STR2 ,
	UDF_STR3 
)
VALUES 
(
	'REASON_CODE',
	'W_EMP_STATUS',
	'ES005',
	'Unsatisfactory Performance.',
	'Unsatisfactory',
	SYSDATE,
	'BASE',
	'BASE',
	'Y',
	'C',
	'Y',
	NULL
);

INSERT INTO GENCODES 
(
	FLD_NAME ,
	MOD_NAME ,
	FLD_VALUE ,
	DESCR ,
	SH_DESCR ,
	CHG_DATE ,
	CHG_USER ,
	CHG_TERM ,
	ACTIVE ,
	UDF_STR1 ,
	UDF_STR2 ,
	UDF_STR3 
)
VALUES 
(
	'REASON_CODE',
	'W_EMP_STATUS',
	'ES006',
	'Diciplinary Action.',
	'Diciplinary Action',
	SYSDATE,
	'BASE',
	'BASE',
	'Y',
	'C',
	'Y',
	NULL
);

INSERT INTO GENCODES 
(
	FLD_NAME ,
	MOD_NAME ,
	FLD_VALUE ,
	DESCR ,
	SH_DESCR ,
	CHG_DATE ,
	CHG_USER ,
	CHG_TERM ,
	ACTIVE ,
	UDF_STR1 ,
	UDF_STR2 ,
	UDF_STR3 
)
VALUES 
(
	'REASON_CODE',
	'W_EMP_STATUS',
	'ES007',
	'Lack of professional behaviour.',
	'Lack of prof behav',
	SYSDATE,
	'BASE',
	'BASE',
	'Y',
	'C',
	'Y',
	NULL
);

INSERT INTO GENCODES 
(
	FLD_NAME ,
	MOD_NAME ,
	FLD_VALUE ,
	DESCR ,
	SH_DESCR ,
	CHG_DATE ,
	CHG_USER ,
	CHG_TERM ,
	ACTIVE ,
	UDF_STR1 ,
	UDF_STR2 ,
	UDF_STR3 
)
VALUES 
(
	'REASON_CODE',
	'W_EMP_STATUS',
	'ES008',
	'Absenteeism.',
	'Absenteeism',
	SYSDATE,
	'BASE',
	'BASE',
	'Y',
	'C',
	'Y',
	NULL
);

COMMIT;

INSERT INTO GENCODES 
(
	FLD_NAME ,
	MOD_NAME ,
	FLD_VALUE ,
	DESCR ,
	SH_DESCR ,
	CHG_DATE ,
	CHG_USER ,
	CHG_TERM ,
	ACTIVE ,
	UDF_STR1 ,
	UDF_STR2 ,
	UDF_STR3 
)
VALUES 
(
	'REASON_CODE',
	'W_EMP_STATUS',
	'ES009',
	'Completion of Training',
	'Training Completed',
	SYSDATE,
	'BASE',
	'BASE',
	'Y',
	'P',
	'N',
	NULL
);

INSERT INTO GENCODES 
(
	FLD_NAME ,
	MOD_NAME ,
	FLD_VALUE ,
	DESCR ,
	SH_DESCR ,
	CHG_DATE ,
	CHG_USER ,
	CHG_TERM ,
	ACTIVE ,
	UDF_STR1 ,
	UDF_STR2 ,
	UDF_STR3 
)
VALUES 
(
	'REASON_CODE',
	'W_EMP_STATUS',
	'ES010',
	'Completion of Extended Training',
	'Training Completed',
	SYSDATE,
	'BASE',
	'BASE',
	'Y',
	'P',
	'N',
	NULL
);

INSERT INTO GENCODES 
(
	FLD_NAME ,
	MOD_NAME ,
	FLD_VALUE ,
	DESCR ,
	SH_DESCR ,
	CHG_DATE ,
	CHG_USER ,
	CHG_TERM ,
	ACTIVE ,
	UDF_STR1 ,
	UDF_STR2 ,
	UDF_STR3 
)
VALUES 
(
	'REASON_CODE',
	'W_EMP_STATUS',
	'ES011',
	'Completion of Performance Improvement Program',
	'Program Completed',
	SYSDATE,
	'BASE',
	'BASE',
	'Y',
	'P',
	'N',
	NULL
);


COMMIT;

INSERT INTO GENCODES 
(
	FLD_NAME ,
	MOD_NAME ,
	FLD_VALUE ,
	DESCR ,
	SH_DESCR ,
	CHG_DATE ,
	CHG_USER ,
	CHG_TERM ,
	ACTIVE ,
	UDF_STR1 ,
	UDF_STR2 ,
	UDF_STR3 
)
VALUES 
(
	'REASON_CODE',
	'W_EMP_STATUS',
	'ES012',
	'Completion of Probation',
	'Probation Completed',
	SYSDATE,
	'BASE',
	'BASE',
	'Y',
	'C',
	'N',
	NULL
);

INSERT INTO GENCODES 
(
	FLD_NAME ,
	MOD_NAME ,
	FLD_VALUE ,
	DESCR ,
	SH_DESCR ,
	CHG_DATE ,
	CHG_USER ,
	CHG_TERM ,
	ACTIVE ,
	UDF_STR1 ,
	UDF_STR2 ,
	UDF_STR3 
)
VALUES 
(
	'REASON_CODE',
	'W_EMP_STATUS',
	'ES013',
	'Completion of Training.',
	'Training Completed',
	SYSDATE,
	'BASE',
	'BASE',
	'Y',
	'C',
	'N',
	NULL
);

INSERT INTO GENCODES 
(
	FLD_NAME ,
	MOD_NAME ,
	FLD_VALUE ,
	DESCR ,
	SH_DESCR ,
	CHG_DATE ,
	CHG_USER ,
	CHG_TERM ,
	ACTIVE ,
	UDF_STR1 ,
	UDF_STR2 ,
	UDF_STR3 
)
VALUES 
(
	'REASON_CODE',
	'W_EMP_STATUS',
	'ES014',
	'Completion of Extended Training / Probation',
	'Probation Completed',
	SYSDATE,
	'BASE',
	'BASE',
	'Y',
	'C',
	'N',
	NULL
);

INSERT INTO GENCODES 
(
	FLD_NAME ,
	MOD_NAME ,
	FLD_VALUE ,
	DESCR ,
	SH_DESCR ,
	CHG_DATE ,
	CHG_USER ,
	CHG_TERM ,
	ACTIVE ,
	UDF_STR1 ,
	UDF_STR2 ,
	UDF_STR3 
)
VALUES 
(
	'REASON_CODE',
	'W_EMP_STATUS',
	'ES015',
	'Completion of Performance Improvement Program.',
	'Program Completed',
	SYSDATE,
	'BASE',
	'BASE',
	'Y',
	'C',
	'N',
	NULL
);


COMMIT;

INSERT INTO OBJ_ITEMCHANGE 
(
	OBJ_NAME,
	FORM_NO,
	FIELD_NAME,
	MANDATORY
)
VALUES 
(
	'emptranprom',
	'1',
	'reason_code',
	'Y'
);

INSERT INTO OBJ_ITEMCHANGE 
(
	OBJ_NAME,
	FORM_NO,
	FIELD_NAME,
	MANDATORY
)
VALUES 
(
	'emptranprom',
	'1',
	'design__to',
	'Y'
);

COMMIT;

INSERT INTO POPHELP
(
	FIELD_NAME,
	MOD_NAME,
	SQL_STR,
	MSG_TITLE,
	WIDTH,
	HEIGHT,
	CHG_DATE,
	CHG_USER,
	CHG_TERM,
	SQL_INPUT,
	DEFAULT_COL,
	HELP_OPTION
)
VALUES
(
	'REASON_CODE',
	'W_EMPTRANPROM',
	'SELECT FLD_VALUE AS Reason, DESCR AS Description FROM GENCODES WHERE FLD_NAME=''REASON_CODE'' AND MOD_NAME IN (''W_EMPTRANPROM'') AND UDF_STR1 = ''?'' AND CASE WHEN ACTIVE IS NULL THEN ''Y'' ELSE ACTIVE END = ''Y''  ORDER BY FLD_VALUE',
	'Reason of Actions',
	0,
	0,
	SYSDATE,
	'BASE',
	'BASE',
	':trans_type',
	1,
	1
);

COMMIT;

INSERT INTO MESSAGES
(
	MSG_NO,
	MSG_STR,
	MSG_DESCR,
	MSG_TYPE,
	MSG_OPT,
	MSG_TIME,
	ALARM,
	ERR_SOURCE,
	CHG_DATE,
	CHG_USER,
	CHG_TERM,
	OVERRIDE_INPUT,
	MAIL_OPTION
) 
VALUES 
(
	'VTEMPEVT04',
	'Invalid Reason of Action!',
	'Reason of Action can not be blank, Please enter Reason of Action defined in system or Select the Same from List',
	'E',
	'Y',
	NULL,
	NULL,
	NULL,
	SYSDATE,
	'BASE',
	'BASE',
	NULL,
	NULL
);

INSERT INTO MESSAGES
(
	MSG_NO,
	MSG_STR,
	MSG_DESCR,
	MSG_TYPE,
	MSG_OPT,
	MSG_TIME,
	ALARM,
	ERR_SOURCE,
	CHG_DATE,
	CHG_USER,
	CHG_TERM,
	OVERRIDE_INPUT,
	MAIL_OPTION
) 
VALUES 
(
	'VTEMPEVT05',
	'Invalid Reason of Action!',
	'REason of Action is not defined in system, Please enter Reason of Action defined in system or Select the Same from List',
	'E',
	'Y',
	NULL,
	NULL,
	NULL,
	SYSDATE,
	'BASE',
	'BASE',
	NULL,
	NULL
);


COMMIT;

INSERT INTO GENCODES 
(
	FLD_NAME ,
	MOD_NAME ,
	FLD_VALUE ,
	DESCR ,
	SH_DESCR ,
	CHG_DATE ,
	CHG_USER ,
	CHG_TERM ,
	ACTIVE ,
	UDF_STR1 ,
	UDF_STR2 ,
	UDF_STR3 
)
VALUES 
(
	'REASON_CODE',
	'W_EMPTRANPROM',
	'EV001',
	'Normal Promotion',
	'Promotion',
	SYSDATE,
	'BASE',
	'BASE',
	'Y',
	'P',
	NULL,
	NULL
);

INSERT INTO GENCODES 
(
	FLD_NAME ,
	MOD_NAME ,
	FLD_VALUE ,
	DESCR ,
	SH_DESCR ,
	CHG_DATE ,
	CHG_USER ,
	CHG_TERM ,
	ACTIVE ,
	UDF_STR1 ,
	UDF_STR2 ,
	UDF_STR3 
)
VALUES 
(
	'REASON_CODE',
	'W_EMPTRANPROM',
	'EV002',
	'Promotion with Transfer',
	'Promotion',
	SYSDATE,
	'BASE',
	'BASE',
	'Y',
	'P',
	NULL,
	NULL
);


INSERT INTO GENCODES 
(
	FLD_NAME ,
	MOD_NAME ,
	FLD_VALUE ,
	DESCR ,
	SH_DESCR ,
	CHG_DATE ,
	CHG_USER ,
	CHG_TERM ,
	ACTIVE ,
	UDF_STR1 ,
	UDF_STR2 ,
	UDF_STR3 
)
VALUES 
(
	'REASON_CODE',
	'W_EMPTRANPROM',
	'EV003',
	'Career Progression Plan',
	'Career Plan',
	SYSDATE,
	'BASE',
	'BASE',
	'Y',
	'P',
	NULL,
	NULL
);

INSERT INTO GENCODES 
(
	FLD_NAME ,
	MOD_NAME ,
	FLD_VALUE ,
	DESCR ,
	SH_DESCR ,
	CHG_DATE ,
	CHG_USER ,
	CHG_TERM ,
	ACTIVE ,
	UDF_STR1 ,
	UDF_STR2 ,
	UDF_STR3 
)
VALUES 
(
	'REASON_CODE',
	'W_EMPTRANPROM',
	'EV004',
	'Employee Progression Plan',
	'Employee Plan',
	SYSDATE,
	'BASE',
	'BASE',
	'Y',
	'P',
	NULL,
	NULL
);


INSERT INTO GENCODES 
(
	FLD_NAME ,
	MOD_NAME ,
	FLD_VALUE ,
	DESCR ,
	SH_DESCR ,
	CHG_DATE ,
	CHG_USER ,
	CHG_TERM ,
	ACTIVE ,
	UDF_STR1 ,
	UDF_STR2 ,
	UDF_STR3 
)
VALUES 
(
	'REASON_CODE',
	'W_EMPTRANPROM',
	'EV005',
	'Expertiation',
	'Expertiation',
	SYSDATE,
	'BASE',
	'BASE',
	'Y',
	'T',
	NULL,
	NULL
);


INSERT INTO GENCODES 
(
	FLD_NAME ,
	MOD_NAME ,
	FLD_VALUE ,
	DESCR ,
	SH_DESCR ,
	CHG_DATE ,
	CHG_USER ,
	CHG_TERM ,
	ACTIVE ,
	UDF_STR1 ,
	UDF_STR2 ,
	UDF_STR3 
)
VALUES 
(
	'REASON_CODE',
	'W_EMPTRANPROM',
	'EV006',
	'Repartiation',
	'Repartiation',
	SYSDATE,
	'BASE',
	'BASE',
	'Y',
	'T',
	NULL,
	NULL
);

INSERT INTO GENCODES 
(
	FLD_NAME ,
	MOD_NAME ,
	FLD_VALUE ,
	DESCR ,
	SH_DESCR ,
	CHG_DATE ,
	CHG_USER ,
	CHG_TERM ,
	ACTIVE ,
	UDF_STR1 ,
	UDF_STR2 ,
	UDF_STR3 
)
VALUES 
(
	'REASON_CODE',
	'W_EMPTRANPROM',
	'EV007',
	'Transfer with Redesignation',
	'Transfer',
	SYSDATE,
	'BASE',
	'BASE',
	'Y',
	'T',
	NULL,
	NULL
);

INSERT INTO GENCODES 
(
	FLD_NAME ,
	MOD_NAME ,
	FLD_VALUE ,
	DESCR ,
	SH_DESCR ,
	CHG_DATE ,
	CHG_USER ,
	CHG_TERM ,
	ACTIVE ,
	UDF_STR1 ,
	UDF_STR2 ,
	UDF_STR3 
)
VALUES 
(
	'REASON_CODE',
	'W_EMPTRANPROM',
	'EV008',
	'Inter Business Unit',
	'Transfer',
	SYSDATE,
	'BASE',
	'BASE',
	'Y',
	'T',
	NULL,
	NULL
);

INSERT INTO GENCODES 
(
	FLD_NAME ,
	MOD_NAME ,
	FLD_VALUE ,
	DESCR ,
	SH_DESCR ,
	CHG_DATE ,
	CHG_USER ,
	CHG_TERM ,
	ACTIVE ,
	UDF_STR1 ,
	UDF_STR2 ,
	UDF_STR3 
)
VALUES 
(
	'REASON_CODE',
	'W_EMPTRANPROM',
	'EV009',
	'Intra Business Unit',
	'Transfer',
	SYSDATE,
	'BASE',
	'BASE',
	'Y',
	'T',
	NULL,
	NULL
);

INSERT INTO GENCODES 
(
	FLD_NAME ,
	MOD_NAME ,
	FLD_VALUE ,
	DESCR ,
	SH_DESCR ,
	CHG_DATE ,
	CHG_USER ,
	CHG_TERM ,
	ACTIVE ,
	UDF_STR1 ,
	UDF_STR2 ,
	UDF_STR3 
)
VALUES 
(
	'REASON_CODE',
	'W_EMPTRANPROM',
	'EV010',
	'Intercompany Transfer',
	'Transfer',
	SYSDATE,
	'BASE',
	'BASE',
	'Y',
	'T',
	NULL,
	NULL
);

INSERT INTO GENCODES 
(
	FLD_NAME ,
	MOD_NAME ,
	FLD_VALUE ,
	DESCR ,
	SH_DESCR ,
	CHG_DATE ,
	CHG_USER ,
	CHG_TERM ,
	ACTIVE ,
	UDF_STR1 ,
	UDF_STR2 ,
	UDF_STR3 
)
VALUES 
(
	'REASON_CODE',
	'W_EMPTRANPROM',
	'EV011',
	'Short Term Assignment',
	'Assignment',
	SYSDATE,
	'BASE',
	'BASE',
	'Y',
	'T',
	NULL,
	NULL
);

INSERT INTO GENCODES 
(
	FLD_NAME ,
	MOD_NAME ,
	FLD_VALUE ,
	DESCR ,
	SH_DESCR ,
	CHG_DATE ,
	CHG_USER ,
	CHG_TERM ,
	ACTIVE ,
	UDF_STR1 ,
	UDF_STR2 ,
	UDF_STR3 
)
VALUES 
(
	'REASON_CODE',
	'W_EMPTRANPROM',
	'EV012',
	'Promotion with Transfer.',
	'Promotion',
	SYSDATE,
	'BASE',
	'BASE',
	'Y',
	'O',
	NULL,
	NULL
);

INSERT INTO GENCODES 
(
	FLD_NAME ,
	MOD_NAME ,
	FLD_VALUE ,
	DESCR ,
	SH_DESCR ,
	CHG_DATE ,
	CHG_USER ,
	CHG_TERM ,
	ACTIVE ,
	UDF_STR1 ,
	UDF_STR2 ,
	UDF_STR3 
)
VALUES 
(
	'REASON_CODE',
	'W_EMPTRANPROM',
	'EV013',
	'Redesignation with Transfer',
	'Redesignation',
	SYSDATE,
	'BASE',
	'BASE',
	'Y',
	'S',
	NULL,
	NULL
);


INSERT INTO GENCODES 
(
	FLD_NAME ,
	MOD_NAME ,
	FLD_VALUE ,
	DESCR ,
	SH_DESCR ,
	CHG_DATE ,
	CHG_USER ,
	CHG_TERM ,
	ACTIVE ,
	UDF_STR1 ,
	UDF_STR2 ,
	UDF_STR3 
)
VALUES 
(
	'REASON_CODE',
	'W_EMPTRANPROM',
	'EV014',
	'Restructuring',
	'Restructuring',
	SYSDATE,
	'BASE',
	'BASE',
	'Y',
	'R',
	NULL,
	NULL
);

INSERT INTO GENCODES 
(
	FLD_NAME ,
	MOD_NAME ,
	FLD_VALUE ,
	DESCR ,
	SH_DESCR ,
	CHG_DATE ,
	CHG_USER ,
	CHG_TERM ,
	ACTIVE ,
	UDF_STR1 ,
	UDF_STR2 ,
	UDF_STR3 
)
VALUES 
(
	'REASON_CODE',
	'W_EMPTRANPROM',
	'EV015',
	'Role Change',
	'Role Change',
	SYSDATE,
	'BASE',
	'BASE',
	'Y',
	'R',
	NULL,
	NULL
);

INSERT INTO GENCODES 
(
	FLD_NAME ,
	MOD_NAME ,
	FLD_VALUE ,
	DESCR ,
	SH_DESCR ,
	CHG_DATE ,
	CHG_USER ,
	CHG_TERM ,
	ACTIVE ,
	UDF_STR1 ,
	UDF_STR2 ,
	UDF_STR3 
)
VALUES 
(
	'REASON_CODE',
	'W_EMPTRANPROM',
	'EV016',
	'Restructuring.',
	'Restructuring',
	SYSDATE,
	'BASE',
	'BASE',
	'Y',
	'Z',
	NULL,
	NULL
);


INSERT INTO GENCODES 
(
	FLD_NAME ,
	MOD_NAME ,
	FLD_VALUE ,
	DESCR ,
	SH_DESCR ,
	CHG_DATE ,
	CHG_USER ,
	CHG_TERM ,
	ACTIVE ,
	UDF_STR1 ,
	UDF_STR2 ,
	UDF_STR3 
)
VALUES 
(
	'REASON_CODE',
	'W_EMPTRANPROM',
	'EV017',
	'Annual Revision',
	'Annual Revision',
	SYSDATE,
	'BASE',
	'BASE',
	'Y',
	'I',
	NULL,
	NULL
);


INSERT INTO GENCODES 
(
	FLD_NAME ,
	MOD_NAME ,
	FLD_VALUE ,
	DESCR ,
	SH_DESCR ,
	CHG_DATE ,
	CHG_USER ,
	CHG_TERM ,
	ACTIVE ,
	UDF_STR1 ,
	UDF_STR2 ,
	UDF_STR3 
)
VALUES 
(
	'REASON_CODE',
	'W_EMPTRANPROM',
	'EV018',
	'Market Correction',
	'Market Correction',
	SYSDATE,
	'BASE',
	'BASE',
	'Y',
	'I',
	NULL,
	NULL
);


INSERT INTO GENCODES 
(
	FLD_NAME ,
	MOD_NAME ,
	FLD_VALUE ,
	DESCR ,
	SH_DESCR ,
	CHG_DATE ,
	CHG_USER ,
	CHG_TERM ,
	ACTIVE ,
	UDF_STR1 ,
	UDF_STR2 ,
	UDF_STR3 
)
VALUES 
(
	'REASON_CODE',
	'W_EMPTRANPROM',
	'EV019',
	'Mid-term Revision',
	'Mid-term Revision',
	SYSDATE,
	'BASE',
	'BASE',
	'Y',
	'I',
	NULL,
	NULL
);


INSERT INTO GENCODES 
(
	FLD_NAME ,
	MOD_NAME ,
	FLD_VALUE ,
	DESCR ,
	SH_DESCR ,
	CHG_DATE ,
	CHG_USER ,
	CHG_TERM ,
	ACTIVE ,
	UDF_STR1 ,
	UDF_STR2 ,
	UDF_STR3 
)
VALUES 
(
	'REASON_CODE',
	'W_EMPTRANPROM',
	'EV020',
	'Compliance',
	'Compliance',
	SYSDATE,
	'BASE',
	'BASE',
	'Y',
	'I',
	NULL,
	NULL
);


INSERT INTO GENCODES 
(
	FLD_NAME ,
	MOD_NAME ,
	FLD_VALUE ,
	DESCR ,
	SH_DESCR ,
	CHG_DATE ,
	CHG_USER ,
	CHG_TERM ,
	ACTIVE ,
	UDF_STR1 ,
	UDF_STR2 ,
	UDF_STR3 
)
VALUES 
(
	'REASON_CODE',
	'W_EMPTRANPROM',
	'EV021',
	'Other',
	'Other',
	SYSDATE,
	'BASE',
	'BASE',
	'Y',
	'I',
	NULL,
	NULL
);

INSERT INTO GENCODES 
(
	FLD_NAME ,
	MOD_NAME ,
	FLD_VALUE ,
	DESCR ,
	SH_DESCR ,
	CHG_DATE ,
	CHG_USER ,
	CHG_TERM ,
	ACTIVE ,
	UDF_STR1 ,
	UDF_STR2 ,
	UDF_STR3 
)
VALUES 
(
	'REASON_CODE',
	'W_EMPTRANPROM',
	'EV022',
	'Merit',
	'Merit',
	SYSDATE,
	'BASE',
	'BASE',
	'Y',
	'I',
	NULL,
	NULL
);


INSERT INTO GENCODES 
(
	FLD_NAME ,
	MOD_NAME ,
	FLD_VALUE ,
	DESCR ,
	SH_DESCR ,
	CHG_DATE ,
	CHG_USER ,
	CHG_TERM ,
	ACTIVE ,
	UDF_STR1 ,
	UDF_STR2 ,
	UDF_STR3 
)
VALUES 
(
	'REASON_CODE',
	'W_EMPTRANPROM',
	'EV023',
	'Counter Offer',
	'Counter Offer',
	SYSDATE,
	'BASE',
	'BASE',
	'Y',
	'I',
	NULL,
	NULL
);

INSERT INTO GENCODES 
(
	FLD_NAME ,
	MOD_NAME ,
	FLD_VALUE ,
	DESCR ,
	SH_DESCR ,
	CHG_DATE ,
	CHG_USER ,
	CHG_TERM ,
	ACTIVE ,
	UDF_STR1 ,
	UDF_STR2 ,
	UDF_STR3 
)
VALUES 
(
	'REASON_CODE',
	'W_EMPTRANPROM',
	'EV024',
	'Warning',
	'Warning',
	SYSDATE,
	'BASE',
	'BASE',
	'Y',
	'A',
	NULL,
	NULL
);


INSERT INTO GENCODES 
(
	FLD_NAME ,
	MOD_NAME ,
	FLD_VALUE ,
	DESCR ,
	SH_DESCR ,
	CHG_DATE ,
	CHG_USER ,
	CHG_TERM ,
	ACTIVE ,
	UDF_STR1 ,
	UDF_STR2 ,
	UDF_STR3 
)
VALUES 
(
	'REASON_CODE',
	'W_EMPTRANPROM',
	'EV025',
	'Penal Action',
	'Penal Action',
	SYSDATE,
	'BASE',
	'BASE',
	'Y',
	'A',
	NULL,
	NULL
);


INSERT INTO GENCODES 
(
	FLD_NAME ,
	MOD_NAME ,
	FLD_VALUE ,
	DESCR ,
	SH_DESCR ,
	CHG_DATE ,
	CHG_USER ,
	CHG_TERM ,
	ACTIVE ,
	UDF_STR1 ,
	UDF_STR2 ,
	UDF_STR3 
)
VALUES 
(
	'REASON_CODE',
	'W_EMPTRANPROM',
	'EV026',
	'Pending Enquiry',
	'Pending Enquiry',
	SYSDATE,
	'BASE',
	'BASE',
	'Y',
	'A',
	NULL,
	NULL
);


INSERT INTO GENCODES 
(
	FLD_NAME ,
	MOD_NAME ,
	FLD_VALUE ,
	DESCR ,
	SH_DESCR ,
	CHG_DATE ,
	CHG_USER ,
	CHG_TERM ,
	ACTIVE ,
	UDF_STR1 ,
	UDF_STR2 ,
	UDF_STR3 
)
VALUES 
(
	'REASON_CODE',
	'W_EMPTRANPROM',
	'EV027',
	'Suspension',
	'Suspension',
	SYSDATE,
	'BASE',
	'BASE',
	'Y',
	'A',
	NULL,
	NULL
);

INSERT INTO GENCODES 
(
	FLD_NAME ,
	MOD_NAME ,
	FLD_VALUE ,
	DESCR ,
	SH_DESCR ,
	CHG_DATE ,
	CHG_USER ,
	CHG_TERM ,
	ACTIVE ,
	UDF_STR1 ,
	UDF_STR2 ,
	UDF_STR3 
)
VALUES 
(
	'REASON_CODE',
	'W_EMPTRANPROM',
	'EV028',
	'Deputation',
	'Deputation',
	SYSDATE,
	'BASE',
	'BASE',
	'Y',
	'D',
	NULL,
	NULL
);


INSERT INTO GENCODES 
(
	FLD_NAME ,
	MOD_NAME ,
	FLD_VALUE ,
	DESCR ,
	SH_DESCR ,
	CHG_DATE ,
	CHG_USER ,
	CHG_TERM ,
	ACTIVE ,
	UDF_STR1 ,
	UDF_STR2 ,
	UDF_STR3 
)
VALUES 
(
	'REASON_CODE',
	'W_EMPTRANPROM',
	'EV029',
	'Demotion',
	'Demotion',
	SYSDATE,
	'BASE',
	'BASE',
	'Y',
	'E',
	NULL,
	NULL
);


INSERT INTO GENCODES 
(
	FLD_NAME ,
	MOD_NAME ,
	FLD_VALUE ,
	DESCR ,
	SH_DESCR ,
	CHG_DATE ,
	CHG_USER ,
	CHG_TERM ,
	ACTIVE ,
	UDF_STR1 ,
	UDF_STR2 ,
	UDF_STR3 
)
VALUES 
(
	'REASON_CODE',
	'W_EMPTRANPROM',
	'EV030',
	'Holiday Table Change',
	'Holiday Table Change',
	SYSDATE,
	'BASE',
	'BASE',
	'Y',
	'H',
	NULL,
	NULL
);


INSERT INTO GENCODES 
(
	FLD_NAME ,
	MOD_NAME ,
	FLD_VALUE ,
	DESCR ,
	SH_DESCR ,
	CHG_DATE ,
	CHG_USER ,
	CHG_TERM ,
	ACTIVE ,
	UDF_STR1 ,
	UDF_STR2 ,
	UDF_STR3 
)
VALUES 
(
	'REASON_CODE',
	'W_EMPTRANPROM',
	'EV031',
	'Shift Pattern Change',
	'Shift Pattern Change',
	SYSDATE,
	'BASE',
	'BASE',
	'Y',
	'W',
	NULL,
	NULL
);


COMMIT;

DELETE FROM GENMST WHERE FLD_NAME='RELIGION' AND MOD_NAME IN ('W_EMP_DET_CHG','W_EMP_COMPLETE','W_EMPCOMPLETE');
COMMIT;

INSERT INTO GENMST 
(
	FLD_NAME,
	MOD_NAME,
	DESCR,
	ERROR_CD,
	BLANK_OPT,
	FLD_TYPE,
	FLD_MIN,
	FLD_MAX,
	VAL_TYPE,
	CHG_DATE,
	CHG_USER,
	CHG_TERM,
	FORM_NO
)
VALUES 
(
	'RELIGION',
	'X',
	'Religion validation against gencodes',
	'GVRELIG001',
	'N',
	'C',
	NULL,
	NULL,
	'M',
	SYSDATE,
	'BASE',
	'BASE',
	'1'
);

COMMIT;

UPDATE OBJ_ITEMCHANGE SET FIELD_NAME = 'reason_code' WHERE FIELD_NAME='reson_code' AND OBJ_NAME IN ('emp_status','emptranprom') AND FORM_NO='1';
COMMIT;
