/*
 * Decompiled with CFR 0.152.
 */
package ibase.e12ria.client;

import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.HasKeyboardSelectionPolicy;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.MenuBar;
import com.google.gwt.user.client.ui.MenuItem;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.xml.client.Document;
import com.google.gwt.xml.client.Node;
import com.google.gwt.xml.client.NodeList;
import com.google.gwt.xml.client.XMLParser;
import ibase.e12ria.client.E12AdvDataGrid;
import ibase.e12ria.client.E12CommonUtils;
import ibase.e12ria.client.E12Global;
import ibase.e12ria.client.LinkActionInfoBean;
import ibase.e12ria.client.MetaDataNodeObj;
import ibase.e12ria.client.ObjDetails;
import ibase.e12ria.client.WizardPageUtils;
import ibase.e12ria.client.resources.Resources;
import ibase.e12ria.e12table.client.DataGridTableRowModel;
import ibase.e12ria.e12table.client.E12CustomTextCell;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.TreeMap;

public class E12DataTable
extends Widget {
    protected boolean isAnyRowSelected = false;
    private int formNo;
    private String objName;
    private WizardPageUtils wizPageUtils;
    private E12AdvDataGrid e12AdvDataGrid;
    private ScrollPanel scrlPanel;
    private TreeMap<Integer, MetaDataNodeObj> dataGridTableHeaderMap = new TreeMap();
    private TreeMap<Integer, Object> dataGridTableColumnMap = new TreeMap();

    public E12DataTable(int pageSize, WizardPageUtils wizPageUtils) {
        this.wizPageUtils = wizPageUtils;
        this.objName = wizPageUtils.getObjName();
        this.e12AdvDataGrid = new E12AdvDataGrid(pageSize, Resources.DATAGRID_RES){

            @Override
            public void createContextMenu() {
                E12DataTable.this.populateContextMenu();
            }

            @Override
            public void performDoubleClick() {
            }
        };
        this.e12AdvDataGrid.setKeyboardSelectionPolicy(HasKeyboardSelectionPolicy.KeyboardSelectionPolicy.DISABLED);
        this.e12AdvDataGrid.setWizPageUtils(wizPageUtils);
    }

    public void initWidget(int formNo, ScrollPanel scrlPanel) {
        try {
            this.formNo = formNo;
            this.scrlPanel = scrlPanel;
            String tabType = ObjDetails.get(this.objName).getObjFormDetails(formNo).getScrFlag();
            String tokenizedStr = E12Global.E12Storage.getItem(String.valueOf(this.objName) + "_" + formNo + "_" + tabType);
            HashMap<String, ArrayList> tokenizedMap = E12CommonUtils.getInstance().parseTokenizedString(tokenizedStr);
            ArrayList colObjList = tokenizedMap.get("ColumnObject");
            ArrayList txtObjList = tokenizedMap.get("TextObject");
            ArrayList tableColObjList = tokenizedMap.get("table_column");
            String pkFelds = "";
            String allFelds = "";
            int tableColObjCtr = 0;
            while (tableColObjCtr < tableColObjList.size()) {
                HashMap tableObjNodValMap = (HashMap)tableColObjList.get(tableColObjCtr);
                String keyVal = (String)tableObjNodValMap.get("key");
                String colName = (String)tableObjNodValMap.get("name");
                if (keyVal != null && !"".equalsIgnoreCase(keyVal) && keyVal.equalsIgnoreCase("yes")) {
                    pkFelds = pkFelds != null && pkFelds.length() > 0 ? String.valueOf(pkFelds) + "~" + colName : colName;
                }
                allFelds = allFelds != null && allFelds.length() > 0 ? String.valueOf(allFelds) + "~" + colName : colName;
                ++tableColObjCtr;
            }
            this.e12AdvDataGrid.setPKColumnNames(pkFelds);
            this.e12AdvDataGrid.setHeaderColNames(allFelds);
            int textObjCtr = 0;
            while (textObjCtr < txtObjList.size()) {
                HashMap txtObjNodValMap = (HashMap)txtObjList.get(textObjCtr);
                String alignmentTxtObj = (String)txtObjNodValMap.get("alignment");
                String textTxtObj = (String)txtObjNodValMap.get("text");
                String xCordinateTxtObj = (String)txtObjNodValMap.get("x");
                String yCordinateTxtObj = (String)txtObjNodValMap.get("y");
                String heightTxtObj = (String)txtObjNodValMap.get("height");
                String widthTxtObj = (String)txtObjNodValMap.get("width");
                String nameTxtObj = E12Global.checkNull((String)txtObjNodValMap.get("name"));
                if (nameTxtObj.endsWith("_t")) {
                    nameTxtObj = nameTxtObj.substring(0, nameTxtObj.lastIndexOf("_t"));
                }
                String visibleTxtObj = (String)txtObjNodValMap.get("visible");
                MetaDataNodeObj txtBeanObj = new MetaDataNodeObj(textTxtObj, alignmentTxtObj, xCordinateTxtObj, yCordinateTxtObj, heightTxtObj, widthTxtObj, visibleTxtObj, "Txt", null, nameTxtObj, null, null, null, null, null, null);
                this.dataGridTableHeaderMap.put(textObjCtr + 1, txtBeanObj);
                ++textObjCtr;
            }
            int colObjCtr = 0;
            while (colObjCtr < colObjList.size()) {
                HashMap colObjNodValMap = (HashMap)colObjList.get(colObjCtr);
                String alignmentColObj = (String)colObjNodValMap.get("alignment");
                String tabSeqColObj = (String)colObjNodValMap.get("tabsequence");
                String xCordinateColObj = (String)colObjNodValMap.get("x");
                String yCordinateColObj = (String)colObjNodValMap.get("y");
                String heightColObj = (String)colObjNodValMap.get("height");
                String widthColObj = (String)colObjNodValMap.get("width");
                String formatColObj = (String)colObjNodValMap.get("format");
                String nameColObj = (String)colObjNodValMap.get("name");
                String visibleColObj = (String)colObjNodValMap.get("visible");
                String editStyleColObj = (String)colObjNodValMap.get("EditStyle");
                String limitColObj = (String)colObjNodValMap.get("limit");
                String requiredColObj = (String)colObjNodValMap.get("required");
                String popHelpColObj = "";
                String textCaseColObj = (String)colObjNodValMap.get("case");
                if (this.wizPageUtils.isPopHelpField(nameColObj)) {
                    popHelpColObj = "true";
                }
                for (int index : this.dataGridTableHeaderMap.keySet()) {
                    MetaDataNodeObj txtBeanObj = this.dataGridTableHeaderMap.get(index);
                    MetaDataNodeObj colBeanObj = null;
                    if (!nameColObj.equalsIgnoreCase(txtBeanObj.getName())) continue;
                    colBeanObj = new MetaDataNodeObj(txtBeanObj.getText(), alignmentColObj, xCordinateColObj, yCordinateColObj, heightColObj, widthColObj, visibleColObj, "Col", tabSeqColObj, nameColObj, formatColObj, popHelpColObj, editStyleColObj, limitColObj, requiredColObj, textCaseColObj);
                    this.dataGridTableColumnMap.put(index, colBeanObj);
                    break;
                }
                ++colObjCtr;
            }
            this.wizPageUtils.getFormsWidgetMap().put(formNo, this);
        }
        catch (Exception e) {
            Window.alert((String)("E12DataTable : initWidget :" + e.getMessage()));
        }
    }

    public ScrollPanel getContainer() {
        if (this.scrlPanel == null) {
            this.scrlPanel = new ScrollPanel();
        }
        return this.scrlPanel;
    }

    public void createTableComponent(int formNo, String responseStr) {
        try {
            ArrayList<DataGridTableRowModel> dataGridTableRowList = new ArrayList<DataGridTableRowModel>();
            Document doc = XMLParser.parse((String)responseStr);
            XMLParser.removeWhitespace((Node)doc);
            NodeList detailNodeList = doc.getElementsByTagName("Detail" + formNo);
            int len = 0;
            if (detailNodeList != null) {
                len = detailNodeList.getLength();
            }
            int cntr = 0;
            while (cntr < len) {
                String domID = "1";
                HashMap<Integer, E12CustomTextCell.CellData> rowData = new HashMap<Integer, E12CustomTextCell.CellData>();
                Node detailNode = detailNodeList.item(cntr);
                HashMap<String, String> detailMap = E12CommonUtils.getInstance().parseNode(detailNode);
                if (detailMap.containsKey("Detail" + formNo + ".domID")) {
                    domID = E12Global.checkNull(detailMap.get("Detail" + formNo + ".domID"));
                }
                E12CustomTextCell.CellData cellDataSel = new E12CustomTextCell.CellData(0, "false");
                cellDataSel.setName("selected");
                if (detailMap.containsKey("Detail" + formNo + ".selected")) {
                    cellDataSel.setData(E12Global.checkNull(detailMap.get("Detail" + formNo + ".selected")));
                } else if (detailMap.containsKey("attribute.selected")) {
                    cellDataSel.setData(E12Global.checkNull(detailMap.get("attribute.selected")));
                }
                rowData.put(0, cellDataSel);
                block5: for (String nodeName : detailMap.keySet()) {
                    if (nodeName.indexOf(".") != -1) continue;
                    for (int index : this.dataGridTableColumnMap.keySet()) {
                        MetaDataNodeObj colBeanObj = (MetaDataNodeObj)this.dataGridTableColumnMap.get(index);
                        if (!nodeName.equalsIgnoreCase(colBeanObj.getName())) continue;
                        String data = detailMap.get(nodeName);
                        data = this.wizPageUtils.changeTextCase(data, colBeanObj.getTextCase());
                        E12CustomTextCell.CellData cellData = new E12CustomTextCell.CellData(index, data);
                        cellData.setName(nodeName);
                        cellData.setProtect("1".equals(detailMap.get(String.valueOf(nodeName) + "." + "protect")) || "32766".equalsIgnoreCase(colBeanObj.getTab()));
                        int limit = 0;
                        try {
                            limit = (int)Double.parseDouble(colBeanObj.getLimit().trim());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        cellData.setLimit(limit);
                        cellData.setMandatory("yes".equals(colBeanObj.getRequired()));
                        cellData.setPophelp("true".equals(colBeanObj.getPopHelp()));
                        cellData.setNumber("1".equals(colBeanObj.getAlignment()));
                        cellData.setWidth(colBeanObj.getWidth());
                        cellData.setItemChanged(this.wizPageUtils.isItemChangeField(formNo, nodeName));
                        cellData.setTextCase(colBeanObj.getTextCase());
                        rowData.put(index, cellData);
                        continue block5;
                    }
                }
                dataGridTableRowList.add(new DataGridTableRowModel(domID, rowData));
                ++cntr;
            }
            this.scrlPanel.clear();
            this.scrlPanel.add((Widget)this.e12AdvDataGrid.createTableComponent(dataGridTableRowList, this.dataGridTableColumnMap));
            this.scrlPanel.setWidth("100%");
        }
        catch (Exception e) {
            Window.alert((String)("E12DataTable Exception:" + e.getMessage()));
        }
    }

    protected void populateContextMenu() {
        int menuSize = 0;
        int count = 0;
        ScrollPanel scrllPnl = new ScrollPanel();
        MenuBar popupMenuBar = new MenuBar(true);
        HashMap<String, LinkActionInfoBean> linkActionInfoMap = this.wizPageUtils.getLinkActionInfoMap();
        if (linkActionInfoMap != null) {
            for (String key : linkActionInfoMap.keySet()) {
                final LinkActionInfoBean linkActionInfoBean = linkActionInfoMap.get(key);
                String formNoStr = linkActionInfoBean.getFormNo();
                if (!formNoStr.equalsIgnoreCase(String.valueOf(this.formNo))) continue;
                int linklength = linkActionInfoBean.getTitle().length();
                if (linklength > 29) {
                    ++count;
                }
                MenuItem linkActionctionItem = new MenuItem(linkActionInfoBean.getTitle(), true, new Command(){

                    public void execute() {
                        E12DataTable.this.e12AdvDataGrid.hideContextMenu();
                        E12CommonUtils.getInstance().performLinkAction(linkActionInfoBean, E12DataTable.this.e12AdvDataGrid.getPKFieldValue(), E12DataTable.this.objName, E12DataTable.this.e12AdvDataGrid.getHeaderColNames(), true, E12DataTable.this.e12AdvDataGrid.getSeletedDataGridTRModel());
                    }
                });
                popupMenuBar.addItem(linkActionctionItem);
                popupMenuBar.addSeparator();
                ++menuSize;
            }
        }
        scrllPnl.add((Widget)popupMenuBar);
        this.e12AdvDataGrid.initContextMenu(scrllPnl, menuSize, count);
    }

    protected void setCheckBoxes(boolean value) {
        try {
            if (this.e12AdvDataGrid.getDataProvider() != null) {
                Column chkBoxColumn = this.e12AdvDataGrid.getColumn(0);
                List rowDataList = this.e12AdvDataGrid.getDataProvider().getList();
                int itemsLen = rowDataList.size();
                int rowsCtr = 0;
                while (rowsCtr < itemsLen) {
                    DataGridTableRowModel rowData = (DataGridTableRowModel)rowDataList.get(rowsCtr);
                    chkBoxColumn.getFieldUpdater().update(rowsCtr, (Object)rowData, (Object)value);
                    ++rowsCtr;
                }
                this.e12AdvDataGrid.getDataProvider().refresh();
            }
        }
        catch (Exception e) {
            Window.alert((String)("Exception in setCheckBoxes : " + e.getMessage()));
        }
    }

    public E12AdvDataGrid getDataTable() {
        return this.e12AdvDataGrid;
    }
}

