package ibase.dashboard.sfa.ejb;
import ibase.system.config.ConnDriver;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import javax.ejb.Stateless;
import org.json.simple.JSONObject;
/**
 * Session Bean implementation class SalesPersonSales
 */
@Stateless
public class LiveEventDetails extends ValidatorEJB implements LiveEventDetailsLocal, LiveEventDetailsRemote
{
	public LiveEventDetails() {
        // TODO Auto-generated constructor stub
    }
	 GenericUtility genericUtility = GenericUtility.getInstance();
    @SuppressWarnings("unchecked")
	
    public JSONObject getActiveEvent(String dataSourceName) throws RemoteException, ITMException
    {
		JSONObject rawDataActiveEventlJson = new JSONObject();
		JSONObject rowData = null;
		String sql         = "";
		ResultSet rs       = null;
		PreparedStatement pstmt = null;
		Connection conn    = null;
		ConnDriver connDriver = new ConnDriver();	
		try
		{			
			conn = connDriver.getConnectDB(dataSourceName);
			connDriver = null;
			
			/*Final SQL on dated 22082016*/
			
			sql="SELECT st.survey_templ, st.descr AS active_event, " +
				"(SELECT LEN(SCOPE_VAL_DESCR) - LEN(REPLACE(SCOPE_VAL_DESCR, ',', ''))+1 AS No_Of_PARTICIPANTS " +
				"FROM dbo.SCOPE_VALUE WHERE SCOPE_CODE= (SELECT MAX(SCOPE_CODE) " +
				"FROM dbo.survey_config_appl WHERE APPL_ENTITY='E' and  SURVEY_ID= (SELECT MAX(SURVEY_ID) " +
				"FROM dbo.survey_config WHERE SURVEY_TEMPL=st.survey_templ))) AS No_Of_PARTICIPANTS, " +
				"CONVERT(VARCHAR(19),st.valid_upto,110) AS exp_date FROM dbo.survey_config sc " +
				"INNER JOIN dbo.survey_template st ON st.survey_templ=sc.survey_templ " +
				"INNER JOIN dbo.survey_config_appl scp ON scp.survey_id =sc.survey_id " +
				"WHERE scp.appl_entity='E' AND CONVERT(VARCHAR(19),GETDATE(),106) BETWEEN st.eff_from " +
				"AND st.valid_upto GROUP BY st.descr , st.survey_templ, st.valid_upto ";
		
			
			
			pstmt = conn.prepareStatement(sql);
			rs    = pstmt.executeQuery();
			int count = 0;				
			while (rs.next())
			{
				rowData = new JSONObject();
				rowData.put("active_event",checkNull (rs.getString("ACTIVE_EVENT")));
				rowData.put("no_of_participants",checkNull (rs.getString("NO_OF_PARTICIPANTS")));
				rowData.put("exp_date",checkNull (rs.getString("EXP_DATE")));
				rowData.put("survey_templ",checkNull (rs.getString("SURVEY_TEMPL")));
				rawDataActiveEventlJson.put(count, rowData);
				count++;
			}
			rs.close();
			rs=null;
			pstmt.close();
			pstmt=null;
		}
		catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
					rs.close();
					rs = null;
					if (pstmt != null)
					pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in :LiveEventDetails getActiveEvent :" + d.getMessage());
				throw new ITMException(d);
			}
		}		
		return rawDataActiveEventlJson;		
	}
    
    @SuppressWarnings("unchecked")    
    public JSONObject getParticipentEventSummary(String dataSourceName,String eventCode) throws RemoteException, ITMException
    {
    	JSONObject rawDataParticipentEventSummaryJson = new JSONObject();
		JSONObject rowData      = null;
		String sql              = "";
		ResultSet rs            = null;
		PreparedStatement pstmt = null;
		Connection conn         = null;
		ConnDriver connDriver   = new ConnDriver();
			
		try
		{
			System.out.println(" Inside LiveEventDetails for getParticipentEventSummary Data Soruc Name ="+dataSourceName+ "==== eventCode :"+eventCode);
			conn = connDriver.getConnectDB (dataSourceName);
			connDriver = null;
		
			/*Final Sql*/
			if(eventCode!=null)
			{
			sql = "SELECT code, PARTICIPANTS_NAME, result, count_m AS No_of_Evaluation, perce, " +
				  "RANK() over (order by perce DESC ) AS rank FROM ( select code, " +
				  "PARTICIPANTS_NAME, COUNT(DISTINCT TRAN_ID) as count_m, SUM(result) as result, " +
				  "sum(result)*100/( COUNT(DISTINCT TRAN_ID))/( SELECT SUM(result_range_max) " +
				  "FROM dbo.survey_master WHERE survey_code IN ( SELECT survey_code FROM dbo.survey_templ_det " +
				  "WHERE survey_templ='"+eventCode+"' ))AS perce  from ( SELECT srd.TRAN_ID, emp.code, " +
				  "emp.firstname +' '+ emp.lastname AS PARTICIPANTS_NAME,  case when  ISNUMERIC(RESULT)=1 " +
				  "then (srd.result ) else 0 end as result, srd.TRAN_ID  AS count_m   " +
				  "FROM dbo.SURVEY_CONFIG sc INNER JOIN ( SELECT * FROM dbo.survey_config_appl " +
				  "WHERE appl_entity='E' ) sca ON sca.survey_id=sc.SURVEY_ID " +
				  "INNER JOIN dbo.SURVEY_FORM sf ON sf.SURVEY_ID=sc.SURVEY_ID " +
				  "INNER JOIN dbo.SURVEY_RESULT sr ON sr.tran_id__form=sf.tran_id " +
				  "INNER JOIN dbo.SURVEY_RESULT_DET srd ON srd.TRAN_ID=sr.TRAN_ID " +
				  "INNER JOIN ( SELECT * FROM dbo.survey_result_appl WHERE appl_entity='E' ) " +
				  "sra ON sra.TRAN_ID=srd.tran_id INNER JOIN dbo.SCOPE_VALUE sv ON sv.scope_code=sca.scope_code" +
				  " INNER JOIN ( SELECT SCOPE_CODE AS CODE, LTRIM(RTRIM(m.n.value('.[1]','varchar(8000)'))) " +
				  "AS EMP_CODE FROM ( SELECT SCOPE_CODE, CAST('<XMLRoot><RowData>' + REPLACE(SCOPE_VAL_DESCR,',', '</RowData><RowData>')    + '</RowData></XMLRoot>' AS XML) AS x " +
				  "FROM dbo.SCOPE_VALUE ) t CROSS APPLY x.nodes('/XMLRoot/RowData')m(n) ) A ON a.code =sv.scope_code " +
				  "AND A.EMP_CODE=sra.ENTITY_CODE INNER JOIN dbo.employee emp ON emp.code=A.EMP_CODE " +
				  "WHERE SURVEY_TEMPL='"+eventCode+"' " +
				  /*"GROUP BY emp.code, emp.firstname +' '+ emp.lastname, sca.scope_code,srd.result,srd.TRAN_ID  */") b " +
				  "group by code, PARTICIPANTS_NAME ) a ORDER BY rank ";
				
			pstmt     = conn.prepareStatement(sql);
			rs        = pstmt.executeQuery();
			int count = 0;				
			while (rs.next())
			{
				rowData = new JSONObject();
				rowData.put("participants_code",checkNull (rs.getString("CODE")));
				rowData.put("participants_name",checkNull (rs.getString("PARTICIPANTS_NAME")));
				rowData.put("no_of_evaluation",checkNull (rs.getString("NO_OF_EVALUATION")));
				rowData.put("marks_obtained",checkNull (rs.getString("RESULT")));	 
				rowData.put("rank", checkNull(rs.getString("RANK")));				
				rawDataParticipentEventSummaryJson.put(count, rowData);
				count++;
			}
			rs.close();
			rs=null;
			pstmt.close();
			pstmt=null;
		  }
		}			
		catch (Exception  e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
					rs.close();
					rs = null;
					if (pstmt != null)
					pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in :getParticipentEventSummary:" + d.getMessage());
				throw new ITMException(d);
			}
		}
		System.out.println("LiveEventDetails  rawDataParticipentEventSummaryJson String======>>"+rawDataParticipentEventSummaryJson.toString());
	    return rawDataParticipentEventSummaryJson;
    }
          
    @SuppressWarnings("unchecked")
   
    public JSONObject getParticipentEventDetail(String dataSourceName,String eventCode,String participentCode) throws RemoteException, ITMException
    {
    	JSONObject rawDataParticipentEventDetailJson = new JSONObject();
		JSONObject rowData      = null;
		String sql              = "";
		ResultSet rs            = null;
		PreparedStatement pstmt = null;
		Connection conn         = null;
		ConnDriver connDriver   = new ConnDriver();
					
		try
		{
			System.out.println(" Inside LiveEventDetails for getParticipentEventDetail Data Soruc Name ="+dataSourceName+ "==== participentCode :"+participentCode+"eventCode==="+eventCode);
			conn = connDriver.getConnectDB(dataSourceName);
			connDriver = null;
		
			
        	
	
	       /*Final sql*/
	if(participentCode!=null && eventCode!=null)
	{
		System.out.println(" Inside LiveEventDetails for getParticipentEventDetail Data Soruc Name ="+dataSourceName+ "==== participentCode :"+participentCode+"eventCode==="+eventCode);
		
		sql=" WITH as_det (zone,region,team,emp_code,name,FIRSTNAME,MGR,nos,total)AS ( SELECT e.ZONECODE ZONE, r.Name AS REGION, e.teamcode TEAM, e.code AS emp_code, (e.FIRSTNAME +' '+ e.LASTNAME) NAME, SUR.MGR, emp.FIRSTNAME, COUNT(SUR.MGR) NOS, SUM(SUR.RESULT) TOTAL FROM dbo.employee e INNER JOIN dbo.REGION r ON e.regionid = r.id INNER JOIN ( SELECT APP.ENTITY_CODE EMP_CODE, SRE.EMP_CODE MGR, SUM(CAST(SRD.result AS INT)) RESULT FROM dbo.survey_result_EMP SRE INNER JOIN dbo.survey_result SR ON SRE.TRAN_ID = SR.TRAN_ID__FORM INNER JOIN (  SELECT code, a, b, PARTICIPANTS_NAME, sum( result) as result, count_m FROM ( SELECT emp.code, srd.TRAN_ID                      AS a, sra.TRAN_ID AS b, emp.firstname +' '+ emp.lastname AS PARTICIPANTS_NAME, case when  ISNUMERIC(RESULT)=1 then (srd.result ) else 0 end AS result, COUNT(DISTINCT srd.TRAN_ID)      AS count_m FROM dbo.SURVEY_CONFIG sc INNER JOIN ( SELECT * FROM dbo.survey_config_appl WHERE appl_entity='E' ) sca ON sca.survey_id=sc.SURVEY_ID INNER JOIN dbo.SURVEY_FORM sf ON sf.SURVEY_ID=sc.SURVEY_ID INNER JOIN dbo.SURVEY_RESULT sr ON sr.tran_id__form=sf.tran_id INNER JOIN dbo.SURVEY_RESULT_DET srd ON srd.TRAN_ID=sr.TRAN_ID LEFT JOIN ( SELECT * FROM dbo.survey_result_appl WHERE appl_entity='E' ) sra ON sra.TRAN_ID=srd.tran_id INNER JOIN dbo.SCOPE_VALUE sv ON sv.scope_code=sca.scope_code LEFT JOIN ( SELECT SCOPE_CODE  AS CODE, LTRIM(RTRIM(m.n.value('.[1]','varchar(8000)'))) AS EMP_CODE FROM ( SELECT SCOPE_CODE, CAST('<XMLRoot><RowData>'  + REPLACE(SCOPE_VAL_DESCR, ',','</RowData><RowData>') + '</RowData></XMLRoot>' AS XML) AS x FROM dbo.SCOPE_VALUE ) t CROSS APPLY x.nodes('/XMLRoot/RowData')m(n) ) A ON a.code      =sv.scope_code AND A.EMP_CODE=sra.ENTITY_CODE LEFT JOIN dbo.employee emp ON emp.code =A.EMP_CODE " +
				"WHERE SURVEY_TEMPL='"+eventCode+"' " +
				"GROUP BY srd.TRAN_ID, sra.TRAN_ID, emp.code, emp.firstname +' '+ emp.lastname, sca.scope_code, srd.result ) a group by code, a, b, PARTICIPANTS_NAME, count_m ) SRD ON SR.TRAN_ID = SRD.B INNER JOIN ( SELECT * FROM dbo.survey_result_appl WHERE APPL_ENTITY = 'E' ) APP ON SRD.B = APP.TRAN_ID GROUP BY APP.ENTITY_CODE, SRE.EMP_CODE    ) SUR ON e.code = SUR.EMP_CODE INNER JOIN Employee emp ON emp.code =sur.mgr " +
				"WHERE e.code='"+participentCode+"' " +
				"GROUP BY e.ZONECODE, r.Name, e.teamcode, e.code, SUR.MGR, emp.FIRSTNAME, (e.FIRSTNAME +' '+ e.LASTNAME) ) SELECT * FROM as_det";
		
				pstmt = conn.prepareStatement(sql);
				rs    = pstmt.executeQuery();
				int count = 0;	
			    while (rs.next())
			     {		    	
			    	rowData = new JSONObject();	
			    	rowData.put("participants_code",checkNull (rs.getString("EMP_CODE")));
			    	rowData.put("mgr",checkNull( rs.getString("MGR")));
			        rowData.put("zone",checkNull (rs.getString("ZONE")));						
					rowData.put("region", checkNull(rs.getString("REGION")));
					rowData.put("team",checkNull( rs.getString("TEAM")));
					rowData.put("name", checkNull(rs.getString("NAME")));				
					rawDataParticipentEventDetailJson.put(count, rowData);
					count++;
			    }
			    rs.close();
				rs=null;
				pstmt.close();
				pstmt=null;
		  }
 	}//closed if block	
	catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
					rs.close();
					rs = null;
					if (pstmt != null)
					pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in :getParticipentEventDetail:" + d.getMessage());
				throw new ITMException(d);
			}
		}
		System.out.println("LiveEventDetails rawDataParticipentEventDetailJson String======>>"+rawDataParticipentEventDetailJson.toString());
	    return rawDataParticipentEventDetailJson;
    }
       
    @SuppressWarnings("unchecked")
    
    public JSONObject getParticipentProductDetail(String dataSourceName,String eventCode,String participentCode) throws RemoteException, ITMException
    {
    	JSONObject rawDataParticipentProductDetailJson = new JSONObject();
		JSONObject rowData      = null;
		String sql              = "";
		ResultSet rs            = null;
		PreparedStatement pstmt = null;
		Connection conn         = null;
		ConnDriver connDriver   = new ConnDriver();
		double percntVal        = 0.0;				
		try
		{
			System.out.println(" Inside LiveEventDetails for getParticipentEventDetail Data Soruc Name ="+dataSourceName+ "==== participentCode :"+participentCode+"eventCode==="+eventCode);
			conn = connDriver.getConnectDB(dataSourceName);
			connDriver = null;
		
			
	
	       /*Final sql*/
	if(participentCode!=null && eventCode!=null)
	{
		System.out.println(" Inside LiveEventDetails for getParticipentEventDetail Data Soruc Name ="+dataSourceName+ "==== participentCode :"+participentCode+"eventCode==="+eventCode);
	
		sql="WITH as_det1 (code,prd_name,mgr_name,mgr_code,perc,report,resultcnt,total, NEW_TRAN_ID) AS " +
				"(SELECT CODE, PRD_NAME, mgr_name, mgr_code, PERC, REPORT, RESULTCNT, TOTAL, NEW_TRAN_ID FROM " +
				"(SELECT DET_PRD.CODE, DET_PRD.b as NEW_TRAN_ID, DET_PRD.NAME , DET_PRD.mgr_name, DET_PRD.EMP_CODE AS mgr_code, " +
				"DET_PRD.PRD_NAME, RESULT, TOTAL, Str((RESULT * 100.0/TOTAL),4,1) AS PERC, 'Marks' AS REPORT," +
				" (RESULT)AS RESULTCNT FROM (SELECT e.CODE, SUM(SUR.RESULT) TOTAL FROM dbo.employee e " +
				"INNER JOIN dbo.REGION r ON e.regionid = r.id INNER JOIN (SELECT APP.ENTITY_CODE EMP_CODE," +
				" SRE.EMP_CODE MGR, SUM(CAST(SRD.result AS INT)) RESULT, APPR.ENTITY_CODE PRD_CODE," +
				" APPR.ENTITY_DESCR PRD_DESC, SR.TRAN_ID FROM dbo.survey_result_EMP SRE INNER JOIN " +
				"dbo.survey_result SR ON SRE.TRAN_ID = SR.TRAN_ID__FORM INNER JOIN ( " +
				"SELECT code, a, b, PARTICIPANTS_NAME, sum(result) as result, count_m FROM ( SELECT emp.code, " +
				"srd.TRAN_ID AS a, sra.TRAN_ID AS b, emp.firstname +' '+ emp.lastname AS PARTICIPANTS_NAME , " +
				"case when  ISNUMERIC(srd.result)=1 then (srd.result ) else 0 end AS result," +
				" COUNT(DISTINCT srd.TRAN_ID)      AS count_m FROM dbo.SURVEY_CONFIG sc INNER JOIN " +
				"( SELECT * FROM dbo.survey_config_appl WHERE appl_entity='E' ) sca ON " +
				"sca.survey_id=sc.SURVEY_ID INNER JOIN dbo.SURVEY_FORM sf ON sf.SURVEY_ID=sc.SURVEY_ID" +
				" INNER JOIN dbo.SURVEY_RESULT sr ON sr.tran_id__form=sf.tran_id INNER JOIN " +
				"dbo.SURVEY_RESULT_DET srd ON srd.TRAN_ID=sr.TRAN_ID LEFT JOIN ( SELECT * " +
				"FROM dbo.survey_result_appl WHERE appl_entity='E' ) sra ON sra.TRAN_ID=srd.tran_id INNER JOIN" +
				" dbo.SCOPE_VALUE sv ON sv.scope_code=sca.scope_code LEFT JOIN " +
				"(SELECT SCOPE_CODE AS CODE, LTRIM(RTRIM(m.n.value('.[1]','varchar(8000)'))) AS EMP_CODE " +
				"FROM (SELECT SCOPE_CODE, CAST('<XMLRoot><RowData>' + REPLACE( SCOPE_VAL_DESCR,',','</RowData>" +
				"<RowData>') + '</RowData></XMLRoot>' AS XML) AS x FROM dbo.SCOPE_VALUE ) t CROSS " +
				"APPLY x.nodes('/XMLRoot/RowData')m(n) ) A ON a.code     =sv.scope_code AND " +
				"A.EMP_CODE=sra.ENTITY_CODE LEFT JOIN dbo.employee emp ON emp.code =A.EMP_CODE " +
			"WHERE SURVEY_TEMPL='"+eventCode+"' " +
			"GROUP BY srd.TRAN_ID, sra.TRAN_ID, emp.code,srd.result, emp.firstname +' '+ emp.lastname, " +
			"sca.scope_code ) a group by code, a, b, PARTICIPANTS_NAME, count_m ) SRD ON" +
			" SR.TRAN_ID = SRD.b INNER JOIN ( SELECT * FROM dbo.survey_result_appl WHERE APPL_ENTITY = 'E' )" +
			" APP ON SRD.b = APP.TRAN_ID INNER JOIN ( SELECT * FROM dbo.survey_result_appl WHERE" +
			" APPL_ENTITY = 'I' ) APPR ON SRD.b = APPR.TRAN_ID GROUP BY APP.ENTITY_CODE, SRE.EMP_CODE, " +
			"APPR.ENTITY_CODE, APPR.ENTITY_DESCR, SR.TRAN_ID ) SUR ON e.code = SUR.EMP_CODE " +
			"WHERE e.code      = '"+participentCode+"' " +
			"GROUP BY e.CODE ) HDR INNER JOIN ( SELECT (e.FIRSTNAME +' '+ e.LASTNAME) NAME, APPR.ENTITY_DESCR " +
			"AS PRD_NAME , SUM(CAST(SRD.result AS INT)) RESULT , (SELECT firstname+ +''+lastname FROM " +
			"dbo.employee WHERE emp_code= SRE.emp_code ) AS mgr_name, SRE.emp_code, e.code, SRD.b FROM " +
			"dbo.survey_result_EMP SRE INNER JOIN dbo.survey_result SR ON SRE.TRAN_ID = SR.TRAN_ID__FORM " +
			"INNER JOIN (SELECT code, a, b, SURVEY_CODE, PARTICIPANTS_NAME, result, count_m FROM (  " +
			"select code, a, b,SURVEY_CODE, PARTICIPANTS_NAME, sum(result) as result, count_m from (" +
			"SELECT emp.code, srd.TRAN_ID AS a, sra.TRAN_ID AS b, srd.SURVEY_CODE, emp.firstname +' '+ " +
			"emp.lastname AS PARTICIPANTS_NAME, case when  ISNUMERIC(srd.RESULT)=1 then (srd.result ) else 0 " +
			"end AS result , COUNT(DISTINCT srd.TRAN_ID)      AS count_m FROM dbo.SURVEY_CONFIG sc INNER JOIN " +
			"( SELECT * FROM dbo.survey_config_appl WHERE appl_entity='E' ) sca ON sca.survey_id=sc.SURVEY_ID " +
			"INNER JOIN dbo.SURVEY_FORM sf ON sf.SURVEY_ID=sc.SURVEY_ID INNER JOIN dbo.SURVEY_RESULT sr " +
			"ON sr.tran_id__form=sf.tran_id INNER JOIN dbo.SURVEY_RESULT_DET srd ON srd.TRAN_ID=sr.TRAN_ID " +
			"LEFT JOIN ( SELECT * FROM dbo.survey_result_appl WHERE appl_entity='E' ) sra ON " +
			"sra.TRAN_ID=srd.tran_id INNER JOIN dbo.SCOPE_VALUE sv ON sv.scope_code=sca.scope_code " +
			"LEFT JOIN (SELECT SCOPE_CODE AS CODE, LTRIM(RTRIM(m.n.value('.[1]','varchar(8000)'))) AS " +
			"EMP_CODE FROM (SELECT SCOPE_CODE, CAST('<XMLRoot><RowData>' + REPLACE( SCOPE_VAL_DESCR,',','</RowData><RowData>') + '</RowData></XMLRoot>' AS XML) AS x FROM dbo.SCOPE_VALUE ) t CROSS APPLY x.nodes('/XMLRoot/RowData')m(n) ) A ON" +
			" a.code     =sv.scope_code AND A.EMP_CODE=sra.ENTITY_CODE LEFT JOIN dbo.employee emp ON emp.code" +
			"       =A.EMP_CODE " +
			"WHERE SURVEY_TEMPL='"+eventCode+"' " +
			"GROUP BY srd.TRAN_ID, sra.TRAN_ID, srd.SURVEY_CODE, emp.code,srd.result, emp.firstname +' '+ " +
			"emp.lastname, sca.scope_code ) b group by code, a, b,SURVEY_CODE, PARTICIPANTS_NAME, count_m ) a" +
			"  ) SRD ON SR.TRAN_ID = SRD.b INNER JOIN ( SELECT * FROM dbo.survey_result_appl WHERE " +
			"APPL_ENTITY = 'E' ) APP ON SRD.b = APP.TRAN_ID INNER JOIN ( SELECT * FROM dbo.survey_result_appl " +
			"WHERE APPL_ENTITY = 'I' ) APPR ON SRD.b = APPR.TRAN_ID INNER JOIN dbo.employee e ON " +
			"APP.ENTITY_CODE = e.code INNER JOIN dbo.survey_master sm ON SRD.SURVEY_CODE    = sm.SURVEY_CODE " +
			"WHERE APP.ENTITY_CODE = '"+participentCode+"' " +
			"GROUP BY (e.FIRSTNAME +' '+ e.LASTNAME) , APPR.ENTITY_DESCR , e.code, SRE.emp_code, SRD.b  ) DET_PRD ON " +
			" HDR.CODE = DET_PRD.CODE ) X WHERE upper(report)='MARKS' ) SELECT as_det1.code,as_det1.prd_name, " +
			"as_det1.mgr_name, as_det1.mgr_code, as_det1.perc, as_det1.report, as_det1.resultcnt, as_det1.total, " +
			"(SELECT SUM(result_range_max) AS tot_marks FROM dbo.survey_master WHERE survey_code IN " +
			"(SELECT survey_code FROM dbo.survey_templ_det " +
			"WHERE survey_templ='"+eventCode+"' " +
			") ) outof_marks , ( employee.firstname +' '+ employee.lastname) AS emp_name,'"+eventCode+"' as survey_templ, as_det1.NEW_TRAN_ID " +
			"FROM as_det1 INNER JOIN employee ON as_det1.code=employee.code ";
	
	
		

		
		
	            pstmt = conn.prepareStatement(sql);
				rs    = pstmt.executeQuery();
				int count = 0;	
				double percentage = 0.0D; double totalCircle = 629.0D; double dashOffSet = 0.0D;
			    double rsltCnt = 0.0D; double total = 0.0D;
			    while (rs.next())
			     {
				rowData = new JSONObject();
		        rsltCnt = Double.parseDouble(checkNull(rs.getString("RESULTCNT")));
		        total   = Double.parseDouble(checkNull(rs.getString("OUTOF_MARKS")));
		        //total   = Double.parseDouble(checkNull(rs.getString("TOTAL")));
		        
		        System.out.println("rsltCnt:" + rsltCnt);
		        System.out.println("total:" + total);
		        percntVal = rsltCnt / total * 100.0D;
		        System.out.println("percntVal:" + percntVal);
		        percentage = Double.parseDouble(checkNull(rs.getString("PERC")));
		        dashOffSet = totalCircle * percntVal / 100.0D;
		        rowData.put("dashOffSet", Double.valueOf(dashOffSet));
		        System.out.println(" dashOffSet :" + dashOffSet);
		        rowData.put("descr", "Marks");
		        rowData.put("percentage", Long.valueOf(Math.round(percntVal)));
		        rowData.put("spanvalue", Math.round(percntVal) + "%");        
		        rowData.put("ontimeval", checkNull(rs.getString("RESULTCNT")));
		        rowData.put("totalval", checkNull(rs.getString("OUTOF_MARKS")));
		        //rowData.put("totalval", checkNull(rs.getString("TOTAL")));	        
		        rowData.put("person_name", checkNull(rs.getString("EMP_NAME")));
		        rowData.put("prd_name", checkNull(rs.getString("PRD_NAME")));
		        rowData.put("magagerName",checkNull( rs.getString("MGR_NAME")));
		        rowData.put("uniqueCode",checkNull( rs.getString("MGR_CODE")));
		        rowData.put("survey_templ",checkNull( rs.getString("SURVEY_TEMPL")));
		       // rowData.put("mgr",checkNull( rs.getString("MGR")));	
		        rowData.put("new_tran_id", checkNull(rs.getString("NEW_TRAN_ID")));
		        rowData.put("tbldisplay", "style='display: visible'");
		        rowData.put("circledisplay", "c100");
		        rawDataParticipentProductDetailJson.put(Integer.valueOf(count), rowData);
		        count++;
			}
			    rs.close();
				rs=null;
				pstmt.close();
				pstmt=null;
		  }
 	}//closed if block	
	catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
					rs.close();
					rs = null;
					if (pstmt != null)
					pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in :getParticipentEventDetail:" + d.getMessage());
				throw new ITMException(d);
			}
		}
		System.out.println("LiveEventDetails rawDataParticipentProductDetailJson String======>>"+rawDataParticipentProductDetailJson.toString());
	    return rawDataParticipentProductDetailJson;
    }
    
    
    
    
    @SuppressWarnings("unchecked")    
    public JSONObject getProductDetail(String dataSourceName,String personName,String productName,String mgrCode,String eventCode, String newTranId) throws RemoteException, ITMException
    {
    	JSONObject rawDataProductDetailJson = new JSONObject();
		JSONObject rowData                  = null;
		String sql                          = "";
		ResultSet rs                        = null;
		PreparedStatement pstmt             = null;
		Connection conn                     = null;
		ConnDriver connDriver               = new ConnDriver();
		
		try
		{
			System.out.println(" Inside LiveEventDetails for getProductDetail Data Soruc Name ="+dataSourceName+" personName=:"+ personName );
			conn = connDriver.getConnectDB(dataSourceName);
			connDriver = null;
			
			/*Final sql*/
			if(mgrCode!=null && mgrCode!="")
			{
				System.out.println(" Inside LiveEventDetails for getParticipentEventDetail Data Soruc Name ="+dataSourceName+ "==== personName :"+personName+"productName==="+productName);
			
			sql =   " SELECT EMP_CODE, SURVEY, SURVEY_CODE, (CASE WHEN SUM(result)=0 THEN result1 " +
					" ELSE (CAST (SUM(result) AS VARCHAR(10)))END) AS result FROM (SELECT SRE.EMP_CODE, sm.SURVEY_CODE, " +
					" RTRIM(LTRIM(upper(sm.DESCR))) AS SURVEY , CASE WHEN ISNUMERIC(srd.result)=1 THEN (srd.result ) " +
					" ELSE 0 END AS result, CASE WHEN ISNUMERIC(srd.result)<>1 THEN (srd.result ) ELSE '' END AS result1, " +
					" srd.TRAN_ID FROM dbo.survey_result_EMP SRE INNER JOIN dbo.survey_result SR ON SRE.TRAN_ID = SR.TRAN_ID__FORM " +
					" INNER JOIN dbo.survey_result_det SRD ON SR.TRAN_ID = SRD.TRAN_ID " +
					" INNER JOIN ( SELECT * FROM dbo.survey_result_appl WHERE APPL_ENTITY = 'E' ) " +
					" APP ON SRD.TRAN_ID = APP.TRAN_ID INNER JOIN ( SELECT * FROM dbo.survey_result_appl " +
					" WHERE APPL_ENTITY = 'I' ) APPR ON SRD.TRAN_ID = APPR.TRAN_ID " +
					" INNER JOIN dbo.employee e ON APP.ENTITY_CODE = e.code " +
					" INNER JOIN dbo.survey_master sm ON SRD.SURVEY_CODE = sm.SURVEY_CODE " +
					" INNER JOIN dbo.SURVEY_TEMPL_DET std ON std.SURVEY_CODE = sm.SURVEY_CODE " +
					" WHERE RTRIM(LTRIM(e.FIRSTNAME +' '+ e.LASTNAME)) = '"+personName+"' " +
					" AND RTRIM(LTRIM(APPR.ENTITY_DESCR))              = '"+productName+"' " +
					" AND SRE.EMP_CODe = '"+mgrCode+"' " +
					" AND std.SURVEY_TEMPL ='"+eventCode+"'  and srd.tran_id='"+newTranId+"' )a " +
					" GROUP BY EMP_CODE, SURVEY_CODE, SURVEY, result1 ";
				
				/*Last Used*/
			/*sql=    " select EMP_CODE, SURVEY, SURVEY_CODE, REPLACE (sum(result),0,result1) as result " +
					" from ( SELECT SRE.EMP_CODE,sm.SURVEY_CODE, RTRIM(LTRIM(upper(sm.DESCR))) AS SURVEY , " +
					" case when  ISNUMERIC(srd.result)=1 then (srd.result ) else 0 end AS result, case " +
					" when  ISNUMERIC(srd.result)<>1 then (srd.result ) else '' end AS result1, srd.TRAN_ID " +
					" FROM dbo.survey_result_EMP SRE INNER JOIN dbo.survey_result SR ON SRE.TRAN_ID = SR.TRAN_ID__FORM " +
					" INNER JOIN dbo.survey_result_det SRD ON SR.TRAN_ID = SRD.TRAN_ID " +
					" INNER JOIN ( SELECT * FROM dbo.survey_result_appl WHERE APPL_ENTITY = 'E' ) APP ON SRD.TRAN_ID = APP.TRAN_ID " +
					" INNER JOIN ( SELECT * FROM dbo.survey_result_appl WHERE APPL_ENTITY = 'I' ) APPR ON SRD.TRAN_ID = APPR.TRAN_ID " +
					" INNER JOIN dbo.employee e ON APP.ENTITY_CODE = e.code " +
					" INNER JOIN dbo.survey_master sm ON SRD.SURVEY_CODE = sm.SURVEY_CODE " +
					" inner join dbo.SURVEY_TEMPL_DET  std on std.SURVEY_CODE=sm.SURVEY_CODE " +
					" WHERE RTRIM(LTRIM(e.FIRSTNAME +' '+ e.LASTNAME)) = '"+personName+"' " +
					" AND RTRIM(LTRIM(APPR.ENTITY_DESCR))='"+productName+"' " +
					" AND SRE.EMP_CODe ='"+mgrCode+"' " +
					" and std.SURVEY_TEMPL='"+eventCode+"' )a " +
					" GROUP BY EMP_CODE,SURVEY_CODE, SURVEY, result1 ";*/
				
				
				
			
			pstmt = conn.prepareStatement(sql);
			rs    = pstmt.executeQuery();
			int count = 0;		
			while (rs.next())
			{
				rowData = new JSONObject();
				rowData.put("survey", checkNull(rs.getString("SURVEY")));
				rowData.put("result", checkNull(rs.getString("RESULT")));
				rawDataProductDetailJson.put(count, rowData);
				count++;
			}
			rs.close();
			rs=null;
			pstmt.close();
			pstmt=null;
		}
	
		}		
		catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
					rs.close();
					rs = null;
					if (pstmt != null)
					pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in :getProductDetail:" + d.getMessage());
				throw new ITMException(d);
			}
		}
		System.out.println("LiveEventDetails rawDataProductDetailJson String======>>"+rawDataProductDetailJson.toString());
	    return rawDataProductDetailJson;
    }
    private String checkNull(String str)
   	{
   		if(str == null)
   		{
   			return "";
   		}
   		else
   		{
   			return str ;
   		}

   	}

	
	
}
