package ibase.webitm.ejb.fin;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.concurrent.Exchanger;

import org.w3c.dom.*;

import javax.ejb.Stateless;

import ibase.webitm.ejb.sys.GenerateXmlFromDB;
import ibase.webitm.ejb.sys.NFCreateEdiMultiLogic;
import ibase.webitm.ejb.sys.UtilMethods;
import ibase.system.config.ConnDriver;
import ibase.utility.CommonConstants;
import ibase.webitm.ejb.ActionHandlerEJB;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.ejb.vfm.utility.GenericClass;
import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.TransIDGenerator;


@Stateless
public class FixedAssetTransfConf extends ActionHandlerEJB implements FixedAssetTransfConfLocal,FixedAssetTransfConfRemote
{
	String userId="";
	private String XfrTypeG="",siteCodeG="",siteCodeToG="",linkTypeG="",empLoginCode="",confirmedG="",xtraParamsG="";	
	Timestamp tranDateG=null;

	public String confirm(String tranId, String xtraParams, String forcedFlag) throws RemoteException,ITMException
	{
		System.out.println("--------------confirm method of FixedAssetTransfConf ------------- : ");
		String retString = "";		
		try
		{
						
				retString = confirmFixedAssetTransf(tranId,xtraParams,forcedFlag);
			
		}
		catch(Exception e)
		{
			System.out.println("Exception :FixedAssetTransfConf :confirm():" + e.getMessage() + ":");
			retString = GenericUtility.getInstance().createErrorString(e);
			e.printStackTrace();
		}
		
		return retString;
	}
	
	private String confirmFixedAssetTransf(String tranId,String xtraParams,String forcedFlag) 
	{
		ResultSet rs=null;
		Connection conn=null;
		ConnDriver ConnDriver = new ConnDriver();
		PreparedStatement pstmt=null;
		ITMDBAccessEJB itmdbAccess=new ITMDBAccessEJB();
		String sql="",errString="",xFrType="",siteCodeFrom="",siteCodeTo="",linkType="";	
		Timestamp tranDate=null;
		try
		{		
			ConnDriver connDriver = null;
			connDriver = new ConnDriver();
			conn = connDriver.getConnectDB("DriverValidator");	
			setEmpLoginCode(GenericUtility.getInstance().getValueFromXTRA_PARAMS(xtraParams,"loginEmpCode").trim());								
			System.out.println("empLoginCode--->["+getEmpLoginCode()+"]");
			userId = GenericUtility.getInstance().getValueFromXTRA_PARAMS(xtraParams, "userId");			
			conn.setAutoCommit(false);
			String confirmed="";
			sql = "select xfr_type,confirmed,site_code__from,site_code__to,link_type,tran_date from asset_transfer_hdr where  tran_id = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, tranId);
			rs = pstmt.executeQuery();
			if( rs.next() )
			{
				xFrType=rs.getString("xfr_type");
				confirmed =rs.getString("confirmed")==null ? "N":rs.getString("confirmed");
				siteCodeFrom =rs.getString("site_code__from")==null ? "":rs.getString("site_code__from");
				siteCodeTo =rs.getString("site_code__to")==null ? "":rs.getString("site_code__to");
				linkType =rs.getString("link_type")==null ? "":rs.getString("link_type");
				tranDate=rs.getTimestamp("tran_date");
			}	
			if( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}
			if ( rs != null )
			{
				rs.close();
				rs = null;
			}			
			setConfirmedG(confirmed);
			setXfrTypeG(xFrType);
			setSiteCodeG(siteCodeFrom);
			setSiteCodeToG(siteCodeTo);
			setLinkTypeG(linkType);
			setTranDateG(tranDate);
			setXtraParamsG(xtraParams);
			
			System.out.println("XfrType--->["+getXfrTypeG()+"]");
			System.out.println("Confirmed--->["+getConfirmedG()+"]");
			
			
			if("Y".equalsIgnoreCase(getConfirmedG())){
				//if transaction already confirm then show error 
				errString = itmdbAccess.getErrorString("", "VTMCONF1", "", "", conn);
				return errString;
			}
			else if("N".equalsIgnoreCase(getConfirmedG()) && "R".equalsIgnoreCase(xFrType)){
				errString=retrieveAssetTransfer(conn,tranId,xtraParams);// --------------------Check if it is correct calling method
				return errString;
			}else if("N".equalsIgnoreCase(getConfirmedG())){
				errString=retrieveAssetTransfer(conn,tranId,xtraParams);	// --------------------Check if it is correct calling method parameters
				return errString;
			}
		}
		catch(Exception e){
			e.printStackTrace();
		}
		return errString;
	}
	
	private String retrieveAssetTransfer(Connection conn,String tranid,String xtraParams)
	{
		System.out.println("---------In retrieveAssetTransfer method ----------------");
		ResultSet rs=null,rs1=null;
		PreparedStatement pstmt=null,pstmt1=null;
		String errorCode="",sql="",sql1="",itemSerTo="",assetCodeFrom="",grpCodeTo="",
				alocCodeTo="",cctrCodeFrom="",deprTypeTo="",itemSer="",itemCode="",grpCode="",cctrCodeTo="";		
		double totalValue=0.0,wdvAmt2=0.0,deprAmt2=0.0,wdvAmtRevl2=0.0,deprAmtRevl2=0.0;
		Timestamp tranDate=null,procDate2=null;
		int count=0,lineNo=0;
		
		try{
			
			System.out.println("xFrtype--->>["+getXfrTypeG()+"]");
			System.out.println("SiteCodeFrom--->>["+getSiteCodeG()+"]");
			System.out.println("siteCodeTo--->>["+getSiteCodeToG()+"]");
			 if("N".equalsIgnoreCase(getConfirmedG()) && "R".equalsIgnoreCase(getXfrTypeG())){
				errorCode=assetRegisterPost(conn,tranid);//------------------------------method call
				errorCode=errorCode==null ? "" : errorCode.trim();
				System.out.println("ErrorCode After assetRegisterPost--->>["+errorCode+"]");
				if(errorCode.length() > 0){
					return errorCode; //-------------------------------error handling
				}
				
			}else if("N".equalsIgnoreCase(getConfirmedG())){
				if(getSiteCodeG().equalsIgnoreCase(getSiteCodeToG())){
					System.out.println("--------site code same------");
					sql="select line_no,asset_code__from,item_ser__to,grp_code__to,aloc_code__to,cctr_code__from,depr_type__to,total_value "
							+ "from asset_transfer_det where tran_id = ?";
					pstmt=conn.prepareStatement(sql);
					pstmt.setString(1, tranid);
					rs=pstmt.executeQuery();
					while(rs.next()){
						lineNo=rs.getInt(1);
						assetCodeFrom=rs.getString(2)==null ? "" :rs.getString(2).trim();
						itemSerTo=rs.getString(3)==null ? "" :rs.getString(3).trim();
						grpCodeTo=rs.getString(4)==null ? "" :rs.getString(4).trim();
						alocCodeTo=rs.getString(5)==null ? "" :rs.getString(5).trim();
						cctrCodeFrom=rs.getString(6)==null ? "" :rs.getString(6).trim();
						deprTypeTo=rs.getString(7)==null ? "" :rs.getString(7).trim();
						totalValue=rs.getDouble(8);
						System.out.println("assetCodeFrom--->>["+assetCodeFrom+"]");
						System.out.println("deprTypeTo--->>["+deprTypeTo+"]");
						System.out.println("totalValue--->>["+totalValue+"]");
						
						sql1="select item_ser,item_code,grp_code,proc_date_2,wdv_amt_2,depr_amt_2,wdv_amt_revl_2,depr_amt_revl_2 "
								+ "from asset_register where asset_code = ?";
						
						pstmt1=conn.prepareStatement(sql1);
						pstmt1.setString(1, assetCodeFrom);
						rs1=pstmt1.executeQuery();
						if(rs1.next()){
						itemSer=rs1.getString(1)==null ? "" :rs1.getString(1).trim();
						itemCode=rs1.getString(2)==null ? "" :rs1.getString(2).trim();
						grpCode=rs1.getString(3)==null ? "" :rs1.getString(3).trim();
						procDate2=rs1.getTimestamp(4);
						wdvAmt2=rs1.getDouble(5);
					    deprAmt2=rs1.getDouble(6);
					    wdvAmtRevl2=rs1.getDouble(7);
					    deprAmtRevl2=rs1.getDouble(8);
						} //end if
						if( pstmt1 != null ){
						pstmt1.close();
						pstmt1 = null;
						}
						if ( rs1 != null ){
						rs1.close();
						rs1 = null;
						}
						System.out.println("itemCode--->>["+itemCode+"]");
						System.out.println("grpCode--->>["+grpCode+"]");
						System.out.println("wdvAmt2--->>["+wdvAmt2+"]");
						
						//update asset_transfer_det
						sql1="update asset_transfer_det set  wdv_amt_2 = ?,depr_amt_2 = ?,wdv_amt_revl_2 = ?,depr_amt_revl_2 = ? "
								+ "where tran_id = ? and line_no= ?";
						pstmt1=conn.prepareStatement(sql1);
						pstmt1.setDouble(1,wdvAmt2);
						pstmt1.setDouble(2,deprAmt2);
						pstmt1.setDouble(3,wdvAmtRevl2);
						pstmt1.setDouble(4,deprAmtRevl2);
						pstmt1.setString(5,tranid);
						pstmt1.setInt(5,lineNo);
						int assetTr=pstmt1.executeUpdate();
						
						if( pstmt1 != null ){
						pstmt1.close();
						pstmt1 = null;
						}
						//Update asset_register set status = T (Transfer)
						sql1="update asset_register set status = ? where asset_code = ?";
						pstmt1=conn.prepareStatement(sql1);
						pstmt1.setString(1,"T");
						pstmt1.setString(2,assetCodeFrom);
						int assetReg=pstmt1.executeUpdate();						
						if( pstmt1 != null ){
						pstmt1.close();
						pstmt1 = null;
						}

						
					} //end while
					if( pstmt != null ){
					pstmt.close();
					pstmt = null;
					}
					if(rs != null ){
					rs.close();
					rs = null;
					}
					
					errorCode=assetRegisterPost(conn,tranid);////Remaining...........................................line :199
					System.out.println("return string from assetRegisterPost 111----->>["+errorCode+"]");
					if(errorCode !=null && errorCode.length() > 0){
						return errorCode; //-------------------------------------Error handling
					}
					
					
				}else{
					// if the site is not same , then update only in asset register
					System.out.println("--------site code not same------");
					sql="select asset_code__from, item_ser__to, grp_code__to,aloc_code__to, cctr_code__to, depr_type__to "
							+ "from   asset_transfer_det where  tran_id = ?";
					pstmt=conn.prepareStatement(sql);
					pstmt.setString(1, tranid);
					rs=pstmt.executeQuery();
					while(rs.next()){
						assetCodeFrom=rs.getString(1)==null ? "" :rs.getString(1).trim();
						itemSerTo=rs.getString(2)==null ? "" :rs.getString(2).trim();
						grpCodeTo=rs.getString(3)==null ? "" :rs.getString(3).trim();
						alocCodeTo=rs.getString(4)==null ? "" :rs.getString(4).trim();
						cctrCodeTo=rs.getString(5)==null ? "" :rs.getString(5).trim();
						deprTypeTo=rs.getString(6)==null ? "" :rs.getString(6).trim();
						
						
						sql1="update asset_register set item_ser  = ?,grp_code  = ?,aloc_code = ?,cctr_code = ?,depr_type = ? where asset_code = ?";
						pstmt1=conn.prepareStatement(sql1);
						pstmt1.setString(1,itemSerTo);
						pstmt1.setString(2,grpCodeTo);
						pstmt1.setString(3,alocCodeTo);
						pstmt1.setString(4,cctrCodeTo);
						pstmt1.setString(5,deprTypeTo);
						pstmt1.setString(6,assetCodeFrom);
						int assetReg=pstmt1.executeUpdate();						
						if( pstmt1 != null ){
						pstmt1.close();
						pstmt1 = null;
						}
						
					 }//end while
					if( pstmt != null ){
					pstmt.close();
					pstmt = null;
					}
					if(rs != null ){
					rs.close();
					rs = null;
					}
				} //end site code condition
			} //end else if of confirmed N
			 
			 sql="update asset_transfer_hdr set confirmed = ?,confirm_date= ?,emp_code__aprv = ? where tran_id = ?";
			 pstmt=conn.prepareStatement(sql);
			 pstmt.setString(1,"Y");			 
			 pstmt.setDate(2, new java.sql.Date(System.currentTimeMillis()));
			 pstmt.setString(3, getEmpLoginCode());
			 pstmt.setString(4, tranid);
			 int assetHdr=pstmt.executeUpdate();
			
			
		}
		catch(Exception e){
			e.printStackTrace();
		}
		return errorCode;
	}
	private String assetRegisterPost(Connection conn,String tranId)
	{
		System.out.println("-----assetRegisterPost method tranid :["+tranId+"]--------");
		ResultSet rs=null,rs2=null;
		PreparedStatement pstmt=null,pstmt2=null;
		double exchRateL=0, orginalValueL=0, otherChgsL=0, taxAmtL=0,taxRecoAmtL=0,diffAmtExchL=0,
				revalueAmtL=0, totalValueL=0,deprPerc1L=0,deprAmt1L=0,deprAmt2L=0,wdvAmt1L=0, deprPerc2L=0,
				remValue=0,exciseAmtL=0, commChgsL=0, installChgsL=0, insurChgsL=0,profitLossL=0,totalValueBcL=0,
				deprAmtRevl2L=0,wdvAmtRevl2L=0,octroiChgsL=0,wdvAmt2L=0;
		Timestamp rcpDateL=null,instDateL=null,remDateL=null,useDateL=null,verifiedOnL=null,procDate1L=null,procDate2L=null,revalueDateL=null;
		String sql="",sql1="",refSer="",keyString="",alocCodeToL="",errorString="";
		String assetCodeToL="",itemSerToL="",grpCodeToL="",assetTypeL="",tranIdCreateL="",tranSerCreateL="",billNoL="",suppCodeL="",suppNameL="",itemCodeL="";
				
		String siteCodeL="",currCodeL="",tranIdRemL="",tranSerRemL="",assetCodefromL="",cctrCodetoL="",
				deprTypefromL="",deprMethod1L="",deprMethod2L="",empCodeVerifyL="", remarksL="",assetCodeLinkL="",keyStringL="",refSerL="",
		empCodeL="",acctPrdProcL="",assetCodeParL="";
		Timestamp tranDate=null;
		try{			
			System.out.println("xFrType11--->>["+getXfrTypeG()+"]");
			System.out.println("linkType11--->>["+getLinkTypeG()+"]");
			System.out.println("siteCodeFrom11 To--->>["+getSiteCodeG()+"]["+getSiteCodeG()+"]");
			
			if("T".equalsIgnoreCase(getXfrTypeG())){
				// Function to Pass the Accounting effect for Issue,Y- Indicate Multi Asset Transaction
				errorString=assetTransferPost(conn, tranId);
				System.out.println("return string from assetTransferPost 555 --->>["+errorString+"]");
				if(errorString !=null && errorString.length() > 0){
					return errorString; //--------------------------------------------Error Handling
				}
				
				if("P".equalsIgnoreCase(getLinkTypeG()) || "A".equalsIgnoreCase(getLinkTypeG())){										
					String uniqueKey =GenericClass.generateTranId("w_asset_transfer", getSiteCodeG(), conn);  						
					System.out.println("uniqueKey----->>["+uniqueKey+"]");
				}else if("E".equalsIgnoreCase(getLinkTypeG())){
					GenerateXmlFromDB generateXmlFromDB = GenerateXmlFromDB.getInstance();
					String dataString = generateXmlFromDB.getXMLData("w_asset_transfer", tranId , conn);
					System.out.println("generateXmlFromDB returned [" + dataString + "]");
					generateXmlFromDB = null;
					Document dom = GenericUtility.getInstance().parseString(dataString);
					NFCreateEdiMultiLogic ceateEdiMultiLogic = new NFCreateEdiMultiLogic();
					errorString = ceateEdiMultiLogic.nfCreateEdiMultiLogic( dom, "w_asset_transfer", getXtraParamsG(), conn );
					ceateEdiMultiLogic = null;
					if (errorString != null && !"SUCCESS".equals(errorString))
					{
						return errorString;
					}
					else
					{
						errorString = "";
					}
				}
			}else if("R".equalsIgnoreCase(getXfrTypeG())){
				sql="asset_code__to,item_ser__to,grp_code__to,asset_type,tran_id__create,tran_ser__create,bill_no,supp_code,supp_name,item_code,"
						+ "rcp_date,inst_date,curr_code,exch_rate,orginal_value,other_chgs,tax_amt,tax_reco_amt,diff_amt__exch,excise_amt,"
						+ "comm_chgs,octroi_chgs,install_chgs,insur_chgs,total_value,revalue_amt,revalue_date,use_date,depr_type__from,depr_perc_1,"
						+ "depr_method_1,depr_amt_1,wdv_amt_1,depr_perc_2,depr_method_2,depr_amt_2,wdv_amt_2,asset_code__from,profit_loss,"
						+ "total_value__bc,acct_prd__proc,verified_on,emp_code__verify,cctr_code__to,wdv_amt_revl_2,depr_amt_revl_2,aloc_code__to "
						+ "from asset_transfer_det where tran_id = ?";	
				pstmt=conn.prepareStatement(sql);
				pstmt.setString(1,tranId);
				rs=pstmt.executeQuery();
				while(rs.next()){
					assetCodeToL=rs.getString("asset_code__to")==null ? "" :rs.getString("asset_code__to").trim();
					itemSerToL=rs.getString("item_ser__to")==null ? "" :rs.getString("item_ser__to").trim();
					grpCodeToL=rs.getString("grp_code__to")==null ? "" :rs.getString("grp_code__to").trim();
					assetTypeL=rs.getString("asset_type")==null ? "" :rs.getString("asset_type").trim();
					tranIdCreateL=rs.getString("tran_id__create")==null ? "" :rs.getString("tran_id__create").trim();					
					tranSerCreateL=rs.getString("tran_ser__create")==null ? "" :rs.getString("tran_ser__create").trim();
					billNoL=rs.getString("bill_no")==null ? "" :rs.getString("bill_no").trim();
					suppCodeL=rs.getString("supp_code")==null ? "" :rs.getString("supp_code").trim();
					suppNameL=rs.getString("supp_name")==null ? "" :rs.getString("supp_name").trim();
					itemCodeL=rs.getString("item_code")==null ? "" :rs.getString("item_code").trim();
					
					
					rcpDateL=rs.getTimestamp("rcp_date");
					instDateL=rs.getTimestamp("inst_date");
					currCodeL=rs.getString("curr_code")==null ? "" :rs.getString("curr_code").trim();
					exchRateL=rs.getDouble("exch_rate");
					orginalValueL=rs.getDouble("orginal_value");					
					otherChgsL=rs.getDouble("other_chgs");					
					taxAmtL=rs.getDouble("tax_amt");
					taxRecoAmtL=rs.getDouble("tax_reco_amt");
					diffAmtExchL=rs.getDouble("diff_amt__exch");
					exciseAmtL=rs.getDouble("excise_amt");
					
					commChgsL=rs.getDouble("comm_chgs");
					octroiChgsL=rs.getDouble("octroi_chgs");
					installChgsL=rs.getDouble("install_chgs");
					insurChgsL=rs.getDouble("insur_chgs");
					totalValueL=rs.getDouble("total_value");
					revalueAmtL=rs.getDouble("revalue_amt");					
					revalueDateL=rs.getTimestamp("revalue_date");
					useDateL=rs.getTimestamp("use_date");
					deprTypefromL=rs.getString("depr_type__from")==null ? "" :rs.getString("depr_type__from").trim();
					deprPerc1L=rs.getDouble("depr_perc_1");
					
					deprMethod1L=rs.getString("depr_method_1")==null ? "" :rs.getString("depr_method_1").trim();
					deprAmt1L=rs.getDouble("depr_amt_1");
					wdvAmt1L=rs.getDouble("wdv_amt_1");
					deprPerc2L=rs.getDouble("depr_perc_2");
					deprMethod2L=rs.getString("depr_method_2")==null ? "" :rs.getString("depr_method_2").trim();
					deprAmt2L=rs.getDouble("depr_amt_2");
					wdvAmt2L=rs.getDouble("wdv_amt_2");
					
					assetCodefromL=rs.getString("asset_code__from")==null ? "" :rs.getString("asset_code__from").trim();
					profitLossL=rs.getDouble("profit_loss");
					totalValueBcL=rs.getDouble("total_value__bc");
					acctPrdProcL=rs.getString("acct_prd__proc")==null ? "" :rs.getString("acct_prd__proc").trim();
					verifiedOnL=rs.getTimestamp("verified_on");
					
					empCodeVerifyL=rs.getString("emp_code__verify")==null ? "" :rs.getString("emp_code__verify").trim();
					cctrCodetoL=rs.getString("cctr_code__to")==null ? "" :rs.getString("cctr_code__to").trim();
					wdvAmtRevl2L=rs.getDouble("wdv_amt_revl_2");
					deprAmtRevl2L=rs.getDouble("depr_amt_revl_2");
					alocCodeToL=rs.getString("aloc_code__to")==null ? "" :rs.getString("aloc_code__to").trim();				
					
					
					String assetCodePK = GenericClass.generateTranId("w_asset_register", getSiteCodeG(), conn); 
					System.out.println("assetCodePK---->>["+assetCodePK+"]");
					
					remarksL = "Received " +assetCodeLinkL+ " asset from site: " +getSiteCodeG();
					//Insert record in asset_register
					sql1="insert into asset_register (asset_code, item_ser, grp_code,site_code, asset_type, tran_id__create, remarks," //7
							+ "tran_ser__create,bill_no, supp_code, supp_name, item_code, rcp_date, inst_date,curr_code, exch_rate,"  //16
							+ "orginal_value, other_chgs, tax_amt, tax_reco_amt,octroi_chgs,diff_amt__exch, excise_amt, comm_chgs,"   //24
							+ "install_chgs, insur_chgs,total_value,revalue_amt,revalue_date, use_date, depr_type, depr_perc_1,"  //32
							+ "depr_method_1,depr_amt_1,wdv_amt_1, depr_perc_2, depr_method_2, depr_amt_2, wdv_amt_2,status, "  //40
							+ "asset_code__link,profit_loss, tot_value__bc,acct_prd__proc, verified_on,emp_code__verify,chg_date, chg_user,"  //48
							+ "chg_term, cctr_code,aloc_code,wdv_amt_revl_2,depr_amt_revl_2,proc_date_1,proc_date_2) " //55
							+ "values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,"
							+ "?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,"
							+ "?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,"
							+ "?,?,?,?,?,?,?,?,?,? )";
					
					pstmt2=conn.prepareStatement(sql1);
					
					pstmt2.setString(1, assetCodePK);
					pstmt2.setString(2, itemSerToL);
					pstmt2.setString(3, grpCodeToL);
					pstmt2.setString(4, getSiteCodeToG());
					pstmt2.setString(5, assetTypeL);					
					pstmt2.setString(6, tranIdCreateL);
					pstmt2.setString(7, remarksL);					
					pstmt2.setString(8, tranSerCreateL);
					pstmt2.setString(9, billNoL);
					pstmt2.setString(10, suppCodeL);
					pstmt2.setString(11, suppNameL);
					pstmt2.setString(12, itemCodeL);
					pstmt2.setTimestamp(13, rcpDateL);
					pstmt2.setTimestamp(14, instDateL);
					pstmt2.setString(15,currCodeL);
					
					pstmt2.setDouble(16, exchRateL);					
					pstmt2.setDouble(17, orginalValueL);
					pstmt2.setDouble(18, otherChgsL);
					pstmt2.setDouble(19, taxAmtL);
					pstmt2.setDouble(20, taxRecoAmtL);
					pstmt2.setDouble(21, octroiChgsL);					
					pstmt2.setDouble(22, diffAmtExchL);
					pstmt2.setDouble(23, exciseAmtL);
					pstmt2.setDouble(24, commChgsL);					
					pstmt2.setDouble(25, installChgsL);
					pstmt2.setDouble(26, insurChgsL);
					pstmt2.setDouble(27, totalValueL);
					pstmt2.setDouble(28, revalueAmtL);					
					pstmt2.setTimestamp(29, revalueDateL);
					pstmt2.setTimestamp(30, useDateL);
					
					pstmt2.setString(31, deprTypefromL);
					pstmt2.setDouble(32, deprPerc1L);				
					pstmt2.setString(33, deprMethod1L);
					pstmt2.setDouble(34, deprAmt1L);
					pstmt2.setDouble(35, wdvAmt1L);
					pstmt2.setDouble(36, deprPerc2L);
					pstmt2.setString(37, deprMethod2L);
					pstmt2.setDouble(38, deprAmt2L);
					pstmt2.setDouble(39, wdvAmt2L);
					pstmt2.setString(40, "A");					
					pstmt2.setString(41, assetCodeLinkL);
					pstmt2.setDouble(42, profitLossL);
					pstmt2.setDouble(43, totalValueBcL);
					pstmt2.setString(44, acctPrdProcL);
					pstmt2.setTimestamp(45, verifiedOnL);
					
					pstmt2.setString(46, empCodeVerifyL);
					pstmt2.setDate(47, new java.sql.Date(System.currentTimeMillis()));
					pstmt2.setString(48,userId);					
					pstmt2.setString(49,"system");
					pstmt2.setString(50,cctrCodetoL);
					pstmt2.setString(51,alocCodeToL);
					pstmt2.setDouble(52, wdvAmtRevl2L);
					pstmt2.setDouble(53, deprAmtRevl2L);					
					pstmt2.setTimestamp(54,procDate1L);
					pstmt2.setTimestamp(55, procDate2L);
					
					int assReg=pstmt2.executeUpdate();
					if( pstmt2 != null ){
					pstmt2.close();
					pstmt2 = null;
					}
					System.out.println("revalueAmtL----->>["+revalueAmtL+"]");
					if(revalueAmtL > 0){
						//for inserting record into asset_revalue table							
						String assetRevalueTranId =GenericClass.generateTranId("w_asset_transfer", getSiteCodeG(), conn); 
								//TransIDGeneratorObj2.generateTranSeqID(refSerL, "tran_id", keyStringL, conn);
						System.out.println("assetRevalueTranId---->>["+assetRevalueTranId+"]");
						
						sql1="insert into asset_revalue(tran_id,tran_date,asset_code,revalue_amt,revalue_date,curr_code,exch_rate," 
								+ "chg_date,chg_user,chg_term,revalue_type,confirmed,emp_code__aprv) " 
								+ "values (?,?,?,?,?,?,?,?,?,?,?,?,? )";
						
						pstmt2=conn.prepareStatement(sql1);
						pstmt2.setString(1, assetRevalueTranId);
						pstmt2.setTimestamp(2, tranDate);
						pstmt2.setString(3, assetCodePK);
						pstmt2.setDouble(4, revalueAmtL);
						pstmt2.setTimestamp(5, revalueDateL);
						pstmt2.setString(6, currCodeL);
						pstmt2.setDouble(7, exchRateL);
						pstmt2.setDate(8, new java.sql.Date(System.currentTimeMillis()));
						pstmt2.setString(9,userId);					
						pstmt2.setString(10,"system");
						pstmt2.setString(11,"R"); 
						pstmt2.setString(12,"Y");
						pstmt2.setString(13,empLoginCode);
						
						int assetReval=pstmt2.executeUpdate();
						if( pstmt2 != null ){
						pstmt2.close();
						pstmt2 = null;
						}						
					} //revalueAmtL > 0 end
					
					errorString=assetTransferPost(conn,tranId);
					System.out.println("errorString after assetTransferPost --->>["+errorString+"]");
					
				} //end while
			}
			
		}
		catch(Exception e){
			e.printStackTrace();
		}
		return errorString;
	}
	
private String assetTransferPost(Connection conn,String tranIdL)
{
		System.out.println("------In assetTransferPost method------");
		ResultSet rs=null,rs1=null;
		PreparedStatement pstmt=null,pstmt1=null;
		String siteCode="",siteCodeTo="",siteCodeOld="",xFrTypeL="",finEntityL="",currCodeL="",exchRateL="",itemCodeL="",
				cctrCodeMod="",acctCodeMod="",sql="",sql1="",assetCodeL="",itemSerL="",grpCodeL="",cctrCodeFromL="",remarksL="",
				lsCctrcode="",lsCctrAccCode="",lsCctrCodeAr="",transerL = "FATRAN",errorCodeL="",cctrCodeL="",acctCodeL="",
				cctrAccCodeL="",acctAccCodeL="",cctrCodeArL="",acctCodeArL="",lsCctrCode="",lsAcctCode="";
		double totalValueL=0,exciseAmt=0,orgExciseL=0,wdvAmt2L=0,deprAmt2L=0,deprAmtRevl2L=0,wdvAmtRevl2L=0,revalueAmt=0,modAmt=0;
		int cnt = 0;
		Timestamp useDateL=null;
		HashMap glTraceMap=new HashMap();
		FinCommon fincommonObj=new FinCommon();
		ITMDBAccessEJB itmdbAccessL=new ITMDBAccessEJB();
		try{
		xFrTypeL=getXfrTypeG();
		siteCode=getSiteCodeG();
		siteCodeTo=getSiteCodeToG();
		siteCodeOld=getSiteCodeToG();
		
		// Checking Financial Entity
		finEntityL=getNameOrDescrForCode(conn, "site", "fin_entity","site_code",siteCode);
		// Checking Currency Code
		currCodeL=getNameOrDescrForCode(conn, "finent", "curr_code","fin_entity",finEntityL);
		// Checking Exchange Rate	
		exchRateL=getNameOrDescrForCode(conn, "currency", "std_exrt","curr_code",currCodeL);
		// Selecting the Modvat Account Code.
		cctrCodeMod=getNameOrDescrForCode(conn, "disparm", "var_value","var_name","EXC_CENVAT");
		
		String code[]=cctrCodeMod.split(";");
		if(code.length == 0){
		cctrCodeMod="";
		acctCodeMod="";
	    }else if(code.length == 1){
	    acctCodeMod=code[0];
	    cctrCodeMod="";
	    }else if(code.length == 2){
	    acctCodeMod=code[0];
	    cctrCodeMod=code[1];			  
	    }
		System.out.println("xFrType--->[["+xFrTypeL+"]");
		if("T".equalsIgnoreCase(xFrTypeL)){
		sql="select asset_code__from,item_ser__from,grp_code__from,cctr_code__from,item_code,total_value,excise_amt,"
				+ "wdv_amt_2,depr_amt_2,use_date,depr_amt_revl_2,wdv_amt_revl_2 "
				+ "from asset_transfer_det where tran_id = ?";
		
		}else if("R".equalsIgnoreCase(xFrTypeL)){
		sql="select asset_code__to,item_ser__to,grp_code__to,cctr_code__to,item_code,total_value,excise_amt,"
				+ "wdv_amt_2,depr_amt_2,use_date,depr_amt_revl_2,wdv_amt_revl_2 "
				+ "from asset_transfer_det where tran_id = ?";
		}
		pstmt=conn.prepareStatement(sql);
		pstmt.setString(1, tranIdL);
		rs=pstmt.executeQuery();
		while(rs.next()){
			
			assetCodeL=rs.getString(1)==null ? "": rs.getString(1).trim();
			itemSerL=rs.getString(2)==null ? "": rs.getString(2).trim();
			grpCodeL=rs.getString(3)==null ? "": rs.getString(3).trim();
			cctrCodeL=rs.getString(4)==null ? "": rs.getString(4).trim();
			itemCodeL=rs.getString(5)==null ? "": rs.getString(5).trim();			
			totalValueL=rs.getDouble(6);
			exciseAmt=rs.getDouble(7);
			wdvAmt2L=rs.getDouble(8);
			deprAmt2L=rs.getDouble(9);
			useDateL=rs.getTimestamp(10);
			deprAmtRevl2L=rs.getDouble(11);
			wdvAmtRevl2L=rs.getDouble(12);		
			
			lsCctrcode=fincommonObj.getAcctDetrTtype(itemCodeL,itemSerL,"FA",grpCodeL,conn);
			System.out.println("return String from getAcctDetrTtype lsCctrcode----->>"+lsCctrcode);
			String [] code1=lsCctrcode.split(",");
			if(code1.length == 0){
			lsCctrCode="";
			lsAcctCode="";
		    }else if(code1.length == 1){
		    lsAcctCode=code1[0];
		    cctrCodeL="";
		    }else if(code1.length == 2){
		    lsAcctCode=code1[0];
		    lsCctrCode=code1[1];			  
		    }
			if(lsAcctCode == null || lsAcctCode.trim().length() == 0){
				errorCodeL = itmdbAccessL.getErrorString("", "VTACCTCD1", "", "", conn);
				// // return account error string VTACCTCD1 ......................%>%>%>%>%>%>%>%>%%>%
			}
			// for ACCDEPR
			lsCctrAccCode=fincommonObj.getAcctDetrTtype(itemCodeL,itemSerL,"ACCDEPR",grpCodeL,conn);
			System.out.println("return String from getAcctDetrTtype lsCctrAccCode----->>"+lsCctrAccCode);
			String [] code2=lsCctrcode.split(",");
			if(code2.length == 0){
			cctrAccCodeL="";
			acctAccCodeL="";
		    }else if(code2.length == 1){
		    acctAccCodeL=code2[0];
		    cctrAccCodeL="";
		    }else if(code2.length == 2){
		    acctAccCodeL=code2[0];
		    cctrAccCodeL=code2[1];			  
		    }
			if(acctAccCodeL == null || acctAccCodeL.trim().length() == 0){
				errorCodeL = itmdbAccessL.getErrorString("", "VTACCTCD1", "", "", conn);
				// // return account error string VTACCTCD1 ......................%>%>%>%>%>%>%>%>%%>% FAXFRR
			}
			// for AR account 
			if("T".equalsIgnoreCase(xFrTypeL)){				
			lsCctrCodeAr = fincommonObj.getAcctDetrDistTtype(getSiteCodeG(),getSiteCodeToG(),itemSerL,grpCodeL,itemCodeL,"FAXFRI","",conn) ;
			System.out.println("lsCctrCodeAr T------>>["+lsCctrCodeAr+"]");
			String [] code3=lsCctrcode.split(",");
			if(code3.length == 0){
			cctrCodeArL="";
			acctCodeArL="";
		    }else if(code3.length == 1){
		    acctCodeArL=code3[0];
		    cctrCodeArL="";
		    }else if(code3.length == 2){
		    acctCodeArL=code3[0];
		    cctrCodeArL=code3[1];			  
		    }
			}else if("R".equalsIgnoreCase(xFrTypeL)){
			lsCctrCodeAr = fincommonObj.getAcctDetrDistTtype(getSiteCodeG(),getSiteCodeToG(),itemSerL,grpCodeL,itemCodeL,"FAXFRR","",conn) ;
			System.out.println("lsCctrCodeAr R------>>["+lsCctrCodeAr+"]");
			String [] code4=lsCctrcode.split(",");
			if(code4.length == 0){
			cctrCodeArL="";
			acctCodeArL="";
		    }else if(code4.length == 1){
		    acctCodeArL=code4[0];
		    cctrCodeArL="";
		    }else if(code4.length == 2){
		    acctCodeArL=code4[0];
		    cctrCodeArL=code4[1];			  
		    }
			}
			
			if(acctCodeArL == null || acctCodeArL.trim().length() == 0){
				errorCodeL = itmdbAccessL.getErrorString("", "VTACCTCD1", "", "", conn);
				// // return account error string VTACCTCD1 ......................%>%>%>%>%>%>%>%>%%>% FAXFRR
			}
			// Taking total of Re-value Amount from Asset Re-value
			sql1="select sum(case when revalue_amt is null then 0 else revalue_amt end) "
					+ "from asset_revalue where  asset_code = ?";
			pstmt1=conn.prepareStatement(sql1);
			pstmt1.setString(1, assetCodeL);
			rs1=pstmt1.executeQuery();
			if(rs1.next()){
				revalueAmt=rs1.getDouble(1);
			}
			if(rs1 != null ){
			rs1.close();
			rs1 = null;
			}		
			if( pstmt1 != null ){
			pstmt1.close();
			pstmt1 = null;
			}		
			
			// Total Cost is Original Cost + Ra-valued Amount
			totalValueL	= totalValueL + revalueAmt;
			java.util.Date date = useDateL;
			java.util.Date tranDateL = getTranDateG();
			System.out.println("date333--->[["+date+"]");
			System.out.println("tranDateL444--->[["+tranDateL+"]");
			while(true){
				date=UtilMethods.getInstance().AddMonths(date, 3);
				cnt++;
				if(date.after(tranDateL) || date == tranDateL){
					break;
				}
			}
			modAmt	= ((orgExciseL * 2.5) / 100) * cnt;
			modAmt	= orgExciseL - modAmt;
			
			// Transferee's A/c OR Transferor's A/c  
			glTraceMap.put("tran_date", getTranDateG());
			glTraceMap.put("eff_date", getTranDateG());
			glTraceMap.put("fin_entity", finEntityL);
			glTraceMap.put("site_code",getSiteCodeG());
			glTraceMap.put("sundry_type", "O");			
			glTraceMap.put("sundry_code", "");
			glTraceMap.put("acct_code", acctCodeArL);
			
			/*if("T".equalsIgnoreCase(xFrTypeL))
					if len(trim(ls_cctr_code_from)) > 0 then ls_cctr_code_ar = ls_cctr_code_from
			else if("T".equalsIgnoreCase(xFrTypeL))
					if len(trim(ls_cctr_code_to)) > 0 then ls_cctr_code_ar = ls_cctr_code_to*/
		    
			
			
			glTraceMap.put("cctr_code", cctrCodeArL);
			glTraceMap.put("emp_code", "");
			glTraceMap.put("anal_code", "");
			
			glTraceMap.put("curr_code", currCodeL);
			glTraceMap.put("exch_rate", exchRateL);
			
			if("T".equalsIgnoreCase(xFrTypeL)){
				if (wdvAmt2L >= 0){
					glTraceMap.put("dr_amt", wdvAmt2L);
					glTraceMap.put("cr_amt", 0);						
				}else{
					glTraceMap.put("dr_amt", 0);
					glTraceMap.put("cr_amt",0 - wdvAmt2L);							
				}
			}else if("R".equalsIgnoreCase(xFrTypeL)){
				if (wdvAmt2L >= 0){
					glTraceMap.put("dr_amt", 0);
					glTraceMap.put("cr_amt", wdvAmt2L);						
				}else{
					glTraceMap.put("dr_amt", 0 - wdvAmt2L);
					glTraceMap.put("cr_amt",0);							
				}
			}
			
			glTraceMap.put("ref_type", "F");
			glTraceMap.put("ref_ser",transerL);
			glTraceMap.put("ref_id", tranIdL);
			glTraceMap.put("remarks", remarksL);
			
			errorCodeL=fincommonObj.glTraceUpdate(glTraceMap, conn);
			System.out.println("return String from gltrace 111---->>["+errorCodeL+"]");
			if(errorCodeL !=null && errorCodeL.length() > 0){
				return "Error";//----------------------------------------------------error handling
			}
			// Accumulated Depreciation A/c
			
			glTraceMap.put("tran_date", getTranDateG());
			glTraceMap.put("eff_date", getTranDateG());
			glTraceMap.put("fin_entity", finEntityL);
			glTraceMap.put("site_code",getSiteCodeG());
			glTraceMap.put("sundry_type", "O");			
			glTraceMap.put("sundry_code", "");
			glTraceMap.put("acct_code", acctAccCodeL);
			
			
			if(cctrCodeL.length() > 0 ){
				cctrAccCodeL = cctrCodeL;		 		
			}
			glTraceMap.put("cctr_code", cctrAccCodeL); 
			glTraceMap.put("emp_code", ""); 
			glTraceMap.put("anal_code", ""); 
			glTraceMap.put("curr_code",currCodeL); 
			glTraceMap.put("exch_rate", exchRateL);
			
			if("T".equalsIgnoreCase(xFrTypeL)){
				if (deprAmt2L >= 0){
					glTraceMap.put("dr_amt", deprAmt2L);
					glTraceMap.put("cr_amt", 0);						
				}else{
					glTraceMap.put("dr_amt", 0);
					glTraceMap.put("cr_amt",0 - deprAmt2L);							
				}
			}else if("R".equalsIgnoreCase(xFrTypeL)){
				if (deprAmt2L >= 0){
					glTraceMap.put("dr_amt", 0);
					glTraceMap.put("cr_amt", deprAmt2L);						
				}else{
					glTraceMap.put("dr_amt", 0 - deprAmt2L);
					glTraceMap.put("cr_amt",0);							
				}
			}
			glTraceMap.put("ref_type", "F");
			glTraceMap.put("ref_ser",transerL);
			glTraceMap.put("ref_id", tranIdL);
			glTraceMap.put("remarks", remarksL);			
			
			errorCodeL=fincommonObj.glTraceUpdate(glTraceMap, conn);
			System.out.println("return String from gltrace 222---->>["+errorCodeL+"]");
			if(errorCodeL !=null && errorCodeL.length() > 0){
				return "Error";//----------------------------------------------------error handling
			}
			
			// Fixed Asset A/c
			
			glTraceMap.put("tran_date", getTranDateG());
			glTraceMap.put("eff_date", getTranDateG());
			glTraceMap.put("fin_entity", finEntityL);
			glTraceMap.put("site_code",getSiteCodeG());
			glTraceMap.put("sundry_type", "O");			
			glTraceMap.put("sundry_code", "");
			glTraceMap.put("acct_code", acctCodeL);
			
			
			if(cctrCodeL.length() > 0 ){
				lsCctrCode = cctrCodeL;		 		
			}
			glTraceMap.put("cctr_code", lsCctrCode); 
			glTraceMap.put("emp_code", ""); 
			glTraceMap.put("anal_code", ""); 
			glTraceMap.put("curr_code",currCodeL); 
			glTraceMap.put("exch_rate", exchRateL);
			
			if("T".equalsIgnoreCase(xFrTypeL)){
				if (totalValueL >= 0){
					glTraceMap.put("dr_amt", totalValueL);
					glTraceMap.put("cr_amt", 0);						
				}else{
					glTraceMap.put("dr_amt", 0);
					glTraceMap.put("cr_amt",0 - totalValueL);							
				}
			}else if("R".equalsIgnoreCase(xFrTypeL)){
				if (totalValueL >= 0){
					glTraceMap.put("dr_amt", 0);
					glTraceMap.put("cr_amt", totalValueL);						
				}else{
					glTraceMap.put("dr_amt", 0 - totalValueL);
					glTraceMap.put("cr_amt",0);							
				}
			}
			glTraceMap.put("ref_type", "F");
			glTraceMap.put("ref_ser",transerL);
			glTraceMap.put("ref_id", tranIdL);
			glTraceMap.put("remarks", remarksL);			
			
			errorCodeL=fincommonObj.glTraceUpdate(glTraceMap, conn);
			System.out.println("return String from gltrace 333---->>["+errorCodeL+"]");
			if(errorCodeL !=null && errorCodeL.length() > 0){
				return "Error";//----------------------------------------------------error handling
			}
			
			// Modvat A/c
			
			glTraceMap.put("tran_date", getTranDateG());
			glTraceMap.put("eff_date", getTranDateG());
			glTraceMap.put("fin_entity", finEntityL);
			glTraceMap.put("site_code",getSiteCodeG());
			glTraceMap.put("sundry_type", "O");			
			glTraceMap.put("sundry_code", "");
			glTraceMap.put("acct_code", acctCodeMod);
			
			
			if(cctrCodeL.length() > 0 ){
				cctrCodeMod = cctrCodeL;		 		
			}
			glTraceMap.put("cctr_code", cctrCodeMod); 
			glTraceMap.put("emp_code", ""); 
			glTraceMap.put("anal_code", ""); 
			glTraceMap.put("curr_code",currCodeL); 
			glTraceMap.put("exch_rate", exchRateL);
			
			if("T".equalsIgnoreCase(xFrTypeL)){
				if (modAmt >= 0){
					glTraceMap.put("dr_amt", modAmt);
					glTraceMap.put("cr_amt", 0);						
				}else{
					glTraceMap.put("dr_amt", 0);
					glTraceMap.put("cr_amt",0 - modAmt);							
				}
			}else if("R".equalsIgnoreCase(xFrTypeL)){
				if (modAmt >= 0){
					glTraceMap.put("dr_amt", 0);
					glTraceMap.put("cr_amt", modAmt);						
				}else{
					glTraceMap.put("dr_amt", 0 - modAmt);
					glTraceMap.put("cr_amt",0);							
				}
			}
			glTraceMap.put("ref_type", "F");
			glTraceMap.put("ref_ser",transerL);
			glTraceMap.put("ref_id", tranIdL);
			glTraceMap.put("remarks", remarksL);			
			
			errorCodeL=fincommonObj.glTraceUpdate(glTraceMap, conn);
			System.out.println("return String from gltrace 444---->>["+errorCodeL+"]");
			if(errorCodeL !=null && errorCodeL.length() > 0){
				return "Error";//----------------------------------------------------error handling
			}
			
			errorCodeL=fincommonObj.checkGlTranDrCr(transerL, tranIdL, conn);
			System.out.println("return String from checkGlTranDrCr--->>["+errorCodeL+"]");
			if(errorCodeL !=null && errorCodeL.length() > 0){
				return "Error";//----------------------------------------------------error handling
			}
					
		} //end while
		
		if(rs != null ){
		rs.close();
		rs = null;
		}		
		if( pstmt != null ){
		pstmt.close();
		pstmt = null;
		}	
		}
		catch(Exception e)
		{
			System.out.println("Exception : in assetTransferPost method----");
			e.printStackTrace();
			return "Error";
		}
		return "";
}

public String getXfrTypeG() {
	return XfrTypeG;
}

public void setXfrTypeG(String xfrTypeG) {
	XfrTypeG = xfrTypeG;
}

public String getSiteCodeG() {
	return siteCodeG;
}

public void setSiteCodeG(String siteCodeG) {
	if(siteCodeG==null)
		this.siteCodeG ="";
	else
		this.siteCodeG = siteCodeG.trim();
	
}

public String getSiteCodeToG() {
	return siteCodeToG;
}

public void setSiteCodeToG(String siteCodeToG) {
	if(siteCodeToG==null)
		this.siteCodeToG="";
	else
		this.siteCodeToG = siteCodeToG.trim();
}

public String getLinkTypeG() {
	return linkTypeG;
}

public void setLinkTypeG(String linkTypeG) {
	if(linkTypeG==null)
		this.linkTypeG="";
	else
		this.linkTypeG = linkTypeG.trim(); 
}
public String getEmpLoginCode() {		
	  return empLoginCode;
		
}

public void setEmpLoginCode(String empLoginCode) {
	if(empLoginCode==null)
		this.empLoginCode="";
	else
		this.empLoginCode = empLoginCode.trim();
}

public String getConfirmedG() {
	return confirmedG;
}

public void setConfirmedG(String confirmedG) {
	if(confirmedG==null)
		this.confirmedG="";
	else
		this.confirmedG = confirmedG.trim();
}

public Timestamp getTranDateG() {
	return tranDateG;
}

public void setTranDateG(Timestamp tranDateG) {
	this.tranDateG = tranDateG;
}


public String getXtraParamsG() {
	return xtraParamsG;
}

public void setXtraParamsG(String xtraParamsG) {
	this.xtraParamsG = xtraParamsG;
}

protected String getNameOrDescrForCode(Connection conn, String table_name, String descr_col_name,String whrCondCol, String whrCondVal)
{
			String descr = null;
			
			if(conn!=null){
				
				ResultSet rs=null;
				PreparedStatement pstmt = null;
				
				String sql="SELECT "+descr_col_name+" FROM "+table_name+" WHERE "+whrCondCol+" = ?";
				
				System.out.println("SQL in getNameOrDescrForCode method : "+sql);
				try
				{
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1,whrCondVal);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						descr = rs.getString(descr_col_name);
					}
					
					descr=descr==null ?"" :descr;
				}
				catch(SQLException e)
				{
					System.out.println("SQL Exception In getNameOrDescrForCode method of FixedAssetTransfConf Class : "+e.getMessage());
					e.printStackTrace();
				}
				catch(Exception ex)
				{
					System.out.println("Exception In getNameOrDescrForCode method of FixedAssetTransfConf Class : "+ex.getMessage());
					ex.printStackTrace();
				}finally{
					
					try{
						
						if(pstmt!=null){
							pstmt.close();
							pstmt = null;
						}
						if(rs!=null){
							rs.close();
							rs = null;
						}
					}catch (SQLException se) {
						se.printStackTrace();
					}
				}
			}else{
				try {
					throw new SQLException("Connection passed to FixedAssetTransf.getNameOrDescrForCode() method is null");
				} catch (SQLException e) {
					e.printStackTrace();
				}
			}
				
		return descr;
	}
	
	
}
