/**
 *  Purpose: Dashboard for User Acitivity, Reuest ID: W15CSUN005  
 *  Author: Sneha Mestry
 *  Date: 16-06-2015
 */

package ibase.webitm.ejb.wms;
import ibase.system.config.ConnDriver;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.utility.E12GenericUtility;
import ibase.webitm.utility.ITMException;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.HashSet;
import java.util.Iterator;
import javax.ejb.Stateless;
import org.json.simple.JSONObject;


@Stateless
public class UserActivity extends ValidatorEJB implements UserActivityRemote, UserActivityLocal
{
		
	public UserActivity()
	{}
	E12GenericUtility genericUtility = new E12GenericUtility();
	//1.This is the main method to show the parent graph 
	@SuppressWarnings("unchecked")	
	
	public JSONObject getUserActivityDetails(String dataSourceName, String siteCode, String fromDate, String toDate, String empCodeFrom, String empCodeTo) throws RemoteException, ITMException
	{
		JSONObject rawDataJson = new JSONObject();
		JSONObject rowData = null;
		Connection conn = null;
		//Commented by Santosh on 14-06-2016
		//ConnDriver connDriver = new ConnDriver();
		ResultSet rs = null;
		PreparedStatement pstmt = null;		
		
		// Changed by Sneha Mestry on 29-07-2015, Request ID: W15DSUN014
		String  sql = "", empCode = "", empName = "", pickOrder = "", pickType = "", noArt = "", locCode = "", inputDate = "";
		Timestamp tranDateTo = null, tranDateFrom = null;
		// End by Sneha Mestry on 29-07-2015, Request ID: W15DSUN014
		
		/*
		String sql = "", sql1 = "", sql2 = "", sql3 = "", sql4 = "", sql5 = "", sql6 = "", sql7 = "";
		PreparedStatement pstmt = null, pstmt1 = null, pstmt2 = null, pstmt3 = null, pstmt4 = null, pstmt5 = null, pstmt6 = null, pstmt7 = null;	
		String emp = "", user = "", total = "Total"; 
		HashSet<String> empCodeList = new HashSet<String>();
		HashSet<String> userList = new HashSet<String>(); 
		*/
		try
		{
			//Changed and Commented By Santosh on 14-06-2016 :[START]
			//conn = connDriver.getConnectDB(dataSourceName);
			conn = getConnection();
			//connDriver = null;
			//Changed and Commented By Santosh on 14-06-2016 :[END]
			int count = 0;
			// Changed by Sneha Mestry on 29-07-2015, Request ID: W15DSUN014
			/*String dbDateFormat = genericUtility.getDBDateFormat(); 
			String simpleDateFormat = genericUtility.getApplDateFormat();
			
			inputDate = genericUtility.getValidDateString(fromDate, simpleDateFormat, dbDateFormat);
			System.out.println("inputDate fromDate :::::: " + inputDate);
			tranDateFrom =  Timestamp.valueOf(inputDate + " 00:00:00.0");
			System.out.println("TimeStamp fromDate :::::: " + tranDateFrom);
			
			inputDate = genericUtility.getValidDateString(toDate, simpleDateFormat, dbDateFormat);
			System.out.println("inputDate fromDate :::::: " + inputDate);
			tranDateTo =  Timestamp.valueOf(inputDate + " 00:00:00.0");
			System.out.println("TimeStamp toDate :::::: " + tranDateTo);*/

			sql = "SELECT DDF_GET_EMP_NAME(PIH.EMP_CODE__APRV)  AS EMP_NAME, PIH.EMP_CODE__APRV AS EMP_CODE__APRV, " 
				+ "COUNT(PID.PICK_ORDER) AS COUNT_PICK_ORDER, PIH.PICK_TYPE, " 
				+ "(CASE WHEN PIH.PICK_TYPE = 'A' THEN SUM(PID.QUANTITY) ELSE SUM(PID.NO_ART) END) AS SUM_NO_ART, " 
				+ "COUNT(PID.LOC_CODE) AS COUNT_LOC_CODE FROM PICK_ISS_HDR PIH, PICK_ISS_DET PID " 
				+ "WHERE PIH.EMP_CODE__APRV >= ? AND PIH.EMP_CODE__APRV <= ? " 
				+ "AND PIH.TRAN_DATE >= to_date(?,'dd/mm/yy')  " 
				+ "AND PIH.TRAN_DATE <= to_date(?,'dd/mm/yy') " 
				+ "AND PIH.PICK_ORDER = PID.PICK_ORDER AND PIH.TRAN_ID=PID.TRAN_ID AND PIH.CONFIRMED ='Y' AND  PIH.site_code = ? AND " 
				+ "INSTR(CASE WHEN pick_type = 'C' THEN Q'(C','M)' WHEN pick_type = 'A' THEN 'A' WHEN pick_type = 'B' THEN Q'(C','M','A)' END, " 
				+ "PIH.PICK_TYPE) > 0 GROUP BY PIH.EMP_CODE__APRV, PID.PICK_ORDER, PIH.PICK_TYPE ";
			pstmt = conn.prepareStatement(sql);			
			pstmt.setString(1, empCodeFrom); 
			pstmt.setString(2, empCodeTo);
			pstmt.setString(3, fromDate); 
			pstmt.setString(4, toDate);
			/*pstmt.setTimestamp(3, tranDateFrom); 
			pstmt.setTimestamp(4, tranDateTo);*/
			pstmt.setString(5, siteCode);
			rs = pstmt.executeQuery();
			while (rs.next())
			{
				empName = rs.getString(checkNull("EMP_NAME"));
				empCode = rs.getString(checkNull("EMP_CODE__APRV"));
				pickOrder = rs.getString(checkNull("COUNT_PICK_ORDER"));
				pickType = rs.getString(checkNull("PICK_TYPE"));
				noArt = rs.getString(checkNull("SUM_NO_ART"));
				locCode = rs.getString(checkNull("COUNT_LOC_CODE"));
				
				rowData = new JSONObject();
				rowData.put("empName", empName);
				rowData.put("empCode", empCode);
				rowData.put("pickOrder", pickOrder);
				rowData.put("picktype", pickType);
				rowData.put("noArt", noArt);
				rowData.put("locCode", locCode);
				rawDataJson.put(count, rowData);
				count++;
			}			
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			if(rs != null)
			{
				rs.close();
				rs = null;	
			}
			// End by Sneha Mestry on 29-07-2015, Request ID: W15DSUN014
			/*
			int count = 0, sum = 0, caseCount = 0, activeCount = 0, replCount = 0, masterPickCount = 0, 
				masterPackCount = 0, phyCount = 0, loadCount = 0;

			// Sql for empCode and chg_user 
			/*sql = "select distinct(emp_code__aprv), chg_user from pick_iss_hdr where site_code = ? and emp_code__aprv is not null union  " 
				+ "select distinct(emp_code__aprv), chg_user from pack_hdr where site_code = ? and emp_code__aprv is not null union  "
				+ "select distinct(emp_code__aprv), chg_user from repl_iss_hdr where site_code = ? and emp_code__aprv is not null union "
				+ "select distinct(emp_code__user), chg_user from physcan where site_code = ? and emp_code__user is not null union " 
				+ "select distinct(u.emp_code), s.chg_user from users u, shipment s  where s.site_code = ? and  trim(s.chg_user) = trim(u.code) ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, siteCode); 
			pstmt.setString(2, siteCode);
			pstmt.setString(3, siteCode);
			pstmt.setString(4, siteCode);
			pstmt.setString(5, siteCode);
			rs = pstmt.executeQuery();
			while (rs.next())
			{
				emp = checkNull(rs.getString(1));
				user = checkNull(rs.getString(2));
				
				empCodeList.add(emp);
				userList.add(user);
				System.out.println("empCode :::::::::: " + emp);
				System.out.println("empCodeList :::::::::: " + empCodeList);
				System.out.println("user :::::::::: " + user);
				System.out.println("userList :::::::::: " + userList);	
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			
			if(rs != null)
			{
				rs.close();
				rs = null;	
			}

			if (empCodeList.size() > 0 )
			{  
				Iterator<String> itrEmpCode = empCodeList.iterator();
				
				//Employee Name
				sql = " select DDF_GET_EMPLOYEE_NAME (?) as EMPNAME from DUAL ";
				pstmt = conn.prepareStatement(sql);
				
				//Count for Case Pick
				sql1 = "select count(*) as caseCount from pick_iss_hdr where confirmed = 'Y' and pick_type = 'C' and  " 
					+ "site_code = ? and emp_code__aprv = ? and emp_code__aprv is not null "; 
				pstmt1 = conn.prepareStatement(sql1);
				
				//Count for Active Pick
				sql2 = "select count(*) as activeCount from pick_iss_hdr where confirmed = 'Y' and pick_type = 'A' and  " 
					+ "site_code = ? and emp_code__aprv = ? and emp_code__aprv is not null "; 
				pstmt2 = conn.prepareStatement(sql2);
				
				//Count for Replenishment
				sql3 = "select count(*) as replCount from repl_iss_hdr where confirmed = 'Y' and site_code = ?  " 
					+ "and emp_code__aprv = ? and emp_code__aprv is not null "; 
				pstmt3 = conn.prepareStatement(sql3);
				
				//Count for Master Pick
				sql4 = "select count(*) as masterPickCount from pick_iss_hdr where confirmed = 'Y' and pick_type = 'M' and " 
					+ "site_code = ? and emp_code__aprv = ? and emp_code__aprv is not null"; 
				pstmt4 = conn.prepareStatement(sql4);
				
				//Count for Master Pack
				sql5 = "select count(*) as masterPackCount from pack_hdr where confirmed = 'Y' and site_code = ?  " 
					+ "and emp_code__aprv = ? and emp_code__aprv is not null "; 
				pstmt5 = conn.prepareStatement(sql5);
				
				//Count for Physical Scan
				sql6 = "select count(*) as phyCount from physcan where confirmed = 'Y' and site_code = ? and " 
					+ "emp_code__user = ? and emp_code__user is not null "; 
				pstmt6 = conn.prepareStatement(sql6);
				
				//Count for Loading
				sql7 = "select  count(s.shipment_id) as loadCount from shipment s , users u  where s.confirmed = 'Y' and " 
					+ "s.site_code = ? and trim(s.chg_user) = trim(u.code) and u.emp_code = ? and s.chg_user is not null "; 
				pstmt7 = conn.prepareStatement(sql7);
				
				while(itrEmpCode.hasNext())
				{
					empCode = itrEmpCode.next().toString();
					System.out.println("empCode :::::::::: " + empCode);
					
					//Emp Name
					pstmt.setString(1, empCode); 
					rs = pstmt.executeQuery();
					if (rs.next())
					{
						empName = checkNull(rs.getString("EMPNAME"));
						System.out.println("empName :::::::::: " + empName);
					}
					if(rs != null)
					{
						rs.close();
						rs = null;	
					}	
					pstmt.clearParameters();
					
					//Count for Case Pick
					pstmt1.setString(1, siteCode); 
					pstmt1.setString(2, empCode);
					rs = pstmt1.executeQuery();
					if (rs.next())
					{
						caseCount = rs.getInt("caseCount"); 
						System.out.println("Case Pick Count ::::::::: " + caseCount);
						sum = rs.getInt("caseCount"); 
						System.out.println(" Total till Case Pick :::::::::::::::: " + sum);	
					}	
					if(rs != null)
					{
						rs.close();
						rs = null;	
					}	
					pstmt1.clearParameters();
					
					//Count for Active Pick
					pstmt2.setString(1, siteCode); 
					pstmt2.setString(2, empCode);
					rs = pstmt2.executeQuery();
					if (rs.next())
					{
						activeCount = rs.getInt("activeCount"); 
						sum = rs.getInt("activeCount") + sum;
						
						System.out.println("Active Pick Count ::::::::: " + activeCount);
						System.out.println(" Total till Active Pick :::::::::::: " + sum);
					}
					if(rs != null)
					{
						rs.close();
						rs = null;	
					}
					pstmt2.clearParameters();
					
					//Count for Replenishment
					pstmt3.setString(1, siteCode); 
					pstmt3.setString(2, empCode);
					rs = pstmt3.executeQuery();
					if (rs.next())
					{
						replCount = rs.getInt("replCount"); 
						sum = rs.getInt("replCount") + sum;
						
						System.out.println("Replenishment Count ::::::::: " + replCount);
						System.out.println(" Total till Replenishment Count :::::::::: " + sum);
					}		
					if(rs != null)
					{
						rs.close();
						rs = null;	
					}
					pstmt3.clearParameters();
					
					//Count for Master Pick
					pstmt4.setString(1, siteCode); 
					pstmt4.setString(2, empCode);
					rs = pstmt4.executeQuery();
					if (rs.next())
					{
						masterPickCount = rs.getInt("masterPickCount"); 
						sum = rs.getInt("masterPickCount") + sum;
						
						System.out.println("masterPick Count ::::::::: " + masterPickCount);
						System.out.println(" Total till Master Pick ::::::::::: " + sum);
					}
					if(rs != null)
					{
						rs.close();
						rs = null;	
					}
					pstmt4.clearParameters();
					
					//Count for Master Pack
					pstmt5.setString(1, siteCode); 
					pstmt5.setString(2, empCode);
					rs = pstmt5.executeQuery();
					if (rs.next())
					{
						masterPackCount = rs.getInt("masterPackCount"); 
						sum = rs.getInt("masterPackCount") + sum;
						
						System.out.println("masterPack Count ::::::::: " + masterPackCount);
						System.out.println(" Total till Master Pack :::::::::: " + sum);
					}
					if(rs != null)
					{
						rs.close();
						rs = null;	
					}
					pstmt5.clearParameters();
					
					//Count for Physical Scan
					pstmt6.setString(1, siteCode); 
					pstmt6.setString(2, empCode);
					rs = pstmt6.executeQuery();
					if (rs.next())
					{
						phyCount = rs.getInt("phyCount"); 
						sum = rs.getInt("phyCount") + sum;
						
						System.out.println("Physical Count ::::::::: " + phyCount);
						System.out.println(" Total till physical Count ::::::::: " + sum);
					}
					if(rs != null)
					{
						rs.close();
						rs = null;	
					}
					pstmt6.clearParameters();
					
					//Count for Loading
					pstmt7.setString(1, siteCode); 
					pstmt7.setString(2, empCode);
					rs = pstmt7.executeQuery();
					if (rs.next())
					{
						loadCount = rs.getInt("loadCount"); 
						sum = rs.getInt("loadCount") + sum;
						
						System.out.println("Loading Count ::::::::: " + loadCount);
						System.out.println(" Total till Loading Count ::::::::: " + sum);
					}
					pstmt7.clearParameters();
					if(rs != null)
					{
						rs.close();
						rs = null;	
					}
	
					rowData = new JSONObject();
					rowData.put("empName", empName);
					rowData.put("caseCount", caseCount);
					rowData.put("activeCount", activeCount);
					rowData.put("replCount", replCount);
					rowData.put("masterPickCount", masterPickCount);
					rowData.put("masterPackCount", masterPackCount);
					rowData.put("phyCount", phyCount);
					rowData.put("loadCount", loadCount);
					rowData.put("sum", sum);
					rawDataJson.put(count, rowData);
					count++;
				}	
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(pstmt1 != null)
				{
					pstmt1.close();
					pstmt1 = null;
				}
				if(pstmt2 != null)
				{
					pstmt2.close();
					pstmt2 = null;
				}
				if(pstmt3 != null)
				{
					pstmt3.close();
					pstmt3 = null;
				}
				if(pstmt4 != null)
				{
					pstmt4.close();
					pstmt4 = null;
				}
				if(pstmt5 != null)
				{
					pstmt5.close();
					pstmt5 = null;
				}
				if(pstmt6 != null)
				{
					pstmt6.close();
					pstmt6 = null;
				}
				if(pstmt7 != null)
				{
					pstmt7.close();
					pstmt7 = null;
				}
				//********************************************************************************************************
				//Total for Case Pick
				sql = "select count(*) as caseCount from pick_iss_hdr where confirmed = 'Y' and pick_type = 'C' and  " 
					+ "site_code = ?  and emp_code__aprv is not null "; 
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, siteCode); 
				rs = pstmt.executeQuery();
				if (rs.next())
				{
					caseCount = rs.getInt("caseCount"); 
					sum = rs.getInt("caseCount");
					System.out.println("Total Case Pick Count ::::::::: " + caseCount);
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(rs != null)
				{
					rs.close();
					rs = null;	
				}
				
				//Total for Active Pick
				sql = "select count(*) as activeCount from pick_iss_hdr where confirmed = 'Y' and pick_type = 'A' and  " 
					+ "site_code = ? and emp_code__aprv is not null "; 
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, siteCode); 
				rs = pstmt.executeQuery();
				if (rs.next())
				{
					activeCount = rs.getInt("activeCount"); 
					sum = rs.getInt("activeCount") + sum;
					System.out.println(" Total Active Pick :::::::::::: " + activeCount);
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(rs != null)
				{
					rs.close();
					rs = null;	
				}
				
				//Total for Replenishment
				sql = "select count(*) as replCount from repl_iss_hdr where confirmed = 'Y' and site_code = ? and " 
					+ "emp_code__aprv is not null "; 
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, siteCode); 
				rs = pstmt.executeQuery();
				while (rs.next())
				{
					replCount = rs.getInt("replCount"); 
					sum = rs.getInt("replCount") + sum;
					System.out.println("Total Replenishment  ::::::::: " + replCount);
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(rs != null)
				{
					rs.close();
					rs = null;	
				}

				//Total for Master Pick
				sql = "select count(*) as masterPickCount from pick_iss_hdr where confirmed = 'Y' and pick_type = 'M' and  " 
					+ "site_code = ?  and emp_code__aprv is not null "; 
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, siteCode); 
				rs = pstmt.executeQuery();
				if (rs.next())
				{
					masterPickCount = rs.getInt("masterPickCount"); 
					sum = rs.getInt("masterPickCount") + sum;
					System.out.println("Total masterPick  ::::::::: " + masterPickCount);
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(rs != null)
				{
					rs.close();
					rs = null;	
				}
				
				//Total for Master Pack
				sql = "select count(*) as masterPackCount from pack_hdr where confirmed = 'Y' and site_code = ? and emp_code__aprv is not null  "; 
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, siteCode); 
				rs = pstmt.executeQuery();
				if (rs.next())
				{
					masterPackCount = rs.getInt("masterPackCount"); 
					sum = rs.getInt("masterPackCount") + sum;
					System.out.println("Total masterPack Count ::::::::: " + masterPackCount);
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(rs != null)
				{
					rs.close();
					rs = null;	
				}
				
				//Total for Physical Scan
				sql = "select count(*) as phyCount from physcan where confirmed = 'Y' and site_code = ? and emp_code__user is not null "; 
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, siteCode); 
				rs = pstmt.executeQuery();
				while (rs.next())
				{

					phyCount = rs.getInt("phyCount"); 
					sum = rs.getInt("phyCount") + sum;
					System.out.println("Total Physical Count ::::::::: " + phyCount);
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(rs != null)
				{
					rs.close();
					rs = null;	
				}

				//Total for Loading
				sql = "select  count(*) as loadCount from shipment  where confirmed = 'Y' and site_code = ?  and chg_user is not null "; 
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, siteCode); 
				rs = pstmt.executeQuery();
				if (rs.next())
				{
					loadCount = rs.getInt("loadCount"); 
					sum = rs.getInt("loadCount") + sum;
					System.out.println("Total Loading  ::::::::: " + loadCount);
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(rs != null)
				{
					rs.close();
					rs = null;	
				}
				
				
				rowData = new JSONObject();
				rowData.put("empName", total);
				rowData.put("caseCount", caseCount);
				rowData.put("activeCount", activeCount);
				rowData.put("replCount", replCount);
				rowData.put("masterPickCount", masterPickCount);
				rowData.put("masterPackCount", masterPackCount);
				rowData.put("phyCount", phyCount);
				rowData.put("loadCount", loadCount);
				rowData.put("sum", sum);
				rawDataJson.put(count, rowData);
				count++;
				
				System.out.println("Total caseCount ::::::::::" + caseCount + " Total activeCount ::::::::::: " +activeCount+
						"Total replCount ::::::::::" + replCount + "Total masterPickCount ::::::::::: " +masterPickCount+
						"Total masterPackCount ::::::::::" + masterPackCount + "Total phyCount ::::::::::: " +phyCount+
						"Total loadCount ::::::::::" + loadCount + "Total ::::::::: " + sum);
					
			}*/	
			
		}
		catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		} 
		finally
		{
			try
			{
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(rs != null)
				{
					rs.close();
					rs = null;	
				}

				if (conn != null)
				{
					conn.close();
					conn = null;
				}				
				/*
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				
				if(pstmt1 != null)
				{
					pstmt1.close();conn = null;
					
					pstmt1 = null;
				}
				if(pstmt2 != null)
				{
					pstmt2.close();
					pstmt2 = null;
				}
				if(pstmt3 != null)
				{
					pstmt3.close();
					pstmt3 = null;
				}
				if(pstmt4 != null)
				{
					pstmt4.close();
					pstmt4 = null;
				}
				if(pstmt5 != null)
				{
					pstmt5.close();
					pstmt5 = null;
				}
				if(pstmt6 != null)
				{
					pstmt6.close();
					pstmt6 = null;
				}
				if(pstmt7 != null)
				{
					pstmt7.close();
					pstmt7 = null;
				}
				
				if (conn != null)
				{
					conn.close();
					conn = null;
				}	
				*/	
			} 
			catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in :UserActivity.getUserActivityDetails(String dataSourceName, String month):" + d.getMessage());
				throw new ITMException(d);
			}
		}
	
		return rawDataJson;
	}
	
	private String checkNull(String str)
	{
		if(str == null)
		{
			return "";
		}
		else
		{
			return str.trim();
		}

	}
	
}
