/**
 * PURPOSE : Validation and Itemchange for Picking Issue
 * AUTHOR : Gulzar
 * DATE : 13/09/11
 */

package ibase.webitm.ejb.wms;

import ibase.system.config.*;
import ibase.webitm.ejb.*;
import ibase.webitm.ejb.dis.DistCommon;
import ibase.utility.E12GenericUtility;
import ibase.webitm.utility.ITMException;

import java.rmi.RemoteException;
import java.sql.*;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.*;

import org.w3c.dom.*;

@javax.ejb.Stateless
public class LocWisePickWizIC extends ValidatorEJB implements LocWisePickWizICLocal, LocWisePickWizICRemote 
{
	/**
	 * The method is defined without any parameter and returns blank string
	 */
	@Override
	public String wfValData() throws RemoteException, ITMException
	{
		return "";
	}

	/**
	 * The public method is used for converting the current form data into a document(DOM)
	 * The dom is then given as argument to the overloaded function wfValData to perform validation
	 * Returns validation string if exists else returns null in XML format
	 * @param xmlString contains the current form data in XML format
	 * @param xmlString1 contains all the header information in the XML format
	 * @param xmlString2 contains the data of all the forms in XML format
	 * @param objContext represents the form number
	 * @param editFlag represents the mode of transaction(A-Add or E-Edit)
	 * @param xtraParams contains additional information such as loginEmpCode,loginCode,chgTerm etc
	 */	
	@Override
	public String wfValData(String xmlString, String xmlString1, String xmlString2, String objContext,String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		Document currFormDataDom = null;
		Document hdrDataDom = null;
		Document allFormDataDom = null;
		String errString = null;
		E12GenericUtility genericUtility = new E12GenericUtility();    

		try
		{
			System.out.println( "xmlString ::" + xmlString);
			System.out.println( "xmlString1 ::" + xmlString1);
			System.out.println( "xmlString2 ::" + xmlString2);
			if(xmlString != null && xmlString.trim().length()!=0)
			{
				currFormDataDom = genericUtility.parseString(xmlString); 
			}
			if(xmlString1 != null && xmlString1.trim().length()!=0)
			{
				hdrDataDom = genericUtility.parseString(xmlString1); 
			}
			if(xmlString2 != null && xmlString2.trim().length()!=0)
			{
				allFormDataDom = genericUtility.parseString(xmlString2); 
			}
			errString = wfValData( currFormDataDom, hdrDataDom, allFormDataDom, objContext, xtraParams);
			System.out.println( "ErrString: " + errString);
		}
		catch(Exception e)
		{
			errString = genericUtility.createErrorString(e);
			e.printStackTrace();
			throw new ITMException(e);
		}
		return (errString); 
	}

	/**
	 * The public overloaded method takes a document as input and is used for the validation of required fields 
	 * Returns validation string if exist otherwise returns null in XML format
	 * @param currFormDataDom contains the current form data as a document object model
	 * @param hdrDataDom contains all the header information
	 * @param allFormDataDom contains the field data of all the forms 
	 * @param objContext represents form number
	 * @param editFlag represents the mode of transaction(A-Add or E-Edit)
	 * @param xtraParams contains additional information such as loginEmpCode,loginCode,chgTerm etc
	 */
	@Override
	public String wfValData(Document currFormDataDom, Document hdrDataDom, Document allFormDataDom, String objContext, String xtraParams) throws RemoteException, ITMException
	{   				
		
		
		String waveId="",palletStatus="",ptcn="",pickOrder="",columnValue="",errString="",lpnNo="",
				itemCode="",siteCode="",lotNo="",lotSl="",locCodeTo="",confirmed="",singleLotSl="",
				itemLotOpt="",rowCountStr="",pickType="",sql="",sql1="",lineNoPick="",locCodeSys="",
						sugLocInvstat="",objName="",cartonNo="",caseLabel="",tranID="",intrLocInvstat="";
		String holdStatus="",sqlitem = "",hazMaterial = "",sqlPtcn = "",ptcnReport = "",sqlTran = "",pickOrd = "",
				transMode = "",itemCd = "",ptcnHaz = "",waveIdHaz = "",pickOrdIss = "",linNoOrder = "",selReplCnt = "";
		
		String replOrder = "",sqlptcn = "";
		
		PreparedStatement pstmtitem = null;
		ResultSet rsitem = null;		
		int cntRepl = 0;
		String replOrderPick = "";
		String lineNoRepl = "";
		String sqlPick = "";
		java.util.Date tranDate = null;
		String prdCode = "";
		
		int count = 0, cnt = 0;
		int rowCount = 0;
		int noOfChilds = 0;
		int noOfParent = 0;
		int lineNoOrd = 0;
		
		double quantity = 0.0;
		double shipperSize = 0.0; 
		E12GenericUtility genericUtility = new E12GenericUtility();
		DistCommon distCommon = new DistCommon();	
        ibase.webitm.utility.wms.CommonWmsUtil commonWmsUtility =ibase.webitm.utility.wms.CommonWmsUtil.getInstance();
		Connection conn = null;
		PreparedStatement pstmt = null,pstmt1 = null;
		PreparedStatement pstmtPickLotNo = null;
		PreparedStatement pstmtPickLotSl = null;
		PreparedStatement pstmtLoc = null;
		PreparedStatement pstmtStock = null;
		PreparedStatement pstmtLoc1 = null;
		PreparedStatement pstmtStock1 = null;
		PreparedStatement pstmtStock2 = null;
		PreparedStatement pstmtStock3 = null;

		ResultSet rs = null, rs1 = null;		

		StringBuffer errStringXml = new StringBuffer("<?xml version=\"1.0\"?>\r\n<Root><Errors>");
		String errorType = "", errCode = "", docLocCode = "" ,statusPkord= "", status = "O",locCode = "";
		ArrayList errList = new ArrayList();
		ArrayList errFields = new ArrayList();
	
		HashMap itmVolumeMap = new HashMap();
	
		String assignTo = "",childNodeName = "";
		NodeList parentNodeList = null;
		NodeList childNodeList = null;
		Node parentNode = null;
		Node childNode = null;
		int childNodeListLength = 0;
		try
		{	
			int currentFormNo = 0;
			//Changed and Commented By Santosh on 14-06-2016 :[START]
			//ConnDriver connDriver = new ConnDriver();
			//conn = connDriver.getConnectDB( "DriverITM" );
			conn = getConnection();
			//connDriver = null;
			//Changed and Commented By Santosh on 14-06-2016 :[END]
			SimpleDateFormat sdf1 = new SimpleDateFormat(genericUtility.getApplDateFormat());
			String userId = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginCode" );

			if ( objContext != null && objContext.trim().length() > 0 )
			{
				currentFormNo = Integer.parseInt( objContext );
			}
			System.out.println("currentFormNo----------->>"+currentFormNo);			
			/*NodeList parentList = currFormDataDom.getElementsByTagName( "Detail" + currentFormNo );
			NodeList childList = null;	
			noOfParent = parentList.getLength();*/
			

			//changes added to get the obj_name and to distinguish betwwen active pick and case pick
			//Gulzar - 28/11/11
			objName = checkNullAndTrim(getObjNameFromDom( currFormDataDom, "objName", objContext ));
			System.out.println(" objName =[" + objName + "]");

			//Changes by gulzar on 12/28/2011
			intrLocInvstat = distCommon.getDisparams( "999999", "INTR_LOCATION", conn );
			//End changes by gulzar on 12/28/2011
			
			switch ( currentFormNo )  // Switch Case for form number
			{
			case 1:
			{				
				System.out.println("detail1 validation@@---------");
				System.out.println("currFormDataDom---->>["+genericUtility.serializeDom(currFormDataDom).toString()+"]");
				System.out.println("hdrDataDom----->>["+genericUtility.serializeDom(hdrDataDom).toString()+"]");
				System.out.println("allFormDataDom----->>["+genericUtility.serializeDom(allFormDataDom).toString()+"]");
				parentNodeList = allFormDataDom.getElementsByTagName("Detail1");
				parentNode = parentNodeList.item(0);
				childNodeList = parentNode.getChildNodes();
				childNodeListLength = childNodeList.getLength();
				System.out.println("childNodeListLength---------->>"+childNodeListLength);
				for ( int ctr = 0; ctr < childNodeListLength; ctr++ ) //Loop for each node of current detail
				{	
					childNode = childNodeList.item(ctr);
					childNodeName = childNode.getNodeName();
					if( childNode.getNodeType() != Node.ELEMENT_NODE )
					{
						continue;
					}					
					if ( childNode != null && childNode.getFirstChild() != null )
					{
						columnValue = childNode.getFirstChild().getNodeValue();
					}
					System.out.println(" columnName [" + childNodeName + "] columnValue [" + columnValue + "]");
					if ( "pick_order".equalsIgnoreCase( childNodeName ) )
					{
						if ( childNode.getFirstChild() == null)
						{
					
							errList.add( "NULPICKORD" );
							errFields.add( childNodeName.toLowerCase() );
							
						}
						pickOrder = genericUtility.getColumnValue( "pick_order", currFormDataDom );
						ptcn = genericUtility.getColumnValue( "ptcn", allFormDataDom );
						System.out.println("new PTCN---------->>"+ptcn);						
						//Changed by sumit on 22/01/13 adding validation where user going to do this task which is already processing by other user start
						sql = "SELECT CONFIRMED, CHG_USER FROM PICK_ISS_HDR WHERE PICK_ORDER = ? ";
						pstmt = conn.prepareStatement( sql );
						pstmt.setString( 1, pickOrder );
						rs = pstmt.executeQuery();
						if( rs.next() )
						{
							System.out.println(" confirmed ["+rs.getString("CONFIRMED")+"] userid ["+rs.getString("CHG_USER")+"]");
							if( "N".equalsIgnoreCase(rs.getString("CONFIRMED")) && !userId.trim().equalsIgnoreCase(rs.getString("CHG_USER").trim()))
							{
								errList.add( "VMPICKORDU" );
								errFields.add( childNodeName.toLowerCase() );
							}
						}
						rs.close();
						rs = null;
						pstmt.close();
						pstmt = null;						
						
						//
						sql = "SELECT CONFIRMED, CHG_USER FROM PICK_ISS_HDR  WHERE PTCN  = ? ";
						pstmt = conn.prepareStatement( sql );
						pstmt.setString( 1, ptcn );
						rs = pstmt.executeQuery();
						if( rs.next() )
						{
							System.out.println(" confirmed ["+rs.getString("CONFIRMED")+"] userid ["+rs.getString("CHG_USER")+"]");
							if( "Y".equalsIgnoreCase(rs.getString("CONFIRMED")) )
							{
								errList.add( "VMPTCNCONF" );
								errFields.add( childNodeName.toLowerCase() );
							}
						}
						rs.close();
						rs = null;
						pstmt.close();
						pstmt = null;
						//
						
						sql =   " SELECT SUM(QUANTITY - CASE WHEN DEALLOC_QTY IS NULL THEN 0 ELSE DEALLOC_QTY END) AS QUANTITY " +
								" FROM PICK_ORD_DET WHERE PICK_ORDER = ? ";
					    quantity = 0.0;
						pstmt = conn.prepareStatement( sql );
						pstmt.setString( 1, pickOrder );
						rs = pstmt.executeQuery();
						if( rs.next() )
						{
							quantity = rs.getDouble("QUANTITY");
							System.out.println(" quantity ["+quantity+"]");
							if( quantity <= 0)
							{
								errList.add( "PICKDEALOC" );
								errFields.add( childNodeName.toLowerCase() );
							}
						}
						rs.close();
						rs = null;
						pstmt.close();
						pstmt = null;						
												
						sql =   "SELECT STATUS FROM WAVE_TASK_DET WHERE REF_ID = ? ";					    
						pstmt = conn.prepareStatement( sql );
						pstmt.setString( 1, pickOrder );
						rs = pstmt.executeQuery();
						if( rs.next() )
						{				
							status = rs.getString("STATUS");
							System.out.println(" status ["+status+"]");
							if("Y".equalsIgnoreCase(status))
							{
								errList.add( "VTPKORDC" );
								errFields.add( childNodeName.toLowerCase() );
							}
						}
						rs.close();
						rs = null;
						pstmt.close();
						pstmt = null;						
				
						sql = "SELECT count(1) FROM PICK_ORD_HDR WHERE PICK_ORDER = ?";
						pstmt = conn.prepareStatement( sql );
						pstmt.setString( 1, pickOrder );
						rs = pstmt.executeQuery();
						if( rs.next() )
						{
							cnt = rs.getInt(1);
						}
						rs.close();
						rs = null;
						pstmt.close();
						pstmt = null;
						if( cnt == 0)
						{
							errList.add( "VMPICKORD" );
							errFields.add( childNodeName.toLowerCase() );
						}						
						else
						{
							sql = " SELECT WAVE_TASK.CANCEL FROM WAVE_TASK, PICK_ORD_HDR " +
									" WHERE PICK_ORD_HDR.WAVE_ID = WAVE_TASK.WAVE_ID " +
									" AND PICK_ORD_HDR.PICK_ORDER = ? ";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, pickOrder);
							rs = pstmt.executeQuery();
							if( rs.next())
							{
								if( "Y".equalsIgnoreCase(rs.getString("CANCEL")))
								{
									errList.add( "PICKCANCEL" );
									errFields.add( childNodeName.toLowerCase() );
								}
							}
						}
					
						status = "O";
						sql = "SELECT PICK_TYPE, CASE WHEN STATUS IS NULL THEN 'O' ELSE STATUS END AS STATUS FROM PICK_ORD_HDR WHERE PICK_ORDER = ?";
						pstmt = conn.prepareStatement( sql );
						pstmt.setString( 1, pickOrder );
						rs = pstmt.executeQuery();

						if( rs.next() )
						{
							pickType = checkNull(rs.getString("PICK_TYPE"));
							status  = checkNull(rs.getString("STATUS"));
						}
						else
						{
							errList.add( "INVPICKORD" );
							errFields.add( childNodeName.toLowerCase() );
				
						}
						rs.close(); rs = null;
						pstmt.close(); pstmt = null;
						if("C".equals(status))
						{
							errList.add( "VTPKORDC" );
							errFields.add( childNodeName.toLowerCase() );
							
						}

						sql=" SELECT WAVE_ID FROM PICK_ORD_HDR WHERE PICK_ORDER = ? ";
						pstmt = conn.prepareStatement( sql );
						pstmt.setString( 1, pickOrder );
						rs = pstmt.executeQuery();

						if( rs.next() )
						{
							waveId = rs.getString("WAVE_ID");
						}

						rs.close();
						rs = null;
						pstmt.close();
						pstmt = null;

						if(waveId != null && waveId.trim().length() > 0)
						{
							sql= "SELECT HOLD_STATUS FROM WAVE_TASK WHERE WAVE_ID = ? ";
							pstmt = conn.prepareStatement( sql );
							pstmt.setString( 1, waveId );
							rs = pstmt.executeQuery();
							if( rs.next() )
							{
								holdStatus = rs.getString("HOLD_STATUS");
							}
							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;
						}
						
						if("Y".equalsIgnoreCase(holdStatus))
						{
							errList.add( "PRCESHLD" );
							errFields.add( childNodeName.toLowerCase() );
						}
						
						
						if ( pickType.trim().length() == 0  )
						{
							
							errList.add( "NULPICKTYP" );
							errFields.add( childNodeName.toLowerCase() );
							
						}
					
						if ( "active_pick".equalsIgnoreCase(objName) && ! pickType.trim().equalsIgnoreCase("A") )
						{
							errList.add( "ACTIVEPICK" );
							errFields.add( childNodeName.toLowerCase() );
						}
						else if ( "case_pick".equalsIgnoreCase(objName) && (! pickType.trim().equalsIgnoreCase("C") &&  ! pickType.trim().equalsIgnoreCase("M")) )
						{
							errList.add( "CASEPICK" );
							errFields.add( childNodeName.toLowerCase() );
						}
					
						sql = "SELECT STATUS FROM PICK_ORD_HDR WHERE PICK_ORDER = ? ";
						pstmt = conn.prepareStatement( sql );
						pstmt.setString( 1, pickOrder );
						rs = pstmt.executeQuery();

						if( rs.next() )
						{
							statusPkord = checkNull(rs.getString("STATUS"));
						}
						rs.close(); rs = null;
						pstmt.close(); pstmt = null;
						if ( "C".equalsIgnoreCase(statusPkord.trim()) )
						{
							errList.add( "CLSPCKORD" ); 
							errFields.add( childNodeName.toLowerCase() ); 
						}
						 
						sql = "SELECT HDR.REPL_ORDER AS REPL_ORDER FROM REPL_ORD_HDR HDR, REPL_ORD_DET DET, PICK_ORD_DET DET1 WHERE" +
								" HDR.REPL_ORDER = DET.REPL_ORDER AND DET1.REPL_ORDER = HDR.REPL_ORDER AND DET.PICK_ORDER= ? ";

						pstmt = conn.prepareStatement( sql );
						pstmt.setString( 1,pickOrder);
						rs = pstmt.executeQuery();
						if( rs.next() )
						{
							replOrder = checkNull(rs.getString("REPL_ORDER"));
						}
						rs.close(); rs = null;
						pstmt.close(); pstmt = null;

						if ( replOrder.trim().length() > 0 )
						{
							sql = "SELECT CONFIRMED FROM REPL_ISS_HDR WHERE REPL_ORDER = ? ";

							pstmt = conn.prepareStatement( sql );
							pstmt.setString( 1, replOrder );
							rs = pstmt.executeQuery();

							if( rs.next() )
							{
								confirmed = checkNull(rs.getString("CONFIRMED"));
							}
							rs.close(); rs = null;
							pstmt.close(); pstmt = null;

							if ( confirmed.trim().length() == 0 || "N".equalsIgnoreCase(confirmed.trim()) )
							{
							
								errList.add( "VTREPLISS1" );
								errFields.add( childNodeName.toLowerCase() );
							}
						}
						
						sql = " SELECT DISTINCT POD.REPL_ORDER FROM PICK_ORD_DET POD, REPL_ORD_DET ROD WHERE  POD.PICK_ORDER= ? " +
								" AND ROD.REPL_ORDER IS NOT NULL AND POD.REPL_ORDER = ROD.REPL_ORDER " +
								" AND (CASE WHEN ROD.CANCEL_MODE IS NULL THEN 'N' ELSE ROD.CANCEL_MODE END) <> 'Y'" +
								" AND (POD.QUANTITY - CASE WHEN POD.DEALLOC_QTY IS NULL THEN 0 ELSE POD.DEALLOC_QTY END ) > 0 ";

						pstmt = conn.prepareStatement( sql );
						pstmt.setString( 1, pickOrder );
						rs = pstmt.executeQuery();

						while( rs.next() )
						{
							replOrder = checkNull(rs.getString(1));
							if ( replOrder.trim().length() > 0 )
							{
								sql1 = "SELECT CONFIRMED FROM REPL_ISS_HDR WHERE REPL_ORDER = ? ";
								confirmed = "N";
								pstmt1 = conn.prepareStatement( sql1 );
								pstmt1.setString( 1, replOrder );
								rs1 = pstmt1.executeQuery();

								if( rs1.next() )
								{
									confirmed = checkNull(rs1.getString("CONFIRMED"));
								}
								rs1.close(); rs1 = null;
								pstmt1.close(); pstmt1 = null;

								if ( confirmed.trim().length() == 0 || "N".equalsIgnoreCase(confirmed.trim()) )
								{
									errList.add( "VTREPLISS1" );
									errFields.add( childNodeName.toLowerCase() );
								}
							}


						}
						rs.close(); rs = null;
						pstmt.close(); pstmt = null;
						System.out.println("@@@@@ item validation in pick_order executed.......");
						pickOrder = checkNull(genericUtility.getColumnValue( "pick_order", currFormDataDom  ));
						
						sql = " SELECT ASSIGN_TO FROM PICK_ORD_HDR WHERE PICK_ORDER = ? ";
						pstmt = conn.prepareStatement( sql );
						pstmt.setString( 1, pickOrder );
						rs = pstmt.executeQuery();
						if( rs.next() )
						{
							assignTo = checkNull (rs.getString("ASSIGN_TO"));
						}
						
						rs.close();
						rs = null;
						pstmt.close();
						pstmt = null;
						
						System.out.println("UESRID:"+userId);
						System.out.println("ASSIGNTO:"+assignTo);
						if( assignTo !=null && assignTo.trim().length() > 0 && !assignTo.trim().equalsIgnoreCase(userId) )
						{
							errList.add( "INVREPKTSK" );
							errFields.add( childNodeName.toLowerCase() );
						}						
						String palletNoDom = checkNull(genericUtility.getColumnValue( "ptcn", currFormDataDom ));;
						String palletNoDb = "";
						sql = "SELECT P.PTCN FROM PICK_ISS_HDR P WHERE P.PICK_ORDER = ? " 
								+" AND P.TRAN_ID  NOT IN (SELECT TRAN_ID FROM PICK_ISS_DET WHERE PICK_ORDER = ?)";       // commented by cpatil on 11-sept-12
							pstmt = conn.prepareStatement( sql );
							pstmt.setString( 1, pickOrder );
							pstmt.setString( 2, pickOrder );

							rs = pstmt.executeQuery();

							if( rs.next() )
							{
								palletNoDb = checkNull(rs.getString("ptcn"));
								System.out.println("pallet no db ="+palletNoDb);
								if ( (palletNoDom.trim().length() > 0 &&  palletNoDb.length() > 0 && ! palletNoDom.trim().equalsIgnoreCase(palletNoDb))  )
								{
									System.out.println("Unmatch PALLET NO ");
									errList.add( "VTAPLTEXST" );
									errFields.add( childNodeName.toLowerCase() );
								}
							}
							
							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;
						
					}
					else if ( "ptcn".equalsIgnoreCase( childNodeName ) )   
					{
						if ( childNode.getFirstChild() == null)
						{							
							errList.add( "NULLPLTNO" );
							errFields.add( childNodeName.toLowerCase() );						
						}
						else
						{
							
							ptcn = checkNullAndTrim(genericUtility.getColumnValue( "ptcn", currFormDataDom ));
							pickOrder = checkNullAndTrim(genericUtility.getColumnValue( "pick_order", currFormDataDom ));

							sql = "SELECT PICK_TYPE FROM PICK_ORD_HDR WHERE PICK_ORDER = ?";
							pstmt = conn.prepareStatement( sql );
							pstmt.setString( 1, pickOrder );
							rs = pstmt.executeQuery();

							if( rs.next() )
							{
								pickType = checkNull(rs.getString("PICK_TYPE"));
							}
							rs.close(); rs = null;
							pstmt.close(); pstmt = null;

							/*sql = "SELECT PTCN FROM WAVE_TASK_DET WHERE REF_ID = ?";
							pstmt = conn.prepareStatement( sql );
							pstmt.setString( 1, pickOrder );
							rs = pstmt.executeQuery();

							if( rs.next() )
							{
								ptcn = checkNull(rs.getString("ptcn"));
							}
							rs.close(); rs = null;
							pstmt.close(); pstmt = null;*/
							System.out.println("ptcn@@-------->>["+ptcn+"]");							
							
							sql = "SELECT DISTINCT PTCN FROM WAVE_TASK_DET WHERE REF_ID IN (SELECT DISTINCT PICK_ORDER FROM PICK_ISS_HDR WHERE PTCN = ?)";
							pstmt = conn.prepareStatement( sql );
							pstmt.setString(1, ptcn);
							rs = pstmt.executeQuery();
							while( rs.next())
							{
								String tempPTCN = "";
								tempPTCN = checkNullAndTrim(rs.getString("ptcn"));
								if( !tempPTCN.equalsIgnoreCase(ptcn))
								{
									errList.add( "INVPKPTCN" );
									errFields.add( childNodeName.toLowerCase() );
								}								
							}
							rs.close(); rs = null;
							pstmt.close(); pstmt = null;														
						}

					}
				}
			} //End of case 1 Validation
			break;
			case 2:
			{				
				System.out.println("detail2 validation.............");
				System.out.println("currFormDataDom---->>["+genericUtility.serializeDom(currFormDataDom).toString()+"]");
				System.out.println("hdrDataDom----->>["+genericUtility.serializeDom(hdrDataDom).toString()+"]");
				System.out.println("allFormDataDom----->>["+genericUtility.serializeDom(allFormDataDom).toString()+"]");	
				parentNodeList = allFormDataDom.getElementsByTagName("Detail2");
				parentNode = parentNodeList.item(0);
				System.out.println("parentNode >>>{"+parentNode+"}");
				childNodeList = parentNode.getChildNodes();
				childNodeListLength = childNodeList.getLength();
				System.out.println("childNodeListLength >>>{"+childNodeListLength+"}");
				for ( int ctr = 0; ctr < childNodeListLength; ctr++ ) //Loop for each node of current detail
				{	
					childNode = childNodeList.item(ctr);
					childNodeName = childNode.getNodeName();
					System.out.println("value of child node name ["+childNodeName + "]");
					if( childNode.getNodeType() != Node.ELEMENT_NODE )
					{
						continue;
					}					
					if ( childNode != null && childNode.getFirstChild() != null )
					{
						columnValue = childNode.getFirstChild().getNodeValue();
					}
					System.out.println(" columnName [" + childNodeName + "] columnValue [" + columnValue + "]");
					if ( "tran_date".equalsIgnoreCase( childNodeName ) )
					{
						if ( childNode.getFirstChild() == null )
						{							
							errList.add( "NULLTRANDT" );
							errFields.add( childNodeName.toLowerCase() );							
						}

					}//End of tran_date validation
					else if( "site_code".equalsIgnoreCase( childNodeName ) )
					{
						if ( childNode.getFirstChild() == null)
						{							
							errList.add( "NULLSITECD" );
							errFields.add( childNodeName.toLowerCase() );							
						}
						siteCode = genericUtility.getColumnValue( "site_code", currFormDataDom );
						sql = "SELECT COUNT(*) AS COUNT FROM SITE WHERE SITE_CODE = ?";
						pstmt = conn.prepareStatement( sql );
						pstmt.setString( 1, siteCode );
						rs = pstmt.executeQuery();

						if( rs.next() )
						{
							count = rs.getInt("COUNT");
						}
						rs.close(); rs = null;
						pstmt.close(); pstmt = null;

						if( count == 0 )
						{							
							errList.add( "INVDSITECD" );
							errFields.add( childNodeName.toLowerCase() );							
						}
						else 
						{							
							siteCode = genericUtility.getColumnValue("site_code", currFormDataDom);
							
							System.out.println("364 site code ="+siteCode);
							if (genericUtility.getColumnValue("tran_date", currFormDataDom) != null)
							{
								tranDate = sdf1.parse(genericUtility.getColumnValue("tran_date", currFormDataDom));
								sql = "select code from period where ?  between fr_date and to_date";
								pstmt = conn.prepareStatement(sql);
								pstmt.setDate(1, new java.sql.Date(tranDate.getTime()));
								rs = pstmt.executeQuery();
								if (rs.next())
								{
									prdCode = rs.getString(1);

								}
								rs.close();
								rs = null;
								pstmt.close();
								pstmt = null;

								sql = "select count(*) from period_stat where site_code = ? and prd_code = ? ";
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1, siteCode);
								pstmt.setString(2, prdCode);
								rs = pstmt.executeQuery();
								if (rs.next())
								{
									count = rs.getInt(1);

								}
								rs.close();
								rs = null;
								pstmt.close();
								pstmt = null;
								if (count == 0)
								{
									errList.add( "VTSITEPD" );
									errFields.add( childNodeName.toLowerCase() );
									break;
								}
								// nvo_functions_adv.nf_check_period('SAL',mdate1,msite_code)
								errCode = nfCheckPeriod("IC", tranDate, siteCode);
								System.out.println("425 Error Code = " + errCode);
								if (errCode != null && errCode.trim().length() > 0)
								{
									errList.add( errCode );
									errFields.add( childNodeName.toLowerCase() );
				
								}
							} 							 
						}//end 
					}//End of site_code validation
					else if ( "pick_order".equalsIgnoreCase( childNodeName ) )
					{
						if ( childNode.getFirstChild() == null)
						{							
							errList.add( "NULPICKORD" );
							errFields.add( childNodeName.toLowerCase() );
							
						}
						pickOrder = genericUtility.getColumnValue( "pick_order", currFormDataDom );			
						
						sql = "SELECT CONFIRMED, CHG_USER FROM PICK_ISS_HDR WHERE PICK_ORDER = ? ";
						pstmt = conn.prepareStatement( sql );
						pstmt.setString( 1, pickOrder );
						rs = pstmt.executeQuery();
						if( rs.next() )
						{
							System.out.println(" confirmed ["+rs.getString("CONFIRMED")+"] userid ["+rs.getString("CHG_USER")+"]");
							if( "N".equalsIgnoreCase(rs.getString("CONFIRMED")) && !userId.trim().equalsIgnoreCase(rs.getString("CHG_USER").trim()))
							{
								errList.add( "VMPICKORDU" );
								errFields.add( childNodeName.toLowerCase() );
							}
						}
						rs.close();
						rs = null;
						pstmt.close();
						pstmt = null;						
						

						sql = "SELECT COUNT(*) AS COUNT FROM PICK_ORD_HDR WHERE PICK_ORDER = ?";
						pstmt = conn.prepareStatement( sql );
						pstmt.setString( 1, pickOrder );
						rs = pstmt.executeQuery();

						if( rs.next() )
						{
							count = rs.getInt("COUNT");
						}
						rs.close(); rs = null;
						pstmt.close(); pstmt = null;

						if( count == 0 )
						{							
							errList.add( "INVPICKORD" );
							errFields.add( childNodeName.toLowerCase() );							
						}
						
						
					}//End pick_order validation
					else if ( "pick_type".equalsIgnoreCase( childNodeName ) )
					{
						pickType = checkNull(genericUtility.getColumnValue( "pick_type", currFormDataDom ));
						if ( childNode.getFirstChild() == null)
						{							
							errList.add( "NULPICKTYP" );
							errFields.add( childNodeName.toLowerCase() );							
						}						
						else 
						{
							sql = "SELECT COUNT(*) AS COUNT FROM PICK_ORD_HDR WHERE pick_type = ?";
							pstmt = conn.prepareStatement( sql );
							pstmt.setString( 1, pickType.trim() );
							rs = pstmt.executeQuery();

							if( rs.next() )
							{
								count = rs.getInt("COUNT");
							}
							rs.close(); rs = null;
							pstmt.close(); pstmt = null;
							if( count == 0 )
							{
								errList.add( "INVPICKTYP" );
								errFields.add( childNodeName.toLowerCase() );
							}
						}

					}
				}
			} //End of case 2 Validation
			break;
			case 3:
			{
				System.out.println("detail3 validation.............");
				System.out.println("currFormDataDom---->>["+genericUtility.serializeDom(currFormDataDom).toString()+"]");
				System.out.println("hdrDataDom----->>["+genericUtility.serializeDom(hdrDataDom).toString()+"]");
				System.out.println("allFormDataDom----->>["+genericUtility.serializeDom(allFormDataDom).toString()+"]");	
					
				parentNodeList = allFormDataDom.getElementsByTagName("Detail3");
				parentNode = parentNodeList.item(0);
				childNodeList = parentNode.getChildNodes();
				childNodeListLength = childNodeList.getLength();
				System.out.println("childNodeListLength----->>"+childNodeListLength);				
				for ( int ctr = 0; ctr < childNodeListLength; ctr++ ) //Loop for each node of current detail
				{	
					childNode = childNodeList.item(ctr);
					childNodeName = childNode.getNodeName();					
					System.out.println("value of child node : "+childNode);
					if( childNode.getNodeType() != Node.ELEMENT_NODE )
					{
						continue;
					}					
					if ( childNode != null && childNode.getFirstChild() != null )
					{
						columnValue = childNode.getFirstChild().getNodeValue();
					}
					System.out.println(" columnName [" + childNodeName + "] columnValue [" + columnValue + "]");
					if ( "loc_code".equalsIgnoreCase( childNodeName ) )
					{
						locCode = checkNull(genericUtility.getColumnValue( "loc_code", allFormDataDom ));
						pickOrder = genericUtility.getColumnValue( "pick_order", allFormDataDom );

						locCode = locCode.trim();
						System.out.println("locCode@@@--------->>["+locCode+"]");	
						System.out.println("pickOrder@@--------->>["+pickOrder+"]");	
						if ( locCode.length() == 0 )
						{							
							errList.add( "VTLOCNNULL" ); //Location code can not be null
							errFields.add( childNodeName.toLowerCase() );						
						}
						else
						{
							sql = "SELECT COUNT(*) AS COUNT FROM LOCATION WHERE LOC_CODE = ?";
							pstmt = conn.prepareStatement(sql);							
							pstmt.setString(1, locCode);							
							rs = pstmt.executeQuery();
							if(rs.next())								
							{
								count = rs.getInt(1);
							}
							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;
							System.out.println("Location count@@------->>"+count);
							if(count == 0)
							{
								errList.add( "VTLOCNTPM" ); // Location does not exist in Location master
								errFields.add( childNodeName.toLowerCase() );	
							}
							else
							{
								sql = "SELECT COUNT(*) AS COUNT FROM PICK_ORD_DET WHERE PICK_ORDER = ?"
										+ " AND LOC_CODE = ?";
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1,pickOrder);
								pstmt.setString(2, locCode);
								rs = pstmt.executeQuery();
								if(rs.next())								
								{
									count = rs.getInt(1);
								}
								rs.close();
								rs = null;
								pstmt.close();
								pstmt = null;
								System.out.println("count@@------->>"+count);
								if(count == 0)
								{
									errList.add( "VTINVDLOCC" ); //INVALID LOCATION CODE
									errFields.add( childNodeName.toLowerCase() );	
								}
							}

						}

					}//End of tran_date validation
				}

			} //End of Case 3 Validation		
			case 4:			
			{
				System.out.println("detail4 validation.............");
			}
				
			}//End of switch statement
			int errListSize = errList.size();
			cnt =0;
			String errFldName = null;
			if ( errList != null && errListSize > 0 )
			{
				for (cnt = 0; cnt < errListSize; cnt++ )
				{
					errCode = (String)errList.get(cnt);
					errFldName = (String)errFields.get(cnt);
					System.out.println("errCode .........."+errCode);
					errString = getErrorString( errFldName, errCode, userId );
					errorType =  errorType( conn , errCode );
					if ( errString.length() > 0)
					{
						String bifurErrString = errString.substring( errString.indexOf("<Errors>") + 8,errString.indexOf("<trace>"));
						bifurErrString =bifurErrString;//+"<trace>"+errMsg+"</trace>";
						bifurErrString =bifurErrString+errString.substring( errString.indexOf("</trace>") + 8,errString.indexOf("</Errors>"));
						errStringXml.append(bifurErrString);
						System.out.println("errStringXml .........."+errStringXml);
						errString = "";
					}
					if ( errorType.equalsIgnoreCase("E"))
					{
						break;
					}
				}
				errList.clear();
				errList = null;
				errFields.clear();
				errFields = null;

				errStringXml.append("</Errors></Root>\r\n");
			}
			else
			{
				errStringXml = new StringBuffer( "" );
			}
			errString = errStringXml.toString();
		}
		catch ( Exception e )
		{
			System.out.println ( "Exception: LocWisePickWizIC: wfValData( Document currFormDataDom ): " + e.getMessage() + ":" );
			//throw new ITMException(e);
			e.printStackTrace();
			errString = generateErrorString( genericUtility.createErrorString( e ) ) ;
		}
		finally
		{
			try
			{
				if (rs!=null)
				{
					rs.close();
					rs = null;
				}				
				if (pstmt!=null)
				{
					pstmt.close(); pstmt = null;
				}
				if (pstmtPickLotNo!=null)
				{
					pstmtPickLotNo.close(); pstmtPickLotNo = null;
				}
				if (pstmtPickLotSl!=null)
				{
					pstmtPickLotSl.close(); pstmtPickLotSl = null;
				}
				if (pstmtLoc!=null)
				{
					pstmtLoc.close(); pstmtLoc = null;
				}
				if (pstmtLoc1!=null)
				{
					pstmtLoc1.close(); pstmtLoc1 = null;
				}
				if (pstmtStock!=null)
				{
					pstmtStock.close(); pstmtStock = null;
				}
				if (pstmtStock1!=null)
				{
					pstmtStock1.close(); pstmtStock1 = null;
				}
				if (pstmtStock2!=null)
				{
					pstmtStock2.close(); pstmtStock2 = null;
				}
				if( pstmtStock3 != null  )
				{
					pstmtStock3.close(); pstmtStock3 = null;
				}
				if( conn != null  )
				{
					conn.close(); conn = null;
				}
			}
			catch(Exception e)
			{
				System.out.println( "Exception : LocWisePickWizIC:wfValData : " + e.getMessage() );
				throw new ITMException(e);
			}
		}
		System.out.println( "errString>>>>>>>::"+errString );
		return errString;
	}
	private String errorType( Connection conn , String errorCode )
	{
		String msgType = "";
		PreparedStatement pstmt = null ; 
		ResultSet rs = null;
		try
		{			
			String  sql = " SELECT MSG_TYPE FROM MESSAGES WHERE MSG_NO =   ? ";

			pstmt = conn.prepareStatement( sql );			
			pstmt.setString(1, errorCode);			
			rs = pstmt.executeQuery();
			while( rs.next() )
			{
				msgType = rs.getString("MSG_TYPE");
			}			
		}
		catch (Exception ex)
		{
			ex.printStackTrace();
		}		
		finally
		{
			try
			{
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch ( Exception e )
			{
				e.printStackTrace();
			}
		}		
		return msgType;
	}


	/**
	 * The public method is defined without any parameters and returns blank string
	 */
	@Override
	public String itemChanged() throws RemoteException, ITMException
	{
		return "";
	}

	/**
	 * The public method is used for converting the current form data into a document(dom)
	 * The dom is then given as argument to the overloaded function wfValData to perform validation
	 * Returns validation string if exists else returns null in XML format
	 * @param xmlString contains the current form data in XML format
	 * @param xmlString1 contains all the header information in the XML format
	 * @param xmlString2 contains the data of all the forms in XML format
	 * @param objContext represents the form number
	 * @param editFlag represents the mode of transaction(A-Add or E-Edit)
	 * @param xtraParams contains additional information such as loginEmpCode,loginCode,chgTerm etc
	 */
	@Override
	public String itemChanged(String xmlString, String xmlString1, String xmlString2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		Document currFormDataDom = null;
		Document hdrDataDom = null;
		Document allFormDataDom = null;
		String errString = null;
		E12GenericUtility genericUtility = new E12GenericUtility();
		System.out.println("xmlString ["+xmlString+"]");
		System.out.println("xmlString1 ["+xmlString1+"]");
		System.out.println("xmlString2 ["+xmlString2+"]");
		try
		{
			if (xmlString != null && xmlString.trim().length()!=0)
			{
				currFormDataDom = genericUtility.parseString(xmlString); 
			}
			if (xmlString1 != null && xmlString1.trim().length()!=0)
			{
				hdrDataDom = genericUtility.parseString(xmlString1); 
			}
			if (xmlString2 != null && xmlString2.trim().length()!=0)
			{
				allFormDataDom = genericUtility.parseString(xmlString2); 
			}
			System.out.println ( "Calling  itemChanged( currFormDataDom, hdrDataDom, allFormDataDom, objContext, currentColumn, editFlag, xtraParams )");
			errString = itemChanged( currFormDataDom, hdrDataDom, allFormDataDom, objContext, currentColumn, editFlag, xtraParams );
			System.out.println ( "ErrString :" + errString);
		}
		catch (Exception e)
		{
			System.out.println ( "Exception :LocWisePickWizIC :itemChanged(String,String):" + e.getMessage() + ":" );
			throw new ITMException(e);
		}
		System.out.println ( "returning from LocWisePickWizIC itemChanged \n[" + errString + "]" );

		return errString;
	}

	/**
	 * The public overloaded method takes a document as input and is used for the validation of required fields 
	 * Returns validation string if exist otherwise returns null in XML format
	 * @param currFormDataDom contains the current form data as a document object model
	 * @param hdrDataDom contains all the header information
	 * @param allFormDataDom contains the field data of all the forms 
	 * @param objContext represents form number
	 * @param currentColumn represents the current field 
	 * @param editFlag represents the mode of transaction(A-Add or E-Edit)
	 * @param xtraParams contains additional information
	 */
	@Override
	public String itemChanged( Document currFormDataDom, Document hdrDataDom, Document allFormDataDom, String objContext, String currentColumn,String editFlag, String xtraParams ) throws RemoteException,ITMException
	{		
		String retString = "";		
		String siteCode = "";
		String itemCode = "";
		String locCode = "";
		String lotNo = "";
		String lpnNo = "";
		String pickOrder = "";
		String siteDescr = "";
		String tranID = "";
		String tranDate = "";
		String sql = "";
		String locCodeTo = "";
		String itemDescr = "";
		String unit = "";
		String pickType = "";
		
		String ptcn = "";
		String pickLocInvstat = "";
		String cartonNo = "";
		String pickLocCode = "";
		String stockSql = "",docLocCode = "";
		String userId = "";
		String actCartonNo = "";
		String actPackCode = "";
		
		String siteCodeShip = "";
		int currentFormNo = 0;
		int lineNoOrd = 0;
		int lineNoIss = 0;
		int domID = 0;
		int locListSize = 0;
		int count = 0;

		double quantity = 0;
		double noArt = 0;
		double qtyPerArt = 0;
		double shipperSize = 0.0; 
		
		Connection conn = null;
		PreparedStatement pstmt = null;
		PreparedStatement pstmtOrd = null;
		PreparedStatement pstmtIss = null;
		PreparedStatement pstmtStock = null;

		ResultSet rs = null ;
		ResultSet rsOrd = null ;
		ResultSet rsIss = null ;
		ResultSet rsStock = null ;
		ArrayList pickLocList = null;
		ArrayList<String> locCodeList = new ArrayList <String>();
		HashMap itmVolumeMap = new HashMap();
		StringBuffer valueXmlString;

		System.out.println("xtraParams=["+xtraParams+"]");
		DistCommon distCommon = new DistCommon();

		E12GenericUtility genericUtility = new E12GenericUtility();
		genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginCode" );

		String objName = checkNullAndTrim(getObjNameFromDom( currFormDataDom, "objName", objContext ));

		valueXmlString = new StringBuffer("<?xml version=\"1.0\"?>\r\n<Root>\r\n<Header>\r\n<editFlag>").append( editFlag );

		try
		{
			DateFormat dtFormat = new SimpleDateFormat(genericUtility.getApplDateFormat());

			String dbDateFormat = genericUtility.getDBDateFormat();
			String applDateFormat = genericUtility.getApplDateFormat();
			//Changed and Commented By Santosh on 14-06-2016 :[START]
			//ConnDriver connDriver = new ConnDriver();
			//conn = connDriver.getConnectDB( "DriverITM" );
			conn = getConnection();
			//connDriver = null;
			//Changed and Commented By Santosh on 14-06-2016 :[END]

			if( objContext != null && objContext.trim().length() > 0 )
			{
				currentFormNo = Integer.parseInt( objContext );
			}
			System.out.println("current form no["+currentFormNo+"]");
			valueXmlString.append("</editFlag>\r\n</Header>\r\n");
			switch ( currentFormNo )  
			{
			case 1:
			{
				valueXmlString.append( "<Detail1 domID='1'>\r\n" );
				valueXmlString.append("<attribute selected=\"N\" updateFlag=\"A\" status=\"O\" pkNames=\"\" />\r\n");
				if( currentColumn.trim().equalsIgnoreCase( "itm_default" ) )
				{
					//valueXmlString.append( "<trans_mode><![CDATA[" ).append( "E" ).append( "]]></trans_mode>\r\n" );
				}
				valueXmlString.append("</Detail1>\r\n");
			} //Case 1. End
			break;
			case 2:
			{
				System.out.println("inside case 2 itemchange");
				System.out.println("hdrDataDom PTCN------->>["+genericUtility.serializeDom(hdrDataDom)+"]");	
				System.out.println("currFormDataDom PTCN------>>["+genericUtility.serializeDom(currFormDataDom)+"]");
				System.out.println("allFormDataDom PTCN------>>["+genericUtility.serializeDom(allFormDataDom)+"]");
				//valueXmlString.append( "<Detail2 domID='1'>\r\n" );

				if( currentColumn.trim().equalsIgnoreCase( "itm_default" ) )
				{
					System.out.println("item change case 2 itm_default.............");

					pickOrder = genericUtility.getColumnValue( "pick_order", hdrDataDom );

					java.sql.Date tranDateDb = null;

					java.util.Date currDate = new java.util.Date();
					tranDate = dtFormat.format( currDate );

					String loginCode = checkNull(genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginCode" ));
					String chgTerm = checkNull(genericUtility.getValueFromXTRA_PARAMS( xtraParams, "chgTerm" ));
					siteCode = checkNull(genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginSiteCode" ));
					ptcn = genericUtility.getColumnValue( "ptcn", hdrDataDom );
					if ( siteCode.trim().length() == 0 || "INVALID_SITE".equalsIgnoreCase(siteCode.trim()) )
					{
						siteCode = getSiteCode( xtraParams, conn );
					}
					System.out.println("siteCode = ["+siteCode+"]");
					System.out.println("ptcn@@ = ["+ptcn+"]");
					System.out.println("pickOrder = ["+pickOrder+"]");

					sql = "SELECT TRAN_ID, TRAN_DATE, PICK_ORDER, SITE_CODE, PICK_TYPE, PTCN FROM PICK_ISS_HDR WHERE PICK_ORDER = ? AND PTCN = ? AND CHG_USER = ? AND case when confirmed is null then 'N' else confirmed end = 'N'";
					pstmt = conn.prepareStatement( sql );
					pstmt.setString( 1, pickOrder );
					pstmt.setString( 2, ptcn );
					pstmt.setString( 3, loginCode );
					rs = pstmt.executeQuery();	
					if( rs.next() )
					{
						tranID = rs.getString("TRAN_ID");
						tranDateDb = rs.getDate("TRAN_DATE");
						siteCode = rs.getString("SITE_CODE");
						pickType = checkNull(rs.getString("PICK_TYPE"));
						ptcn = rs.getString("ptcn");
						//valueXmlString.append( "<tran_id><![CDATA[" ).append( checkNull( tranID )).append( "]]></tran_id>\r\n" );
						valueXmlString.append("<Detail2 domID='1' selected=\"Y\">\r\n");
						valueXmlString.append("<attribute selected=\"Y\" updateFlag=\"E\" status=\"O\" pkNames=\"\" />\r\n"); //added by Kunal on 14/08/12
						valueXmlString.append( "<tran_id><![CDATA[" ).append( checkNull( tranID )).append( "]]></tran_id>\r\n" );  //commented by Ashish Sonawane on 11-sep-12 for generating pick_issue for each time 
					}
					else
					{
						tranID = genericUtility.getColumnValue( "tran_id", currFormDataDom );
						ptcn = genericUtility.getColumnValue( "ptcn", hdrDataDom );
						valueXmlString.append("<Detail2 domID='1' selected=\"N\">\r\n");
						valueXmlString.append("<attribute selected=\"N\" updateFlag=\"A\" status=\"N\" pkNames=\"\" />\r\n"); //added by Kunal on 14/08/12
						valueXmlString.append( "<tran_id><![CDATA[" ).append( checkNull( tranID )).append( "]]></tran_id>\r\n" );
					}
					rs.close();rs = null;
					pstmt.close();pstmt = null;


					sql = "SELECT SITE_CODE, PICK_TYPE FROM PICK_ORD_HDR WHERE PICK_ORDER = ?";
					pstmt = conn.prepareStatement( sql );
					pstmt.setString( 1, pickOrder );
					rs = pstmt.executeQuery();	
					if( rs.next() )
					{
						pickType = checkNull(rs.getString("PICK_TYPE"));
					}
					rs.close();rs = null;
					pstmt.close();pstmt = null;
					//}
					if ( tranDateDb != null )
					{
						//	tranDate = genericUtility.getValidDateString( tranDateDb.toString() , dbDateFormat, applDateFormat ); //commented by Ashish Sonawane on 11-sep-12 
					}
					valueXmlString.append( "<tran_date protect ='1'><![CDATA[" ).append( checkNull( tranDate )).append( "]]></tran_date>\r\n" );
					valueXmlString.append( "<pick_type protect ='1'><![CDATA[" ).append( checkNull( pickType )).append( "]]></pick_type>\r\n" );
					valueXmlString.append( "<ptcn><![CDATA[" ).append( checkNull( ptcn )).append( "]]></ptcn>\r\n" );
					valueXmlString.append( "<pallet_no><![CDATA[" ).append( checkNull( ptcn )).append( "]]></pallet_no>\r\n" );
					valueXmlString.append( "<pick_order><![CDATA[" ).append( checkNull( pickOrder )).append( "]]></pick_order>\r\n" );
					valueXmlString.append( "<site_code><![CDATA[" ).append( checkNull( siteCode )).append( "]]></site_code>\r\n" );

					sql = "SELECT DESCR FROM SITE WHERE SITE_CODE = ?";
					pstmt = conn.prepareStatement( sql );
					pstmt.setString( 1, siteCode );						
					rs = pstmt.executeQuery();	
					if( rs.next() )
					{
						siteDescr = rs.getString("DESCR");
					}
					rs.close();rs = null;
					pstmt.close();pstmt = null;

					valueXmlString.append( "<site_descr><![CDATA[").append( checkNull( siteDescr )).append( "]]></site_descr>\r\n" );
					valueXmlString.append( "<confirmed><![CDATA[").append("N").append( "]]></confirmed>\r\n" );
					valueXmlString.append( "<chg_user><![CDATA[").append( loginCode ).append( "]]></chg_user>\r\n" );
					valueXmlString.append( "<chg_date><![CDATA[").append( tranDate ).append( "]]></chg_date>\r\n" );
					valueXmlString.append( "<chg_term><![CDATA[").append( chgTerm ).append( "]]></chg_term>\r\n" );

				}
				valueXmlString.append("</Detail2>\r\n");
			} //Case 2. End
			break;
			case 3://Case 3. Start
			{
				System.out.println("item change case 3...................");
				System.out.println("hdrDataDom PTCN------->>["+genericUtility.serializeDom(hdrDataDom)+"]");	
				System.out.println("currFormDataDom PTCN------>>["+genericUtility.serializeDom(currFormDataDom)+"]");
				System.out.println("allFormDataDom PTCN------>>["+genericUtility.serializeDom(allFormDataDom)+"]");
				pickOrder = genericUtility.getColumnValue( "pick_order", hdrDataDom );
				siteCode = genericUtility.getColumnValue( "site_code", allFormDataDom );
				System.out.println("siteCode---------->>"+siteCode);	
				currentColumn = currentColumn == null ? "" :currentColumn.trim();
				System.out.println("currentColumn------>>["+currentColumn+"]");
				if( currentColumn.equalsIgnoreCase( "itm_default" ) )
				{
					System.out.println("item change itm_default.............");
					if(allFormDataDom != null)
					{
						String xmlStr = getSelectedLocCode(allFormDataDom,pickOrder,siteCode,conn);
						xmlStr = xmlStr == null ? "" :xmlStr.trim();
						System.out.println("xmlStr@@----------------->>"+xmlStr);
						if(xmlStr.length() > 0)
						{
							valueXmlString.append(xmlStr);
						}
						
					}
				}
				
				if( currentColumn.trim().equalsIgnoreCase( "itm_default_add" ) )
				{
					System.out.println("item change itm_default_add.............");
					NodeList nodeList = allFormDataDom.getElementsByTagName("Detail3");
					//String domIdL =  nodeList.item(0).getAttributes().getNamedItem("domID").getNodeValue();
					String domIdL = getUpdateFlagFromDom(allFormDataDom, "3"); 
					System.out.println("domIdLL=="+domIdL);
					valueXmlString.append("<Detail3 domID='"+domIdL+"' selected=\"Y\">\r\n");
					valueXmlString.append("<attribute selected=\"Y\" updateFlag=\"A\" status=\"O\" pkNames=\"\" />\r\n");
					valueXmlString.append( "<loc_code><![CDATA[]]></loc_code>\r\n" );
					//valueXmlString.append( "<ptcn><![CDATA[]]></ptcn>\r\n" );
					valueXmlString.append("</Detail3>\r\n");
				}
				if( currentColumn.trim().equalsIgnoreCase( "loc_code" ) )
				{	
					System.out.println("item change loc_code.............");
					String locCodeL = checkNull(genericUtility.getColumnValue( "loc_code", allFormDataDom ));
					String domId = getDomID(allFormDataDom,locCodeL);
					System.out.println("domId----------------->>"+domId);		
					System.out.println("locCodeL----------------->>"+locCodeL);	
					
					valueXmlString.append("<Detail3 domID='"+domId+"' selected=\"Y\">\r\n");
					valueXmlString.append("<attribute selected=\"Y\" updateFlag=\"A\" status=\"O\" pkNames=\"\" />\r\n"); 
					valueXmlString.append( "<loc_code><![CDATA[" ).append( locCodeL ).append( "]]></loc_code>\r\n" );
					//valueXmlString.append( "<ptcn><![CDATA[" ).append( "PTCN0001" ).append( "]]></ptcn>\r\n" );	
					valueXmlString.append("</Detail3>\r\n");
				}
				

			} //Case 3. End
			break;
			case 4:
			{
				System.out.println("item change case 4...................");
				System.out.println("hdrDataDom PTCN------->>["+genericUtility.serializeDom(hdrDataDom)+"]");	
				System.out.println("currFormDataDom PTCN------>>["+genericUtility.serializeDom(currFormDataDom)+"]");
				System.out.println("allFormDataDom PTCN------>>["+genericUtility.serializeDom(allFormDataDom)+"]");
				pickOrder =  checkNullAndTrim(genericUtility.getColumnValue( "pick_order", hdrDataDom ));
				ptcn =  checkNullAndTrim(genericUtility.getColumnValue( "ptcn", hdrDataDom ));
				String tranIDL = checkNullAndTrim(genericUtility.getColumnValue( "tran_id", allFormDataDom,"2"));				
				System.out.println("pickOrder------------->>["+pickOrder+"]  tranIDL---->>["+tranIDL+"]");		
				locCodeList = getLocationCode(allFormDataDom,tranIDL, conn);
				System.out.println("locCodeList------>>["+locCodeList+"]");
				System.out.println("ptcn@@@------>>["+ptcn+"]");
				String mark = "";
				String quantityDefault = "1";
				StringBuffer sqlBuf = new StringBuffer();
				currentColumn = currentColumn == null ? "" :currentColumn.trim();
				System.out.println("currentColumn------>>["+currentColumn+"]");
				if( currentColumn.trim().equalsIgnoreCase( "itm_default" ) )
				{
					double pendNoArt = 0d,noArtPickIss = 0d;
					int pstmtCnt = 0,incrCnt = 0;
					domID = 0;
					String lineOrdStr = "";
					System.out.println("item change itm_default.............");
					
					/*if(tranIDL.length() > 0)
					{
						sqlBuf = sqlBuf.append("SELECT DET.LINE_NO,DET.LOC_CODE,DET.ITEM_CODE,DET.QUANTITY,DET.NO_ART,"
								+ "DET.LOT_NO,DET.PACK_CODE,DET.LOC_CODE__TO,DET.CARTON_NO,ITEM.DESCR ITEM_DESCR "
								+ "FROM PICK_ISS_DET DET,ITEM ITEM WHERE DET.TRAN_ID = ? AND  "
								+ "ITEM.ITEM_CODE = DET.ITEM_CODE ORDER BY LINE_NO ");
						pstmt = conn.prepareStatement(sqlBuf.toString());
						pstmt.setString(1,tranIDL);
						rs = pstmt.executeQuery();
								
					}	*/				
					
					sql = "SELECT H.TRAN_ID FROM PICK_ISS_HDR H,PICK_ISS_DET D WHERE H.PICK_ORDER = D.PICK_ORDER "
							+ "AND  H.PICK_ORDER = ? AND  H.PTCN = ? ";
							
					pstmt = conn.prepareStatement( sql );
					pstmt.setString( 1, pickOrder );
					pstmt.setString( 2, ptcn );
					rs = pstmt.executeQuery();

					if ( rs.next() )
					{
						tranIDL = checkNull(rs.getString(1));
					}
					rs.close(); rs = null;
					pstmt.close(); pstmt = null;
					System.out.println("tranIDL------>>["+tranIDL+"]");
					if ( tranIDL.trim().length() > 0 )
					{
										
						int issQty = 0;
						int noOfArt = 0;
						String caseLabel ="",locCodeSys ="";
						
						sql = "SELECT MAX(LINE_NO)  FROM PICK_ISS_DET WHERE TRAN_ID = ?";
					
						pstmt = conn.prepareStatement( sql );
						pstmt.setString( 1, tranIDL );
						rs = pstmt.executeQuery();
	
						if ( rs.next() )
						{
							domID = rs.getInt(1);
						}
						rs.close(); rs = null;
						pstmt.close(); pstmt = null;
						
						sql = " SELECT P.LINE_NO, P.PICK_ORDER, P.LINE_NO__ORD,P.NO_ART, P.LOC_CODE, P.LOT_NO,I.DESCR, "
								+" P.SITE_CODE,P.ITEM_CODE, P.LOT_SL, P.CASE_LABEL, P.LOC_CODE__TO, P.LOC_CODE__SYS, P.CARTON_NO, "
								+" (P.QUANTITY - (CASE WHEN P.DEALLOC_QTY IS NULL THEN 0 ELSE P.DEALLOC_QTY END )) AS QUANTITY,P.PACK_CODE "
								+" FROM PICK_ISS_DET P , ITEM I WHERE P.TRAN_ID = ? AND P.PICK_ORDER = ? "
								+" AND (P.QUANTITY - (CASE WHEN P.DEALLOC_QTY IS NULL THEN 0 ELSE P.DEALLOC_QTY END )) > 0  AND I.ITEM_CODE = P.ITEM_CODE"
								+" ORDER BY P.TRAN_ID, P.LINE_NO ";
						pstmtIss = conn.prepareStatement( sql );
						
						pstmtIss.setString( 1, tranIDL );
						pstmtIss.setString( 2, pickOrder );
						rsIss = pstmtIss.executeQuery();
						while ( rsIss.next() )
						{
							/*lotNo = checkNullAndTrim(rsIss.getString("LOT_NO"));
							lpnNo = checkNullAndTrim(rsIss.getString("LOT_SL"));*/
							
							//Changed by Manish for getting the null value in pick_iss_det[start]
							lotNo = rsIss.getString("LOT_NO");
							lpnNo = rsIss.getString("LOT_SL");
							//Changed by Manish for getting the null value in pick_iss_det[end]
							
							locCode = checkNullAndTrim(rsIss.getString("LOC_CODE"));
							caseLabel = checkNull(rsIss.getString("CASE_LABEL"));
							locCodeTo = checkNullAndTrim(rsIss.getString("LOC_CODE__TO"));
							locCodeSys = checkNull(rsIss.getString("LOC_CODE__SYS"));
							cartonNo = checkNull(rsIss.getString("CARTON_NO"));
							lineNoIss = rsIss.getInt("LINE_NO");
							issQty = rsIss.getInt("QUANTITY");
							noOfArt = rsIss.getInt("NO_ART");
							actPackCode = checkNull(rsIss.getString("PACK_CODE"));
							valueXmlString.append( "<Detail4 domID='"+ lineNoIss +"' objContext = '"+currentFormNo+"' objName='"+objName+"' selected=\"Y\">\r\n" );
						
							valueXmlString.append("<attribute selected=\"Y\" updateFlag=\"E\" status=\"O\" pkNames=\"\" />\r\n"); 

							valueXmlString.append( "<tran_id><![CDATA[" ).append( tranID ).append( "]]></tran_id>\r\n" );
							valueXmlString.append( "<line_no><![CDATA[" ).append( lineNoIss ).append( "]]></line_no>\r\n" );
							valueXmlString.append( "<pick_order><![CDATA[" ).append( pickOrder ).append( "]]></pick_order>\r\n" );
							valueXmlString.append( "<line_no__ord><![CDATA[" ).append( checkNullAndTrim(rsIss.getString("LINE_NO__ORD")) ).append( "]]></line_no__ord>\r\n" );
							valueXmlString.append( "<item_code><![CDATA[" ).append( checkNullAndTrim(rsIss.getString("ITEM_CODE")) ).append( "]]></item_code>\r\n" );
							valueXmlString.append( "<item_descr><![CDATA[" ).append(  checkNullAndTrim(rsIss.getString("DESCR") ) ).append( "]]></item_descr>\r\n" );
							valueXmlString.append( "<site_code><![CDATA[" ).append( checkNullAndTrim(rsIss.getString("SITE_CODE") )).append( "]]></site_code>\r\n" );
							valueXmlString.append( "<loc_code><![CDATA[" ).append( locCode ).append( "]]></loc_code>\r\n" );
							valueXmlString.append( "<lot_no><![CDATA[" ).append( lotNo ).append( "]]></lot_no>\r\n" );
							valueXmlString.append( "<lot_sl><![CDATA[" ).append( lpnNo ).append( "]]></lot_sl>\r\n" );
							valueXmlString.append( "<quantity><![CDATA[" ).append( issQty).append( "]]></quantity>\r\n" );
							valueXmlString.append( "<unit><![CDATA[" ).append( unit).append( "]]></unit>\r\n" );
							valueXmlString.append( "<no_art><![CDATA[" ).append( "1" ).append( "]]></no_art>\r\n" );
							valueXmlString.append( "<loc_code__sys><![CDATA[" ).append( locCodeTo ).append( "]]></loc_code__sys>\r\n" );
							valueXmlString.append( "<loc_code__to><![CDATA[" ).append( locCodeTo ).append( "]]></loc_code__to>\r\n" );
							valueXmlString.append( "<user_id><![CDATA[" ).append(userId).append( "]]></user_id>\r\n" );
							valueXmlString.append("<carton_no><![CDATA[").append(cartonNo).append("]]></carton_no>\r\n");
							valueXmlString.append("<pack_code><![CDATA[").append(actPackCode).append("]]></pack_code>\r\n");
							valueXmlString.append("</Detail4>\r\n");
							lotNo = ""; lpnNo = ""; locCode = ""; locCodeTo = ""; locCodeSys = ""; cartonNo = ""; issQty = 0;
						}
						
						if(rsIss != null)
						{
							rsIss.close();
							rsIss = null;
						}
						
						if(pstmtIss != null)
						{
							pstmtIss.close();
							pstmtIss = null;
						}
						
						
					}
					
					

					
				
					if(locCodeList.size() > 0)// && tranIDL.length() == 0 )
					{
						/*sqlBuf = sqlBuf.append("SELECT PODET.LOC_CODE,PODET.PICK_ORDER,PODET.LINE_NO,PODET.ITEM_CODE,PODET.SITE_CODE,PODET.LOC_CODE,"+
								" PODET.LOT_NO, PODET.LOT_SL, PODET.NO_ART, (PODET.QUANTITY - (CASE WHEN PODET.DEALLOC_QTY IS NULL THEN 0 ELSE PODET.DEALLOC_QTY END )) AS QUANTITY ,"
								+ "PODET.CARTON_NO,PODET.PACK_CODE , ITEM.DESCR ITEM_DESCR, ITEM.UNIT UNIT, LOC_CODE__TO "+
								" FROM PICK_ORD_DET PODET, ITEM ITEM WHERE PODET.PICK_ORDER = ? AND PODET.ITEM_CODE = ITEM.ITEM_CODE "+
								//" AND PODET.LINE_NO NOT IN (SELECT PICK_ISS_DET.LINE_NO__ORD FROM PICK_ISS_DET WHERE PICK_ISS_DET.PICK_ORDER =  ? ) "+
								" AND (PODET.QUANTITY - (CASE WHEN PODET.DEALLOC_QTY IS NULL THEN 0 ELSE PODET.DEALLOC_QTY END )) > 0 "+
								" AND PODET.LOC_CODE  IN (");*/
								
								
						
						sqlBuf = sqlBuf.append( " SELECT PODET.LOC_CODE,PODET.PICK_ORDER,PODET.LINE_NO,PODET.ITEM_CODE,PODET.SITE_CODE,PODET.LOC_CODE, "
								+" PODET.LOT_NO, PODET.LOT_SL, PODET.NO_ART, (SELECT CASE WHEN SUM(QUANTITY) IS NULL THEN 0 ELSE SUM(QUANTITY) " 
								+" END FROM PICK_ISS_DET WHERE PICK_ORDER =PODET.PICK_ORDER AND LINE_NO__ORD = PODET.LINE_NO) AS REST_QTY,"
								+" (PODET.QUANTITY - ((CASE WHEN PODET.DEALLOC_QTY IS NULL THEN 0 ELSE PODET.DEALLOC_QTY END )"
								+" ) - (SELECT CASE WHEN SUM(QUANTITY - (CASE WHEN DEALLOC_QTY IS NULL THEN 0 ELSE DEALLOC_QTY END ))" 
								+" IS NULL THEN 0 ELSE SUM(QUANTITY -(CASE WHEN DEALLOC_QTY IS NULL THEN 0 ELSE DEALLOC_QTY END ))" 
								+" END FROM PICK_ISS_DET WHERE PICK_ORDER =PODET.PICK_ORDER AND LINE_NO__ORD = PODET.LINE_NO) ) AS QUANTITY ,"
								+" PODET.CARTON_NO,PODET.PACK_CODE ,ITEM.DESCR ITEM_DESCR, ITEM.UNIT UNIT, LOC_CODE__TO  FROM PICK_ORD_DET PODET,"
								+" ITEM ITEM WHERE PODET.PICK_ORDER = ? AND PODET.ITEM_CODE = ITEM.ITEM_CODE  AND" 
								+" (PODET.QUANTITY - (CASE WHEN PODET.DEALLOC_QTY IS NULL THEN 0 ELSE PODET.DEALLOC_QTY END )) > 0"  
								+" AND PODET.LOC_CODE  IN (");
						
						
						for(int i = 0; i < locCodeList.size(); i++)
						{
							mark = mark + "?,";
						}
						mark = mark.substring(0,mark.length() - 1);
						sqlBuf.append(mark);	
						sqlBuf.append(") ORDER BY PODET.LOC_CODE");
						pstmt = conn.prepareStatement(sqlBuf.toString());
						pstmt.setString(++pstmtCnt, pickOrder );
						//pstmt.setString(++pstmtCnt , pickOrder );
						System.out.println("pstmtCnt----------->>"+pstmtCnt);
						
						for (String list : locCodeList)
						{						
							pstmt.setString(++pstmtCnt,list);	
						}
						System.out.println("sqlBuf.toString()----------->>"+sqlBuf.toString());						
						rs = pstmt.executeQuery();
					
						while(rs.next())
						{							
							pendNoArt = 0d;
							noArtPickIss = 0d;
							lineNoOrd = rs.getInt("LINE_NO");
							locCode = checkNullAndTrim(rs.getString("LOC_CODE"));
							itemCode = checkNullAndTrim(rs.getString("ITEM_CODE"));
							itemDescr = checkNull(rs.getString("ITEM_DESCR"));
							siteCode = checkNullAndTrim(rs.getString("SITE_CODE"));
							quantity = rs.getDouble("QUANTITY"); 
							unit = rs.getString("UNIT");
							noArt = rs.getDouble("NO_ART"); 

							lotNo = rs.getString("LOT_NO");
							lpnNo = rs.getString("LOT_SL");//CHANGED @@
							itmVolumeMap.clear();
							itmVolumeMap = getItemVoumeMap(itemCode,lotNo,conn);
							shipperSize = (Double) itmVolumeMap.get("SHIPPER_SIZE");


							locCodeTo = rs.getString("LOC_CODE__TO");
							actCartonNo = checkNull(rs.getString("CARTON_NO"));
							actPackCode = checkNull(rs.getString("PACK_CODE"));				


							lineOrdStr = ""+lineNoOrd;
							
							//int rowCntPickIss = getRecordsInPickIssDet(pickOrder,itemCode,tranIDL,conn);
							//System.out.println("rowCntPickIss----------->>"+rowCntPickIss);
							//valueXmlString.append( "<Detail4 domID='"+ domID +"' objContext = '"+currentFormNo+"' objName='"+objName+"' selected=\"N\">\r\n" );
							//valueXmlString.append("<attribute selected=\"N\" updateFlag=\"A\" status=\"N\" pkNames=\"\" />\r\n");
							if(quantity <= 0)
							{
								continue;
							}
							
							for(int i = 1; i <= quantity ; i++)
							{
								domID++;
								/*if(rowCntPickIss >= i)
								{
									valueXmlString.append("<Detail4 domID='"+domID+"' selected=\"Y\">\r\n");
									valueXmlString.append("<attribute selected=\"Y\" updateFlag=\"E\" status=\"O\" pkNames=\"\" />\r\n");
								}
								else
								{
									valueXmlString.append("<Detail4 domID='"+domID+"' selected=\"N\">\r\n");
									valueXmlString.append("<attribute selected=\"N\" updateFlag=\"A\" status=\"N\" pkNames=\"\" />\r\n");
								}*/
								
								valueXmlString.append("<Detail4 domID='"+domID+"' selected=\"N\">\r\n");
								valueXmlString.append("<attribute selected=\"N\" updateFlag=\"A\" status=\"N\" pkNames=\"\" />\r\n");
								valueXmlString.append( "<tran_id><![CDATA[" ).append( tranIDL ).append( "]]></tran_id>\r\n" );
								valueXmlString.append( "<line_no><![CDATA[" ).append( domID ).append( "]]></line_no>\r\n" );
								valueXmlString.append( "<pick_order><![CDATA[" ).append( pickOrder ).append( "]]></pick_order>\r\n" );
								valueXmlString.append( "<line_no__ord><![CDATA[" ).append( lineNoOrd ).append( "]]></line_no__ord>\r\n" );
								valueXmlString.append( "<item_code><![CDATA[" ).append( itemCode ).append( "]]></item_code>\r\n" );
								valueXmlString.append( "<item_descr><![CDATA[" ).append( itemDescr ).append( "]]></item_descr>\r\n" );
								valueXmlString.append( "<site_code><![CDATA[" ).append( siteCode ).append( "]]></site_code>\r\n" );
								valueXmlString.append( "<loc_code><![CDATA[" ).append( locCode ).append( "]]></loc_code>\r\n" );
								valueXmlString.append( "<lot_no><![CDATA[" ).append( lotNo ).append( "]]></lot_no>\r\n" );
								valueXmlString.append( "<lot_sl><![CDATA[" ).append( lpnNo ).append( "]]></lot_sl>\r\n" );
								valueXmlString.append( "<unit><![CDATA[" ).append( unit).append( "]]></unit>\r\n" );
								valueXmlString.append( "<loc_code__sys><![CDATA[" ).append( locCodeTo ).append( "]]></loc_code__sys>\r\n" );
								valueXmlString.append( "<loc_code__to><![CDATA[" ).append( locCodeTo ).append( "]]></loc_code__to>\r\n" );
								if (!"A".equalsIgnoreCase(pickType.trim()))
								{
									valueXmlString.append( "<quantity><![CDATA[" ).append( quantityDefault).append( "]]></quantity>\r\n" );
									valueXmlString.append( "<no_art><![CDATA[" ).append( noArt ).append( "]]></no_art>\r\n" );	

								}
								else //if ("C".equalsIgnoreCase(pickType.trim()))
								{
									valueXmlString.append( "<no_art><![CDATA[1]]></no_art>\r\n" );	
									valueXmlString.append( "<quantity><![CDATA[" + quantityDefault + "]]></quantity>\r\n" );
								}

								if ("A".equalsIgnoreCase(pickType.trim()))
								{
									valueXmlString.append("<carton_no><![CDATA[").append(actCartonNo).append("]]></carton_no>\r\n");
									valueXmlString.append("<pack_code><![CDATA[").append(actPackCode).append("]]></pack_code>\r\n");
								}
								valueXmlString.append( "<case_label><![CDATA[" ).append( "" ).append( "]]></case_label>\r\n" );
								valueXmlString.append("</Detail4>\r\n");


							} //end for
					} //end while
					
					}
				}
			}//Case 4. End
			
			}//End of switch block
			valueXmlString.append( "</Root>\r\n" );	
		}
		catch (Exception e)
		{				
			e.printStackTrace();			
			valueXmlString = valueXmlString.append( generateErrorString( genericUtility.createErrorString( e ) ) );
		}
		finally
		{	
			try
			{
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if ( rsOrd != null )
				{
					rsOrd.close();
					rsOrd = null;
				}
				if ( rsIss != null )
				{
					rsIss.close();
					rsIss = null;
				}
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				if ( pstmtOrd != null )
				{
					pstmtOrd.close();
					pstmtOrd = null;
				}
				if ( pstmtIss != null )
				{
					pstmtIss.close();
					pstmtIss = null;
				}
				if ( conn != null )
				{
					conn.close();
					conn = null;
				}
			}
			catch (Exception e)
			{
				e.printStackTrace();
				throw new ITMException(e);
			}
		}
		System.out.println( "valueXmlString.toString()>>>>>>>::"+valueXmlString.toString());
		return valueXmlString.toString();
	}

	/**
	 * The function checks whether the input string is null. 
	 * If null, the function returns blank string.  
	 * @param input
	 */
	private String checkNull( String input )	
	{
		if ( input == null )
		{
			input = "";
		}
		return input;
	}
	/**
	 * The function checks whether the input string is null. 
	 * If null, the function returns blank string otherwise trim the input string and return.  
	 * @param input
	 */
	private String checkNullAndTrim( String inputVal )
	{
		if ( inputVal == null )
		{
			inputVal = "";
		}
		else
		{
			inputVal = inputVal.trim();
		}
		return inputVal;
	}
	
	private String getSelectedLocCode(Document dom,String pickOrder,String siteCode,Connection conn) throws ITMException,Exception
	{
		String xmlString = "",locCodeL = "",sql = "",domId1 = "",locCodeL1 = "";
		int lineNo = 0,totalNodeLength = 0;
		NodeList parentNodeList = null;
		NodeList childNodeList = null;
		Node parentNode = null;
		Node childNode = null;
		int childNodeListLength ,rowCnt = 0,domId = 0;
		String childNodeName = null;
		StringBuffer valueXmlString = new StringBuffer();
		boolean isLocCode = false;
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		try
		{
			System.out.println("in getSelectedLocCode mehotd------->>["+pickOrder+"]");			
			sql = "SELECT DISTINCT (LOC_CODE) FROM PICK_ISS_DET WHERE PICK_ORDER = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, pickOrder);
			rs = pstmt.executeQuery();
			while(rs.next())
			{
				rowCnt = 1;
				domId++;
				locCodeL = rs.getString(1);
				locCodeL = locCodeL == null ? "" : locCodeL.trim();
				/*if(isLocationExist(pickOrder, locCodeL, siteCode, conn))
				{
					valueXmlString.append("<Detail3 domID='"+domId+"' selected=\"Y\">\r\n");
					valueXmlString.append("<attribute selected=\"Y\" updateFlag=\"E\" status=\"O\" pkNames=\"\" />\r\n");
				}
				else
				{
					valueXmlString.append("<Detail3 domID='"+domId+"' selected=\"N\">\r\n");
					valueXmlString.append("<attribute selected=\"N\" updateFlag=\"A\" status=\"N\" pkNames=\"\" />\r\n");
					
				}	*/	
				valueXmlString.append("<Detail3 domID='"+domId+"' selected=\"Y\">\r\n");
				valueXmlString.append("<attribute selected=\"Y\" updateFlag=\"E\" status=\"O\" pkNames=\"\" />\r\n");
				valueXmlString.append( "<loc_code><![CDATA["+locCodeL+"]]></loc_code>\r\n" );
				valueXmlString.append("</Detail3>");
			}
			if(rs!=null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
			
			if(dom != null && rowCnt == 0)
			{	
				
				NodeList list = dom.getElementsByTagName("Detail3");	
			
				totalNodeLength = list.getLength();
				System.out.println("totalNodeLength----->>"+totalNodeLength);				
				for (int ctr = 0; ctr < list.getLength() ; ctr++)
				{
					childNode = list.item(ctr);			
					childNodeName = childNode.getNodeName();
					System.out.println("Child name --->> "+childNodeName);	

					if (childNode.getNodeType() == Node.ELEMENT_NODE)
					{
						Element eElement = (Element) childNode;								
						domId1 =  list.item(0).getAttributes().getNamedItem("domID").getNodeValue();
						System.out.println("domId1 --->> "+domId1);	
						valueXmlString.append("<Detail3 domID='"+domId1+"' selected=\"Y\">\r\n");
						valueXmlString.append("<attribute selected=\"Y\" updateFlag=\"E\" status=\"O\" pkNames=\"\" />\r\n");
						locCodeL1 =  eElement.getElementsByTagName("loc_code").item(0).getTextContent();		
						locCodeL1 = locCodeL1 == null? "" : locCodeL1.trim();
						System.out.println("ctr --->> "+ctr);	
						System.out.println("locCodeL1 --->> "+locCodeL1);	
						if(locCodeL1.length() > 0)
						{
							isLocCode = true;
						}
						if(locCodeL.length() == 0 && !isLocCode)
						{
							return "";
						}
						valueXmlString.append( "<loc_code><![CDATA["+locCodeL+"]]></loc_code>\r\n" );
						valueXmlString.append("</Detail3>");
						
					}
				
				
				}
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			if(rs!=null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
		}
		
		System.out.println("Return string getSelectedLocCode--->>["+valueXmlString.toString()+"]");
		return valueXmlString.toString();
	}
	private boolean isLocationExist(String pickOrder,String locCode,String siteCode,Connection conn)throws ITMException
	{
		boolean isExist = false;
		String sql = "";
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		int count = 0;
		try
		{
			pickOrder = pickOrder == null ? "" :pickOrder.trim();
			siteCode = siteCode == null ? "" :siteCode.trim();
			locCode = locCode == null ? "" :locCode.trim();
			sql = "SELECT COUNT(*) FROM PICK_ISS_DET WHERE PICK_ORDER = ? AND LOC_CODE = ? AND SITE_CODE = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,pickOrder);
			pstmt.setString(2,locCode);
			pstmt.setString(3,siteCode);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				count = rs.getInt(1);
			}
			System.out.println("isLocationExist count-------->>"+count);
			
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
			
			if(count > 0)
			{
				return true;
			}			
		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		return false;
	}
	private String getDomID(Document dom,String locCode) throws ITMException
	{
		String locCodeL = "",domId = "";
		int lineNo = 0,totalNodeLength = 0;
		NodeList parentNodeList = null;
		NodeList childNodeList = null;
		Node parentNode = null;
		Node childNode = null;
		int childNodeListLength;
		String childNodeName = null;
		try
		{
			if(dom != null)
			{
				NodeList list = dom.getElementsByTagName("Detail3");
				//Document dom3 = (Document) list;
				totalNodeLength = list.getLength();
				for (int ctr = 0; ctr < list.getLength() ; ctr++)
				{
					childNode = list.item(ctr);			
					childNodeName = childNode.getNodeName();
					System.out.println("Child name --->> "+childNodeName);	

					if (childNode.getNodeType() == Node.ELEMENT_NODE)
					{
						Element eElement = (Element) childNode;					
						locCodeL =  eElement.getElementsByTagName("loc_code").item(0).getTextContent();
						//String ptcn1 =  eElement.getElementsByTagName("wave_id").item(0).getTextContent();						
						System.out.println("ctr --->> "+ctr);	
						System.out.println("locCodeL --->> "+locCodeL);	
						if(locCodeL.equalsIgnoreCase(locCode))							
						{
							domId =  list.item(0).getAttributes().getNamedItem("domID").getNodeValue();
							
						}
						
					}
				
				}
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		System.out.println("domId --->>["+domId+"]");		
		return domId;
	}
	private int getRecordsInPickIssDet(String pickOrderL,String itemCode,String tranId,Connection conn) throws ITMException,Exception
	{
		System.out.println("----------in getRecordsInPickIssDet------------");		
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		String sql = "";
		int count = 0;
		pickOrderL =pickOrderL ==null ?"":pickOrderL.trim();
		tranId =tranId ==null ?"":tranId.trim();
		try
		{		
			if(tranId.length() == 0)
			{
				sql = "SELECT COUNT(*) FROM PICK_ISS_DET WHERE PICK_ORDER = ? AND item_code = ?";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, pickOrderL);					
				pstmt.setString(2, itemCode);	
			}
			else
			{
				sql = "SELECT COUNT(*) FROM PICK_ISS_DET WHERE TRAN_ID = ? AND item_code = ?";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, tranId);					
				pstmt.setString(2, itemCode);
			}		
			
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				count = rs.getInt(1);
			}
			System.out.println("PICK_ISS_DET count------->>"+count);
		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			if(rs!=null)
			{
				rs.close();
				rs = null;				
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;				
			}
		}
		return count;
	}
	private String getSiteCode( String xtraParams, Connection conn ) throws ITMException
	{
		String defaultSite = "";
		String empSite = "";
		String workSite = "";
		String sql = "";
		String loginCode = "";

		PreparedStatement pstmt = null;
		ResultSet rs = null;

		try
		{
			E12GenericUtility genericUtility = new E12GenericUtility();
			loginCode = checkNull(genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginCode" ));

			sql = "SELECT USERS.EMP_CODE, USERS.ENTITY_CODE, USERS.SITE_CODE__DEF, EMP.EMP_SITE, EMP.WORK_SITE "+
					"FROM USERS USERS, EMPLOYEE EMP WHERE USERS.EMP_CODE = EMP.EMP_CODE AND USERS.CODE = ? ";
			pstmt = conn.prepareStatement( sql );
			pstmt.setString( 1, loginCode );						
			rs = pstmt.executeQuery();	
			if( rs.next() )
			{
				defaultSite = checkNull(rs.getString("SITE_CODE__DEF"));
				empSite = checkNull(rs.getString("EMP_SITE"));
				workSite = checkNull(rs.getString("WORK_SITE"));
			}
			if ( defaultSite.trim().length() == 0 && empSite.trim().length() > 0 )
			{
				defaultSite = empSite;
			}
			rs.close();rs = null;
			pstmt.close();pstmt = null;
		}
		catch (Exception e)
		{				
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{	
			try
			{
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch (Exception e)
			{
				e.printStackTrace();
				throw new ITMException(e);
			}
		}
		System.out.println("defaultSite = ["+defaultSite+"]");
		return defaultSite;
	}	
	private String getObjNameFromDom( Document dom, String attribute, String objContext ) throws RemoteException,ITMException
	{
		NodeList detailList = null;
		Node currDetail = null,reqDetail = null;
		String objName = "";
		int	detailListLength = 0;

		try
		{
			detailList = dom.getElementsByTagName("Detail"+objContext);
			detailListLength = detailList.getLength();
			for (int ctr = 0; ctr < detailListLength; ctr++)
			{
				currDetail = detailList.item(ctr);
				objName = currDetail.getAttributes().getNamedItem(attribute).getNodeValue();
			}
		}
		catch ( Exception e )
		{
			throw new ITMException(e);
		}
		return objName;
	}
	
	public String generateErrorString( String errorString )
	{
		return ("<Errors><error id = \"xxxx\" type=\"E\">" + errorString.substring(errorString.indexOf("<message>") , errorString.indexOf("</description>") + "</description>".length()) + "<redirect>1</redirect><type>E</type></error></Errors>");
	}	
	private String setSelectedToDom( Document allFormDataDom, String detailString, ArrayList issDetSelList ) throws Exception
	{
		ArrayList selectedList = new ArrayList();
		NodeList detailList = null;
		Node currDetail = null;
		NodeList currDetailList = null;
		String selectedVal = "", nodeName = "", updateStatus = "";
		String domIDVal = "";
		String updatedDetailDomStr = "";
		String attributeVal = "";
		String caseLabel = "";
		String locCodeTo = "";
		String cartonNo = "";
		String columnValue = "";

		HashMap toUpdateMap = new HashMap();

		Node elementName = null;

		int currDetailListLength = 0;
		int	detailListLength = 0;

		int selectedValCnt = 0;

		E12GenericUtility genericUtility = new E12GenericUtility();

		try
		{
			detailList = allFormDataDom.getElementsByTagName("Detail3");
			detailListLength = detailList.getLength();
			for ( int ctr = 0; ctr < detailListLength; ctr++ )
			{
				currDetail = detailList.item(ctr);
				currDetailList = currDetail.getChildNodes();
				currDetailListLength = currDetailList.getLength();

				attributeVal = "";
				columnValue = "";

				ArrayList toUpdNodeList = new ArrayList();
				HashMap dataMap = new HashMap();

				for ( int i=0; i< currDetailListLength; i++ )
				{
					Node childNode = currDetailList.item(i);
					nodeName = childNode.getNodeName();
					if (nodeName.equalsIgnoreCase("Attribute"))
					{
						attributeVal = checkNull(currDetailList.item(i).getAttributes().getNamedItem("selected").getNodeValue());
						System.out.println("attributeVal =["+attributeVal+"]");
					}//if (nodeName = Attribute
					else if (nodeName.equalsIgnoreCase("case_label"))
					{
						if ( childNode != null && childNode.getFirstChild() != null )
						{
							caseLabel = childNode.getFirstChild().getNodeValue();
							//toUpdNodeList.add( 0, childNode );
							dataMap.put("case_label", childNode);
						}
					}
					else if (nodeName.equalsIgnoreCase("loc_code__to"))
					{
						if ( childNode != null && childNode.getFirstChild() != null )
						{
							locCodeTo = childNode.getFirstChild().getNodeValue();
							//toUpdNodeList.add( 1, childNode );
							dataMap.put("loc_code__to", childNode);
						}
					}
					else if (nodeName.equalsIgnoreCase("carton_no"))
					{
						if ( childNode != null && childNode.getFirstChild() != null )
						{
							cartonNo = childNode.getFirstChild().getNodeValue();
							//toUpdNodeList.add( 2, childNode );
							dataMap.put("carton_no", childNode);
						}
					}
				}//End of inner for loop
				if ( "Y".equalsIgnoreCase(attributeVal.trim()) )
				{
					if ( currDetail.getAttributes().getNamedItem( "domID" ) != null )
					{
						domIDVal = checkNull(currDetail.getAttributes().getNamedItem( "domID" ).getNodeValue());
						System.out.println("domIDVal =["+domIDVal+"]");
					}
					toUpdateMap.put( domIDVal, dataMap );
				}
			}//End of for loop

			System.out.println("toUpdateMap:>>>>>>>>>>>: "+toUpdateMap);

			detailList = null;

			detailString = detailString + "</Root>\r\n" ;	
			System.out.println("detailString:>>>>>>>>>>> "+detailString);
			Document detailDom = genericUtility.parseString(detailString); 

			Element elementAttr = null;

			detailList = detailDom.getElementsByTagName("Detail3");
			detailListLength = detailList.getLength();
			for ( int ctr = 0; ctr < detailListLength; ctr++ )
			{
				currDetail = detailList.item(ctr);

				if ( currDetail.getAttributes().getNamedItem( "selected" ) != null )
				{
					selectedVal = checkNull(currDetail.getAttributes().getNamedItem( "selected" ).getNodeValue());
					System.out.println("selectedVal =["+selectedVal+"]");
					if ( "N".equalsIgnoreCase(selectedVal.trim()) )
					{
						if ( currDetail.getAttributes().getNamedItem( "domID" ) != null )
						{
							//ArrayList aList = null;

							HashMap dataMap = new HashMap();

							domIDVal = checkNull(currDetail.getAttributes().getNamedItem( "domID" ).getNodeValue());
							System.out.println("domIDVal =["+domIDVal+"]");
							System.out.println("toUpdateMap.containsKey(domIDVal) =["+toUpdateMap.containsKey(domIDVal)+"]");
							if ( toUpdateMap.containsKey(domIDVal) )
							{
								elementAttr = (Element)currDetail;
								elementAttr.setAttribute( "selected" , "Y" );

								Node caseLabelNode = null;
								Node locCodeToNode = null;
								Node cartonNoNode = null;

								dataMap = (HashMap)toUpdateMap.get(domIDVal);

								if ( dataMap.get("case_label") != null )
								{
									caseLabelNode = (Node)dataMap.get("case_label");
								}
								if ( dataMap.get("loc_code__to") != null )
								{
									locCodeToNode = (Node)dataMap.get("loc_code__to");
								}
								if ( dataMap.get("carton_no") != null )
								{
									cartonNoNode = (Node)dataMap.get("carton_no");
								}

								Node updatedNode = null;

								currDetailList = currDetail.getChildNodes();
								currDetailListLength = currDetailList.getLength();

								for ( int i = 0; i < currDetailListLength; i++ )
								{
									elementName = currDetailList.item(i);
									nodeName = elementName.getNodeName();
									if( elementName.getNodeType() != Node.ELEMENT_NODE || nodeName.equalsIgnoreCase("#text") )
									{
										continue;
									}
									System.out.println("nodeName =["+nodeName+"]");
									if (nodeName.equalsIgnoreCase("case_label"))
									{
										if(caseLabelNode != null)
										{
											//System.out.println("caseLabelNode =["+genericUtility.serializeDom( caseLabelNode )+"]");
											updatedNode = detailDom.importNode(caseLabelNode, true);
											//System.out.println("updatedNode =["+genericUtility.serializeDom( updatedNode )+"]");
											(detailDom.getElementsByTagName("Detail3").item(ctr)).replaceChild(updatedNode, elementName );
										}
										else
										{
											System.out.println("On Next Previous case label node null");
										}
									}
									else if ( nodeName.equalsIgnoreCase("loc_code__to") )
									{
										if(locCodeToNode != null)
										{
											//System.out.println("LocCodeToNode =["+genericUtility.serializeDom( LocCodeToNode )+"]");
											updatedNode = detailDom.importNode(locCodeToNode, true);
											//System.out.println("updatedNode =["+genericUtility.serializeDom( updatedNode )+"]");
											(detailDom.getElementsByTagName("Detail3").item(ctr)).replaceChild(updatedNode, elementName );
										}
										else
										{
											System.out.println("On Next Previous location code null");
										}
									}
									else if ( nodeName.equalsIgnoreCase("carton_no") )
									{
										if(cartonNoNode != null)
										{
											//System.out.println("cartonNoNode =["+genericUtility.serializeDom( cartonNoNode )+"]");
											updatedNode = detailDom.importNode(cartonNoNode, true);
											//System.out.println("updatedNode =["+genericUtility.serializeDom( updatedNode )+"]");
											(detailDom.getElementsByTagName("Detail3").item(ctr)).replaceChild(updatedNode, elementName );
										}
										else
										{
											System.out.println("On Next Previous cartonNoNode code null");
										}
									}
								}//inner for loop
							}//if ( toUpdateMap.containsKey(domIDVal) )
						}//if ( currDetail.getAttributes().getNamedItem( "domID" )
					}//if ( "N".equalsIgnoreCase(selectedVal.trim()) )
				}//if ( currDetail.getAttributes().getNamedItem( "selected" )
			}//outer for loop
			updatedDetailDomStr = genericUtility.serializeDom( detailDom );
			System.out.println("updatedDetailDomStr:>>>>>>>>>>> "+updatedDetailDomStr);
		}
		catch (Exception e)
		{
			e.printStackTrace();
			throw e;
		}

		return updatedDetailDomStr;
	}
	public ArrayList<String> getLocationCode(Document dom,String tranId,Connection conn) throws ITMException,Exception
	{
		ArrayList<String> colVal = new ArrayList<String>();		
		NodeList parentNodeList = null;
		NodeList childNodeList = null;
		Node parentNode = null;
		Node childNode = null;
		int childNodeListLength = 0;
		String childNodeName = null,locCode = "",sql ="";
		E12GenericUtility genericUtility = new E12GenericUtility();
		String columnName = "";
		String columnValue = null;
		boolean continueLoop = true;
		boolean isFormNo = false;		
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		try
		{			
			System.out.println("tranId in detail3@@--------->>["+tranId+"]");			
			/*if(tranId.length() > 0)
			{
				sql = "SELECT DISTINCT (LOC_CODE) FROM PICK_ISS_DET WHERE TRAN_ID = ?";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, tranId);
				rs = pstmt.executeQuery();
				while(rs.next())
				{					 
					colVal.add(checkNull(rs.getString(1)));					 
				}
				if(rs!=null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt !=null)
				{
					pstmt.close();
					pstmt = null;
				}

			}*/
			if ( dom != null)
			{
				parentNodeList = dom.getElementsByTagName("Detail3");
				childNodeListLength = parentNodeList.getLength();
				System.out.println("childNodeListLength@----->>"+childNodeListLength);
				for (int ctr = 0; ctr < childNodeListLength; ctr++)
				{				
					childNode = parentNodeList.item(ctr);			
					childNodeName = childNode.getNodeName();
					System.out.println("Child name --->> "+childNodeName);	

					if (childNode.getNodeType() == Node.ELEMENT_NODE)
					{
						Element eElement = (Element) childNode;					
						locCode =  checkNull(eElement.getElementsByTagName("loc_code").item(0).getTextContent());											
						System.out.println("locCode----->"+locCode);					
						colVal.add(locCode);
					}
				}				

			}
			else
			{
				System.out.println("dom is null please check................");
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			if(rs!=null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt !=null)
			{
				pstmt.close();
				pstmt = null;
			}
		}
		return colVal;
	}
	
	private HashMap getItemVoumeMap(String itemCode,String lotNo,Connection con)throws Exception
	{
		double shipperSize = 0,itemVolume = 0,caseVolume = 0;
		PreparedStatement pstmt = null;
		String sql="";
		ResultSet rs = null;
		double itmLen = 0,itmWidth = 0,itmHeight = 0,itemGrossWeight = 0,lotLen = 0 ,lotHeight = 0,lotWidth = 0,caseGrossWeight = 0,itemNetWeight = 0, caseNetWeight = 0;
		HashMap dataVolumeMap = new HashMap();
		
		try {
			
			sql = "SELECT I.LENGTH ITEM_LEN,I.WIDTH ITEM_WID,I.HEIGHT ITEM_HEIGHT,I.GROSS_WEIGHT ITEM_GROSS_WEIGHT,I.NET_WEIGHT ITEM_NET_WEIGHT,"
				  +" L.LENGTH LITEM_LEN,L.WIDTH LITEM_WID,L.HEIGHT LITEM_HEIGHT,L.SHIPPER_SIZE SHIPSIZE,L.GROSS_WEIGHT CASE_GROSS_WEIGHT,L.NET_WEIGHT CASE_NET_WEIGHT FROM"
				  +" ITEM I,ITEM_LOT_PACKSIZE L"
				  +" WHERE I.ITEM_CODE = L.ITEM_CODE"
				  +" AND L.LOT_NO__FROM <= ? AND L.LOT_NO__TO >= ?"
				  +" AND  I.ITEM_CODE = ?";
				  
			
			pstmt = con.prepareStatement(sql);
			if(lotNo != null && lotNo.length() > 0)
			{
				pstmt.setString(1, lotNo);
				pstmt.setString(2, lotNo);
			}
			else
			{
				pstmt.setString(1, "00");
				pstmt.setString(2, "ZZ");
			}
			pstmt.setString(3, itemCode);
			rs = pstmt.executeQuery();
			
			if(rs.next())
			{
				itmLen = rs.getDouble("ITEM_LEN");
				itmWidth = rs.getDouble("ITEM_WID");
				itmHeight = rs.getDouble("ITEM_HEIGHT");
				itemGrossWeight = rs.getDouble("ITEM_GROSS_WEIGHT");
				lotLen = rs.getDouble("LITEM_LEN");
				lotWidth = rs.getDouble("LITEM_WID");
				lotHeight = rs.getDouble("LITEM_HEIGHT");				
				shipperSize = rs.getDouble("SHIPSIZE");				
				caseGrossWeight = rs.getDouble("CASE_GROSS_WEIGHT");				
				itemNetWeight = rs.getDouble("ITEM_NET_WEIGHT");				
				caseNetWeight = rs.getDouble("CASE_NET_WEIGHT");				
			}
			
			//shipperSize = (lotHeight * lotWidth * lotLen)/(itmLen * itmWidth * itmHeight);
			itemVolume = (itmLen * itmWidth * itmHeight);
			caseVolume = (lotHeight * lotWidth * lotLen);
			
			dataVolumeMap.put("SHIPPER_SIZE", shipperSize);
			dataVolumeMap.put("ITEM_VOLUME", itemVolume);
			dataVolumeMap.put("CASE_VOLUME", caseVolume);
			dataVolumeMap.put("ITEM_GROSS_WEIGHT", itemGrossWeight);
			dataVolumeMap.put("CASE_GROSS_WEIGHT", caseGrossWeight);
			dataVolumeMap.put("ITEM_NET_WEIGHT", itemNetWeight);
			dataVolumeMap.put("CASE_NET_WEIGHT", caseNetWeight);
			
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
		
			}
			if(rs != null)
			{
				rs.close();
				rs = null;
		
			}
			
			
			
		} catch (Exception e) {
			// TODO: handle exception

			throw e;
		}
		finally
		{
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
		
			}
			if(rs != null)
			{
				rs.close();
				rs = null;
		
			}
		}
		
		return dataVolumeMap;
	}
	//Changed by sumit on 13/03/12 to reterive shipper size end
	private String getUpdateFlagFromDom( Document dom,  String objContext ) throws RemoteException,ITMException
	{
		NodeList detailList = null;
		Node attrbNode = null, detailNode = null, reqDetail = null;
		String retString = "";
		int	detailListLength = 0;

		try
		{
			detailList = dom.getElementsByTagName("Detail"+objContext);
			detailListLength = detailList.getLength();			
			for (int ctr = 0; ctr < detailListLength; ctr++)
			{				
				detailNode = detailList.item(ctr);
				retString = detailNode.getAttributes().getNamedItem("domID").getNodeValue();
				System.out.println("detail node Dom ID:::::::::::+ "+retString);
				
				if(detailNode != null)
				{
					System.out.println("detail node::::::::::: "+detailNode.getNodeName());
					NodeList attrbNodeList = detailNode.getChildNodes();
					
					for (int ctrA = 0; ctrA < attrbNodeList.getLength(); ctrA++)
					{
						attrbNode = attrbNodeList.item(ctrA);
					
						if(attrbNode != null)
						{
							if( attrbNode.getNodeType() != Node.ELEMENT_NODE )
							{
								continue;
							}
							System.out.println("attrbNode node::::::::::: "+attrbNode.getNodeName());
							if(attrbNode != null && "attribute".equalsIgnoreCase(attrbNode.getNodeName()))
							{
								System.out.println("attrbNode node::::::::::: ");
							if("A".equalsIgnoreCase( attrbNode.getAttributes().getNamedItem("updateFlag").getNodeValue()))
							{
								return retString;
							}
								
							}
						}
					}
				}
				//test = detail3Node.getAttributes().getNamedItem("updateFlag").getNodeValue();
			}			
		}
		catch ( Exception e )
		{
			throw new ITMException(e);
		}
		return retString;
	}
}