/*
 * Decompiled with CFR 0.152.
 */
package ibase.e12ria.client;

import com.google.gwt.dom.client.InputElement;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FileUpload;
import com.google.gwt.user.client.ui.FormPanel;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Widget;
import ibase.e12ria.client.E12Constants;
import ibase.e12ria.client.E12Global;

public class ME12FileUpload
extends Composite {
    protected HorizontalPanel container = new HorizontalPanel();
    protected FormPanel fileUploadFormPanel = new FormPanel();
    protected FileUpload fileUpload = new FileUpload();
    protected Image image = new Image("large-loading.gif");

    public ME12FileUpload(String objName) {
        this.fileUpload.setName("fileUpload");
        this.fileUpload.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                if (!"".equals(ME12FileUpload.this.getFilename())) {
                    if (ME12FileUpload.this.isValidFile()) {
                        E12Global.getInstance().setLoading(true);
                        ME12FileUpload.this.showImage(true);
                        ME12FileUpload.this.doAttachment();
                    } else {
                        Window.alert((String)E12Constants.constants.setFileNotRecognized());
                        E12Global.getInstance().setLoading(false);
                        ME12FileUpload.this.reset();
                    }
                }
            }
        });
        this.fileUploadFormPanel.add((Widget)this.fileUpload);
        this.fileUploadFormPanel.setEncoding("multipart/form-data");
        this.fileUploadFormPanel.setMethod("post");
        this.fileUploadFormPanel.setAction("/ibase/RIAWizardHandlerServlet?ACTION=UPLOAD_DOCUMENT&OBJ_NAME=" + objName + "&EDITOR_ID=" + E12Global.getInstance().getEditorID(objName));
        this.container.add((Widget)this.fileUploadFormPanel);
        this.initWidget((Widget)this.container);
    }

    public void addSubmitCompleteHandler(FormPanel.SubmitCompleteHandler handler) {
        this.fileUploadFormPanel.addSubmitCompleteHandler(handler);
    }

    public void doAttachment() {
        this.fileUploadFormPanel.submit();
        this.showImage(false);
    }

    protected void showImage(boolean flag) {
        if (flag) {
            this.container.clear();
            this.container.add((Widget)this.fileUploadFormPanel);
            this.container.add((Widget)this.image);
        } else {
            this.container.remove((Widget)this.image);
        }
    }

    public String getFilename() {
        String fileName = "";
        if (this.fileUpload != null) {
            fileName = this.fileUpload.getFilename();
        }
        return fileName;
    }

    public void reset() {
        ((InputElement)this.fileUpload.getElement().cast()).setValue("");
    }

    protected boolean isValidFile() {
        String fileName = this.getFilename();
        if (fileName == null) {
            return false;
        }
        return fileName.lastIndexOf(".") != -1;
    }
}

