 
 INSERT INTO DASHBOARD_PAGES
    (
      USER_ID,
      PAGE_ID,
      TITLE,
      URI,
      IMAGE_URI,
      PAGE_TYPE,
      ENTITY_TYPE,
      ENTITY_CODE,
      CHG_USER,
      CHG_TERM,
      CHG_DATE,
      COMP_TYPE
    )
    VALUES
    (
      'X001',
      3,
      'Zonewise Coaching Days',
      '/ibase/dwh/GwtDashboardPage.html?metadataname=zonewisecoachingday',
      NULL,
      'T',
      'U',
      'X001',
      'X001',
      '127.0.0.1',
      sysdate,
      NULL
    );
  
  
  INSERT INTO DASHBOARD_COMP
  (
    USER_ID,
    PAGE_ID,
    COMP_ID,
    TITLE,
    URI,
    WIDTH,
    HEIGHT,
    ROW_NO,
    COLUMN_NO,
    COMP_TYPE,
    COMP_NAME,
    ENTITY_TYPE,
    ENTITY_CODE,
    DBR_RESOURCE
  )
  VALUES
  (
    'X001',
    3,
    1,
    'Zonewise Coaching Days',
    '/ibase/dwh/GwtDashboardPage.html?metadataname=zonewisecoachingday',
    0,0,0,1,
    NULL,
    NULL,
    'U',
    'X001',
    NULL
  ); 
  
  
  
  
  -----------------------------------function-----------------------------------------------
  CREATE OR REPLACE
  FUNCTION FN_SP_CNT_NEW_MT(
      ls_emp   IN CHAR,
      ls_month IN VARCHAR2,
      ls_year  IN VARCHAR2,
      ls_level IN CHAR )
    RETURN NUMBER
  IS
    chem_call_count NUMBER(10,2);
  BEGIN
    BEGIN
      IF ls_level = 'REP' THEN
        SELECT SUM(chem_call_count)
        INTO chem_call_count
        FROM
          (SELECT DISTINCT SMT.SALES_PERS,
            SMT.DCR_ID,
            (
            CASE
              WHEN (SELECT ACTIVITY_CODE FROM SPRS_ACT_TRAN WHERE TRAN_ID = SM.DCR_ID) IN ('HT','HC','HR','SM','HA','HM','TH','HS','OF')
              THEN 0.5
              ELSE 1
            END) chem_call_count
          FROM strg_meet SM
          INNER JOIN STRG_MEET_TEAM SMT
          ON SM.DCR_ID          = SMT.DCR_ID
          AND SM.STRG_CODE      = SMT.STRG_CODE
          WHERE (sm.sales_pers) = ls_emp
          AND SM.EVENT_DATE BETWEEN TRUNC(to_date(ls_month
            ||ls_year,'MMYYYY'),'MM')
          AND LAST_DAY(TO_DATE(LS_MONTH
            ||LS_YEAR,'MMYYYY'))
          AND SMT.design_code <>'RBM'
          ) ;
      elsif ls_level = 'FLM' THEN
        SELECT SUM(chem_call_count)
        INTO chem_call_count
        FROM
          (SELECT DISTINCT SM.SALES_PERS,
            SMT.DCR_ID,
            (
            CASE
              WHEN TRIM(SM.event_type)                                                 ='JW'
              AND (SELECT ACTIVITY_CODE FROM SPRS_ACT_TRAN WHERE TRAN_ID = SM.DCR_ID) IN ('HT','HC','HR','SM','HA','HM','TH','HS','OF')
              THEN 0.5
              ELSE 1
            END) chem_call_count
          FROM strg_meet SM
          INNER JOIN STRG_MEET_TEAM SMT
          ON SM.DCR_ID        = SMT.DCR_ID
          AND SM.STRG_CODE    = SMT.STRG_CODE
          AND SM.sales_pers   = SMT.sales_pers
          WHERE EVENT_TYPE    = 'JW'
          AND (sm.sales_pers) = ls_emp
          AND SM.EVENT_DATE BETWEEN TRUNC(TO_DATE(LS_MONTH
            ||LS_YEAR,'MMYYYY'),'MM')
          AND LAST_DAY(TO_DATE(ls_month
            ||ls_year,'MMYYYY'))
          );
      END IF;
    EXCEPTION
    WHEN no_data_found THEN
      chem_call_count:=0;
    END;
    RETURN CHEM_CALL_COUNT ;
  END;