package ibase.webitm.ejb.wms;
import java.rmi.RemoteException;
import java.util.*;
import java.util.Date;
import java.text.DateFormat;
import java.sql.*;
import javax.ejb.*;
import javax.naming.InitialContext;
import org.w3c.dom.*;
import javax.xml.parsers.*;
import java.text.SimpleDateFormat;
import ibase.webitm.ejb.*;
import ibase.webitm.utility.*;
import ibase.system.config.*;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.GenericUtility;
import ibase.utility.CommonConstants;

@javax.ejb.Stateless
public class DespPackPreSave extends ValidatorEJB implements DespPackPreSaveLocal, DespPackPreSaveRemote
{
	public String preSave()throws RemoteException,ITMException
	{
		return "";
	}

	public String preSave( String domString, String editFlag, String xtraParams, Connection conn ) throws RemoteException,ITMException
	{
		String retString = "";
		String objName = "";
		String outerCartonNo = "", despId ="";
		PreparedStatement pStmt = null;
		Document dom = null;
			
		boolean isError = false;
		boolean isLocalConn = false;

		try
		{
			conn.setAutoCommit( false );
			
			GenericUtility genericUtility = GenericUtility.getInstance();
			dom = genericUtility.parseString(domString);
			objName  = getObjNameFromDom( dom, "objName");
			System.out.println("--- objName["+objName+"]");
			
			System.out.println("--- domString DespPackPreSave ["+domString+"]");			
			outerCartonNo = checkNull( genericUtility.getColumnValue("outer_carton_no", dom));
			despId  = checkNull( genericUtility.getColumnValue("desp_id", dom));
			System.out.println("--- outerCartonNo--> [" + outerCartonNo + "] ---- despId--> ["+despId+"]");
			
			String sql="";
			int updateCnt = 0;

			sql = "DELETE FROM DESP_PACK_DET WHERE DESP_ID = ? AND OUTER_CARTON_NO = ?";
			System.out.println("--- Delete if record exist in table desp_pack_det ["+sql+"]");
			pStmt = conn.prepareStatement( sql );
			pStmt.setString( 1, despId);
			pStmt.setString( 2, outerCartonNo);			
			updateCnt = pStmt.executeUpdate();
			System.out.println("******** Query Executed of delete desp_det **********");
			System.out.println("[ DespPackPreSave ] Update Count for deleting from desp_pack_det table :"+updateCnt);
			pStmt.close();
			pStmt = null;
			
			sql = "DELETE FROM DESPATCHDET WHERE DESP_ID = ?";
			System.out.println("--- Delete if record exist in table despatchdet ["+sql+"]");
			pStmt = conn.prepareStatement( sql );
			pStmt.setString( 1, despId);
			updateCnt = pStmt.executeUpdate();
			System.out.println("******** Query Executed of delete despatchdet **********");
			System.out.println("[ DespPackPreSave ] Update Count for deleting from despatchdet table :"+updateCnt);
			pStmt.close();
			pStmt = null;

		}
		catch(Exception e)
		{
			System.out.println("Exception :DespPackPreSave : :==>\n"+e.getMessage());
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				System.out.println("isError ["+isError+"]");
				System.out.println("isLocalConn ["+isLocalConn+"]");
				
				    if( isError )
					{
						conn.rollback();
					}
					else
					{
						conn.commit();
					}
					if(pStmt != null)
					{
						pStmt.close();
						pStmt = null;
					}
					
					//conn.close();	
			}
			catch(Exception e)
			{
				System.out.println("Exception :DespPackPreSave : :==>\n"+e.getMessage());
				try
				{
					System.out.println("Before rollback");
					conn.rollback();
				}
			
				catch(SQLException sqle)
				{
                    System.out.println(sqle);
				}
				throw new ITMException(e);
			
			}
		}
		System.out.println("Return string :"+retString);
		return retString;		
	}
	private String getObjNameFromDom( Document dom, String attribute ) throws RemoteException,ITMException
	{
		String objName = "";
		try
		{
			NodeList detailList = null;
			Node currDetail = null;			
			int	detailListLength = 0;

			detailList = dom.getElementsByTagName("Detail2");
			detailListLength = detailList.getLength();
			for (int ctr = 0;ctr < detailListLength;ctr++)
			{
				currDetail = detailList.item(ctr);
				objName = currDetail.getAttributes().getNamedItem(attribute).getNodeValue();
						
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		return objName;
	}

	public String checkNull(String input)
	{
		if (input == null || "null".equalsIgnoreCase(input))
		{
			input= "";
		}
		return input.trim();
	}
}
