



CREATE TABLE WAVE_TASK 
(
 WAVE_ID                                  VARCHAR2(12) NOT NULL,
 TRAN_DATE                                DATE,
 SALE_ORDER__FROM                         CHAR(10),
 SALE_ORDER__TO                           CHAR(10),
 CUST_CODE__FROM                          CHAR(10),
 CUST_CODE__TO                            CHAR(10),
 DUE_DATE__FROM                           DATE,
 DUE_DATE__TO                             DATE,
 CHG_USER                                 CHAR(10),
 CHG_TERM                                 VARCHAR2(15),
 CHG_DATE                                 DATE
);

tablespace itm_dis_d2;
alter table WAVE_TASK add constraint PK_WAVE_TASK primary key (WAVE_ID);
using index tablespace itm_dis_i1;



create table WAVE_TASK_DET 
 (
 WAVE_ID                                  VARCHAR2(12)  NOT NULL, 
 LINE_NO                                    NUMBER(3) NOT NULL,
 REF_SER                                            CHAR(6),
 REF_ID                                             CHAR(10),
 REF_TYPE                                           CHAR(1),
 STATUS                                             CHAR(1),
 SALE_ORDER                                         CHAR(10),
 PTCN                                               CHAR(10) NOT NULL
);


tablespace itm_dis_d2;
alter table WAVE_TASK_DET add constraint PK_WAVE_TASK_DET primary key (WAVE_ID,
LINE_NO) ;
using index tablespace itm_dis_i1;
alter table WAVE_TASK_DET add constraint FK_WAVE_TASK_DET foreign key (WAVE_ID)
references WAVE_TASK (WAVE_ID) on delete cascade;



 create table REPL_ORD_HDR  
(
 REPL_ORDER                                         CHAR(10)  NOT NULL,
 ORDER_DATE                                         DATE,
 SITE_CODE                                          CHAR(5),
 SALE_ORDER                                         CHAR(10),
 WAVE_ID                                            VARCHAR2(12),
 CHG_USER                                           CHAR(10),
 CHG_TERM                                           VARCHAR2(15),
 CHG_DATE                                           DATE,
 ORDER_TYPE                                         CHAR(1)
);


tablespace itm_dis_d2;

alter table REPL_ORD_HDR add constraint PK_REPL_ORD_HDR primary key (REPL_ORDER);
using index tablespace itm_dis_i1;




create table REPL_ORD_DET  
(
 REPL_ORDER                                 CHAR(10) NOT NULL,
 LINE_NO                                    NUMBER(3) NOT NULL,
 SALE_ORDER                                         CHAR(10),
 LINE_NO__SORD                                      NUMBER(3),
 SITE_CODE                                          CHAR(5),
 ITEM_CODE                                          CHAR(10),
 LOC_CODE                                           CHAR(8),
 LOT_NO                                             CHAR(15),
 LOT_SL                                             CHAR(15),
 NO_ART                                             NUMBER(6),
 QUANTITY                                           NUMBER(14,3),
 PICK_ORDER                                         CHAR(10),
 LINE_NO__PICK                                      NUMBER(3),
 EXP_LEV                                            CHAR(20) NOT NULL

);

tablespace itm_dis_d2;
alter table REPL_ORD_DET add constraint PK_REPL_ORD_DET primary key (REPL_ORDER,
LINE_NO) ;
using index tablespace itm_dis_i1;
alter table REPL_ORD_DET add constraint FK_REPL_ORD_DET foreign key (REPL_ORDER)
references REPL_ORD_HDR (REPL_ORDER) on delete cascade;




create table REPL_ISS_HDR  
(
 TRAN_ID                                            CHAR(10) NOT NULL,
 TRAN_DATE                                          DATE,
 SITE_CODE                                          CHAR(5),
 REPL_ORDER                                         CHAR(10),
 CONFIRMED                                          CHAR(1),
 CONF_DATE                                          DATE,
 EMP_CODE__APRV                                     CHAR(10),
 CHG_USER                                           CHAR(10),
 CHG_DATE                                           DATE,
 CHG_TERM                                           VARCHAR2(15)
);

tablespace itm_dis_d2;
alter table REPL_ISS_HDR add constraint PK_REPL_ISS_HDR primary key (TRAN_ID) using
index tablespace itm_dis_i1;




create table REPL_ISS_DET  
(
 TRAN_ID                                            CHAR(10)  NOT NULL,
 LINE_NO                                            NUMBER(3) NOT NULL,
 REPL_ORDER                                         CHAR(10),
 LINE_NO__ORD                                       NUMBER(3),
 SITE_CODE                                          CHAR(5),
 ITEM_CODE                                          CHAR(10),
 LOC_CODE                                           CHAR(8),
 LOT_NO                                             CHAR(15),
 LOT_SL                                             CHAR(15),
 QUANTITY                                           NUMBER(14,3),
 NO_ART                                             NUMBER(6),
 LOC_CODE__TO                                       CHAR(8),
 LOC_CODE__SYS                                      CHAR(8)
);

tablespace itm_dis_d2;
  alter table REPL_ISS_DET add constraint PK_REPL_ISS_DET primary key (TRAN_ID,
LINE_NO) ;
using index tablespace itm_dis_i1;
alter table REPL_ISS_DET add constraint FK_REPL_ISS_DET foreign key (TRAN_ID)
references REPL_ISS_HDR (TRAN_ID) on delete cascade;



 create table PICK_ORD_HDR  
(
 PICK_ORDER                                 	    CHAR(10) NOT NULL,
 ORDER_DATE                                         DATE,
 SITE_CODE                                          CHAR(5),
 SALE_ORDER                                         CHAR(10),
 WAVE_ID                                            VARCHAR2(12),
 PICK_TYPE                                          CHAR(1),
 CHG_USER                                           CHAR(10),
 CHG_DATE                                           DATE,
 CHG_TERM                                           VARCHAR2(15)
);


tablespace itm_dis_d2;
alter table  PICK_ORD_HDR add  constraint PK_PICK_ORD_HDR primary key (PICK_ORDER);
using index tablespace itm_dis_i1;



 create table PICK_ORD_DET  
(
 PICK_ORDER                                         CHAR(10) NOT NULL,
 LINE_NO                                            NUMBER(3) NOT NULL,
 SALE_ORDER                                         CHAR(10),
 LINE_NO__SORD                                      NUMBER(3),
 SITE_CODE                                          CHAR(5),
 ITEM_CODE                                          CHAR(10),
 LOC_CODE                                           CHAR(8),
 LOT_NO                                             CHAR(15),
 LOT_SL                                             CHAR(15),
 NO_ART                                             NUMBER(6),
 QUANTITY                                           NUMBER(14,3),
 EXP_LEV                                            CHAR(20) NOT NULL

);


tablespace itm_dis_d2;
   alter table  PICK_ORD_DET add constraint PK_PICK_ORD_DET primary key (PICK_ORDER,
LINE_NO); 
using index tablespace itm_dis_i1;
alter table PICK_ORD_DET add constraint FK_PICK_ORD_DET foreign key (PICK_ORDER)
references PICK_ORD_HDR (PICK_ORDER) on delete cascade;
 


 create table PICK_ISS_HDR  
(
 TRAN_ID                                            CHAR(10) NOT NULL,
 TRAN_DATE                                          DATE,
 PICK_ORDER                                         CHAR(10) NOT NULL,
 SITE_CODE                                          CHAR(5),
 CONFIRMED                                          CHAR(1),
 CONF_DATE                                          DATE,
 EMP_CODE__APRV                                     CHAR(10),
 CHG_USER                                           CHAR(10),
 CHG_DATE                                           DATE,
 CHG_TERM                                           VARCHAR2(15),
 PICK_TYPE                                          CHAR(1),
 PALLET_NO                                          VARCHAR2(25)

);


tablespace itm_dis_d2;
alter table PICK_ISS_HDR add   constraint PK_PICK_ISS_HDR primary key (TRAN_ID);
using index tablespace itm_dis_i1;




 create table PICK_ISS_DET 
 (
 TRAN_ID                                           CHAR(10) NOT NULL,
 LINE_NO                                           NUMBER(3) NOT NULL,
 PICK_ORDER                                        CHAR(10) NOT NULL,
 LINE_NO__ORD                                       NUMBER(3),
 SITE_CODE                                          CHAR(5),
 ITEM_CODE                                          CHAR(10),
 LOC_CODE                                           CHAR(8),
 LOT_NO                                             CHAR(15),
 LOT_SL                                             CHAR(15),
 NO_ART                                             NUMBER(6),
 QUANTITY                                           NUMBER(14,3),
 LOC_CODE__TO                                       CHAR(8),
 CASE_LABEL                                         VARCHAR2(40),
 LOC_CODE__SYS                                      CHAR(8),
 CARTON_NO                                          VARCHAR2(15)
);

tablespace itm_dis_d2;
alter table  PICK_ISS_DET add  constraint PK_PICK_ISS_DET primary key (TRAN_ID,
LINE_NO); 
using index tablespace itm_dis_i1;
alter table PICK_ISS_DET add constraint FK_PICK_ISS_DET foreign key (TRAN_ID)
references PICK_ISS_HDR (TRAN_ID) on delete cascade;



create table PACK_HDR  
(
 TRAN_ID                                           CHAR(10) NOT NULL,
 TRAN_DATE                                          DATE,
 SITE_CODE                                          CHAR(5),
 SALE_ORDER                                         CHAR(10),
 WAVE_ID                                            VARCHAR2(12),
 CONFIRMED                                          CHAR(1),
 CONF_DATE                                          DATE,
 EMP_CODE__APRV                                     CHAR(10),
 CHG_USER                                           CHAR(10),
 CHG_DATE                                           DATE,
 CHG_TERM                                           VARCHAR2(15),
 OUTER_CARTON_NO                                    VARCHAR2(15),
 PICK_ORDER                                         CHAR(10)
);

tablespace itm_dis_d2;
 alter table  PACK_HDR add  constraint PK_PACK_HDR primary key (TRAN_ID); 
tablespace itm_dis_i1;



 create table PACK_DET 
 (
 TRAN_ID                                            CHAR(10) NOT NULL,
 LINE_NO                                            NUMBER(3) NOT NULL,
 SALE_ORDER                                         CHAR(10),
 LINE_NO__SORD                                      NUMBER(3),
 SITE_CODE                                          CHAR(5),
 ITEM_CODE                                          CHAR(10),
 LOC_CODE                                           CHAR(8),
 LOT_NO                                             CHAR(15),
 LOT_SL                                             CHAR(15),
 QUANTITY                                           NUMBER(14,3),
 LOC_CODE__TO                                       CHAR(8),
 CARTON_NO                                          VARCHAR2(15),
 NO_ART                                             NUMBER(6)
);

tablespace itm_dis_d2;
 alter table  PACK_DET add  constraint PK_PACK_DET primary key (TRAN_ID, LINE_NO);
using index tablespace itm_dis_i1;
alter table PACK_DET add constraint FK_PACK_DET foreign key (TRAN_ID) references
PACK_HDR (TRAN_ID) on delete cascade;



CREATE TABLE DESP_PACK_DET
(
 TRAN_ID                                            CHAR(10) NOT NULL,
 LINE_NO                                            NUMBER(3) NOT NULL,
 OUTER_CARTON_NO                                    VARCHAR2(15),
 DESP_ID                                            CHAR(10),
 TRACK_NO                                           VARCHAR2(35)
);

 tablespace ITM_DIS_D2;

 ALTER TABLE DESP_PACK_DET ADD CONSTRAINT PK_DESP_PACK_DET_X PRIMARY KEY
 (TRAN_ID);
 using index TABLESPACE ITM_DIS_I1;

DELETE FROM ITM2MENU
WHERE win_name = 'w_wavegen';

INSERT INTO ITM2MENU (
	application,
	level_1,
	level_2,
	level_3,
	level_4,
	level_5,
	win_name,
	descr,
	comments,
	menu_path,
	icon_path,
	close_icon,
	open_icon,
	obj_type,
	chg_date,
	chg_term,
	chg_user)
VALUES (
	'SFA',
	1,
	7,
	0,
	0,
	0,
	'w_wavegen',
	'Wave Generation',
	'Wave Gen',
	'SFA.1.7.0.0.0',
	'e12_logo.gif',
	NULL,
	NULL,
	'P',
	NULL,
	NULL,
	NULL);

DELETE FROM OBJ_ACTIONS
WHERE obj_name = 'wavegen';

INSERT INTO OBJ_ACTIONS (
	obj_name,
	line_no,
	rights_char,
	interactive,
	service_code,
	description,
	title,
	image,
	action_type,
	form_no,
	service_handler,
	placement,
	tran_type,
	chg_date,
	chg_term,
	chg_user)
VALUES (
	'wavegen',
	7,
	'R',
	'a',
	'get_data',
	'Action Button for getting data',
	'GetData',
	NULL,
	'U',
	'2',
	'3',
	NULL,
	NULL,
	NULL,
	NULL,
	NULL);

INSERT INTO OBJ_ACTIONS (
	obj_name,
	line_no,
	rights_char,
	interactive,
	service_code,
	description,
	title,
	image,
	action_type,
	form_no,
	service_handler,
	placement,
	tran_type,
	chg_date,
	chg_term,
	chg_user)
VALUES (
	'wavegen',
	8,
	'R',
	'a',
	'process',
	'Action Button for processing the data',
	'Process',
	NULL,
	'U',
	'2',
	'3',
	NULL,
	NULL,
	NULL,
	NULL,
	NULL);

DELETE FROM obj_forms
WHERE win_name = 'w_wavegen';

INSERT INTO obj_forms (
	win_name,
	title,
	obj_brow_name,
	obj_edit_name,
	cross_update_expr,
	expr_fld_info, 
	target_fld_info,
	expr_comment,
	form_no,
	auto_accept_scan,
	scan_metadata,
	scan_flag,
	scr_flag,
	property_info,
	ext_com,
	ext_metadata,
	ext_setup,
	after_save,
	column_on_save,
	scan_delimiter,
	auto_accept_weighdata,
	rate_col,
	qty_col,
	form_type,
	disp_metadata,
	parent_key_col,
	assisted_mode )
VALUES (
	'w_wavegen',
	'Stock Detail',
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	'1',
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL);

INSERT INTO obj_forms (
	win_name,
	title,
	obj_brow_name,
	obj_edit_name,
	cross_update_expr,
	expr_fld_info, 
	target_fld_info,
	expr_comment,
	form_no,
	auto_accept_scan,
	scan_metadata,
	scan_flag,
	scr_flag,
	property_info,
	ext_com,
	ext_metadata,
	ext_setup,
	after_save,
	column_on_save,
	scan_delimiter,
	auto_accept_weighdata,
	rate_col,
	qty_col,
	form_type,
	disp_metadata,
	parent_key_col,
	assisted_mode )
VALUES (
	'w_wavegen',
	'Stock Item',
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	'2',
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL);

DELETE FROM transetup
WHERE tran_window = 'w_wavegen';

INSERT INTO transetup (
	tran_window,
	save_flag,
	val_flag,
	key_flag,
	key_string,
	udf_1,
	udf_2,
	udf_3,
	udf_4,
	udf_5,
	repeate_add,
	chg_date,
	chg_user,
	chg_term,
	edi_option,
	site_acc_col,
	confirm_col,
	confirm_val,
	repeat_add_det,
	load_mode,
	auto_confirm,
	ledg_post_conf,
	chg_date_on_conf,
	tran_id_col,
	mail_option,
	confirm_mode,
	garbage_opt,
	val_flag_edi,
	verify_password,
	table_name,
	application,
	table_desc,
	tran_date_col,
	sales_pers_acc_col,
	cust_acc_col,
	supp_acc_col,
	item_ser_acc_col,
	emp_acc_col,
	workflow_opt,
	tran_id__from,
	tran_id__to,
	multitire_opt,
	ref_ser,
	view_mode,
	table_name_det1,
	table_name_det2,
	table_name_det3,
	tax_forms,
	sign_status,
	user_tran_window,
	custom_preview_obj,
	childdata_argopt,
	ignoreerrlist_onload,
	edit_tmplt,
	wrkflw_init,
	formal_args,
	edit_opt,
	audit_trail_opt,
	edittax,
	cache_opt,
	optimize_mode,
	edit_expr,
	transfer_mode,
	rate_col,
	qty_col,
	rcp_cache_status,
	print_control,
	item_ser_acc_code,
	profile_id__res,
	period_option,
	tran_compl_msg,
	wrkflw_priority,
	exec_type,
	disp_meta_data)
VALUES (
	'w_wavegen',
	'2',
	'2',
	'A',
	'seq10',
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	'N',
	fn_sysdate(),
	'BASE',
	'1',
	'0',
	NULL,
	NULL,
	'Y',
	NULL,
	NULL,
	NULL,
	'N',
	'N',
	'TRAN_ID',
	'0',
	'0',
	'N',
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	'W-ORD',
	'F',
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL);

DELETE FROM transetup
WHERE tran_window = 'w_ptcn';

INSERT INTO transetup (
	tran_window ,
	save_flag ,
	val_flag ,
	key_flag ,
	key_string,
	repeate_add ,
	chg_date ,
	chg_user ,
	chg_term ,
	edi_option ,
	confirm_mode ,
	mail_option ,
	garbage_opt ,
	table_name,
	application,
	ref_ser,
	tran_id_col,
	confirm_col,
	confirm_val)
VALUES (
	'w_ptcn',
	'2',
	'2',
	'A',
	'PTCN,seq06',
	'N',
	fn_sysdate(),
	'Rohan ',
	'BASE ',
	'0',
	'0',
	'0',
	'N',
	'WAVE_TASK',
	'DIS',
	'C-PTCN',
	'ptcn',
	'',
	'');

DELETE FROM REFSER
WHERE ref_ser = 'C-PTCN';

INSERT INTO REFSER (
	ref_ser ,
	descr ,
	type ,
	sys_ser ,
	prefix ,
	chg_date ,
	chg_user ,
	chg_term ,
	seq_name ,
	tax_form_reqd ,
	trans_type )
 VALUES (
	'C-PTCN',
	'Pick ticket control no',
	'S',
	NULL,
	NULL,
	fn_sysdate(),
	'Rohan',
	'BASE',
	NULL,
	NULL,
	NULL);

DELETE FROM SYSTEM_EVENTS
WHERE obj_name = 'wavegen';

INSERT INTO SYSTEM_EVENTS (
	obj_name,
	event_code,
	event_context,
	service_code,
	method_rule,
	chg_date,
	chg_user,
	chg_term,
	result_handle,
	overwrite_core,
	comp_type,
	comp_name,
	comm_format)
VALUES (
	'wavegen',
	'get_data',
	'1',
	'agetData_wavegen',
	NULL,
	fn_sysdate(),
	'Dharmen',
	'BASE29',
	'2',
	'0',
	'EJB',
	'WaveGenerationPrc',
	NULL);

INSERT INTO SYSTEM_EVENTS (
	obj_name,
	event_code,
	event_context,
	service_code,
	method_rule,
	chg_date,
	chg_user,
	chg_term,
	result_handle,
	overwrite_core,
	comp_type,
	comp_name,
	comm_format)
VALUES (
	'wavegen',
	'process',
	'1',
	'aprocessWavegen',
	NULL,
	fn_sysdate(),
	'DHARMEN   ',
	'BASE216',
	'2',
	'0',
	'EJB',
	'WaveGenerationPrc',
	NULL);


DELETE FROM SYSTEM_EVENT_SERVICES
WHERE service_code = 'aprocessWavegen';

INSERT INTO SYSTEM_EVENT_SERVICES (
	service_code,
	service_descr,
	service_uri,
	service_provider,
	method_name,
	return_value,
	return_type,
	return_descr,
	return_xfrm,
	chg_date,
	chg_user,
	chg_term)
VALUES (
	'aprocessWavegen',
	'Action To process the Data',
	'http://192.168.0.107/BaseE12DotNetService/E12BusinessLogic.asmx',
	'Base Information',
	'process',
	'String',
	'S',
	NULL,
	NULL,
	fn_sysdate(),
	'DHARMEN',
	'BASE29');


DELETE FROM SYSTEM_EVENT_SERVICES
WHERE service_code = 'agetData_wavegen';

INSERT INTO SYSTEM_EVENT_SERVICES (
	service_code,
	service_descr,
	service_uri,
	service_provider,
	method_name,
	return_value,
	return_type,
	return_descr,
	return_xfrm,
	chg_date,
	chg_user,
	chg_term)
VALUES (
        'agetData_wavegen',
	'Action To get the Data',
	'http://192.168.0.107/BaseE12DotNetService/E12BusinessLogic.asmx',
	'Base Information',
	'getData',
	'String',
	'S',
	NULL,
	NULL,
	fn_sysdate(),
	'Dharmen',
	'BASE29');


DELETE FROM SYSTEM_SERVICE_ARGS
WHERE service_code = 'agetData_wavegen';

INSERT INTO SYSTEM_SERVICE_ARGS (
	service_code,
	line_no,
	arg_name,
	arg_mode,
	descr,
	arg_type,
	arg_xfrm,
	chg_date,
	chg_user,
	chg_term,
	arg_value )
 VALUES (
	'agetData_wavegen',
	1,
	'COMPONENT_TYPE',
	'I',
	'Component Type',
	'S',
	NULL,
         fn_sysdate(),       	
	'AVIPRASH  ',
	'BASE216',
	'EJB');

INSERT INTO SYSTEM_SERVICE_ARGS (
	service_code,
	line_no,
	arg_name,
	arg_mode,
	descr,
	arg_type,
	arg_xfrm,
	chg_date,
	chg_user,
	chg_term,
	arg_value )
VALUES (
	'agetData_wavegen',
	2,
	'COMPONENT_NAME',
	'I',
	'Component Name',
	'S',
	NULL,
	fn_sysdate(),
	'DHARMEN   ',
	'BASE29',
	'WaveGenerationPrc');


INSERT INTO SYSTEM_SERVICE_ARGS (
	service_code,
	line_no,
	arg_name,
	arg_mode,
	descr,
	arg_type,
	arg_xfrm,
	chg_date,
	chg_user,
	chg_term,
	arg_value )
VALUES (
	'agetData_wavegen',
	3,
	'XML_DATA',
	'I',
	'XML data of form no 1',
	'S',
	NULL,
	fn_sysdate(),
	'DHARMEN   ',
	'BASE29',
	NULL);
INSERT INTO SYSTEM_SERVICE_ARGS (
	service_code,
	line_no,
	arg_name,
	arg_mode,
	descr,
	arg_type,
	arg_xfrm,
	chg_date,
	chg_user,
	chg_term,
	arg_value )
VALUES (
	'agetData_wavegen',
	4,
	'XML_DATA_1',
	'I',
	'XML data of form no All',
	'S',
	NULL,
	fn_sysdate(),
	'DHARMEN   ',
	'BASE29',
	NULL);

INSERT INTO SYSTEM_SERVICE_ARGS (
	service_code,
	line_no,
	arg_name,
	arg_mode,
	descr,
	arg_type,
	arg_xfrm,
	chg_date,
	chg_user,
	chg_term,
	arg_value )
VALUES (
	'agetData_wavegen',
	5,
	'WINDOW_NAME',
	'I',
	'Window Name',
	'S',
	NULL,
	fn_sysdate(),
	'DHARMEN   ',
	'BASE29',
	'w_sordalloc');

INSERT INTO SYSTEM_SERVICE_ARGS (
	service_code,
	line_no,
	arg_name,
	arg_mode,
	descr,
	arg_type,
	arg_xfrm,
	chg_date,
	chg_user,
	chg_term,
	arg_value )
VALUES (
	'agetData_wavegen',
	6,
	'XTRA_PARAMS',
	'I',
	'Extra Arguments',
	'S',
	NULL,
	fn_sysdate(),
	'DHARMEN   ',
	'BASE29',
	NULL);


DELETE FROM SYSTEM_SERVICE_ARGS
WHERE service_code = 'aprocessWavegen';


INSERT INTO SYSTEM_SERVICE_ARGS(
	service_code,
	line_no,
	arg_name,
	arg_mode,
	descr,
	arg_type,
	arg_xfrm,
	chg_date,
	chg_user,
	chg_term,
	arg_value )
VALUES (
	'aprocessWavegen',
	1,
	'COMPONENT_TYPE',
	'I',
	'Component Type',
	'C.String',
	NULL,
	fn_sysdate(),
	'DHARMEN   ',
	'BASE216',
	'EJB');

INSERT INTO SYSTEM_SERVICE_ARGS(
	service_code,
	line_no,
	arg_name,
	arg_mode,
	descr,
	arg_type,
	arg_xfrm,
	chg_date,
	chg_user,
	chg_term,
	arg_value )
VALUES (
	'aprocessWavegen',
	2,
	'COMPONENT_NAME',
	'I',
	'Component Name',
	'C.String',
	NULL,
	fn_sysdate(),
	'DHARMEN',
	'BASE216',
	'WaveGenerationPrc');

INSERT INTO SYSTEM_SERVICE_ARGS(
	service_code,
	line_no,
	arg_name,
	arg_mode,
	descr,
	arg_type,
	arg_xfrm,
	chg_date,
	chg_user,
	chg_term,
	arg_value )
VALUES (
	'aprocessWavegen',
	3,
	'XML_DATA_1',
	'I',
	'XML data of form no 1',
	'S',
	NULL,
	fn_sysdate(),
	'DHARMEN   ',
	'BASE216',
	NULL);
INSERT INTO SYSTEM_SERVICE_ARGS(
	service_code,
	line_no,
	arg_name,
	arg_mode,
	descr,
	arg_type,
	arg_xfrm,
	chg_date,
	chg_user,
	chg_term,
	arg_value )
VALUES (
	'aprocessWavegen',
	4,
	'XML_DATA__ALL',
	'I',
	'XML data of form no 1',
	'S',
	NULL,
	fn_sysdate(),
	'DHARMEN   ',
	'BASE216',
	NULL);

INSERT INTO SYSTEM_SERVICE_ARGS(
	service_code,
	line_no,
	arg_name,
	arg_mode,
	descr,
	arg_type,
	arg_xfrm,
	chg_date,
	chg_user,
	chg_term,
	arg_value )
VALUES (
	'aprocessWavegen',
	5,
	'OBJ_CONTEXT',
	'I',
	'Object Context',
	'S',
	NULL,
	fn_sysdate(),
	'DHARMEN   ',
	'BASE216',
	NULL);

INSERT INTO SYSTEM_SERVICE_ARGS(
	service_code,
	line_no,
	arg_name,
	arg_mode,
	descr,
	arg_type,
	arg_xfrm,
	chg_date,
	chg_user,
	chg_term,
	arg_value )
VALUES (
	'aprocessWavegen',
	6,
	'XTRA_PARAMS',
	'I',
	'Extra Arguments',
	'S',
	NULL,
	fn_sysdate(),
	'DHARMEN   ',
	'BASE216',
	NULL);

DELETE FROM disparm
WHERE var_name = 'MASTER_PACK_WEIGHT';

INSERT INTO disparm
   (
	prd_code,
	var_name,
	var_type,
	var_value,
	descr,
	var_subs,
	chg_date,
	chg_user,
	chg_term,
	min_order_qty
   )
VALUES 
   (
       '999999',
	'MASTER_PACK_WEIGHT',
	'S',
	'70',
	'Master Pack weight allowed',
	NULL,
	fn_sysdate(),
	'Rohan',
	'Rohan',
	NULL
   );

DELETE FROM disparm
WHERE var_name = 'MASTER_PACK_CASE_COUNT';

INSERT INTO disparm
   (
	prd_code,
	var_name,
	var_type,
	var_value,
	descr,
	var_subs,
	chg_date,
	chg_user,
	chg_term,
	min_order_qty
   )
VALUES 
  (
	'999999',
	'MASTER_PACK_CASE_COUNT',
	'S',
	'60',
	'Master Pack Case Count',
	NULL,
	fn_sysdate(),
	'Rohan',
	'Rohan',
	NULL
   );

DELETE FROM disparm
WHERE var_name = 'MASTER_PACK_WEIGHT_PER_ORDER';

INSERT INTO disparm
   (
	prd_code,
	var_name,
	var_type,
	var_value,
	descr,
	var_subs,
	chg_date,
	chg_user,
	chg_term,
	min_order_qty
   )
VALUES 
   (
	'999999',
	'MASTER_PACK_WEIGHT_PER_ORDER',
	'S',
	'350',
	'Master Pack weight Per Order allowed',
	NULL,
	fn_sysdate(),
	'Rohan',
	'1 ',
	NULL
    );

DELETE FROM disparm
WHERE var_name = 'RESERV_LOC';

INSERT INTO disparm
   (
	prd_code,
	var_name,
	var_type,
	var_value,
	descr,
	var_subs,
	chg_date,
	chg_user,
	chg_term,
	min_order_qty
   )
VALUES 
   (
	'999999',
	'RESERV_LOC',
	'S',
	'RESRV',
	'Reserve last updated location',
	NULL,
	fn_sysdate(),
	'SUN',
	'prg ',
	NULL
   );


DELETE FROM disparm
WHERE var_name = 'PER_PALLET__VOLUME';

INSERT INTO disparm
   (
	prd_code,
	var_name,
	var_type,
	var_value,
	descr,
	var_subs,
	chg_date,
	chg_user,
	chg_term,
	min_order_qty
   )
VALUES 
   (
	'999999',
	'PER_PALLET__VOLUME',
	'S',
	'115200',
	'The Dimension of pallet are 60*48*40 inches H*L*W',
	NULL,
	fn_sysdate(),
	'Pragyan',
	'Pragyan',
	NULL);


DELETE FROM disparm
WHERE var_name = 'ADJUST_DR_CR_NOTE';

INSERT INTO disparm
   (
	prd_code,
	var_name,
	var_type,
	var_value,
	descr,
	var_subs,
	chg_date,
	chg_user,
	chg_term,
	min_order_qty
   )
VALUES 
  (
	'999999',
	'ADJUST_DR_CR_NOTE',
	'S',
	'Y',
	'Adjust DR/CR Note',
	0,
	fn_sysdate(),
	'BASE',
	'01BASE228',
	NULL);

DELETE FROM disparm
WHERE var_name = 'ADJUST_CUST_ADV';

INSERT INTO disparm
   (
	prd_code,
	var_name,
	var_type,
	var_value,
	descr,
	var_subs,
	chg_date,
	chg_user,
	chg_term,
	min_order_qty
   )
VALUES 
(
	'999999',
	'ADJUST_CUST_ADV',
	'S',
	'Y',
	'Adjust Customer Advance',
	0,
	fn_sysdate(),
	'BASE',
	'07BASE27',
	NULL
);

DELETE FROM disparm
WHERE var_name = 'ADJ_ADV_CUST_SALE';

INSERT INTO disparm
   (
	prd_code,
	var_name,
	var_type,
	var_value,
	descr,
	var_subs,
	chg_date,
	chg_user,
	chg_term,
	min_order_qty
   )
VALUES 
  (
	'999999',
	'ADJ_ADV_CUST_SALE',
	'S',
	'Q',
	'UOM ROUNDING REQD FOR QTY, RATE OR BOTH',
	NULL,
	fn_sysdate(),
	'BASE',
	'99BASE004',
	NULL
  );

DELETE FROM disparm
WHERE var_name = 'PER_PALLET__WEIGHT';

INSERT INTO disparm
   (
	prd_code,
	var_name,
	var_type,
	var_value,
	descr,
	var_subs,
	chg_date,
	chg_user,
	chg_term,
	min_order_qty
   )
VALUES 
  (
	'999999',
	'PER_PALLET__WEIGHT',
	'S',
	'2500',
	'The total weight per pallet maximum 2500LBS',
	NULL,
	fn_sysdate(),
	'Pragyan',
	'Pragyan',
	NULL
  );

INSERT INTO messages (
	msg_no ,
	msg_str,
	msg_descr ,
	msg_type ,
	msg_opt ,
	msg_time ,
	alarm ,
	err_source ,
	chg_date ,
	chg_user ,
	chg_term ,
	override_input ,
	mail_option )
VALUES (
	'VTCOMPL',
	'PROCESS OVER!!',
	'Process Completed Successfully',
	'W',
	'Y',
	NULL,
	NULL,
	NULL,
	fn_sysdate(),
	'Gulzar',
	'BASE207',
	NULL,
	NULL);

insert into obj_links(obj_name,form_no,field_name,target_obj_name,link_form_name,link_title,link_type,link_arg,update_flag,rights_char)
 values('wavegen','1','site_code','view_stock','view_stock11','Veiw Inventory','1','item_code.String,site_code.String','0','0');

commit;

