package ibase.webitm.util.gst;

import java.io.IOException;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.SerializerProvider;

import ibase.webitm.bean.gst.HSN;
import ibase.webitm.bean.gst.HSNDetails;

public class HSNSerializer extends BaseSerializer<HSN>
{
	@Override
	public void serialize(HSN hsn, JsonGenerator json, SerializerProvider serializeProvider) throws IOException, JsonProcessingException
	{
		json.writeStartObject();
		
		json.writeFieldName("data");
        json.writeStartArray();

        for(HSNDetails hsnDetails : hsn.hsnDetails)
        {
        	writeEachHSN(hsnDetails, json);
        }
        
        json.writeEndArray();
        json.writeEndObject();
	}
	
	private void writeEachHSN(HSNDetails hsnDetails, JsonGenerator json)
	{
		try
		{
			json.writeStartObject();
			
			json.writeNumberField("num", hsnDetails.num);
			json.writeStringField("hsn_sc", hsnDetails.itemOrServiceCode);
			if(hsnDetails.description != null && hsnDetails.description.trim().length()>0)
			{
				json.writeStringField("desc", hsnDetails.description);
			}
			json.writeStringField("uqc", hsnDetails.unitOfMeasure);
			json.writeNumberField("qty", hsnDetails.quantity);
			json.writeNumberField("val", hsnDetails.totalAmount);
			json.writeNumberField("txval", hsnDetails.totalTaxableAmount);
			if(hsnDetails.totalIGSTAmount > 0)
			{
				json.writeNumberField("iamt", hsnDetails.totalIGSTAmount);
			}
			if(hsnDetails.totalCGSTAmount > 0)
			{
				json.writeNumberField("camt", hsnDetails.totalCGSTAmount);
			}
			if(hsnDetails.totalSGSTAmount > 0)
			{
				json.writeNumberField("samt", hsnDetails.totalSGSTAmount);
			}
			if(hsnDetails.totalCESSAmount > 0)
			{
				json.writeNumberField("csamt", hsnDetails.totalCESSAmount);
			}
			
			json.writeEndObject();
		}
		catch(Exception e)
		{
			System.out.println("HSNSerializer.writeEachHSN()["+e.getMessage()+"]");
			e.printStackTrace();
		}
	}
}
