/**
 * PURPOSE : PalletizationConf component
 * AUTHOR : Sneha Mestry
 * DATE : 12-10-2015
 */

package ibase.webitm.ejb.wms;

import ibase.system.config.ConnDriver;
import ibase.utility.CommonConstants;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.ejb.dis.DistCommon;
import ibase.utility.E12GenericUtility;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.TransIDGenerator;
import ibase.webitm.utility.wms.CommonWmsUtil;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;

import org.w3c.dom.*;

@javax.ejb.Stateless
public class PalletizationConf extends ValidatorEJB implements PalletizationConfLocal, PalletizationConfRemote
{
	public String postSave()throws RemoteException,ITMException
	{
		return "";
	}
	public String postSave( String domString, String tranId, String editFlag, String xtraParams, Connection conn1 ) throws RemoteException, ITMException
	{
		NodeList parentNodeList = null;
		NodeList childNodeList = null;
		Node parentNode = null;
		Node childNode = null;
		//Connection conn1 = null;

		String errString = "", siteCode = "", palletNo = "", sql = "", objName = "", childNodeName = "", userId = "", errorType = "", errCode = "",
		tranIdDB = "";
		int ctr = 0, childNodeListLength = 0, cnt = 0, tranIdScanCount = 0, tranIdCount = 0;
		boolean isError = false;

		ArrayList <String> errList = new ArrayList<String>();
		ArrayList <String> errFields = new ArrayList <String> ();
		DistCommon distComm = new DistCommon();

		PreparedStatement pstmt = null;
		ResultSet rs = null; 

		StringBuffer errStringXml = new StringBuffer("<?xml version=\"1.0\"?>\r\n<Root><Errors>");
		try
		{
			System.out.println("::::::::::::::::: Inside postSave for palletization confirm :::::::::::::::: ");
			E12GenericUtility genericUtility = new E12GenericUtility();
			
			//commented by azhar[06-MAR-17][START]
			/*ConnDriver connDriver = new ConnDriver();
			conn1 = connDriver.getConnectDB("DriverITM");
			conn1.setAutoCommit(false);
			connDriver = null;*/
			//commented by azhar[06-MAR-17][END]

			Document dom = null;
			dom = genericUtility.parseString(domString);

			siteCode = checkNull(genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginSiteCode" ));	
			userId = getValueFromXTRA_PARAMS(xtraParams, "loginCode");	
			palletNo = checkNull(genericUtility.getColumnValue("pallet_no", dom, "3" ));
			objName = getObjNameFromDom( dom, "objName",  "1" );

			System.out.println("domString ::::::::::::: " + domString);
			System.out.println("xtraParams ::::::::::::: " + xtraParams);
			System.out.println("tranId----------->>["+tranId+"]");

			System.out.println("siteCode ::::::::::::: " + siteCode);
			System.out.println("userId ::::::::::::: " + userId);
			System.out.println("palletNo ::::::::::::: " + palletNo);
			System.out.println("objName ::::::::::::: " + objName);

			parentNodeList = dom.getElementsByTagName("Detail1");
			parentNode = parentNodeList.item(0);
			childNodeList = parentNode.getChildNodes();
			childNodeListLength = childNodeList.getLength();
			System.out.println("childNodeListLength----------->>["+childNodeListLength+"]");

			if("palletization".equalsIgnoreCase(objName))
			{
				if( tranId == null || tranId.trim().length() <= 0) // Add mode
				{
					System.out.println("tranId inside add mode ----------->>");

					sql = "select tran_id from  pallet_hdr where confirmed = ? and site_code = ? and pallet_no = ? ";						
					pstmt = conn1.prepareStatement(sql);
					pstmt.setString(1, "N");
					pstmt.setString(2, siteCode);
					pstmt.setString(3, palletNo);
					rs = pstmt.executeQuery();
					if(rs.next())
					{	
						tranIdDB = checkNullAndTrim(rs.getString("tran_id"));	
					}
					if(pstmt != null){pstmt.close();pstmt = null;}
					if(rs != null){rs.close();rs = null;}

					System.out.println("tranIdDB----------->>["+tranIdDB+"]");

					tranIdScanCount = getTranIdScanDet(tranIdDB, siteCode, conn1);
					if(tranIdScanCount <= 0)
					{
						System.out.println("No records scan for this transaction for palletization confirm ::::::::::  "); 
						errCode = "VTINVTID";		
						errList.add( errCode );
						errFields.add(childNodeName.toLowerCase());
					}
					else
					{
						System.out.println("Calling confirm for palletization confirm menu :::::::::::::::::::: "); 
						errString = confirm(tranIdDB, siteCode, conn1);
					}

				}
				else // edit mode
				{
					System.out.println("tranId in edit mode for palletization ----------->>["+tranId+"]");
					tranIdScanCount = getTranIdScanDet(tranId, siteCode, conn1);
					if(tranIdScanCount <= 0)
					{
						System.out.println("No records scan for this transaction for palletization confirm ::::::::::  "); 
						errCode = "VTINVTID";		
						errList.add( errCode );
						errFields.add(childNodeName.toLowerCase());
					}
					else
					{
						System.out.println("Calling confirm for palletization confirm menu :::::::::::::::::::: "); 
						errString = confirm(tranId, siteCode, conn1);
					}
				}
			}
			else // Palletization Confirm
			{

				for (ctr = 0; ctr < childNodeListLength; ctr++) 
				{					
					childNode = childNodeList.item(ctr);
					childNodeName = childNode.getNodeName();
					System.out.println("childNodeName ------->>["+childNodeName+"]");

					if("tran_id".equalsIgnoreCase(childNodeName))
					{

						tranIdScanCount = getTranIdScanDet(tranId, siteCode, conn1);
						tranIdCount = getTranId(tranId, siteCode, conn1);

						if(tranId.length() <= 0) 
						{
							System.out.println("Tran Id found blank :::::::::: "); 
							errCode = "VTTRANIDNL";		
							errList.add( errCode );
							errFields.add(childNodeName.toLowerCase());
						}
						else if(tranIdCount <= 0)
						{
							System.out.println("Transaction ID not found ::::::::::  "); 
							errCode = "VTINVTRID";		
							errList.add( errCode );
							errFields.add(childNodeName.toLowerCase());
						}
						else if(tranIdScanCount <= 0)
						{
							System.out.println("No records scan for this transaction for palletization confirm ::::::::::  "); 
							errCode = "VTINVTID";		
							errList.add( errCode );
							errFields.add(childNodeName.toLowerCase());
						}
						else
						{
							System.out.println("Calling confirm for palletization confirm menu :::::::::::::::::::: "); 
							errString = confirm(tranId, siteCode, conn1);
						}
					}
				}
			}


			int errListSize = errList.size();
			cnt =0;
			String errFldName = null;
			if ( errList != null && errListSize > 0 )
			{
				for (cnt = 0; cnt < errListSize; cnt++ )
				{
					errCode = errList.get(cnt);
					errFldName = errFields.get(cnt);
					System.out.println("errCode .........." + errCode);
					errString = getErrorString( errFldName, errCode, userId );
					errorType =  errorType( conn1, errCode );
					if ( errString.length() > 0)
					{
						String bifurErrString = errString.substring( errString.indexOf("<Errors>") + 8, errString.indexOf("<trace>"));
						bifurErrString =bifurErrString+errString.substring( errString.indexOf("</trace>") + 8, errString.indexOf("</Errors>"));
						errStringXml.append(bifurErrString);
						System.out.println("errStringXml .........."+errStringXml);
						errString = "";
					}
					if ( errorType.equalsIgnoreCase("E"))
					{
						break;
					}
				}
				errList.clear();
				errList = null;
				errFields.clear();
				errFields = null;
				errStringXml.append("</Errors></Root>\r\n");
			}
			else
			{
				if( tranId == null || tranId.trim().length() <= 0) 
				{
					return getError(tranIdDB, "VTTRANCONF", conn1);
				}
				else
				{
					return getError(tranId, "VTTRANCONF", conn1);
				}

			}	
			errString = errStringXml.toString();
		}
		catch(Exception e)
		{
			try
			{
				System.out.println("Exception "+e.getMessage());
				e.printStackTrace();			
				throw new ITMException(e);
			}
			catch (Exception e1)
			{
				isError = true;
				e1.printStackTrace();
				throw new ITMException(e1);
			}
		}
		finally
		{
			try
			{				
				if( !isError  )
				{
					System.out.println("commmit in PalletizationConf");
					//conn1.commit(); //commented by azhar[06-MAR-17]
				}
				else if ( isError )
				{
					System.out.println("rollback");
					conn1.rollback();
				}
				//commented by azhar[06-MAR-17][START]
				/*if (conn1 != null)
				{
					conn1.close();
					conn1 = null;
				}*/
				//commented by azhar[06-MAR-17][END]
			}
			catch(Exception e)
			{
				e.printStackTrace();
				throw new ITMException(e);
			}
		}
		return errString;
	}	

	private String checkNull( String input )	
	{
		if ( input == null )
		{
			input = "";
		}
		return input.trim();
	}

	private String checkNullAndTrim( String inputVal )
	{
		if ( inputVal == null )
		{
			inputVal = "";
		}
		else
		{
			inputVal = inputVal.trim();
		}
		return inputVal;
	}

	public String errorType( Connection conn , String errorCode )
	{
		String msgType = "";
		PreparedStatement pstmt = null ; 
		ResultSet rs = null;
		try
		{			
			String  sql = " select msg_type from messages where msg_no =  ? ";
			pstmt = conn.prepareStatement( sql );			
			pstmt.setString(1, errorCode);			
			rs = pstmt.executeQuery();
			while( rs.next() )
			{
				msgType = rs.getString("MSG_TYPE");
			}			
		}
		catch (Exception ex)
		{
			ex.printStackTrace();
		}		
		finally
		{
			try
			{
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch ( Exception e )
			{
				e.printStackTrace();
			}
		}		
		return msgType;
	}

	public int getTranId(String tranId, String siteCode, Connection conn1) throws Exception
	{
		PreparedStatement pstmt = null ;
		ResultSet rs = null ; 
		String sql = "";
		int count = 0;
		try
		{				
			sql = "select count(*) from  pallet_hdr where confirmed = ? and site_code = ? and tran_id = ? ";						
			pstmt = conn1.prepareStatement(sql);
			pstmt.setString(1, "N");
			pstmt.setString(2, siteCode);
			pstmt.setString(3, tranId);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				count = rs.getInt(1);	
			}
		}
		catch(Exception e)
		{
			System.out.println("Exception in getTranId ::::::::::: " + e);
			e.printStackTrace();
			throw new Exception(e);
		}
		finally
		{
			if(rs!=null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
		}
		System.out.println("Return List from getTranId ------>>" + count);		
		return count;
	}

	public int getTranIdScanDet(String tranId, String siteCode, Connection conn1) throws Exception
	{
		PreparedStatement pstmt = null ;
		ResultSet rs = null ; 
		String sql = "";
		int count = 0;
		try
		{				
			sql = "select count(det.tran_id) from pallet_det det, pallet_hdr hdr where hdr.confirmed = ? and hdr.site_code = ? and " 
				+" hdr.tran_id = det.tran_id and hdr.tran_id = ?  ";						
			pstmt = conn1.prepareStatement(sql);
			pstmt.setString(1, "N");
			pstmt.setString(2, siteCode);
			pstmt.setString(3, tranId);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				count = rs.getInt(1);	
			}
		}
		catch(Exception e)
		{
			System.out.println("Exception in getTranIdScanDet ::::::::::: " + e);
			e.printStackTrace();
			throw new Exception(e);
		}
		finally
		{
			if(rs!=null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
		}
		System.out.println("Return value form getTranIdScanDet ------>>" + count);		
		return count;
	}

	public String confirm( String tranId, String siteCode, Connection conn1 ) throws Exception
	{		
		String sql = "",  tranDate = "", invStat = "", qcType = "",errString = "", 
		expDate = "", mfgDate = "", palletStatus = "", qcReqd = "", procMth = "", lineNoInterface = "", familyGrp = "",
		stroPref = "",stroPrefF="",stroPrefM="",stroPrefS="",stroPrefR="";
		double holdQuantity = 0, quantityDB = 0, packSize = 0, interfaceQty = 0,  interfaceQtyRem = 0, totQuantity = 0, qtyPerArt = 0, noArt = 0;
		PreparedStatement pstmt = null, pstmt1 = null;		
		ResultSet rs = null, rs1 = null;
		boolean isError = false, isLocalConn = false;

		DistCommon distComm = new DistCommon();
		String nexpLoc = "", lockCode = "", expLoc = "";
		ArrayList  interfaceArrList = new ArrayList();
		if(conn1 == null){
		ConnDriver connDriver = new ConnDriver();
		//conn1 = connDriver.getConnectDB("DriverITM");
		conn1 = getConnection();	
		isLocalConn = true;
		}
		int interfaceQty1 = 0;
		//Changed By Jagruti Shinde on 4/1/2016 Request Id:W15JSUN001[Start]
		stroPrefF = distComm.getDisparams("999999", "AWMS_FAST_MOVING", conn1);
		stroPrefM = distComm.getDisparams("999999", "AWMS_MEDIUM_MOVING", conn1);
		stroPrefS = distComm.getDisparams("999999", "AWMS_SLOW_MOVING", conn1);
		//Changed By Jagruti Shinde on 4/1/2016 Request Id:W15JSUN001[End]
		Calendar cal = Calendar.getInstance();
		try
		{
			System.out.println("::::::::::::::::: Inside confirm for palletization confirm :::::::::::::::: ");
			System.out.println("tranId :::::::::::::::: " + tranId);
			System.out.println("siteCode :::::::::::::::: " + siteCode);

			CommonWmsUtil commonWmsUtility = CommonWmsUtil.getInstance();
			E12GenericUtility genericUtility = new E12GenericUtility();			
			//Date today = new Timestamp(System.currentTimeMillis()); //commented by azhar to avoid date with timestamp[13-APR-2017]
			
			//added by azhar to avoid date with timestamp[13-APR-2017][START]
			SimpleDateFormat dbf = new SimpleDateFormat(genericUtility.getDBDateFormat());
			Timestamp today = Timestamp.valueOf(dbf.format(cal.getTime()) + " 00:00:00.0");
			//added by azhar to avoid date with timestamp[13-APR-2017][END]
			
			sql = "update pallet_hdr set confirmed = ?, conf_date = ? where tran_id = ? ";
			pstmt = conn1.prepareStatement(sql);
			pstmt.setString(1, "Y");
			pstmt.setTimestamp(2, new Timestamp(System.currentTimeMillis()));
			pstmt.setString(3, tranId);
			pstmt.executeUpdate();	
			pstmt.close();
			pstmt = null;

			sql = "select det.item_code, det.lot_no, det.lot_sl, det.quantity, det.pallet_no, " 
				+ "hdr.inv_stat, det.site_code, det.loc_code, hdr.tran_date, det.line_no, i.descr, i.unit, i.item_type, " 
				+ "hdr.pallet_status, case qc_sample_type  when '1' then 'N' when '2' then 'F' else 'C' end as qc_sample_type  " 
				+ "from pallet_hdr hdr, pallet_det det, item i where hdr.tran_id = det.tran_id and det.tran_id = ? and i.item_code = det.item_code ";
			pstmt = conn1.prepareStatement(sql);
			pstmt.setString(1, tranId);
			rs = pstmt.executeQuery();
			while(rs.next())
			{
				System.out.println("qc_sample_type ::::::::::::: " + checkNullAndTrim(rs.getString("qc_sample_type")));


				sql = "select hold_qty, qty_per_art, no_art from stock where quantity > 0 and site_code = ?  and loc_code = ? and " 
					+ "item_code = ? and lot_no = ? and lot_sl = ? ";
				pstmt1 = conn1.prepareStatement(sql);
				pstmt1.setString(1, rs.getString("site_code"));
				pstmt1.setString(2, rs.getString("loc_code"));
				pstmt1.setString(3, rs.getString("item_code"));
				pstmt1.setString(4, rs.getString("lot_no"));
				pstmt1.setString(5, rs.getString("lot_sl"));
				rs1 = pstmt1.executeQuery();
				if (rs1.next())
				{
					holdQuantity = rs1.getDouble("hold_qty");
					qtyPerArt = rs1.getDouble("qty_per_art");
					noArt = rs1.getDouble("no_art");
				}
				if(pstmt1 != null){ pstmt1.close(); pstmt1 = null; }
				if(rs1 != null){ rs1.close(); rs1 = null; }

				System.out.println("holdQuantity ::::::::::::: " + holdQuantity);
				System.out.println("qtyPerArt ::::::::::::: " + qtyPerArt);
				System.out.println("noArt ::::::::::::: " + noArt);
				// InvStat
				if(holdQuantity > 0) 
				{
					//System.out.println("inside hold quantity greater than zero :::::::::::::::::: ");
					nexpLoc = distComm.getDisparams("999999","NEAR_EXP_LOCK",conn1);
					expLoc = distComm.getDisparams("999999","EXP_LOCK",conn1);

					sql = "select i.lock_code from inv_hold i, inv_hold_det d where i.tran_id = d.tran_id and i.site_code = d.site_code and " 
						+ "d.item_code = ? and d.site_code = ? and d.loc_code = ? and d.lot_no = ?  and d.lot_sl = ? and d.hold_status = ? ";
					pstmt1 = conn1.prepareStatement(sql);
					pstmt1.setString(1, rs.getString("item_code"));
					pstmt1.setString(2, rs.getString("site_code"));
					pstmt1.setString(3, rs.getString("loc_code"));
					pstmt1.setString(4, rs.getString("lot_no"));
					pstmt1.setString(5, rs.getString("lot_sl"));
					pstmt1.setString(6, "H");
					rs1 = pstmt1.executeQuery();
					if (rs1.next())
					{
						lockCode = checkNullAndTrim(rs1.getString("lock_code"));
					}
					if(pstmt1 != null){ pstmt1.close(); pstmt1 = null; }
					if(rs1 != null){ rs1.close(); rs1 = null; }

					System.out.println("lockCode ::::::::::::: " + lockCode);
					if(lockCode.equalsIgnoreCase(nexpLoc))
					{
						invStat = "N";
					}
					else if(lockCode.equalsIgnoreCase(expLoc))
					{
						invStat = "E";
					}
					else
					{
						invStat = "H";
					}
				}
				else
				{
					invStat = "A";
				}
				System.out.println("invStat final ::::::::::::: " + invStat);	
				/*
				// Quantity, no of Arts, Total Quantity
				HashMap hm1 = new HashMap();
				hm1 = commonWmsUtility.getItemVoumeMap(rs.getString("item_code"), rs.getString("lot_no"), conn1);
				packSize = (Double) hm1.get("PACK_SIZE"); 
				quantityDB = rs.getDouble("quantity");

				interfaceQty =  quantityDB / packSize;
				interfaceQtyRem =  quantityDB % packSize;
				interfaceQty1 = (int) interfaceQty;

				System.out.println("packSize ::::::::::::: " + packSize);	
				System.out.println("quantityDB ::::::::::::: " + quantityDB);
				System.out.println("interfaceQty ::::::::::::: " + interfaceQty);	
				System.out.println("interfaceQtyRem ::::::::::::: " + interfaceQtyRem);	
				System.out.println("interfaceQty1 ::::::::::::: " + interfaceQty1);	

				if(interfaceQtyRem > 0)
				{
					interfaceQty = 	interfaceQty1 + 1;
				}
				else
				{
					interfaceQty = interfaceQty1;
				}
				totQuantity = packSize * interfaceQty;

				System.out.println("Final Quantity for interface table ::::::::::::: " + interfaceQty);	
				System.out.println("totQuantity ::::::::::::: " + totQuantity);	
				 */
				// Expiry Date, Mfg Date
				sql = "select exp_date, mfg_date from stock where item_code = ? and site_code = ? and lot_no = ? and lot_sl = ? and loc_code = ?  ";
				pstmt1 = conn1.prepareStatement(sql);
				pstmt1.setString(1, rs.getString("item_code"));
				pstmt1.setString(2, rs.getString("site_code"));
				pstmt1.setString(3, rs.getString("lot_no"));
				pstmt1.setString(4, rs.getString("lot_sl"));
				pstmt1.setString(5, rs.getString("loc_code"));
				rs1 = pstmt1.executeQuery();
				if (rs1.next())
				{
					expDate = rs1.getString("exp_date");
					mfgDate = rs1.getString("mfg_date");
				}
				if(pstmt1 != null){ pstmt1.close(); pstmt1 = null; }
				if(rs1 != null){ rs1.close(); rs1 = null; }

				/*//Pallet Status
				if(interfaceQtyRem == 0)
				{
					palletStatus = "F";
				}
				else
				{
					palletStatus = "P";
				}
				System.out.println("palletStatus ::::::::::::: " + palletStatus);	*/
				/*
				// QC Type
				sql = "select qc_reqd from siteitem where item_code = ? and site_code = ?  ";
				pstmt1 = conn1.prepareStatement(sql);
				pstmt1.setString(1, rs.getString("item_code"));
				pstmt1.setString(2, rs.getString("site_code"));
				rs1 = pstmt1.executeQuery();
				if (rs1.next())
				{
					qcReqd = rs1.getString("qc_reqd");
				}
				if(pstmt1 != null){ pstmt1.close(); pstmt1 = null; }
                if(rs1 != null){ rs1.close(); rs1 = null; } */

				HashMap hm2 = new HashMap();
				hm2 = commonWmsUtility.getPalletizedAttributes(rs.getString("item_code"), siteCode, conn1);
				procMth = (String) hm2.get("PROC_MTH");

				familyGrp = (String) hm2.get("LOC_ZONE__PREF"); 
				stroPref = (String) hm2.get("ANALYSIS_CLASS");

				//Changed By Jagruti Shinde on 4/1/2016 Request Id:W15JSUN001[Start]
				if(stroPref.equalsIgnoreCase(stroPrefF))
				{
					System.out.println("stroPrefF :"+stroPrefF);
					stroPrefR = "F";
				}
				else if(stroPref.equalsIgnoreCase(stroPrefM))
				{
					System.out.println("stroPrefM :"+stroPrefM);
					stroPrefR = "M";
				}
				else if(stroPref.equalsIgnoreCase(stroPrefS))
				{
					System.out.println("stroPrefS :"+stroPrefS);
					stroPrefR = "S";
				}
				System.out.println("stroPref value inserted in AWMS :"+stroPrefR);
				// Changed By Jagruti Shinde on 4/1/2016 Request Id:W15JSUN001[End]

				/*
                if("".equalsIgnoreCase(procMth) && procMth.length() <= 0)
                {
                	qcType = "N";
                }
                else if(!"".equalsIgnoreCase(procMth) && "Y".equalsIgnoreCase(qcReqd))
                {
                	qcType = "F";
                }
                else
                {
                	qcType = "C";
                }
                System.out.println("qcReqd ::::::::::::: " + qcReqd);
                System.out.println("procMth ::::::::::::: " + procMth);
                System.out.println("qcType  ::::::::::::: " + qcType);
				 */
				/* lineNoInterface = "   " + rs.getString("line_no");
                lineNoInterface = lineNoInterface.substring( lineNoInterface.length()-3 );*/


				lineNoInterface = checkNullAndTrim(rs.getString("line_no"));

				HashMap hm = new HashMap();
				hm.put("TRAN_ID", "");
				hm.put("ITEM_CODE", checkNullAndTrim(rs.getString("item_code")));
				hm.put("DESCR", checkNullAndTrim(rs.getString("descr")));
				hm.put("UNIT", checkNullAndTrim(rs.getString("unit")));
				hm.put("ITEM_TYPE", checkNullAndTrim(rs.getString("item_type")));
				hm.put("FAMILY_GRP", familyGrp);
				//hm.put("FAMILY_GRP", "");
				hm.put("IN_OUT", "I");
				hm.put("REF_SER", "PZ");
				hm.put("REF_ID", tranId);
				//hm.put("TRAN_DATE", checkNullAndTrim(String.valueOf(rs.getTimestamp("TRAN_DATE"))));
				// Changed by Sneha on 17-11-2015
				hm.put("TRAN_DATE", checkNullAndTrim(String.valueOf(today)));
				//End by Sneha
				hm.put("LOT_NO", rs.getString("lot_no"));
				hm.put("LOT_SL", rs.getString("lot_sl"));
				hm.put("QUANTITY", checkNullAndTrim((String.valueOf(noArt)))); 
				hm.put("QTY_PER_ART",checkNullAndTrim((String.valueOf(qtyPerArt))));  
				hm.put("TOTAL_QTY", checkNullAndTrim(rs.getString("quantity")));
				/*
				hm.put("QUANTITY", checkNullAndTrim((String.valueOf(interfaceQty))));  
				hm.put("QTY_PER_ART", checkNullAndTrim((String.valueOf(packSize))));  
				hm.put("TOTAL_QTY", checkNullAndTrim((String.valueOf(totQuantity)))); 
				 */
				hm.put("EXP_DATE", checkNullAndTrim(expDate)); 
				hm.put("MFG_DATE", checkNullAndTrim(mfgDate)); 
				hm.put("PALLET_NO", checkNullAndTrim(rs.getString("pallet_no")));
				hm.put("PALLET_STATUS", checkNullAndTrim(rs.getString("pallet_status")));
				hm.put("MSG_STAT", "N");
				hm.put("LOCK_STAT", checkNullAndTrim(invStat));
				hm.put("ERR_COD", "");
				hm.put("ERR_DESC", "");
				hm.put("QC_TYPE", checkNullAndTrim(rs.getString("qc_sample_type")));
				hm.put("TRANS_DT_ACK", "");
				//hm.put("STRO_PREF", "");

				//Changed by Jagruti Shinde on 4/1/2016 Request Id:W15JSUN001[Start]
				//hm.put("STRO_PREF", stroPref);
				hm.put("STRO_PREF", stroPrefR);
				//Changed by Jagruti Shinde on 4/1/2016 Request Id:W15JSUN001[End]
				hm.put("LINE_NO", lineNoInterface);	

				interfaceArrList.add(hm);


			}
			errString = commonWmsUtility.updateAwmsInterface(interfaceArrList, siteCode, conn1);
			
			System.out.println("Inserted into interface2 table ::::::::::::: ");	

			if(pstmt != null){ pstmt.close(); pstmt = null; }
			if(rs != null){ rs.close(); rs = null; }
		}
		catch (SQLException ex)
		{	
			isError = true;		
			System.out.println("Exception ::" +sql+ ex.getMessage() + ":");
			ex.printStackTrace();
			errString = ex.getMessage();
			throw new ITMException(ex);
		}
		catch (Exception e)
		{	
			isError = true;
			System.out.println("Exception ::" + e.getMessage() + ":");
			e.printStackTrace();
			errString = e.getMessage();
			throw new ITMException(e);
		}
		finally
		{
			//commented by azhar[06-MAR-17][START]
			if(isLocalConn){
			if( !isError  )
			{
				System.out.println("commmit");
				conn1.commit();
				
			}
			else if ( isError )
			{
				System.out.println("rollback");
				conn1.rollback();
			}
			conn1.close();
			}
			//commented by azhar[06-MAR-17][END]
			if(rs!=null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}

		}
		return errString;
	}

	public  String getError(String tranId, String Code, Connection conn)  throws ITMException, Exception
	{
		String mainStr ="";

		try
		{
			String errString = "";
			errString =  new ITMDBAccessEJB().getErrorString("",Code,"","",conn);
			String begPart = errString.substring(0,errString.indexOf("<message>")+9);
			String endDesc = errString.substring(errString.indexOf("</description>"));
			mainStr= begPart+"Transaction confirmed."+"</message><description>";
			mainStr= mainStr+"Transaction confirmed for Transaction ID : ["+tranId+"]."+endDesc;
			System.out.println("mainStr:::::::::::::::::: "+mainStr);
			begPart = null;
		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		return mainStr;
	}

	private String getObjNameFromDom( Document dom, String attribute, String objContext ) throws RemoteException,ITMException
	{
		NodeList detailList = null;
		Node currDetail = null, reqDetail = null;
		String objName = "";
		int	detailListLength = 0;

		try
		{
			detailList = dom.getElementsByTagName("Detail"+objContext);
			detailListLength = detailList.getLength();			
			for (int ctr = 0; ctr < detailListLength; ctr++)
			{				
				currDetail = detailList.item(ctr);
				objName = currDetail.getAttributes().getNamedItem(attribute).getNodeValue();
			}			
		}
		catch ( Exception e )
		{
			throw new ITMException(e);
		}
		return objName;
	}
}


