package ibase.webitm.util.gst;

import java.io.IOException;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;

import ibase.webitm.bean.gst.SuppliesDetails;

public class SuppliesDetailsSerailizer extends JsonSerializer<SuppliesDetails> 
{
	@Override
	public void serialize(SuppliesDetails suppliesDetails, JsonGenerator json, SerializerProvider serializerProvider) throws IOException, JsonProcessingException 
	{
		if(suppliesDetails!= null)
		{
			json.writeStartObject();
			
			if(suppliesDetails.outwardSuppliesDetails != null)
			{
				json.writeFieldName("osup_det");
				json.writeStartObject();
				json.writeNumberField("txval", suppliesDetails.outwardSuppliesDetails.taxableAmount);
				json.writeNumberField("iamt", suppliesDetails.outwardSuppliesDetails.igstAmount);
				json.writeNumberField("camt", suppliesDetails.outwardSuppliesDetails.cgstAmount);
				json.writeNumberField("samt", suppliesDetails.outwardSuppliesDetails.sgstAmount);
				json.writeNumberField("csamt", suppliesDetails.outwardSuppliesDetails.cessAmount);
				json.writeEndObject();
			}
			if(suppliesDetails.outwardZeroRatedSupplies != null)
			{
				json.writeFieldName("osup_zero");
				json.writeStartObject();
				json.writeNumberField("txval", suppliesDetails.outwardZeroRatedSupplies.taxableAmount);
				json.writeNumberField("iamt", suppliesDetails.outwardZeroRatedSupplies.igstAmount);
				json.writeNumberField("csamt", suppliesDetails.outwardZeroRatedSupplies.cessAmount);
				json.writeEndObject();
			}
			if(suppliesDetails.outwardExempetedSupplies != null)
			{
				json.writeFieldName("osup_nil_exmp");
				json.writeStartObject();
				json.writeNumberField("txval", suppliesDetails.outwardExempetedSupplies.taxableAmount);
				json.writeEndObject();
			}
			if(suppliesDetails.inwardSuppliesUnderRevCharge != null)
			{
				json.writeFieldName("isup_rev");
				json.writeStartObject();
				json.writeNumberField("txval", suppliesDetails.inwardSuppliesUnderRevCharge.taxableAmount);
				json.writeNumberField("iamt", suppliesDetails.inwardSuppliesUnderRevCharge.igstAmount);
				json.writeNumberField("camt", suppliesDetails.inwardSuppliesUnderRevCharge.cgstAmount);
				json.writeNumberField("samt", suppliesDetails.inwardSuppliesUnderRevCharge.sgstAmount);
				json.writeNumberField("csamt", suppliesDetails.inwardSuppliesUnderRevCharge.cessAmount);
				json.writeEndObject();
			}
			if(suppliesDetails.outwardNonGSTSupplies != null)
			{
				json.writeFieldName("osup_nongst");
				json.writeStartObject();
				json.writeNumberField("txval", suppliesDetails.outwardNonGSTSupplies.taxableAmount);
				json.writeEndObject();
			}
			
			json.writeEndObject();
		}
	}
}


