/**
 * @author : Mahendra Jadhav 
 * @Request Id :F14ISUN011
 * Date : 02/02/15
 */
package ibase.webitm.ejb.fin.adv;

import ibase.system.config.AppConnectParm;
import ibase.system.config.ConnDriver;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.ActionHandlerEJB;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.ejb.MasterStatefulLocal;
import ibase.webitm.ejb.ValidatorEJB;
//import ibase.webitm.ejb.dis.DistCommon;
import ibase.webitm.ejb.fin.FinCommon;
import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.text.*;




import javax.ejb.Stateless;
import javax.naming.InitialContext;
@Stateless
public class GenReceiptConf extends ActionHandlerEJB implements GenReceiptConfLocal,GenReceiptConfRemote 
{
	
	E12GenericUtility e12GenericUtility = new E12GenericUtility();
	protected InitialContext ctx = null;
	
	
	public String confirm(String tranID,String xtraParams, String forcedFlag) throws RemoteException,ITMException
	{
		String retString = "";
		boolean isConn= false;
		Connection conn = null;
		
 
		try
		{
			retString = confirm( tranID, xtraParams, forcedFlag, conn );

			if ( retString != null && retString.length() > 0 )
			{
				throw new Exception("Exception while calling confirm for tran  Id:["+tranID+"]");
			}
		}
		catch(Exception exception)
		{
			System.out.println("Exception in [GenReceiptConf]: " + exception.getMessage());
		}
		return retString;
	}
	
	public String confirm(String tranId,String xtraParams,String forcedFlag, Connection conn) throws RemoteException,ITMException
	{
		System.out.println("confirm called.......");
		String sql = "",confirm="",siteCode="",errString="",userId="",tranSer = "",loginEmpCode="";
		String chgUser="",errStr="",returnString="";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		FinCommon finCommon = null;
		GenericUtility genericUtility = null;
		ITMDBAccessEJB itmDBAccessEJB = null;
		ValidatorEJB validatorEJB = null;
		boolean connStatus=false;
		
		int cnt=0;
		try
		{
			System.out.println("Confirm method() :tran id = "+tranId);
			if ( conn == null )
			{
				ConnDriver connDriver = null;
				connDriver = new ConnDriver();
				conn = connDriver.getConnectDB("DriverITM");
				conn.setAutoCommit(false);
				connDriver = null;
				connStatus = true;
			}
			finCommon = new FinCommon();
			genericUtility = new GenericUtility();
			itmDBAccessEJB = new ITMDBAccessEJB();
			validatorEJB = new ValidatorEJB();
			userId =validatorEJB.getValueFromXTRA_PARAMS(xtraParams, "loginEmpCode");
			System.out.println("userId:"+userId);
			
			

			sql = "select confirmed ,site_code,chg_user from RECEIPT_FORM where tran_id = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,tranId);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				confirm = rs.getString("confirmed") == null ?"N":rs.getString("confirmed");
				siteCode = rs.getString("site_code") == null ?" ":rs.getString("site_code");
				chgUser = rs.getString("chg_user") == null ?" ":rs.getString("chg_user");
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
			if(chgUser==null || chgUser.trim().length()==0)
			{
				chgUser="SYSTEM";
			}

			System.out.println("confirm  ::"+confirm);
			if(confirm != null  && confirm.equalsIgnoreCase("N"))
			{
				
				errString = generateReceipt(tranId,conn,xtraParams);
				System.out.println("err String from genReceiptConf ="+errString);
				
				if(errString.indexOf("Success") > -1)
				{
					
					
					sql="update receipt_form set confirmed='Y', conf_date = ? where tran_id= ?";
					pstmt = conn.prepareStatement( sql );	
					pstmt.setDate(1, new java.sql.Date(new java.util.Date().getTime()));
					pstmt.setString(2, tranId );
					cnt = pstmt.executeUpdate();					
					pstmt.close();
					pstmt = null;
					
					System.out.println("cnt==>"+cnt);
					if(cnt>0)
					{
						conn.commit();
						errStr = "VTCONFSUCC";
						System.out.println("CONFIRMED SUCESSFULLY!!!!!!!");
						returnString = itmDBAccessEJB.getErrorString("",errStr,userId);
						return returnString;
					}
					
				}
				else
				{
					return errString;
					
				}
				
				
								
		/*		if(errString == null || errString.trim().length() == 0)
				{
					if("null".equalsIgnoreCase(loginEmpCode) || ==null || loginEmpCode.trim().length()==0)
					{
						loginEmpCode="E03952";
					}
					System.out.println("loginEmpCode--3-"+loginEmpCode);
					sql = "update receipt set confirmed = 'Y', conf_date = ?,emp_code__aprv = ? where tran_id = ?";
					pstmt = conn.prepareStatement(sql);
					pstmt.setDate(1, new java.sql.Date(new java.util.Date().getTime()));
					pstmt.setString(2, loginEmpCode);
					pstmt.setString(3, tranId);
					int updateCoount = pstmt.executeUpdate();
					System.out.println("no of row update = "+updateCoount);
					pstmt.close();
					pstmt = null;
					if(updateCoount > 0)
					{
						errString = itmDBAccessEJB.getErrorString("","VTCICONF3","","",conn);
					}
				}
				else 
				{
					//errString = itmDBAccessEJB.getErrorString("","VTDESNCONF ","","",conn);
					return errString;
				}
		*/	
			}
			else
			{
				System.out.println("The Selected transaction is already confirmed");
				errString = itmDBAccessEJB.getErrorString("","VTMCONF1","","",conn);
				return errString;
			}
			System.out.println("115 err String from confirm method.....");
		} 
		catch( Exception e)
		{
			if(conn!=null)
			{
				try {
					conn.rollback();
				} catch (SQLException ex) {

					System.out.println("Exception : "+e);
					e.printStackTrace();
					throw new ITMException(e);

				}
			}
			System.out.println("Exception : "+e);
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			
				try
				{
					
					if(errString != null && errString.trim().length() > 0)
					{
						if( conn != null && !conn.isClosed() && connStatus ) 
						{
							if(errString.indexOf("VTCICONF3") > -1)
							{
								conn.commit();
							}
							else
							{
								conn.rollback();
							}
							conn.close();
							conn = null;
						}
					}
					if(rs != null)
					{
						rs.close();
						rs = null;
					}
					if(pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
					//conn.close();
				}
				catch(Exception e)
				{
					System.out.println("Exception : "+e);e.printStackTrace();
					throw new ITMException(e);
				}
			
		}
		return errString;
	} //end of confirm method
	
	
	
	
	public String generateReceipt(String tranId,Connection conn, String xtraParams) throws Exception ,ITMException
	{
		ITMDBAccessEJB itmDBAccessEJB = null;
		String errString ="",xmlString="",sql="",acctCode="",remarks="",finEntity="";
		String lineNoRef="",refNo="",refSer="";
		String custCode="",tranType="",rcpMode="",bankCode="",custbankRef="",currCode="",currCodeHD="";
		String acctCodeArHD="",cctrCodeArHD="",acctCodeAdvHD="",cctrCodeAdvHD="";
		String acctCodeBalHD="",cctrCodeBalHD="",acctCodeCfHD="",cctrCodeCfHD="",acctCodeCfArHD="",cctrCodeCfArHD="";
		StringBuffer xmlBuff = new StringBuffer();
		StringBuffer advBuff = new StringBuffer();
		PreparedStatement pstmt=null;
		PreparedStatement pstmt1=null;
		ResultSet rs =null;
		ResultSet rs1 =null;
		
		String tranDate =null;
		int lineNo=0;
		String siteCode="";		
		
		
		Date refDate=null,effDate=null;
		double rcpAmt =0.0,chqAmt=0.0;
		
		itmDBAccessEJB = new ITMDBAccessEJB();
		SimpleDateFormat sdf = new SimpleDateFormat(e12GenericUtility.getApplDateFormat());
		try
		{
			
			
			SimpleDateFormat  simpleDateFormat = new SimpleDateFormat(e12GenericUtility.getApplDateFormat());
			java.util.Calendar cal = java.util.Calendar.getInstance();
			tranDate = simpleDateFormat.format(cal.getTime());
			
			
            sql = "select CUST_CODE,TRAN_TYPE,RCP_MODE,BANK_CODE ,REF_NO,REF_DATE,SITE_CODE, " +
            		" EFF_DATE,CUST_BANK_REF,CHQ_AMT,REMARKS from RECEIPT_FORM where tran_id = ? ";
 
			
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, tranId);
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				custCode=rs.getString("CUST_CODE");
				tranType=rs.getString("TRAN_TYPE");
				rcpMode=rs.getString("RCP_MODE");
				bankCode=rs.getString("BANK_CODE");
				refNo=rs.getString("REF_NO");
				refDate=rs.getDate("REF_DATE");
				siteCode=rs.getString("SITE_CODE");
				effDate=rs.getDate("EFF_DATE");
				custbankRef=rs.getString("CUST_BANK_REF");
				chqAmt=rs.getDouble("CHQ_AMT");
				remarks=rs.getString("REMARKS");
			
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
			
			System.out.println("refDate :"+refDate);
			System.out.println("effDate :"+effDate);
			//System.out.println("refDate :"+refDate);
			
			custCode = custCode == null ? "" : custCode.trim();
			tranType = tranType == null ? "" : tranType.trim();
			rcpMode = rcpMode == null ? "" : rcpMode.trim();
			bankCode = bankCode == null ? "" : bankCode.trim();
			refNo = refNo == null ? "" : refNo.trim();
			siteCode = siteCode == null ? "" : siteCode.trim();
			custbankRef = custbankRef == null ? "" : custbankRef.trim();
			remarks = remarks == null ? "" : remarks.trim();
			/*refSer = refSer == null ? "" : refSer.trim();
			refSer = refSer == null ? "" : refSer.trim();
			refSer = refSer == null ? "" : refSer.trim();*/
			
			
			/*---------------------------------------------------------------------------------------*/
			
			/*sql = "select acct_code__ar, cctr_code__ar, curr_code, " +
					" acct_code__adv, cctr_code__adv from customer where cust_code = ? " ;
        	pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,custCode);
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				acctCodeArHD=rs.getString("acct_code__ar");
				cctrCodeArHD=rs.getString("cctr_code__ar");
				acctCodeAdvHD=rs.getString("acct_code__adv");
				cctrCodeAdvHD=rs.getString("cctr_code__adv");
				currCodeHD=rs.getString("curr_code");
				
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;*/
			
			
			
			
			/*sql = " select case when acct_code__bal is null then '' else acct_code__bal end,case " +
					" when cctr_code__bal is null then '' else cctr_code__bal   end,acct_code__cf, cctr_code__cf, " +
					" case when acct_code__cf_ar is null then '' " +
					" else acct_code__cf_ar end, case when cctr_code__cf_ar is null  then '' else cctr_code__cf_ar end " +
					" from bank where bank_code = ?" ;
        	pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,bankCode);
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				acctCodeBalHD=rs.getString(1);
				cctrCodeBalHD=rs.getString(2);
				acctCodeCfHD=rs.getString(3);
				cctrCodeCfHD=rs.getString(4);
				acctCodeCfArHD=rs.getString(5);
				cctrCodeCfArHD=rs.getString(6);
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;*/
			
			
			 /* sql = " select curr_code from bank where bank_code = ?" ;
	        	pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,bankCode);
				rs = pstmt.executeQuery();
				if (rs.next())
				{
					currCodeHD=rs.getString("curr_code");
				}
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;*/
			
				currCodeHD = currCodeHD == null ? "" : currCodeHD.trim();
				acctCodeArHD = acctCodeArHD == null ? "" : acctCodeArHD.trim();
				cctrCodeArHD = cctrCodeArHD == null ? "" : cctrCodeArHD.trim();
				acctCodeAdvHD = acctCodeAdvHD == null ? "" : acctCodeAdvHD.trim();
				cctrCodeAdvHD = cctrCodeAdvHD == null ? "" : cctrCodeAdvHD.trim();
				
				acctCodeBalHD = acctCodeBalHD == null ? "" : acctCodeBalHD.trim();
				cctrCodeBalHD = cctrCodeBalHD == null ? "" : cctrCodeBalHD.trim();
				acctCodeCfHD = acctCodeCfHD == null ? "" : acctCodeCfHD.trim();
				cctrCodeCfHD = cctrCodeCfHD == null ? "" : cctrCodeCfHD.trim();
				acctCodeCfArHD = acctCodeCfArHD == null ? "" : acctCodeCfArHD.trim();
				cctrCodeCfArHD = cctrCodeCfArHD == null ? "" : cctrCodeCfArHD.trim();
				
				System.out.println("currCodeHD :"+currCodeHD);
				System.out.println("acctCodeArHD :"+acctCodeArHD+"@cctrCodeArHD"+cctrCodeArHD);
				System.out.println("acctCodeAdvHD :"+acctCodeAdvHD+"@cctrCodeAdvHD"+cctrCodeAdvHD);
				
				System.out.println("acctCodeBalHD :"+acctCodeBalHD+"@cctrCodeBalHD"+cctrCodeBalHD);
				System.out.println("acctCodeCfHD :"+acctCodeCfHD+"@cctrCodeCfHD"+cctrCodeCfHD);
				System.out.println("acctCodeCfArHD :"+acctCodeCfArHD+"@cctrCodeCfArHD"+cctrCodeCfArHD);
				
				
				 sql = " select fin_entity from site where site_code=? " ;
		        	pstmt = conn.prepareStatement(sql);
					pstmt.setString(1,siteCode);
					rs = pstmt.executeQuery();
					if (rs.next())
					{
						finEntity=rs.getString("fin_entity");
					}
					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null;
				
					finEntity = finEntity == null ? "" : finEntity.trim();
			
			/*--------------------------------------------------------------------------------------*/
			
			
			
			

			xmlBuff.append("<?xml version='1.0' encoding='ISO-8859-1'?>\n");
			xmlBuff.append("<DocumentRoot>");
			xmlBuff.append("<description>").append("Datawindow Root").append("</description>");
			xmlBuff.append("<group0>");
			xmlBuff.append("<description>").append("Group0 description").append("</description>");
			xmlBuff.append("<Header0>");
			
			xmlBuff.append("<objName><![CDATA[").append("receipt_adv").append("]]></objName>");
			xmlBuff.append("<pageContext><![CDATA[").append("1").append("]]></pageContext>");
			xmlBuff.append("<objContext><![CDATA[").append("1").append("]]></objContext>");
			xmlBuff.append("<editFlag><![CDATA[").append("A").append("]]></editFlag>");
			xmlBuff.append("<focusedColumn><![CDATA[").append("").append("]]></focusedColumn>");
			xmlBuff.append("<action><![CDATA[").append("SAVE").append("]]></action>");
			xmlBuff.append("<elementName><![CDATA[").append("").append("]]></elementName>");
			xmlBuff.append("<keyValue><![CDATA[").append("1").append("]]></keyValue>");
			xmlBuff.append("<taxKeyValue><![CDATA[").append("	").append("]]></taxKeyValue>");
			xmlBuff.append("<saveLevel><![CDATA[").append("1").append("]]></saveLevel>");
			xmlBuff.append("<forcedSave><![CDATA[").append(true).append("]]></forcedSave>");
			xmlBuff.append("<taxInFocus><![CDATA[").append(false).append("]]></taxInFocus>");
			xmlBuff.append("<description>").append("Header0 members").append("</description>");
			//xmlBuff.append("<Detail1 objContext =\"1\"").append(" objName=\"receipt_adv\" domID=\"1\" dbID=\"\">");
			xmlBuff.append("<Detail1 objContext =\"1\"").append(" objName=\"receipt_adv\" domID=\"1\" dbID=\"\">");
			xmlBuff.append("<attribute selected=\"N\" updateFlag=\"A\" status=\"N\" pkNames=\"\"/>");
			xmlBuff.append("<tran_id/>");
			
			xmlBuff.append("<tran_date><![CDATA["+tranDate+"]]></tran_date>");
			xmlBuff.append("<cust_code><![CDATA["+custCode+"]]></cust_code>");
			xmlBuff.append("<tran_type><![CDATA["+tranType+"]]></tran_type>");
			xmlBuff.append("<rcp_mode><![CDATA["+rcpMode+"]]></rcp_mode>");
			xmlBuff.append("<bank_code><![CDATA["+bankCode+"]]></bank_code>");
			xmlBuff.append("<ref_no><![CDATA["+refNo+"]]></ref_no>");//cheque no
			if(refDate != null)
			{
				xmlBuff.append("<ref_date><![CDATA["+sdf.format(refDate)+"]]></ref_date>");	
			}
			else
			{
				xmlBuff.append("<ref_date><![CDATA[]]></ref_date>");
			}
			
			
		//	xmlBuff.append("<dlv_mode><![CDATA[]]></dlv_mode>");
		//	xmlBuff.append("<dlv_ref><![CDATA[]]></dlv_ref>");
		//	xmlBuff.append("<net_amt><![CDATA[]]></net_amt>");
		//	xmlBuff.append("<curr_code><![CDATA[]]></curr_code>");
		//	xmlBuff.append("<exch_rate><![CDATA[]]></exch_rate>");
		//	xmlBuff.append("<net_amt__bc><![CDATA[]]></net_amt__bc>");
		//	xmlBuff.append("<fin_entity><![CDATA[]]></fin_entity>");
			//xmlBuff.append("<acct_code__ar><![CDATA["+acctCodeArHD+"]]></acct_code__ar>");
		//	xmlBuff.append("<cctr_code__ar><![CDATA["+cctrCodeAdvHD+"]]></cctr_code__ar>");
		//	xmlBuff.append("<acct_code__bal><![CDATA["+acctCodeBalHD+"]]></acct_code__bal>");
		//	xmlBuff.append("<cctr_code__bal><![CDATA["+cctrCodeBalHD+"]]></cctr_code__bal>");
			xmlBuff.append("<site_code><![CDATA["+siteCode+"]]></site_code>");
			xmlBuff.append("<confirmed><![CDATA[]]></confirmed>");
			xmlBuff.append("<auto_recd><![CDATA[]]></auto_recd>");
			xmlBuff.append("<adv_amt><![CDATA[]]></adv_amt>");
			xmlBuff.append("<bill_amt><![CDATA[]]></bill_amt>");
		//	xmlBuff.append("<acct_code__cf><![CDATA["+acctCodeCfHD+"]]></acct_code__cf>");
		//	xmlBuff.append("<cctr_code__cf><![CDATA["+cctrCodeCfHD+"]]></cctr_code__cf>");
			if(effDate != null)
			{
				xmlBuff.append("<eff_date><![CDATA["+sdf.format(effDate)+"]]></eff_date>");
			}
			else
			{
				xmlBuff.append("<eff_date><![CDATA[]]></eff_date>");
			}
			
			xmlBuff.append("<diff_amt__exch><![CDATA[]]></diff_amt__exch>");
			xmlBuff.append("<sale_order><![CDATA[]]></sale_order>");
			xmlBuff.append("<cust_bank_ref><![CDATA[]]></cust_bank_ref>");
			xmlBuff.append("<entry_batch_no><![CDATA[]]></entry_batch_no>");
			//xmlBuff.append("<acct_code__adv><![CDATA["+acctCodeAdvHD+"]]></acct_code__adv>");
			//xmlBuff.append("<cctr_code__adv><![CDATA["+cctrCodeArHD+"]]></cctr_code__adv>");
			xmlBuff.append("<emp_code__aprv><![CDATA[]]></emp_code__aprv>");
			xmlBuff.append("<chq_amt><![CDATA["+chqAmt+"]]></chq_amt>");
			//xmlBuff.append("<fin_chg><![CDATA[]]></fin_chg>");
//			xmlBuff.append("<EFFECT_PARTY><![CDATA["+tranDate+"]]></tran_date>");
//			xmlBuff.append("<TRAN_ID__MRCP><![CDATA["+tranDate+"]]></tran_date>");
//			xmlBuff.append("<SITE_CODE__MRCP><![CDATA["+tranDate+"]]></tran_date>");
//			xmlBuff.append("<BILL_DISC_AMT><![CDATA["+tranDate+"]]></tran_date>");
//			xmlBuff.append("<EFUNDADJ_AMT><![CDATA["+tranDate+"]]></tran_date>");
//			xmlBuff.append("<OTH_AMT><![CDATA["+tranDate+"]]></tran_date>");
			xmlBuff.append("<advadj_amt><![CDATA[]]></advadj_amt>");
			xmlBuff.append("<fin_scheme><![CDATA[]]></fin_scheme>");
			xmlBuff.append("<item_ser><![CDATA[]]></item_ser>");
//			xmlBuff.append("<PARENT__TRAN_ID><![CDATA["+tranDate+"]]></tran_date>");
			xmlBuff.append("<rcp_type><![CDATA[]]></rcp_type>");
			//xmlBuff.append("<acct_code__cr><![CDATA[]]></acct_code__cr>");
		//	xmlBuff.append("<trf_status><![CDATA[]]></trf_status>");
		//	xmlBuff.append("<quantity__fc><![CDATA[]]></quantity__fc>");
			xmlBuff.append("<remarks><![CDATA["+remarks+"]]></remarks>");
			//xmlBuff.append("<curr_code><![CDATA["+currCodeHD+"]]></curr_code>");
			xmlBuff.append("<fin_entity><![CDATA["+finEntity+"]]></fin_entity>");
			xmlBuff.append("</Detail1>");
			
			

			//sql="select ref_ser,ref_no,line_no__ref from rcpdet_form where tran_id=?  and ADJ_OPT_FLG <> ? ";
			sql=" select ref_ser,ref_no,line_no__ref,rcp_amt from rcpdet_form where tran_id=? ";
			System.out.println("<!@#>Adding detail 2.......... sql "+sql);
			pstmt1=conn.prepareStatement(sql);
			pstmt1.setString(1,tranId);
			rs1=pstmt1.executeQuery();

			while(rs1.next()){

				    lineNo++;
				    System.out.println("lineNo is " + lineNo);
			
				    refSer=rs1.getString("ref_ser");
				    refNo=rs1.getString("ref_no");
				    lineNoRef=rs1.getString("line_no__ref");
				    rcpAmt=rs1.getDouble("rcp_amt");
				    
				    
				    refSer = refSer == null ? "" : refSer.trim();
				    refNo = refNo == null ? "" : refNo.trim();
				    lineNoRef = lineNoRef == null ? "" : lineNoRef.trim();
				    
				/*---------------------------------------------------------------------------------------*/    
				/*    sql ="select (tot_amt - adj_amt) as amt , tran_ser,tran_date,ref_no,ref_date,curr_code,exch_rate,acct_code,   " +
							" cctr_code,due_date,tax_amt,tot_amt,cust_code,adj_amt,   case when bad_debt_amt is null then 0 else bad_debt_amt end,discount_dt,DISCOUNT     from receivables  "
							+ "  where tran_ser = ? and ref_no = ?     and line_no__ref = ?  " ;
		 
					
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1,refSer);
					pstmt.setString(2,refNo);
					pstmt.setString(3,lineNoRef);
					rs = pstmt.executeQuery();
					if (rs.next())
					{
						currCode=rs.getString("curr_code");
						acctCode=rs.getString("acct_code");
					}
					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null;
					
					currCode = currCode == null ? "" : currCode.trim();
					acctCode = acctCode == null ? "" : acctCode.trim();*/
					
					
					System.out.println("acctCode !!!"+acctCode);
					
				/*---------------------------------------------------------------------------------------*/    
				    
					System.out.println("@@@@@@@@@@@@@@@Adding detail 2..........");
					//xmlBuff.append("<Detail2 objContext=\"2\" objName=\"receivables_jv\" domID=\"1\" dbID=''>");
					xmlBuff.append("<Detail2 objContext=\"2\" objName=\"receipt_adv\" domID=\"1\" dbID=''>");
					xmlBuff.append("<attribute selected=\"N\" updateFlag=\"A\" status=\"N\" pkNames=\"\"/>");
				
					xmlBuff.append("<tran_id/>");
					
					xmlBuff.append("<line_no><![CDATA["+lineNo+"]]></line_no>");
					xmlBuff.append("<line_no__ref><![CDATA["+lineNoRef+"]]></line_no__ref>");
					xmlBuff.append("<ref_ser><![CDATA["+refSer+"]]></ref_ser>");
					xmlBuff.append("<ref_no><![CDATA["+refNo+"]]></ref_no>");
					xmlBuff.append("<rcp_amt><![CDATA["+rcpAmt+"]]></rcp_amt>");
					//xmlBuff.append("<curr_code><![CDATA["+currCode+"]]></curr_code>");
					//xmlBuff.append("<acct_code__ar><![CDATA["+acctCode+"]]></acct_code__ar>");
					
					xmlBuff.append("</Detail2>");
				
			

			} 
			rs1.close();
			rs1=null;
			pstmt1.close();
			pstmt1=null;
			xmlBuff.append(advBuff.toString());
	

			xmlBuff.append("</Header0>");
			xmlBuff.append("</group0>");
			xmlBuff.append("</DocumentRoot>");
			xmlString = xmlBuff.toString();
			System.out.println("xmlString    " + xmlString);

			

			errString = saveData(siteCode,xmlString,conn);

			System.out.println("Passed xml in  master State full  errString   " + errString);


		} catch(Exception e)
		{
			conn.rollback();
			e.printStackTrace();
			throw new ITMException(e);
			
		}

		return errString;
	}


	private String saveData(String siteCode,String xmlString, Connection conn) throws ITMException
	{
		System.out.println("saving data...........");
		InitialContext ctx = null;
		String retString = null;
		MasterStatefulLocal masterStateful = null; // for ejb3
		try
		{
			AppConnectParm appConnect = new AppConnectParm();
			ctx = new InitialContext(appConnect.getProperty());
			masterStateful = (MasterStatefulLocal)ctx.lookup("ibase/MasterStatefulEJB/local");
			System.out.println("-----------masterStateful------- " + masterStateful);
			String [] authencate = new String[2];
			authencate[0] = "";
			authencate[1] = "";
			System.out.println("xmlString to masterstateful [" + xmlString + "]");
			retString = masterStateful.processRequest(authencate, siteCode, true, xmlString,true,conn);
		}
		catch(ITMException itme)
		{
			System.out.println("ITMException :CreateDistOrder :saveData :==>");
			throw itme;
		}
		catch(Exception e)
		{
			e.printStackTrace();
			System.out.println("Exception :CreateDistOrder :saveData :==>");
			throw new ITMException(e);
		}
		return retString;
	}	



}
