package ibase.webitm.ejb.dis;

import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.GenericUtility;
import ibase.system.config.ConnDriver;
import ibase.webitm.ejb.*;
import ibase.webitm.utility.*;
import ibase.system.config.AppConnectParm;
import javax.naming.InitialContext;
import java.sql.*;
import java.util.*;
import javax.ejb.*;

public class StockHelpBean
{
	String siteCode = "";
	String itemCode = "";
	public String locCode = "",lotNo = "",locSl = "",unit = "",dimention = "", mfgDate = "";
	public String quantity = "",allocQty = "",netAvailable = "",available = "", noArt = "", itemCodeStk = "";
	public String retestDate = "",expDate = "",potency = "",suppCodeMfg = "",batchNo = "", rate = "";
	public String packCode = "", invStat = "", holdQuant = "", qtyPerArt = "", batchSize = "";
	public String ppoQty = "", pindQty = "";	
	public HashMap beanLotQuantMap = new HashMap();
	public java.sql.Timestamp currDateTs = null;
	
	public void setSiteCode(String siteCodeJsp)
	{
		this.siteCode = siteCodeJsp;
	}
	public void setItemCode(String itemCodeJsp)
	{
		this.itemCode = itemCodeJsp;
	}
	
	public ArrayList getDetails() throws Exception
	{
		ArrayList stkHlpRetArr = new ArrayList();
		ArrayList thisBeanArray = new ArrayList();
		InitialContext ctx = null;
		StockHelp.StockDtlParams stkParms = null;
		StockHelpBean stkHlpBean = null;
		AppConnectParm appConnect = null;
		StockHelpLocal homeObj = null;
		StockHelpRemote stkHelpRemote = null;
		try
		{			
			appConnect = new AppConnectParm();
			ctx = new InitialContext(appConnect.getProperty());
			//homeObj = (StockHelpLocal)ctx.lookup("StockHelp");    for ejb2
			homeObj = (StockHelpLocal)ctx.lookup("ibase/StockHelp/local"); // for BaseInfo ejb3
			//stkHelpRemote = (StockHelpRemote)ctx.lookup(HelloEjb.class.getName());  // standard
			//stkHelpRemote = (StockHelpRemote)(homeObj.create());   //for ejb2
			stkHlpRetArr = homeObj.getDetails(this.siteCode,this.itemCode);
			if(stkHlpRetArr.size() > 0)
			{
				for (int i=0; i<stkHlpRetArr.size(); i++ )
				{
					stkParms = (StockHelp.StockDtlParams)(stkHlpRetArr.get(i));
					stkHlpBean = new StockHelpBean();
					stkHlpBean.itemCodeStk = stkParms.itemCode;
					stkHlpBean.locCode = stkParms.currLocCode;
					stkHlpBean.lotNo = stkParms.currLotNo;
					stkHlpBean.locSl = stkParms.currLotSl;
					stkHlpBean.mfgDate = stkParms.mfgDate;
					stkHlpBean.noArt = stkParms.noArt;
					stkHlpBean.rate = stkParms.rate;
					stkHlpBean.available = stkParms.available;
					stkHlpBean.unit = stkParms.unit;
					stkHlpBean.quantity = Double.toString(stkParms.quantity);
					stkHlpBean.allocQty = Double.toString(stkParms.allocQuant);
					stkHlpBean.holdQuant = Double.toString(stkParms.holdQuant);
					stkHlpBean.netAvailable = stkParms.netAvailable;
					stkHlpBean.retestDate = stkParms.retestDate;
					stkHlpBean.expDate = stkParms.expDate;					
					stkHlpBean.potency = stkParms.potencyPerc;
					stkHlpBean.suppCodeMfg = stkParms.suppCodeMfg;					
					stkHlpBean.batchNo = stkParms.batchNo;
					stkHlpBean.dimention = stkParms.dimention;
					stkHlpBean.packCode = stkParms.packCode;
					stkHlpBean.invStat = stkParms.invStat;
					stkHlpBean.beanLotQuantMap = stkParms.lotQuantMap;
					stkHlpBean.currDateTs = stkParms.currDateTs;
					stkHlpBean.qtyPerArt = stkParms.qtyPerArt;
					stkHlpBean.batchSize = stkParms.batchSize;
					stkHlpBean.ppoQty = stkParms.ppoQty;
					stkHlpBean.pindQty = stkParms.pindQty;
					thisBeanArray.add(stkHlpBean);
				}
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			appConnect = null;
			ctx = null;
			homeObj = null;
			stkHelpRemote = null;
			stkHlpRetArr = null;
			stkParms = null;
		}
		return thisBeanArray;
	}
}