package ibase.dashboard.sfa.servlet;

import ibase.dashboard.sfa.ejb.TaskTrackingRemote;
import ibase.system.config.AppConnectParm;
import ibase.webitm.utility.ITMException;
import java.io.IOException;
import java.io.OutputStream;
import javax.naming.InitialContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.simple.JSONObject;

public class TaskTrackingServlet extends HttpServlet
{
	private static final long serialVersionUID = 1L;

	
	
	public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException
	{
		doPost(request, response);
	}

	public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException
	{
		TaskTrackingRemote taskActivityRemote = null;
		InitialContext context = null;
		AppConnectParm appConnectParm = new AppConnectParm();
		String dataSourceName = "";
		String groupId = "";
		String userId = "";
		
		
		try
		{
			System.out.println("in  TaskActivityServlet  " );
			response.setContentType("application/xml");
			
			dataSourceName 	= request.getParameter("dataSourceName");
			groupId 		= request.getParameter("groupId");
			userId 			= request.getParameter("userId");
			
			
			System.out.println("in TaskTrackingServlet groupId :"+groupId+"----userId :"+userId);
			
			context = new InitialContext(appConnectParm.getProperty());
			taskActivityRemote = (TaskTrackingRemote) context.lookup("ibase/TaskTracking/remote");
			JSONObject jsonObjData = (JSONObject) taskActivityRemote.getTask( dataSourceName,groupId,userId);
			OutputStream outputStream = response.getOutputStream();
			outputStream.write(jsonObjData.toString().getBytes());
			outputStream.flush();
			outputStream.close();
			System.out.println("  in servlet Final data set for TaskTrackingServlet  build the Graph is===" + jsonObjData);
		} catch (Exception e)
		{
			System.out.println("Exception : TaskTrackingServlet :doPost(HttpServletRequest request, HttpServletResponse response) :" + e);
			try
			{
				throw new ITMException(e);
			} catch (ITMException e1)
			{
				e1.printStackTrace();
			}
		}
	}

}