/*
 * Copyright 2007 Robert Hanson <iamroberthanson AT gmail.com>
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *    http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.gwtwidgets.client.ui.canvas.impl;

import org.gwtwidgets.client.ui.canvas.Canvas;
import org.gwtwidgets.client.ui.canvas.Font;
import org.gwtwidgets.client.ui.canvas.FontLoadListener;

/**
 * Factory for Safari's canvas implementation. This is the simplest canvas implementation
 * as Safari exhibits no performance penalties for drawing images.
 * @author George Georgovassilis g.georgovassilis[at]gmail.com
 *
 */
public class SafariCanvasFactory extends CanvasFactory{
	
	public Canvas create(int width, int height){
		return new FFCanvasImpl(width, height);
	}

	public Font getFont(String bitmapPath, String descriptionPath, FontLoadListener listener) {
		return new BitmapFontImpl(bitmapPath, descriptionPath, listener);
	}

}
